#ifndef _MMICAMERATEST_H_
#define _MMICAMERATEST_H_

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		CameraTest
 $File:		       MmiCameraTest.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Texas Instruments France                                                       
 $Date:		    16/06/04                                                    
                                                                               
********************************************************************************
                                                                              
 Description:

    This module provides the Camera functionality.
                        
********************************************************************************
 $History: MmiCameraTest.h

	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154
 	Description:	Application to test camera
 	Solution:	Implemented the camera application with following functionalities
 			preview, snapshot and image saving.
	16/06/04   			
	   
 $End

*******************************************************************************/



/*******************************************************************************
                                                                              
                                Include files
                                                                              
*******************************************************************************/




/*******************************************************************************
                                                                              
                                Interface constants
                                                                              
*******************************************************************************/




/*******************************************************************************
                                                                              
                                Public methods
                                                                              
*******************************************************************************/

/* pretty standard initialise, execute and exit methods
*/
GLOBAL int mmi_camera_test_launch_view_finder (MfwMnu* m, MfwMnuItem* i);
T_MFW_HND mmi_camera_test_opt_create(T_MFW_HND parent);
GLOBAL int mmi_camera_test_set_quality (MfwMnu* m, MfwMnuItem* i);
GLOBAL int mmi_camera_test_set_color (MfwMnu* m, MfwMnuItem* i);
T_MFW_HND mmi_camera_test_opt_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr);
int M_exeQuality(MfwMnu* m, MfwMnuItem* i);
int M_exeColor(MfwMnu* m, MfwMnuItem* i);
static int M_exeZoom(MfwMnu* m, MfwMnuItem* i);
GLOBAL int mmi_camera_edit_filename(MfwMnu* m, MfwMnuItem* i);


/*******************************************************************************
                                                                              
                                End of File
                                                                              
*******************************************************************************/

#endif //_MMICAMERATEST_H_

