/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   CAMERATEST
 $File:       MmiCameraTest.c
 $Revision:   1.0
 $Author:   Texas Instruments France
 $Date:       25/06/04

********************************************************************************

 Description:

    This module provides the Camera functionality.

********************************************************************************
 $History: MmiCameraTest.c
 
 	Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
	Description: Locosto: MIgration to New LCD APIs
	Solution: Migrated to New APIs by replacing the old driver APIs with
	corresponding New LCD APIs

	Aug 22 2005, xpradipg - LOCOSTO-ENH-31154
 	Description:	Application to test camera
 	Solution:	Implemented the camera application with following functionalities
 			preview, snapshot and image saving.
 			
  25/06/04 Texas Instruments France original version

 $End

*******************************************************************************/




/*******************************************************************************

                                Include files

*******************************************************************************/
#define ENTITY_MFW
/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "prim.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "message.h" /* included for aci_cmh.h .... */
#include "aci_cmh.h" /* included for mfw_sat.h, included for MmiDummy.h, included for MmiMenu.h */

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_icn.h"	/* included for mfw_mnu.h */
#include "mfw_mnu.h"
#include "mfw_tim.h"
#include "mfw_kbd.h"
#include "mfw_sat.h" /* included for MmiDummy.h, included for MmiMenu.h */
#include "mfw_cm.h" 
#include "mfw_cam.h"
#include "MmiBlkLangDB.h"
#include "mmiColours.h"
#include "MmiDialogs.h"

#include "MmiDummy.h" /* included for MmiMenu.h */
#include "MmiLists.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
#include "AUIEditor.h"
#include "MmiMain.h"
#include "Mmiicons.h"
#include "MmiCameraTest.h"
#include "MmiWindow.h"
#include "MmiCall.h"

#include "r2d/r2d.h"

/*******************************************************************************

                                internal data

*******************************************************************************/
//Events for window
#define CT_INIT 0
#define CT_RETURN 1
#define CT_RESUME 2

//Events for editor
#define CT_EDITOR_CANCEL 2
#define CT_EDITOR_SELECT 3

//Dialog Screen timeout
#define CT_INFO_SCRN_TIMEOUT  1000
//Default Filename of the Jpeg file to be saved.
#define CT_DEFAULT_FILENAME "Snapshot"
#define CT_FILENAME_EDITOR_INPUT_LEN 45 

/*
 * Structures
 */

/*camera window structure*/
typedef struct{
	T_MMI_CONTROL	mmi_control;
	MfwHnd			win;
	MfwHnd			mfwwin;	
	T_MFW_HND			optwin;	
	T_MFW_HND			infowin;	
	MfwHnd			parent;
	MfwHnd          kbd;
	MfwIcnAttr      ct_bitmap;
	SHORT           id;
}	T_MMI_CT_Win_data;

typedef struct
{
    /* administrative data */

    T_MMI_CONTROL   mmi_control;
    T_MFW_HND       win;
    SHORT           id;
    T_MFW_HND       parent;
    /* associated handlers */
    T_MFW_HND       kbd;
    T_MFW_HND       kbd_long;
    T_MFW_HND       menu;

} T_MMI_CT_Opt_data;

/*editor data structure*/
typedef struct{
	T_MMI_CONTROL	mmi_control;
	MfwHnd			win;
	MfwHnd			ct_win_editor;
	UBYTE			ct_buffer[CT_FILE_NAME_LENGTH+1];
}	T_CT_Editor_Data;

//Camera Option Menu Items
static const MfwMnuItem Mmi_camera_OPTItems [] =
{
	{0,0,0,(char *)TxtQuality,0,(MenuFunc)M_exeQuality,item_flag_none},
	//{0,0,0,(char *)TxtColour,0,(MenuFunc)M_exeColor,item_flag_none},	
	//{0,0,0,(char *)TxtDigiZoom,0,(MenuFunc)M_exeZoom,item_flag_none},	
	{0,0,0,(char *)TxtFilename,0,(MenuFunc)mmi_camera_edit_filename,item_flag_none}	
};

//Camera Option menu Atrributes
static const MfwMnuAttr Mmi_camera_OPTAttrib =
{
    &SmsSend_R_OPTArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu       */
    -1,                                 /* use default font         */
    (MfwMnuItem*)Mmi_camera_OPTItems,                      /* with these items         */
    sizeof(Mmi_camera_OPTItems)/sizeof(MfwMnuItem), /* number of items     */
    COLOUR_LIST_SMS,	TxtNull, NULL, MNUATTRSPARE

};
//Variable to track the different Camera states.
extern UBYTE camera_state;
//Window Handler for Option window.
T_MFW_HND optwin;
//Variable to track active Call 
extern T_call call_data;
//Default filename for captured image
char new_filename[CT_FILE_NAME_LENGTH] = CT_DEFAULT_FILENAME;
UBYTE IsCamInit = FALSE; //Variable to initialise Camil only once.
T_MFW_HND digwin1 = NULL; //Window handler for Info Dialog.
/*******************************************************************************

                                Local prototypes

*******************************************************************************/
int mmi_camera_test_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
T_MFW_HND mmi_camera_test_win_create(T_MFW_HND parent);
static int mmi_camera_test_opt_kbd_cb (MfwEvt e, MfwKbd *k);
static int mmi_camera_test_opt_mnu_cb (MfwEvt e, MfwMnu *m);
void mmi_camera_test_opt_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
int mmi_camera_test_opt_win_cb (MfwEvt evt, MfwHnd win);
static int mmi_camera_test_kbd_cntrl (MfwEvt e, MfwKbd *k);
static void mmi_camera_test_opt_destroy(MfwHnd own_window);
void mmi_camera_test_update_softkeys (int lsk, int rsk);
T_MFW_HND mmi_camera_editor_create(T_MFW_HND parent);

/*******************************************************************************

 $Function:     mmi_camera_test_show_info

 $Description: 	Displays the dialog box

 $Returns: 		Dialog window

 $Arguments:		parent -parent window for dialog
 				str1- String to be displayed in dialog
 				str2 -String to be displayed in dialog
 				callback- Callback function

*******************************************************************************/
static MfwHnd mmi_camera_test_show_info(T_MFW_HND parent, int str1, int str2, T_VOID_FUNC callback)
{
	T_DISPLAY_DATA display_info;
	T_MFW_HND win;

      TRACE_EVENT ("mmi_camera_test_show_info()");

	/*
	** Create a timed dialog to display the Message .
	*/
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, str1, str2, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, callback, THREE_SECS, KEY_LEFT | KEY_CLEAR | KEY_HUP/*0*/);

	win = info_dialog(parent, &display_info);
	dspl_Enable(1);
	return win;
}

/*******************************************************************************

 $Function:    		 mmi_camera_test_show_saving_info

 $Description: 	Displays the Saving dialog box

 $Returns: 		Dialog window

 $Arguments:		parent -parent window for dialog
 				callback- Callback function

*******************************************************************************/

static MfwHnd mmi_camera_test_show_saving_info(T_MFW_HND parent, T_VOID_FUNC callback)
{
	T_DISPLAY_DATA display_info;
	T_MFW_HND win;
      TRACE_EVENT ("mmi_camera_test_show_saving_info()");

	dspl_Clear(0,0,SCREEN_SIZE_X-1,SCREEN_SIZE_Y-1 );
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtSnapSaving,TxtNull, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, callback, FOREVER, KEY_LEFT | KEY_CLEAR | KEY_HUP/*0*/);
	win = info_dialog(parent, &display_info);
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_ENABLE);
	dspl_Enable(1);
	return win;
}
/*******************************************************************************

 $Function:		mmi_camera_test_win_cntrl

 $Description:		This is the dialog control function for the Camera Window. It
 				receives the signals from the MFW and determines what action, if any, to take.

 $Returns:		None

 $Arguments:		win :		The pointer to the window handler, so the function can reference the
							dynamic user data, if any.
 				event :		The incoming event
 				value :		Generic incoming Parameter, it will be 'event' dependant
 				parameter :	Generic incoming Parameter, it will be 'event' dependant

*******************************************************************************/
int mmi_camera_test_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
	T_MFW_WIN			* win_data = ((T_MFW_HDR *) win)->data;
	T_MMI_CT_Win_data * data = (T_MMI_CT_Win_data *)win_data->user;

	TRACE_EVENT ("mmi_camera_test_exec_cb()");
	switch (event)
	{
	case CT_INIT:
		TRACE_EVENT(">> mmi_camera_test_exec_cb(), CT_INIT ");
		 camera_state = CAMERA_STATE_VIEWFINDER;
		 //Create keyboard handler
        	data->kbd = kbd_create (data->win,KEY_ALL,(T_MFW_CB)mmi_camera_test_kbd_cntrl);
		winShow(data->win);
		break;

	case CT_RESUME:
		break;

	case CT_RETURN:
		TRACE_EVENT(">> mmi_camera_test_exec_cb(), CT_RETURN ");
		winShow(data->win);
	  break;
	default:
		TRACE_EVENT(">> mmi_camera_test_exec_cb(), default ");
	   
	}
	 return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:     mmi_camera_dialog_cb

 $Description: Callback for Dialog 

 $Returns:None

 $Arguments: 		win  - Window Handler
 				identifier - Identifier
 				reason 	-

*******************************************************************************/
void mmi_camera_dialog_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
  TRACE_FUNCTION ("mmi_camera_dialog_cb()");

      switch (reason)
      {
        case INFO_TIMEOUT:
          /* no break; */
        case INFO_KCD_HUP:
          /* no break; */
        case INFO_KCD_LEFT:
          /* no break; */
        case INFO_KCD_RIGHT:
          /* no break; */
        case INFO_KCD_CLEAR:
		if( digwin1)
			dialog_info_destroy(digwin1);
		digwin1 = NULL;
		mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
		rvf_delay(40);
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
		dspl_control(DSPL_ACCESS_DISABLE);
            	mfw_cam_set_viewfinder_mode();
		break;
      }
}

/*******************************************************************************

 $Function:     mmi_camera_saving_info_cb

 $Description: Callback for Dialog 

 $Returns:None

 $Arguments: 		win  - Window Handler
 				identifier - Identifier
 				reason 	-

*******************************************************************************/
void mmi_camera_saving_info_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
}

/*******************************************************************************

 $Function:		mmi_camera_test_kbd_cntrl

 $Description:		Keyboard event handler for camera window

 $Returns:		status int

 $Arguments:		e		- window handle event
 				k		- keyboard control block
*******************************************************************************/
static int mmi_camera_test_kbd_cntrl (MfwEvt e, MfwKbd *k)
{
	T_MFW_HND	win  = mfwParent(mfw_header());
	T_MFW_WIN			* win_data = ((T_MFW_HDR *) win)->data;
	T_MMI_CT_Win_data * data = (T_MMI_CT_Win_data *)win_data->user;
    
    TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()");
	switch (k->code)
	{

		case KCD_LEFT:

			 TRACE_EVENT  ("mmi_camera_test_kbd_cntrl() KCD_LEFT");
			switch (camera_state)
		    	{
				case CAMERA_STATE_SNAPSHOT:
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-CAMERA_STATE_SNAPSHOT");
	       	    		//call MFW function to save snapshot
					camera_state = CAMERA_STATE_SAVE;
	       	    		if(mfw_cam_save_snapshot() == MFW_CAM_FAILED)	
					{
							//Display the error message
							mmi_camera_test_show_info(win, TxtFailed, TxtNull, (T_VOID_FUNC)mmi_camera_dialog_cb);	
							break;
					}
					//Display the Saving Dialog box	
					digwin1 = mmi_camera_test_show_saving_info(win,(T_VOID_FUNC)mmi_camera_saving_info_cb);				
					
				break;

				case CAMERA_STATE_VIEWFINDER:
				TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-CAMERA_STATE_VIEWFINDER");
			    		if(data)
			    		{
						//Disable sensor and display the Options window.
						mfw_cam_disable_sensor();
						rvf_delay(40); 		//Since MMI is not waiting the callback of disable camera, a delay is given.
					//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
					//replaced the flag with the function call, to migrate to the new Lcd APIs
						dspl_control(DSPL_ACCESS_ENABLE);
						camera_state = CAMERA_STATE_CONFIGURE;
						mmi_camera_test_opt_start(data->win,(MfwMnuAttr*)&Mmi_camera_OPTAttrib);
					}
					break;

				case CAMERA_STATE_SAVE:
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-CAMERA_STATE_SAVE");
					mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
					mfw_cam_set_viewfinder_mode();
					break;
			   }
     	       break;
		case KCD_MNUSELECT:
			switch (camera_state)
			{
				case CAMERA_STATE_VIEWFINDER:
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-CAMERA_STATE_SNAPSHOT");
					camera_state = CAMERA_STATE_SNAPSHOT;
					//Take the Snapshot 
					mfw_cam_take_snapshot();
					//Display the softkeys for Snapshot
					mmi_camera_test_update_softkeys(TxtSoftSnapSave,TxtSoftBack);
					rvf_delay(40);
				//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
				//replaced the flag with the function call, to migrate to the new Lcd APIs
					dspl_control(DSPL_ACCESS_DISABLE);
					break;
		    }
		   break;
		case KCD_RIGHT:
		case KCD_HUP:
            	    TRACE_EVENT  ("mmi_camera_test_kbd_cntrl() Back");
			switch (camera_state)
		   	 {
				case CAMERA_STATE_SNAPSHOT:					
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-mfw_cam_set_viewfinder_mode snapshot");
					camera_state = CAMERA_STATE_VIEWFINDER;
					//Goback to the Viewfinder Mode
					mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
					rvf_delay(40);
					mfw_cam_set_viewfinder_mode();
					break;

				case CAMERA_STATE_SAVE:
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-mfw_cam_set_viewfinder_mode save");
					camera_state = CAMERA_STATE_VIEWFINDER;
					//Goback to the Viewfinder Mode
					mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
					mfw_cam_set_viewfinder_mode();
				break;

				case CAMERA_STATE_VIEWFINDER:	
					TRACE_EVENT  ("mmi_camera_test_kbd_cntrl()-CAMERA_STATE_VIEWFINDER");
					//Disable the Camera and goto the Application Menu
					mfw_cam_disable_sensor();
					rvf_delay(100);
					camera_state = CAMERA_STATE_IDLE;
				//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
				//replaced the flag with the function call, to migrate to the new Lcd APIs
					dspl_control(DSPL_ACCESS_ENABLE);
					if(data->win != NULL)
					{
					      winDelete (data->win);
		       	          	mfwFree((void *)data, sizeof (T_MMI_CT_Win_data));
					}
				break;

		    }
	      break;

		default:
			
			break;
	}
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:		mmi_camera_test_win_cb

 $Description:		This function is the windows callback function for the mmi camera Root window.
 				It has no display.

 $Returns:		MFW_EVENT_CONSUMED 

 $Arguments:		event		- window handle event
 				win			- Camera window

*******************************************************************************/
int mmi_camera_test_win_cb (MfwEvt evt, MfwHnd win)
{
	T_MFW_WIN	*win_data = ((T_MFW_HDR *)win)->data;
	T_MMI_CT_Win_data	*data = (T_MMI_CT_Win_data *)win_data->user;

	TRACE_EVENT("mmi_camera_test_win_cb()");
	switch (evt)
	{
	case MfwWinVisible:  /* window is visible  */	    

		TRACE_EVENT("mmi_camera_test_win_cb()---MfwWinVisible");
       	if(camera_state == CAMERA_STATE_IDLE || camera_state == CAMERA_STATE_VIEWFINDER )
               	{
         
				mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
				rvf_delay(40);
				mfw_cam_launch_viewfinder_dma();
               	}
		break;

	// Post the SUSPEND event
	case MfwWinSuspend:  /* window is suspended  */

		TRACE_EVENT("mmi_camera_test_win_cb()-suspend");
		break;

	// Post the RESUME event
	case MfwWinResume: 	/* window is resumed */
		TRACE_EVENT("mmi_camera_test_win_cb()-resume");
		camera_state = CAMERA_STATE_VIEWFINDER;
		break;

	case MfwWinFocussed: /* input focus / selected   */	
		TRACE_EVENT("mmi_camera_test_win_cb()-MfwWinFocussed");
	case MfwWinDelete:   /* window will be deleted   */        
			default:
	return MFW_EVENT_REJECTED;
	}
	return MFW_EVENT_CONSUMED;
}



/*******************************************************************************

 $Function:		mmi_camera_test_win_create

 $Description:		This function performs the necessary steps to create the a window to handle the
 				viewfinder related softkeys and the viewfinder bitmaps. It will be removed, 
 				or rather remove itself on returning the data to the Mfw.

 $Returns:		T_MFW_HND : Window Handle to the New Window, Null if failed.

 $Arguments:		parent : pointer to the parent window.
 
*******************************************************************************/
T_MFW_HND mmi_camera_test_win_create(T_MFW_HND parent)
{
	T_MMI_CT_Win_data *data;
	T_MFW_WIN * win;

    TRACE_EVENT ("mmi_camera_test_win_create()");

	data = (T_MMI_CT_Win_data *)mfwAlloc((U16)sizeof(T_MMI_CT_Win_data));

	data->win = winCreate(parent, 0, E_WIN_VISIBLE|MfwWinSuspend|MfwWinResume, mmi_camera_test_win_cb);

	if (data->win == NULL)
		{
	    	/*
	    	** Failed to start : Free Memory, and exit
		    */
	    	mfwFree((U8 *)data, (U16)sizeof(T_MMI_CT_Win_data));
		data = NULL;
	    	return data;
		}
    	else
		{
	
       	    /*
	    	** Setup the Dialog control functions
		    */
		data->mmi_control.dialog = (T_DIALOG_FUNC)mmi_camera_test_exec_cb;
		    data->mmi_control.data = data;
		    win = ((T_MFW_HDR *)data->win)->data;
	    	win->user = (void *)data;
		    //initialize bitmap data
	        data->ct_bitmap.area.px 	= 	0;
		    data->ct_bitmap.area.py 	= 	0;
	    	data->ct_bitmap.area.sx 	=   175;
		    data->ct_bitmap.area.sy 	=   220;
	        data->ct_bitmap.icnType = BMP_FORMAT_16BIT_LCD_COLOUR;
		    data->ct_bitmap.iconCol = COLOUR_ICON_XX;		 
                 scrDrawFilledRect ( data->ct_bitmap.area.px, data->ct_bitmap.area.py, data->ct_bitmap.area.sx, data->ct_bitmap.area.sy, dspl_GetBgdColour() );
	    //define softkeys
	    displaySoftKeys(TxtSoftOptions,TxtSoftBack);
          dspl_Enable(1);
	  if(IsCamInit == FALSE)
		{
			TRACE_EVENT("Initialising Camil");
			 mfw_cam_init();
			 IsCamInit = TRUE;
		}
		}
	
	return data->win;

}

/*******************************************************************************

 $Function:     mmi_camera_test_start

 $Description:  create a new camera dialog
 				
 $Returns:    Dialogue info win

 $Arguments:  parent win, display info

*******************************************************************************/
T_MFW_HND mmi_camera_test_start (T_MFW_HND  parent_win)
{
  T_MFW_HND win;
	TRACE_FUNCTION("mmi_camera_test_start()");
	
    win = mmi_camera_test_win_create(parent_win);
   if (win NEQ NULL)
        {
	    SEND_EVENT (win, CT_INIT, NULL, NULL);
	}

   return win;
}

/*******************************************************************************

 $Function:     mmi_camera_test_launch_view_finder

 $Description:  	Create the window which is going to have
 				 the viewfinder bitmaps displayed on top of it.

 $Returns:		Always returns MFW_EVENT_CONSUMED (1)

 $Arguments:		m : pointer to the mnu data for the menu which caused this function to be called.
 				i   : pointer to the item data from the menu.

*******************************************************************************/
GLOBAL int  mmi_camera_test_launch_view_finder (MfwMnu* m, MfwMnuItem* i)
			{

   T_MFW_HND win = mfw_parent(mfw_header());

   TRACE_EVENT("mmi_camera_test_launch_view_finder()");
   mmi_camera_test_start(win);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	mmi_camera_test_opt_start

 $Description:		called when the user press  the Option menu in Camera Window
 				
 $Returns:		T_MFW_HND : Window Handle to the New Window, Null if failed.

 $Arguments:	parent_window -parent window handle
 				menuAttr - Menu attributes.

*******************************************************************************/

T_MFW_HND mmi_camera_test_opt_start(T_MFW_HND parent_window, MfwMnuAttr *menuAttr)
{
    T_MFW_HND win;

    TRACE_FUNCTION ("mmi_camera_test_opt_start()");

    optwin = (T_MFW_HND)mmi_camera_test_opt_create (parent_window);

    if (optwin NEQ NULL)
        {
	    SEND_EVENT (optwin, CT_INIT, NULL, (void *)menuAttr);
	}
    return win;
	}

/*******************************************************************************

 $Function:		mmi_camera_test_opt_win_create

 $Description:		This function performs the necessary steps to create the a window .

 $Returns:		T_MFW_HND : Window Handle to the New Window, Null if failed.

 $Arguments:		parent : pointer to the parent window.

*******************************************************************************/
T_MFW_HND mmi_camera_test_opt_create(T_MFW_HND parent)
		{
	 T_MMI_CT_Opt_data      * data = (T_MMI_CT_Opt_data *)ALLOC_MEMORY (sizeof (T_MMI_CT_Opt_data));
    T_MFW_WIN  * win;

    TRACE_FUNCTION ("mmi_camera_test_opt_create()");

	    	/*
     * Create window handler
		    */

    data->win = 
	win_create (parent, 0, E_WIN_VISIBLE, (T_MFW_CB)mmi_camera_test_opt_win_cb);
    if (data->win EQ NULL)
				{
	    return NULL;
	}
       	    /*
     * connect the dialog data to the MFW-window
		    */

    data->mmi_control.dialog = (T_DIALOG_FUNC)mmi_camera_test_opt_exec_cb;
		    data->mmi_control.data = data;
		    win = ((T_MFW_HDR *)data->win)->data;
	    	win->user = (void *)data;
    data->parent             = parent;

		    /*
     * return window handle
		    */
	
    return data->win;
	}

/*******************************************************************************

 $Function:		mmi_camera_test_opt_win_cb

 $Description:		This function is the windows callback function for the mmi camera option window.

 $Returns:		MFW_EVENT_CONSUMED 

 $Arguments:		event		- window handle event
 				win			- Camera window

*******************************************************************************/
int mmi_camera_test_opt_win_cb (MfwEvt evt, MfwHnd win)
{
   TRACE_EVENT("mmi_camera_test_opt_win_cb()");
    switch (evt)
				{
        case MfwWinVisible:  /* window is visible  */
	    displaySoftKeys(TxtSoftSelect,TxtSoftBack);
	    break;
	case MfwWinFocussed: /* input focus / selected   */
	case MfwWinDelete:   /* window will be deleted   */
        default:
	    return MFW_EVENT_REJECTED;
				}
    return MFW_EVENT_CONSUMED;

		    }

/*******************************************************************************

 $Function:		mmi_camera_test_opt_exec_cb

 $Description:		This is the dialog control function for the Camera Option Window. It
 				receives the signals from the MFW and determines what action, if any, to take.

 $Returns:		None

 $Arguments:		win :		The pointer to the window handler, so the function can reference the
							dynamic user data, if any.
 				event :		The incoming event
 				value :		Generic incoming Parameter, it will be 'event' dependant
 				parameter :	Generic incoming Parameter, it will be 'event' dependant

*******************************************************************************/
void mmi_camera_test_opt_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
    T_MFW_WIN        * win_data = ((T_MFW_HDR *) win)->data;
    T_MMI_CT_Opt_data  * data     = (T_MMI_CT_Opt_data *)win_data->user;
     TRACE_FUNCTION ("mmi_camera_test_opt_exec_cb()");
    switch (event)
			   {
	case CT_INIT:
		TRACE_EVENT(">> mmi_camera_test_opt_exec_cb(), CT_INIT ");
		/* initialization of administrative data */
		data->id = value;

			data->kbd =      kbdCreate(data->win,KEY_ALL,         (MfwCb)mmi_camera_test_opt_kbd_cb);
			data->kbd_long = kbdCreate(data->win,KEY_ALL|KEY_LONG,(MfwCb)mmi_camera_test_opt_kbd_cb);
			data->menu =     mnuCreate(data->win,(MfwMnuAttr *)&Mmi_camera_OPTAttrib, E_MNU_ESCAPE, (MfwCb)mmi_camera_test_opt_mnu_cb);
			mnuLang(data->menu,mainMmiLng);

			/* put the (new) dialog window on top of the window stack */
			mnuUnhide(data->menu);
			winShow(data->win);
			break;

	case CT_RETURN:
		TRACE_EVENT(">> mmi_camera_test_opt_exec_cb(), CT_RETURN ");
		mmi_camera_test_opt_destroy(optwin);
		mmi_camera_test_update_softkeys(TxtSoftOptions,TxtSoftBack);
 		mfw_cam_launch_viewfinder_dma();
	      break;

		default:
	    return;
	}
}

/*******************************************************************************

 $Function:    	mmi_camera_test_opt_kbd_cb

 $Description:		Keyboard event handler for camera  Option window

 $Returns:		execution status

 $Arguments:	e - event id
 				k - keyboard info
*******************************************************************************/
 
static int mmi_camera_test_opt_kbd_cb (MfwEvt e, MfwKbd *k)
 {
    T_MFW_HND    win  = mfwParent(mfw_header());
    T_MFW_WIN  * win_data = ((T_MFW_HDR *)win)->data;
    T_MMI_CT_Opt_data      * data = (T_MMI_CT_Opt_data *)win_data->user;

    TRACE_FUNCTION ("mmi_camera_test_opt_kbd_cb()");

    if (e & KEY_LONG)
	{
	    switch (k->code)
		{
		case KCD_HUP: /* back to previous menu */
		    mnuEscape(data->menu);
		    break;
		case KCD_RIGHT: /* Power Down */
		    return MFW_EVENT_REJECTED; /* handled by idle */
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
    else
	{
	switch (k->code)
	{
		case KCD_MNUUP: /* highlight previous entry */
		    mnuUp(data->menu);
		    break;
		case KCD_MNUDOWN: /* highlight next entry */
		    mnuDown(data->menu);
		    break;
		case KCD_MNUSELECT:
		case KCD_LEFT: /* activate this entry */
		    mnuSelect(data->menu);
		    break;
		case KCD_HUP: /* back to previous menu */
		case KCD_RIGHT: /* back to previous menu */
		    mnuEscape(data->menu);
				break;
		default: /* no response to all other keys */
		    return MFW_EVENT_CONSUMED;
		}
	}
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	mmi_camera_test_opt_mnu_cb

 $Description:	Menu callback function for the Option window

 $Returns:		Execution status

 $Arguments:	e - event id
 				m - menu handle
*******************************************************************************/

static int mmi_camera_test_opt_mnu_cb (MfwEvt e, MfwMnu *m)
{
    T_MFW_HND    win  = mfwParent(mfw_header());
    T_MFW_WIN  * win_data = ((T_MFW_HDR *)win)->data;
    T_MMI_CT_Opt_data      * data = (T_MMI_CT_Opt_data *)win_data->user;
  
    TRACE_FUNCTION ("mmi_camera_test_opt_mnu_cb()");

    switch (e)
	{
	case E_MNU_ESCAPE: /* back to previous menu */
		TRACE_EVENT("E_MNU_ESCAPE");
		SEND_EVENT (optwin, CT_RETURN, data->id, NULL);
		camera_state = CAMERA_STATE_VIEWFINDER;
			break;
	default: /* in mnuCreate() only E_MNU_ESCAPE has been enabled! */
	    return MFW_EVENT_REJECTED;
	}
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	mmi_camera_test_opt_destroy

 $Description:		Destroy the Camera Option window
 				
 $Returns:		mfw window handle

 $Arguments:	own_window - current window

*******************************************************************************/

static void mmi_camera_test_opt_destroy(MfwHnd own_window)
{
    T_MFW_WIN * win_data;
    T_MMI_CT_Opt_data     * data;

    TRACE_FUNCTION ("mmi_camera_test_opt_destroy()");

    if (own_window)
	{
	    win_data = ((T_MFW_HDR *)own_window)->data;
	    data = (T_MMI_CT_Opt_data *)win_data->user;

	    if (data)
		{

		   /*
		** Failed to start : Free Memory, and exit
		*/

		if(data->kbd != NULL)
				{
		           kbdDelete (data->kbd);
				}

		if(data->kbd_long!= NULL)
				{
		   kbdDelete (data->kbd_long);
				}

		if(data->menu!= NULL)
      		{
		   mnuDelete(data->menu);
		    }

		     // Delete WIN handler
		     
			   win_delete (data->win);

		     // Free Memory
		  
		    FREE_MEMORY ((void *)data, sizeof (T_MMI_CT_Opt_data));
	}
	else
			   {
		    TRACE_EVENT ("mmi_camera_test_opt_destroy() called twice");
               }
		    }
}

/*******************************************************************************

 $Function:     		mmi_camera_test_set_quality

 $Description:  	Set the Quality factor for the image to be saved.

 $Returns:		Always returns MFW_EVENT_CONSUMED (1)

 $Arguments:		m : pointer to the mnu data for the menu which caused this function to be called.
 				i   : pointer to the item data from the menu.

*******************************************************************************/
GLOBAL int mmi_camera_test_set_quality (MfwMnu* m, MfwMnuItem* i)
{
   int txtId = TxtStandard;
   UBYTE qfactor;
	TRACE_FUNCTION ("mmi_camera_test_set_quality()");
 switch (m->lCursor[m->level])
	{
	case 0:
		txtId = TxtEconomy;
		qfactor = QUALITY_ECONOMY;

		break;
	case 1:
		txtId = TxtStandard;
		qfactor = QUALITY_STANDARD;
		break;
	case 2:
		txtId = TxtHigh;
		qfactor = QUALITY_HIGH;
		break;
		
		default:
		txtId = TxtStandard;
		qfactor = QUALITY_STANDARD;
		break;

	}
	//Set the Quality Factor.
 mfw_cam_set_quality_factor(qfactor);
	//Display the dialgbox to the user.
 mmi_camera_test_show_info(0, txtId,TxtNull,NULL);
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:     		mmi_camera_test_set_color

 $Description:  	Set the Color for the Viewfinder

 $Returns:		 Always returns MFW_EVENT_CONSUMED (1)

 $Arguments:		m : pointer to the mnu data for the menu which caused this function to be called.
 				i   : pointer to the item data from the menu.

*******************************************************************************/
GLOBAL int mmi_camera_test_set_color (MfwMnu* m, MfwMnuItem* i)
{
   int txtId;
   UBYTE blackandwhite;
	TRACE_FUNCTION ("mmi_camera_test_set_color()");
 switch (m->lCursor[m->level])
		{
	case 0:
		txtId = TxtColor;
		blackandwhite = FALSE;
		break;
	case 1:
		txtId = TxtSepia;
		blackandwhite = FALSE;
		break;
	case 2:
		txtId = TxtBlackandWhite;
		blackandwhite = TRUE;
		break;
	case 3:
		txtId = TxtNegative;
		blackandwhite = FALSE;
		break;

		}
mfw_cam_set_viewfinder_param_color(blackandwhite);
 mmi_camera_test_show_info(0, txtId,TxtNull,NULL);
	return   MFW_EVENT_CONSUMED;
}


/*******************************************************************************

  $Function:	  M_exeQuality

  $Description:	  This function is called when the user press "Quality"  in the
				  Camera Options screen.This function creates and displays the 
				  Quality menu in  the option screen.

  $Returns:		  Execution status

  $Arguments:	  m - menu handler
				  i - Menu item selected
 
*******************************************************************************/

 int M_exeQuality(MfwMnu* m, MfwMnuItem* i)
{

    T_MFW_HND       win  = mfwParent(mfw_header());
    T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
    T_MMI_CT_Opt_data * data = (T_MMI_CT_Opt_data *)win_data->user;
	TRACE_FUNCTION("M_exeQuality");

	bookMenuStart(data->win, qualityMenuAttributes(),0);
	return   MFW_EVENT_CONSUMED;

}

/*******************************************************************************

  $Function:	  M_exeColor

  $Description:	  This function is called when the user press "Color"  in the
				  Camera Options screen.This function creates and displays the 
				  Color menu in  the option screen.

  $Returns:		  Execution status

  $Arguments:	  m - menu handler
				  i - Menu item selected

*******************************************************************************/
	
 int M_exeColor(MfwMnu* m, MfwMnuItem* i)
	{
    T_MFW_HND       win  = mfwParent(mfw_header());
    T_MFW_WIN     * win_data = ((T_MFW_HDR *)win)->data;
    T_MMI_CT_Opt_data * data = (T_MMI_CT_Opt_data *)win_data->user;
	TRACE_FUNCTION("M_exeColor");

	bookMenuStart(data->win, colorMenuAttributes(),0);
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

  $Function:	  M_exeZoom

  $Description:	  This function is called when the user press "Zoom"  in the
				  Camera Options screen.This function creates and displays the 
				  Zoom menu in  the option screen.
	
  $Returns:		  Execution status
	  
  $Arguments:	  m - menu handler
				  i - Menu item selected
		
*******************************************************************************/

 int M_exeZoom(MfwMnu* m, MfwMnuItem* i)
{
	int txtId = TxtDigiZoom;
	TRACE_FUNCTION("M_exeZoom");
	mfw_cam_set_viewfinder_param_zoom(TRUE);
	mmi_camera_test_show_info(0, txtId,TxtNull,NULL);
	return   MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:		mmi_filename_editor_cb

 $Description:		This function provides the callback functionality to the editor to rename the
 				default jpeg filename.

 $Returns:		None

 $Arguments:	

*******************************************************************************/
static void mmi_filename_editor_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_MFW_WIN		* win_data = ((T_MFW_HDR *) win)->data;
	T_CT_Editor_Data* dev_name_data = (T_CT_Editor_Data *)win_data->user;
	UBYTE			* editor_buffer = NULL;
	SHORT			max_edit_size = 0;
	T_MFW_HND		editor_win;
	T_MFW_HND		parent;

    TRACE_FUNCTION ("mmi_filename_editor_cb()");

		editor_buffer = dev_name_data->ct_buffer;
		max_edit_size =CT_FILENAME_EDITOR_INPUT_LEN;
		editor_win = dev_name_data->ct_win_editor;
		parent = dev_name_data->win;

	switch (reason)
	{
		case INFO_KCD_LEFT:
		{	
			/*
			** If there is no string entered, treat this as if it was a "Cancel"
			*/
			if (editor_buffer[0] == NULL)
			{
				/*
				** Send a "Cancel" to the  window
				*/
				SEND_EVENT(parent, CT_EDITOR_CANCEL, identifier, NULL);
			}
			else
	{
				//If the file extn is not jpg, send cancel event
					/*
					** Send a "Select" to the  window
					*/
					SEND_EVENT(parent, CT_EDITOR_SELECT, identifier, NULL);
			}
		}
			break;

		case INFO_KCD_RIGHT:
			if (strlen((char *)editor_buffer) == NULL)
			{

				/*
				** Send a "Cancel" to the  window
				*/
				SEND_EVENT(parent, CT_EDITOR_CANCEL, identifier, NULL);
	}
			break;

		case INFO_KCD_HUP:
			/*
			** Set the buffer to NULLS
			*/
			memset(editor_buffer, 0x00, max_edit_size);

			/*
			** Send a "Cancel" to the   window
			*/
			SEND_EVENT(parent, CT_EDITOR_CANCEL, identifier, NULL);
			break;

		default:
			/* otherwise no action to be performed
			*/
			break;
	}
}


/*******************************************************************************

 $Function:		mmi_camera_test_update_softkeys

 $Description:		This function updates only the softkeys region.
 				
 $Returns:		None

 $Arguments:		None

*******************************************************************************/
void mmi_camera_test_update_softkeys (int lsk, int rsk)
{
	TRACE_EVENT("mmi_camera_test_update_softkeys");
	dspl_SetBgdColour(COL_White);
	dspl_ClearAll();
	displaySoftKeys(lsk,rsk);
//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
//replaced the flag with the function call, to migrate to the new Lcd APIs
	dspl_control(DSPL_ACCESS_ENABLE);
	dspl_Enable(1);
}

/*******************************************************************************

 $Function:    	mmi_camera_editor_destroy

 $Description:	Destroy the  filename editor window

 $Returns:		mfw window handle

 $Arguments:	own_window - current window

*******************************************************************************/
MfwRes mmi_camera_editor_destroy(T_MFW_HND win)
	{
	T_MFW_WIN * win_data;
	T_CT_Editor_Data * data;
			
	TRACE_FUNCTION ("mmi_camera_editor_destroy");
	if (win == NULL)
		return MfwResIllHnd;

	win_data = ((T_MFW_HDR *) win)->data;
	data = (T_CT_Editor_Data *)win_data->user;

		/*
	** Destroy the Window
		*/
	win_delete(data->win);

       	/*
	** Free the dynamically allocated memory
		*/
	mfwFree((U8 *)data, (U16)sizeof(T_CT_Editor_Data));

	return MfwResOk;
}

/*******************************************************************************

 $Function:    	mmi_camera_editor_cntrl

 $Description:	Exec callback function for the edit filename window

 $Returns:		none

 $Arguments:	win - current window
 				event - event id
 				value - unique id
 				parameter - optional data.
 			
*******************************************************************************/
void mmi_camera_editor_cntrl (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
		{
	T_MFW_WIN			* win_data = ((T_MFW_HDR *) win)->data;
	T_CT_Editor_Data * data = (T_CT_Editor_Data *)win_data->user;
	T_AUI_EDITOR_DATA	editor_data;

	TRACE_FUNCTION ("mmi_camera_editor_cntrl");
	
	switch (event)
		{
		case CT_INIT:
#ifdef NEW_EDITOR
                      //Clear the editor buffer
			memset(&editor_data,'\0',sizeof(editor_data));
			// copy the default name in the editor buffer
			strcpy((char *)data->ct_buffer,CT_DEFAULT_FILENAME);
			
			/*
			** Initialise the editor
			*/
			AUI_edit_SetDefault(&editor_data);
			AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, data->ct_buffer, CT_FILE_NAME_LENGTH);
			AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtFilename, NULL);
			AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
			AUI_edit_SetEvents(&editor_data, 0, TRUE, FOREVER, (T_AUI_EDIT_CB)mmi_filename_editor_cb);
			data->ct_win_editor = AUI_edit_Start(data->win, &editor_data);
#endif
			break;

		case CT_EDITOR_CANCEL:
			/*
			** The editor will be destroyed. Reset the Window handler
			*/
			data->ct_win_editor = NULL;

			/*
			** Destroy the editor Window
			*/
			TRACE_FUNCTION ("mmi_camera_editor_cntrl CT_EDITOR_CANCEL");
			mmi_camera_editor_destroy(data->win);
			SEND_EVENT (optwin, CT_RETURN, NULL, NULL);
		       camera_state = CAMERA_STATE_VIEWFINDER;
			break;

		case CT_EDITOR_SELECT:
			//copy the file name from the editor
			strcpy(new_filename,(char *)data->ct_buffer);
			mmi_camera_editor_destroy(data->win);
			SEND_EVENT (optwin, CT_RETURN, NULL, NULL);
			camera_state = CAMERA_STATE_VIEWFINDER;
			break;

		default:
			TRACE_FUNCTION ("mmi_camera_editor_cntrl(), Unexpected Event!"); 
			break;
	}


}

/*******************************************************************************

 $Function:     mmi_camera_edit_filename

 $Description:  	This function is called when the user press Filename in the option menu .

 $Returns:    Execution status

 $Arguments:  m - menu handler
        i - Menu item selected

*******************************************************************************/
GLOBAL int mmi_camera_edit_filename(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND win = mfw_parent(mfw_header());
	T_MFW_WIN		* win_data = ((T_MFW_HDR *) win)->data;
	T_CT_Editor_Data * data = (T_CT_Editor_Data *)(win_data->user);

    TRACE_FUNCTION ("mmi_camera_edit_filename()");

	data->ct_win_editor = (MfwHnd)mmi_camera_editor_create(win);

	if (data->ct_win_editor != NULL)
	{
	    SEND_EVENT(data->ct_win_editor, CT_INIT, 0, NULL);
	}
	else
	{
	    TRACE_FUNCTION ("mmi_camera_edit_filename() : Unable to create Editor Win!");
	}
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	mmi_camera_editor_create

 $Description:		Create a window for editing the image file name to be saved.

 $Returns:		window handle

 $Arguments:	parent - parent window.

*******************************************************************************/


T_MFW_HND mmi_camera_editor_create(T_MFW_HND parent)
{
	T_CT_Editor_Data *data;
	T_MFW_WIN * win;

	TRACE_FUNCTION ("mmi_camera_editor_create");

	data = (T_CT_Editor_Data *)mfwAlloc((U16)sizeof(T_CT_Editor_Data));

	if (data == NULL)
		return data;

	data->win = winCreate(parent, 0, E_WIN_VISIBLE, NULL);

	if (data->win == NULL)
	{
		/*
		** Failed to start : Free Memory, and exit
		*/
		mfwFree((U8 *)data, (U16)sizeof(T_CT_Editor_Data));
		data = NULL;
		return data;
	}
	else
	{
		/*
		** Setup the Dialog control functions
		*/
		data->mmi_control.dialog = (T_DIALOG_FUNC)mmi_camera_editor_cntrl;
		data->mmi_control.data = data;

		win = ((T_MFW_HDR *)data->win)->data;
		win->user = (void *)data;
}

	return data->win;

}

/*******************************************************************************

 $Function:    	display_saved_image

 $Description:	Displays the Dialog to show the status of save image

 $Returns:		None

 $Arguments:	res - Status of Save Image

*******************************************************************************/

 void display_saved_image(BOOL res)
 	{

		if(call_data.win)
		{
			dialog_info_destroy(digwin1);
			digwin1 = NULL;
			return;
		}
	//Sept 15, 2005 REF: LOCOSTO-ENH-34257 - xpradipg
	//replaced the flag with the function call, to migrate to the new Lcd APIs
		dspl_control(DSPL_ACCESS_ENABLE);
		dspl_Clear(0,0,SCREEN_SIZE_X-1,SCREEN_SIZE_Y-1 );
		if( res)
			mmi_camera_test_show_info(digwin1, TxtSaved, TxtNull,(T_VOID_FUNC) mmi_camera_dialog_cb);	
		else
			mmi_camera_test_show_info(digwin1, TxtFailed, TxtNull,(T_VOID_FUNC) mmi_camera_dialog_cb);
 	}


