#ifndef _MMI_CPHS_H_
#define _MMI_CPHS_H_

/*******************************************************************************

          CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name: Basic MMI
 $Project code: BMI (6349)
 $Module:   CPHS
 $File:       MmiCPHS.h
 $Revision:   1.0

 $Author:   Condat(UK)
 $Date:       25/01/02

********************************************************************************

 Description:

  Handles CPHS functionality


********************************************************************************
 $History: MmiCPHS.h

//  May 31, 2004        REF: CRR 17291  xvilliva
//	Bug:	After power cycle the setting of the used line which have been made 
//			from the BMI is lost.
//	Fix:	The global variable g_Pin2 is declared here.

  25/01/02      Original Condat(UK) BMI version.

 $End

*******************************************************************************/
#include "mfw_cphs.h"
#include "mfw_mfw.h"
#include "MmiBookShared.h"
#include "mfw_mnu.h"

typedef enum
{
  LINE1,
  LINE2,
  FAX,
  DATA
} ALS_lines;
#define VOICEMAIL 0x7070
typedef enum
{
  MAILBOX,
  CHECK_STATUS
} T_CPHS_FUNCS;

//xvilliva SPR17291
extern char g_pin2[MAX_PIN+1];

//initialise CPHS
T_MFW_HND mmi_cphs_init(void); // RAVI

//call mailbox numbers
int menu_cphs_call_mailbox_number(MfwMnu* m, MfwMnuItem* i);

//edit mailbox numbers
int menu_cphs_edit_mailbox_number(MfwMnu* m, MfwMnuItem* i);

//get operator name from CPHS SIM
T_MFW_CPHS_OP_NAME* CphsRequestOperatorName(void); // RAVI

//returns TRUE if present
UBYTE CphsPresent(void); // RAVI

//returns TRUE if SIM configured for mailbox number
USHORT CphsMailboxPresent(void /* struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi*/ ); // RAVI

//Get voicemail status, returns status of line requested in parameter
T_MFW_CFLAG_STATUS GetCphsVoicemailStatus(UBYTE line);

//get call forwarding status of specified line
T_MFW_CFLAG_STATUS GetCphsDivertStatus(UBYTE line);

//get current enabled ALS line
int cphs_als_status(MfwMnu* m, MfwMnuItem* i);

// Set the current CPHS ALS lock status
int cphs_lock_als(MfwMnu* m, MfwMnuItem* i);
int cphs_unlock_als(MfwMnu* m, MfwMnuItem* i);

//Set ALS line to Line 1
int cphs_line1_select(MfwMnu* m, MfwMnuItem* i);

//Set ALS line to Line 2
int cphs_line2_select(MfwMnu* m, MfwMnuItem* i);

//Display any info numbers
int InfoNumbers( MfwMnu *m, MfwMnuItem *i );

//Pop up a dialogue
void ShowMessage(T_MFW_HND win, USHORT TextId1, USHORT TextId2);

//check if ALS
USHORT ALSPresent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT CphsALSUnlocked( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
USHORT CphsALSLocked( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );

//check if any info nums
USHORT InfoNumbersPresent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi );
void mmi_cphs_refresh(void); // RAVI
UBYTE GetAlsLine(void); // RAVI
#endif
