/*******************************************************************************

					CONDAT (UK)

********************************************************************************									      

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.				   
									      
********************************************************************************

 $Project name: Basic MMI						       
 $Project code: BMI (6349)							     
 $Module:		CPHS
 $File: 	    MmiCPHS.c
 $Revision:		1.0							  
									      
 $Author:		Condat(UK)							   
 $Date: 	    25/01/02							  
									       
********************************************************************************
									      
 Description

    This module provides the CPHS functionality

  
********************************************************************************
 $History: MmiCall.c

	Jun 14, 2005 REF: MMI-FIX-30439 x0018858
   	Description: The homezone/cityzone tags were not being displayed properly.
   	Solution: Modified to save the tags properly in caches and also made the 
	appropriate modifications to update the same properly during mobility.

	Aug 16, 2004    REF: CRR 24323   Deepa M.D
	Bug:Clenup of sprintf used for tracing
	Fix:Replace the char buf[]; sprintf (buf, "...", ...); TRACE_EVENT (buf); statements by TRACE_EVENT_PX

    	Jun 23, 2004        	REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
  	Solution:			The CF state is maintained in flash. During bootup the CF icon in the idle screen
  					 is displayed depending upon its state in the ffs


//  May 31, 2004        REF: CRR 17291  xvilliva
//	Bug:	After power cycle the setting of the used line which have been made 
//			from the BMI is lost.
//	Fix:	1.The global g_pin2 is defined here.
//		2. sAT_PlusCLCK() is called while locking and unlocking ALS.
//		3. ALSPresent() is modified to call tAT_PercentALS() & qAT_PercentALS().
//		NOTE:- ALSPresent() was giving faulty status earlier.


  25/01/02			Original Condat(UK) BMI version. (MC)	
	   
 $End

*******************************************************************************/


/******************************************************************************
									      
				Include Files
									      
*******************************************************************************/

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif
#include "mfw_sys.h"

#include "cus_aci.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "ksd.h"
#include "psa.h"
#include "mfw_sms.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_str.h"

#include "dspl.h"

#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiMmi.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "MmiDialogs.h"
#include "MmiMenu.h"
#include "MmiSoftKeys.h"
/* SPR#1428 - SH - New Editor changes */
#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else
#include "MmiEditor.h"
#endif
#include "MmiBookShared.h"
#include "mmiSmsMenu.h"
#include "Mmiicons.h"
#include "mmiColours.h"

#include "MmiCPHS.h"
// Jun 23 2004        REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
#include "mfw_ffs.h"
/* SPR759 - SH */
#ifdef MMI_HOMEZONE_ENABLED
#include "MmiHomezone.h"
#endif




/******************************************************************************
									      
			       Definitions
									      
*******************************************************************************/
//#define CPHS_PROV_TEST /*Test to bypass the reading of the CPHS field from the SIM card*/
char g_pin2[MAX_PIN+1];//xvilliva SPR17291

typedef enum


{
	INFO_NUM_LIST,
	MAILBOX_LIST, 
	MAILBOX_LIST_CALL
}
	T_MENU_TYPE;


static MfwMnuAttr InfoNum_menuAttrib =
{
    &melody_menuArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE, /* centered page menu	    */
    -1, 				/* use default font	    */
    NULL,				/* with these items	    */
    0,					/* number of items     */
    COLOUR_LIST_XX, TxtNull, NULL, MNUATTRSPARE

};

typedef struct 
{
	 /* administrative data */

    T_MMI_CONTROL	mmi_control;
    T_MFW_HND		win;
    T_MFW_HND		parent_win;
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;	/* SPR#1428 - SH - New Editor data */
#else /* NEW_EDITOR */
	T_EDITOR_DATA		editor_data;
#endif /* NEW_EDITOR */

    /* associated handlers */

    T_MFW_HND		kbd;
    T_MFW_HND		kbd_long;
    T_MFW_HND		menu;
	T_MFW_HND		menu_tim;
	UBYTE				status_of_timer; /* use for the keypadlock */

	T_MFW_HND mailbox_win;
	T_MFW_CPHS_ENTRY cphs_voicemail_num;
	T_MFW_CPHS_VC_STAT* cphs_voicemail_status;
	T_MFW_CPHS_STATUS cphs_status;
	T_MFW_CPHS_OP_NAME* operator_name;

}  T_MMI_CPHS_DATA;


typedef struct
{
  T_MMI_CONTROL    mmi_control;
  T_MFW_HND	   numbers_win; 				   /* MFW win handler	   */
  T_MFW_HND	   parent;
  T_MFW_HND	   melody_handler;	   /* MFW sms handler	   */
  unsigned char      local_status;
  ListMenuData	   * menu_list_data;
} T_INFO_NUM_INFO;

#define E_INIT 1



#define CPHS_TELESERVICES_BYTE_VALUE	0x06
#define ALS_MASK						0x80

#define CPHS_INFONUMS_BYTE_VALUE		0xC0
#define INFONUM_MASK					0xFF


/******************************************************************************
									      
			       Static Global variables
									      
*******************************************************************************/

static T_MFW_CPHS_ENTRY cphs_voicemail_num;
static T_MFW_CPHS_INFONUM_ENTRY current_info_num;
static T_MFW_CPHS_VC_NUM cphs_voicemail_numbers;
static T_MFW_CPHS_VC_STAT* cphs_voicemail_status;
static T_MFW_CPHS_STATUS cphs_status = CPHS_NotPresent;
static T_MFW_CPHS_OP_NAME operator_name;
static T_MFW_CPHS_DV_STAT call_forwarding_status;
static T_MFW_CPHS_ALS_STATUS als_status;
static T_MFW_CPHS_CSP customer_service_profile;
static T_MFW_CPHS_INFONUM_LIST* info_numbers[4]= {NULL, NULL, NULL, NULL};

static UBYTE info_num_level;
static USHORT info_num_index;

static T_MENU_TYPE type_of_list = INFO_NUM_LIST;

/******************************************************************************
									      
			       Function Prototypes
									      
*******************************************************************************/
int InfoNumbers2(void); // RAVI

int show_cphs_mb_number(T_MFW_CPHS_ENTRY* mb_number);
static void mailbox_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason);
static int cphs_win_cb (T_MFW_EVENT event, T_MFW_WIN * win);
int cphs_mfw_cb(T_MFW_EVENT event, void* para);
void cphs_dialog_cb(T_MFW_HND win, USHORT e,  SHORT identifier, void *parameter);
T_MFW_HND mmi_cphs_create(T_MFW_HND parent_window);
T_MFW_HND	edit_mailbox_start(T_MFW_HND parent_window);

static T_MFW_HND  buildInfoNumberMenu( MfwHnd parent_window);
void info_num_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
void InfonumList_cb(T_MFW_HND * Parent, ListMenuData * ListData);
static void InfoNum_destroy(MfwHnd own_window);
static int info_num_win_cb (MfwEvt e, MfwWin *w) ;
void info_num_display_cb(T_MFW_HND win, USHORT identifier, UBYTE reason);
EXTERN void  cphs_support_check(void);  // ADDED BY RAVI - 29-11-2005

/******************************************************************************
									      
			       Public functions
									      
*******************************************************************************/
/*******************************************************************************

 $Function:	mmi_cphs_init()

 $Description:	initiatialise cphs module
 
 $Returns:		mfw handle

 $Arguments:	none
		
*******************************************************************************/
T_MFW_HND mmi_cphs_init()
{	
	T_MFW_HND status;
	cphs_init();			//initialise MFW CPHS module

	status = cphs_create(NULL, 0xFFFF, cphs_mfw_cb); //create handler for MFW CPHS EVENTS
	
	info_num_level = 0;
	info_num_index = 1;
	cphs_get_als_info(&als_status);
	return status;
}

void mmi_cphs_refresh()
{	
	cphs_support_check();	//check if cphs supported
	/*retrieval of other values set off by callback function cphs_mfw_cb
	so when the CPHS status is retrieved, the operator name is then requested and 
	when it has returned, then the CSP is requested etc etec  */
		
}
/*******************************************************************************

 $Function:	cphs_E_plus_ALS_supported

 $Description:	returns TRUE if SIM is from E-plus, FALSE otherwise 
 
 $Returns:		status BOOL

 $Arguments:	none
		
*******************************************************************************/
BOOL cphs_E_plus_ALS_supported()
{	char IMSI[17];
	char MNC_MCC[6];
	char E_plus_MNC_MCC[] = "26203";
	int i=0;
	T_ACI_RETURN result;
//	char debug[40];  // RAVI
	
	while ((result = qAT_PlusCIMI(CMD_SRC_LCL, IMSI)) != AT_CMPL  && i < 5)
	{
		i++;
	}
		
	strncpy(MNC_MCC, IMSI, 5);
	MNC_MCC[5] =0;//terminate string
	TRACE_EVENT("E-plus IMSI?");
	TRACE_EVENT(MNC_MCC);
	if (!strncmp(E_plus_MNC_MCC, MNC_MCC, 5)) //if e-plus IMSI
	{	
		return TRUE;

	}
	else
	{	TRACE_EVENT("Not e-plus IMSI");
		return FALSE;
	}

}
/*******************************************************************************

 $Function:	cphs_als_status

 $Description:	display which ALS line is enabled
 
 $Returns:		status int

 $Arguments:	menu, tag (not used)
		
*******************************************************************************/
int cphs_als_status(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());
	UBYTE line;
	line = GetAlsLine();
#ifndef CPHS_PROV_TEST
	if (CphsPresent() == TRUE || cphs_E_plus_ALS_supported())
#endif
	{
		if (als_status.selectedLine != MFW_SERV_NotPresent)
			switch(line)
			{
				case (MFW_SERV_LINE1): ShowMessage(parent, TxtLine1, TxtActivated);break;
				case (MFW_SERV_LINE2): ShowMessage(parent, TxtLine2, TxtActivated);break;
				default: ShowMessage(parent, TxtReadError, TxtNull);break;
			}
		else
			ShowMessage(parent, TxtReadError, TxtNull);
	}
#ifndef CPHS_PROV_TEST
	else
		ShowMessage(parent, TxtNotSupported, TxtNull);
#else
		cphs_support_check();
#endif

	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:	       cphs_lock_als

 $Description:	       Lock ALS Line Selection from menu 
 
 $Returns:		status int

 $Arguments:	       menu, tag (not used)
		
*******************************************************************************/
int cphs_lock_als(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND		parent	     = mfwParent( mfw_header());
	T_MFW			retVal;

	TRACE_FUNCTION("cphs_lock_als");

#ifndef CPHS_PROV_TEST
	if (!ALSPresent(NULL, NULL, NULL))
#endif
	{
		//xvilliva SPR17291 
		//We call sAT_PlusCLCK(), to update the value in FFS. This is the value used by
		//ACI to estabilish a call on Line1 or Line2.
#ifndef FF_2TO1_PS 
		sAT_PlusCLCK(CMD_SRC_LCL,CLCK_FAC_Al,CLCK_MOD_Lock,g_pin2,
				((als_status.selectedLine == MFW_SERV_LINE1) ? CLASS_Vce : CLASS_AuxVce));//
#endif
		retVal = cphs_set_als_status(MFW_LINE_LOCKED);
		if (retVal == CPHS_OK)
		{
			als_status.status = MFW_LINE_LOCKED;
			ShowMessage(parent, TxtAlsLocked, TxtNull);
		}
	}
#ifndef CPHS_PROV_TEST
	else
		ShowMessage(parent, TxtNotSupported, TxtNull);
#endif

	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:	       cphs_unlock_als

 $Description:	       Unlock ALS Line Selection from menu 
 
 $Returns:		status int

 $Arguments:	       menu, tag (not used)
		
*******************************************************************************/
int cphs_unlock_als(MfwMnu* m, MfwMnuItem* i)
{
	T_MFW_HND		parent	     = mfwParent( mfw_header());
	T_MFW			retVal;

	TRACE_FUNCTION("cphs_unlock_als");

#ifndef CPHS_PROV_TEST
	if (!ALSPresent(NULL, NULL, NULL))
#endif
	{
		//xvilliva SPR17291
		//We call sAT_PlusCLCK(), to update the value in FFS. This is the value used by
		//ACI to estabilish a call on Line1 or Line2. 
#ifndef FF_2TO1_PS
		sAT_PlusCLCK(CMD_SRC_LCL,CLCK_FAC_Al,CLCK_MOD_Unlock,g_pin2,((als_status.selectedLine == MFW_SERV_LINE1) ? CLASS_Vce : CLASS_AuxVce));//
#endif
		retVal = cphs_set_als_status(MFW_LINE_UNLOCKED);
		if (retVal == CPHS_OK)
		{
			als_status.status = MFW_LINE_UNLOCKED;
			ShowMessage(parent, TxtAlsUnlocked, TxtNull);
		}
	}
#ifndef CPHS_PROV_TEST
	else
		ShowMessage(parent, TxtNotSupported, TxtNull);
#endif

	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:	cphs_line1_select

 $Description:	Enable ALS Line1 from menu 
 
 $Returns:		status int

 $Arguments:	menu, tag (not used)
		
*******************************************************************************/
int cphs_line1_select(MfwMnu* m, MfwMnuItem* i)
{	
	T_MFW_HND		parent	     = mfwParent( mfw_header());
#ifndef CPHS_PROV_TEST
	if (!ALSPresent(NULL, NULL, NULL))
#endif
	{	cphs_select_line(MFW_SERV_LINE1);
		cphs_get_divert_status();
	}
#ifndef CPHS_PROV_TEST
	else
		ShowMessage(parent, TxtNotSupported, TxtNull);
#endif
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:	cphs_line2_select

 $Description:	Enable ALS Line2 from menu 
 
 $Returns:		status int

 $Arguments:	menu, tag (not used)
		
*******************************************************************************/
int cphs_line2_select(MfwMnu* m, MfwMnuItem* i)
{	T_MFW_HND		parent	     = mfwParent( mfw_header());

#ifndef CPHS_PROV_TEST
	if (!ALSPresent(NULL, NULL, NULL))
#endif
	{	cphs_select_line(MFW_SERV_LINE2);
		cphs_get_divert_status();
	}
#ifndef CPHS_PROV_TEST
	else
		ShowMessage(parent, TxtNotSupported, TxtNull);
#endif
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:	menu_cphs_call_mailbox_number

 $Description:	edit mailbox numbers from menu 
 
 $Returns:		status int

 $Arguments:	menu, tag (not used)
		
*******************************************************************************/
int menu_cphs_call_mailbox_number(MfwMnu* m, MfwMnuItem* i)
{   T_MFW_HND		parent	     = mfwParent( mfw_header());
	T_MFW_CPHS_INFO configuration;
	type_of_list = MAILBOX_LIST_CALL;
	cphs_config(&configuration);
	/***************************Go-lite Optimization changes Start***********************/
	//Aug 16, 2004    REF: CRR 24323   Deepa M.D
	TRACE_EVENT_P2( "CPHS? %d Mailbox config info: %d", configuration.mbNum, CphsPresent());
	/***************************Go-lite Optimization changes end***********************/
	if (CphsMailboxPresent()==TRUE )
		cphs_get_mailbox();
	else
		M_callVoice(m, i);
    return MFW_EVENT_CONSUMED;		
}
/*******************************************************************************

 $Function:	menu_cphs_edit_mailbox_number

 $Description:	edit mailbox numbers from menu 
 
 $Returns:		status int

 $Arguments:	menu, tag (not used)
		
*******************************************************************************/
int menu_cphs_edit_mailbox_number(MfwMnu* m, MfwMnuItem* i)
{   T_MFW_HND		parent	     = mfwParent( mfw_header());
	T_MFW_CPHS_INFO configuration;
	
	type_of_list = MAILBOX_LIST;
	
	cphs_config(&configuration);
	/***************************Go-lite Optimization changes Start***********************/
	//Aug 16, 2004    REF: CRR 24323   Deepa M.D
	TRACE_EVENT_P2( "CPHS? %d Mailbox config info: %d", configuration.mbNum, CphsPresent());
	/***************************Go-lite Optimization changes end***********************/
	if (CphsMailboxPresent()==TRUE )
		cphs_get_mailbox();
	else
		M_exeVoice(m, i);
    return MFW_EVENT_CONSUMED;		
}
/*******************************************************************************

 $Function:	InfoNumbers

 $Description:	displays information number list from CPHS 

 $Returns:		MFW_EVENT_CONSUMED always

 $Arguments:	m, menu, i, item
 
*******************************************************************************/

int InfoNumbers( MfwMnu *m, MfwMnuItem *i )
{
	T_MFW_HND win;
    T_MFW_HND parent_win = mfw_parent(mfw_header());
	T_MFW_CPHS_INFO config_info;
	
	cphs_config(&config_info);
	/***************************Go-lite Optimization changes Start***********************/
//Aug 16, 2004    REF: CRR 24323   Deepa M.D
	TRACE_EVENT_P1("Info Num config info: %d", config_info.iNum);
	/***************************Go-lite Optimization changes end***********************/
	if (CphsPresent() && config_info.iNum&0x03)
	{	if (info_numbers[0] != NULL&& info_numbers[0]->count != 0)
		{	type_of_list = INFO_NUM_LIST;
			info_num_level = 1;
			win = buildInfoNumberMenu(parent_win);
			
			if (win NEQ NULL)
			{
				SEND_EVENT (win, E_INIT, 0, 0);
			}
		}
		else
			ShowMessage(parent_win, TxtEmptyList, TxtNull);
	}
	else
		ShowMessage(parent_win, TxtNotSupported, TxtNull);
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:	CphsRequestOperatorName()

 $Description:	returns operator name data structure from CPHS SIM data

 $Returns:		see above

 $Arguments:	none
 
*******************************************************************************/
T_MFW_CPHS_OP_NAME* CphsRequestOperatorName()
{	
	return &operator_name;
}

/*******************************************************************************

 $Function:	CphsPresent()

 $Description:	indicates whether CPHS sim or not

 $Returns:		TRUE if it is, FALSe if it isn't
 $Arguments:	none
 
*******************************************************************************/
UBYTE CphsPresent()
{

	if (cphs_status == CPHS_OK)
		return TRUE;
	else
	 {	 if (cphs_status == CPHS_NotPresent)
			return FALSE;
		else /*MC 21/05/02, CONQ5999->6007 Helps diagnose initialisation probs*/
			return CPHS_ERR;
	}
}
/*******************************************************************************

 $Function:	CphsMailboxPresent

 $Description:	indicates whether a CPHS SIM which supports mailbox numbers

 $Returns:		TRUE if it is, FALSe if it isn't
 $Arguments:	none
 
*******************************************************************************/
USHORT CphsMailboxPresent( /*struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi*/ )
{	T_MFW_CPHS_INFO config_info;

	cphs_config(&config_info);

	if (config_info.mbNum &0x03 && CphsPresent())
		return /*0*/TRUE;
	else
		return /*1*/FALSE;

}
/*******************************************************************************

 $Function:	ALSPresent

 $Description:	indicates whether a CPHS SIM supports ALS by checking CSP

 $Returns:		0 if it does, 1 if it doesn't
 $Arguments:	menu tag, menu attribute tag, menu item tag (none of them used, 
				this is merely the format for menu display/suppression functions)
 
*******************************************************************************/
USHORT ALSPresent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{ 
	//xvilliva SPR17291 - The pre-existing code was returning ALS not supported 
	//		      even if it the SIM supported. Changed the code to call 
	//		      tAT_PercentALS() and qAT_PercentALS(). 		

	T_ACI_RETURN ACI_return = AT_FAIL ;
	T_ACI_ALS_MOD ALSmode = (T_ACI_ALS_MOD)0;  // RAVI

	ACI_return = tAT_PercentALS( CMD_SRC_NONE, &ALSmode );
	ACI_return = qAT_PercentALS( CMD_SRC_NONE, &ALSmode );

	// ALSmode = 1;//xvilliva  SPR17291 - IMP: Hardcoded for our SIMS - got to test on ALS sim.

	return   (!ALSmode);//returns 0 (if line1 or line2) returns 1 if not supported.
}
/*******************************************************************************

 $Function:	       CphsALSUnlocked

 $Description:	       Indicates whether a CPHS SIM's support of ALS has been locked by the User

 $Returns:		0 if it hasn't, 1 if it has
 $Arguments:	       menu tag, menu attribute tag, menu item tag (none of them used, 
				this is merely the format for menu display/suppression functions)
 
*******************************************************************************/
USHORT CphsALSUnlocked( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
	USHORT retVal = CphsALSLocked(m, ma, mi);

	if (retVal == 0)
		retVal = 1;
	else
		retVal = 0;
	
	return (retVal);
}
/*******************************************************************************

 $Function:	       CphsALSUnlocked

 $Description:	       Indicates whether a CPHS SIM's support of ALS has been locked by the User

 $Returns:		0 if it has, 1 if it hasn't
 $Arguments:	       menu tag, menu attribute tag, menu item tag (none of them used, 
				this is merely the format for menu display/suppression functions)
 
*******************************************************************************/
USHORT CphsALSLocked( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{
	USHORT retVal;
	
	if (als_status.status == MFW_LINE_LOCKED)
		retVal = 0;
	else
		retVal = 1;
	
	return (retVal);
}
/*******************************************************************************

 $Function:	InfoNumbersPresent

 $Description:	indicates whether a CPHS SIM has Info Numbers by checking CSP

 $Returns:		0 if it does, 1 if it doesn't
 $Arguments:	none
 
*******************************************************************************/
USHORT InfoNumbersPresent( struct MfwMnuTag *m, struct MfwMnuAttrTag *ma, struct MfwMnuItemTag *mi )
{	T_MFW_CPHS_INFO config_info;
	
	int i;
	cphs_config(&config_info);
	/***************************Go-lite Optimization changes Start***********************/
	//Aug 16, 2004    REF: CRR 24323   Deepa M.D
	TRACE_EVENT_P1("InfoNum config: %d", config_info.iNum);
	/***************************Go-lite Optimization changes end***********************/
	for(i=0; i< strlen((char*)customer_service_profile.csp); i+=2)	
	{
		if (customer_service_profile.csp[i] ==CPHS_INFONUMS_BYTE_VALUE)
			if (customer_service_profile.csp[(i+1)] & INFONUM_MASK)
				return 0; //ALS is supported
	}
	return 1;
}
/*******************************************************************************

 $Function:	GetCphsVoicemailStatus

 $Description:	Asks MFW to check voicemail status on CPHS SIM
				cphs_mfw_cb handles callback from this
 $Returns:		status of line passed as parameter
 $Arguments:	line
 
*******************************************************************************/
T_MFW_CFLAG_STATUS GetCphsVoicemailStatus(UBYTE line)
{	
	cphs_get_mailbox_status (); 
	TRACE_EVENT("Requesting voicemail status");
	
	/*SPR 2653, removed unneccessary code*/
	/*requesting the mailbox status will trigger an event from the MFW if
	CPHS is supported and that event will cause a voicemail indication window if a 
	voicemail flag has been set in the SIM*/
		return MFW_CFLAG_NotPresent;


}
/*******************************************************************************

 $Function:	GetCphsDivertStatus

 $Description:	get call forwarding status of specified line
				cphs_mfw_cb handles callback from this
 $Returns:		status of line passed as parameter
 $Arguments:	line
 
*******************************************************************************/

T_MFW_CFLAG_STATUS GetCphsDivertStatus(UBYTE line)
{	
	switch (line)
	{
		case MFW_SERV_LINE1:	return call_forwarding_status.line1; //break;  // RAVI
		case MFW_SERV_LINE2:		return call_forwarding_status.line2; // break; // RAVI
		case MFW_SERV_FAX:		return call_forwarding_status.fax; // break; // RAVI
		case MFW_SERV_DATA:		return call_forwarding_status.data; // break; // RAVI
		default:		return MFW_CFLAG_NotPresent;
	}
}
/*******************************************************************************

 $Function:	GetAlsLine
 $Description:	gets current als line
 $Returns:		current als line
 $Arguments:	line
 
*******************************************************************************/
UBYTE GetAlsLine()
{	
	return als_status.selectedLine;
}

/*******************************************************************************

 $Function:	ShowMessage
 $Description:	Displays screen with passed text ids
 $Returns:		nothing
 $Arguments:	parent window, 2 text ids
 
*******************************************************************************/
void ShowMessage(T_MFW_HND win, USHORT TextId1, USHORT TextId2)
{

	T_DISPLAY_DATA Dialog;

	/* Initialise the dialog control block with default information
	*/
	dlg_initDisplayData_TextId( &Dialog, TxtNull,  TxtNull, TextId1, TextId2 , COLOUR_STATUS);
	dlg_initDisplayData_events( &Dialog, NULL, THREE_SECS, KEY_LEFT| KEY_RIGHT|KEY_CLEAR );

	/* Show the dialog
	*/
	info_dialog( win, &Dialog );
}



/******************************************************************************
									      
			     Private functions
									      
*******************************************************************************/

T_MFW_HND	edit_mailbox_start(T_MFW_HND parent_window)
{
		T_MFW_HND		win	      = mmi_cphs_create(parent_window);
		TRACE_FUNCTION("calc_start()");
	    if (win NEQ NULL)
		{
		SEND_EVENT(win, MAILBOX, NULL, NULL);
	       
		} 

	   return win;
} 





T_MFW_HND mmi_cphs_create(T_MFW_HND parent)
{	T_MMI_CPHS_DATA     * data = (T_MMI_CPHS_DATA *)ALLOC_MEMORY (sizeof (T_MMI_CPHS_DATA ));
	T_MFW_WIN  * mailbox_win;

	if (data EQ NULL)
	{
		return NULL;
	}

	// Create window handler
	data->mailbox_win = win_create (parent, 0, E_WIN_VISIBLE, (MfwCb)cphs_win_cb);
	if (data->mailbox_win EQ NULL)
	{
		
		return NULL;
	}
	// connect the dialog data to the MFW-window
	data->mmi_control.dialog = (T_DIALOG_FUNC)cphs_dialog_cb;
	data->mmi_control.data	 = data;
	mailbox_win			 = ((T_MFW_HDR *)data->mailbox_win)->data;
	mailbox_win->user		 = (void *)data;
	data->parent_win	 = parent;
	data->win = mailbox_win;
	return data->mailbox_win;

}

void mailbox_destroy(MfwHnd own_window)
{
  T_MFW_WIN * win_data;
  T_MMI_CPHS_DATA   * data = NULL; 

  if (own_window)
	{	

	win_data = ((T_MFW_HDR *)own_window)->data;
		if (win_data != NULL) //PATCH TB
			data = (T_MMI_CPHS_DATA *)win_data->user;

	  if (data)
		{
		TRACE_EVENT ("mailbox_destroy()");
			
			win_delete (data->win);
		  // Free Memory
			FREE_MEMORY ((void *)data, sizeof (T_MMI_CPHS_DATA));
	
		}
	  else
		{
			TRACE_EVENT ("mailbox_destroy() called twice");
		}
	}
}

void cphs_dialog_cb(T_MFW_HND win, USHORT e,  SHORT identifier, void *parameter)
{	TRACE_EVENT("cphs_dialog_cb()");
	switch(e)
	{	case (MAILBOX): 
			cphs_get_mailbox();break;
		default: break;
	}
}

static int cphs_win_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
    T_MMI_CPHS_DATA	* data = (T_MMI_CPHS_DATA *)win->user;
	
    TRACE_FUNCTION ("cphs_win_cb()");

    if(data EQ 0)
	return 1;
    switch (event)
    {
	case E_WIN_VISIBLE:
		if (win->flags & E_WIN_VISIBLE)
		{
		    /* Print the information dialog */
		    /* Clear Screen */
		    dspl_ClearAll();
		}
	   default:
		return 0;
	}
    return 1;
}
/*******************************************************************************

 $Function:	show_cphs_mb_numbers
 $Description:	Show the list of mailbox numbers
 $Returns:		nothing
 $Arguments:	none
 
*******************************************************************************/
void show_cphs_mb_numbers()
{
	T_MFW_HND win;
    T_MFW_HND parent_win= mfw_parent(mfw_header());

	{
		win = buildInfoNumberMenu(parent_win);

		if (win NEQ NULL)
		{
			SEND_EVENT (win, E_INIT, 0, 0);
		}
	}
}

/*******************************************************************************

 $Function:	show_cphs_mb_number
 $Description:	Show the passed mailbox number in editor
 $Returns:		status int
 $Arguments:	mailbox number entry
 
*******************************************************************************/

int show_cphs_mb_number(T_MFW_CPHS_ENTRY* mb_number)
{	T_MFW_HND parent_win = mfw_parent(mfw_header());
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;	/* SPR#1428 - SH - New Editor data*/
#else
	T_EDITOR_DATA		editor_data;
#endif
	char temp_number[PHB_MAX_LEN];

	memset(temp_number, 0, PHB_MAX_LEN);

	//if it's an international number without a '+' 
	if (mb_number->ton == MFW_TON_INTERNATIONAL && mb_number->number[0] != '+')
	{	strcat(temp_number, "+");	//put a + in front of number
		strcat(temp_number, (char*)mb_number->number);
		strcpy((char*)mb_number->number, temp_number);
	}

/* SPR#1428 - SH - New Editor changes */

#ifdef NEW_EDITOR
	AUI_edit_SetDefault(&editor_data);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)mb_number->number, PHB_MAX_LEN-1);
	AUI_edit_SetMode(&editor_data, 0, ED_CURSOR_UNDERLINE);
	AUI_edit_SetDisplay(&editor_data, 0, COLOUR_EDITOR, EDITOR_FONT);
	AUI_edit_SetEvents(&editor_data, 0, TRUE, FOREVER, (T_AUI_EDIT_CB)mailbox_edit_cb);
	AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtNull, NULL);

	AUI_edit_Start(parent_win, &editor_data);
#else /* NEW_EDITOR */
	editor_attr_init(&editor_data.editor_attr, 0, edtCurBar1, NULL, (char*)mb_number->number, PHB_MAX_LEN-1, COLOUR_EDITOR);
	editor_data_init(&editor_data, (T_EDIT_CB)mailbox_edit_cb, TxtSoftOK, TxtDelete, NULL, 1, DIGITS_MODE, FOREVER);
	editor_data.Identifier		=  0; 
	editor_data.hide				= FALSE;
	editor_data.destroyEditor		= TRUE; 
	editor_data.TextString		= NULL; /*MC SPR 1257, stops glitch in Chinese*/ 


	editor_start(parent_win,&editor_data);	/* start the editor */ 
#endif /* NEW_EDITOR */
// ADDED BY RAVI - 29-11-2005
#if (BOARD == 61)
	return 1; 
#endif
// END RAVI
}

/*******************************************************************************

 $Function:	mailbox_edit_cb
 $Description:	callback for mailbox editor screen
 $Returns:		nothing
 $Arguments:	window, identifier, reason
 
*******************************************************************************/
static void mailbox_edit_cb( T_MFW_HND win, USHORT Identifier,UBYTE reason)
{

	TRACE_FUNCTION("mailbox_edit_cb()");
	switch (reason )
    {
	case INFO_KCD_LEFT:
	{	
		TRACE_EVENT((char*)cphs_voicemail_num.number);
		cphs_set_mailbox(&cphs_voicemail_num);
		
		}

		break;
		
	default:
	{
	    /* otherwise no action to be performed
	    */
		    break;
	}
	}
}
/*******************************************************************************

 $Function:	cphs_mfw_cb
 $Description:	Callback handler for mfw_cphs events
 $Returns:		status int
 $Arguments:	event, parameter pointer
 
*******************************************************************************/
int cphs_mfw_cb(T_MFW_EVENT event, void* para)
{	T_MFW_HND parent = mfwParent( mfw_header());
	
//   T_MFW_CPHS_VC_NUM* number_list =(T_MFW_CPHS_VC_NUM* )para;  // RAVI

//	T_MFW_CPHS_PARA* parameter = (T_MFW_CPHS_PARA*)para;  // RAVI
//	T_MFW_CPHS_STATUS temp;  // RAVI
	switch(event)
	{	case E_CPHS_IND: 
			TRACE_EVENT("Getting cphs status");
			if(para != NULL)
			{	cphs_status =(* (T_MFW_CPHS_STATUS*)para);
				if (cphs_status != CPHS_OK)
				{
					/***************************Go-lite Optimization changes Start***********************/
					//Aug 16, 2004    REF: CRR 24323   Deepa M.D	
					TRACE_EVENT_P1("cphs not supported, apparently%d", cphs_status);
					/***************************Go-lite Optimization changes end***********************/
				}
				cphs_operator_name();
			}
			break;	      
		case E_CPHS_OP_NAME:	
			if(para != NULL)
			{	
				memcpy(&operator_name, para, sizeof(T_MFW_CPHS_OP_NAME));
				TRACE_EVENT("operator name callback");
				
									     
			if (operator_name.longName.data[0] == NULL)
				TRACE_EVENT("Blank long name");

			if (operator_name.shortName.data[0] == NULL)
				TRACE_EVENT("Blank short name");

			cphs_get_csp();
			}
			 break;   
		case E_CPHS_GET_VC_NUM:
		{	
			if (para!= NULL)
			{	memcpy(&cphs_voicemail_numbers, para, sizeof(T_MFW_CPHS_VC_NUM));
			/***************************Go-lite Optimization changes Start***********************/
			//Aug 16, 2004    REF: CRR 24323   Deepa M.D
			TRACE_EVENT_P1("Voicemail No %s", cphs_voicemail_numbers.entries[0].number);
			/***************************Go-lite Optimization changes end***********************/
				show_cphs_mb_numbers();
			}
			
		}
		break;
		 case E_CPHS_SET_VC_NUM:   
		{		//result of writing mailbox number
			UBYTE write_result;
			if(para != NULL)
			{	write_result = *(UBYTE*)para;
				if (write_result == MFW_SIMOP_WRITE_OK)
					ShowMessage(parent, TxtSaved, TxtNull);
				else
					ShowMessage(parent, TxtWriteError, TxtNull);//display "Write Error"
			}
		 }
		 break;
			 case E_CPHS_GET_VC_STAT:  
			 {	
				MfwHnd	idle_win =idle_get_window();
				// UBYTE line;  // RAVI
				if(para != NULL)
				{	cphs_voicemail_status = (T_MFW_CPHS_VC_STAT*)para;

					TRACE_EVENT("Getting voicemail status");
					if (cphs_voicemail_status->line1 == MFW_CFLAG_SET)
					{
    					       ShowMessage(idle_win, TxtVoicemail, TxtLine1);

    					       /* SPR#1929 - DS - Set voicemail icon on idle screen. Port of 1960 */
    					       iconsSetState(iconIdVoice);
    				      }

				
					if (cphs_voicemail_status->line2 == MFW_CFLAG_SET)
					{	
						ShowMessage(idle_win, TxtVoicemail, TxtLine2);

						/* SPR#1929 - DS - Set voicemail icon on idle screen. Port of 1960 */
    					      iconsSetState(iconIdVoice);
					}

					 /* SPR#1929 - DS - Remove voicemail icon from idle screen if 
                                  * there is no voicemail waiting on either line1/line2. Port of 1960.
                                  */
					if ( (cphs_voicemail_status->line1 != MFW_CFLAG_SET) && 
					     (cphs_voicemail_status->line2 != MFW_CFLAG_SET) )
    				      {
    				            iconsDeleteState(iconIdVoice);
    				      }

				}

			 }
			 break;
			case E_CPHS_SET_VC_STAT:  
		 
			{		//result of resetting mailbox status
				// UBYTE write_result;  // RAVI

				TRACE_EVENT("Mailbox status set");
				//Update our copy of the mailbox status
				GetCphsVoicemailStatus(0);
			}
			break;
			 case E_CPHS_GET_DV_STAT:
			 {	
				TRACE_EVENT("Getting divert status");
				if(para != NULL)
					memcpy(&call_forwarding_status, para, sizeof(T_MFW_CPHS_DV_STAT));
				{UBYTE line;
				//check for divert on active line
					line = GetAlsLine();
					//check if current outgoing line diverted
					if (line == MFW_SERV_LINE2)
						DivertStatus = GetCphsDivertStatus(MFW_SERV_LINE2);
					else//if (line == MFW_SERV_LINE1)
						DivertStatus = GetCphsDivertStatus(MFW_SERV_LINE1);

					//set the call forwarding icon 
					if (DivertStatus == MFW_CFLAG_SET)
					{
						iconsSetState(iconIdCallFor);
//  Jun 23, 2004        REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
//              Setting the Current state of CF in Flash						
						FFS_flashData.CFState=TRUE;
					}
					//gid rid of call forwarding icon 
					if (DivertStatus == MFW_CFLAG_NOTSet)
					{
						iconsDeleteState(iconIdCallFor); 
//  Jun 23, 2004        REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
//              Setting the Current state of CF in Flash						
						FFS_flashData.CFState=FALSE;
					}
//  Jun 23, 2004        REF: CRR MMI-SPR-13599  Rashmi C N(Sasken) 
//              Writng the Current state of CF into ffs						
			flash_write();
					
				}
			 }break; 
			 case E_CPHS_SET_DV_STAT:    
			 {		//result of setting divert status
				// UBYTE write_result;  // RAVI

					TRACE_EVENT("Divert status set");
					cphs_get_divert_status(); //refresh divert status

			 }
			 break;
			 case E_CPHS_GET_ALS_STATUS:  
				{	if(para != NULL)
						memcpy(&als_status, para, sizeof(T_MFW_CPHS_ALS_STATUS));
				}
				break;
			 case E_CPHS_SET_LINE: 
			 {		//result of set ALS line
				UBYTE write_result;
				if(para != NULL)
				{	write_result = *(UBYTE*)para;
					if (write_result == MFW_SIMOP_WRITE_OK)
						ShowMessage(parent, TxtChanged, TxtNull);
					if (write_result == MFW_SIMOP_WRITE_ERR)
						ShowMessage(parent, TxtWriteError, TxtNull);//display "Write Error"
				}
				cphs_get_als_info(&als_status);//refresh current line
				cphs_get_divert_status(); //refresh divert status
			 }
			 break;
			 case E_CPHS_SET_ALS_STATUS: 
			 {		//result of setting ALS status
				UBYTE write_result;
				if(para != NULL)
				{	write_result = *(UBYTE*)para;
					if (write_result == MFW_SIMOP_WRITE_OK)
						ShowMessage(parent, TxtSaved, TxtNull);
					if (write_result == MFW_SIMOP_WRITE_ERR)
						ShowMessage(parent, TxtWriteError, TxtNull);//display "Write Error"
				}
			 }
			 break;
			 case E_CPHS_GET_CSP:	
			 { if(para != NULL)
				{	memcpy(&customer_service_profile, para, sizeof(T_MFW_CPHS_CSP));
			 /***************************Go-lite Optimization changes Start***********************/
			 //Aug 16, 2004    REF: CRR 24323   Deepa M.D
			 TRACE_EVENT_P7("CSP: %x,%x,%x,%x,%x,%x,%x", customer_service_profile.csp[0], customer_service_profile.csp[1], 
				 customer_service_profile.csp[2], customer_service_profile.csp[3], customer_service_profile.csp[4], customer_service_profile.csp[5],
				 customer_service_profile.csp[6]);
			 TRACE_EVENT_P3("%x,%x,%x", customer_service_profile.csp[7], customer_service_profile.csp[8], customer_service_profile.csp[9]);
			 TRACE_EVENT_P7("CSP: %x,%x,%x,%x,%x,%x,%x", customer_service_profile.csp[10], customer_service_profile.csp[11], 
				 customer_service_profile.csp[12], customer_service_profile.csp[13], customer_service_profile.csp[14], customer_service_profile.csp[15],
				 customer_service_profile.csp[16]);
			 TRACE_EVENT_P3("%x,%x,%x", customer_service_profile.csp[17], customer_service_profile.csp[18], customer_service_profile.csp[19]);
			 /***************************Go-lite Optimization changes end***********************/
					cphs_get_info_num(1, info_num_index);
				}

			 }break;  
			 case E_CPHS_GET_INFO_NUM:
			 {	
				if(para != NULL)
				{	
					memcpy(&current_info_num, para, sizeof( T_MFW_CPHS_INFONUM_ENTRY));

					TRACE_EVENT("Getting info number");
					if (current_info_num.result !=MFW_SIMOP_READ_ERR)
						{	T_DISPLAY_DATA Dialog;
							TRACE_EVENT("Displaying num");
							/* Initialise the dialog control block with default information
							*/
							dlg_initDisplayData_TextStr( &Dialog, TxtSoftCall,  TxtSoftBack, (char*)current_info_num.alpha.data, (char*)current_info_num.number, COLOUR_STATUS);
							dlg_initDisplayData_events( &Dialog, (T_VOID_FUNC) info_num_display_cb, FOREVER, KEY_LEFT| KEY_RIGHT|KEY_CLEAR );

							/* Show the dialog
							*/
							info_dialog( parent, &Dialog );
						}
					}
				 }
			 
			 break; 
			 case E_CPHS_GET_INFO_LIST:
				{ 
					if (para == NULL)
					{	
						TRACE_EVENT("Invalid info num list");
					}
					else
					{	//populate next pointer 
					       //RAVI - 29-11-2005 
						if ((info_numbers[info_num_level] = (T_MFW_CPHS_INFONUM_LIST*) ALLOC_MEMORY(sizeof(T_MFW_CPHS_INFONUM_LIST))))
							memcpy(info_numbers[info_num_level], para, sizeof(T_MFW_CPHS_INFONUM_LIST));

						
							TRACE_EVENT("Getting info numbers!!");
							if (info_numbers[info_num_level]->count != 0)
							{
								/***************************Go-lite Optimization changes Start***********************/
								//Aug 16, 2004    REF: CRR 24323   Deepa M.D
								TRACE_EVENT_P1("Valid info num list, count:%d",info_numbers[info_num_level]->count);
								/***************************Go-lite Optimization changes end***********************/
								if (info_num_level)
								{	info_num_level++;
									InfoNumbers2();
									
								}
							}
							else
								info_numbers[info_num_level]=NULL;
					}
				}
			 break;
			 case E_CPHS_GET_SIM_FIELD:
				{	T_MFW_CPHS_READ_SIM_ENTRY temp;

					memcpy(&temp, para, sizeof(T_MFW_CPHS_READ_SIM_ENTRY));
					if (temp.data_len >0)
						//Jun 14, 2005 REF: MMI-FIX-30439 x0018858
						//begin 30439
						//temp.exchange_data[temp.data_len-1] = 0;
						//end 30439
					/***************************Go-lite Optimization changes Start***********************/
					//Aug 16, 2004    REF: CRR 24323   Deepa M.D
					TRACE_EVENT_P3("Sim Read, Field: %d (Record: %d) Errcode: %d",temp.requested_field, temp.record, temp.sim_result);
					/***************************Go-lite Optimization changes end***********************/
					/* SPR759 - SH - Read Sim for homezone, calls appropriate functions */
					#ifdef MMI_HOMEZONE_ENABLED	
						if (temp.requested_field>=HZ_SIM_PARAMETERS
							&& temp.requested_field < (HZ_SIM_CELL_CACHE+HZ_ZONES_MAX) )
						{
							homezoneReadSimCb(temp.requested_field, temp.record, temp.sim_result);
						}
					#endif
				}
			 break;

			  case E_CPHS_SET_SIM_FIELD:
				{
				T_MFW_CPHS_READ_SIM_ENTRY temp;

					memcpy(&temp, para, sizeof(T_MFW_CPHS_READ_SIM_ENTRY));
					if (temp.data_len >0)
						temp.exchange_data[temp.data_len-1] = 0;
					/***************************Go-lite Optimization changes Start***********************/
					//Aug 16, 2004    REF: CRR 24323   Deepa M.D
					TRACE_EVENT_P2("Sim Write, Requested_field: %d Errcode: %d",temp.requested_field, temp.sim_result);
					/***************************Go-lite Optimization changes end***********************/
					/* SPR759 - SH - Read Sim for homezone, calls appropriate functions */
					#ifdef MMI_HOMEZONE_ENABLED
						if (temp.requested_field>=HZ_SIM_PARAMETERS
							&& temp.requested_field < (HZ_SIM_CELL_CACHE+HZ_ZONES_MAX) )
						{
							homezoneWriteSimCb(temp.requested_field, temp.record, temp.sim_result);
						}
					#endif
				}
				break;
				
			 default: break;
				}
	

	return TRUE;
}








/*******************************************************************************

 $Function:	int InfoNumbers2( )
 $Description:	Displays info number sub-menus
 $Returns:		status int
 $Arguments:	nothing
 
*******************************************************************************/
//for sub-menus
int InfoNumbers2( )
{
	T_MFW_HND win;
    T_MFW_HND parent_win = mfw_parent(mfw_header());
    
	TRACE_FUNCTION("InfoNumbers2");
	
	if (info_numbers != NULL)
	{	type_of_list = INFO_NUM_LIST;
		win = buildInfoNumberMenu(parent_win);

		if (win NEQ NULL)
		{
			SEND_EVENT (win, E_INIT, 0, 0);
		}
	}
	
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:	buildInfoNumberMenu
 $Description:	Creates window for Information numbers
 $Returns:		window created
 $Arguments:	parent window
 
*******************************************************************************/
static T_MFW_HND  buildInfoNumberMenu( MfwHnd parent_window)
{
	T_INFO_NUM_INFO *  data = (T_INFO_NUM_INFO *)ALLOC_MEMORY (sizeof (T_INFO_NUM_INFO));
	T_MFW_WIN  * win;
	

    /*
     * Create window handler
     */

    data->numbers_win = win_create (parent_window, 0, E_WIN_VISIBLE, (T_MFW_CB)info_num_win_cb);
    if (data->numbers_win EQ NULL)
	{
	   return NULL;
	}

	TRACE_EVENT(">>>> Info num window created: " );
    /* 
     * connect the dialog data to the MFW-window
     */

    data->mmi_control.dialog = (T_DIALOG_FUNC)info_num_exec_cb;
    data->mmi_control.data   = data;
    win 		     = ((T_MFW_HDR *)data->numbers_win)->data;
    win->user		     = (void *)data;
    data->parent	     = parent_window;
	winShow(data->numbers_win);
    /*
     * return window handle
     */

     return data->numbers_win;
}

/*******************************************************************************

 $Function:	info_num_display_cb

 $Description:	Dialogue callback function of the information Numbers display window
 
 $Returns:		none

 $Arguments:	win - window handler, dialogue id, key pressed
				
 
*******************************************************************************/

void info_num_display_cb(T_MFW_HND win, USHORT identifier, UBYTE reason)
{

   // char buf [40];  // RAVI
    
	TRACE_FUNCTION ("info_num_display_cb");

      switch (reason) 
      {
	case INFO_KCD_LEFT: callNumber((UBYTE*)current_info_num.number);
	default: break;  // RAVI - Deafault corrected to default.
	
      }
}
/*******************************************************************************

 $Function:	info_num_exec_cb

 $Description:	Exec callback function of the information Numbers window
 
 $Returns:		none

 $Arguments:	win - window handler
				event - mfw event
				parameter - optional data.
 
*******************************************************************************/
void info_num_exec_cb (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
    T_MFW_WIN	   * win_data = ((T_MFW_HDR *) win)->data;
    T_INFO_NUM_INFO   * data = (T_INFO_NUM_INFO *)win_data->user;
	UBYTE i;
	UBYTE numberOfEntries;
//	ListWinInfo	 * mnu_data = (ListWinInfo *)parameter;   // RAVI
	char* Mailboxes[4];

	Mailboxes[0] = MmiRsrcGetText(TxtLine1);
	Mailboxes[1] =MmiRsrcGetText(TxtLine2);
	Mailboxes[2] = MmiRsrcGetText(TxtFax);
	Mailboxes[3] = MmiRsrcGetText(TxtData);
    TRACE_FUNCTION (">>>>> info_num_exec_cb()");
	
    switch (event)
	{
	case E_INIT:

		TRACE_EVENT(">>>> info_num_exec_cb() Event:E_INIT");

		 /* initialization of administrative data */


		data->menu_list_data = (ListMenuData *)ALLOC_MEMORY(sizeof(ListMenuData));

		if(data->menu_list_data == 0)
		{
			TRACE_EVENT("Failed memory alloc 1 ");
			return;
		}
		if (type_of_list == MAILBOX_LIST || type_of_list == MAILBOX_LIST_CALL)
			{	numberOfEntries = cphs_voicemail_numbers.count;
				if (numberOfEntries > 4)
					numberOfEntries = 4;
			}
		else
			numberOfEntries = info_numbers[info_num_level-1]->count;
		
		data->menu_list_data->List = (T_MFW_MNU_ITEM *)ALLOC_MEMORY( 4 * sizeof(T_MFW_MNU_ITEM) );

		if(data->menu_list_data->List == 0)
		{
			TRACE_EVENT("Failed memory alloc 2");
			return;
		}
		
		for (i = 0; i < numberOfEntries ; i++)
		{
			mnuInitDataItem(&data->menu_list_data->List[i]);
			if (type_of_list == MAILBOX_LIST || type_of_list == MAILBOX_LIST_CALL)
				data->menu_list_data->List[i].str  = (char *)cphs_voicemail_numbers.entries[i].alpha.data;
			else
				data->menu_list_data->List[i].str  = (char *)info_numbers[info_num_level-1]->entry[i].alpha.data;
			data->menu_list_data->List[i].flagFunc = item_flag_none; 
		}

		data->menu_list_data->ListLength =numberOfEntries;
		data->menu_list_data->ListPosition = 1;
		data->menu_list_data->CursorPosition = 1;
		data->menu_list_data->SnapshotSize = numberOfEntries;
		data->menu_list_data->Font = 0;
		if (type_of_list == MAILBOX_LIST_CALL)
			data->menu_list_data->LeftSoftKey = TxtSoftCall;
		else
			data->menu_list_data->LeftSoftKey = TxtSoftSelect;
		data->menu_list_data->RightSoftKey = TxtSoftBack;
		data->menu_list_data->KeyEvents = KEY_ALL;
		data->menu_list_data->Reason = 0;
		data->menu_list_data->Strings = TRUE;
		data->menu_list_data->Attr   = &InfoNum_menuAttrib;
		data->menu_list_data->autoDestroy    = FALSE;
		
		
		/* Create the dynamic menu window */
	    listDisplayListMenu(win, data->menu_list_data,(ListCbFunc)InfonumList_cb,0);
		  
		break;

	default:
	    break;
	}
}
/*******************************************************************************

 $Function:	InfonumList_cb

 $Description:	Callback function for the info num list.
 
 $Returns:		none
 
 $Arguments:	Parent - parent window.
				ListData - Menu item list
*******************************************************************************/

void InfonumList_cb(T_MFW_HND * Parent, ListMenuData * ListData)
{
    T_MFW_WIN	    * win_data = ((T_MFW_HDR *)Parent)->data;
    T_INFO_NUM_INFO * data     = (T_INFO_NUM_INFO *)win_data->user;	  
//	char debug[40];   // RAVI

	if ((ListData->Reason EQ LISTS_REASON_BACK) || (ListData->Reason EQ LISTS_REASON_CLEAR))
	{
	   
		listsDestroy(ListData->win);
	    InfoNum_destroy(data->numbers_win);
	    info_num_level--;
	}
	else if(ListData->Reason EQ LISTS_REASON_SELECT)
	{
		if (type_of_list == MAILBOX_LIST || type_of_list == MAILBOX_LIST_CALL) //get the correct voicemail num
		{	
			if (type_of_list == MAILBOX_LIST)
			{	/*If we're editing*/
				show_cphs_mb_number(&cphs_voicemail_numbers.entries[ListData->ListPosition]);
				memcpy(&cphs_voicemail_num, &cphs_voicemail_numbers.entries[ListData->ListPosition], sizeof(T_MFW_CPHS_ENTRY));
			}
			else
			{	char temp_number[PHB_MAX_LEN];
			
				memcpy(&cphs_voicemail_num, &cphs_voicemail_numbers.entries[ListData->ListPosition], sizeof(T_MFW_CPHS_ENTRY));
				memset(temp_number, 0, PHB_MAX_LEN);
				
				/*If we're calling the number*/ 
				//if it's an international number without a '+' 
				if (cphs_voicemail_num.ton == MFW_TON_INTERNATIONAL && cphs_voicemail_num.number[0] != '+')
				{	strcat(temp_number, "+");	//put a + in front of number
					strcat(temp_number, (char*)cphs_voicemail_num.number);
					strcpy((char*)cphs_voicemail_num.number, temp_number);
				}
				callNumber(cphs_voicemail_num.number);

			}

			
		}
		else
		{	
			//get the number/directory
				info_num_index = info_numbers[info_num_level-1]->entry[ListData->ListPosition].index;
				/***************************Go-lite Optimization changes Start***********************/
				//Aug 16, 2004    REF: CRR 24323   Deepa M.D
				TRACE_EVENT_P3("Index selected: %d, Level, %d, entryStat:%d",info_num_index, info_num_level, 
					info_numbers[info_num_level-1]->entry[ListData->ListPosition].entryStat); 
				/***************************Go-lite Optimization changes end***********************/
								if (info_numbers[info_num_level-1]->entry[ListData->ListPosition].entryStat & 0x80) //if bit 8 set
				{	TRACE_EVENT("CPHS INFO:Should be number entry");
					if (info_num_level < 4)
						cphs_select_info_num(info_num_index);
				}
				else
				{	if (info_num_level < 4)
					{	TRACE_EVENT("CPHS INFO:Should be dir entry");
					
						cphs_get_info_num(info_num_level+1, info_num_index+1);
					}
				}
					
		}	
			   
	}

	
}

/*******************************************************************************

 $Function:	InfoNum_destroy

 $Description:	Destroy the info num window.
			
 $Returns:		none

 $Arguments:	own_window- current window
*******************************************************************************/

static void InfoNum_destroy(MfwHnd own_window)
{
    T_MFW_WIN * win_data;
    T_INFO_NUM_INFO	* data;
	UBYTE numberOfEntries;
	
    TRACE_FUNCTION ("InfoNum_destroy()");
	
    if (own_window)
	{
	    win_data = ((T_MFW_HDR *)own_window)->data;
	    data = (T_INFO_NUM_INFO *)win_data->user;

	    if (data)
		{
		    /*
		     * Delete WIN handler
		     */ 
		    win_delete (data->numbers_win);

		    /*	   
		     * Free Memory
		     */
		     if (type_of_list == MAILBOX_LIST)
		    {	numberOfEntries = cphs_voicemail_numbers.count;
				if (numberOfEntries > 4)
					numberOfEntries = 4;
			}
		     else
				numberOfEntries =info_numbers[info_num_level-1]->count;
			if (data->menu_list_data != NULL)
			{	//int i; // RAVI
				FREE_MEMORY ((void *)data->menu_list_data->List, numberOfEntries * sizeof (T_MFW_MNU_ITEM));
			    FREE_MEMORY ((void *)data->menu_list_data, sizeof (ListMenuData));
			    if (type_of_list == INFO_NUM_LIST && info_num_level > 1)//if info numbers, 
				{	FREE_MEMORY((void*)info_numbers[info_num_level-1], sizeof(T_MFW_CPHS_INFONUM_LIST));
				info_numbers[info_num_level-1] = NULL;
			    }
			}
			FREE_MEMORY ((void *)data, sizeof (T_INFO_NUM_INFO));

		}
	    else
		{
		    TRACE_EVENT ("InfoNum_destroy() called twice");
		}
	}
}

/*******************************************************************************

 $Function:	info_num_win_cb

 $Description:	Window callback function for the info numbers window.
 
 $Returns:		none

 $Arguments:	w - mfw window handler
				e - mfw event
				
*******************************************************************************/

static int info_num_win_cb (MfwEvt e, MfwWin *w)    /* yyy window event handler */
{
	TRACE_EVENT ("info_num_win_cb()");
	switch (e)
	{
	case MfwWinVisible:  /* window is visible  */
		break;
	case MfwWinFocussed: /* input focus / selected	 */	
	case MfwWinDelete:   /* window will be deleted	 */   
		
	default:	    
		return MFW_EVENT_REJECTED;
	}
	return MFW_EVENT_CONSUMED;
}



