/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	Basic MMI                                                      
 $Project code:	BMI (6349)                                                           
 $Module:		PhoneBook
 $File:		    MmiBookInputWindow.h
 $Revision:		1.0                                                       
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		    25/10/00                                                      
                                                                               
********************************************************************************
                                                                              
 Description:

    This module provides the functionality for the input window of the
	phone book module.
	                    
********************************************************************************
 $History: MmiBookInputWindow.h

	25/10/00			Original Condat(UK) BMI version.	
	   
 $End

*******************************************************************************/





/*******************************************************************************
                                                                              
                                Include Files
                                                                              
*******************************************************************************/
#define ENTITY_MFW

/* includes */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif

#include "mfw_sys.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#include "mfw_lng.h"
/* SPR#1428 - SH - New Editor changes */
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_tim.h"

#include "mfw_sim.h"
#include "mfw_cm.h"
#include "mfw_nm.h"
#include "mfw_phb.h"
#include "mfw_mme.h"
#include "mfw_sat.h"
#include "mfw_sms.h"

#include "dspl.h"

#include "ksd.h"
#include "psa.h"

#include "MmiMain.h"
#include "MmiBookController.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"



#include "MmiMenu.h"
#include "mmiCall.h"
#include "Mmiicons.h"
#include "MmiIdle.h"

#include "MmiSoftKeys.h"
#include "MmiSounds.h"
#include "MmiIdle.h"
#include "MmiNetwork.h"
#include "mmiSat_i.h"
#include "MmiAoc.h"

#include "gdi.h"
#include "audio.h"

#include "cus_aci.h"
#include "mfw_ffs.h"
#include "MmiTimers.h"

#include "MmiBookShared.h"
#ifdef EASY_TEXT_ENABLED
#include "MmiChineseInput.h"
#endif

#include "mmiColours.h"
/* SPR#1428 - SH - New Editor
 * This file is obsolete with new editor and should not be compiled */
#ifndef NEW_EDITOR

#define NAME 	0
#define NUMBER  1

static int DoNextLongPress = FALSE;
static UBYTE UPPER_CASE = TRUE;
static UBYTE MODE;
extern int upCase;


/*******************************************************************************
                                                                              
                                Private Methods
                                                                              
*******************************************************************************/

/*******************************************************************************

 $Function:		bookInputDialog

 $Description:	Dialog function for the input window
 
 $Returns:		None

 $Arguments:	win, window handle
                event, event to be handled
				value, not used
				parameter, not used
 
*******************************************************************************/

static void bookInputDialog( T_MFW_HND win, USHORT event, SHORT value, void *parameter )
{
    T_MFW_WIN		*win_data	= ((T_MFW_HDR *) win)->data;
    tBookStandard	*data		= (tBookStandard *) win_data->user;
	tInputSpecifics	*properties = (tInputSpecifics *) parameter;

    TRACE_FUNCTION ("bookInputDialog()");

	/* Handle the input event, ew only deal with initialise and
	   destroy of the window in here
	*/
    switch( event )
	{
		case INPUT_INIT:
		{
			/* Initialise the input window
			*/
			data->properties.abc			= properties->abc;
			data->properties.text			= properties->text;
			data->properties.edt_attr_input	= properties->edt_attr_input;
			data->properties.left_soft_key	= properties->left_soft_key;
			data->properties.right_soft_key = properties->right_soft_key;
			data->properties.callback		= properties->callback;
            data->edt						= edtCreate( data->win, data->properties.edt_attr_input, 0, 0 );

			/* activate our editor, stopping any others before doing so
			*/
			editDeactivate();
			editActivate( data->edt, properties->abc );
			edtChar( data->edt, ecBottom );

			/* show the window
			*/
			winShow( data->win );
		}
		break;

		case INPUT_DESTROY:
		{
			/* destroy the input window
			*/
			bookInputDestroy( win );
		}
		break;
	}
}






/*******************************************************************************

 $Function:		bookInputWindowCB

 $Description:	Window event handler
 
 $Returns:		MFW_CONSUMED for the visible event, MFW_PASSED otherwise

 $Arguments:	e, event, w, window handle
 
*******************************************************************************/

static int bookInputWindowCB( MfwEvt e, MfwWin *w )
{
	tBookStandard *data = (tBookStandard *) w->user;

    TRACE_FUNCTION ("bookInputWindowCB()");

	/* Handle the visible event, otherwise return MFW_EVENT_PASSED
	*/
	switch( e )
    {
        case MfwWinVisible:
		{
			/* Window visible
			*/
		    MmiBookShowDefault();
			edtShow( data->edt );
		    PROMPT( MmiBookMenuArea().px, MmiBookMenuArea().py, 0, data->properties.text );
			softKeys_displayId(data->properties.left_soft_key, data->properties.right_soft_key, 0, COLOUR_LIST_SUBMENU);
		}
		break;

        default:
		{
			/* unabel to handle event, pass handling of event back up tree
			*/
			return MFW_EVENT_PASSED;
		}
    }

	/* if we get here, we have handled the event
	*/
    return MFW_EVENT_CONSUMED;
}






/*******************************************************************************

 $Function:		bookInputKbdCB

 $Description:	Input window keyboard handler
 
 $Returns:		MFW_EVENT_CONSUMED always, this will pass LEFT, RIGHT and CLEAR
				events back to the calling window using the installed callback
				method

 $Arguments:	e, event, k, key handle
 
*******************************************************************************/

static int bookInputKbdCB( MfwEvt e, MfwKbd *k )
{
    T_MFW_HND       win			= mfwParent( mfw_header() );
    T_MFW_WIN		*win_data	= ((T_MFW_HDR *) win)->data;
    tBookStandard	*data		= (tBookStandard *) win_data->user;

    TRACE_FUNCTION ("bookInputKbdCB()");

	/* make sure the active editor is ours
	*/
    if ( activeEditor() != data->edt )
        editActivate( data->edt, data->properties.abc );

	/* Handle the key press
	*/
    switch (k->code)
    {
		case KCD_MNUUP:
		{
			/* move right
			*/
			edtChar( data->edt, ecRight );
		}
		break;

	    case KCD_MNUDOWN:
		{
			/* move left
			*/
		    edtChar( data->edt, ecLeft );
		}
		break;

		case KCD_MNUSELECT:
	    case KCD_LEFT:
		{
			/* select the entry using the parent window callback
			*/
		    data->properties.callback( data->parent_win, INPUT_LEFT );
		   
		}
		break;

		case KCD_HUP:
		{
            /* get edit control block
			*/
            MfwEdt *edt = ( (MfwHdr *) data->edt )->data;

                data->properties.callback( data->parent_win, INPUT_CLEAR );
		}
		break;

		case KCD_RIGHT:
		{
			MfwEdt *edt = ( (MfwHdr *) data->edt )->data;
			/* select the entry using the parent windows callback
			*/
			//If we have any data input, delete the char before cursor
			if ( edt->attr->text[0] )
				edtChar( data->edt, ecBack );
			else	
			{
				data->properties.callback( data->parent_win, INPUT_RIGHT );
				displaySoftKeys_edition (TxtNull, TxtNull ,TxtNull);
				MODE = NUMBER;
			}
			 
		}
		break;

		case KCD_HASH:
		{
			/* deal with hash key 
			*/
	        edtChar( data->edt, '#' );
		}
		break;

	    case KCD_STAR:
		{
			/* deal with star key
			*/
		    edtChar( data->edt, '*' );
		}
		break;

	    default:
		{
			/* default handling for the key being pressed
			*/

			/*NM, p015a    */
			/* it is better to use these two function for different mode*/
			if (data->properties.abc EQ TRUE)
				editEventKey(e, k); /* alpha-mode*/
			else
				edtChar(data->edt ,editControls[k->code]); /*digit -mode*/

			edtShow(data->edt);
			/*p015a  end  */
			
		}
		break;
    }

	/* always consume the event
	*/
    return MFW_EVENT_CONSUMED;
}






/*******************************************************************************

 $Function:		bookInputKbdLongCB

 $Description:	Keyboard long event handler
 
 $Returns:		MFW_EVENT_CONSUMED always

 $Arguments:	e, event, k, key handle
 
*******************************************************************************/

static int bookInputKbdLongCB( MfwEvt e, MfwKbd *k )
{
    T_MFW_HND       win			= mfwParent( mfw_header() );
    T_MFW_WIN		*win_data	= ((T_MFW_HDR *) win)->data;
    tBookStandard	*data		= (tBookStandard *) win_data->user;

    TRACE_FUNCTION ("bookInputKbdLongCB()");


    /* subpress unwanted longpresses (mfw throws more than one long press event for one long press on a key)*/
    if ( e & KEY_LONG )
    {
	   	if ( DoNextLongPress EQ FALSE )
	       DoNextLongPress = TRUE; 
		else
	       DoNextLongPress = FALSE; 
    }
    if ( !DoNextLongPress )
        return MFW_EVENT_CONSUMED;      /* don't do current long press */

	

	/* Handling the long keypress events needs to deal with a 
	   number of characters in the input window, not just the
	   normal clear event
	*/
	
	/* if the event is long key clear and the buffer is not empty then
	   clear the buffer.  Otherwise if the buffer is empty then destroy
	   the input editor
	*/

	switch(k->code)
	{
		case KCD_HUP:	
		{
		    MfwEdt *edt;

			/* get edit control block
			*/
			edt = ((MfwHdr *) data->edt)->data;
	
			/* if buffer empty then kill the editor window, otherwise clear the buffer
			*/
			if ( edt->attr->text[0] )
			{
				char *c_ptr = data->properties.edt_attr_input->text;
				memset( c_ptr, '\0', strlen( c_ptr ) );
				edtReset( data->edt );
				edtShow( data->edt );
			}
			else
				bookInputDestroy( data->win );
		}
		break;

		case KCD_HASH:
			edtChar( data->edt, ecBack );
			edtChar( data->edt, 'p' );
		break;

		case KCD_0:
			edtChar( data->edt, ecBack );
			edtChar( data->edt, '+' );
		break;


		default:
		if (MODE EQ NAME)
		{
			
			if (UPPER_CASE EQ FALSE)
			{
				TRACE_EVENT("UPPER_CASE EQ FALSE");
				UPPER_CASE = TRUE;
				upCase = FALSE;	
				displaySoftKeys_edition (TxtLowercase, TxtNull ,TxtNull);														

			}
			else
			{
			    TRACE_EVENT("UPPER_CASE EQ TRUE");
				UPPER_CASE = FALSE;		
				upCase = TRUE;
				displaySoftKeys_edition (TxtUppercase, TxtNull ,TxtNull);														
			}
			edtChar(data->edt, ecBack);
		}
			break;
			
	}

	/* always handle the event
	*/
	return  MFW_EVENT_CONSUMED;
}





/*******************************************************************************

 $Function:		bookInputCreate

 $Description:	Create the input window and asociate it's handlers
 
 $Returns:		handle of new window, or NULL if failure

 $Arguments:	parent, handle of the parent window
 
*******************************************************************************/

static T_MFW_HND bookInputCreate( MfwHnd parent )
{
    T_MFW_WIN		*parent_win_data    = ( (T_MFW_HDR *) parent )->data;
    tBookStandard   *parent_data        = (tBookStandard *) parent_win_data->user;
	T_phbk			*phbk               = parent_data->phbk;
	T_MFW_WIN		*win_data;
	tBookStandard	*data;

	TRACE_FUNCTION ("bookInputCreate()");

	/* allocate memory for our control block
	*/
	if ( ( data = (tBookStandard *) ALLOC_MEMORY( sizeof( tBookStandard ) ) ) == NULL )
		return NULL;

	/* Create the window if we can
	*/
	if ( ( data->win = win_create( parent, 0, E_WIN_VISIBLE, (T_MFW_CB) bookInputWindowCB ) ) == NULL )
	{
		FREE_MEMORY( (void *)data, sizeof( tBookStandard ) );
		return NULL;
	}

	/* Okay, we have created the control block and the window, so
	   we now need to configure the dialog and data pointers
	*/
    data->mmi_control.dialog	= (T_DIALOG_FUNC) bookInputDialog;
    data->mmi_control.data		= data;
    win_data					= ((T_MFW_HDR *)data->win)->data;
 	win_data->user				= (void *) data;
	data->phbk					= phbk;
	data->parent_win			= parent;

	/* create keyboards and menus for our window
	*/
	data->kbd		= kbdCreate( data->win, KEY_ALL,            (MfwCb) bookInputKbdCB );
    data->kbd_long	= kbdCreate( data->win, KEY_ALL | KEY_LONG, (MfwCb) bookInputKbdLongCB );

	/* And return the handle of the newly created window
	*/
    return data->win;
}





/*******************************************************************************
                                                                              
                                Public Methods
                                                                              
*******************************************************************************/

/*******************************************************************************

 $Function:		bookInputStart

 $Description:	Start the input handler
 
 $Returns:		Handle of newly created window, or NULL if failure

 $Arguments:	parent, parent window handle, properties, input window property
				control block.
 
*******************************************************************************/

MfwHnd bookInputStart( MfwHnd parent,tInputSpecifics *properties )
{
	T_MFW_HND win;

	TRACE_FUNCTION ("bookInputStart()");

	/* allocate window, and if successful initialise it
	*/
	if ( ( win = bookInputCreate( parent ) ) != NULL )
		SEND_EVENT( win, INPUT_INIT, 0, properties );
	return win;
}


/*******************************************************************************

 $Function:		bookInputStartNumberEditor

 $Description:	Start the input handler using default properties
 
 $Returns:		Handle of newly created window, or NULL if failure

 $Arguments:	parent, parent window handle, buffer, input buffer
 
*******************************************************************************/

MfwHnd bookInputStartNumberEditor( MfwHnd parent, void *buffer )
{
    T_MFW_HND	    win         = parent;
    T_MFW_WIN       *win_data   = ( (T_MFW_HDR *) win )->data;
    tBookStandard   *data       = (tBookStandard *) win_data->user;
    T_phbk          *Phbk       = data->phbk;
    tInputSpecifics DefaultParameters;

	TRACE_FUNCTION ("bookInputStartNumberEditor()");
	MODE = NUMBER;
	
    /* Set up the default parameters for the input window
    */
	bookSetEditAttributes( NUMBER_EDITOR, COLOUR_EDITOR_XX, 0, edtCurBar1, 0, 
		(char *) buffer, NUMBER_LENGTH, &Phbk->edt_attr_number );

	DefaultParameters.abc               = FALSE;
	DefaultParameters.text              = TxtEnterNumber;
	DefaultParameters.edt_attr_input    = &Phbk->edt_attr_number;
	DefaultParameters.left_soft_key     = TxtSoftOK;
	DefaultParameters.right_soft_key    = TxtDelete;//Changed text
	// dunno if that changes softkey functionality
	DefaultParameters.callback          = bookAddNumberCB;

	/* allocate window, and if successful initialise it
	*/
    return bookInputStart( parent, &DefaultParameters );
}



/*******************************************************************************

 $Function:		bookInputStartNameEditor

 $Description:	Start the input handler using default properties
 
 $Returns:		Handle of newly created window, or NULL if failure

 $Arguments:	parent, parent window handle, buffer, input buffer
 
*******************************************************************************/

MfwHnd bookInputStartNameEditor( MfwHnd parent, void *buffer )
{
    T_MFW_WIN       *win_data   = ( (T_MFW_HDR *) parent )->data;
    tBookStandard   *data       = (tBookStandard *) win_data->user;
    T_phbk          *Phbk       = data->phbk;

    tInputSpecifics DefaultParameters;

	MODE = NAME;

	TRACE_FUNCTION ("bookInputStartNameEditor()");

    /* Set up the default parameters for the input window */

    /*MC 1957, name strings should use MAX_ALPHA_LEN*/
	bookSetEditAttributes( NUMBER_EDITOR, COLOUR_EDITOR_XX, 0, edtCurBar1, 0, 
		(char *) buffer, MAX_ALPHA_LEN, &Phbk->edt_attr_name );

 /*SPR 1434*/

 /*SPR 1526, changed #ifdef to #if*/
#if defined(CHINESE_MMI) && defined(EASY_TEXT_ENABLED)
/*MC, the chinese editor MUST have a unicode string as input*/
/*MC , SPR 1242 merged in from b-sample build*/
	if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
	{	T_CHINESE_DATA chinese_data;
		chinese_data.TextString = (char*) Phbk->edt_buf_name;
		if (chinese_data.TextString[0]== 0)//if, empty string
		{	chinese_data.TextString[0] = 0x80;//give string Unicode tag
			chinese_data.TextString[1] = 0x7F;
		}
		else
		{	char l_name[MAX_ALPHA_LEN];
			int ascii_len = strlen(chinese_data.TextString);
			int i;
			if (chinese_data.TextString[0]!= 0x80)/*If ASCII string*/
			{	memset(l_name, '\0', MAX_ALPHA_LEN);
				l_name[0] = 0x80;//give Unicode tag
				l_name[1] = 0x7F;	
				/*convert ascii string to unicode*/
				{	for (i =0; i < (ascii_len); i++) 
						{	if ((2+2*i+1)>=MAX_ALPHA_LEN)
								break;
							l_name[2+2*i] = 0x00; 
							l_name[2+2*i+1] = chinese_data.TextString[i]; 
						}
						if ((2+2*i+1)<=MAX_ALPHA_LEN)
						{	l_name[2+2*i] = 0x00;		//double null termination
							l_name[2+2*i+1] = 0x00;
						}
				}
				memcpy(chinese_data.TextString, l_name, MAX_ALPHA_LEN);
			}
		}
		/*MC end*/

		chinese_data.Callback = (T_EDIT_CB)bookAddNameCB;
		chinese_data.Identifier = INPUT_LEFT ;
		chinese_data.LeftSoftKey = TxtSave;
		chinese_data.DestroyEditor = TRUE;
		chinese_data.EditorSize = (USHORT)((MAX_ALPHA_LEN-4)/2);//i.e.8
		return chinese_input(parent, &chinese_data);
	}
	else
#endif
	{
		DefaultParameters.abc               = TRUE;
		DefaultParameters.text              = TxtEnterName;
		DefaultParameters.edt_attr_input    = &Phbk->edt_attr_name;
		DefaultParameters.left_soft_key     = TxtSoftOK;
		DefaultParameters.right_soft_key    = TxtDelete;//Changed text - MC
		DefaultParameters.callback          = bookAddNameCB;

		/* allocate window, and if successful initialise it
		*/
   		return bookInputStart( parent, &DefaultParameters );
	}
}



/*******************************************************************************

 $Function:		bookInputDestroy

 $Description:	Destroy Input Window
 
 $Returns:		None

 $Arguments:	Handle of window to be destroyed
 
*******************************************************************************/

void bookInputDestroy( MfwHnd window )
{
	T_MFW_WIN     *win  = ((T_MFW_HDR *) window)->data;
	tBookStandard *data = (tBookStandard *) win->user;

	TRACE_FUNCTION ("bookInputDestroy()");

	if (data)
	{
        editDeactivate();
     
		winDelete ( data->win );
		FREE_MEMORY( (void *) data, sizeof( tBookStandard ) );
	}
}

#endif /* NEW_EDITOR */

/*******************************************************************************
                                                                              
                                End of File
                                                                              
*******************************************************************************/
