#
#	Setting Directory for Layer4 Objects
#
TARID := bmi
OBJ := $(CONDAT_DIR)/obj/obj_$(TARID)

INCLAYER4 = -I$(SRCMFW)
SRCOBJ = $(ICNOBJ)

COLOUR_MMI = 0 
#
# Sim application setting
#

ifeq ($(TK),1)
COPT1 += -dSIM_TOOLKIT
else
COPT1 += -uSIM_TOOLKIT
endif

ifeq ($(WAP),1)
COPT1 += -dMMI_WAP_ENABLED
else
COPT1 += -uMMI_WAP_ENABLED
endif


#
# Support for Colour display
#	
ifeq ($(BOARD),41)
COLOUR_MMI = 1
endif

ifeq ($(BOARD),40)
COLOUR_MMI = 1
endif

ifeq ($(COLOUR_MMI),1)
COPT1 += -dCOLOURDISPLAY
else
COPT1 += -uCOLOURDISPLAY
endif

ICNOBJ =	$(OBJ)/IcnDefs.$(OBJ_TAIL) 
ifeq ($(COLOUR_MMI),1)
ICNOBJ +=	$(OBJ)/IcnNetBouygues.$(OBJ_TAIL) \
		$(OBJ)/IcnNetChinamobile.$(OBJ_TAIL) \
		$(OBJ)/IcnNetFareast.$(OBJ_TAIL) \
		$(OBJ)/IcnNetorange.$(OBJ_TAIL) \
		$(OBJ)/IcnNetSFR.$(OBJ_TAIL) \
		$(OBJ)/IcnNetsonofon.$(OBJ_TAIL) \
		$(OBJ)/IcnNetVodafone.$(OBJ_TAIL) \
		$(OBJ)/IcnNetVodafoneD2.$(OBJ_TAIL) \
		$(OBJ)/IcnNetTmobile.$(OBJ_TAIL) \
		$(OBJ)/IcnBattery.$(OBJ_TAIL) \
		$(OBJ)/IcnCipher.$(OBJ_TAIL) \
		$(OBJ)/IcnForward.$(OBJ_TAIL) \
		$(OBJ)/IcnKeylock.$(OBJ_TAIL) \
		$(OBJ)/IcnSignal.$(OBJ_TAIL) \
		$(OBJ)/IcnMessage.$(OBJ_TAIL) \
		$(OBJ)/IcnGprs.$(OBJ_TAIL) \
		$(OBJ)/IcnHomezone.$(OBJ_TAIL) \
		$(OBJ)/IcnVoicemail.$(OBJ_TAIL) \
		$(OBJ)/IcnBgdSquares.$(OBJ_TAIL) \
		$(OBJ)/icnBgdTI.$(OBJ_TAIL) \
		$(OBJ)/icnAniPhone.$(OBJ_TAIL) \
		$(OBJ)/IcnPopupBgd.$(OBJ_TAIL) \
		$(OBJ)/IcnLogoTI.$(OBJ_TAIL) \
		$(OBJ)/IcnMainApp.$(OBJ_TAIL) \
		$(OBJ)/IcnMainSet.$(OBJ_TAIL) \
		$(OBJ)/IcnMainPhb.$(OBJ_TAIL) \
		$(OBJ)/IcnMainMsg.$(OBJ_TAIL) \
		$(OBJ)/IcnMainDiv.$(OBJ_TAIL) \
		$(OBJ)/IcnMainRcl.$(OBJ_TAIL) \
		$(OBJ)/IcnMainSec.$(OBJ_TAIL) \
		$(OBJ)/IcnMainStk.$(OBJ_TAIL) \
		$(OBJ)/IcnMainWap.$(OBJ_TAIL) \
		$(OBJ)/IcnCallBackGround.$(OBJ_TAIL)
endif

		
#
# Creating icn.lib
#


$(TOP_DIR)/$(ICN_LIB) :  $(OBJ) $(SRCOBJ) 
	-$(PERL) $(CONDAT_DIR)/int/bin/make_ver.pl
	$(AR) r $(TOP_DIR)/$(ICN_LIB) $(SRCOBJ) ver.$(OBJ_TAIL)

$(OBJ):	
	mkdir $(subst /,$(SLASH),$(OBJ))
	
clean: 
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))

$(ICNOBJ): $(OBJ)/%.$(OBJ_TAIL) : $(SRCICN)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NTRACE) >> cmd
	echo -D$(NWARN) >> cmd
	echo -DTRGT_G23 >> cmd
	echo -DAUS_CONDAT_TYPE_PORTING >> cmd
	echo -DUSE_WIP_MALLOC >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo $(FDOPT) >> cmd
	echo $(INCDRV1) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICOM) >> cmd
	echo -I$(ICDG) >> cmd
	echo -I$(IAUS) >> cmd
	echo -I$(IGLE) >> cmd
	echo -I$(IAUSC) >> cmd
	echo -I$(SRCWAP) >> cmd
	echo $(INCLAYER4) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd

