#ifdef FF_GPF_TCPIP

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    AUIWap.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Some definitions and internal function prototypes for the WAP AUI.
    
                        
********************************************************************************

 $History: AUIWap.h

     xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
     Removing unwanted screens in the callback of the "New mms" dialog screen.
     Sepearted the call back funtion for the sending and receving mms info dialog screns.     

    xrashmic 17 Jul, 2005 MMI-SPR-31364
    When it is detected that a very large page is being opened, the wap adapter sends a message.
    We need to exit wap and display a error dialog as we have memory constraints.

    May 16 2005  REF:  MMI-SPR-29887  x0012849
    To Implement the deferred MMS retrieval.

    xreddymn Mar-05-2005 MMI-SPR-26144
    Added states for MMS send cancel

        xrashmic 08 Feb, 2005 MMI-SPR-27853

	 Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
	 Description: MFW memory size variable changed from U16 -> U32
	 Solution: The use of variable U16 has been replaced with U32

        xrashmic 26 Aug, 2004 MMI-SPR-23931
        
	xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42

	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/

/* Events */
//xpradipg - Aug 4:changes for WAP2.0 Menu
#define WAP_INIT 200					/* initialise WAP browser */
#define WAP_SHOW_CARD	 201			/* display the WAP card */

/* Edit modes
 *
 * Specify what to do after editing a URL.
 */

enum
{
	WAP_GOTO_URL,
	WAP_ADD_BOOKMARK,
	WAP_ADD_BOOKMARK_NAME,
	WAP_EDIT_BOOKMARK,
	WAP_EDIT_BOOKMARK_URL,
	WAP_EDIT_HISTORY,
	WAP_EDIT_HISTORY_URL,
	WAP_EDIT_HOMEPAGE,
	WAP_EDIT_APN,
	WAP_EDIT_DOWNLOAD	/* SPR#2086 - TEST */
};


/* Delete modes
 *
 * Specify what to do after delete confirmation screen.
 */

enum
{
	WAP_DELETE_BOOKMARK,
	WAP_DELETE_HISTORY,
	WAP_CLEAR_HISTORY,
	WAP_DELETE_PROFILE /* SPR#2324 - SH */
};

/* Number edit modes
 *
 * Specify what to do after a numeric edit screen
 */

enum
{
	WAP_DIALUP_NUMBER,
	WAP_IP_ADDRESS1,
	WAP_IP_ADDRESS2,
	WAP_PORT1,
	WAP_PORT2,
	WAP_RESPONSE_TIMER
//xpradipg - Aug 4,2004: changes for WAP 2.0 Menus

	,
	WAP_NAME_SERVER1,
	WAP_NAME_SERVER2


};


/* Options menu items
 *
 * These are the menu items in the options menu.
 */
 
enum
{
	WAP_ADDBOOKMARK,
	WAP_BOOKMARKS,
	WAP_GOTO,
	WAP_HOMEPAGE,
	WAP_BACK,
	WAP_RELOAD,
	WAP_EXIT,
	
	MAX_OPTIONS				/* Always have this at the end of the list */
};


/* T_WAP_BROWSER
 *
 * This structure holds all information about the wap browser window.
 */

typedef struct
{
	T_MMI_CONTROL		mmi_control;
	T_MFW_HND			parent_win;
	T_MFW_HND			win;
	T_MFW_HND			kbd;
	T_MFW_HND			kbd_long;
} T_WAP_BROWSER;

/* SPR#1816 - SH
 * T_WAP_STRING
 * Dynamically allocated string.  Used to store output text.
 */

typedef struct
{
	USHORT *text;
	USHORT length;
}
T_WAP_STRING;



/* T_WAP_PUSH_DATA
 *
 * SPR#2086 - Data storage for PUSH
 */
 
typedef struct
{
	T_MFW_HND	Sms_handler;			/* Handler for SMS */
	T_WAP_LIST	*List;
	SHORT 		list_ids[WAP_PUSH_MAX_MESSAGES];
	UBYTE		list_created;
	SHORT		service_indication;		/* The current Service Indication to be loaded */
}
T_WAP_PUSH_DATA;



/* T_WAP_DATA
 *
 * All data for WAP can be accessed through this structure.
 */
 
typedef struct
{
	T_MFW_HND			parent_win;					/* The parent window */
	T_MFW_HND			edit_win;					// ...input window
	T_MFW_HND			options_win;				// ...options window
	T_MFW_HND			sub_options_win;			/* SPR#2324 - SH - Sub-options window */
	T_MFW_HND			sub_sub_options_win;		/* SPR#2324 - SH - Sub-sub-options window */
	T_MFW_HND			menu_win;					// ...main WAP menu window
	T_MFW_HND			browser_win;				// The browser window
	T_MFW_HND			list_win;					// List window (bookmarks etc)
	ListMenuData		*list_data;					// ...and its list data
	T_MFW_HND			optionsmenu_win;			// The options menu window, accessible from browser
	ListMenuData		*optionsmenu_data;			// ...and its list data
	T_WAP_LIST			*OptionsList;				// The list of options menu items
	T_MFW_HND			temp_win;					// Temporary window pointer storage
	T_MFW_HND			connect_win;				// The "connecting" dialog window
	T_MFW_HND			error_win;					/* SPR#1739 - SH - Error dialog */			

	//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
	T_MFW_HND			mms_win;	
	int 					mms_win_type;
	//xreddymn Feb-18-2005 MMI-SPR-26144: Set to 1 when user has
    //    canceled sending MMS
	U8					mms_cancel;
    U8                  wapOutOfMem;                //xrashmic 17 Jul, 2005 MMI-SPR-31364
	T_WAP_APPLICATION	application;				/* SPR#2086 - Application type */
	T_WAP_CB			callback;					/* SPR#2086 - Function called when WAP starts up */
	
	char				*Buffer;					// Buffer for text input
	char				*Buffer2;					// Second buffer for dual input dialogs
	T_WAP_STRING		Message;					/* Buffer for text output */
	USHORT				*LeftSoftKey;				// Text for custom left soft key
	USHORT				*RightSoftKey;				// Text for custom right soft key
	char				*URLSelect;					// The current URL that is selected in a list menu
	UBYTE				OptionSelect;				// The number of the selected URL
	UBYTE				profile_store;		//xrashmic 23 Dec, 2004 MMI-SPR-27623

	UBYTE				view_id;					/* SPR#2086 - ID of the current view */
	T_WAP_VIEW			*View;						// Pointer to current view
	BOOL				connected;					// Are we connected?

	void				*gen_pointer;				// Pointer to  generic data
	BOOL				update_forbid;				// If TRUE, forbids update to the WAP browser window
	T_MFW_HND			timer;						/* SPR#1569 - SH - Mfw timer */
	UBYTE				call_waiting;				/* SPR#1850 - SH - TRUE if incoming call is waiting */

	T_WAP_PUSH_DATA		*PushData;					/* Data for WAP Push */

} T_WAP_DATA;


/* Window indicators
 *
 * These flags are used to specify which windows will be destroyed in WAP_destroy
 */

#define WAP_WIN 			0x0001
#define MENU_WIN 			0x0002
#define OPTIONS_WIN 		0x0004
#define LIST_WIN 			0x0008
#define EDIT_WIN 			0x0010
#define OPTIONSMENU_WIN   0x0020
#define BROWSER_WIN 		0x0040
#define CONNECT_WIN			0x0080

#define RETURN_TO_MENU_FLAG 0x1000
#define ALL_WAP_FLAG		0x2000

/* SPR#2086 - ALL_WIN closes all windows of the current WAP Application, but now all views */
#define ALL_WIN 			(WAP_WIN | MENU_WIN | OPTIONS_WIN | LIST_WIN | EDIT_WIN | OPTIONSMENU_WIN | BROWSER_WIN | CONNECT_WIN)
/* RETURN_TO_MENU closes all windows, but not WAP itself.  It has an extra flag */
#define RETURN_TO_MENU		(RETURN_TO_MENU_FLAG | OPTIONS_WIN | LIST_WIN | EDIT_WIN | OPTIONSMENU_WIN | BROWSER_WIN | CONNECT_WIN)
/* SPR#2086 - ALL_WAP closes all windows, destroys all views and shuts down the browser */
#define ALL_WAP (ALL_WAP_FLAG | ALL_WIN)

//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
//xrashmic 08 Feb, 2005 MMI-SPR-27853
typedef enum
{
	MMS_TYPE_NONE=0,
	MMS_TYPE_SEND_PROGRESS,
	MMS_TYPE_SEND_SUCCESS,
	MMS_TYPE_SEND_FAILED,
	MMS_TYPE_RECIEVE_PROGRESS,
	MMS_TYPE_RECIEVE_SUCCESS,
	MMS_TYPE_RECIEVE_FAILED,
	MMS_TYPE_PLEASEWAIT,
	MMS_TYPE_ERROR,
	// xreddymn Mar-05-2005: Window type for the "connecting" dialog
	MMS_TYPE_SEND_START,
	MMS_TYPE_NOTIFICATION_PROGRESS,   // x0012849 May 16 2005 for 29887
	MMS_TYPE_NOTIFICATION_RECEIVED     // x0012849 May 16 2005 for 29887
}MMS_WIN_TYPE;

/* Prototypes for functions */

void				AUI_wap_callback(UBYTE result);
T_MFW_HND			AUI_please_wait(T_MFW_HND parent_win);	/* SPR#1569 - SH - Added this function */
void				AUI_please_wait_cb(T_MFW_HND win, USHORT identifier, SHORT reason); /* SPR#1569 - SH - Added this function */
void				AUI_please_wait_destroy(void);
void				AUI_menu_create(UBYTE result);
static void			AUI_menu_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
void				AUI_download_create(UBYTE result);
static void			AUI_wap_shutdown(UBYTE result);
int					AUI_homepage(MfwMnu* menu, MfwMnuItem* item);
/* SPR#2086 - Changed return type to void */
void				AUI_create (T_MFW_HND parent_win, T_WAP_APPLICATION application, T_WAP_CB callback);
void				AUI_destroy (USHORT windows);  /* SPR#2086 */
T_WAP_DATA			*AUI_wap_data (void);
/* SPR#2086 - Removed functions associated with main WAP window */
void				AUI_connecting_dialog (ULONG status);	/* SPR#2086 */
void				AUI_connecting_dialog_cb (T_MFW_HND win, UBYTE identifier, UBYTE reason);
void 				AUI_prepare_to_connect();
void				AUI_wap_start_load_URL(UBYTE result); /* SPR#2086 - added */
T_MFW_HND			AUI_win_create (T_MFW_HND parent_win);
int					AUI_win_destroy (T_MFW_HND win);
static int			AUI_win_cb (T_MFW_EVENT event, T_MFW_WIN * win);
void				AUI_win_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
static int			AUI_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard);
static int			AUI_kbd_long_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard);
int					AUI_edit(char *shortcut, USHORT identifier, USHORT prompt, USHORT maxlen);

/* SPR#2086 - Remove window parameter*/
//static T_MFW_HND	AUI_edit_create(USHORT identifier, USHORT prompt, USHORT maxlen);
//liuyu add unicode support to follow 2112 updates
static T_MFW_HND	AUI_edit_create(USHORT identifier, USHORT prompt, USHORT maxlen, BOOL unicode);

static void			AUI_edit_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
void				AUI_list_redraw(USHORT list, USHORT TxtId); 	/* SPR#1684 - SH */
static void			AUI_list_redraw_cb(T_MFW_HND win, USHORT identifier, SHORT reason); /* SPR#1684 - SH */
static void			AUI_bookmarks_list_cb(T_MFW_HND win, ListMenuData *EntryListData);
static void			AUI_history_list_cb(T_MFW_HND parent_win, ListMenuData *EntryListData);
static void			AUI_profiles_list_cb(T_MFW_HND parent_win, ListMenuData *EntryListData);
static void			AUI_profiles_setup_cb(T_MFW_HND win, ListMenuData *EntryListData);
/* SPR#2086 - Remove win parameter */
int					AUI_entry_list (T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos);
static ListMenuData*   AUI_entry_list_create (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos);
int					AUI_entry_goto(WAP_LIST_TYPE identifier);
int					AUI_entry_delete(UBYTE identifier);
void				AUI_entry_delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason);
int					AUI_entry_sendSMS(void);
static void			AUI_profile_name_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
static void			AUI_username_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
static void			AUI_password_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
/* SPR#2086 - Removed window parameter, made static void */
static void			AUI_number_edit(int identifier, USHORT prompt);
static void			AUI_number_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
static void			AUI_error_cb(T_MFW_HND win, USHORT identifier, SHORT reason);		/* SPR#1793 - SH - Modified parameter types */
/* SPR#2086 - Remove window parameter*/
void				AUI_info_dialog(USHORT TxtId1, USHORT TxtId2);
#ifdef NEW_EDITOR
void 		AUI_standard_editor(T_AUI_EDITOR_DATA *editor_data, USHORT identifier, USHORT mode, USHORT titleId, T_AUI_EDIT_CB Callback);
#else /* NEW_EDITOR */
void			AUI_standard_editor(T_EDITOR_DATA *editor_data, char *buffer, U16 size, UBYTE mode, T_EDIT_CB callback);
#endif /* NEW_EDITOR */
static void			AUI_input_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
static void			AUI_password_cb_1(T_MFW_HND win, USHORT identifier, USHORT reason);
static void			AUI_password_cb_2(T_MFW_HND win, USHORT identifier, USHORT reason);
static void			AUI_confirm_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
static void			AUI_info_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
static void			AUI_options_menu_cb(T_MFW_HND win, ListMenuData *EntryListData);
static void			AUI_goto_cb(T_MFW_HND parent_win, USHORT identifier, USHORT reason);
void 				AUI_options_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason); /* SPR#2086 */
static USHORT		AUI_textid_to_uc(USHORT *dest, int src, USHORT destlen);
static USHORT		AUI_text_to_uc(USHORT *dest, USHORT *src, USHORT destlen);
void				AUI_wap_string_alloc(T_WAP_STRING *string, USHORT size);
void				AUI_wap_string_free(T_WAP_STRING *string);

void		AUI_error_dialog(T_WAP_VIEW *View, SHORT errorCode);
//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
void		AUI_wap_error_dialog(T_WAP_VIEW *View, SHORT errorCode);


void			AUI_wap_push_start();
void			AUI_wap_push_destroy();
void			AUI_wap_push_list_display();
void			AUI_wap_push_list_destroy();

#ifdef FF_MMI_MMS
void			AUI_mms_wap_start();
//xrashmic 08 Feb, 2005 MMI-SPR-27853
//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
 void AUI_mmssend_cb(T_MFW_HND win, USHORT identifier, USHORT reason);
 void AUI_mmsrcv_cb(T_MFW_HND win, USHORT identifier, USHORT reason);

//xrashmic 26 Aug, 2004 MMI-SPR-23931
void AUI_ems_dialog();
#endif
//xrashmic 08 Feb, 2005 MMI-SPR-27853
T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback);
static void AUI_profile_reset_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);  /* SPR#2324 - SH - added */
#else /* #ifdef FF_GPF_TCPIP */

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    AUIWap.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Some definitions and internal function prototypes for the WAP AUI.
    
                        
********************************************************************************

 $History: AUIWap.h

	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/

/* Events */

#define WAP_INIT 200					/* initialise WAP browser */
#define WAP_SHOW_CARD	 201			/* display the WAP card */

/* Edit modes
 *
 * Specify what to do after editing a URL.
 */

enum
{
	WAP_GOTO_URL,
	WAP_ADD_BOOKMARK,
	WAP_ADD_BOOKMARK_NAME,
	WAP_EDIT_BOOKMARK,
	WAP_EDIT_BOOKMARK_URL,
	WAP_EDIT_HISTORY,
	WAP_EDIT_HISTORY_URL,
	WAP_EDIT_HOMEPAGE,
	WAP_EDIT_APN
};


/* Delete modes
 *
 * Specify what to do after delete confirmation screen.
 */

enum
{
	WAP_DELETE_BOOKMARK,
	WAP_DELETE_HISTORY,
	WAP_CLEAR_HISTORY,
	WAP_DELETE_PROFILE /* SPR#2324 - SH */
};

/* Number edit modes
 *
 * Specify what to do after a numeric edit screen
 */

enum
{
	WAP_DIALUP_NUMBER,
	WAP_IP_ADDRESS1,
	WAP_IP_ADDRESS2,
	WAP_PORT1,
	WAP_PORT2,
	WAP_RESPONSE_TIMER

};


/* Options menu items
 *
 * These are the menu items in the options menu.
 */
 
enum
{
	WAP_ADDBOOKMARK,
	WAP_BOOKMARKS,
	WAP_GOTO,
	WAP_HOMEPAGE,
	WAP_BACK,
	WAP_RELOAD,
	WAP_EXIT,
	
	MAX_OPTIONS				/* Always have this at the end of the list */
};


/* T_WAP_BROWSER
 *
 * This structure holds all information about the wap browser window.
 */

typedef struct
{
	T_MMI_CONTROL		mmi_control;
	T_MFW_HND			parent_win;
	T_MFW_HND			win;
	T_MFW_HND			kbd;
	T_MFW_HND			kbd_long;
} T_WAP_BROWSER;

/*
 * T_WAP_STRING
 * Dynamically allocated string.  Used to store output text.
 */

typedef struct
{
	USHORT *text;
	USHORT length;
}
T_WAP_STRING;


/* T_WAP_DATA
 *
 * All data for WAP can be accessed through this structure.
 */
 
typedef struct
{
	T_MMI_CONTROL		mmi_control;
	T_MFW_HND			parent_win;
	T_MFW_HND			win;						/* The WAP data window (sits behind all other windows) */
	T_MFW_HND			edit_win;					/* ...input window */
	T_MFW_HND			options_win;				/* ...options window */
	T_MFW_HND			sub_options_win;			/* SPR#2324 - SH - Sub-options window */
	T_MFW_HND			sub_sub_options_win;		/* SPR#2324 - SH - Sub-sub-options window */
	T_MFW_HND			menu_win;					/* ...main WAP menu window */
	T_MFW_HND			browser_win;				/* The browser window */
	T_MFW_HND			list_win;					/* List window (bookmarks etc) */
	ListMenuData		*list_data;					/* ...and its list data */
	T_MFW_HND			optionsmenu_win;			/* The options menu window, accessible from browser */
	ListMenuData		*optionsmenu_data;			/* ...and its list data */
	T_WAP_LIST			*OptionsList;				/* The list of options menu items */
	T_MFW_HND			temp_win;					/* Temporary window pointer storage */
	T_MFW_HND			connect_win;				/* The "connecting" dialog window */
	T_MFW_HND			error_win;					/* Error dialog window */

	T_MFW_HND			main_kbd;				

	char				*Buffer;					/* Buffer for text input */
	char				*Buffer2;					/* Second buffer for dual input dialogs */
	T_WAP_STRING		Message;					/* Buffer for text output */
	USHORT				*LeftSoftKey;				/* Text for custom left soft key */
	USHORT				*RightSoftKey;				/* Text for custom right soft key */
	char				*URLSelect;					/* The current URL that is selected in a list menu */
	UBYTE				OptionSelect;				/* The number of the selected URL */
	UBYTE				profile_store;				/* SPR#2324 - SH - Temporary storage for profile ID */

	T_WAP_VIEW			*View;						/* Pointer to current view */
	BOOL				connected;					/* Are we connected? */

	void				*gen_pointer;				/* Pointer to  generic data */
	BOOL				update_forbid;				/* If TRUE, forbids update to the WAP browser window */
	T_MFW_HND			timer;						/* Mfw timer */
	UBYTE				call_waiting;				/* TRUE if incoming call is waiting */
} T_WAP_DATA;


/* Window indicators
 *
 * These flags are used to specify which windows will be destroyed in AUI_destroy()
 */

/* WAP_WIN - Shuts down the WAP application.  WARNING: will not deallocate ALL memory */
#define WAP_WIN 			0x0001

/* These are standard windows that can be destroyed */

#define MENU_WIN 			0x0002
#define OPTIONS_WIN 		0x0004
#define LIST_WIN 			0x0008
#define EDIT_WIN 			0x0010
#define OPTIONSMENU_WIN   0x0020
#define BROWSER_WIN 		0x0040
#define CONNECT_WIN			0x0080

/* ALL_WIN - This completely shuts down the WAP application and all its windows */

#define ALL_WIN 			(WAP_WIN | MENU_WIN | OPTIONS_WIN | LIST_WIN | EDIT_WIN | OPTIONSMENU_WIN | BROWSER_WIN | CONNECT_WIN)

/* RETURN_TO_MENU - This closes all windows, but not WAP itself.  It has an extra flag */

#define RETURN_TO_MENU		(0x1000 | MENU_WIN | OPTIONS_WIN | LIST_WIN | EDIT_WIN | OPTIONSMENU_WIN | BROWSER_WIN | CONNECT_WIN)


/*******************************
 * LOCAL FUNCTION PROTOTYPES *
 *******************************/

T_MFW_HND			AUI_please_wait(T_MFW_HND parent_win);
void				AUI_please_wait_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_menu_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
int					AUI_homepage(MfwMnu* menu, MfwMnuItem* item);
T_MFW_HND			AUI_create (T_MFW_HND parent_win);
T_WAP_DATA			*AUI_wap_data (void);
void				AUI_destroy (T_MFW_HND own_window, USHORT windows);
static int			AUI_cb (T_MFW_EVENT event, T_MFW_WIN * win);
static int 			AUI_main_kbd_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard);
void				AUI_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
T_MFW_HND			AUI_connecting_dialog (T_MFW_HND win, ULONG status);	
void				AUI_connecting_dialog_cb (T_MFW_HND win, UBYTE identifier, UBYTE reason);
void				AUI_connect_URL (T_MFW_HND win, char *URL);
T_MFW_HND			AUI_win_create (T_MFW_HND parent_win);
int					AUI_win_destroy (T_MFW_HND win);
static int			AUI_win_cb (T_MFW_EVENT event, T_MFW_WIN * win);
void				AUI_win_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter);
static int			AUI_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard);
static int			AUI_kbd_long_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard);
int					AUI_edit(char *shortcut, USHORT identifier, USHORT prompt, USHORT maxlen);
static T_MFW_HND	AUI_edit_create(MfwHnd parent_win, USHORT identifier, USHORT prompt, USHORT maxlen, BOOL unicode);
static void			AUI_edit_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_list_redraw(USHORT list, USHORT TxtId);
static void			AUI_list_redraw_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_bookmarks_list_cb(T_MFW_HND win, ListMenuData *EntryListData);
static void			AUI_history_list_cb(T_MFW_HND parent_win, ListMenuData *EntryListData);
static void			AUI_profiles_list_cb(T_MFW_HND parent_win, ListMenuData *EntryListData);
static void			AUI_profiles_setup_cb(T_MFW_HND win, ListMenuData *EntryListData);
static int			AUI_entry_list (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos);
static ListMenuData*   AUI_entry_list_create (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos);
int					AUI_entry_goto(WAP_LIST_TYPE identifier);
int					AUI_entry_delete(UBYTE identifier);
void				AUI_entry_delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason);
int					AUI_entry_sendSMS(void);
static void			AUI_profile_name_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason);
static void			AUI_username_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);
static void			AUI_password_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);
int					AUI_number_edit(T_MFW_HND parent_win, int identifier, USHORT prompt);
static void			AUI_number_edit_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);
static void			AUI_error_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_info_dialog(T_MFW_HND win, USHORT TxtId1, USHORT TxtId2);
#ifdef NEW_EDITOR
static void 		AUI_standard_editor(T_AUI_EDITOR_DATA *editor_data, USHORT identifier, USHORT mode, USHORT titleId, T_AUI_EDIT_CB Callback);
#else /* NEW_EDITOR */
static void			AUI_standard_editor(T_EDITOR_DATA *editor_data, char *buffer, U16 size, UBYTE mode, T_EDIT_CB callback);
#endif /* NEW_EDITOR */
static void			AUI_input_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_password_cb_1(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_password_cb_2(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_confirm_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static void			AUI_info_cb(T_MFW_HND win, USHORT identifier, SHORT reason);
static T_WAP_RES	AUI_wap_options_menu_open(UBYTE contextType);
static void			AUI_options_menu_cb(T_MFW_HND win, ListMenuData *EntryListData);
static void			AUI_goto_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);
static USHORT		AUI_textid_to_uc(USHORT *dest, int src, USHORT destlen);
static USHORT		AUI_text_to_uc(USHORT *dest, USHORT *src, USHORT destlen);
static void			AUI_wap_string_alloc(T_WAP_STRING *string, USHORT size);
static void			AUI_wap_string_free(T_WAP_STRING *string);
void				AUI_error_dialog(T_WAP_VIEW *View, SHORT errorCode);

// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32
UBYTE*				AUI_wap_memory_alloc(U32 size);
void				AUI_wap_memory_free(UBYTE* address, U32 size);
/* SPR#2324 - SH */
static void AUI_access_menu(T_MFW_HND win, USHORT identifier, SHORT reason);
static void AUI_profiles_options_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason); /* SPR#2324 - SH - added */
static void AUI_profile_change_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason); /* SPR#2324 - SH - added */
static void AUI_profile_reset_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason);  /* SPR#2324 - SH - added */

#endif /* ! #ifdef FF_GPF_TCPIP */
