#ifdef FF_GPF_TCPIP

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    AUIWap.c
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	The user interface for WAP.  Provides the required menus, lists, dialogs and
 	utilises the functionality of the ATB appropriately.
                        
********************************************************************************

 $History: AUIWap.c

	xrashmic 13 Feb, 2006 MMI-SPR-58532
	Exiting wap onreceiving pdp deactivation from the network

     xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
     Removing unwanted screens in the callback of the "New mms" dialog screen.
     Sepearted the call back funtion for the sending and receving mms info dialog screns.

    Nov 05, 2005 REF: OMAPS00044867 Sumanth Kumar.C
    Description:Delete (Softkey) remains, after clearing all the characters in Username field.
    Solution: AUI_edit_SetAltTextStr is added in the AUI_Standard_editor() with soft key back option.

    xrashmic 17 Aug, 2005 MMI-SPR-31364
    When it is detected that a very large page is being opened, the wap adapter sends a message.
    We need to exit wap and display a error dialog as we have memory constraints.

  	xreddymn Aug-03-2005 MMI-SPR-33058:
    Handling of animated GIF images with transparency

    xreddymn Jun-29-2005 MMI-ENH-32467:
    Handling of animated GIF images

    July 18 2005  REF:  MMI-SPR-32012  x0012849	
    To change the functionality of RSK , when there is no page to go back.
 
    xreddymn Jun-21-2005 MMI-SPR-30291: Send one message for the entire profile,
    instead of sending one parameter at a time, to the WAP adapter

    Jun-08-2005 MMI-SPR-30291 xreddymn: Added patches from FG

      May 11 2005  REF:  MMI-SPR-29887  x0012849
     To Implement the deferred MMS retrieval.
     
     Apr 28 2005  REF:  MMI-SPR-30400  x0012849
     To display the contents of Drop down menu correctly when a page is browsed through D sample.
 
     Apr 07 2005  REF:  MMI-SPR-27826  x0012849
     To avoid crash when a user replies to the MMS which is there in Inbox
 
    xreddymn Apr-14-2005 MMI-SPR-30224
    Modified width setting for Chinese characters

    xreddymn Apr-02-2005 MMI-SPR-29936
    Added functions to assign and remove GPRS event callback to handle GPRS
    status events when sending a MMS message

    xreddymn Mar-05-2005 MMI-SPR-26144
    Added changes for cancel sending MMS

    xrashmic 08 Feb, 2005 MMI-SPR-27853
    Error handling in sending MMS and also displaying the progress  value
       
    x0018858 8 Feb, 2005 MMI-SPR-27872
    Modified to resolve the memory leak issue. 
	
    xreddymn Jan-31-2005 MMI-SPR-28483: Support MIDI objects

    xrashmic 28 Jan, 2005 MMI-SPR-28166
    Adding support for saving plugin images
    
    xrashmic 21 Jan, 2005 MMI-SPR-28223
    Ignoring the number and scroll key events while displaying the plugin images

    xrashmic 21 Dec, 2004 MMI-SPR-27620
    The URL buffer needs to be cleared before prompting for the Name
    
    xreddymn Jan-27-2005 MMI-SPR-28135
    Added changes to redraw profile list menu on receiving a new profile
    through OTA.

    xreddymn Jan-11-2005 MMI-SPR-27618
    Added changes to hide cursor in case of read-only editor

    xrashmic 4 Jan, 2005 MMI-SPR-27874
    Description: when images less than 1 kb was downloaded through wap, 
    phone used to hang.  
    Solution: The variable used for the display of download complete was 
    not populated for images less than 1kb. 
    
       Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
       Description: MFW memory size variable changed from U16 -> U32
       Solution: The use of variable U16 has been replaced with U32

    xrashmic 23 Dec, 2004 MMI-SPR-27623
    Setting the back the original profile if user does not select it in the options menu.

    xrashmic 16 Dec, 2004 MMI-SPR-27622
    To add support for deleting and adding Profiles

        xrashmic 30 Nov, 2004 MMI-SPR-26145
        Deleting the compose and option window after sending the MMS
	
		xrashmic 29 Nov, 2004 MMI-SPR-26161
        Description: The downloaded object through wap was not visible to the MMI
        Solution: The downloaded wap object is available in the object manager 
        and can be used by the MMS

        xrashmic 05 Nov, 2004 MMI-SPR-25252
        The Bookmark names was not getting stored correctly. The 
        first chracter was neglected when data->Buffer[2] was sent
    xrashmic 14 Dec, 2004 MMI-SPR-23921
    Implementing the forward functionality for MMS

    CRR 25259: xpradipg 28 sep 2004
    Description: System restarted when deleting WAP bookmark
    Solution: When we Send the URL, the window handle assignment to 
    data->edit_win is removed since all windows after selecting send are handled
    by the sms module

	xrashmic 6 Oct, 2004 MMI-SPR-25552
	Afetr receiving MMs, information dialogs in wap were not being displayed.

    CRR 25541: 06 Oct 2004 - xpradipg
    Description: WAP: Profiles names are not displaying properly after renaming
    Solution : The address from the third character for the name buffer was
    which was required for the old editor. This has been modified for the new 
    editor and put under the flag

    CRR 25277: 06 Oct 2004 - xpradipg
    Description: Recieving an ems when inbox is open
    Solution: A refresh event is sent to the Inbox list which inturn updates 
    the list

	xreddymn Sep-13-2004, MMI-SPR-24121
	Modified string operations to fix the issue

        xrashmic 03 Sep, 2004 MMI-SPR-24395
        The bookmark and history names names was not getting stored correctly

        xrashmic 26 Aug, 2004 MMI-SPR-23931
        To display the indication of new EMS in the idle screen

	xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
	All the status screen, .i.e sending, receiving etc. are displayed separatly for the MMS module.
	Previously the WAP screens were being used. 

	14/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else  /* NEW_FRAME */

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif /* NEW_FRAME */

#include "mfw_sys.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "mfw_sms.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_cm.h"

#include "dspl.h"

#include "MmiMmi.h"
#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "mmiCall.h"

#include "MmiMenu.h"
#include "MmiSoftKeys.h"
#include "MmiResources.h"

#include "MmiBlkLangDB.h"
#include "MmiBookUtils.h"
#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else
#include "MmiEditor.h"
#endif
#include "MmiBookShared.h"
#include "ATBData.h"

#include "wapmic_types.h"

#include "ATBWapAUI.h"
#include "ATBWapACI.h"
#include "mmiSmsMenu.h"
//xrashmic 26 Aug, 2004 MMI-SPR-23931
#include "mmimmsmenu.h"
#include "MmiIdle.h"

#include "mmismssend.h"
#include "AUIWapext.h"	/* SPR#1824 - SH */
#include "AUIWap.h"
/* SPR#1574 - SH */
#ifdef MMI_GPRS_ENABLED
#include "MmiGprs.h"
#endif

#include "cus_aci.h"
#include "prim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif


#include "mmiColours.h"
#include "font_bitmaps.h"
#include "capimic.h"
//CRR 25277: 06 oct 2004
#include "mmiwindow.h"
//xrashmic 29 Nov, 2004 MMI-SPR-26161
#include "mg4def.h"

// Jun 23 2005  REF:  MMI-SPR-29887  x0012849
// This values should be same as the ones in MMS_RECEIVE_FAIL in ATBdata.h
#define MMS_RECEIVE_FAIL -25  
// Jun 23 2005  REF:  MMI-SPR-29887  x0012849
extern T_MFW_HND g_MmsBoxWin;  
// Jun 23 2005  REF:  MMI-SPR-29887  x0012849
BOOL is_downloadcancelled=FALSE;
/* Define this to trace memory allocations & freeings */
#undef TRACE_MEMALLOC

//CRR 25277: 06 oct 2004
extern MfwHnd mmsboxwinhnd;
extern UBYTE folder;
BOOL exitingWap=FALSE;//xrashmic 13 Feb, 2006 MMI-SPR-58532

//xrashmic 21 Jan, 2005 MMI-SPR-28223
BOOL pluginImageDisplayed;

//xrashmic 29 Nov, 2004 MMI-SPR-26161
int downloaded_data_size= 0;
char downloaded_data[MAX_DOWNLOAD];
extern M4_StoreDownloadedObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type);
M4_E_OBJECT_TYPE obj_Type = EMtUnknown;
//xrashmic 08 Feb, 2005 MMI-SPR-27853
extern void AUI_mms_error_dialog(SHORT errorCode);
T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback);
extern BOOL saveObjectPlugin;
extern ObjectType PluginObjectType;
ESTATUS M4_StorePluginObject(char *objbuffer, int size, M4_E_OBJECT_TYPE obj_Type );

//May 17 2005  REF:  MMI-SPR-29887  x0012849
// Called when user cancels the retrieving operation
void cancel_TMrecieve(void);
//May 17 2005  REF:  MMI-SPR-29887  x0012849
// Called when user cancels the retrieving operation
UBYTE get_urlIDget(void);  
//Jun 28 2005  REF:  MMI-SPR-29887  x0012849  
void  Delete_Body(void);  
//xrashmic 26144
void cancel_TMsend(void);
UBYTE get_urlID(void);
void MmsWAPDeactivate(void);
void mms_gprs_deattach(void);

// xreddymn Mar-05-2005 MMI-SPR-26144
// progressValue (0 to 100) is the percentage of completion of 
//    a MMS send operation
extern int progressValue;
// This is set to 1 when user has canceled a MMS send operation
UBYTE mms_cancel_status=0;

/* List menu attributes
 *
 * Needed for creating the menu.
 */

static MfwMnuAttr list_menuAttrib =
{
    &menuArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE,
    -1,
    NULL,
    0,
	COLOUR_LIST_XX, TxtNull, MNUATTRSPARE
};

/*
	SPR#2086 - SH - No need for an invisible window
	Local data handler
*/

static T_WAP_DATA *wap_mmi_data = 0;//liuyu add = 0
static BOOL wap_callActive = FALSE;

/* Set up variables and functions for tracing purposes */

#ifdef TRACE_MEMALLOC

// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32
U32 memUsed = 0;
UBYTE memTracker[110] = {0};
#endif

//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
extern int MMSactive;

//xrashmic 3 Nov, 2004 MMI-SPR-26145
extern T_MFW_HND mms_create_opt_hnd;
extern T_MFW_HND mms_create_hnd;

//xrashmic 14 Dec, 2004 MMI-SPR-23921
extern T_MFW_HND mms_Fwdcreate_hnd;
extern T_MFW_HND g_OptionsWin;
//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
extern T_MFW_HND g_MmsReadWin;
extern T_MFW_HND g_MmsExtractEdtWin;
extern T_MFW_HND MMSBox_Extract_exec_win;
/*******************************************************************************

 $Function:    	AUI_wap_init

 $Description:	Initialise WAP
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	application - Application type required
 				callback - Function to be called when WAP is started.
 
*******************************************************************************/

void AUI_wap_init(void)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_init()");
#endif

	flash_wap_init();


	AUI_wap_push_start();


	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_start

 $Description:	Start WAP
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	application - Application type required
 				callback - Function to be called when WAP is started.
 
*******************************************************************************/

void AUI_wap_start(T_WAP_APPLICATION application, T_WAP_CB callback)
{
	T_MFW_HND win;
    T_WAP_DATA *data;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_start()");
#endif
	
	AUI_create(NULL, application, callback);
    // xreddymn Feb-18-2005 MMI-SPR-26144: Update status flag for MMS cancel
    data = AUI_wap_data();
    data->mms_cancel = 0;
    //xrashmic 17 Aug, 2005 MMI-SPR-31364
    // Update the staus flag for exiting wap while trying to open huge page 
    data->wapOutOfMem=FALSE;
	return; 
}

// xreddymn Jun-28-2005 MMI-SPR-32467
/*******************************************************************************

 $Function:    	AUI_wap_get_win

 $Description:  Returns handle to browser window
 
 $Returns:      Handle to browser window

 $Arguments:    None.
 
*******************************************************************************/

T_MFW_HND AUI_wap_get_win(void)
{
    T_WAP_DATA *data;
	data = AUI_wap_data();
	if(data)
	{
		return data->browser_win;
	}
	else
	{
		return NULL;
	}
}

// xreddymn Aug-03-2005 MMI-SPR-33058
/*******************************************************************************

 $Function:    	AUI_wap_restore_background

 $Description:  Displays background color of WAP application within the
                given rectangle
 
 $Returns:      None.

 $Arguments:    (x1, y1) are the co-ordinates of the left-top corner
                (x2, y2) are the co-ordinates of the right-bottom corner
 
*******************************************************************************/

void AUI_wap_restore_background(S32 x1, S32 y1, S32 x2, S32 y2)
{
	U32 fgdColour;
	resources_setColour( COLOUR_WAP );
	fgdColour = dspl_GetBgdColour();
	dspl_SetFgdColour( fgdColour );
	if(x1 < WAP_LEFT_BORDER) 
		x1 = WAP_LEFT_BORDER;
	if(y1 < WAP_TOP_BORDER)
		y1 = WAP_TOP_BORDER;
	if(x2 > WAP_SCREEN_RIGHT)
		x2 = WAP_SCREEN_RIGHT;
	if(y2 > WAP_SCREEN_BOTTOM)
		y2 = WAP_SCREEN_BOTTOM;
	if((y2 >= y1) && (x2 >= x1))
		dspl_DrawFilledRect(x1, y1, x2, y2);
}

/*******************************************************************************

 $Function:    	AUI_wap_terminate

 $Description:	Terminate a WAP application
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	application - Application type to terminate
 				callback - Function to be called when WAP is terminated.
 
*******************************************************************************/

void AUI_wap_terminate(T_WAP_APPLICATION application, T_WAP_CB callback)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_terminate()");
#endif

	if (!data)
	{
		return;
	}

	data->application = application;
	data->callback = callback;

	switch(data->application)
	{
		case WAP_BROWSER:
			ATB_wap_change_view(WAP_OBJECT_ID);
			AUI_destroy(ALL_WIN);
			break;


		case WAP_PUSH:
			ATB_wap_change_view(WAP_PUSH_VIEW);
			AUI_destroy(WAP_WIN);
			break;


		case WAP_DOWNLOAD:
			ATB_wap_change_view(WAP_DOWNLOAD_VIEW);
			AUI_destroy(WAP_WIN);
			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_callback

 $Description:	Call WAP callback function
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	result - TRUE or FALSE
 
*******************************************************************************/

void AUI_wap_callback(UBYTE result)
{
	T_WAP_DATA *data = AUI_wap_data();
	USHORT trackIndex;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_callback()");
#endif

	if (!data)
	{
		return;
	}
	
	AUI_please_wait_destroy();

#ifdef TRACE_MEMALLOC
	for (trackIndex = 0; trackIndex<110; trackIndex++)							// Used to track memory allocations
	{
		if (memTracker[trackIndex]!=0)
		{
			TRACE_EVENT_P2("TRACKINDEX %d is %d", trackIndex, memTracker[trackIndex]);
		}
	}
#endif

	if (data->callback)
	{
		data->callback(result);//xmzhou02 should send to MMS here.
	}
	data->callback = NULL;	/* Callback only used once */

	return;
}


/*******************************************************************************

 $Function:    	AUI_menu

 $Description:	The main WAP menu
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_menu(MfwMnu* menu, MfwMnuItem* item)
{
	T_DISPLAY_DATA   display_info;
	T_DISPLAY_DATA   display_info2;
	 T_MFW_HND win = mfw_parent(mfw_header());	
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_menu");
#endif

	

	/*NM 17.6.04
	 it allows to enter the WAP connection only when the SIM 
	 read has been completed. The read access takes 25-20 second
	 otherwise the behaviour is not stabil
	*/
	if (!smsidle_get_ready_state())
	{
		TRACE_EVENT("SIM card reading is not ready yet, please wait ");
	
		dlg_zeroDisplayData(&display_info);
		display_info.LeftSoftKey	= (USHORT)TxtNull;
		display_info.RightSoftKey	= (USHORT)TxtNull;
		display_info.TextId 		= TxtPleaseWait;
		display_info.TextId2 		= TxtNull;
		display_info.displayCol 	= COLOUR_STATUS ;
		display_info.Time = SIX_SECS;
	      /*
	       * Info Screen
	       */
//	       info_dialog (win, &display_info);


		dlg_zeroDisplayData(&display_info2);
		display_info2.LeftSoftKey	= (USHORT)TxtNull;
		display_info2.RightSoftKey	= (USHORT)TxtNull;
		display_info2.TextId 		= TxtSimNot;
		display_info2.TextId2 		= TxtReady;
		display_info2.displayCol 	= COLOUR_STATUS ;
		display_info2.Time = THREE_SECS;
		
	      /*
	       * Info Screen
	       */
	         info_dialog (win, &display_info);	
		  info_dialog (win, &display_info2);
		  
	}
	else
	{
	mfwCheckMemoryLeft();
	
	/* SPR#2086 - SH - Create a WAP_BROWSER application */
	AUI_wap_start(WAP_BROWSER, (T_WAP_CB)AUI_menu_create);
	}

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_menu_create

 $Description:	When WAP is started up, this function is called to create the main menu
 				SPR#2086 - SH - Added
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void AUI_menu_create(UBYTE result)
{
	T_WAP_DATA *data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_menu_create");
#endif

	if (!result)
	{
		return;
	}

	data = AUI_wap_data();
	 
	if (!data)
	{
		return;
	}

	if (data->menu_win)
	{
		AUI_destroy(MENU_WIN);
	}
	
	//xrashmic 6 Oct, 2004 MMI-SPR-25552
	//Unset MMSactive flag as soon as we enter the Wap menu so that all error 
	//and notification screens are routed to WAP module.
	MMSactive=FALSE;
	/* SPR#2086 - No longer have main WAP window.
	 * Only create menu if parent window exists. */

	data->parent_win = bookPhonebookStart(data->parent_win, PhbkNone);
	data->menu_win = bookMenuStart(data->parent_win, WAPMenuAttributes(), 0);
	SEND_EVENT(data->menu_win, ADD_CALLBACK, NULL, (void *)AUI_menu_cb);
		
	mfwCheckMemoryLeft();
	return;
}


/*******************************************************************************

 $Function:    	AUI_please_wait

 $Description:	SPR#1569 - SH - Added this function
 				Creates a "Please Wait" message that will hang around until WAP has
 				been started

 $Returns:		

 $Arguments:	parent_win - the parent window
 
*******************************************************************************/

T_MFW_HND AUI_please_wait(T_MFW_HND parent_win)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_DISPLAY_DATA display_info;

	TRACE_FUNCTION("AUI_please_wait()");

	if (data->temp_win)
	{
		AUI_please_wait_destroy();
	}

	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtPleaseWait, TxtNull, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_please_wait_cb, 10000, 0 );
	
	data->temp_win = info_dialog(parent_win,&display_info); //information screen

	return data->temp_win;
}


/*******************************************************************************

 $Function:    	AUI_please_wait_cb

 $Description:	SPR#1569 - SH - Added this function
 				Timeout callback for the please wait window
 				SPR#1763 - SH - On timeout, exit WAP properly

 $Returns:		None.

 $Arguments:	win - the parent window
 
*******************************************************************************/

void AUI_please_wait_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data		= AUI_wap_data();		

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_please_wait_cb()");
#endif

 	if (!data)
  	{
  		return;
  	}
  	
	switch(reason)
	{
		case INFO_TIMEOUT:
			AUI_please_wait_destroy();
			AUI_destroy(ALL_WIN);/* SPR#2086 */
			info_screen(NULL, TxtTimedOut, TxtNull, NULL);
			break;
	}
}


/*******************************************************************************

 $Function:    	AUI_please_wait_destroy

 $Description:	SPR#2086 - SH - Added this function
 				Destroys the please wait window

 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void AUI_please_wait_destroy(void)
{
	T_WAP_DATA *data = AUI_wap_data();

	if (data->temp_win)
	{
		TRACE_FUNCTION("AUI_please_wait_destroy()");
		SEND_EVENT(data->temp_win, DIALOG_DESTROY, NULL, NULL);
		data->temp_win = NULL;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_start_done

 $Description:	WAP has started - can create new view
 				SPR#2086 - SH - Now copes with different types of application
 
 $Returns:		None.

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_start_done(void)
{
	T_WAP_DATA *data			= AUI_wap_data();	
	T_MMI_WAP_NEW_VIEW_IND		wap_view;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_start_done");
#endif
	
	if (!data)
	{
		return;
	}

	/* Check what type of application is required */

	switch(data->application)
	{
		case WAP_BROWSER:
			/* Check if browsing view already exists */
			if (ATB_wap_get_view(WAP_OBJECT_ID))
			{
				ATB_wap_change_view(WAP_OBJECT_ID);
				AUI_wap_new_view_done();
				return;
			}
			
			wap_view.object_id 		= WAP_OBJECT_ID;
			wap_view.uaMode			= 1;												// Specifies WML user agent
			wap_view.view_width		= WAP_SCREEN_WIDTH;									// Width of screen for browser
			wap_view.view_height	= WAP_SCREEN_HEIGHT;								// Height of screen for browser
			wap_view.font_height	= WAP_CHAR_HEIGHT;
			wap_view.unicode_height	= WAP_CHAR_HEIGHT;
			// xreddymn Apr-14-2005 MMI-SPR-30224: Chinese characters have
			// a fixed width of 12, whereas WAP_CHAR_WIDTH was defined as 6
#ifdef CHINESE_MMI
			wap_view.unicode_width	= 12;
#else
			wap_view.unicode_width	= WAP_CHAR_WIDTH;
#endif
			
			/* Get height and widths of all characters in current font */

			wap_view.font_width_length = 256;
			wap_view.font_width = (UBYTE *)AUI_wap_memory_alloc(256*sizeof(UBYTE));
			font_getAllAsciiWidths(wap_view.font_width);

			data->view_id = WAP_OBJECT_ID;
			data->View = ATB_wap_new_view(&wap_view, (void *)data); // Create the view

			AUI_wap_memory_free(wap_view.font_width, 256*sizeof(UBYTE));
			break;


		case WAP_PUSH:
			if (ATB_wap_get_view(WAP_PUSH_VIEW))
			{
				ATB_wap_change_view(WAP_PUSH_VIEW);
			}
			else
			{
				data->view_id = WAP_PUSH_VIEW;
				data->View = ATB_wap_new_view_invisible(WAP_PUSH_VIEW);
			}

			AUI_wap_callback(TRUE);
			break;

			
		case WAP_DOWNLOAD:
			if (ATB_wap_get_view(WAP_DOWNLOAD_VIEW))
			{
				ATB_wap_change_view(WAP_DOWNLOAD_VIEW);
			}
			else
			{
				data->view_id = WAP_DOWNLOAD_VIEW;
				data->View = ATB_wap_new_view_invisible(WAP_DOWNLOAD_VIEW);
			}
			AUI_wap_callback(TRUE);
			break;
#ifdef FF_MMI_MMS			
		case WAP_MMS://xmzhou02 check and create VIEW
		    TRACE_EVENT("@@@ WAP_MMS case in AUI_wap_start_done() @@@ ");
			if (ATB_wap_get_view(WAP_DOWNLOAD_VIEW))
			{
				ATB_wap_change_view(WAP_DOWNLOAD_VIEW);
			}
			else
			{
				data->view_id = WAP_DOWNLOAD_VIEW;
				data->View = ATB_wap_new_view_invisible(WAP_DOWNLOAD_VIEW);
				//newly allocated view should already been set to active view
				//ATB_wap_change_view(WAP_DOWNLOAD_VIEW);

				//ATB_mms_config();
			}
			AUI_wap_callback(TRUE);
			break;
#endif			
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_new_view_done

 $Description:	View has started
 				SPR#2086 - SH - Call application callback
 
 $Returns:		None

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_new_view_done(void)
{
	T_WAP_DATA *data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_new_view_done");
#endif
	
	if (!data)
	{
		return;
	}
	
	switch (data->application)
	{
		case WAP_BROWSER:
			AUI_wap_callback(TRUE);
			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_menu_cb

 $Description:	Callback function for the WAP menu
 
 $Returns:		None.

 $Arguments:	parent_win 	- the WAP data window
 				identifier 	- unused
 				reason		- unused
 
*******************************************************************************/

static void AUI_menu_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA *data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_menu_cb");
#endif

	if (!data)
	{
		return;
	}
	
	data->menu_win = NULL;
	if (data->parent_win)
	{
		bookPhonebookDestroy(data->parent_win);
		data->parent_win = NULL;
	}
	AUI_destroy(ALL_WIN); /* SPR#2086 */
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_homepage

 $Description:	Enter WAP browser with URL=homepage URL
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_homepage(MfwMnu* menu, MfwMnuItem* item)
{	
	T_WAP_DATA *data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_homepage");
#endif

	if (!data)
	{
		return;
	}
	
	AUI_wap_connect_URL(data->View->Profile->Homepage);	/* SPR#2086 - modified */
	
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	AUI_download

 $Description:	Create a download editor
 				SPR#2086 - TEST
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_download(MfwMnu* menu, MfwMnuItem* item)
{	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_download");
#endif

	AUI_wap_start(WAP_DOWNLOAD, (T_WAP_CB)AUI_download_create);
		
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_download_create

 $Description:	When WAP is started up for download, this function is called
 				SPR#2086 - TEST
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void AUI_download_create(UBYTE result)
{
	T_WAP_DATA *data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_download_create");
#endif

	if (!result)
	{
		return;
	}

	data = AUI_wap_data();
	 
	if (!data)
	{
		return;
	}

	AUI_edit("http://www.kongzhong.com/dxwap/2002.jpg", WAP_EDIT_DOWNLOAD, TxtEnterURL, URL_MAX_LEN);

	return;
}


/*******************************************************************************

 $Function:    	AUI_create

 $Description:	Creates a window (never shown) to which is attached all the data that
 				is used in WAP.  This is distinct from the WAP card browser window,
 				which is created dynamically.
 				SPR#2086 - SH - New arguments 'application' and 'callback'
 
 $Returns:		Pointer to the new window

 $Arguments:	parent win	- Pointer to the parent window of the data window
 				application	- Application type to start up
 				callback	- Callback function, called when WAP starts up
 
*******************************************************************************/

void AUI_create (T_MFW_HND parent_win, T_WAP_APPLICATION application, T_WAP_CB callback)
{
	T_WAP_DATA				*data;
//	T_MMI_WAP_START_IND		wap_start;	/* SPR#1842 */

	T_MMI_WAP_START_USER_AGENT_REQ wap_start;

	if (application == WAP_BROWSER)
	{
	wap_start.object_id = 1;
		wap_start.uaType = 1;
	}
	else if (application == WAP_DOWNLOAD)
	{
		wap_start.object_id = 4;
		wap_start.uaType = 4;
	}

	/* SPR#1793 - SH - Only allocate data after we've checked WAP
	 * doesn't already exist */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_create");
#endif

	/* SPR#2086 - SH - If WAP already active, go straight to create view */
	

	if (AUI_wap_data()) /*One instance of WAP already activated*/
	{
              TRACE_EVENT("@@@@ WAP stack has already initiated. @@@@");//xmzhou02
		data = AUI_wap_data();
		data->application = application;
		data->callback = callback;//xmzhou02 should be useless??? because this callback will not be called because wap already started.
		/* If we haven't yet got a parent window, use the one supplied */
		if (data->parent_win==NULL && parent_win!=NULL)
		{
			data->parent_win = parent_win;
		}
		AUI_wap_start_done();
		return;
	}

	/* Allocate WAP DATA */
	
	data = (T_WAP_DATA *)AUI_wap_memory_alloc (sizeof (T_WAP_DATA));

	if (!data)
	{
		TRACE_EVENT("** WAP memory allocation failed **");
		AUI_wap_callback(FALSE);
		return;
	}
	
	/* Store data in a static handler */
	
	wap_mmi_data = data;
	
	/* No longer need window handler */

	data->update_forbid	= FALSE;
	data->parent_win	= parent_win;

	/* Reset various window pointers */
	
	data->edit_win		= NULL;
	data->options_win	= NULL;
	data->list_win		= NULL;
	data->menu_win		= NULL;													// Indicate none of these windows exist yet
	data->browser_win	= NULL;
	data->list_data		= NULL;
	data->connect_win	= NULL;
	data->error_win		= NULL;		/* SPR#1739 - SH */
	data->temp_win		= NULL;		/* SPR#2086 - SH */
	data->call_waiting	= FALSE;	/* SPR#1850 - SH */
	
	//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
	//These mms_win and mms_win_type would hold the current mma status/error screen information
	data->mms_win=NULL;
	data->mms_win_type=0;
	
	/* SPR#1684 - SH - Removed customised menu area */
		
	/*	Allocate memory for some strings.  SPR#1816 - SH - Unicode */
	
	data->Buffer		= (char *)AUI_wap_memory_alloc ((INPUT_MAX_LEN+1)*sizeof(USHORT));	// Input buffer 1
	data->Buffer2		= (char *)AUI_wap_memory_alloc ((INPUT_MAX_LEN+1)*sizeof(USHORT));	// Input buffer 2
	data->Message.text	= NULL;
	data->Message.length = 0;
	data->LeftSoftKey	= (USHORT *)AUI_wap_memory_alloc ((SOFTKEY_MAX_LEN+2)*sizeof(USHORT));	// Left softkey text
	data->RightSoftKey	= (USHORT *)AUI_wap_memory_alloc ((SOFTKEY_MAX_LEN+2)*sizeof(USHORT));	// Right softkey text

	/* Create list for options menu
	 * SPR#1816 - SH - Added unicode parameter */
	
	data->OptionsList	= ATB_wap_entry_list_create(WAP_OPTIONS_LIST, MAX_OPTIONS+1, OPTIONS_MAX_LEN, TRUE);	// Options menu list

	data->PushData = NULL;	/* SPR#2086 - SH - Create push data when needed */


	/* Generate "Please wait" window while WAP starts up
	 * SPR#2086 - SH - Don't generate window if there is no parent */

	if (data->parent_win)
	{
		AUI_please_wait(data->parent_win); /* SPR#2086 */
	}
	
	data->View = NULL;

	/* SPR#2086 - SH - Store WAP application type and callback */
	data->application = application;
	data->callback = callback;
//xrashmic 13 Feb, 2006 MMI-SPR-58532
#ifdef MMI_GPRS_ENABLED
	GPRS_SetCallback(parent_win, (T_GPRS_CB)AUI_wap_gprs_cb);
#endif /* MMI_GPRS_ENABLED */
	/* SPR#1842 - SH - Removed timer for WAP startup */

	ATB_wap_start(&wap_start);
	exitingWap=FALSE;//xrashmic 13 Feb, 2006 MMI-SPR-58532
	return;

}


/*******************************************************************************

 $Function:    	AUI_wap_data

 $Description:	Returns the WAP data pointer
 
 $Returns:		Pointer to WAP data

 $Arguments:	None
 
*******************************************************************************/

T_WAP_DATA *AUI_wap_data (void)
{
	if (wap_mmi_data==NULL)
	{
		TRACE_EVENT("** WAP not active **");
	}

	return wap_mmi_data;
}


/*******************************************************************************

 $Function:    	AUI_destroy

 $Description:	Destroys the specified WAP windows and their data
 				SPR#2086 - No need for "win" parameter
 
 $Returns:		void

 $Arguments:	windows		- determines which windows will be destroyed.
 				(e.g. LIST_WIN | EDIT_WIN | OPTIONS_WIN | WAP_WIN)
 
*******************************************************************************/
void AUI_destroy(USHORT windows)
{
	T_WAP_DATA *data		= AUI_wap_data();
	USHORT				entryIndex;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_destroy");
#endif
    
	if (data==NULL)
	{
		TRACE_EVENT("*** Could not destroy data ***");
		return;
	}
	
	/* SPR#1850 - SH - If we are closing the browser or exiting WAP, disconnect the call */

	if ((windows & WAP_WIN) || (windows==RETURN_TO_MENU))
	{		
		exitingWap=TRUE;//xrashmic 13 Feb, 2006 MMI-SPR-58532

		if (data->View)
		{
			/* SPR#2086 - Cancel a pending download */
			
			if (data->View->object_id==WAP_OBJECT_ID)
			{
				ATB_wap_stop_download(data->View);
			}

			/* SPR#2086 - Cancel a pending content download */
			
			else if (data->View->object_id==WAP_DOWNLOAD_VIEW)
			{
				ATB_wap_content_cancel(WAP_DOWNLOAD_ID);
			}

			/* End the call */
			
			AUI_end_call(data->View->cId);
		}
		else
		{
			AUI_end_call(0);
		}
	}
		
	/* Check to see if WAP Browser Window should be destroyed */
	
	if ((windows & BROWSER_WIN) && (data->browser_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy browser");
#endif

		/* Destroy the browser window */
		
		AUI_win_destroy(data->browser_win);
		data->browser_win = NULL;

		/* SPR#1824 - SH - No longer destroy error dialog or change
		 * connection status here */
		 
		/* SPR#1794 - SH - Write history list to FFS */
		
		ATB_wap_profile_save(data->View);
	}

	/* SPR#1189 - SH - Can destroy connect window explicitly
	   Check to see if Connection Dialog should be destroyed */
    	
	if ((windows & CONNECT_WIN) && (data->connect_win != NULL))													// Destroy "connecting" window
	{
		SEND_EVENT(data->connect_win,DIALOG_DESTROY,0,0);
		data->connect_win = NULL;
	}

	/* Check to see if WAP Main Menu should be destroyed */
		
	if ((windows & MENU_WIN) && (data->menu_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy menu");
#endif
		bookMenuDestroy(data->menu_win);
		data->menu_win = NULL;
		if (data->parent_win)
		{
			bookPhonebookDestroy(data->parent_win);
			data->parent_win = NULL;
		}
	}

	/* Check to see if Options Menu should be destroyed */
	
	if ((windows & OPTIONSMENU_WIN) && (data->optionsmenu_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy optionsmenu");
#endif
		/* WAP page can now update */

		data->update_forbid = FALSE;
		
		/* Remove all options list entries */
		
		for (entryIndex=0; entryIndex<(data->OptionsList->no_of_entries); entryIndex++)
		{
			if (data->OptionsList->Entry[entryIndex]!=NULL)
			{
				/* SPR#1816 - SH - All entries now the same length */
				AUI_wap_memory_free((UBYTE *)data->OptionsList->Entry[entryIndex], (SOFTKEY_MAX_LEN+1)*sizeof(USHORT));  // Destroy each entry
				data->OptionsList->Entry[entryIndex] = NULL;
			}
		}

		/* Destroy the list itself */
		
		if (data->optionsmenu_data)
		{
			AUI_wap_memory_free((UBYTE *)data->optionsmenu_data->List, (data->optionsmenu_data->ListLength)*sizeof(T_MFW_MNU_ITEM)); 
			AUI_wap_memory_free((UBYTE *)data->optionsmenu_data, sizeof(ListMenuData));
			data->optionsmenu_data = NULL;
		}
		
		listsDestroy(data->optionsmenu_win);
		data->optionsmenu_win = NULL;
	}

	/* Check to see if List Window should be destroyed */
	
	if ((windows & LIST_WIN) && (data->list_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy list");
#endif
		if (data->list_data)
	{
			AUI_wap_memory_free((UBYTE *)data->list_data->List, (data->list_data->ListLength)*sizeof(T_MFW_MNU_ITEM));
			AUI_wap_memory_free((UBYTE *)data->list_data, sizeof(ListMenuData));
			data->list_data = NULL;												// Destroy menu items list
		}
		listsDestroy(data->list_win);											// Same for list window
		data->list_win = NULL;


		/* SPR#2086 - Destroy the list of pushed messages, if it exists */
		if (data->PushData)
		{
			AUI_wap_push_list_destroy();
		}

	}

	/* Check to see if Options Window should be destroyed */
		
	if ((windows & OPTIONS_WIN) && (data->options_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy options");
#endif
		bookMenuDestroy(data->options_win);
		data->options_win = NULL;
              //CRR 25541: 06 oct 2004 - xpradipg
              //The sub_options window of profiles list needs to be destroyed before
              //displaying the profile list again.
              if(data->sub_options_win)
              {
                  bookMenuDestroy(data->sub_options_win);
                  data->sub_options_win = NULL;
              }
	}

	/* Check to see if Editor should be destroyed */
		
	if ((windows & EDIT_WIN) && (data->edit_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy editor");
#endif
		//editor_destroy(data->edit_win);
#ifdef NEW_EDITOR
                    AUI_edit_Destroy(data->edit_win);
#else /* NEW_EDITOR */
                    editor_destroy(data->edit_win);
#endif /* NEW_EDITOR */

		data->edit_win = NULL;
	}

	/* Check to see if WAP Application should be destroyed */
		
	if (windows & WAP_WIN)														// Destroy WAP data win (exiting WAP)
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy WAP");
#endif
		
		/* SPR#1739 - SH - Destroy the error dialog if it exists */

		if (data->error_win)
		{
			SEND_EVENT(data->error_win, DIALOG_DESTROY, 0, 0);
			data->error_win = NULL;
		}
		
		/* SPR#1569 - SH - Destroy now happens in stages
		 * Display "Please wait" dialog; WAP destroy will complete on callback
		 * SPR#1824 - SH - Now only create please wait if it doesn't exist
		 * SPR#2086 - SH - Don't create please wait if there is no parent win */

		if (!data->temp_win && data->parent_win!=NULL)
		{
			AUI_please_wait(data->parent_win);
		}
		
		/* SPR#1824 - SH - If there's a view around, prepare the cache to shut down */

		if (data->View)
		{

			/* SPR#2086 - SH - destroy push data if it exists, and if we're destroying a push view */
			if (data->View->object_id==WAP_PUSH_VIEW && data->PushData)
			{
				AUI_wap_push_destroy();
			}


			/* Set status to shutting down */
			ATB_wap_status_change(data->View, ATB_WAP_SHUTTING_DOWN);

			if (windows==ALL_WAP)
			{
				TRACE_EVENT("SHUTTING DOWN EVERYTHING");
				/* Here we override the callback function - this is an emergency shutdown,
				 * instigated by the WAP application rather than by the user */

				 data->callback = (T_WAP_CB) AUI_wap_shutdown;
			}
		}

		ATB_wap_destroy();
	}

	/* SPR#2086 - SH - No longer need to recreate menu */
	
#ifdef TRACE_AUIWAP
	TRACE_EVENT("AUI_destroy end");
#endif

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_cache_prepare_done

 $Description:	Cache is prepared for WAP_TERMINATE
 				SPR#2086 - Simplify
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_cache_prepare_done(void)
{
	TRACE_FUNCTION("AUI_wap_cache_prepare_done()");

	ATB_wap_destroy();

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_close_view_done

 $Description:	SPR#1569 - SH - Added this function
 				Called when a view has been closed
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_close_view_done(void)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_close_view_done");
#endif

	if (!data)
	{
		return;
	}

	/* If we've destroyed all the views, then prepare the cache for shutdown */
	
	if (data->view_id==WAP_NO_VIEW)
	{
		ATB_wap_cache_prepare();
	}

	/* Otherwise, we've closed down everything necessary */
	else
	{
		AUI_wap_callback(TRUE);
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_terminate_done

 $Description:	SPR#1569 - SH - Added this function
 				Called when a WAP termination is complete
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_terminate_done(void)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_WAP_CB callback;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_terminate_done");
#endif

	if (!data)
	{
		return;
	}

	AUI_please_wait_destroy();
	
	if (data->Buffer)
		AUI_wap_memory_free ((UBYTE *)data->Buffer, (INPUT_MAX_LEN+1)*sizeof(USHORT));	// Delete input buffer 1

	if (data->Buffer2)
		AUI_wap_memory_free ((UBYTE *)data->Buffer2, (INPUT_MAX_LEN+1)*sizeof(USHORT));	// Delete input buffer 2

	AUI_wap_string_free(&data->Message);		/*Delete output buffer */

	if (data->LeftSoftKey)
		AUI_wap_memory_free ((UBYTE *)data->LeftSoftKey, (SOFTKEY_MAX_LEN+2)*sizeof(USHORT));  // Delete left softkey text

	if (data->RightSoftKey)
		AUI_wap_memory_free ((UBYTE *)data->RightSoftKey, (SOFTKEY_MAX_LEN+2)*sizeof(USHORT)); // Delete right softkey text

	if (data->OptionsList)
		ATB_wap_entry_list_destroy(data->OptionsList);							// Destroy options menu list
	
	/* Before we destroy data, store callback function */

	callback = data->callback;

	/* Destroy WAP data */
	
    wap_mmi_data = 0;
	AUI_wap_memory_free ((UBYTE *)data, sizeof (T_WAP_DATA));				// Destroy main data structure

	/* Call callback to notify caller that WAP is closed */

	if (callback)
	{
		callback(TRUE);
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_shutdown

 $Description:	Callback function called when a view is shut down.  For this case, all
 				views must be destroyed, so continue with shutdown process
 				SPR#2086 - Added
 
 $Returns:		None

 $Arguments:	result - The result of the view shutdown
 
*******************************************************************************/

static void AUI_wap_shutdown(UBYTE result)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_shutdown");
#endif

	if (!result)
	{
		return;
	}

	/* If there are still views to shut down, do so */
	
	ATB_wap_destroy();

	return;
}


/* SPR#2086 - Removed functions associated with main WAP window */

/*******************************************************************************

 $Function:    	AUI_connecting_dialog

 $Description:	Show "Connecting..." dialog (displayed while sending configuration
 				information to WAP gateway)
 				SPR#2086 - Remove window parameter, no longer return window
 
 $Returns:		Window handler

 $Arguments:	status - The status to display
 
*******************************************************************************/

void AUI_connecting_dialog (ULONG status)
{
	T_WAP_DATA *data		= AUI_wap_data();
	T_DISPLAY_DATA		display_info;
	int					timer;
	T_MFW_EVENT			keyEvents;
	
#ifdef TRACE_AUIWAP		
	TRACE_FUNCTION("AUI_connecting_dialog");
#endif

	if (!data)
	{
		return;
	}
	
	
	/* SPR#1982 - SH - Standard values for events */
	
	timer = FOREVER;
	keyEvents = KEY_CLEAR | KEY_RIGHT;

	switch(status)
	{
		case ATB_WAP_ATTACHING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtAttaching, TxtGPRS, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_LOGGING_IN:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtConnecting, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_CONNECTING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtLoggingIn, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_CARD_READING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtDownloading, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN+1);	/* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Title, CARD_TITLE_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;			// Show name of card being read
			break;

		case ATB_WAP_DOWNLOADING:
			/* SPR#2086 - Show "loading" message if we're downloading content */
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtDownloading, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN+1);	/* +1 space for 0x80 */
			if (data->Message.text[0]!=0x7F80)
			{
	 			data->Message.text[0] = 0x7F80;
				ATB_uc_text_copy(&data->Message.text[1], data->View->Title, CARD_TITLE_MAX_LEN);
			}
			else
			{
				ATB_uc_text_copy(data->Message.text, data->View->Title, CARD_TITLE_MAX_LEN);
			}
			display_info.TextString2 = (char *)data->Message.text;			// Show name of card being read
			break;

		case ATB_WAP_DEACTIVATING:
			/* SPR#1982 - SH - Waiting for context to deactivate, dialog with no cancel button */
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtPleaseWait, TxtNull, COLOUR_WAP_POPUP);
			timer = TEN_SECS;
			keyEvents = 0;
			break;

		case ATB_WAP_PLEASE_WAIT:
		default:
			dlg_initDisplayData_TextId(&display_info, TxtNull, TxtCancel, TxtPleaseWait, TxtNull, COLOUR_WAP_POPUP);
			break;
	}
	
	/* Destroy any previous dialog */
		
	AUI_destroy(CONNECT_WIN); /* SPR#2086 */
	
	/* Create new dialog */
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_connecting_dialog_cb, timer, keyEvents );

	/* SPR#2086 - Automatically assign connect_win */
	
	data->connect_win = info_dialog(data->parent_win, &display_info);

	return;
}


/*******************************************************************************

 $Function:    	AUI_connecting_dialog_cb

 $Description:	Callback function for connecting dialog
 
 $Returns:		void

 $Arguments:	win			- pointer to the WAP data window
 				identifier	- identifies function that has called callback
 				reason		- reason for callback
 
*******************************************************************************/

void AUI_connecting_dialog_cb (T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
   T_WAP_DATA *data		= AUI_wap_data();
   
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connecting_dialog_cb");
#endif

	/* SPR#1739 - SH - This should be set to NULL in all cases */
	
	data->connect_win = NULL;

	/* SPR#1816 - SH - Free memory allocated for status message */
	
	AUI_wap_string_free(&data->Message);
				
	switch(reason)
		{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:													// "Cancel" exits browser
			/* SPR#1189 - SH - If browser is active, completely exit WAP.
			 * Otherwise, just return to last menu. */
			 
			if (data->browser_win)
			{
				AUI_destroy(RETURN_TO_MENU);	/* SPR#2086 */
			}
			else
			{
				/* SPR#2086 - Cancel download */
				
				if (data->View->object_id==WAP_OBJECT_ID)
				{
					/* Cancel any pending operation */
					ATB_wap_stop_download(data->View);
				}
				else if (data->View->object_id==WAP_DOWNLOAD_VIEW)
				{
					ATB_wap_content_cancel(WAP_DOWNLOAD_ID);
				}
				
				/* End the call.  SPR#1850 - SH - Provide function with the call ID */
				AUI_end_call(data->View->cId);	
				/* SPR#1982 - SH - Indicate we're no longer connected */
				if (!ATB_wap_status_get(data->View, ATB_WAP_DEACTIVATING))
				{
					ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
				}
			}
		break;

		default:
		break;
		}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_connect_URL

 $Description:	Connects to WAP gateway (if required) and starts to download URL
 				SPR#2086 - removed 'win' parameter
 				- Factored common tasks into following functions
 
 $Returns:		void

 $Arguments:	URL		- URL to connect to
 
*******************************************************************************/

void AUI_wap_connect_URL(char *URL)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_WAP_VIEW *View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_connect_URL");
#endif

	if (!data)
	{
		return;
	}
	//xrashmic 21 Jan, 2005 MMI-SPR-28223
	//Unsetting this flag when we lauch a new URL
	pluginImageDisplayed=FALSE;

	/* Store URL to access later */

	strcpy(data->Buffer, URL);
	
	/* Check if browsing view exists.  If it doesn't, start WAP for
	 * browsing and load URL on callback */
	 
	View = ATB_wap_get_view(WAP_OBJECT_ID);

	if (!View)
	{
		AUI_wap_start(WAP_BROWSER, AUI_wap_start_load_URL);
	}
	else
	{
		AUI_wap_start_load_URL(TRUE);
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_prepare_to_connect

 $Description:	Gets ready to initiate a WAP connection
 				SPR#2086 - Added
 
 $Returns:		None

 $Arguments:	None
 
*******************************************************************************/

void AUI_prepare_to_connect()
{
	T_WAP_DATA *data = AUI_wap_data();

	if (!data)
	{
		return;
	}
	
	/* Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	/* If the browser is already visible, we can destroy the other windows */
	
	if (data->browser_win)
	{
		AUI_destroy(LIST_WIN | OPTIONSMENU_WIN | EDIT_WIN | OPTIONS_WIN); /* SPR#2086 */
	}
	
	 /* Display "Please Wait" if browser is not open */
	   
	if (!data->browser_win || !data->connected)
	{
		ATB_wap_status_change(data->View, ATB_WAP_PLEASE_WAIT);
	}

	/* If we're not already connected, send config data */
	
	if (!data->connected)
	{
		ATB_wap_profile_send(data->View);
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_start_load_URL

 $Description:	Callback function for starting WAP and loading a URL
 				SPR#2086 - SH - Added
 
 $Returns:		void

 $Arguments:	result - TRUE if WAP started successfully.
 
*******************************************************************************/

void AUI_wap_start_load_URL(UBYTE result)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_push_start_load_URL");
#endif

	if (!data || !result)
	{
		return;
	}

	/* Prepare to connect */
	
	AUI_prepare_to_connect();

	/* Copy URL into View storage */
	
	strcpy(data->View->URL, data->Buffer);

	/* Send event requesting URL download */
	
	ATB_wap_download_url(data->View, data->View->URL, TRUE);

	/* Destroy some windows for now; we want to return to the list win
	 * if the connection is cancelled */
	 
	AUI_destroy(OPTIONS_WIN | EDIT_WIN); /* SPR#2086 */

	return;
}


/*******************************************************************************

 $Function:    	AUI_win_create

 $Description:	Create the WAP card browser window
 
 $Returns:		void

 $Arguments:	parent_win			- Pointer to the WAP data window

*******************************************************************************/

T_MFW_HND AUI_win_create (T_MFW_HND parent_win)
{
	T_MFW_WIN	*win_data;
	T_WAP_BROWSER	*browser_data = (T_WAP_BROWSER *)AUI_wap_memory_alloc(sizeof(T_WAP_BROWSER)); 	// WAP browser data

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_create");
#endif

	// xreddymn Jun-28-2005 MMI-SPR-32467
	browser_data->win = win_create(parent_win, 0, E_WIN_VISIBLE | E_WIN_SUSPEND, (T_MFW_CB)AUI_win_cb);	// Create the browser window

	/* Create keyboard handler */
	browser_data->kbd		= kbd_create (browser_data->win, KEY_ALL, (T_MFW_CB)AUI_kbd_cb);
	browser_data->kbd_long	= kbd_create (browser_data->win, KEY_ALL|KEY_LONG, (T_MFW_CB)AUI_kbd_long_cb);

	/* Create window handler */
	
	browser_data->mmi_control.dialog	= (T_DIALOG_FUNC)AUI_win_control;
	browser_data->mmi_control.data		= (void *)browser_data;
	browser_data->parent_win			= parent_win;
	win_data					= ((T_MFW_HDR *)browser_data->win)->data;
	win_data->user				= (void *)browser_data;									// Attach browser data to window

	return browser_data->win;
}


/*******************************************************************************

 $Function:    	AUI_win_destroy

 $Description:	Destroy the WAP card browser window
 
 $Returns:		void

 $Arguments:	win				- Pointer to the WAP browser window

*******************************************************************************/

int AUI_win_destroy (T_MFW_HND win)
{
	T_MFW_WIN			*win_data 	= ((T_MFW_HDR *)win)->data;
	T_WAP_BROWSER		*data		= (T_WAP_BROWSER *)win_data->user;			// WAP browser data

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_destroy");
#endif

	kbd_delete(data->kbd);														// Delete keyboard handlers
	kbd_delete(data->kbd_long);
	
	win_delete(win);															// Delete window
	AUI_wap_memory_free((UBYTE *)data, sizeof(T_WAP_BROWSER));					// Destroy data structure

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_win_control

 $Description:	Dialog function for WAP Browser window
 
 $Returns:		void

 $Arguments:	win			- WAP card browser window
 				event		- Window handle event
 				value		- not used
 				parameter	- not used

*******************************************************************************/

void AUI_win_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
	T_MFW_WIN		*win_data			= ((T_MFW_HDR *)win)->data;
	T_WAP_BROWSER	*data				= (T_WAP_BROWSER *)win_data->user;		// WAP Browser data

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_control");
#endif

	switch (event)
	{
		case WAP_INIT:															// Currently does nothing
			break;
		
		case WAP_SHOW_CARD:														// Show the current card
			win_show(win);
		break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_win_cb

 $Description:	Callback function for browser window
 
 $Returns:		void

 $Arguments:	event		- window handle event
 				win			- WAP browser window
 				
*******************************************************************************/

static int AUI_win_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_cb");
#endif

   	if (!data)
	{
		return NULL;
	}
	
    if (data->update_forbid)
    {
    	return NULL;
	}
	
    switch (event)
	{
		case E_WIN_VISIBLE:
	    	if (win->flags & E_WIN_VISIBLE)
			{
		     	resources_setColour( COLOUR_WAP );
		    	dspl_ClearAll(); 												// Clear the browser area

				/* SPR#2086 - TEST CODE - If we are downloading,
				 * display total amount of data downloaded */

			//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
			//The following screen should not be displayed for the MMS downloaing or sending scenario.
		    	if ((data->View->object_id!=WAP_OBJECT_ID) && !MMSactive)
		    	{
		    		dspl_TextOut(0,0,DSPL_TXTATTR_SIGNED_COORDS, (char *)data->View->Title);
		    		resources_setSKColour( COLOUR_WAP );
		    		displaySoftKeys(TxtExit, TxtEnterURL);
					return 1;
		    	}
		    	
		    	ATB_wap_buffer_display(data->View);								// Display the buffered page
		     	resources_setSKColour( COLOUR_WAP );

				/* SPR#1575 - SH - Display "Cancel" when downloading or reading in a card */
		    	if (ATB_wap_status_get(data->View, ATB_WAP_DOWNLOADING)
		    		|| ATB_wap_status_get(data->View, ATB_WAP_CARD_READING))
	    		{
		    		displaySoftKeys(TxtNull, TxtCancel);
	    		}
		    	else
	    		{
		    		if (data->View->CustSoftKeys)
		    		{
		    			/* SPR#1816 - SH - Unicode */
		    			displayCustSoftKeys((char *)data->LeftSoftKey, (char *)data->RightSoftKey);
		    		}
					else
					{
						if (data->View->CanGoBack)
							displaySoftKeys(TxtSoftOptions, TxtSoftBack);		// Show "options" and "back"
						else
							displaySoftKeys(TxtSoftOptions, TxtNull);			// Only show "options" if we can't go back
					}
				}
    		}
			break;

		// xreddymn Jun-28-2005 MMI-SPR-32467
		case E_WIN_SUSPEND:
			TRACE_EVENT("E_WIN_SUSPEND");
			ATB_animated_GIF_clear();
			break;

		default:
	    	return 0;
	}
    return 1;
}


// July 13 2005  REF:  MMI-SPR-32012  x0012849
// To change the functionality of RSK, when there is no page to go back
/*******************************************************************************

 $Function:    	ExitWAP

 $Description:	 The functionality is same as when we press HANG UP Key. 

 $Returns:      Nothing

 $Arguments:	None
*******************************************************************************/

void ExitWAP(BOOL value)
{
     T_WAP_VIEW *View;
     T_WAP_DATA 		*data		= AUI_wap_data();
     View = data->View;         
     //xrashmic 17 Aug, 2005 MMI-SPR-31364
     //Exiting due to out of memory
    if(WAP_OUT_OF_MEM==value)      
        data->wapOutOfMem=TRUE;
    else
        data->wapOutOfMem=FALSE;
    ATB_wap_stop_download(View);
    AUI_wap_string_free(&data->Message); 
    AUI_destroy(RETURN_TO_MENU);	
    return;     	
}

/*******************************************************************************

 $Function:    	AUI_kbd_cb

 $Description:	Keyboard event handler for browser window

 $Returns:		status int

 $Arguments:	event			- window handle event
 				keyboard		- keyboard control block

*******************************************************************************/

static int AUI_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard)
{	
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_kbd_cb");
#endif

	if (!data)
	{
		return NULL;
	}

	View = data->View;

	/* SPR#2086 - TEST CODE - Soft keys to control download
	 * screen */
	if (View->object_id!=WAP_OBJECT_ID)
	{
		if (keyboard->code==KCD_LEFT || keyboard->code==KCD_HUP)
		{
			AUI_destroy(RETURN_TO_MENU); /* SPR#2086 */
		}
		else if (keyboard->code==KCD_RIGHT)
		{
			AUI_download(NULL,NULL);
		}
		return MFW_EVENT_CONSUMED;
	}

	switch (keyboard->code)
	{
		case KCD_LEFT:
			/* SPR#1575 - SH - Open options menu if not downloading or reading a card */
			if (!ATB_wap_status_get(View, ATB_WAP_DOWNLOADING)
			&& !ATB_wap_status_get(View, ATB_WAP_CARD_READING))
			{
				AUI_wap_options_menu_open(ATB_wap_buffer_identify_element(View));
			}
      		break;

		case KCD_RIGHT:	
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//Unsetting this flag when we exit the wap page
			pluginImageDisplayed=FALSE;

			/* SPR#1575 - SH - Open options menu if not downloading or reading a card */
			if (ATB_wap_status_get(View, ATB_WAP_DOWNLOADING)
				|| ATB_wap_status_get(View, ATB_WAP_CARD_READING))
			{
				ATB_wap_stop_download(View);
			}
			else
			{
				if (View->CustSoftKeys)
					ATB_wap_key_selected(View, View->CustSoftKeyId);  	  		// Customised right soft key
				else
					ATB_wap_card_go_back(View);									// Otherwise default is "Back"
			}
      		break;

      	case KCD_MNUUP:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_UP);							// Scroll card up
      		break;

      	case KCD_MNUDOWN:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_DOWN);							// Scroll card down
      		break;
      // Apr 28 2005  REF:  MMI-SPR-30400 x0012849
      // Handle the MNULEFT event.
      	case KCD_MNULEFT:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_LEFT);							// Scroll card up
      		break;
      // Apr 28 2005  REF:  MMI-SPR-30400 x0012849
      // Handle the MNURIGHT event.
      	case KCD_MNURIGHT:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_RIGHT);							// Scroll card down
      		break;

      	case KCD_1:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_LEFT);							// Scroll card left
      		break;

      	case KCD_3:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
      			ATB_wap_card_key_event(View, WAP_KEY_RIGHT);						// Scroll card right
      		break;

		case KCD_2:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
				ATB_wap_card_scroll(View,0);										// Go to top of card
			break;

		case KCD_5:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
				ATB_wap_card_scroll(View,View->cardYPosition-WAP_PAGE_SCROLL);		// Scroll up a page
			break;

		case KCD_8:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
				ATB_wap_card_scroll(View,View->cardYPosition+WAP_PAGE_SCROLL);		// Scroll down a page
			break;

		case KCD_0:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
				ATB_wap_card_scroll(View,View->cardHeight-WAP_SCREEN_HEIGHT);		// Go to bottom of card
			break;

		/* SH - So that select button can be used to select links etc */
		
		case KCD_MNUSELECT:
      	case KCD_CALL:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
			if(!pluginImageDisplayed)
				 ATB_wap_card_key_event(View, WAP_KEY_SELECT);						// Select an option
      		break;
      	
      	case KCD_HUP:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//Unsetting this flag when we exit the wap page
			pluginImageDisplayed=FALSE;
			ATB_wap_stop_download(View);

			//x0018858 23 Feb, 2005 MMI-SPR-27872
			//Releasing the text string when exitting the wap page.
			//begin
			AUI_wap_string_free(&data->Message); 
			//end

      		AUI_destroy(RETURN_TO_MENU);	/* SPR#2086 */
      		break;

      	case KCD_STAR:
			//xrashmic 21 Jan, 2005 MMI-SPR-28223
			//When a plugin image is being displayed we ignore this key event
  			if(!pluginImageDisplayed)
			{
      		/* SPR#2086 - Toggle image scaling */
				ATB_wap_profile_setting_change(
  				WAP_STATUS_SCALEIMAGES,
  				ATB_wap_profile_setting(WAP_STATUS_SCALEIMAGES)^1);
  				ATB_wap_profile_save(data->View);									// Save change to flash
  				ATB_wap_card_refresh(View);
			}
			break;
      	
    	default:
			break;
	}
	return MFW_EVENT_CONSUMED;
}


static int AUI_kbd_long_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_goto_www

 $Description:	Opens up a text edit screen for entering URLs with "www." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_www(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_www");
#endif

	/* Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	AUI_edit(GET_TEXT(TxtWWWdot),WAP_GOTO_URL,TxtEnterURL,URL_MAX_LEN);			// Enter editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_goto_wap

 $Description:	Opens up a text edit screen for entering URLs with "wap." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_wap(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_wap");
#endif

	/* Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	AUI_edit(GET_TEXT(TxtWAPdot),WAP_GOTO_URL, TxtEnterURL, URL_MAX_LEN);		// Enter editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMI_AUI_goto_other

 $Description:	Opens up a blank text edit screen for entering URLs
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_other(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_other");
#endif

	/* Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	AUI_edit("",WAP_GOTO_URL, TxtEnterURL, URL_MAX_LEN);						// Enter editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_edit

 $Description:	Opens up a text edit screen for editing URLs
    	     
 $Returns:		

 $Arguments:	shortcut	- pointer to a string that will appear in the editor
 				identifier	- specifies what to do with the URL (connect, store etc).
 				prompt		- textId of prompt to display
 				maxlen		- maximum length of the edited string
 
*******************************************************************************/

int AUI_edit(char *shortcut, USHORT identifier, USHORT prompt, USHORT maxlen)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#1816 - SH - Ensure requested buffer size is not too big */
	if (maxlen>INPUT_MAX_LEN)
		maxlen = INPUT_MAX_LEN;
		
	if (identifier==WAP_EDIT_HOMEPAGE)											// If we're editing the homepage URL,
		shortcut = data->View->Profile->Homepage;								// this is the shortcut

	if (identifier==WAP_EDIT_APN)
		shortcut = data->View->Profile->APN;

	/* SPR#1816 - SH - For unicode editors, set buffer up appropriately */
	#if 0
	if (identifier==WAP_EDIT_BOOKMARK || identifier==WAP_EDIT_HISTORY)
	{
		/* Clear editor for name (unicode) */
		data->Buffer[0] = 0x80;
		data->Buffer[1] = 0x7F;
		ATB_uc_text_copy((USHORT *)&data->Buffer[2], (USHORT *)shortcut, CARD_TITLE_MAX_LEN);							// Copy name into editing buffer
		//AUI_edit_create(identifier, prompt, maxlen*2+2);	/* SPR#2086 */
                AUI_edit_create(identifier, prompt, maxlen*2+2);	/* SPR#2086 */
	}
	else
	{
		strcpy(data->Buffer, shortcut);												// Copy shortcut into editing buffer
	   	AUI_edit_create(identifier, prompt, maxlen);	/* SPR#2086 */
	}
    #endif
        if (identifier==WAP_EDIT_BOOKMARK || identifier==WAP_EDIT_HISTORY)
        {
            /* Clear editor for name */
#ifdef NEW_EDITOR
            ATB_uc_text_copy((USHORT *)data->Buffer, (USHORT *)shortcut, CARD_TITLE_MAX_LEN);
            AUI_edit_create(identifier, prompt, maxlen, TRUE);
#else
            data->Buffer[0] = 0x80;
            data->Buffer[1] = 0x7F;
            ATB_uc_text_copy((USHORT *)&data->Buffer[2], (USHORT *)shortcut, CARD_TITLE_MAX_LEN);
            AUI_edit_create( identifier, prompt, maxlen*2+2, TRUE);
#endif
        }
        else
        {
            strcpy(data->Buffer, shortcut);
            AUI_edit_create(identifier, prompt, maxlen, FALSE);
        }

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_edit_create

 $Description:	Creates the edit screen
 				SPR#2086 - Remove window parameter
    	     
 $Returns:		none.

 $Arguments:	identifier	- purpose for edit window (e.g. go to URL)
 				prompt		- textId of prompt to display
 				maxlen		- maximum length of the editor
 
*******************************************************************************/
#if 0
static T_MFW_HND AUI_edit_create(USHORT identifier, USHORT prompt, USHORT maxlen)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit_create");
#endif

	AUI_standard_editor(&editor_data, data->Buffer, maxlen, ALPHA_MODE, (T_EDIT_CB)AUI_edit_cb); // Setup standard editor

	editor_data.TextId				= prompt;									// Prompt to display above editor
	editor_data.Identifier			= identifier;								// Purpose of edit window (for callback)

	data->edit_win = editor_start(data->parent_win,&editor_data);  /* SPR#2086 */					// Start the editor
	
	return data->edit_win;
}
#endif

//static T_MFW_HND AUI_edit_create(MfwHnd parent_win, USHORT identifier, USHORT prompt, USHORT maxlen, BOOL unicode)
static T_MFW_HND AUI_edit_create(USHORT identifier, USHORT prompt, USHORT maxlen, BOOL unicode)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit_create");
#endif

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, identifier, ED_MODE_ALPHA, prompt, (T_AUI_EDIT_CB)AUI_edit_cb);

	if (unicode)
	{
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, maxlen);
 	}
	else
	{
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, maxlen);
	}
	
	//data->edit_win = AUI_edit_Start(data->win, &editor_data);
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, maxlen, ALPHA_MODE, (T_EDIT_CB)AUI_edit_cb);
	editor_data.TextId				= prompt;			/* Prompt to display above editor */
	editor_data.Identifier			= identifier;		/* Purpose of edit window (for callback) */

	data->edit_win = editor_start(data->parent_win,&editor_data);
#endif /* NEW_EDITOR */

	return data->edit_win;
}


/*******************************************************************************

 $Function:    	AUI_edit_cb

 $Description:	Callback function for edit screen.  This performs the following functions,
 				the user having provided a new or updated URL:
 				
 				- Goto URL
 				- Editing of Bookmark and History entries
 				- Add new bookmark
 				- Edit homepage
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_edit_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit_cb");
#endif

	if (!data)
	{
		return;
	}
	
	View = data->View;

	switch (reason)
	{
		case INFO_KCD_LEFT:
			switch (identifier)
   			{
       			/* Go to URL */
       			
       			case WAP_GOTO_URL:
       				AUI_wap_connect_URL(data->Buffer);	/* SPR#2086 - modified */
		    		break;

				/* Edit Bookmark name */
		
				case WAP_EDIT_BOOKMARK:
					/* SPR#1684 - SH - Changed behaviour here */
					AUI_destroy(LIST_WIN);				/* SPR#2086 */
					//xrashmic 03 Sep, 2004 MMI-SPR-24395
					//The bookmark names was not getting stored correctly. The 
					//first chracter was neglected when data->Buffer[2] was sent
                                        #ifdef NEW_EDITOR
					ATB_wap_entry_change(WAP_BOOKMARKS_LIST, View->Bookmarks, data->Buffer, data->OptionSelect);	/* SPR#1816 - SH */
					#else
					ATB_wap_entry_change(WAP_BOOKMARKS_LIST, View->Bookmarks, &data->Buffer[2], data->OptionSelect);	/* SPR#1816 - SH */
					#endif
					ATB_wap_profile_save(View);	
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtChanged);
					break;

				/* Edit Bookmark URL */
		
				case WAP_EDIT_BOOKMARK_URL:
					/* SPR#1684 - SH - Changed behaviour here */
		    		AUI_destroy(LIST_WIN);			/* SPR#2086 */
					ATB_wap_entry_change(WAP_URL_LIST, View->BookmarksURL, data->Buffer, data->OptionSelect);		/* SPR#1816 - SH */
					ATB_wap_profile_save(View);																		// Save change to flash
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtChanged);													// Display "Changed" message
					break;
				
				/* Edit History name */
		
				case WAP_EDIT_HISTORY:
					/* SPR#1684 - SH - Changed behaviour here */
		    		AUI_destroy(LIST_WIN);				/* SPR#2086 */
					//xrashmic 03 Sep, 2004 MMI-SPR-24395
					//The history names was not getting stored correctly. The 
					//first chracter was neglected when data->Buffer[2] was sent
                                        #ifdef NEW_EDITOR
					ATB_wap_entry_change(WAP_HISTORY_LIST, View->History, data->Buffer, data->OptionSelect);	/* SPR#1816 - SH */
					#else
					ATB_wap_entry_change(WAP_HISTORY_LIST, View->History, &data->Buffer[2], data->OptionSelect);	/* SPR#1816 - SH */
					#endif
					ATB_wap_profile_save(View);																	// Save change to flash
					AUI_list_redraw(WAP_HISTORY_LIST, TxtChanged);												// Display "Changed" message
					break;

				/* Edit History URL */
		
				case WAP_EDIT_HISTORY_URL:
					/* SPR#1684 - SH - Changed behaviour here */
		    		AUI_destroy(LIST_WIN);		/* SPR#2086 */
		    		ATB_wap_entry_change(WAP_URL_LIST, View->HistoryURL, data->Buffer, data->OptionSelect);		/* SPR#1816 - SH */
					ATB_wap_profile_save(View);																	// Save change to flash
					AUI_list_redraw(WAP_HISTORY_LIST, TxtChanged);												// Display "Changed" message
					break;

				/* Add Bookmark */
		
				case WAP_ADD_BOOKMARK:
					AUI_destroy(EDIT_WIN);		/* SPR#2086 */													// Destroy editor
					strcpy(data->Buffer2, data->Buffer);	// Store URL in second buffer
					//CRR 25541: 06 oct 2004 - xpradipg
					//the buffer is terminated at buffer[0] for NEW EDITOR
                                        #ifdef NEW_EDITOR
                                //xrashmic 21 Dec, 2004 MMI-SPR-27620
                                //The buffer needs to be cleared before prompting for the Name                                
    					data->Buffer[0] = 0;
					data->Buffer[1] = 0;

                                        #else
					/* SPR#1816 - SH - Clear editor for name (unicode) */
					data->Buffer[0] = 0x80;
					data->Buffer[1] = 0x7F;
					data->Buffer[2] = 0;
					data->Buffer[3] = 0;
                                        #endif
					//AUI_edit_create(WAP_ADD_BOOKMARK_NAME, TxtEditName, CARD_TITLE_MAX_LEN);	/* SPR#2086 */
					AUI_edit_create(WAP_ADD_BOOKMARK_NAME, TxtEditName, CARD_TITLE_MAX_LEN, TRUE);	/* SPR#2086 */
		    		break;

		    	/* Add Bookmark name */
		
				case WAP_ADD_BOOKMARK_NAME:
					/* SPR#1684 - SH - Changed behaviour here */
					AUI_destroy(LIST_WIN);		/* SPR#2086 */
					if (ATB_wap_entry_add(View->BookmarksURL, data->Buffer2)==WAP_FAIL)				// Add URL entry
					{
						AUI_info_dialog(TxtBookmarks, TxtFull);		/* SPR#2086 */				// If list is full, say so
					}
					else
					{
					//xrashmic 05 Nov, 2004 MMI-SPR-25252
					//The Bookmark names was not getting stored correctly. The 
					//first chracter was neglected when data->Buffer[2] was sent
#ifdef NEW_EDITOR
						ATB_wap_entry_add(View->Bookmarks, data->Buffer);
#else /* NEW_EDITOR */
						ATB_wap_entry_add(View->Bookmarks, &data->Buffer[2]);					/* SPR#1816 - SH */
#endif /* NEW_EDITOR */
						ATB_wap_profile_save(View);												// Save change to flash
						AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtStored);						
					}
					break;

				/* Edit Homepage URL */

				case WAP_EDIT_HOMEPAGE:
			 	  	strcpy(View->Profile->Homepage, data->Buffer);					// Change the homepage
			 	  	ATB_wap_profile_save(View);									// Save change to flash
					AUI_destroy(EDIT_WIN);		/* SPR#2086 */
					AUI_info_dialog(TxtChanged, NULL);	/* SPR#2086 */
					break;

				/* Edit APN */

				case WAP_EDIT_APN:
			 	  	strcpy(View->Profile->APN, data->Buffer);							// Change the homepage
			 	  	ATB_wap_profile_save(View);									// Save change to flash
			 	  	AUI_destroy(EDIT_WIN);	/* SPR#2086 */
					AUI_info_dialog(TxtChanged, NULL);		/* SPR#2086 */
					break;

				case WAP_EDIT_DOWNLOAD:
					/* Display "Please Wait" */
                                    //xrashmic 29 Nov, 2004 MMI-SPR-26161
                                    //Reset the size to zero before the download starts
                                    downloaded_data_size=0;
					AUI_connecting_dialog(ATB_WAP_PLEASE_WAIT); /* SPR#2086 */
					AUI_wap_content_get(1, data->Buffer, TRUE, "*/*");
					break;
					
				default:
					break;
    		}
			break;

		/* RSK or HUP key exits menu */
		
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:													// (Exit from Editor)
			AUI_destroy(EDIT_WIN);				/* SPR#2086 */
			if (identifier == WAP_ADD_BOOKMARK_NAME)							// If we've destroyed the name editor,
			{
				strcpy(data->Buffer, data->Buffer2);							// copy the URL back into the editor
				//AUI_edit_create(WAP_ADD_BOOKMARK, TxtEditURL, CARD_TITLE_MAX_LEN); /* SPR#2086 */
				AUI_edit_create(WAP_ADD_BOOKMARK, TxtEditURL, CARD_TITLE_MAX_LEN, FALSE); /* SPR#2086 */
			}
			break;
		
		default:
			break;
	}

	return;
}

/*******************************************************************************

 $Function:    	AUI_list_redraw

 $Description:	SPR#1684 -SH - Added this function
 				When changing, adding, or deleting bookmarks or history list items,
 				this function is called to display the appropriate dialog.  On callback,
 				the AUI_list_redraw_cb() function redraws the appropriate list.

 $Returns:		None.

 $Arguments:	list	- The type of list to be redrawn
 				TxtId	- The text string to be displayed in a dialog for 3s
 
*******************************************************************************/

void AUI_list_redraw(USHORT list, USHORT TxtId)
{
	T_WAP_DATA *data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

	if (!data)
	{
		return;
	}
	
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtId, TxtNull, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_list_redraw_cb, THREE_SECS, 0 );
	display_info.Identifier = list;
	
	info_dialog(data->parent_win, &display_info);

	return;
}


/*******************************************************************************

 $Function:    	AUI_list_redraw_cb

 $Description:	SPR#1684 -SH - Added this function
 				Called when a 3s info dialog times out: the appropriate list is
 				redrawn (history, bookmarks).

 $Returns:		None.

 $Arguments:	win - the parent window
 				identifier - stores the type of list
 				reson - not used.
 
*******************************************************************************/

static void AUI_list_redraw_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data		= AUI_wap_data();	
  
	TRACE_FUNCTION("AUI_list_redraw_cb()");

	if (!data)
	{
		return;
	}
	
	/* Kill any residual editor or options window */
       //xrashmic 16 Dec, 2004 MMI-SPR-27622
       // The profile list window should be redrawn. Hence deleting the old list here.
	AUI_destroy(LIST_WIN|EDIT_WIN | OPTIONS_WIN);	/* SPR#2086 */

	/* Redraw the appropriate list */
	
	switch(identifier)
	{
		case WAP_BOOKMARKS_LIST:
			AUI_entry_list(data->View->Bookmarks, (ListCbFunc)AUI_bookmarks_list_cb,0);
			break;

		case WAP_HISTORY_LIST:
			AUI_entry_list(data->View->History, (ListCbFunc)AUI_history_list_cb,0);
			break;

		/* SPR#1921 - SH */
		case WAP_PROFILES_SETUP:
			AUI_entry_list(data->View->ProfilesList, (ListCbFunc)AUI_profiles_setup_cb,0);
			break;
			

		/* SPR#2086 - SH */
		case WAP_PUSH_LIST:
			AUI_wap_push_list(NULL, NULL);
			break;

	}
	return;
}

/*******************************************************************************

 $Function:    	AUI_profile_list_redraw

 $Description:	Re-displays the profile list menu

 $Returns:		None.

 $Arguments:	index: Index of the currently selected profile
 				xreddymn Jan-27-2005 MMI-SPR-28135
 
*******************************************************************************/

void AUI_profile_list_redraw(S32 index)
{
	T_WAP_DATA *data = AUI_wap_data();

	if ((data==NULL)||(data->View==NULL)||(data->View->ProfilesList==NULL))
	{
		return;
	}
	if(!((data->list_data==NULL)||(data->list_data->win==NULL)))
	{
		AUI_destroy(LIST_WIN);
		ATB_wap_profile_names_read(data->View);
		data->View->ProfilesList->type = WAP_PROFILES_LIST;	
		AUI_entry_list(data->View->ProfilesList, (ListCbFunc)AUI_profiles_setup_cb, index);
		data->View->ProfileId=index;
	}
	else
	{
		ATB_wap_profile_names_read(data->View);
	}
}

/*******************************************************************************

 $Function:    	AUI_bookmarks_add

 $Description:	SPR#1684 - SH - Added this function.
 				New bookmark menu item.  Checks to see if bookmarks are full;
 				if so, displays message and exits.  Otherwise, brings up usual
 				new bookmark shortcut menu.
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_add(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data		= AUI_wap_data();
	T_MMI_WAP_NEW_VIEW_IND		wap_view;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_start_done");
#endif
	
	if (!data)
	{
		return;
	}

	/* If there is space in the bookmarks list */

	if (data->View->Bookmarks->no_of_entries < data->View->Bookmarks->max_entries)
	{
		/* SPR#1684 - SH - Destroy any previous options menu existing */
		if (data->options_win)
		{
			AUI_destroy(OPTIONS_WIN); /* SPR#2086 */
		}
		/* Create Add Bookmark Menu */
		//#ifdef MMI_WAP_ENABLED //added by ellen
		data->options_win = bookMenuStart(data->parent_win, WAPNewBookmarkAttributes(), 0); /* SPR#2086 */
		//#endif
		SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_options_cb);  // Add our own callback
	}
	else
	{
		AUI_info_dialog(TxtBookmarks, TxtFull); /* SPR#2086 */
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_www

 $Description:	Opens up a text edit screen for entering URLs with "www." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_www(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_www");
#endif

	AUI_edit(GET_TEXT(TxtWWWdot),WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);	// Open up the editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_wap

 $Description:	Opens up a text edit screen for entering URLs with "wap." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_wap(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_wap");
#endif

	AUI_edit(GET_TEXT(TxtWAPdot),WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);	// Open up the editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_other

 $Description:	Opens up a blank text edit screen for entering URLs
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_other(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_other");
#endif

	AUI_edit("",WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);					// Open up the editor

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_list

 $Description:	List Bookmarks menu option
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_list(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_list");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#2086 - Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	/* Create the list menu */

	if (data->View->Bookmarks)
	{
		AUI_entry_list(data->View->Bookmarks, (ListCbFunc) AUI_bookmarks_list_cb,0);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_list_cb

 $Description:	Callback function for bookmarks list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of bookmarks list
 
*******************************************************************************/

static void AUI_bookmarks_list_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA	*data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_list_cb");
	TRACE_EVENT_P1("Exit reason: %d", EntryListData->Reason);
#endif

	if (!data)
	{
		return;
	}

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:									
			/* Option is selected... */
			
			data->OptionSelect = EntryListData->ListPosition;						// Store selected bookmark no.
			data->URLSelect = data->View->BookmarksURL->Entry[data->OptionSelect]; 	// Store the URL of the bookmark
			/* SPR#1684 - SH - Destroy any previous options menu existing */
			if (data->options_win)
			{
				AUI_destroy(OPTIONS_WIN); /* SPR#2086 */
			}
			data->options_win = bookMenuStart(win, WAPBookOptMenuAttributes(), 0);	// Create bookmark options menu
			SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_options_cb);  // Add our own callback
	  		break;

		case LISTS_REASON_SEND:
			data->OptionSelect = EntryListData->ListPosition;						// Store selected bookmark no.
			data->URLSelect = data->View->BookmarksURL->Entry[data->OptionSelect]; 	// Store the URL of the bookmark

			AUI_wap_connect_URL(data->URLSelect);	/* SPR#2086 - modified */
			break;
			
		case LISTS_REASON_CLEAR:
		case LISTS_REASON_HANGUP:												// sbh: added, so hangup key exits
  		case LISTS_REASON_BACK:													// Exit list menu
  			AUI_destroy(LIST_WIN);	/* SPR#2086 */
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_goto

 $Description:	Open up the selected bookmark in the WAP browser
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_goto(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_goto");
#endif

	return AUI_entry_goto(WAP_BOOKMARKS_LIST);	
}	


/*******************************************************************************

 $Function:    	AUI_bookmarks_edit

 $Description:	Edit the name of the selected bookmark
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();	
	
#ifdef TRACE_AUIWAP
	UBYTE	entryIndex;

	TRACE_FUNCTION("AUI_bookmarks_edit");
#endif

	if (!data)
	{
		return;
	}
			
	AUI_edit(data->View->Bookmarks->Entry[data->OptionSelect],
		WAP_EDIT_BOOKMARK, TxtEditName, CARD_TITLE_MAX_LEN);
		
	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_edit_url

 $Description:	Edit the URL of the selected bookmark
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_edit_url(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_edit_url");
#endif

	if (!data)
	{
		return;
	}
	
	AUI_edit(data->View->BookmarksURL->Entry[data->OptionSelect],
		WAP_EDIT_BOOKMARK_URL, TxtEditURL, URL_MAX_LEN);
		
	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_delete

 $Description:	Delete the selected bookmark from the bookmarks list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_delete(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_delete");
#endif

	AUI_entry_delete(WAP_DELETE_BOOKMARK);
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_sendSMS

 $Description:	Open up a bookmark in an SMS write editor
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_sendSMS(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_sendSMS");
#endif

	AUI_entry_sendSMS();
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_history_list

 $Description:	List History menu option
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_history_list(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_list");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#2086 - Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	/* Create the history list menu */

	if (data->View->History)
	{
		AUI_entry_list(data->View->History, (ListCbFunc) AUI_history_list_cb,0);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_history_list_cb

 $Description:	Callback function for history list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of history lsit
 
*******************************************************************************/

static void AUI_history_list_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_list_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:									
			/* Option is selected... */
			
			data->OptionSelect = EntryListData->ListPosition;					// Store selected history entry no.
			data->URLSelect = data->View->HistoryURL->Entry[data->OptionSelect];	     // Store the URL of the history entry
			/* SPR#1684 - SH - Destroy any previous options menu existing */
			if (data->options_win)
			{
				AUI_destroy(OPTIONS_WIN); /* SPR#2086 */
			}
			data->options_win = bookMenuStart(win, WAPHistOptMenuAttributes(), 0);     // Create history options menu
			SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_options_cb);  // Add our own callback
  			break;

		case LISTS_REASON_SEND:									
			data->OptionSelect = EntryListData->ListPosition;						// Store selected bookmark no.
			data->URLSelect = data->View->HistoryURL->Entry[data->OptionSelect]; 	// Store the URL of the bookmark
			
			AUI_wap_connect_URL(data->URLSelect);	/* SPR#2086 - modified */
  			break;

  		case LISTS_REASON_BACK:													// Exit menu
			AUI_destroy(LIST_WIN);		/* SPR#2086 */
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_history_goto

 $Description:	Open up the selected history entry in the WAP browser
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_goto(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_goto");
#endif

	return AUI_entry_goto(WAP_HISTORY_LIST);	
}	


/*******************************************************************************

 $Function:    	AUI_history_edit

 $Description:	Edit the name of the selected history entry
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	USHORT			*EntryUC;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_edit");
#endif

	if (!data)
	{
		return 0;
	}

	EntryUC			= (USHORT *)data->View->History->Entry[data->OptionSelect];
	
	AUI_edit((char *)&EntryUC[NUMBER_PADDING], WAP_EDIT_HISTORY, TxtEditName, CARD_TITLE_MAX_LEN);
		
	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_history_edit_url

 $Description:	Edit the URL of the selected history entry
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_edit_url(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_edit_url");
#endif

	if (!data)
	{
		return;
	}
	
	AUI_edit(data->View->HistoryURL->Entry[data->OptionSelect],
		WAP_EDIT_HISTORY_URL, TxtEditURL, URL_MAX_LEN);
		
	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_history_delete

 $Description:	Delete the selected entry from the history list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_delete(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_delete");
#endif

	AUI_entry_delete(WAP_DELETE_HISTORY);
	
	return MFW_EVENT_CONSUMED;
}	


/*******************************************************************************

 $Function:    	AUI_history_clear

 $Description:	Deletes all entries in history list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_clear(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_clear");
#endif

	if (!data)
	{
		return;
	}
	
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtExit, TxtOkToDelete, TxtNull, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_entry_delete_cb, FOREVER, KEY_CLEAR | KEY_LEFT | KEY_RIGHT );
	display_info.Identifier = WAP_CLEAR_HISTORY;
	info_dialog(data->parent_win, &display_info);
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_history_addbook

 $Description:	Adds a history item to the bookmarks list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_addbook(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	USHORT			*EntryUC;
	char			*URL;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_addbook()");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1816 - SH - Add string after NUMBER_PADDING in unicode */
	
	EntryUC		= (USHORT *)data->View->History->Entry[data->OptionSelect];						// Text of the history entry
	URL			= data->View->HistoryURL->Entry[data->OptionSelect];					// URL of the entry

	if (ATB_wap_entry_add(data->View->Bookmarks, (char *)&EntryUC[NUMBER_PADDING])==NULL)  		// Try to add history item to bookmarks
	{
		AUI_info_dialog(TxtBookmarks, TxtFull);	/* SPR#2086 */
	}
	else
	{
		ATB_wap_entry_add(data->View->BookmarksURL, URL);
		ATB_wap_profile_save(data->View);												// Save change to flash
		AUI_info_dialog(TxtStored, NULL);		/* SPR#2086 */
	}
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_history_sendSMS

 $Description:	Open up a history entry in an SMS write editor
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_history_sendSMS(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_sendSMS");
#endif

	AUI_entry_sendSMS();
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profiles_list

 $Description:	Lists names of all profiles in flash
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profiles_list(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_list");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#2086 - Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	/* Create the profile list menu */

	if (data->View->ProfilesList)
	{
		data->View->ProfilesList->type = WAP_PROFILES_LIST;								// To differentiate from WAP_PROFILES_SETUP
		AUI_entry_list(data->View->ProfilesList, (ListCbFunc) AUI_profiles_list_cb, data->View->ProfileId);      // Create the profiles list
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profiles_list_cb

 $Description:	Callback function for profiles list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of profiles list
 
*******************************************************************************/

static void AUI_profiles_list_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA *data = AUI_wap_data();
	UBYTE temp_storage;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_list_cb()");
#endif

	if (!data)
	{
		return;
	}												// Used to store new profile id

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SEND:
		case LISTS_REASON_SELECT:
			/* SPR#1574 - SH - Minor change: "Changed" message appears
			 * before window is destroyed */
			AUI_info_dialog(TxtChanged, NULL);				/* SPR#2086 */
			/* The user has chosen a profile */
			temp_storage = EntryListData->ListPosition;							// Store selected profile number for a bit...
			AUI_destroy(LIST_WIN);		/* SPR#2086 */
			/* Get new profile */
			ATB_wap_profile_read(data->View, temp_storage);							// Read in new profile data
			ATB_wap_profile_save(data->View);											// Save the change to flash
  			break;

  		case LISTS_REASON_BACK:													// Exit menu (back, timeout etc).		
			AUI_destroy(LIST_WIN);	/* SPR#2086 */
  			break;
	}
	return;
}

/*******************************************************************************

 $Function:    	AUI_profile_change_cb

 $Description:	Callback function for profile change window
 
 $Returns:		void		

 $Arguments:	Standard menu callback parameters
 
*******************************************************************************/

static void AUI_profile_change_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_change_cb");
#endif

	if (!data)
	{
		return;
	}

	data->sub_options_win = NULL;

	return;
}

/*******************************************************************************

 $Function:    	AUI_profile_change

 $Description:	Bring up slightly different menus depending on whether profile is
 				GPRS or Dialup.
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_change(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

	/* Only allow modification of the GPRS settings if GPRS is switched on */
#ifdef GPRS
	if (data->View->Profile->AccessType==WAP_GPRS_DATA)
	{
		data->sub_options_win = bookMenuStart(data->parent_win, WAPGPRSProfileAttributes(), 0);
	}
	else
#endif
	{
		data->sub_options_win = bookMenuStart(data->parent_win, WAPDialupProfileAttributes(), 0);
	}
	
	SEND_EVENT(data->sub_options_win, ADD_CALLBACK, NULL, (void *)AUI_profile_change_cb);
  			
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_delete

 $Description:	Delete the highlighted profile
                     //xrashmic 16 Dec, 2004 MMI-SPR-27622
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_delete(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	/* Don't let user delete last profile */

	if (data->View->ProfilesList->no_of_entries==1)
	{
		AUI_info_dialog(TxtNotAllowed, TxtNull);
	}
	else
	{
		/* Present option to delete profile */
		AUI_entry_delete(WAP_DELETE_PROFILE);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_new

 $Description:	Add a new profile
                    //xrashmic 16 Dec, 2004 MMI-SPR-27622
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_new(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE newProfileId;

	/* Check if profiles are full */

	if (data->View->ProfilesList->no_of_entries==data->View->ProfilesList->max_entries)
	{
		AUI_info_dialog(TxtProfiles, TxtFull);
	}
	else
	{
		/* Add the profile */
		newProfileId = data->View->ProfilesList->no_of_entries;
		ATB_wap_profile_default(MAX_PROFILES-1);
              //xrashmic 16 Dec, 2004 MMI-SPR-27622
              // When adding a new profile, use the last record i.e the empty record.
		ATB_wap_entry_add(data->View->ProfilesList, data->View->ProfilesList->Entry[MAX_PROFILES-1]);
		ATB_wap_profile_save(data->View);
		AUI_list_redraw(WAP_PROFILES_LIST, TxtStored);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_reset

 $Description:	Reset profiles to default values
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_reset(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_reset");
#endif

	if (!data)
	{
		return;
	}

	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtResetProfiles, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_profile_reset_cb, FIVE_SECS, KEY_LEFT | KEY_RIGHT | KEY_CLEAR | KEY_HUP );
	
	info_dialog(data->parent_win, &display_info);
	return;
}


/*******************************************************************************

 $Function:    	AUI_profile_reset_cb

 $Description:	Callback from reset profiles dialog
 
 $Returns:		None

 $Arguments:	Standard info dialog callback arguments
 
*******************************************************************************/

static void AUI_profile_reset_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_reset_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch(reason)
	{
		case INFO_KCD_LEFT:
			AUI_destroy(LIST_WIN);
			ATB_wap_profile_default_create(TRUE);
			ATB_wap_profile_names_read(data->View);
			ATB_wap_profile_read(data->View, data->View->ProfileId);
			AUI_list_redraw(WAP_PROFILES_LIST, TxtReset);
			break;
			
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			break;
	} 
	
	return ;
}

/*******************************************************************************

 $Function:    	AUI_profiles_setup

 $Description:	Lists names of all profiles in flash, in order to change settings
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profiles_setup(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_setup");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#2086 - Ensure that the default browser view is selected */

	ATB_wap_change_view(WAP_OBJECT_ID);
	
	/* Store the current profile number - we're going to temporarily change profiles
	 * to edit the settings, then switch back.*/
	
	data->OptionSelect = data->View->ProfileId;
	
	/* Create the profile list menu */

	if (data->View->ProfilesList)
	{
		data->View->ProfilesList->type = WAP_PROFILES_SETUP;								// To differentiate from WAP_PROFILES_LIST
		AUI_entry_list(data->View->ProfilesList, (ListCbFunc) AUI_profiles_setup_cb, data->View->ProfileId);   // Create the profiles list menu
	}
	
	return MFW_EVENT_CONSUMED;
}
/*******************************************************************************

 $Function:    	AUI_profiles_options_cb

 $Description:	Callback function for profiles options window
                     //xrashmic 23 Dec, 2004 MMI-SPR-27623
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				identifier, reason  - Not used
 
*******************************************************************************/

static void AUI_profiles_options_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_options_cb");
#endif

	if (!data)
	{
		return;
	}

	data->options_win = NULL;
	
	/* If the edited profile is different from the selected profile, change back */

	if (data->profile_store!=data->View->ProfileId)
	{
		ATB_wap_profile_read(data->View, data->profile_store);
		/* Recreate list menu so it points to original profile */
		AUI_destroy( LIST_WIN);
		AUI_entry_list(data->View->ProfilesList, (ListCbFunc)AUI_profiles_setup_cb,data->profile_store);
	}

	return;
}



/*******************************************************************************

 $Function:    	AUI_profiles_setup_cb

 $Description:	Callback function for profiles list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of profiles list
 
*******************************************************************************/

static void AUI_profiles_setup_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA *data = AUI_wap_data();
	UBYTE original_profile;
	UBYTE new_profile;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_setup_cb");
#endif

	if (!data)
	{
		return;
	}

	original_profile = data->View->ProfileId;
        //xrashmic 16 Dec, 2004 MMI-SPR-27622
        //The highlighted item position to be stored.
	data->OptionSelect = EntryListData->ListPosition; /* The id of the selected profile */

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SEND:
		case LISTS_REASON_SELECT:									
                    //xrashmic 23 Dec, 2004 MMI-SPR-27623
                    //Storing the original profile before going to the options menu.			
                    /* The user has chosen a profile.  Store the original profile ID */
			data->profile_store = data->View->ProfileId;

			/* The user has chosen a profile */

			new_profile = EntryListData->ListPosition;							// Change profile number
			ATB_wap_profile_read(data->View, new_profile);							// Read in selected profile
			/* SPR#1684 - SH - Destroy any previous options menu existing */
			if (data->options_win)
			{
				AUI_destroy(OPTIONS_WIN); /* SPR#2086 */
			}
			data->options_win = bookMenuStart(data->parent_win, WAPProfOptionsAttributes(), 0);     // Create settings menu
                    //xrashmic 23 Dec, 2004 MMI-SPR-27623
                    //Adding the new call back for the options menu.			
			SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_profiles_options_cb);
  			break;

  		case LISTS_REASON_BACK:													// Exit menu		
			AUI_destroy(LIST_WIN); /* SPR#2086 */

			if (data->View->ProfileId!=data->OptionSelect)							// We've changed profile...
			{
				ATB_wap_profile_read(data->View, original_profile);					// Read in original profile
			}
				
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_entry_list

 $Description:	Create an entry list and store its pointer in list_win/list_data
 
 $Returns:		pointer to list menu data
 				SPR#2086 - Remove window parameter

 $Arguments:	EntryList	- pointer to entry list table
 				Callback	- the callback function
 				pos			- the default highlighted option
 
*******************************************************************************/

int AUI_entry_list (T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_list");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* Destroy previous list, if it exists */
	
	if (data->list_win)
	{
		AUI_destroy(LIST_WIN); /* SPR#2086 */
	}

	/* Create new list */
	
	data->list_data = AUI_entry_list_create (data->parent_win, EntryList, Callback, pos);	// Create the entry list
	if (data->list_data)														// If list has been created...
		data->list_win = data->list_data->win;									// Attach the resulting window to the data
	else
	{
		data->list_win = NULL;													// No window created
	}
	return 1;		
}


/*******************************************************************************

 $Function:    	AUI_entry_list_create

 $Description:	Create an entry list for Bookmarks/History/Profiles, or options menu
 
 $Returns:		pointer to list menu data

 $Arguments:	win			- the WAP data window
 				EntryList	- pointer to bookmarks table
 				Callback	- the callback function for the entry list
 				pos			- the default highlighted option
 
*******************************************************************************/

static ListMenuData * AUI_entry_list_create (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos)
{
	ListMenuData *EntryListData;
	USHORT 		entryIndex;
	USHORT		no_of_entries	= EntryList->no_of_entries;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_list_create");
#endif
	
	if (no_of_entries==0)														// Is the list empty?
	{
		AUI_info_dialog(TxtEmpty, NULL);	/* SPR#2086 */
		return NULL;
	}

	EntryListData = (ListMenuData *)AUI_wap_memory_alloc (sizeof(ListMenuData));	// Allocate memory for list data
	
	if (EntryListData==NULL)
		return NULL;

	EntryListData->List = (T_MFW_MNU_ITEM *) AUI_wap_memory_alloc (no_of_entries*sizeof (T_MFW_MNU_ITEM));

	if (EntryListData->List==NULL)
		return NULL;
	
	/* Fill Menu List */
	
	for (entryIndex=0; entryIndex < no_of_entries; entryIndex++)
	{
		mnuInitDataItem(&EntryListData->List[entryIndex]);
		
		if (EntryList->Entry[entryIndex]!=NULL)
			EntryListData->List[entryIndex].str = (char *)EntryList->Entry[entryIndex];   // Copy Entry into list
		else
			EntryListData->List[entryIndex].str = GET_TEXT(TxtEmpty);			// ...otherwise "Empty"
		
		EntryListData->List[entryIndex].flagFunc = item_flag_none;
	}

	/* Fill common parameters for list handling */

	EntryListData->ListLength		= no_of_entries;
	EntryListData->CursorPosition	= 1;										// Starting position
	EntryListData->ListPosition		= pos+1;
	if (pos>3)
		EntryListData->CursorPosition = pos-3;									// Make sure highlighted is on screen
	EntryListData->SnapshotSize		= 5;										// 5 entries on the screen at once
	EntryListData->Font				= 0;
	
	if (EntryList->type==WAP_PROFILES_LIST || EntryList->type==WAP_OPTIONS_LIST)		// For these lists, left soft key is Select
		EntryListData->LeftSoftKey	= TxtSoftSelect;
	else
		EntryListData->LeftSoftKey	= TxtSoftOptions;
	
	EntryListData->RightSoftKey	= TxtSoftBack;
	EntryListData->KeyEvents	= KEY_ALL;	/* SPR#1921 - SH - Prevents keypresses falling through to window behind */
	EntryListData->Reason		= 0;
	EntryListData->Strings		= TRUE;											// Use strings not text ID's
	EntryListData->Attr			= &list_menuAttrib;
	EntryListData->autoDestroy	= FALSE; 										// Don't destroy on exit

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("Display list");
#endif
	/* SPR#1816 - SH - Use entry list unicode flag to specify whether
	 * the list is unicode or not */
	 
	listDisplayListMenu(win, EntryListData, (ListCbFunc)Callback,(UBYTE)EntryList->unicode);				// Display the list

	return EntryListData;
}


/*******************************************************************************

 $Function:    	AUI_entry_goto

 $Description:	Open up the selected bookmark/history entry in the WAP browser
 
 $Returns:		

 $Arguments:	identifier	- specifies whether history or bookmarks list
 
*******************************************************************************/

int AUI_entry_goto(WAP_LIST_TYPE identifier)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_goto");
#endif

	if (!data)
	{
		return 0;
	}
	
	switch(identifier)
	{
		case WAP_BOOKMARKS_LIST:
		case WAP_HISTORY_LIST:
			AUI_wap_connect_URL(data->URLSelect);	/* SPR#2086 - modified */
			break;
	}

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_entry_delete

 $Description:	Delete the selected entry from the history/bookmarks list
 
 $Returns:		

 $Arguments:	identifier	- specifies history list or bookmarks list	
 
*******************************************************************************/

int AUI_entry_delete(UBYTE identifier)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_delete");
#endif

	if (!data)
	{
		return 0;
	}
	
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_entry_delete_cb, FOREVER, KEY_CLEAR | KEY_LEFT | KEY_RIGHT );
	display_info.Identifier		= identifier;									// Type of list
	
	info_dialog(data->parent_win, &display_info);

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_entry_delete_cb

 $Description:	Callback function for delete confirmation
 
 $Returns:		

 $Arguments:	win			- WAP data window
 				identifier	- Type of list
 				reason		- reason for callback	
 
*******************************************************************************/

void AUI_entry_delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_WAP_VIEW		*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_delete_cb");
#endif

	if (!data)
	{
		return;
	}
	
	View = data->View;
	
	switch(identifier)
	{
		case WAP_DELETE_BOOKMARK:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					AUI_destroy(LIST_WIN);		/* SPR#2086 */
					ATB_wap_entry_remove(View->Bookmarks, data->OptionSelect);     // Delete the selected bookmark name
					ATB_wap_entry_remove(View->BookmarksURL, data->OptionSelect);  // Delete the selected bookmark URL
					ATB_wap_profile_save(View);									// Save change to flash
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;

		case WAP_DELETE_HISTORY:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					AUI_destroy(LIST_WIN);			/* SPR#2086 */
					ATB_wap_entry_remove(View->History, data->OptionSelect);  	// Delete the selected history entry name
					ATB_wap_entry_remove(View->HistoryURL, data->OptionSelect);	// Delete the selected history entry URL
					ATB_wap_renumber_history(View->History);					// Renumber history list
					ATB_wap_profile_save(View);									// Save change to flash
					AUI_list_redraw(WAP_HISTORY_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;
            //xrashmic 16 Dec, 2004 MMI-SPR-27622
            // To handle the delete profile event.
		case WAP_DELETE_PROFILE:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					AUI_destroy(LIST_WIN);										/* Destroy the old list */
					ATB_wap_profile_delete(data->View, data->OptionSelect);	/* Shifts profile data up */
					/* Read in the new profile */
					ATB_wap_profile_read(data->View, data->OptionSelect);
					ATB_wap_profile_save(View);									// Save change to flash
					AUI_list_redraw(WAP_PROFILES_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;
		case WAP_CLEAR_HISTORY:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					ATB_wap_entry_remove_all(View->History);					// Delete all history name entries
					ATB_wap_entry_remove_all(View->HistoryURL);					// Delete all history URL entries
					ATB_wap_profile_save(View);									// Save change to flash
					AUI_entry_list(View->History, (ListCbFunc)AUI_history_list_cb,0); /* SPR#2086 */
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;
    }

	return;
}


/*******************************************************************************

 $Function:    	AUI_entry_sendSMS

 $Description:	Open up an SMS editing screen with the selected URL
 
 $Returns:		

 $Arguments:	none
 
*******************************************************************************/

int AUI_entry_sendSMS(void)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_SmsUserData	UserData;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_sendSMS");
#endif

 	if (!data)
 	{
 		return 0;
 	}
 	
	strcpy((char *)UserData.TextBuffer, data->URLSelect);						// Copy name into SMS editing buffer
	UserData.NumberBuffer[0] = 0;											// No number...
	UserData.CentreBuffer[0] = 0;											// or service centre supplied.

	data->edit_win = SmsSend_SEND_start(data->parent_win, &UserData);						// Start editing SMS

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_name_edit

 $Description:	Opens up a text edit screen for editing the name of a profile
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/
#if 0
int AUI_profile_name_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_name_edit");
#endif

	if (!data)
	{
		return 0;
	}
   
	/* SPR#1816 - SH - Clear editor for name (unicode) */
	data->Buffer[0] = 0x80;
	data->Buffer[1] = 0x7F;
	ATB_uc_text_copy((USHORT *)&data->Buffer[2], data->View->Profile->Title, CARD_TITLE_MAX_LEN);							// Copy name into editing buffer

	/* Set up editor. SPR#1816 - SH - Extend max size for unicode string */
	
	AUI_standard_editor(&editor_data, data->Buffer, (PROFILENAME_MAX_LEN+1)*sizeof(USHORT), ALPHA_MODE, (T_EDIT_CB)AUI_profile_name_edit_cb);
	
	editor_data.TextId				= TxtProfileName;							// "Profile Name:"
	editor_data.min_enter			= 1;										// Avoid returning empty strings
			
	data->edit_win = editor_start(data->parent_win, &editor_data);							// Create input window
	
	return 1;
}
#endif

extern     char* ATB_mms_get_Title(void);
int AUI_profile_name_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_name_edit");
#endif

	if (!data)
	{
		return 0;
	}
   

#ifdef NEW_EDITOR
    //CRR 25541: 06 Oct 2004 - xpradipg
    //commented the addition which is not required in the NEW_EDITOR case
    //and send the address of the buffer instead of &buffer[2]
	/* Store name in editor buffer */
	//data->Buffer[0] = 0x80;
	//data->Buffer[1] = 0x7F;
	ATB_uc_text_copy((USHORT *)data->Buffer, data->View->Profile->Title, PROFILENAME_MAX_LEN);							// Copy name into editing buffer
        
	/* Set up editor. */	
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA, TxtProfileName, (T_AUI_EDIT_CB)AUI_profile_name_edit_cb);

	AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, PROFILENAME_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);

	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
	
#else /* NEW_EDITOR */
	/* Clear editor for name */

	data->Buffer[0] = 0x80;
	data->Buffer[1] = 0x7F;
	ATB_uc_text_copy((USHORT *)&data->Buffer[2], data->View->Profile->Title, PROFILENAME_MAX_LEN);

	/* Set up editor.  */
	
	AUI_standard_editor(&editor_data, data->Buffer, (PROFILENAME_MAX_LEN+2)*sizeof(USHORT), ALPHA_MODE, (T_EDIT_CB)AUI_profile_name_edit_cb);
	
	editor_data.TextId				= TxtProfileName;
	editor_data.min_enter			= 1;				/* Avoid returning empty strings */
			
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}

/*******************************************************************************

 $Function:    	AUI_profile_name_edit_cb

 $Description:	Callback function for editing a profile's title
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_profile_name_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
   	T_WAP_DATA 		*data		= AUI_wap_data();
   	T_WAP_VIEW	*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_profile_name_edit_cb");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(EDIT_WIN);		/* SPR#2086 */
			break;
		
		case INFO_KCD_LEFT:
			/* SPR#1921 - SH - Destroy old list */
			AUI_destroy(LIST_WIN);
			/* Change profile name. SPR#1816 - SH */
                    //CRR 25541: 06 oct 2004 - xpradipg
                    //Send the complete buffer to update the list for the changed entry 
			ATB_wap_entry_change(WAP_PROFILES_LIST, View->ProfilesList,  data->Buffer , View->ProfileId);
			/* Save change to flash */
			ATB_wap_profile_save(View);
			/* List profiles again */
			AUI_list_redraw(WAP_PROFILES_SETUP, TxtChanged);
		default:
			break;
	}
	
	return;
}
		

/*******************************************************************************

 $Function:    	AUI_dialupNumber

 $Description:	Opens up a numeric edit screen for editing the dialup number
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_dialupNumber(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_dialup_number");
#endif

	if (!data)
	{
		return 0;
	}

	strcpy(data->Buffer, data->View->Profile->DialupNumber);					// Copy dialup number into buffer
	AUI_number_edit(WAP_DIALUP_NUMBER, TxtDialupNumber);					// Open editor

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_IPAddress1

 $Description:	Opens up a numeric edit screen for editing the primary IP address
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/
#if 0
int AUI_IPAddress1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress1");
#endif

	if (!data)
	{
		return 0;
	}
	
	strcpy(data->Buffer, data->View->Profile->IPAddress1);						// Copy IP address into edit buffer

	/* Set up editor */

	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS1;             
	editor_data.TextId				= TxtIPAddress1;
	editor_data.min_enter			= 1;										// Avoid returning empty strings
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);							// Create input window
	
	return 1;
}
#endif

int AUI_IPAddress1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress1");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy IP address into edit buffer */
	
	strncpy(data->Buffer, data->View->Profile->IPAddress1, IPADDRESS_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_IP_ADDRESS1, ED_MODE_FORMATTED, TxtIPAddress, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS1;             
	editor_data.TextId				= TxtIPAddress; /* "IP Address" rather than "IP Address 1" (less confusing)*/
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


#if 0
/*******************************************************************************

 $Function:    	AUI_IPAddress2

 $Description:	Opens up a numeric edit screen for editing the secondary IP address
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_IPAddress2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress2");
#endif

   	if (!data)
   	{
   		return 0;
   	}

	strcpy(data->Buffer, data->View->Profile->IPAddress2);						// Copy IP address into edit buffer

	/* Set up editor */

	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS2;             
	editor_data.TextId				= TxtIPAddress2;
	editor_data.min_enter			= 1;										// Avoid returning empty strings
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);							// Create input window
	
	return 1;
}
#endif

int AUI_IPAddress2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress2");
#endif

   	if (!data)
   	{
   		return 0;
   	}

	/* Copy IP address into edit buffer */

	strncpy(data->Buffer, data->View->Profile->IPAddress2, IPADDRESS_MAX_LEN+1);
	
	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_IP_ADDRESS2, ED_MODE_FORMATTED, TxtIPAddress2, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS2;             
	editor_data.TextId				= TxtIPAddress2;
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}

/*******************************************************************************

 $Function:    	AUI_Port1

 $Description:	Opens up a numeric edit screen for editing the primary port
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_Port1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_Port1");
#endif

   	if (!data)
   	{
   		return 0;
	}

	sprintf(data->Buffer, "%d", data->View->Profile->Port1);					// Copy response timer into buffer
	AUI_number_edit(WAP_PORT1, TxtPort1);							// Open editor

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_Port2

 $Description:	Opens up a numeric edit screen for editing the secondary port
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_Port2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_Port2");
#endif

   	if (!data)
   	{
   		return 0;
   	}
   	
	sprintf(data->Buffer, "%d", data->View->Profile->Port2);					// Copy response timer into buffer
	AUI_number_edit(WAP_PORT2, TxtPort2);									// Open editor

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_APN

 $Description:	Opens up a numeric edit screen for editing the APN
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_APN(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_APN");
#endif

	AUI_edit(NULL,WAP_EDIT_APN, TxtAPN, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_username

 $Description:	Opens up a text edit screen for editing the ISP username
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/
#if 0
int AUI_username(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_username");
#endif

	if (!data)
	{
		return 0;
	}
	
	strcpy(data->Buffer, data->View->Profile->Username);						// Copy name into editing buffer

	/* Set up editor */
	
	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_username_cb);
	
	editor_data.TextId				= TxtISPUsername;							// "Username"
	editor_data.hide				= FALSE;
			
	data->edit_win = editor_start(data->parent_win, &editor_data);							// Create input window
	
	return 1;
}
#endif

int AUI_username(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_username");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy name into editing buffer */

	strncpy(data->Buffer, data->View->Profile->Username, USERNAME_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA, TxtISPUsername, (T_AUI_EDIT_CB)AUI_username_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, USERNAME_MAX_LEN+1);
			
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
	
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_username_cb);
	
	editor_data.TextId				= TxtISPUsername;
	editor_data.hide				= FALSE;
			
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}

/*******************************************************************************

 $Function:    	AUI_username_cb

 $Description:	Callback function for editing the ISP username
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_username_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
   	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_username_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy( EDIT_WIN);					/* SPR#2086 */
			break;
		
		case INFO_KCD_LEFT:
			AUI_destroy( EDIT_WIN);						/* SPR#2086 */
			strcpy(data->View->Profile->Username, data->Buffer);				// Change username
			ATB_wap_profile_save(data->View);									// Save change to flash
			AUI_info_dialog(TxtChanged, NULL);			/* SPR#2086 */
			break;
		default:
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_password

 $Description:	Opens up a text edit screen for editing the ISP password
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/
#if 0
int AUI_password(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password");
#endif

	if (!data)
	{
		return 0;
	}
	
	strcpy(data->Buffer, data->View->Profile->Password);						// Copy password into editing buffer

	/* Set up editor */
	
	AUI_standard_editor(&editor_data, data->Buffer, PASSWORD_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb);
	
	editor_data.TextId				= TxtISPPassword;							// "Password"
	editor_data.hide				= TRUE;										// Password is hidden (*****)
			
	data->edit_win = editor_start(data->parent_win, &editor_data);							// Create input window
	
	return 1;
}
#endif
int AUI_password(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy password into editing buffer */
	
	strncpy(data->Buffer, data->View->Profile->Password, PASSWORD_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA | ED_MODE_HIDDEN, TxtISPPassword, (T_AUI_EDIT_CB)AUI_password_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, PASSWORD_MAX_LEN+1);
			
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, PASSWORD_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb);
	
	editor_data.TextId				= TxtISPPassword;
	editor_data.hide				= TRUE;				/* Password is hidden (*****) */
			
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_password_cb

 $Description:	Callback function for editing the ISP password
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_password_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
  	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_password_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy( EDIT_WIN);							/* SPR#2086 */
			break;
		
		case INFO_KCD_LEFT:
			AUI_destroy( EDIT_WIN);		/* SPR#2086 */
			strcpy(data->View->Profile->Password, data->Buffer);				// Change password
			ATB_wap_profile_save(data->View);									// Save change to flash
			AUI_info_dialog(TxtChanged, NULL);		/* SPR#2086 */
			break;
		default:
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_response_timer

 $Description:	Opens up a numeric edit screen for editing the server number
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_response_timer(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_response_timer");
#endif

	if (!data)
	{
		return 0;
	}

	sprintf(data->Buffer, "%d", data->View->Profile->ResponseTimer);			// Copy response timer into buffer
	AUI_number_edit(WAP_RESPONSE_TIMER, TxtResponseTimer);					// Open editor

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_number_edit

 $Description:	Opens up a numeric edit screen.
 				The digits to be edited should be in data->Buffer.
 				SPR#2086 - Removed window parameter, made static void
    	     
 $Returns:		none.

 $Arguments:	identifier	- specifies which edit screen it is (server no. etc)
 				prompt		- prompt, e.g "IP Address"
 
*******************************************************************************/
#if 0
static void AUI_number_edit(int identifier, USHORT prompt)
{
 	T_WAP_DATA *data = AUI_wap_data();
 	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_number_edit()");
#endif

	if (!data)
	{
		return;
	}
	
	/* Set up editor */

	AUI_standard_editor(&editor_data, data->Buffer, NUMBER_MAX_LEN, DIGITS_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	
	editor_data.Identifier			= identifier;								// this is the purpose            
	editor_data.TextId				= prompt;
	editor_data.min_enter			= 1;										// Avoid returning empty strings
			
	data->edit_win = editor_start(data->parent_win, &editor_data);					// Create input window
	
	return;
}
#endif

//int AUI_number_edit(T_MFW_HND parent_win, int identifier, USHORT prompt)
static void  AUI_number_edit(int identifier, USHORT prompt)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

	if (!data)
	{
		return;
	}

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, identifier, 0, prompt, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, NUMBER_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
			
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
	
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, NUMBER_MAX_LEN, DIGITS_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	
	editor_data.Identifier			= identifier;       
	editor_data.TextId				= prompt;
	editor_data.min_enter			= 1;
			
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return;
}

/* Marcus: Issue 1686: 07/03/2003: Start */
/*******************************************************************************

 $Function:    	validate_IP_address

 $Description:	Check the validity of an IP address in the form 255.255.255.255
 
 $Returns:		BOOL, TRUE if valid, else FALSE

 $Arguments:	buffer - the ASCIIZ string containing the IP address to validate
 
*******************************************************************************/

static BOOL validate_IP_address(char *buffer)
{
    char temp[16];
    char *token;
    int  value;
    
    if (strlen(buffer) > sizeof(temp)-1)
        return FALSE;

    strcpy(temp, buffer);
    for (token = strtok(temp, ".");
         token != NULL;
         token = strtok(NULL, "."))
    {
        value = atoi(token);

		/* SPR#1976 - SH - Check for null length IP address too */
        if (strlen(token)==0 || (value < 0) || (value > 255))
            return FALSE;
    }
         
    return TRUE;
}
/* Marcus: Issue 1686: 07/03/2003: End */

/*******************************************************************************

 $Function:    	AUI_number_edit_cb

 $Description:	Callback function for editing a number
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (server or service no.)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_number_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
   	T_WAP_DATA *data = AUI_wap_data();
	T_WAP_PROFILE	*Profile;
	BOOL			valid;
	int				value;

	/* SPR#1976 - SH - Added some more checks to ensure values returned are valid */
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_number_edit_cb");
#endif

	if (!data || !data->View)
	{
		return;
	}

	Profile = data->View->Profile;
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy( EDIT_WIN);				/* SPR#2086 */
			break;
		
		case INFO_KCD_LEFT:
		    {
    			switch(identifier)
    			{
    				case WAP_DIALUP_NUMBER:
    					strcpy(Profile->DialupNumber, data->Buffer);		    // Copy the dialup number to the Profile
						valid = TRUE;
    					break;

    				case WAP_IP_ADDRESS1:
    					valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    					    strcpy(Profile->IPAddress1, data->Buffer);			// Copy the IP address to the Profile
						}
    					else
						{
    					    AUI_info_dialog(TxtOutofRange, TxtNull);  /* SPR#2086 */
						}
    					break;

    				case WAP_IP_ADDRESS2:
    				    valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    					    strcpy(Profile->IPAddress2, data->Buffer);			// Copy the IP address to the Profile
						}
    					else
						{
    					    AUI_info_dialog(TxtOutofRange, TxtNull);  /* SPR#2086 */
						}
    					break;

				//xpradipg - Aug 4,2004: changes for wap 2.0 menus
				case WAP_NAME_SERVER1:
					valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    					    strcpy(Profile->NameServer1, data->Buffer);			// Copy the IP address to the Profile
					}
    					else
					{
    					    AUI_info_dialog(TxtOutofRange, TxtNull);  /* SPR#2086 */
					}
    					break;

				case WAP_NAME_SERVER2:
					valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    					    strcpy(Profile->NameServer2, data->Buffer);			// Copy the IP address to the Profile
					}
    					else
					{
    					    AUI_info_dialog(TxtOutofRange, TxtNull);  /* SPR#2086 */
					}
    					break;


    				case WAP_PORT1:
    					value = atoi(data->Buffer);
    					if (strlen(data->Buffer)>0 && value>=0 && value<=0xFFFF)
    					{
    						valid = TRUE;
    						Profile->Port1 = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    AUI_info_dialog(TxtOutofRange, TxtNull); /* SPR#2086 */
						}
    					break;

    				case WAP_PORT2:
   						value = atoi(data->Buffer);
    					if (strlen(data->Buffer)>0 && value>=0 && value<=0xFFFF)
    					{
    						valid = TRUE;
    						Profile->Port2 = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    AUI_info_dialog(TxtOutofRange, TxtNull); /* SPR#2086 */
						}
    					break;

    				case WAP_RESPONSE_TIMER:
    					value = atoi(data->Buffer);
    					if (strlen(data->Buffer)>0 && value>=0 && value<=0xFFFF)
    					{
    						valid = TRUE;
    						Profile->ResponseTimer = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    AUI_info_dialog(TxtOutofRange, TxtNull); /* SPR#2086 */
						}
    					break;
    			}
    			
    			if (valid)
    			{
        			AUI_destroy( EDIT_WIN); /* SPR#2086 */
        			ATB_wap_profile_save(data->View);									// Save change to flash
        			AUI_info_dialog(TxtChanged, NULL);		/* SPR#2086 */
    			}
		    } 

			break;
		
		default:
			break;
	}
	
	return;

}


/*******************************************************************************

 $Function:    	MMI_AUI_homepage_edit

 $Description:	Opens up a text edit screen for changing the homepage URL
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_homepage_edit(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_homepage_edit");
#endif

	AUI_edit(NULL,WAP_EDIT_HOMEPAGE, TxtEditURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


//xpradipg - Aug 4,2004: changes for wap 2.0 menus
int AUI_NameServer1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_NameServer1");
#endif

   	if (!data)
   	{
   		return 0;
   	}

	/* Copy IP address into edit buffer */

	strncpy(data->Buffer, data->View->Profile->NameServer1, IPADDRESS_MAX_LEN+1);
	
	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_NAME_SERVER1, ED_MODE_FORMATTED, TxtNameServer1, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_NAME_SERVER1;             
	editor_data.TextId				= TxtNameServer1;
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}



int AUI_NameServer2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_NameServer2");
#endif

   	if (!data)
   	{
   		return 0;
   	}

	/* Copy IP address into edit buffer */

	strncpy(data->Buffer, data->View->Profile->NameServer2, IPADDRESS_MAX_LEN+1);
	
	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_NAME_SERVER2, ED_MODE_FORMATTED, TxtNameServer2, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_NAME_SERVER2;             
	editor_data.TextId				= TxtNameServer2;
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


int AUI_PPGAuthentication(MfwMnu * menu, MfwMnuItem * item)
{

	T_WAP_DATA 		*data		= AUI_wap_data();
	T_MFW_HND		setting_win;
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_PPGAuthentication");
#endif

	if (!data)
	{
		return 0;
	}	


/* SPR#2218 - SH - Don't use options_win */
		
	setting_win = bookMenuStart(data->parent_win, WAPPPGAuthenticationAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->PPGAuthentication);
	
	return 1;

}

int AUI_PPGAuthentication_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_PPGAuthentication_set");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->PPGAuthentication= menu->lCursor[menu->level];			// Change connection type
	ATB_wap_profile_save(data->View);											// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);			/* SPR#2086 */
	return 1;
}

int AUI_WirelessProfiledHTTP(MfwMnu * menu, MfwMnuItem * item)
{

	T_WAP_DATA 		*data		= AUI_wap_data();
	T_MFW_HND		setting_win;
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_PPGAuthentication");
#endif

	if (!data)
	{
		return 0;
	}	


/* SPR#2218 - SH - Don't use options_win */
		
	setting_win = bookMenuStart(data->parent_win, WAPWirelessProfiledHTTPAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->WirelessProfiledHTTP);
	
	return 1;

}


int AUI_WirelessProfiledHTTP_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_WirelessProfiledHTTP_set");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->WirelessProfiledHTTP= menu->lCursor[menu->level];			// Change connection type
	ATB_wap_profile_save(data->View);											// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);			/* SPR#2086 */
	return 1;
}

BOOL HTTP_Selected()
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	USHORT PortNumber,PortNumber1;

	PortNumber = data->View->Profile->Port1;
	PortNumber1=data->View->Profile->Port2;

	TRACE_EVENT_P2("The values of Port1 and Port2 are %d  and %d",PortNumber,PortNumber1);
	
	if(data->View->Profile->Port1 ==9201)
		return FALSE;
	return TRUE;
}


/*******************************************************************************

 $Function:    	AUI_connectionType

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionType(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MFW_HND		setting_win;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionType");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#2218 - SH - Don't use options_win */
	
	setting_win = bookMenuStart(data->parent_win, WAPConnectionTypeAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->ConnectionType);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_connectionType_set

 $Description:	Set WAP connection to temporary or permanent
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionType_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionType_set");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->ConnectionType = menu->lCursor[menu->level];			// Change connection type
	ATB_wap_profile_save(data->View);											// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);			/* SPR#2086 */
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_connectionSpeed

 $Description:	SPR#1827 - SH - Added this function
				Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionSpeed(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MFW_HND		setting_win;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionSpeed");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#2218 - SH - Don't use options_win */
		
	setting_win = bookMenuStart(data->parent_win, WAPConnectionSpeedAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->ConnectionSpeed);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_connectionSpeed_set

 $Description:	SPR#1827 - SH - Added this function
 				Set WAP connection speed to analogue, digital
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionSpeed_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionSpeed_set");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->ConnectionSpeed = menu->lCursor[menu->level];			// Change connection type
	ATB_wap_profile_save(data->View);											// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);				/* SPR#2086 */
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_security

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_security(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MFW_HND		setting_win;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_security_on");
#endif

	if (!data)
	{
		return 0;
	}

	/* SPR#2218 - SH - Don't use options win */
	
	setting_win = bookMenuStart(data->parent_win, WAPSecurityOptionAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->Security);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_security_set

 $Description:	Switch security on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_security_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_security_off");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->Security = (BOOL)menu->lCursor[menu->level];
	ATB_wap_profile_save(data->View);											// Save change to flash	
	AUI_info_dialog(TxtChanged, NULL);		/* SPR#2086 */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_access

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_access(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MFW_HND		setting_win;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_access");
#endif

	if (!data)
	{
		return 0;
	}

	/* SPR#2218 - SH - Don't use options win */

	//setting_win = bookMenuStart(data->parent_win, WAPAccessTypeAttributes(), 0); /* SPR#2086 */
	
	setting_win = bookMenuStart(data->parent_win, WAPGPRSDialupAttributes(), 0); /* SPR#2086 */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->AccessType);

	return 1;
}




int AUI_profile_select(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
    
        //xrashmic 23 Dec, 2004 MMI-SPR-27623
	// Store the current profile 
	data->profile_store = data->View->ProfileId;
	
	ATB_wap_profile_save(data->View);
	
	//AUI_info_dialog(data->win, TxtChanged, TxtNull);		
	AUI_info_dialog(TxtChanged, NULL);//2086
  			
	return MFW_EVENT_CONSUMED;
}

/*******************************************************************************

 $Function:    	AUI_access_set

 $Description:	Set access type
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_access_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_access_CSD");
#endif

	if (!data)
	{
		return 0;
	}

	data->View->Profile->AccessType  = menu->lCursor[menu->level];				// Change access type
	ATB_wap_profile_save(data->View);											// Save change to flash	
	AUI_info_dialog(TxtChanged, NULL);		/* SPR#2086 */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_savehist

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_savehist(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA	*data = AUI_wap_data();
	UBYTE SaveHistory;
	T_MFW_HND		setting_win;
	
#ifdef TRACE_AUIWAP	
	TRACE_FUNCTION("AUI_savehist");
#endif

	if (!data)
	{
		return 0;
	}

	/* SPR#2218 - SH - Don't use options win */

	setting_win = bookMenuStart(data->parent_win, WAPSaveHistoryAttributes(), 0); /* SPR#2086 */
	SaveHistory = ATB_wap_profile_setting(WAP_STATUS_SAVEHISTORY);	/* 1 or 0 depending on flag */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &SaveHistory);

	return 1;
}

/*******************************************************************************

 $Function:    	AUI_savehist_set

 $Description:	Set save history on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_savehist_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_savehist_set");
#endif

	if (!data)
	{
		return;
	}
	
	ATB_wap_profile_setting_change(WAP_STATUS_SAVEHISTORY, menu->lCursor[menu->level]); /* SPR#2086 */
	
	ATB_wap_profile_save(data->View);											// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);  /* SPR#2086 */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_scaleimages

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_scaleimages(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA	*data = AUI_wap_data();
	UBYTE ScaleImages;
	T_MFW_HND		setting_win;
	
#ifdef TRACE_AUIWAP	
	TRACE_FUNCTION("AUI_scaleimages");
#endif

	if (!data)
	{
		return 0;
	}

	/* SPR#2218 - SH - Don't use options win */

	setting_win = bookMenuStart(data->parent_win, WAPScaleImagesAttributes(), 0); /* SPR#2086 */
	ScaleImages = ATB_wap_profile_setting(WAP_STATUS_SCALEIMAGES);	/* 1 or 0 depending on flag */
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &ScaleImages);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_scaleimages_set

 $Description:	Set image scaling on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_scaleimages_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_scaleimages_set");
#endif

	if (!data)
	{
		return 0;
	}

	ATB_wap_profile_setting_change(WAP_STATUS_SCALEIMAGES, menu->lCursor[menu->level]); /* SPR#2086 */
	
	ATB_wap_profile_save(data->View);			// Save change to flash
	AUI_info_dialog(TxtChanged, NULL);  /* SPR#2086 */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_info_dialog

 $Description:	Display message for three seconds
 				SPR#2086 - Removed window parameter
 
 $Returns:		None

 $Arguments:	TextId1 			- Id of text string to display
				TextId2 			- Id of text string to display
 
*******************************************************************************/

void AUI_info_dialog(USHORT TxtId1, USHORT TxtId2)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_info_dialog");
#endif
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtId1, TxtId2, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, NULL, THREE_SECS, 0 );
	display_info.Identifier		= 0;
	
	info_dialog(data->parent_win, &display_info);
	return;
}


/*******************************************************************************

 $Function:    	AUI_error_dialog

 $Description:	Display error message for three seconds
 				SPR#1574 - SH - Add "GPRS not supported" message
 
 $Returns:		

 $Arguments:	View			- The current view
 				errorCode		- Number of the error
 
*******************************************************************************/
//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
//The status information is handled by MMS module separatly.
// and wap module separatly
void AUI_error_dialog(T_WAP_VIEW *View, SHORT errorCode)
{
        // xreddymn Mar-05-2005 MMI-SPR-26144: disable dialog display when sending MMS
        if(!MMSactive)
        {
              AUI_wap_error_dialog(View, errorCode);
        }
}

void AUI_wap_error_dialog(T_WAP_VIEW *View, SHORT errorCode)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	static char errorNumber[20];
	char *err;
	USHORT errId1, errId2;
	USHORT lsk, rsk;
	SHORT newCode;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_error_dialog");
	TRACE_EVENT_P1("WAP Error: %d", errorCode);								// Convert the error code to text
#endif

	/* SPR#2086 - SH - Ensure WAP data exists */
	
	data = AUI_wap_data();

	if (!data)
	{
		return;
	}
	/* SPR#1793 - SH - Intercept fatal error */
        //xrashmic 29 Nov, 2004 MMI-SPR-26161
        // When the downloaded data exceeds the limit or the MIME type is not supported, 
        // the download is cancelled and the error is displayed here.
        if((obj_Type == EMtUnknown && downloaded_data_size!=0 ) //download has started but the MIME type is not supported
            ||(downloaded_data_size>MAX_DOWNLOAD)) //download of a supported MIMI type was in progress, but it exceeded the limit
        {
            	if (data->error_win)
		{
			SEND_EVENT(data->error_win, DIALOG_DESTROY, 0, 0);
			data->error_win = NULL;
		}
		if (data->connect_win)
		{
			SEND_EVENT(data->connect_win, DIALOG_DESTROY, 0, 0);
			data->connect_win = NULL;
		}
		if (data->temp_win)
		{
			SEND_EVENT(data->temp_win, DIALOG_DESTROY, 0, 0);
			data->temp_win = NULL;
		}
            if(obj_Type == EMtUnknown)
                //xrashmic 08 Feb, 2005 MMI-SPR-27853
                //Added few more parameters for this function
                 information_dialog(TxtNotSupported, TxtType, NULL,NULL,TxtNull, TxtSoftBack, FOREVER,KEY_RIGHT,NULL);
            else
                //xrashmic 08 Feb, 2005 MMI-SPR-27853
                //Added few more parameters for this function                
                 information_dialog(TxtObject, TxtLarge, NULL,NULL, TxtNull, TxtSoftBack, FOREVER,KEY_RIGHT,NULL);

              downloaded_data_size = 0;
              obj_Type = EMtUnknown;

            return;
        }
	//if (errorCode==8002)
	//OUT OF MEMORY code 0x903 
	if (errorCode==2307)
	{
		TRACE_EVENT("WAP MEMORY FULL");
			
		/* If we're in WAP, error is fatal */
		
		if (data->View)
		{
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtSoftOK, TxtFatalError, TxtErrorOutOfMem, COLOUR_WAP_POPUP);
			dlg_initDisplayData_events( &display_info, NULL, FOREVER, KEY_RIGHT);
			info_dialog(data->parent_win, &display_info);
			AUI_destroy(ALL_WAP); /* SPR#2086 - ALL_WAP for emergency shutdown*/
		}

		return;
	}
	
	/* SPR#1824 - SH - New error message handling */
	
	errId1 = TxtNull;
	errId2 = TxtNull;
	newCode = errorCode;
	
/*	if ((errorCode>=69 && errorCode<=101)
		|| (errorCode>=64 && errorCode<=67)
		|| errorCode==1013)
*/
  if ((errorCode>=1320 && errorCode<=1323)
		|| (errorCode>=1325 && errorCode<=1345)
		|| errorCode==2305 || errorCode==512
    || errorCode==517 || errorCode==518)
	{
		newCode = ERROR_COMMUNICATION_SERVER;
	}

/*	else if ((errorCode>=0 && errorCode<=9)
		|| (errorCode>=224 && errorCode<=227)
		|| (errorCode>=229 && errorCode<=234)
		|| (errorCode>=5300 && errorCode<=5399)
		|| errorCode==1010 || errorCode==1018)
*/
	else if ((errorCode>=768 && errorCode<=780)
		|| errorCode==524)
	{
		newCode = ERROR_COMMUNICATION_GATEWAY;
	}

/*  else if ((errorCode>=1301 && errorCode<=3014)
		|| (errorCode>=4002 && errorCode<=5099)
		|| (errorCode>=5200 && errorCode<=5299)
		|| (errorCode>=5400 && errorCode<=5499)
		|| (errorCode>=6001 && errorCode<=8001)
		|| errorCode==1003 || errorCode==1004
		|| errorCode==1012 || errorCode==1015
		|| errorCode==1016 || errorCode==1019
		|| errorCode==1104)
*/
	else if ((errorCode>=258 && errorCode<=262)
		|| (errorCode>=519 && errorCode<=523)
    || (errorCode>=1543 && errorCode<=1546)
    || (errorCode>=2309 && errorCode<=2313)
    || (errorCode>=1024 && errorCode<=1033)
		|| errorCode==516 || errorCode==1538
    || errorCode==1540 || errorCode==2308
    || errorCode==2565 || errorCode==2566
    || errorCode==256 || errorCode==1536
    || errorCode==1792 || errorCode==2048
    || errorCode==2304)
	{
		newCode = ERROR_UNEXPECTED;
	}

	else if (errorCode>=2560 && errorCode<=2567)
	{
		newCode = ERROR_SECURITY;
	}
	
	switch(newCode)
	{
		case ERROR_GPRS_NOT_SUPPORTED:
			errId1 = TxtGPRS;
			errId2 = TxtNotSupported;
			break;

		/* SPR#1656 - SH - New error when call is disconnected */
		case ERROR_CALL_DISCONNECTED:
			errId1 = TxtConnection;
			errId2 = TxtFailed;
			break;

//		case 8001:
    case 2306:
			errId1 = TxtErrorMemLow; break;
			
		/* Error type 1 */
//		case 68:
    case 1324:
			errId2 = TxtPageNotFound; break;
		/* Error type 2 */
//		case 1008:
    case 257:
			errId2 = TxtInvalidURL; break;
		/* Error type 3 */
//		case 1009:
		case 513:
			errId2 = TxtNoResponse; break;
		/* Error type 4 */
//		case 1011: case 1017: case 1207:
		case 2049: case 2050:
			errId2 = TxtAccessDenied; break;
		/* Error type 5 */
/*		case 1005: case 1006: case 1007:
		case 1020: case 1101: case 1102:
		case 1105: case 1108:
*/    
    case 1798:
		case 1539: case 1542:
			errId2 = TxtErrorInPage; break;
		/* Error type 6 */	
/*		case 1202: case 1203: case 1204:
		case 1205: case 1206: case 1208:
		case 1209: case 1210: case 1211:
		case 1212: case 1213:
*/
		case 1793: case 1794: case 1795:
		case 1796: case 1797: case 1799:
		case 1800:
			errId2 = TxtScriptError; break;
		/* Error type 7 */
		case ERROR_COMMUNICATION_SERVER:
			errId2 = TxtServerError; break;
		/* Error type 8 */
		case ERROR_COMMUNICATION_GATEWAY:
			errId2 = TxtGatewayError; break;
		/* Error type 9 */
		case ERROR_UNEXPECTED:
			errId2 = TxtUnexpectedErr; break;
		/* Error type 10 */
//		case 1103:
    case 1537:
			errId2 = TxtCharacterSet; break;
		/* Error type 11 */
//		case 1106:
    case 1541:
			errId2 = TxtWBXMLError; break;
		/* Error type 13 */
//		case 8002:
    case 2307:
			/* This error already intercepted above */
		case 1001:
			errId2 = TxtErrorOutOfMem; break;
		/* Error type 14 */
/*		case 228:
			errId2 = TxtGatewayBusy; break;
		/* Error type 15 */
//		case 1014:
    case 514:
			errId2 = TxtNoResponse; break;
		/* Error type 16 */
		case ERROR_SECURITY:
			errId2 = TxtSecurityFail; break;
			
//		case 4001:
    case 515:
			errId2 = TxtNoResponse;
			break;

		default:
			if (errorCode<1320)
				errId2 = TxtErrorHTTP;
			break;
	}
	
	/* SPR#1575 - SH - Decide on soft keys.  If browser is not present,
	 * can only exit. */

	if (data->browser_win)
	{
		/* SPR#2086 - SH - Now provide "Exit" option */
		rsk = TxtExit;
		lsk = TxtSoftOK;
	}
	else
	{
		lsk = TxtNull;
		rsk = TxtExit;
	}
	
	/* Set up dialog display data */
	
	dlg_initDisplayData_TextId( &display_info, lsk, rsk, errId1, errId2, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, NULL, FOREVER, KEY_LEFT | KEY_RIGHT);

	/* If no errId1, use "Error <num>" */

	if (errId1==TxtNull)
	{
		sprintf(errorNumber, "%s %d", GET_TEXT(TxtError), errorCode);
		display_info.TextString = errorNumber;
	}

	if (errId2==TxtNull)
	{
		errId2 = TxtUnknown;
	}

	display_info.Callback		= (T_VOID_FUNC)AUI_error_cb;

	/* SPR#1739 - SH - Destroy any previous error dialog */
	if (data->error_win)
	{
		SEND_EVENT(data->error_win, DIALOG_DESTROY, 0, 0);
	}
	data->error_win = info_dialog(data->parent_win, &display_info);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_error_cb

 $Description:	Callback function for the WAP error dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_error_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
   	T_WAP_DATA 		*data		= AUI_wap_data();				// WAP data

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_error_cb");
#endif

	if (!data)
	{
		return;
	}
	
	data->error_win = NULL;				/* SPR#1739 - SH - Coming here, dialog is destroyed */
	data->update_forbid = FALSE;

	/* Destroy any connecting dialog */
	/* SPR#1739 - SH - Do this now with AUI_destroy */
	
	AUI_destroy(CONNECT_WIN); /* SPR#2086 */

	/* SPR#1497 - SH - Softkeys now give two options */
	switch(reason)
	{
		/* Right soft key: Exit
		 * SPR#2086 - Exit browser */
		case INFO_KCD_RIGHT:
			AUI_destroy(RETURN_TO_MENU); /* SPR#2086 */
			break;

		/* Left soft key: OK */
		case INFO_KCD_LEFT:
			/* Now just destroy dialog */
			break;
	}
	
	return;
}

#if 0
/*******************************************************************************

 $Function:    	AUI_standard_editor

 $Description:	Sets up standard attributes for a WAP editor
 
 $Returns:		

 $Arguments:	editor_data		- pointer to existing editor_data
 				size 			- maximum length of editor
 				mode			- editor mode
 				callback		- callback function
 
*******************************************************************************/

void AUI_standard_editor(T_EDITOR_DATA *editor_data, char *buffer, U16 size, UBYTE mode, T_EDIT_CB callback)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_standard_editor");
#endif
	editor_attr_init(&editor_data->editor_attr, ZONE_WAP_EDITOR, edtCurBar1, NULL, buffer, size, COLOUR_EDITOR );
	editor_data->editor_attr.font		= 0;									// Font

	editor_data_init( editor_data, callback, TxtSoftOK, TxtDelete, NULL, 0, mode, FOREVER);
	editor_data->destroyEditor			= FALSE;								// Default: don't destroy editor on exit
	editor_data->hide					= FALSE;								// Default: input not hidden
	editor_data->Identifier				= NULL;									// Default: not used
	
    return;
}
#endif

#ifdef NEW_EDITOR

/*******************************************************************************

 $Function:    	AUI_standard_editor

 $Description:	Sets up standard attributes for a WAP editor
 
 $Returns:		None

 $Arguments:	editor_data		- pointer to existing editor_data
 				buffer			- Text buffer to edit
 				size 			- maximum length of editor
 				mode			- editor mode
 				callback		- callback function
 				unicode			- TRUE if editor is unicode
 
*******************************************************************************/

 void AUI_standard_editor(T_AUI_EDITOR_DATA *editor_data, USHORT identifier, USHORT mode, USHORT titleId, T_AUI_EDIT_CB Callback)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_standard_editor");
#endif

	AUI_edit_SetDefault(editor_data);
	AUI_edit_SetEvents(editor_data, identifier, FALSE, FOREVER, Callback);
	AUI_edit_SetTextStr(editor_data, TxtSoftOK, TxtDelete, titleId, NULL);
	// xreddymn Jan-11-2005 MMI-SPR-27618: For read-only modes don't display the cursor
	if(mode & ED_MODE_READONLY)
	{
		AUI_edit_SetMode(editor_data, mode, ED_CURSOR_NONE);
	}
	else
	{
		AUI_edit_SetMode(editor_data, mode, DS_CURSOR_BAR);
	}
	AUI_edit_SetDisplay(editor_data, ZONE_WAP_EDITOR, COLOUR_EDITOR, EDITOR_FONT);
	
    return;
}

#else /* NEW_EDITOR */

/*******************************************************************************

 $Function:    	AUI_standard_editor

 $Description:	Sets up standard attributes for a WAP editor
 
 $Returns:		None

 $Arguments:	editor_data		- pointer to existing editor_data
 				buffer			- Text buffer to edit
 				size 			- maximum length of editor
 				mode			- editor mode
 				callback		- callback function
 
*******************************************************************************/

 void AUI_standard_editor(T_EDITOR_DATA *editor_data, char *buffer, U16 size, UBYTE mode, T_EDIT_CB callback)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_standard_editor");
#endif
	editor_attr_init(&editor_data->editor_attr, ZONE_WAP_EDITOR, edtCurBar1, NULL, buffer, size, COLOUR_EDITOR );
	editor_data->editor_attr.font		= 0;

	editor_data_init( editor_data, callback, TxtSoftOK, TxtDelete, NULL, 0, mode, FOREVER);
	editor_data->destroyEditor			= FALSE;		/* Default: don't destroy editor on exit */
	editor_data->hide					= FALSE;		/* Default: input not hidden */
	editor_data->Identifier				= 0;
	
    return;
}

#endif /* NEW_EDITOR */


/*******************************************************************************

 $Function:    	AUI_wap_input_dialog_open

 $Description:	Prompts the MMI to open an input dialog given a particular format and
 				string.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 				View			- The current view
 
*******************************************************************************/
#if 0
T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();												/* WAP data */
	USHORT			formatIndex;
	USHORT			bufferIndex;
	USHORT			bufferLength;											/* Length of original buffer */
	T_EDITOR_DATA	editor_data;
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_input_dialog_open");
#endif

	/* SPR#1816 - SH - Number of modifications for unicode.
	 * Title is converted to Unicode, although input string is still taken as ASCII.
	 * Buffer2 is used to store format characters, rather than use extra Format buffer
	 * If no title is supplied, use string "Untitled" */
	 
	if (!data)
	{
		return 0;
	}
	
	data->gen_pointer = Dialog->dialog_pointer;									// Needed by GLE

	if (Dialog->size > INPUT_MAX_LEN)											// No more than max chars accepted
		Dialog->size = INPUT_MAX_LEN;

	/* Convert input string to ASCII */
	ATB_uc_text_convert(Dialog->Input, Dialog->input_length);
	bufferLength = ATB_uc_to_char(data->Buffer, Dialog->Input, INPUT_MAX_LEN);

	/* Convert title to MMI unicode and crop it to fit screen */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);

	if (Dialog->title_length>0)
	{
		titlelen = AUI_text_to_uc(data->Message.text, Dialog->Title, CARD_TITLE_MAX_LEN);       // Convert title to char, store in output buffer
		ATB_uc_text_crop(&data->Message.text[1], titlelen, WAP_SCREEN_WIDTH);		// Crop message to fit
	}
	else
	{
		data->Message.text[0] = 0x7F80;
		AUI_wap_stringID(&data->Message.text[1], CARD_TITLE_MAX_LEN, WAP_STRING_UNTITLED);
	}
	
	/* Convert format characters to ascii */

	ATB_uc_text_convert((USHORT *)Dialog->Format, (USHORT)Dialog->format_length);
	ATB_uc_to_char(data->Buffer2, Dialog->Format, (USHORT)Dialog->format_length);   // Convert format string to char, store in format buffer

	/* Set up standard editor parameters */
	
	AUI_standard_editor(&editor_data, data->Buffer, (Dialog->size+1), ALPHA_MODE, (T_EDIT_CB)AUI_input_cb);

	/* Need to set input mode & put fixed characters into input buffer */
	
	if (Dialog->format_length != 0)												// If we're using formatted input
	{	
		editor_data.mode			= FORMAT_MODE;                				// Special mode for formatted input
		formatIndex = 0;
		bufferIndex = 0;
		
		while (bufferIndex<Dialog->size && formatIndex<strlen(data->Buffer2))
		{
			if (data->Buffer2[formatIndex] == '\\')							// Backslash character indicates fixed char
			{
				formatIndex++;
				data->Buffer[bufferIndex] = data->Buffer2[formatIndex];		// Put fixed char into buffer
			}
			else if (strchr("123456789*", data->Buffer2[formatIndex]))			// In a delimited field...
			{
				if (bufferIndex<bufferLength)									// if we're not at the end of the string, 
					formatIndex--;												// stay where we are in the formatstring
				else
					formatIndex++;												// otherwise go to end of string
			}
			else if (bufferIndex>=bufferLength)									// If we're past the end of the existing buffer...
			{
				data->Buffer[bufferIndex] = ' ';								// Fill it with empty space
			}
			bufferIndex++;
			formatIndex++;
		}
	
		data->Buffer[bufferIndex] = 0;										// Terminate the buffer string
	}

	editor_data.Identifier			= Dialog->dialog_id;						// this is the dialog identity (to be passed to callback)
	editor_data.TextString			= (char *)data->Message.text;				// String to be displayed in output buffer
	editor_data.FormatString		= data->Buffer2;							// Provide the editor with the format string
	
	if (Dialog->is_password)
	{
		editor_data.hide			= TRUE;	
	}
	
	if (!Dialog->empty_ok)
		editor_data.min_enter		= 1;										// Won't accept empty input
			
	data->edit_win = editor_start(data->parent_win, &editor_data); /* SPR#2086 */						// Create input window
	
	return WAP_OK;
}
#endif

//T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog)
T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();												/* WAP data */
	USHORT			formatIndex;
	USHORT			bufferIndex;
	USHORT			bufferLength;
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	USHORT			titlelen;
	USHORT			mode;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_input_dialog_open");
#endif
	
	if (!data)
	{
		return 0;
	}

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, Dialog->dialog_id, ED_MODE_ALPHA, TxtNull, (T_AUI_EDIT_CB)AUI_input_cb);
#endif /* NEW_EDITOR */

	data->gen_pointer = Dialog->dialog_pointer;		/* Needed by GLE */

	if (Dialog->size > INPUT_MAX_LEN)
	{
		Dialog->size = INPUT_MAX_LEN;
	}

	/* SPR#2393 - SH - Ensure input buffer isn't > max size */
	
	if (Dialog->input_length > Dialog->size)
	{
		Dialog->input_length = Dialog->size;
	}
	
	/* Terminate buffer */
	
	Dialog->Input[Dialog->input_length] = 0;
	
	/* Convert input string */
	/* xreddymn Sep-10-2004 MMI-SPR-24121: Dialog->Input is the buffer passed by the browser,
	 * and should not be directly modified. Changes have been made to convert
	 * a copy of the buffer instead.
	 */
	//ATB_uc_text_convert(Dialog->Input, Dialog->input_length);

#ifdef NEW_EDITOR
	/* Buffer is unicode */
	bufferLength = ATB_uc_text_copy((USHORT *)data->Buffer, Dialog->Input, INPUT_MAX_LEN);
	// xreddymn Sep-10-2004 MMI-SPR-24121
	ATB_uc_text_convert((USHORT*)data->Buffer, bufferLength);
#else
	/* Buffer is ascii */
	bufferLength = ATB_uc_to_char(data->Buffer, Dialog->Input, INPUT_MAX_LEN);
#endif /* NEW_EDITOR */

	/* Convert title to MMI unicode and crop it to fit screen */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);

	if (Dialog->title_length>0)
	{
		titlelen = AUI_text_to_uc(data->Message.text, Dialog->Title, CARD_TITLE_MAX_LEN); 
		ATB_uc_text_crop(&data->Message.text[1], titlelen, WAP_SCREEN_WIDTH);
#ifdef NEW_EDITOR
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtNull, (UBYTE *)data->Message.text);
#endif /* NEW_EDITOR */
	}
	else
	{
#ifdef NEW_EDITOR
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtUntitled, NULL);
#else
		data->Message.text[0] = 0x7F80;
		AUI_wap_stringID(&data->Message.text[1], CARD_TITLE_MAX_LEN, WAP_STRING_UNTITLED);
#endif /* NEW_EDITOR */
	}
	
	/* Convert format characters to ascii */

	ATB_uc_text_convert((USHORT *)Dialog->Format, (USHORT)Dialog->format_length);
	ATB_uc_to_char(data->Buffer2, Dialog->Format, (USHORT)Dialog->format_length);

	/* Set up standard editor parameters */

#ifdef NEW_EDITOR
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, Dialog->size+1);

	mode = ED_MODE_ALPHA;
	
	if (Dialog->format_length != 0)
	{
		AUI_edit_SetFormatStr(&editor_data, data->Buffer2, TRUE, ' ');
		mode |= ED_MODE_FORMATTED;
	}
	
	if (Dialog->is_password)
	{
		mode |= ED_MODE_HIDDEN;
	}
	
	if (!Dialog->empty_ok)
	{
		AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	}

	AUI_edit_SetMode(&editor_data, mode, DS_CURSOR_BAR);
	
	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else
	AUI_standard_editor(&editor_data, data->Buffer, (Dialog->size+1), ALPHA_MODE, (T_EDIT_CB)AUI_input_cb);

	/* Need to set input mode & put fixed characters into input buffer */
	
	if (Dialog->format_length != 0)
	{	
		editor_data.mode = FORMAT_MODE;
		formatIndex = 0;
		bufferIndex = 0;
		
		while (bufferIndex<Dialog->size && formatIndex<strlen(data->Buffer2))
		{
			/* Backslash character indicates fixed character */

			if (data->Buffer2[formatIndex] == '\\')
			{
				formatIndex++;
				/* Put fixed char into buffer */
				data->Buffer[bufferIndex] = data->Buffer2[formatIndex];
			}

			/* In a delimited field... */

			else if (strchr("123456789*", data->Buffer2[formatIndex]))
			{
				if (bufferIndex<bufferLength)	/* if we're not at the end of the string,  */
					formatIndex--;				/* stay where we are in the formatstring */
				else
					formatIndex++;				/* otherwise go to end of string */
			}
			
			/* If we're past the end of the existing buffer... */
			
			else if (bufferIndex>=bufferLength)
			{
				data->Buffer[bufferIndex] = ' ';	/* Fill it with empty space */
			}
			bufferIndex++;
			formatIndex++;
		}
	
		data->Buffer[bufferIndex] = 0;				/* Terminate the buffer string */
	}

	editor_data.Identifier = Dialog->dialog_id;		/* this is the dialog identity (to be passed to callback) */
	editor_data.TextString = (char *)data->Message.text;	/* String to be displayed in output buffer */
	editor_data.FormatString = data->Buffer2;			/* Provide the editor with the format string */

	/* Check if input needs to be hidden */
	
	if (Dialog->is_password)
	{
		editor_data.hide = TRUE;	
	}

	/* Is an empty response OK? */
	
	if (!Dialog->empty_ok)
		editor_data.min_enter = 1;

	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif

	return WAP_OK;
}

/*******************************************************************************

 $Function:    	AUI_input_cb

 $Description:	Callback function for the WAP input dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_input_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_MMI_WAP_INPUT_DIALOG_CNF DialogCnf;
	BOOL 			edited;
	USHORT		textlen;	/* SPR#1816 - SH*/

	TRACE_FUNCTION("AUI_input_cb()");

	if (!data)
	{
		return;
	}


	/* SPR#1816 - SH - Free message string */
	AUI_wap_string_free(&data->Message);
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			edited = FALSE;														// Don't change text
			break;

		default:
			edited = TRUE;														// Text is changed
			break;
	}

	// xreddymn Sep-09-2004 MMI-SPR-24121: data->Buffer is not expected to be ASCIIZ here
#ifdef NEW_EDITOR
	textlen = LEa_strlen(data->Buffer);
#else // NEW_EDITOR
	textlen = strlen(data->Buffer);
#endif // NEW_EDITOR
	DialogCnf.object_id		= data->View->object_id;
	DialogCnf.dialog_id		= identifier;										// Dialog id is passed from AUI_input
	DialogCnf.Text 			= (USHORT *)AUI_wap_memory_alloc((textlen+1)*sizeof(USHORT));
	/* xreddymn Sep-08-2004 MMI-SPR-24121: Added different implementations for new and old editors.
	 * In case of the new editor, DialogCnf.Text is already in MMI Unicode and only requiers byte swapping.
	 */
#ifdef NEW_EDITOR
	DialogCnf.text_length = ATB_uc_text_copy((USHORT *)DialogCnf.Text, (USHORT *)data->Buffer, (USHORT)INPUT_MAX_LEN);
	ATB_uc_text_convert((USHORT *)DialogCnf.Text, (USHORT)DialogCnf.text_length);
	((USHORT*)DialogCnf.Text)[DialogCnf.text_length]='\0';
	DialogCnf.text_length++; // To accomodate End of String character '\0'
#else // NEW_EDITOR
	/* SPR#1816 - SH - Convert buffer text to MMI unicode, then convert to normal unicode */
	DialogCnf.text_length	= ATB_char_to_uc(DialogCnf.Text, data->Buffer); 	// ..and now updated input string
	ATB_uc_text_convert((USHORT *)DialogCnf.Text, (USHORT)DialogCnf.text_length);
#endif // NEW_EDITOR
	DialogCnf.edited 		= edited;											// TRUE if text changed
	DialogCnf.dialog_pointer    = data->gen_pointer;							// Needed by GLE

	ATB_wap_input_dialog_closed(&DialogCnf);							// Send data to ATB

	AUI_wap_memory_free((UBYTE *)DialogCnf.Text, (textlen+1)*sizeof(USHORT));

	AUI_destroy(EDIT_WIN);	/* SPR#2086 */

	// xreddymn Sep-08-2004 MMI-SPR-24121: After editing is complete, the browser may continue to update the screen
	data->update_forbid=FALSE;
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_password_dialog_open

 $Description:	Prompts the MMI to open a password dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 				View			- The current view
 
*******************************************************************************/
#if 0
T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_EDITOR_DATA	editor_data;
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_password_dialog_open");
#endif

	/* SPR#1816 - SH - Title is now unicode */
	
	if (Dialog->input_length > USERNAME_MAX_LEN)											// Crop input to max length
	{
		Dialog->input_length = USERNAME_MAX_LEN;
		Dialog->Input[USERNAME_MAX_LEN] = NULL;
	}
	
	strncpy(data->Buffer, Dialog->Input, Dialog->input_length);	/* Input field is char type */

	/* Allocate, convert and crop title */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);
	titlelen = AUI_text_to_uc(data->Message.text, Dialog->Message, CARD_TITLE_MAX_LEN);       /* Convert title to MMI unicode */
	ATB_uc_text_crop(&data->Message.text[1], titlelen, WAP_SCREEN_WIDTH);		/* Crop title to fit */
	
	/* Need to prompt for two separate things: the username and password! */

	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb_1);

	editor_data.Identifier			= Dialog->dialog_id;						// this is the dialog identity (to be passed to callback)
	editor_data.TextString			= (char *)data->Message.text;
	
	data->edit_win = editor_start(data->parent_win, &editor_data);	 /* SPR#2086 */					// Create input window
	
	return WAP_OK;
}
#endif

//T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog)
T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_password_dialog_open");
#endif

	if (!data)
	{
		return WAP_FAIL;
	}

	/* SPR#2393 - Clear buffer */
	
	memset(data->Buffer, 0, USERNAME_MAX_LEN+1);	/* Input field is char type */
	
	/* Need to prompt for two separate things: the username and password! */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, Dialog->dialog_id, ED_MODE_ALPHA, TxtISPUsername, (T_AUI_EDIT_CB)AUI_password_cb_1);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, USERNAME_MAX_LEN+1);
	AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtISPUsername, NULL);

	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = AUI_edit_Start(data->parent_win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb_1);

	editor_data.Identifier = Dialog->dialog_id; /* this is the dialog identity (to be passed to callback) */
	editor_data.TextId = TxtISPUsername; /* SPR#2393 */
	
	/* Don't update WAP browser window while editor is open */
	data->update_forbid = TRUE;
	
	data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_password_cb_1

 $Description:	Callback function for the WAP password dialog, after username entered.
 				Prompts for password.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/
#if 0
static void AUI_password_cb_1(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();				// WAP data
	T_EDITOR_DATA	editor_data;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password_dialog_cb_1");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(EDIT_WIN);									/* SPR#2086 */
			break;

		case INFO_KCD_LEFT:
			data->Buffer2[0] = NULL;											// Empty string for password
			
			AUI_standard_editor(&editor_data, data->Buffer2, PASSWORD_MAX_LEN, ALPHA_MODE,
				(T_EDIT_CB)AUI_password_cb_2);

			editor_data.Identifier	= identifier;								// this is the dialog identity
			editor_data.TextString	= (char *)data->Message.text;				/* SPR#1816 - SH */
			editor_data.hide		= TRUE;

			data->temp_win = data->edit_win;									// Store pointer to this edit window
			data->edit_win = editor_start(data->parent_win, &editor_data); /* SPR#2086 */
	
			return;
   			break;
	}
	return;
}
#endif
//static void AUI_password_cb_1(T_MFW_HND win, USHORT identifier, USHORT reason)
static void AUI_password_cb_1(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	T_MMI_WAP_PASSWORD_DIALOG_CNF DialogCnf; /* SPR#2393 */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password_dialog_cb_1");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			//AUI_destroy(data->win,EDIT_WIN);	/* Destroy edit window */
			AUI_destroy(EDIT_WIN);
			
			/* SPR#2393 - SH - WAP browser can update again */
			data->update_forbid = FALSE;

			/* SPR#2393 - SH - Force an update, otherwise editor screen
			 * shows forever */
			win_show(data->browser_win);

			/* SPR#2393 - SH - Send NULL username/password to indicate dialog cancelled */
			DialogCnf.object_id		= data->View->object_id;
			DialogCnf.dialog_id		= identifier;
			DialogCnf.input_length	= 0;
			DialogCnf.Input 		= NULL;
			DialogCnf.password_length  = 0;
			DialogCnf.Password		= NULL;
			ATB_wap_password_dialog_closed(&DialogCnf);
			break;

		case INFO_KCD_LEFT:
			data->Buffer2[0] = NULL;		/* Empty string for password */

#ifdef NEW_EDITOR
			AUI_standard_editor(&editor_data, identifier, ED_MODE_ALPHA | ED_MODE_HIDDEN, TxtNull, (T_AUI_EDIT_CB)AUI_password_cb_2);
			AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer2, PASSWORD_MAX_LEN+1);
			AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtISPPassword, NULL);

			data->temp_win = data->edit_win;				/* Store pointer to this edit window */
			data->edit_win = AUI_edit_Start(data->parent_win, &editor_data); /* Create input window */

#else /* NEW_EDITOR */
			AUI_standard_editor(&editor_data, data->Buffer2, PASSWORD_MAX_LEN, ALPHA_MODE,
				(T_EDIT_CB)AUI_password_cb_2);

			editor_data.Identifier	= identifier;					/* this is the dialog identity */
			editor_data.TextString	= (char *)data->Message.text;
			editor_data.hide		= TRUE;

			data->temp_win = data->edit_win;				/* Store pointer to this edit window */
			data->edit_win = editor_start(data->parent_win, &editor_data);
#endif /* NEW_EDITOR */

			return;
   			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_password_cb_2

 $Description:	Callback function for the WAP password dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_password_cb_2(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();					// WAP data
	T_MMI_WAP_PASSWORD_DIALOG_CNF DialogCnf;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password_cb_2");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1816 - SH - Free message string */
	AUI_wap_string_free(&data->Message);
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(EDIT_WIN);									/* SPR#2086 */
			data->edit_win = data->temp_win;									// Reinstate previous edit window
			data->temp_win = NULL;
			break;

		case INFO_KCD_LEFT:
			DialogCnf.object_id		= data->View->object_id;
			DialogCnf.dialog_id		= identifier;
			DialogCnf.input_length	= strlen(data->Buffer);
			DialogCnf.Input 		= data->Buffer;
			DialogCnf.password_length  = strlen(data->Buffer2);
			DialogCnf.Password		= data->Buffer2;
			AUI_destroy(EDIT_WIN);					/* SPR#2086 */
			data->edit_win = data->temp_win;
			data->temp_win = NULL;
			AUI_destroy(EDIT_WIN);					/* SPR#2086 */
			ATB_wap_password_dialog_closed(&DialogCnf);
   			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_confirm_dialog_open

 $Description:	Prompts the MMI to open a confirmation dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 				View			- The current view
 
*******************************************************************************/

T_WAP_RES AUI_wap_confirm_dialog_open(T_WAP_MMI_CONFIRM_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	USHORT			titlelen;


#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_confirm_dialog_open");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* SPR#1816 - SH - Title, Left SK, Right SK are now unicode */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);
	
	titlelen = AUI_text_to_uc(data->Message.text, Dialog->Message, CARD_TITLE_MAX_LEN);	// Convert current input to char type, store in output buffer
	ATB_uc_text_crop(data->Message.text, titlelen, WAP_SCREEN_WIDTH);
	AUI_text_to_uc(data->LeftSoftKey, Dialog->Ok_key, Dialog->ok_key_length);
	AUI_text_to_uc(data->RightSoftKey, Dialog->Cancel_key, Dialog->cancel_key_length);

	dlg_initDisplayData_TextStr( &display_info, TxtNull, TxtNull, (char *)data->Message.text, NULL, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_confirm_cb, FOREVER, KEY_CLEAR | KEY_LEFT | KEY_RIGHT );
	display_info.LSKString		= (char *)data->LeftSoftKey;
	display_info.RSKString		= (char *)data->RightSoftKey;
	display_info.Identifier		= Dialog->dialog_id;
	
	info_dialog_softkeystrings (data->parent_win, &display_info); /* SPR#2086 */
	return WAP_OK;
}

			
/*******************************************************************************

 $Function:    	AUI_confirm_cb

 $Description:	Callback function for the WAP confirmation dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window 
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_confirm_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();						// WAP data
	T_MMI_WAP_CONFIRM_DIALOG_CNF DialogCnf;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_confirm_cb");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1816 - SH - Free message string */
	AUI_wap_string_free(&data->Message);
	
	switch (reason)
	{
		case INFO_KCD_HUP:
			AUI_destroy(EDIT_WIN);	/* SPR#2086 */
			break;
		
		case INFO_KCD_RIGHT:
			DialogCnf.dialog_id	= identifier;									// Dialog id is passed from AUI_input
   			DialogCnf.answer	= FALSE;										// Confirmation is false
   			
   			AUI_destroy(EDIT_WIN);					/* SPR#2086 */
  			ATB_wap_confirm_dialog_closed(&DialogCnf);							// Send data to ATB
			break;

		case INFO_KCD_LEFT:
			DialogCnf.dialog_id	= identifier;									// Dialog id is passed from AUI_input
   			DialogCnf.answer	= TRUE;											// Confirmation is true
   			AUI_destroy(EDIT_WIN);			/* SPR#2086 */
  			ATB_wap_confirm_dialog_closed(&DialogCnf);							// Send data to ATB
   			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_info_dialog_open

 $Description:	Prompts the MMI to open an info dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 				View			- The current view
 
*******************************************************************************/

T_WAP_RES AUI_wap_info_dialog_open(T_WAP_MMI_INFO_DIALOG_REQ *Dialog, T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_info_dialog_open");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* SPR#1816 - SH - Title is now unicode */
	
	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);
	
	titlelen = AUI_text_to_uc(data->Message.text, Dialog->Message, CARD_TITLE_MAX_LEN);	// Store message in output buffer as char
	ATB_uc_text_crop(data->Message.text, titlelen, WAP_SCREEN_WIDTH);
	
	dlg_initDisplayData_TextStr( &display_info, TxtNull, TxtNull, (char *)data->Message.text, NULL, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_info_cb, THREE_SECS, 0 );
	info_dialog(data->parent_win, &display_info); /* SPR#2086 */

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_info_cb

 $Description:	Callback function for the WAP confirmation dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_info_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();				// WAP data
	T_MMI_WAP_CONFIRM_DIALOG_CNF DialogCnf;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_info_cb");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1816 - SH - Free message string */
	AUI_wap_string_free(&data->Message);
	
	DialogCnf.dialog_id	= identifier;										// Dialog id is passed from AUI_input
   	DialogCnf.answer	= TRUE;												// Confirmation is true
   	AUI_destroy(EDIT_WIN);		/* SPR#2086 */
  	ATB_wap_confirm_dialog_closed(&DialogCnf);								// Send data to ATB

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_options_menu_open

 $Description:	The ATB will send to the AUI the contents of the menu list
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	contextType	- the context, to specify the first item in the menu
 
*******************************************************************************/

T_WAP_RES AUI_wap_options_menu_open(UBYTE contextType)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE 			startIndex;
	UBYTE			optionIndex;
	const USHORT	optionsItems[]		= {TxtBookmark, TxtBookmarks, TxtGoTo, TxtHomepage, TxtSoftBack, TxtReload, TxtExit };
	const USHORT	contextItem[]		= {TxtGoToLink, TxtEdit, TxtSelect, TxtSelect, TxtSelect, TxtSelect, TxtSelect, TxtSelect, TxtSave};
	T_WAP_LIST		*OptionsList;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_options_menu_open");
#endif

	if (!data)
	{
		return WAP_FAIL;
	}
	// xreddymn Jun-28-2005 MMI-SPR-32467
	ATB_animated_GIF_clear();

	OptionsList = (T_WAP_LIST *)data->OptionsList;
	data->update_forbid = TRUE;
	startIndex = 0;

	OptionsList->no_of_entries = MAX_OPTIONS;

	if (contextType!=NULL)														// If context key is supplied, put it in
	{
		OptionsList->no_of_entries++;
		/* SPR#1816 - SH - Options are now unicode.  Allocate memory and convert from text tags */
		OptionsList->Entry[0] = (char *) AUI_wap_memory_alloc((SOFTKEY_MAX_LEN+1)*sizeof(USHORT));
		AUI_textid_to_uc((USHORT *)OptionsList->Entry[0], contextItem[contextType-1], SOFTKEY_MAX_LEN);
		startIndex = 1;															// Start filling menu from second entry
	}

	for (optionIndex=startIndex; optionIndex<OptionsList->no_of_entries; optionIndex++)  // Fill in rest of entries
	{
		/* SPR#1816 - SH - Options are now unicode.  Allocate memory and convert from text tags */
		OptionsList->Entry[optionIndex] = (char *) AUI_wap_memory_alloc((SOFTKEY_MAX_LEN+1)*sizeof(USHORT));

		AUI_textid_to_uc((USHORT *)OptionsList->Entry[optionIndex], optionsItems[optionIndex-startIndex], SOFTKEY_MAX_LEN);
	}

	data->optionsmenu_data = AUI_entry_list_create (data->parent_win, OptionsList, (ListCbFunc)AUI_options_menu_cb,0);
	data->optionsmenu_win = data->optionsmenu_data->win;

	return WAP_OK;
}

/*******************************************************************************

 $Function:    	savePluginImage

 $Description:	Saves the plugin image into the Object Manager
                       //xrashmic 28 Jan, 2005 MMI-SPR-28166
 $Returns:		void		

 $Arguments:	win				- parent window
 				EntryListData	- list menu data of bookmarks lsit
 
*******************************************************************************/

void savePluginImage()
{
    TRACE_FUNCTION("savePluginImage");
    switch(PluginObjectType)
    {
        case IMAGE_JPG:
            obj_Type=EMtMimeJpeg;
            break;
        case IMAGE_GIF:
            obj_Type=EMtMimeGif;
            break;
        case IMAGE_PNG:
            obj_Type=EMtMimePng;
            break;
        case IMAGE_WBMP:
            obj_Type=EMtMimeWbmp;
            break;
        case IMAGE_BMP:
            obj_Type=EMtMimeBmp;
            break;
        case IMAGE_UNKNOWN :
        default:            
            obj_Type=EMtUnknown;
            break;
    }
    if(saveObjectPlugin)
    {
        if(obj_Type==EMtUnknown)
            information_dialog(TxtNotSupported, TxtType, NULL, NULL, TxtNull,TxtNull,FOREVER,KEY_RIGHT|KEY_HUP,NULL);    
        else
            M4_StorePluginObject(downloaded_data, downloaded_data_size,obj_Type);        
    }
    else
        information_dialog(TxtImage,TxtLarge, NULL, NULL, TxtNull,TxtNull,FOREVER,KEY_RIGHT|KEY_HUP,NULL);
}
/*******************************************************************************

 $Function:    	AUI_options_menu_cb

 $Description:	Callback function for options menu
 
 $Returns:		void		

 $Arguments:	win				- parent window
 				EntryListData	- list menu data of bookmarks lsit
 
*******************************************************************************/
static void AUI_options_menu_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	UBYTE			no_of_entries;	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_options_menu_cb");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;

	/* SPR#1721 - SH - Update forbid now set to false in AUI_destroy */
	
	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:	
			/* Option is selected... */
			no_of_entries = EntryListData->ListLength;
			data->OptionSelect = EntryListData->ListPosition;					// Store selected option no.
			
			if (no_of_entries>MAX_OPTIONS)										// i.e. there's a contextual key in menu
			{
				if (data->OptionSelect==0)										// if we've selected it...
				{
					AUI_destroy(OPTIONSMENU_WIN);	/* SPR#2086 */
                                    //xrashmic 28 Jan, 2005 MMI-SPR-28166
                                    // For Plugin images, When Save item is selected  in the option menu,
                                    // we save the image into the object manager
                                    if(pluginImageDisplayed)
                                        savePluginImage();
                                   else
					ATB_wap_options_menu_select(View);							// tell ATB to do something
					return;
				}
				else
					data->OptionSelect--;										// Otherwise, pretend it isn't there
			}

			switch(data->OptionSelect)
			{
  				case WAP_ADDBOOKMARK:	
  					/* SPR#1816 - SH - Title is unicode, cast to char */
					if (ATB_wap_entry_add(View->Bookmarks, (char *)View->Title)==WAP_FAIL) // Try to add current title to bookmarks
						AUI_info_dialog(TxtBookmarks, TxtFull);	/* SPR#2086 */
					else
					{
						ATB_wap_entry_add(View->BookmarksURL, View->URL);		// Store URL
						ATB_wap_profile_save(View);								// Save change to flash
						AUI_info_dialog(TxtStored, NULL);		/* SPR#2086 */
					}
					break;
    			
				case WAP_BOOKMARKS:
					AUI_entry_list(View->Bookmarks, (ListCbFunc) AUI_bookmarks_list_cb,0); /* SPR#2086 */
    				break;

    			case WAP_GOTO:
    			/* SPR#1684 - SH - Destroy any previous options menu existing */
					if (data->options_win)
					{
						AUI_destroy(OPTIONS_WIN); /* SPR#2086 */
					}
					data->options_win = bookMenuStart(win, WAPGoToAttributes(), 0);	// Create WAP Menu again
					SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_goto_cb);  // Add our own callback
  					break;
  				
    			case WAP_HOMEPAGE:	
    				AUI_destroy(OPTIONSMENU_WIN);	/* SPR#2086 */
    				AUI_wap_connect_URL(View->Profile->Homepage);	/* SPR#2086 - modified */
    				break;
    			
    			case WAP_BACK:
    				AUI_destroy(OPTIONSMENU_WIN);				/* SPR#2086 */
    				ATB_wap_card_go_back(View);									// Go to previous card
    				break;

    			case WAP_RELOAD:
    				AUI_destroy(OPTIONSMENU_WIN);				/* SPR#2086 */
    				ATB_wap_card_refresh(View);									// Reload current card
    				break;
    			
    			case WAP_EXIT:
    				AUI_destroy(RETURN_TO_MENU);	/* SPR#2086 */
    				break;
			}
			break;

  		case LISTS_REASON_BACK:													// Exit menu (back, timeout etc).
  		case LISTS_REASON_CLEAR:	
			AUI_destroy(OPTIONSMENU_WIN);		/* SPR#2086 */
  			break;

  		default:
  			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_goto_cb

 $Description:	Callback function for the goto URL menu
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

static void AUI_goto_cb(T_MFW_HND parent_win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();			// WAP data

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_cb");
#endif

	if (!data)
	{
		return;
	}
	
	data->options_win = NULL; /* SPR#2086 */
	return;
}


/*******************************************************************************

 $Function:    	AUI_options_cb

 $Description:	Callback function for the options menu
 
 $Returns:		None

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

void AUI_options_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA	*data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_options_cb");
#endif

	if (!data)
	{
		return;
	}
	
	data->options_win = NULL;
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_memory_alloc

 $Description:	Called by the WAP.ATB to allocate memory.
 
 $Returns:		Address if successful, null if not.

 $Arguments:	size of memory to be allocated.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

U8* AUI_wap_memory_alloc(U32 size)
{
#ifdef TRACE_MEMALLOC
	memUsed += size;
	if (size<110)
	{
		memTracker[size]++;
		TRACE_EVENT_P3("ALLOC %d, used = %d, tracking = %d", size, memUsed, memTracker[size]);
	}
	else
	{
		TRACE_EVENT_P2("ALLOC %d, used = %d", size, memUsed);
	}
#endif

	return mfwAlloc(size);
}


/*******************************************************************************

 $Function:    	AUI_wap_memory_free

 $Description:	Called by the WAP.ATB to free memory
 
 $Returns:		

 $Arguments:	address and size of memory to be freed.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

U8 AUI_wap_memory_free(U8* address,U32 size)
{
#ifdef TRACE_MEMALLOC
	memUsed -= size;
	if (size<110)
	{
		memTracker[size]--;
		TRACE_EVENT_P3("FREE %d, used = %d, tracking = %d", size, memUsed, memTracker[size]);
	}
	else
	{
		TRACE_EVENT_P2("FREE %d, used = %d", size, memUsed);
	}
#endif

	mfwFree(address,size);
	return 1;
}

/*******************************************************************************

 $Function:    	AUI_wap_string_alloc

 $Description:	SPR#1816 - SH -Added
 				Allocates memory for a string.  Will free any existing
 				stored string.
 
 $Returns:		None.

 $Arguments:	Size of string to be allocated, in unicode characters, not including
 				null terminator.
 
*******************************************************************************/

void AUI_wap_string_alloc(T_WAP_STRING *string, USHORT size)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_string_alloc()");
	TRACE_EVENT_P1("Size of string: %d", size);
#endif

	if (string->length!=0)
	{
		/* If the size is correct, no allocation or freeing required */
		
		if (string->length==size)
			return;
			
		/* Otherwise, free the current message block */

		AUI_wap_string_free(string);
	}

	string->text = (USHORT *)AUI_wap_memory_alloc((size+1)*sizeof(USHORT));
	string->length = size;
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_string_free

 $Description:	SPR#1816 - SH - Added
 				Frees an allocated string
 
 $Returns:		None.

 $Arguments:	string - Pointer to the string
 
*******************************************************************************/

void AUI_wap_string_free(T_WAP_STRING *string)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_string_free()");
	TRACE_EVENT_P1("Size of string: %d", string->length);
#endif

	if (string->length!=0)
	{
		AUI_wap_memory_free((UBYTE *)string->text, (string->length+1)*sizeof(USHORT));
		string->text = NULL;
		string->length = 0;
	}

	return;
}


/*******************************************************************************

 $Function:    	ATB_wap_card_show

 $Description:	Called by the WAP.ATB to show the and/or create the card window.
 
 $Returns:		

 $Arguments:	View	- The current view

 
*******************************************************************************/

void AUI_wap_card_show_req(T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_card_show_req");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1739 - SH - If the connecting window or list window are still extant,
	 * destroy them */

	AUI_destroy(CONNECT_WIN | LIST_WIN); /* SPR#2086 */

	/* If WAP browser window doesn't exist, create it */
	
	if (data->browser_win==NULL)
	{
		data->browser_win = AUI_win_create(data->parent_win);							// Create WAP browser
	}
	
	SEND_EVENT(data->browser_win,WAP_SHOW_CARD,0,0);							// Initialise window

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_status_notify

 $Description:	Called by the WAP.ATB when a status flag has changed
 				SPR#1574 - SH:
 				- Status is now just a value, rather than a bit field.
 				- Added two new states: ATB_WAP_ATTACHING, GPRS is trying to
 				  attach, and ATB_WAP_ATTACH_FAILED, GPRS attach has
 				  failed.
				- Don't need to destroy connecting window, as this is done
				  automatically.
 
 $Returns:		

 $Arguments:	View			- The current view
				status			- parameter which status has changed
 
*******************************************************************************/

void AUI_wap_status_notify(T_WAP_VIEW *View, USHORT status)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_status_notify");
#endif

	if (!data)
	{
		return;
	}
	
	switch (status)
	{

		/* If no status, destroy connecting window */

		case ATB_WAP_NO_STATUS:
			TRACE_EVENT("ATB_WAP_NO_STATUS");

// xreddymn Jun-21-2005 MMI-SPR-30291: 
// Removed this as it causes WAP sub-menu to appear after the
// "Loading <URL>" dialog disappears and just before the WAP
// content is displayed.
//
//			AUI_destroy(CONNECT_WIN);		/* SPR#2086 */
			break;
			
		case ATB_WAP_ATTACHING:												// When logging in
			TRACE_EVENT("ATB_WAP_ATTACHING");	
			AUI_connecting_dialog(ATB_WAP_ATTACHING); /* SPR#2086 */
			break;

		case ATB_WAP_ATTACH_FAILED:												// When logging in
			TRACE_EVENT("ATB_WAP_ATTACH_FAILED");
			AUI_destroy(BROWSER_WIN | CONNECT_WIN); /* SPR#2086 */
			AUI_info_dialog(TxtGPRS, TxtNotAvailable);  /* SPR#2086 */
			break;
		
		case ATB_WAP_ERROR:												// When logging in
			TRACE_EVENT("ATB_WAP_ERROR");
			if (wap_callActive || data->connected)
			{
				AUI_destroy(BROWSER_WIN | CONNECT_WIN);	 /* SPR#2086 */
				AUI_info_dialog(TxtGPRS, TxtError);  /* SPR#2086 */
				wap_callActive = FALSE;												// Declare WAP call in progress
				data->connected = FALSE;
			}
			break;

		case ATB_WAP_ACTIVATE_FAILED:												// When logging in
			TRACE_EVENT("ATB_WAP_ACTIVATE_FAILED");
			AUI_destroy(CONNECT_WIN);		/* SPR#2086 */
			AUI_end_call(-1);		/* End GPRS data call */
			AUI_info_dialog(TxtConnection, TxtFailed);  /* SPR#2086 */
			wap_callActive = FALSE;												// Declare WAP call in progress
			data->connected = FALSE;
			break;
			
		case ATB_WAP_CONNECTING:												// When connecting
			TRACE_EVENT("ATB_WAP_CONNECTING");
			
			wap_callActive = TRUE;												// Declare WAP call in progress
			data->connected = TRUE;
			AUI_connecting_dialog(ATB_WAP_CONNECTING); /* SPR#2086 */
			break;
		
		case ATB_WAP_LOGGING_IN:												// When logging in
			TRACE_EVENT("ATB_WAP_LOGGING_IN");
			/* SPR#1824 - SH - If browser window is present, destroy it,
			 * so on re-creation it will be the top window */

			AUI_destroy(BROWSER_WIN); /* SPR#2086 */
			
			/* Display dialog with "Logging In" */
			AUI_connecting_dialog(ATB_WAP_LOGGING_IN); /* SPR#2086 */
			break;
		
		case ATB_WAP_DOWNLOADING:
			TRACE_EVENT("ATB_WAP_DOWNLOADING");
			data->connected = TRUE;
			/* SPR#2086 - SH - If downloading content, show progress */
			if (data->connect_win && View->object_id==WAP_DOWNLOAD_VIEW)
			{
				AUI_connecting_dialog(ATB_WAP_DOWNLOADING); /* SPR#2086 */
			}
			break;

		/* Status to indicate card is being read
		 * from cache or from network */
		 
		case ATB_WAP_CARD_READING:
			TRACE_EVENT("ATB_WAP_CARD_READING");
			if (data->connect_win)
			{
				AUI_connecting_dialog(ATB_WAP_CARD_READING); /* SPR#2086 */
			}
			break;

		case ATB_WAP_ONLINE_CONNECTION_CLOSED:
			TRACE_EVENT("ATB_WAP_ONLINE_CONNECTION_CLOSED");
			AUI_destroy(BROWSER_WIN | CONNECT_WIN | OPTIONS_WIN | OPTIONSMENU_WIN); 	/* SPR#2086 */
			data->connected = FALSE;
			wap_callActive = FALSE;												// WAP call no longer in progress
			// Jun-08-2005 MMI-SPR-30291: Added patches from FG
			TRACE_EVENT("Connection closed");
                    //xrashmic 17 Aug, 2005 MMI-SPR-31364
                    //To indicate to the user that wap ran out of memory and hence disconnected.
                    if(TRUE == data->wapOutOfMem)
                    {
                       information_dialog(TxtFatalError, TxtErrorOutOfMem,NULL,NULL,TxtNull,TxtSoftBack,FOREVER,KEY_RIGHT|KEY_HUP,0);
                       data->wapOutOfMem= FALSE;
                    }
                    else
			AUI_info_dialog(TxtConnection, TxtDeActivated);  // Just for debbuging
			exitingWap=FALSE;//xrashmic 13 Feb, 2006 MMI-SPR-58532
			break;

		case ATB_WAP_PLEASE_WAIT:
			TRACE_EVENT("ATB_WAP_PLEASE_WAIT");
			AUI_connecting_dialog(ATB_WAP_PLEASE_WAIT); /* SPR#2086 */
			break;

		case ATB_WAP_SHUTTING_DOWN:
			TRACE_EVENT("ATB_WAP_SHUTTING_DOWN");
			break;

		/* SPR#1982 - SH - New status, waiting for PDP context to deactivate */
		
		case ATB_WAP_DEACTIVATING:
			TRACE_EVENT("ATB_WAP_DEACTIVATING");
			AUI_connecting_dialog(ATB_WAP_DEACTIVATING); /* SPR#2086 */
			break;
			
		default:
			TRACE_EVENT("** UNKNOWN STATUS **");
			return;		
	}

	if (data->browser_win)						/*The card is prompted to show the status*/
	{
		TRACE_EVENT("Updating card view for status.");
		win_show(data->browser_win);
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_change_soft_key

 $Description:	Called by the WAP.ATB when the card requests a custom text for a
 				soft key
 
 $Returns:		

 $Arguments:	View			- The current view
 				Label			- The text of the custom soft key
 				length			- Length of the text
 				keyId			- The id of the key, to send to the AUS Browser
 									when the key is pressed.
 
*******************************************************************************/


void AUI_wap_change_soft_key(T_WAP_VIEW *View, USHORT *Label, USHORT length, USHORT keyId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	SHORT			optionsWidth;
	USHORT			optionsLength;
	SHORT			labelWidth;
	/* SPR#1816 - SH - Some shortcuts */
	char			*LeftKeyTag	= (char *)data->LeftSoftKey;
	char			*RightKeyTag = (char *)data->RightSoftKey;
	USHORT			*LeftKeyText = &data->LeftSoftKey[1];
	USHORT			*RightKeyText = &data->RightSoftKey[1];

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_change_soft_key");
#endif

	if (!data)
	{
		return;
	}
	
	/* SPR#1816 - SH - Soft keys are unicode */
	
	if (length > 0)
	{
		/* Insert unicode tag and convert to MMI unicode */
		
		LeftKeyTag[0] = 0x80;
		LeftKeyTag[1] = 0x7F;
		optionsLength = AUI_textid_to_uc(LeftKeyText, TxtSoftOptions, SOFTKEY_MAX_LEN);
		RightKeyTag[0] = 0x80;
		RightKeyTag[1] = 0x7F;
		ATB_uc_text_copy(RightKeyText, Label, length);						// Convert RSK text to char type
		ATB_uc_text_convert(RightKeyText, length);
		
		/* Make sure softkeys fit into the space by cropping them if necessary */

		optionsWidth	= ATB_uc_text_width(LeftKeyText, optionsLength);
		labelWidth		= ATB_uc_text_width(RightKeyText, length);

		if ((labelWidth+optionsWidth) > WAP_TOTAL_WIDTH)						// If they don't fit...
		{
			optionsWidth = WAP_TOTAL_WIDTH-labelWidth-WAP_SOFTKEY_SPACING;		// Try shortening "options"
			if (optionsWidth<ATB_uc_text_width(LeftKeyText, WAP_SOFTKEY_MIN_LENGTH))    // If it's too short....
			{
				optionsWidth = ATB_uc_text_width(LeftKeyText, WAP_SOFTKEY_MIN_LENGTH); // Shorten the other key
				labelWidth = WAP_TOTAL_WIDTH-optionsWidth-WAP_SOFTKEY_SPACING;
			}
		}
		ATB_uc_text_crop(LeftKeyText, optionsLength, optionsWidth);	// Crop the texts
		ATB_uc_text_crop(RightKeyText, length, labelWidth);
		View->CustSoftKeys = TRUE;												// We are using cust. soft keys
		View->CustSoftKeyId = keyId;
	}
	else
		View->CustSoftKeys = FALSE;

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_string

 $Description:	SPR#1816 - SH - Renamed & modified for unicode
 				Gives the ATB the text of a required string (specific for now)
 
 $Returns:		Pointer to the string

 $Arguments:	string	- The string to translate.  If NULL, uses stringID
 				stringID - The string ID (see ATBData.h for list of strings)
 
*******************************************************************************/

USHORT AUI_wap_stringID(USHORT *dest, USHORT destlen, USHORT stringID)
{
	USHORT *temp;
	USHORT src;
	USHORT length;

	switch (stringID)
	{
		case WAP_STRING_DOWNLOADING:
			src = TxtDownloading;
			break;

		case WAP_STRING_UPDATING:
			src = TxtUpdating;
			break;

		case WAP_STRING_UNTITLED:
			src = TxtUntitled;
			break;
			
		default:
			src = TxtError;
			break;
	}

	length = AUI_textid_to_uc(dest, src, destlen);
	
	return length;
}


/*******************************************************************************

 $Function:    	AUI_textid_to_uc

 $Description:	SPR#1816 - SH - Added
 				Converts an string from a text ID to an MMI-converted unicode string.
 
 $Returns:		Length of resulting string

 $Arguments:	dest	- Place to store the result.
 				textId	- The string to translate.
				destlen	- Maximum length of result
 
*******************************************************************************/

static USHORT AUI_textid_to_uc(USHORT *dest, int textId, USHORT destlen)
{
	USHORT length;
	char *srctext = MmiRsrcGetText(textId);
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_string2unicode()");
#endif

	if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
	{
		length = ATB_uc_text_copy(dest, (USHORT *)srctext, destlen);
	}
	else
	{
		length = ATB_char_to_uc(dest, srctext);
	}
	
	return length;
}


/*******************************************************************************

 $Function:    	AUI_text_to_uc

 $Description:	SPR#1816 - SH - Added
 				Converts an standard unicode string to an MMI-converted unicode string,
 				including the 0x80 at the start
 
 $Returns:		N/A

 $Arguments:	dest	- Place to store the result.
 				src		- The string to translate.
 				destLen	- Size of destination array in unicode characters
 
*******************************************************************************/

static USHORT AUI_text_to_uc(USHORT *dest, USHORT *src, USHORT destlen)
{
	USHORT length;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_text_to_uc()");
#endif

	length = ATB_uc_text_copy(&dest[1], src, destlen);
	ATB_uc_text_convert(&dest[1], length);

	dest[0] = 0x7F80;
		
	return length;
}


/* SPR#2086 - Removed obsolete function */


/*******************************************************************************

 $Function:    	AUI_wap_extDestroy

 $Description:	Allows external files to destroy the WAP application
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void AUI_wap_extDestroy(void)
{	
	AUI_destroy(ALL_WIN); /* SPR#2086 */

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_call_connect

 $Description:	SPR#1850 - SH - Called when a CSD call is connected
 
 $Returns:		None.

 $Arguments:	
 
*******************************************************************************/

void AUI_wap_call_connect(SHORT cId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	if (!data)
	{
		return;
	}
	
	if (data->View)
	{	
		TRACE_FUNCTION("AUI_wap_call_connect()");
		data->View->cId = cId;		/* SPR#1850 - SH - Call is connected */
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_call_disconnect

 $Description:	SPR#1656 - SH - Called when a CSD call is terminated
 				Called when a CSD call is terminated - informs WAP of this.
 				SPR#1850 - SH - Now parameter is passed indicating ID of call
 				
 $Returns:		None.

 $Arguments:	
 
*******************************************************************************/

void AUI_wap_call_disconnect(SHORT cId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	TRACE_FUNCTION("AUI_wap_call_disconnect()");
	
	if (!data)
	{
		return;
	}
	
	if (data->View)
	{	
		/* View exists; are we in the connected, or in the connecting screen? */

		if (data->connected || data->connect_win || data->browser_win)
		{
			/* SPR#1850 - SH - Check it's the right call */
			
			if (cId==data->View->cId)
			{
				ATB_wap_disconnect(data->View);  /* SPR#1850 - SH - Disconnect WAP browser */
				data->View->cId = -1;		/* SPR#1850 - SH - Call is disconnected */
				ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
				AUI_error_dialog(data->View, ERROR_CALL_DISCONNECTED);
			}
		}
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_end_call

 $Description:	SPR#1575 - SH - Determine whether call is CSD or GPRS,
 				and attempt to end it.
 				NOTE: this function may be called after WAP is destroyed, so it should
 				never attempt to access WAP data without first checking that it is
 				non-null.
 
 $Returns:		None.

 $Arguments:	SPR#1850 - SH - Now provided with the call ID of the CSD call
 				(ignored for GPRS profile).
 
*******************************************************************************/

void AUI_end_call(SHORT cId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_end_call()");

	if (!data)
	{
		return;
	}
	
	/* If WAP browser is active, inform it of disconnection */
	
	if (data)
	{
		if (data->View)
		{
			/* SPR#1850 - SH - If there is a waiting incoming call, accept it now */
			
			if (data->call_waiting)
			{
				cm_mt_accept();
				data->call_waiting = FALSE;
				return;
			}
			
			ATB_wap_disconnect(data->View);
			
			if (data->View->Profile->AccessType == WAP_CS_DATA)
			{
				/* SPR#1850 - SH - If call ID is not -1, call is active.
				 * End it using cm_disconnect */
				 
				if (data->View->cId!=-1)
				{
					TRACE_EVENT_P1("Disconnecting CSD call: %d", data->View->cId);
					cm_disconnect(data->View->cId);
					data->View->cId = -1;	// Call is no longer active
				}
				
				if (call_get_window())
				{
					TRACE_EVENT("Destroying calling window.");
					SEND_EVENT(call_get_window(), CALL_DESTROY_CALLING_WINDOW, 0, 0);
					data->View->cId = -1;
				}
				return;
			}
			else
			{
				TRACE_EVENT("Disconnect GPRS call.");

				/* SPR#1982 - SH - if GPRS call is not yet terminated, set
				 * status so "Please Wait" is shown until it is. */
				 
#if 0

				if (!disconnect_wap_call(WAP_GPRS_DATA))
				{
					TRACE_EVENT("Waiting for disconnection.");
					ATB_wap_status_change(data->View, ATB_WAP_DEACTIVATING);
				}
#endif	

				return;
			}
		}
	}

	/* SPR#1850 - SH - If we've reached here, the the WAP application
	 * is closed, but the call is still open */

	TRACE_EVENT("WAP is closed; attempting to end call");

	/* SPR#1850 - SH - If call ID is not -1, call is active.
	 * End it using cm_disconnect */
	 
	if (cId!=-1)
	{
		TRACE_EVENT("Disconnecting CSD call in progress.");
		cm_disconnect(cId);
	}
				
	/* Destroy calling window */
		
	if (call_get_window())
	{
		TRACE_EVENT("Destroying calling window.");
		SEND_EVENT(call_get_window(), CALL_DESTROY_CALLING_WINDOW, 0, 0);
	}

#ifdef MMI_GPRS_ENABLED
	/* Terminate any GPRS call in progress.
	 * SPR#1982 - SH - if GPRS call is not yet terminated, set
	 * status so "Please Wait" is shown until it is. */
#if 0
	if (!disconnect_wap_call(WAP_GPRS_DATA))
	{
		TRACE_EVENT("Waiting for disconnection.");
		ATB_wap_status_change(data->View, ATB_WAP_DEACTIVATING);
	}
#endif
#endif

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_in_call

 $Description:	SPR#1850 - SH - Returns TRUE if a WAP CSD call is currently active.
 
 $Returns:		TRUE or FALSE

 $Arguments:	None.
 
*******************************************************************************/

UBYTE AUI_wap_in_call(void)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	UBYTE result;

	TRACE_FUNCTION("AUI_wap_in_call()");
	
	if (!data)
	{
		return FALSE;
	}

	result = FALSE;

	/* Ensure that view is open */
		
	if (data->View)
	{
		/* If the call ID is not -1, there is a call in progress */
		if (data->View->cId!=-1)
		{
			result = TRUE;
		}
	}

	return result;
}


/*******************************************************************************

 $Function:    	AUI_wap_browser_disconnect()

 $Description:	SPR#1850 - SH - Shuts down browser.  Only use in the case where
 				there is an incoming call waiting to be accepted.
 
 $Returns:		TRUE or FALSE

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_browser_disconnect()
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_browser_disconnect()");
	
	if (!data)
	{
		return;
	}
	
	if (data->View)
	{
		data->call_waiting = TRUE;				/* There is a waiting call */
		ATB_wap_stop_download(data->View);		/* Stop any active download */
		ATB_wap_disconnect(data->View);			/* Disconnect the WAP browser */
		AUI_destroy(ALL_WIN);		/* SPR#2086 */
	}

	return;
}


#ifdef MMI_GPRS_ENABLED

/*******************************************************************************

 $Function:    	AUI_wap_gprs_cb

 $Description:	Called when GPRS state changes.  
 
 $Returns:		None.

 $Arguments:	
xrashmic 13 Feb, 2006 MMI-SPR-58532
*******************************************************************************/

void AUI_wap_gprs_cb(UBYTE status)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_gprs_cb");

	if (!data)
	{
		return;
	}

	if (!data->View)
	{
		return;
	}
	
	if (data->View->Profile->AccessType==WAP_GPRS_DATA)
	{
		switch (status)
		{
			case GPRS_CONTEXT_DEACTIVATE:
				//Only for network initiated deactivation we need to exit wap
				//i.e pdp deactivation received by the network.
				if(!exitingWap && !MMSactive)
				{
					ATB_wap_stop_download(data->View);
					AUI_wap_string_free(&data->Message); 
					AUI_destroy(RETURN_TO_MENU); 
				}
				break;
		}
	}
	return;
}
/*******************************************************************************

 $Function:    	AUI_wap_GPRS_status

 $Description:	Called when GPRS state changes.  If WAP is active, updates status.
 				SPR#1574 - SH - Added this function
 
 $Returns:		None.

 $Arguments:	
 
*******************************************************************************/

void AUI_wap_gprs_status(UBYTE status)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_gprs_status");

	if (!data)
	{
		return;
	}

	if (!data->View)
	{
		return;
	}
	
	if (data->View->Profile->AccessType==WAP_GPRS_DATA)
	{
		switch (status)
		{
			case GPRS_ATTACHED:
				TRACE_EVENT("STATUS: Attached.");
				
				/* SPR#1189 - SH - Check that login is still proceeding */
				if (ATB_wap_status_get(data->View, ATB_WAP_ATTACHING))
				{
					TRACE_EVENT("View is attaching!");
					ATB_wap_status_change(data->View, ATB_WAP_LOGGING_IN);
					/* SPR#1575 - SH - Are now attached, can connect */
					connect_gprs(data->View->object_id);
				}
				break;
				
			case GPRS_OFF:
				TRACE_EVENT("STATUS: Detached");
				if (data->connected)
				{
#if 0
					disconnect_wap_call(WAP_GPRS_DATA);
#endif
					ATB_wap_status_change(data->View, ATB_WAP_ATTACH_FAILED);
				}
				break;

			/* SPR#1824 - SH - Added these status values */

			case GPRS_CONTEXT_ACTIVATE:
				TRACE_EVENT("STATUS: Context Activated");
				break;

			case GPRS_CONTEXT_DEACTIVATE:
				TRACE_EVENT("STATUS: Context Deactivated");
				/* SPR#1982 - SH - If we're deactivating, this is OK */
				if (ATB_wap_status_get(data->View, ATB_WAP_DEACTIVATING))
				{
					ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
				}
				/* SPR#1982 - SH - Also display message if status is PLEASE WAIT */
				else if (ATB_wap_status_get(data->View, ATB_WAP_PLEASE_WAIT)
					|| ATB_wap_status_get(data->View, ATB_WAP_CONNECTING)
					|| ATB_wap_status_get(data->View, ATB_WAP_DOWNLOADING) /* SPR#2086 */
					|| ATB_wap_status_get(data->View, ATB_WAP_LOGGING_IN))
				{
					ATB_wap_status_change(data->View, ATB_WAP_ACTIVATE_FAILED);
					if (!data->View->secondaryIP)
					{
						ATB_wap_secondary_IP(data->View);	
					}
					else
					{
                                          //xmzhou_trace_string("ATB_wap_data_call_disconnected 4");
						ATB_wap_data_call_disconnected(data->View);
					}
				}
				break;

			case GPRS_ERROR:
				TRACE_EVENT("STATUS: ERROR");
				AUI_end_call(-1);				/* SPR#1850 - SH - Call ID is -1 for GPRS */
				ATB_wap_status_change(data->View, ATB_WAP_ERROR);
				break;
		}
	}
	return;
}
#endif /* MMI_GPRS_ENABLED */

/*******************************************************************************

 $Function:    	AUI_wap_content_get

 $Description:	Fetches content
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	id - A distinct ID for this request.  Returned in ATB_wap_content().
 				Url - The URL of the content to download.
 				reload - If TRUE, any version of the requested content in the cache
 				will be ignored, and the content will be fetched from the network.
 				acceptHeader - Specifies if any Accept-Header fields will be sent with
 				the request.  Can be NULL.
 				
*******************************************************************************/

void AUI_wap_content_get(UBYTE id, char *Url, BOOL reload, char *acceptHeader)
{
	T_WAP_DATA *data = AUI_wap_data();

	//xmzhou_trace_string_value("data=",data);
	
	data->View->Title[0] = 0;


	//xmzhou_trace_string_value("AUI_wap_content_get : data->connected", data->connected);
	
	if (!data->connected)
	{
		//xmzhou_trace_string("calling ATB_wap_status_change");
		ATB_wap_status_change(data->View, ATB_WAP_PLEASE_WAIT); 
	}
	//T_WAP_RES ATB_wap_content_get(UBYTE urlID, char *Url, BOOL reload, char *acceptHeader);
	ATB_wap_content_get(id, Url, reload, acceptHeader);

	return;
}


/* M4 Begin: A.Mok - 06 OCT 2003 */

//TISHMMS Project
extern void AUI_wap_content_clone (UCHAR urlID, const CHAR *data, USHORT length, BOOL moreData, const CHAR *contentType, ULONG totalSize, SHORT errorNo);
/* M4 End: A.Mok - 06 OCT 2003 */


/*******************************************************************************

 $Function:    	AUI_wap_content

 $Description:	Content is sent from the browser on request.
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	urlID - Unique identifier for the request.
 				Data - the data sent
 				data_length - Length of the data in bytes
 				moreData - TRUE if there is more data to come
 				ContentType - Content type of the data
 				totalSize - Zero if data sent all in one block
 
*******************************************************************************/

void AUI_wap_content(UBYTE urlID,
	char *Data,
	ULONG data_length,
	BOOL moreData,
	char *ContentType,
	ULONG contentType_length,
	ULONG totalSize)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
	float data_length_kbytes;
	char title[20];
       int offset;
	TRACE_FUNCTION("AUI_wap_content()");

	if (!data)
	{
		return;
	}



	data->View->Title[0] = 0x7F80;

	//xmzhou_trace_string("****AUI_wap_content*****");
	//xmzhou_trace_string_value("urlID",urlID);
	//xmzhou_trace_string_value("data_length",data_length);
	//xmzhou_trace_string_value("moreData",moreData);
	//xmzhou_trace_string(ContentType);
	//xmzhou_trace_string_value("contentType_length",contentType_length);
	//xmzhou_trace_string_value("totalSize",totalSize);
#if 0
    /* M4 Begin: A.Mok - 06 OCT 2003 */
    if (!strcmp ("application/vnd.wap.mms-message", ContentType))
    {
        //xmzhou_trace_string("****AUI_wap_content_clone*****");
        AUI_wap_content_clone (urlID, Data, data_length, moreData, ContentType, totalSize, 0);
    }
    /* M4 End: A.Mok - 06 OCT 2003 */	
#endif
        //xrashmic 29 Nov, 2004 MMI-SPR-26161
        offset=downloaded_data_size;
        downloaded_data_size += data_length;

        //If the has download started and the object is not a supported type, abort the download.
        if(offset>0 && obj_Type==EMtUnknown)
        {
                TRACE_EVENT("Unsupported MIME type");
                ATB_wap_change_view(WAP_DOWNLOAD_VIEW);
                AUI_destroy(WAP_WIN);
                return;    
        }

        // Depending on the Contenttype the Mime type is set here for inserting 
        // the object into the object manger of MMS
        if(contentType_length>0)
	{
            if(strstr(ContentType,"Content-Type: image/jpeg"))
            {
                obj_Type =  EMtMimeJpeg;
            }
            else if (strstr(ContentType,"Content-Type: image/gif"))
            {
                   obj_Type =  EMtMimeGif;
            }
            else if (strstr(ContentType,"Content-Type: image/png"))
            {
                obj_Type = EMtMimePng;
            }
            else if (strstr(ContentType,"Content-Type: audio/amr"))
            {
                   obj_Type =  EMtMimeAmr;
            }   
            //xrashmic 4 Jan, 2005 MMI-SPR-27874
            //Added support for BMP and WBMP
            else if(strstr(ContentType,"Content-Type: image/wbmp"))
            {
                   obj_Type =  EMtMimeWbmp;
            }
            else if(strstr(ContentType,"Content-Type: image/bmp"))
            {
                   obj_Type =  EMtMimeBmp;
            }
            // xreddymn Jan-31-2005 MMI-SPR-28483: Support MIDI objects
            else if(strstr(ContentType,"Content-Type: audio/midi"))
            {
                   obj_Type =  EMtMimeMidi;
            }
            else if(strstr(ContentType,"Content-Type: audio/mid"))
            {
                   obj_Type =  EMtMimeMidi;
            }
            else
            {
                obj_Type = EMtUnknown;
            }
        }
        if(downloaded_data_size<MAX_DOWNLOAD)
        {
            //xrashmic 29 Nov, 2004 MMI-SPR-26161
            // If data is within the set limit continue downloading
            if (downloaded_data_size<1024)
            {
                sprintf(title, "D/l: %db", downloaded_data_size);
		//xmzhou_trace_string(title);
		ATB_char_to_uc(&data->View->Title[1], title);
	}
	else
	{
                data_length_kbytes = (float)downloaded_data_size/(float)1024;
		sprintf(title, "D/l: %.1fKb", data_length_kbytes);
		//xmzhou_trace_string(title);
		ATB_char_to_uc(&data->View->Title[1], title);
	}
	
	/* If more data to come, don't display yet */
            memcpy((void *)(downloaded_data+offset), Data,data_length);
	
	if (moreData)
	{
		AUI_connecting_dialog(ATB_WAP_DOWNLOADING); /* SPR#2086 */
		return;
	}
            //xrashmic 4 Jan, 2005 MMI-SPR-27874
            // Adding seperate condition when the data is only few bytes, 
            // as data_length_kbytes is populated only for the images in kbytes
            if (downloaded_data_size<1024)
                sprintf(title, "Downloaded: %db", downloaded_data_size);
            else
                sprintf(title, "Downloaded: %.1fKb", data_length_kbytes);
                //xmzhou_trace_string(title);
                ATB_char_to_uc(&data->View->Title[1], title);
            //xrashmic 29 Nov, 2004 MMI-SPR-26161
            // When the data is downloaded completly, insert it into the object manager.
            M4_StoreDownloadedObject(downloaded_data, downloaded_data_size,obj_Type);
        }
        else
        {
             //xrashmic 29 Nov, 2004 MMI-SPR-26161
             // If data exceeds  the set limit abort the download
              ATB_wap_change_view(WAP_DOWNLOAD_VIEW);
              AUI_destroy(WAP_WIN);
              return;
        }
	AUI_destroy(CONNECT_WIN | EDIT_WIN); /* SPR#2086 */
	
	/* If WAP browser window doesn't exist, create it */
	
	if (data->browser_win==NULL)
	{
		data->browser_win = AUI_win_create(data->parent_win); /* SPR#2086 */
	}

	win_show(data->browser_win);


	
	return;
}

/*
T_WAP_RES ATB_wap_content_post(
	UBYTE urlID,
	char *Url,
	BOOL reload,
	char *acceptHeader,
	char *Data,
	ULONG data_length,
	BOOL moreData,
	char *ContentType,
	UBYTE sendMode,
	char *ContentDisp,
	ULONG totalSize)
*/
//TISHMMS Project

void AUI_wap_content_post_more(
UBYTE urlID,
	char *Data,
	ULONG data_length,
	BOOL moreData)
{
    //xmzhou_trace_string("AUI_wap_content_post_more called");
    
    ATB_wap_content_post_more(
    urlID,
    Data,
    data_length,
    moreData);
}

void AUI_wap_content_post(UBYTE urlID,
	                                        char *Url,
	                                        BOOL reload,
	                                        char *acceptHeader,
	                                        char *Data,
	                                        ULONG data_length,
	                                        BOOL moreData,
	                                        char *ContentType,
	                                        UBYTE sendMode,
	                                        char *ContentDisp,
	                                        ULONG totalSize)
{
	T_WAP_DATA *data = AUI_wap_data();

	//xmzhou_trace_string("AUI_wap_content_post called");
	
	data->View->Title[0] = 0;


	//xmzhou_trace_string_value("AUI_wap_content_post : data->connected", data->connected);
	
	if (!data->connected)
	{
		//xmzhou_trace_string("AUI_wap_content_post: calling ATB_wap_status_change");
		ATB_wap_status_change(data->View, ATB_WAP_PLEASE_WAIT); 
	}
	
	ATB_wap_content_post(
	                                 urlID,
	                                 Url,
	                                 reload,
	                                 acceptHeader,
	                                 Data,
	                                 data_length,
	                                 moreData,
	                                 ContentType,
	                                 sendMode,
	                                 ContentDisp,
	                                 totalSize);

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_view_changed

 $Description:	Notify AUI that view has been changed
 				SPR#2086 - SH - Added
 
 $Returns:		None.

 $Arguments:	View - The new view
 
*******************************************************************************/

void AUI_wap_view_changed(T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_view_changed()");
	
	if (!data)
	{
		return;
	}

	data->View = View;
	if (View)
	{
		data->view_id = View->object_id;
	}
	else
	{
		data->view_id = WAP_NO_VIEW;
	}

	TRACE_EVENT_P1("New view is %d", data->view_id);
	
	return;
}

/*******************************************************************************

 $Function:     AUI_mms_gprs_reset_callback

 $Description:  Remove GPRS event callback that was assigned when sending MMS
 
 $Returns:      None

 $Arguments:    None

                xreddymn Apr-02-2005 MMI-SPR-29936
 
*******************************************************************************/

void AUI_mms_gprs_reset_callback(void)
{
	T_WAP_DATA *data = AUI_wap_data();
	if(data != NULL)
	{
		GPRS_SetCallback(data->parent_win, NULL);
	}
}

/*******************************************************************************

 $Function:     AUI_mms_gprs_status

 $Description:  GPRS event callback function when sending MMS
 
 $Returns:      None

 $Arguments:    status: GPRS status codes posted through this argument

                xreddymn Apr-02-2005 MMI-SPR-29936
 
*******************************************************************************/

void AUI_mms_gprs_status(UBYTE status)
{
	if(GPRS_ERROR == status)
	{
		T_WAP_DATA 	*data = AUI_wap_data();

		AUI_mms_status_notify(ATB_WAP_ATTACH_FAILED);
		AUI_mms_gprs_reset_callback();
		AUI_mms_cancel_send();
		ATB_wap_disconnect(data->View);
	}
}

/*******************************************************************************

 $Function:     AUI_mms_gprs_set_callback

 $Description:  Assign GPRS event callback when sending MMS
 
 $Returns:      None

 $Arguments:    None

                xreddymn Apr-02-2005 MMI-SPR-29936
 
*******************************************************************************/

void AUI_mms_gprs_set_callback(void)
{
	T_WAP_DATA *data = AUI_wap_data();
	if(data != NULL)
	{
		GPRS_SetCallback(data->parent_win, (T_GPRS_CB)AUI_mms_gprs_status);
	}
}

// May 19 2005  REF:  MMI-SPR-29887  xrashmic
// To display an Error Message when user tries to retrieve the MMS with  GPRS disabled SIM.
void AUI_retrivemms_gprs_status(UBYTE status)
{
   if(GPRS_ERROR == status)
   {
       T_WAP_DATA *data = AUI_wap_data();
       AUI_mms_status_notify(ATB_WAP_ATTACH_FAILED);
       AUI_mms_gprs_reset_callback();
       AUI_mms_cancel_recieve();
       ATB_wap_disconnect(data->View);
   }
}
 // May 19 2005  REF:  MMI-SPR-29887  xrashmi
 // Call back function for GPRS connection.
void AUI_retrievemms_gprs_set_callback(void)
{
   T_WAP_DATA *data = AUI_wap_data();
   if(data != NULL)
   {
      GPRS_SetCallback(data->parent_win, (T_GPRS_CB)AUI_retrivemms_gprs_status);
   }
}

//xrashmic 08 Feb, 2005 MMI-SPR-27853
/*******************************************************************************

 $Function:    	AUI_mmssend_cb

 $Description:	Call back function for all send mms info dialog screens
 
 $Returns:		None.

 $Arguments:	
//xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
//Sepearted the call back funtion for the sending and receving mms dialog screns.
*******************************************************************************/
void AUI_mmssend_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	
        TRACE_EVENT("AUI_mmssend_cb");
	data->mms_win=NULL;
	data->mms_win_type=0; 
    // xrashmic 30 Nov, 2004 MMI-SPR-26145
    // Deleting the compose and option window after sending the MMS
    if(mms_create_opt_hnd)
    {
         MMI_DestoryWindow(mms_create_opt_hnd);
         mms_create_opt_hnd=NULL;
        if(mms_create_hnd)
        {
             MMI_DestoryWindow(mms_create_hnd);
             mms_create_hnd=NULL;
        }
        //xrashmic 14 Dec, 2004 MMI-SPR-23921
        // Deleting the forward window if it was created.
        else if(mms_Fwdcreate_hnd)
        {
             MMI_DestoryWindow(mms_Fwdcreate_hnd);
             mms_Fwdcreate_hnd=NULL;
            //The options window containing "forward" options.
        }
       // Apr 07 2005  REF:  MMI-SPR-27826  x0012849
       // To avoid crash when a user replies to the MMS which is there in Inbox
       // Delete the options window  not only while forwarding but also while replying
       // May 11 2005  REF:  MMI-SPR-29887  x0012849
       // The code is Moved to get the list of MMS refreshed each time we go out and come back to the list.
    }
       if(g_OptionsWin)   
       {
                MMI_DestoryWindow(g_OptionsWin);
                g_OptionsWin=NULL;
		 // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
               // To refresh the list of MMS, after this the first item in the list is highlighted
		 if(g_MmsBoxWin)                      
 	              SEND_EVENT (g_MmsBoxWin, MWM_REDRAW, 0,(void *)folder);  
    				
       }
     //CRR 25577: 06 oct 2004 - xpradipg
    //we check if the current window is the MMS Inbox list window and then post
    //the redraw event which will refresh the list
       if(mmsboxwinhnd)
       {
             SEND_EVENT(mmsboxwinhnd, MWM_REDRAW, 0,(void *)folder);
       } 
}


/*******************************************************************************

 $Function:    	AUI_mmsrcv_cb

 $Description:	Call back function for all receive mms info dialog screens
 
 $Returns:		None.

 $Arguments:	
 //xrashmic 23 Nov, 2005 MMI-SPR-OMAPS00047637
//Sepearted the call back funtion for the sending and receving mms dialog screns.
*******************************************************************************/
void AUI_mmsrcv_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	
        TRACE_EVENT("AUI_mmsrcv_cb");
	data->mms_win=NULL;
	data->mms_win_type=0;

       if(g_OptionsWin)   
       {
		  //Removing the Inbox option screen
                MMI_DestoryWindow(g_OptionsWin);
                g_OptionsWin=NULL;
		 if(g_MmsReadWin)
		 {
			//Removing the Inbox->option->Read screen
			MMI_DestoryWindow(g_MmsReadWin);
			g_MmsReadWin=NULL;
		 }
		else if(mms_Fwdcreate_hnd)
        	{
        		//Removing the Inbox->option->Forward screen
             		MMI_DestoryWindow(mms_Fwdcreate_hnd);
	             mms_Fwdcreate_hnd=NULL;
       	
        	}
		else if(mms_create_hnd)
		{
			//Removing the Inbox->option->Reply screen
			MMI_DestoryWindow(mms_create_hnd);
			mms_create_hnd=NULL;
		}
		else if(MMSBox_Extract_exec_win)
		{
			if(g_MmsExtractEdtWin)
			{
				//Removing the Inbox->option->extract->list->rename screen
				AUI_edit_Destroy(g_MmsExtractEdtWin);
				g_MmsExtractEdtWin=NULL;
			}
			//Removing the Inbox->option->extract->list screen
			MMI_DestoryWindow(MMSBox_Extract_exec_win);
			MMSBox_Extract_exec_win=NULL;
		}
        }
	if(g_MmsBoxWin)                      
	              SEND_EVENT (g_MmsBoxWin, MWM_REDRAW, 0,(void *)folder);    
}

// xreddymn Mar-25-2005 MMI-SPR-26144
/*******************************************************************************

 $Function:    	AUI_mms_cancel_status

 $Description:	Used to check if MMS send was cancelled
 
 $Returns:		Returns 1 if user has canceled sending MMS

 $Arguments:	None
 
*******************************************************************************/

UBYTE AUI_mms_cancel_status(void)
{
	if(mms_cancel_status)
	{
		mms_cancel_status=0;
		return(1);
	}
	else return(0);
}

/*******************************************************************************

 $Function:    	AUI_mms_cancel_send

 $Description:	This function is called to cancel sending MMS
                Posts cancel events to MMS and WAP clients
 
 $Returns:		None.

 $Arguments:	None
 
*******************************************************************************/

void AUI_mms_cancel_send(void)
{
	T_WAP_DATA *data = AUI_wap_data();
    cancel_TMsend();
    ATB_wap_content_cancel(get_urlID());
}

//May 17 2005  REF:  MMI-SPR-29887  x0012849
// Called when user cancels the retrieving MMS operation.
void AUI_mms_cancel_recieve(void)
{
    cancel_TMrecieve();
   //Jun 28 2005  REF:  MMI-SPR-29887  x0012849
   // Here delete the body file if created any earlier.
    Delete_Body();
    ATB_wap_content_cancel(get_urlIDget());
}
/*******************************************************************************

 $Function:    	AUI_mms_cancel_cb

 $Description:	Call back function for AUI_mms_dialog
 
 $Returns:		None.

 $Arguments:	
 
*******************************************************************************/

void dialog_info_destroy   (T_MFW_HND  own_window);

void AUI_mms_cancel_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	TRACE_FUNCTION("AUI_mms_cancel_cb");
    data->mms_win=NULL;
	data->mms_win_type=MMS_TYPE_NONE;
	progressValue=0;
	data->mms_cancel=1;
	mms_cancel_status=1;
    AUI_mms_cancel_send();
    AUI_mms_cancel_exit();
    dspl_Enable(1);
}
//May 17 2005  REF:  MMI-SPR-29887  x0012849
// Call back for canceling Retrieving  MMS

void AUI_mms_recieve_cancel_cb(T_MFW_HND win, USHORT identifier, USHORT reason)
{
    T_WAP_DATA *data = AUI_wap_data();
    TRACE_FUNCTION("   AUI_mms_recieve_cancel_cb");
   // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
    is_downloadcancelled = TRUE; 
    data->mms_win=NULL;
    data->mms_win_type=MMS_TYPE_NONE;
    // Jun 23 2005  REF:  MMI-SPR-29887  x0012849
    AUI_mms_status_notify(MMS_RECEIVE_FAIL); 
    AUI_mms_cancel_recieve();
    dspl_Enable(1);
}

/*******************************************************************************

 $Function:    	AUI_mms_cancel_exit

 $Description:  This function exits the MMS composer when user has canceled
                sending MMS. Currently this is not used. But will be required
                when MMI-SPR-26144 is solved 
 
 $Returns:		None.

 $Arguments:	None
 
*******************************************************************************/

void AUI_mms_cancel_exit(void)
{
    // xrashmic 30 Nov, 2004 MMI-SPR-26145
    // Deleting the compose and option window after sending the MMS
    if(mms_create_opt_hnd)
    {
         MMI_DestoryWindow(mms_create_opt_hnd);
         mms_create_opt_hnd=NULL;
        if(mms_create_hnd)
        {
             MMI_DestoryWindow(mms_create_hnd);
             mms_create_hnd=NULL;
        }
        //xrashmic 14 Dec, 2004 MMI-SPR-23921
        // Deleting the forward window if it was created.
        else if(mms_Fwdcreate_hnd)
        {
             MMI_DestoryWindow(mms_Fwdcreate_hnd);
             mms_Fwdcreate_hnd=NULL;
            //The options window containing "forward" options.
            if(g_OptionsWin)
            {
                MMI_DestoryWindow(g_OptionsWin);
                g_OptionsWin=NULL;
            }
        }
    }
     //xrashmic 26144
}

/*******************************************************************************

 $Function:    	AUI_ems_dialog

 $Description:	To display the indication of new ems in the idle screen
 		       xrashmic 26 Aug, 2004 MMI-SPR-23931
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/
void AUI_ems_dialog()
{
  //CRR 25577: 06 oct 2004 - xpradipg
  //we check if the current window is the MMS Inbox list window and then post
  //the redraw event which will refresh the list
  if(mmsboxwinhnd)
  {
      SEND_EVENT(mmsboxwinhnd, MWM_REDRAW, 0,(void *)folder);
  }
    addNewEMS();
		return;
}

/*******************************************************************************

 $Function:    	information_dialog

 $Description:	To display info dialog screens.
 		       xrashmic 29 Nov, 2004 MMI-SPR-26161
 
 $Returns:		None.

 $Arguments:	 
*******************************************************************************/
T_MFW_HND information_dialog(USHORT TxtId1, USHORT TxtId2,char* Txt1, char* Txt2, USHORT SoftKeyTxtId1, USHORT SoftKeyTxtId2, int timer, T_MFW_EVENT keyEvents, T_VOID_FUNC callback)
{
    T_DISPLAY_DATA  display_info;
    T_MFW_HND       parent_win  = mfwParent(mfw_header());
    T_MFW_HND       win;
    TRACE_FUNCTION("information_dialog");
    dlg_initDisplayData_TextId( &display_info, SoftKeyTxtId1, SoftKeyTxtId2, TxtId1, TxtId2, COLOUR_WAP_POPUP);
    display_info.TextString=Txt1;
    display_info.TextString2=Txt2;
    dlg_initDisplayData_events( &display_info,callback, timer, keyEvents);
    display_info.Identifier  = 0; 
    win=info_dialog(parent_win, &display_info);
    dspl_Enable(0);
    win_show(win);
    dspl_Enable(1);
    return win;
} 

#else /* #ifdef FF_GPF_TCPIP */

/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:                                                   
 $Project code:	                                                           
 $Module:		
 $File:		    AUIWap.c
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	The user interface for WAP.  Provides the required menus, lists, dialogs and
 	utilises the functionality of the ATB appropriately.
                        
********************************************************************************

 $History: AUIWap.c

	14/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>


#if defined (NEW_FRAME)

#include "typedefs.h"
#include "vsi.h"
#include "pei.h"
#include "custom.h"
#include "gsm.h"

#else  /* NEW_FRAME */

#include "STDDEFS.H"
#include "custom.h"
#include "gsm.h"
#include "vsi.h"

#endif /* NEW_FRAME */

#include "mfw_sys.h"

#include "mfw_mfw.h"
#include "mfw_win.h"
#include "mfw_kbd.h"
#ifndef NEW_EDITOR
#include "mfw_edt.h"
#endif
#include "mfw_tim.h"
#include "mfw_phb.h"
#include "mfw_sms.h"
#include "mfw_icn.h"
#include "mfw_mnu.h"
#include "mfw_lng.h"
#include "mfw_sat.h"
#include "mfw_kbd.h"
#include "mfw_nm.h"
#include "mfw_cm.h"

#include "dspl.h"

#include "MmiMmi.h"
#include "MmiMain.h"
#include "MmiDummy.h"
#include "MmiDialogs.h"
#include "MmiLists.h"
#include "mmiCall.h"

#include "MmiMenu.h"
#include "MmiSoftKeys.h"
#include "MmiResources.h"

#include "MmiBlkLangDB.h"
#include "MmiBookUtils.h"
#ifdef NEW_EDITOR
#include "ATBCommon.h"
#include "ATBDisplay.h"
#include "ATBEditor.h"
#include "AUIEditor.h"
#else
#include "MmiEditor.h"
#endif
#include "MmiBookShared.h"
#include "ATBData.h"
#include "wap_types.h"
#include "ATBWapAUI.h"
#include "ATBWapACI.h"
#include "mmiSmsMenu.h"
#include "mmismssend.h"
#include "AUIWap.h"
#include "AUIWapext.h"
#ifdef MMI_GPRS_ENABLED
#include "MmiGprs.h"
#endif

#include "cus_aci.h"
#include "p_sim.h"
#ifndef PCM_2_FFS
#include "pcm.h"
#endif

#include "mmiColours.h"
#include "font_bitmaps.h"

/* Define this to trace memory allocations & freeings */
#undef TRACE_MEMALLOC


/* List menu attributes
 *
 * Needed for creating the menu.
 */
 
static MfwMnuAttr list_menuAttrib =
{
    &menuArea,
    MNU_LEFT | MNU_LIST | MNU_CUR_LINE,
    -1,
    NULL,
    0,
	COLOUR_LIST_XX, TxtNull, MNUATTRSPARE
};

/*
	Local Handler: the WAP window (At the moment only one instance possible in BMI)
*/

MfwHnd wap_main_window = 0;
static BOOL wap_callActive = FALSE;

/* Set up variables and functions for tracing purposes */

#ifdef TRACE_MEMALLOC
U16 memUsed = 0;
UBYTE memTracker[110] = {0};
#endif

int check_memory(void)
{
	TRACE_EVENT_P1("Memory left: %d", mfwCheckMemoryLeft());
	return;
}


/*******************************************************************************

 $Function:    	AUI_menu

 $Description:	The main WAP menu
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_menu(MfwMnu* menu, MfwMnuItem* item)
{
	T_MFW_HND	win;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_menu");
#endif
	
	win = AUI_create(mfwParent( mfw_header()));

	if (!win)
	{
		TRACE_EVENT("ERROR - Wap Already Open");
	}
	
	check_memory();

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_please_wait

 $Description:	Creates a "Please Wait" message that will hang around until WAP has
 				been started

 $Returns:		Window handle of the created window

 $Arguments:	parent_win - the parent window
 
*******************************************************************************/

T_MFW_HND AUI_please_wait(T_MFW_HND parent_win)
{
	T_DISPLAY_DATA display_info;

	TRACE_FUNCTION("AUI_please_wait()");

	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtPleaseWait, TxtNull, COLOUR_STATUS);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_please_wait_cb, 10000, 0 );
	
	return info_dialog(parent_win,&display_info);
}


/*******************************************************************************

 $Function:    	AUI_please_wait_cb

 $Description:	Timeout callback for the please wait window

 $Returns:		None.

 $Arguments:	win - the parent window
 
*******************************************************************************/

void AUI_please_wait_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data		= AUI_wap_data();		

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_please_wait_cb()");
#endif

 	if (!data)
  	{
  		return;
  	}
  	
	switch(reason)
	{
		case INFO_TIMEOUT:
			SEND_EVENT(win, DIALOG_DESTROY, NULL, NULL);
			AUI_destroy(data->win, ALL_WIN);
			AUI_info_dialog(NULL, TxtTimedOut, TxtNull);
			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_start_done

 $Description:	WAP has started - can create new view
 
 $Returns:		None.

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_start_done(void)
{
	T_WAP_DATA *data			= AUI_wap_data();	
	T_MMI_WAP_NEW_VIEW_IND		wap_view;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_start_done");
#endif
	
	if (!data)
	{
		return;
	}

	/* Start view */
	
	wap_view.object_id 		= 1;
	wap_view.uaMode			= 1;								/* Specifies WML user agent */
	wap_view.view_width		= WAP_SCREEN_WIDTH;					/* Width of screen for browser */
	wap_view.view_height	= WAP_SCREEN_HEIGHT;				/* Height of screen for browser */
	wap_view.font_height	= WAP_CHAR_HEIGHT;					/* Height of latin font */
	wap_view.unicode_height	= WAP_CHAR_HEIGHT;					/* Height of unicode font */
	wap_view.unicode_width	= WAP_CHAR_WIDTH;					/* Width of characters in unicode font */
	
	/* Get height and widths of all latin characters in current font */

	wap_view.font_width_length = 256;
	wap_view.font_width = (UBYTE *)AUI_wap_memory_alloc(256*sizeof(UBYTE));
	font_getAllAsciiWidths(wap_view.font_width);

	/* Create the view */
	
	data->View = ATB_wap_new_view(&wap_view, (void *)data);

	AUI_wap_memory_free(wap_view.font_width, 256*sizeof(UBYTE));

	/* We're not connected as yet */
	
	data->connected = FALSE;
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_new_view_done

 $Description:	View has started - can create menu
 
 $Returns:		None

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_new_view_done(void)
{
	T_WAP_DATA *data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_new_view_done");
#endif
	
	if (!data)
	{
		return;
	}

	/* Initialise window */
	
	SEND_EVENT(data->win,WAP_INIT,0,0);

	/* Destroy temp_win, if it exists */
	
	if (data->temp_win)
	{
		SEND_EVENT(data->temp_win, DIALOG_DESTROY, NULL, NULL);
		data->temp_win = NULL;
	}

	/* Create WAP main menu */
	
	data->menu_win = bookMenuStart(data->win, WAPMenuAttributes(), 0);
	SEND_EVENT(data->menu_win, ADD_CALLBACK, NULL, (void *)AUI_menu_cb);

	return;
}


/*******************************************************************************

 $Function:    	AUI_menu_cb

 $Description:	Callback function for the WAP menu
 
 $Returns:		None.

 $Arguments:	parent_win 	- the WAP data window
 				identifier 	- unused
 				reason		- unused
 
*******************************************************************************/

static void AUI_menu_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA *data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_menu_cb");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#2413 - SH - If still disconnecting, don't allow WAP application to be
	 * destroyed. */
	 
	if (data->View != NULL)
	{
		if (ATB_wap_status_get(data->View, ATB_WAP_DEACTIVATING))
		{
			/* Recreate menu */

			data->menu_win = bookMenuStart(data->win, WAPMenuAttributes(), 0);
			SEND_EVENT(data->menu_win, ADD_CALLBACK, NULL, (void *)AUI_menu_cb);
			return;
		}
	}
	
	AUI_destroy(data->win, WAP_WIN);
	return;
}


/*******************************************************************************

 $Function:    	AUI_homepage

 $Description:	Enter WAP browser with URL=homepage URL
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_homepage(MfwMnu* menu, MfwMnuItem* item)
{	
	T_WAP_DATA *data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_homepage");
#endif

	if (!data)
	{
		return NULL;
	}

	/* Connect & attempt to download homepage */
	
	AUI_connect_URL(data->win, data->View->Profile->Homepage);
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_create

 $Description:	Creates a window (never shown) to which is attached all the data that
 				is used in WAP.  This is distinct from the WAP card browser window,
 				which is created dynamically.
 
 $Returns:		Pointer to the new window

 $Arguments:	parent win	- pointer to the parent window of the data window
 
*******************************************************************************/

T_MFW_HND AUI_create (T_MFW_HND parent_win)
{
	T_MFW_WIN  				*win_data;
	T_WAP_DATA				*data;
	T_MMI_WAP_START_IND		wap_start;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_create");
#endif

	/* Check if one instance of WAP already activated */
	
	if (wap_main_window)
	{
		TRACE_EVENT("*** WAP window already open ***");
		return NULL;
	}

	data = (T_WAP_DATA *)AUI_wap_memory_alloc (sizeof (T_WAP_DATA));
	
	/* Create the WAP data window */
	
	data->update_forbid	= FALSE;
	
	data->win = win_create (parent_win, 0, E_WIN_VISIBLE, (T_MFW_CB)AUI_cb);
	if (data->win==NULL)
	{
		TRACE_EVENT("*** Failed to create main WAP window ***");
    	AUI_wap_memory_free((UBYTE *)data, sizeof (T_WAP_DATA));
		return NULL;
	}
	
	/* Create window handler */
	
	wap_main_window				= data->win;
	data->main_kbd				= kbd_create (data->win, KEY_ALL, (T_MFW_CB)AUI_main_kbd_cb);
	
	data->mmi_control.dialog	= (T_DIALOG_FUNC)AUI_control;
	data->mmi_control.data		= (void *)data;
	data->parent_win			= parent_win;
	win_data					= ((T_MFW_HDR *)data->win)->data;
	win_data->user				= (void *)data;		/* Attach data to window */

	/* Reset various window pointers */
	
	data->edit_win		= NULL;
	data->options_win	= NULL;
	data->sub_options_win = NULL; /* SPR#2324 */
	data->sub_sub_options_win = NULL; /* SPR#2324 */
	data->list_win		= NULL;
	data->menu_win		= NULL;
	data->browser_win	= NULL;
	data->list_data		= NULL;
	data->connect_win	= NULL;
	data->error_win		= NULL;
	data->call_waiting	= FALSE;
		
	/*	Allocate memory for some strings. */
	
	data->Buffer		= (char *)AUI_wap_memory_alloc ((INPUT_MAX_LEN+1)*sizeof(USHORT));	/* Input buffer 1 */
	data->Buffer2		= (char *)AUI_wap_memory_alloc ((INPUT_MAX_LEN+1)*sizeof(USHORT));	/* Input buffer 2 */
	data->Message.text	= NULL;
	data->Message.length = 0;
	data->LeftSoftKey	= (USHORT *)AUI_wap_memory_alloc ((SOFTKEY_MAX_LEN+2)*sizeof(USHORT));	/* Left softkey text */
	data->RightSoftKey	= (USHORT *)AUI_wap_memory_alloc ((SOFTKEY_MAX_LEN+2)*sizeof(USHORT));	/* Right softkey text */

	/* Create list for options menu */
	
	data->OptionsList	= ATB_wap_entry_list_create(WAP_OPTIONS_LIST, MAX_OPTIONS+1, OPTIONS_MAX_LEN, TRUE);

	/* Generate "Please wait" window while WAP starts up */

	data->temp_win = AUI_please_wait(data->win);
	data->View = NULL;			/* View has not yet been created */

	/* SPR#2346 - SH - Set up GPRS notification callback */

#ifdef MMI_GPRS_ENABLED
	GPRS_SetCallback(data->win, (T_GPRS_CB)AUI_wap_gprs_status);
#endif /* MMI_GPRS_ENABLED */

	/* Start the WAP Browser */

	ATB_wap_start(&wap_start);
	return data->win;
}


/*******************************************************************************

 $Function:    	AUI_wap_data

 $Description:	Returns the WAP data pointer
 
 $Returns:		Pointer to WAP data

 $Arguments:	None
 
*******************************************************************************/

T_WAP_DATA *AUI_wap_data (void)
{
	T_MFW_WIN *win_data;
	T_WAP_DATA *data;

	if (wap_main_window==NULL)
	{
		TRACE_EVENT("** WAP not active **");
		return NULL;
	}

	win_data	= ((T_MFW_HDR *)wap_main_window)->data;
	data		= (T_WAP_DATA *)win_data->user;	

	return data;
}


/*******************************************************************************

 $Function:    	AUI_destroy

 $Description:	Destroys the specified WAP windows and their data
 
 $Returns:		void

 $Arguments:	win			- pointer to the browser window
 				windows		- determines which windows will be destroyed.
 				(e.g. LIST_WIN | EDIT_WIN | OPTIONS_WIN | WAP_WIN)
 
*******************************************************************************/

void AUI_destroy (T_MFW_HND win, USHORT windows)
{
	T_WAP_DATA *data = AUI_wap_data();
	USHORT entryIndex;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_destroy");
#endif
    
	if (data==NULL)
	{
		TRACE_EVENT("*** Could not destroy data ***");
		return;
	}
	
	/* If we are closing the browser or exiting WAP, disconnect the call */

	if ((windows & WAP_WIN) || (windows==RETURN_TO_MENU))
	{
		if (data->View)
		{
			AUI_wap_end_call(data->View->cId);
		}
		else
		{
			AUI_wap_end_call(0);
		}
	}
		
	/* Check to see if WAP Browser Window should be destroyed */
	
	if ((windows & BROWSER_WIN) && (data->browser_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy browser");
#endif

		/* Destroy the browser window */
		
		AUI_win_destroy(data->browser_win);
		data->browser_win = NULL;
		 
		/* Write history list to FFS */
		
		ATB_wap_profile_save(data->View);
	}

	/* Check to see if Connection Dialog should be destroyed */
    	
	if ((windows & CONNECT_WIN) && (data->connect_win != NULL))
	{
		SEND_EVENT(data->connect_win,DIALOG_DESTROY,0,0);
		data->connect_win = NULL;
	}

	/* Check to see if WAP Main Menu should be destroyed */
		
	if ((windows & MENU_WIN) && (data->menu_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy menu");
#endif
		bookMenuDestroy(data->menu_win);
		data->menu_win = NULL;
	}

	/* Check to see if Options Menu should be destroyed */
	
	if ((windows & OPTIONSMENU_WIN) && (data->optionsmenu_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy optionsmenu");
#endif
		/* WAP page can now update */

		data->update_forbid = FALSE;
		
		/* Remove all options list entries */
		
		for (entryIndex=0; entryIndex<(data->OptionsList->no_of_entries); entryIndex++)
		{
			if (data->OptionsList->Entry[entryIndex]!=NULL)
			{
				AUI_wap_memory_free((UBYTE *)data->OptionsList->Entry[entryIndex], (SOFTKEY_MAX_LEN+1)*sizeof(USHORT));
				data->OptionsList->Entry[entryIndex] = NULL;
			}
		}

		/* Destroy the list itself */
		
		if (data->optionsmenu_data)
		{
			AUI_wap_memory_free((UBYTE *)data->optionsmenu_data->List, (data->optionsmenu_data->ListLength)*sizeof(T_MFW_MNU_ITEM)); 
			AUI_wap_memory_free((UBYTE *)data->optionsmenu_data, sizeof(ListMenuData));
			data->optionsmenu_data = NULL;
		}
		
		listsDestroy(data->optionsmenu_win);
		data->optionsmenu_win = NULL;
	}

	/* Check to see if List Window should be destroyed */
	
	if ((windows & LIST_WIN) && (data->list_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_FUNCTION("AUI_destroy list");
#endif
		if (data->list_data)
	{
			AUI_wap_memory_free((UBYTE *)data->list_data->List, (data->list_data->ListLength)*sizeof(T_MFW_MNU_ITEM));
			AUI_wap_memory_free((UBYTE *)data->list_data, sizeof(ListMenuData));
			data->list_data = NULL;
		}
		listsDestroy(data->list_win);
		data->list_win = NULL;
	}

	/* Check to see if Options Window should be destroyed */
		
	if ((windows & OPTIONS_WIN) && (data->options_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy options");
#endif
		bookMenuDestroy(data->options_win);
		data->options_win = NULL;
	}

	/* Check to see if Editor should be destroyed */
		
	if ((windows & EDIT_WIN) && (data->edit_win != NULL))
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy editor");
#endif

#ifdef NEW_EDITOR
		AUI_edit_Destroy(data->edit_win);
#else
		editor_destroy(data->edit_win);
#endif /* NEW_EDITOR */
		data->edit_win = NULL;
	}

	/* Check to see if WAP Application should be destroyed */
		
	if (windows & WAP_WIN)
	{
#ifdef TRACE_AUIWAP
		TRACE_EVENT("AUI_destroy WAP");
#endif
		/* Turn off GPRS notificaton */
#ifdef MMI_GPRS_ENABLED
		GPRS_SetCallback(NULL, NULL);
#endif /* MMI_GPRS_ENABLED */

		/* Destroy the error dialog if it exists */

		if (data->error_win)
		{
			SEND_EVENT(data->error_win, DIALOG_DESTROY, 0, 0);
			data->error_win = NULL;
		}
		
		/* Display "Please wait" dialog; WAP destroy will complete on callback */

		if (!data->temp_win)
		{
			data->temp_win = AUI_please_wait(data->win);
		}
		
		/* If there's a view around, prepare the cache to shut down */

		if (data->View)
		{
			/* Set status to shutting down */
			ATB_wap_status_change(data->View, ATB_WAP_SHUTTING_DOWN);
			ATB_wap_cache_prepare();
		}
		else /* No view exists, destroy WAP straight away */
		{
			ATB_wap_destroy();
		}
	}

	/* If all windows have been destroyed except main window,
	 * recreate menu */
	 
	if (windows==RETURN_TO_MENU)
	{
		AUI_wap_new_view_done();
	}
	
#ifdef TRACE_AUIWAP
	TRACE_EVENT("AUI_destroy end");
#endif

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_cache_prepare_done

 $Description:	Cache is prepared for WAP_TERMINATE
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_cache_prepare_done(void)
{
	T_WAP_DATA *data = AUI_wap_data();

	TRACE_FUNCTION("AUI_wap_cache_prepare_done()");

	if (!data)
	{
		return;
	}
	
	/* If we're shutting down, continue the process */

	if (ATB_wap_status_get(data->View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("We are shutting down");
		ATB_wap_destroy();
	}
	else
	{
		/* Otherwise, the cache is being resized */
		TRACE_EVENT("*** CACHE RESIZE ***");
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_close_view_done

 $Description:	Called when a view has been closed
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_close_view_done(void)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_close_view_done");
#endif

	ATB_wap_destroy();
}


/*******************************************************************************

 $Function:    	AUI_wap_terminate_done

 $Description:	Called when a WAP termination is complete
 				
 $Returns:		void

 $Arguments:	None
 
*******************************************************************************/

void AUI_wap_terminate_done(void)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_terminate_done()");
#endif

	if (!data)
	{
		return;
	}

	if (data!=NULL)
	{
		if (data->temp_win)
		{
			SEND_EVENT(data->temp_win, DIALOG_DESTROY, NULL, NULL);
			data->temp_win = NULL;
		}

		/* Free memory for some message strings */
		
		AUI_wap_memory_free ((UBYTE *)data->Buffer, (INPUT_MAX_LEN+1)*sizeof(USHORT));	/* Delete input buffer 1 */
		AUI_wap_memory_free ((UBYTE *)data->Buffer2, (INPUT_MAX_LEN+1)*sizeof(USHORT));	/* Delete input buffer 2 */
		AUI_wap_string_free(&data->Message);		/* Delete output buffer */
		AUI_wap_memory_free ((UBYTE *)data->LeftSoftKey, (SOFTKEY_MAX_LEN+2)*sizeof(USHORT));  /* Delete left softkey text */
		AUI_wap_memory_free ((UBYTE *)data->RightSoftKey, (SOFTKEY_MAX_LEN+2)*sizeof(USHORT)); /* Delete right softkey text */

		/* Destroy options menu list */
		
		ATB_wap_entry_list_destroy(data->OptionsList);

		/* Destroy the WAP data window */

		win_delete(data->win);
        wap_main_window = 0;
		AUI_wap_memory_free ((UBYTE *)data, sizeof (T_WAP_DATA));
	}

#ifdef TRACE_MEMALLOC
{
UBYTE	trackIndex;
	for (trackIndex = 0; trackIndex<110; trackIndex++)
	{
		TRACE_EVENT_P2("TRACKINDEX %d is %d", trackIndex, memTracker[trackIndex]);
	}
}
#endif

	return;
}


/*******************************************************************************

 $Function:    	AUI_cb

 $Description:	Callback function for WAP data window.  This window displays "not
 				connected", since its appearance means a connection failure has
 				occurred.  Apart from this, all information to be displayed should be
 				in the other WAP windows (browser window, options window etc).
 
 $Returns:		void

 $Arguments:	event		- window handle event
 				win			- WAP browser window
 				
*******************************************************************************/

static int AUI_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_cb");
#endif

    switch (event)
	{
		case E_WIN_VISIBLE:
		   	if (win->flags & E_WIN_VISIBLE)
			{
		    	dspl_ClearAll();
				/* If this screen is displayed, the connection has been
				 * terminated, so display 'Not Connected' */
		    	PROMPT(4,12,0, TxtNotConnected);
				displaySoftKeys(TxtReload,TxtExit);
   			}
		break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_main_kbd_cb

 $Description:	Cope with a keypress from the "Not Connected" screen.
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	event, keyboard - standard keyboard callback arguments
 				
*******************************************************************************/

static int AUI_main_kbd_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_main_kbd_cb()");
#endif

	if (!data)
	{
		return;
	}

	switch (keyboard->code)
	{
		case KCD_HUP:															
		case KCD_RIGHT:															
			AUI_destroy(data->win, RETURN_TO_MENU);
      		break;

      	case KCD_LEFT:
      		AUI_connect_URL(data->win, data->View->URL);
      		break;
      		
		default:
			break;
	}
	
	return MFW_EVENT_CONSUMED;
}


		    	
/*******************************************************************************

 $Function:    	AUI_control

 $Description:	Dialog function for WAP data window.  Since this window only
 				displays the "not connected" message, currently this function can
 				only show the window.
 
 $Returns:		void

 $Arguments:	win			- WAP data window
 				event		- Window handle event
 				value		- not used
 				parameter	- not used

*******************************************************************************/

void AUI_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_control");
#endif

	switch (event)
	{
		case WAP_INIT:
			win_show(win);
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_connecting_dialog

 $Description:	Show "Connecting..." dialog (displayed while sending configuration
 				information to WAP gateway)
 
 $Returns:		Window handler

 $Arguments:	win		- pointer to the WAP data window
 
*******************************************************************************/

T_MFW_HND AUI_connecting_dialog (T_MFW_HND win, ULONG status)
{
	T_WAP_DATA *data	= AUI_wap_data();
	T_DISPLAY_DATA		display_info;
	int					timer;
	T_MFW_EVENT			keyEvents;
	
#ifdef TRACE_AUIWAP		
	TRACE_FUNCTION("AUI_connecting_dialog");
#endif

	if (!data)
	{
		return;
	}
	
	/* Standard values for events */
	
	timer = FOREVER;
	keyEvents = KEY_CLEAR | KEY_RIGHT;

	/* Decide on message to display depending on status */

	switch(status)
	{
		case ATB_WAP_ATTACHING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtAttaching, TxtGPRS, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_LOGGING_IN:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtConnecting, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_CONNECTING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtLoggingIn, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, PROFILENAME_MAX_LEN+1); /* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Profile->Title, PROFILENAME_MAX_LEN);
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_CARD_READING:
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtCancel, TxtDownloading, TxtNull, COLOUR_WAP_POPUP);
			AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN+1);	/* +1 space for 0x80 */
			data->Message.text[0] = 0x7F80;
			ATB_uc_text_copy(&data->Message.text[1], data->View->Title, CARD_TITLE_MAX_LEN);
			/* Show name of card being read */
			display_info.TextString2 = (char *)data->Message.text;
			break;

		case ATB_WAP_DEACTIVATING:
			/* Waiting for context to deactivate, dialog with no cancel button */
			dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtPleaseWait, TxtNull, COLOUR_WAP_POPUP);
			timer = TEN_SECS;
			keyEvents = 0;
			break;

		case ATB_WAP_PLEASE_WAIT:
		default:
			dlg_initDisplayData_TextId(&display_info, TxtNull, TxtCancel, TxtPleaseWait, TxtNull, COLOUR_WAP_POPUP);
			break;
	}
	
	/* Destroy any previous dialog */
		
	AUI_destroy(data->win, CONNECT_WIN);
	
	/* Create new dialog */
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_connecting_dialog_cb, timer, keyEvents );
	
	return info_dialog(data->win, &display_info);
}


/*******************************************************************************

 $Function:    	AUI_connecting_dialog_cb

 $Description:	Callback function for connecting dialog
 
 $Returns:		void

 $Arguments:	win			- pointer to the WAP data window
 				identifier	- identifies function that has called callback
 				reason		- reason for callback
 
*******************************************************************************/

void AUI_connecting_dialog_cb (T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
   T_WAP_DATA *data		= AUI_wap_data();
   
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connecting_dialog_cb");
#endif

	/* Dialog has been destroyed, set handle to NULL */
	
	data->connect_win = NULL;

	/* Free memory allocated for status message */
	
	AUI_wap_string_free(&data->Message);
				
	switch(reason)
		{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			/* If browser is active, completely exit WAP.
			 * Otherwise, just return to last menu. */
			 
			if (data->browser_win)
			{
				AUI_destroy(data->win, RETURN_TO_MENU);
			}
			else
			{
				/* Cancel any pending operation */
				ATB_wap_stop_download(data->View);
				/* End the call. */
				AUI_wap_end_call(data->View->cId);	
				/* Indicate we're no longer connected */
				if (!ATB_wap_status_get(data->View, ATB_WAP_DEACTIVATING))
				{
					ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
				}
			}
		break;

		default:
		break;
		}
	return;
}


/*******************************************************************************

 $Function:    	AUI_connect_URL

 $Description:	Connects to WAP gateway (if required) and starts to download URL
 
 $Returns:		None.

 $Arguments:	win		- pointer to the WAP data window
 				URL		- URL to connect to
 
*******************************************************************************/

void AUI_connect_URL (T_MFW_HND win, char *URL)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_WAP_VIEW *View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connect_URL");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;
	
	/* If the browser is already visible, we can destroy the other windows */
	
	if (data->browser_win)
	{
		AUI_destroy(data->win, LIST_WIN | MENU_WIN | OPTIONSMENU_WIN | EDIT_WIN | OPTIONS_WIN);
	}
	
	 /* Display "Please Wait" to cover delay until call dialog is displayed.
	  * Only display "Please Wait" if browser window is not open. */
	   
	if (!data->browser_win || !data->connected)
	{
		ATB_wap_status_change(data->View, ATB_WAP_PLEASE_WAIT);
	}

	/* If we're not connected, send configuration data to WAP Browser */
	
	if (!data->connected)
	{
		ATB_wap_profile_send(View);
	}

	/* This is now the current URL */
	
	strcpy(View->URL, URL);

	/* Send event requesting URL download */

	ATB_wap_download_url(View, URL, TRUE);

	/* Destroy some windows for now; we want to return to the list win
	 * if the connection is cancelled */
	 
	AUI_destroy(data->win, OPTIONS_WIN | EDIT_WIN);
	
	return;
}

	
/*******************************************************************************

 $Function:    	AUI_win_create

 $Description:	Create the WAP card browser window
 
 $Returns:		void

 $Arguments:	parent_win			- Pointer to the WAP data window

*******************************************************************************/

T_MFW_HND AUI_win_create (T_MFW_HND parent_win)
{
	T_MFW_WIN			*win_data;
	T_WAP_BROWSER		*data = (T_WAP_BROWSER *)AUI_wap_memory_alloc(sizeof(T_WAP_BROWSER));

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_create");
#endif

	/* Create the browser window */

	data->win = win_create(parent_win,0,E_WIN_VISIBLE, (T_MFW_CB)AUI_win_cb);

	/* Create keyboard handler */
	
	data->kbd		= kbd_create (data->win, KEY_ALL, (T_MFW_CB)AUI_kbd_cb);
	data->kbd_long	= kbd_create (data->win, KEY_ALL|KEY_LONG, (T_MFW_CB)AUI_kbd_long_cb);

	/* Create window handler */
	
	data->mmi_control.dialog	= (T_DIALOG_FUNC)AUI_win_control;
	data->mmi_control.data		= (void *)data;
	data->parent_win			= parent_win;
	win_data					= ((T_MFW_HDR *)data->win)->data;
	win_data->user				= (void *)data;	/* Attach browser data to window */

	return data->win;
}


/*******************************************************************************

 $Function:    	AUI_win_destroy

 $Description:	Destroy the WAP card browser window
 
 $Returns:		void

 $Arguments:	win				- Pointer to the WAP browser window

*******************************************************************************/

int AUI_win_destroy (T_MFW_HND win)
{
	T_MFW_WIN			*win_data 	= ((T_MFW_HDR *)win)->data;
	T_WAP_BROWSER		*data		= (T_WAP_BROWSER *)win_data->user;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_destroy");
#endif

	/* Delete keyboard handlers */
	
	kbd_delete(data->kbd);
	kbd_delete(data->kbd_long);

	/* Delete window */
	
	win_delete(win);
	AUI_wap_memory_free((UBYTE *)data, sizeof(T_WAP_BROWSER));

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_win_control

 $Description:	Dialog function for WAP Browser window
 
 $Returns:		None.

 $Arguments:	win			- WAP card browser window
 				event		- Window handle event
 				value		- not used
 				parameter	- not used

*******************************************************************************/

void AUI_win_control (T_MFW_HND win, USHORT event, SHORT value, void * parameter)
{
	T_MFW_WIN		*win_data	= ((T_MFW_HDR *)win)->data;
	T_WAP_BROWSER	*data		= (T_WAP_BROWSER *)win_data->user;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_control");
#endif

	switch (event)
	{
		case WAP_INIT:
			break;
		
		case WAP_SHOW_CARD:
			win_show(win);
		break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_win_cb

 $Description:	Callback function for browser window
 
 $Returns:		None.

 $Arguments:	event		- window handle event
 				win			- WAP browser window
 				
*******************************************************************************/

static int AUI_win_cb (T_MFW_EVENT event, T_MFW_WIN * win)
{
	T_WAP_DATA 		*data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_win_cb");
#endif

   	if (!data)
	{
		return NULL;
	}
	
    if (data->update_forbid)
    {
    	return NULL;
	}
	
    switch (event)
		{
		case E_WIN_VISIBLE:
	    	if (win->flags & E_WIN_VISIBLE)
			{
				/* Clear the browser area */
				
		     	resources_setColour( COLOUR_WAP );
		    	dspl_ClearAll();
		    	
		    	/* Display the buffered page */

		    	ATB_wap_buffer_display(data->View);

		    	/* Display softkeys */
		    	
		     	resources_setSKColour( COLOUR_WAP );

				/* Display "Cancel" when downloading or reading in a card */
		    	if (ATB_wap_status_get(data->View, ATB_WAP_DOWNLOADING)
		    		|| ATB_wap_status_get(data->View, ATB_WAP_CARD_READING))
	    		{
		    		displaySoftKeys(TxtNull, TxtCancel);
	    		}
		    	else
	    		{
		    		if (data->View->CustSoftKeys)
		    		{
		    			displayCustSoftKeys((char *)data->LeftSoftKey, (char *)data->RightSoftKey);
		    		}
					else
					{
						if (data->View->CanGoBack)
							displaySoftKeys(TxtSoftOptions, TxtSoftBack);  /* Show "options" and "back" */
						else
							displaySoftKeys(TxtSoftOptions, TxtNull);  /* Only show "options" if we can't go back */
					}
				}
    		}
			break;

		default:
	    	return 0;
	}
    return 1;
}


/*******************************************************************************

 $Function:    	AUI_kbd_cb

 $Description:	Keyboard event handler for browser window

 $Returns:		status int

 $Arguments:	event			- window handle event
 				keyboard		- keyboard control block

*******************************************************************************/

static int AUI_kbd_cb (T_MFW_EVENT event, T_MFW_KBD *keyboard)
{	
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_kbd_cb");
#endif

	if (!data)
	{
		return NULL;
	}

	View = data->View;

	switch (keyboard->code)
	{
		case KCD_LEFT:
			/* Open options menu if not downloading or reading a card */
			if (!ATB_wap_status_get(View, ATB_WAP_DOWNLOADING)
				&& !ATB_wap_status_get(View, ATB_WAP_CARD_READING))
			{
				AUI_wap_options_menu_open(ATB_wap_buffer_identify_element(View));
			}
      		break;

		case KCD_RIGHT:	
			/* Open options menu if not downloading or reading a card */
			if (ATB_wap_status_get(View, ATB_WAP_DOWNLOADING)
				|| ATB_wap_status_get(View, ATB_WAP_CARD_READING))
			{
				ATB_wap_stop_download(View);
			}
			else
			{
				if (View->CustSoftKeys)
					ATB_wap_key_selected(View, View->CustSoftKeyId);  /* Customised right soft key */
				else
					ATB_wap_card_go_back(View);						/* Otherwise default is "Back" */
			}
      		break;

		/* Scroll card up */
		
      	case KCD_MNUUP:
      		ATB_wap_card_key_event(View, WAP_KEY_UP);
      		break;

		/* Scroll card down */
		
      	case KCD_MNUDOWN:
      		ATB_wap_card_key_event(View, WAP_KEY_DOWN);
      		break;

		/* Scroll card left */

		case KCD_MNULEFT:
      	case KCD_1:
      		ATB_wap_card_key_event(View, WAP_KEY_LEFT);
      		break;

		/* Scroll card right */
		
		case KCD_MNURIGHT:
      	case KCD_3:
      		ATB_wap_card_key_event(View, WAP_KEY_RIGHT);
      		break;

		/* Top of card */
		
		case KCD_2:
			ATB_wap_card_scroll(View,0);
			break;

		/* Scroll up a page */
		
		case KCD_5:
			ATB_wap_card_scroll(View,View->cardYPosition-WAP_PAGE_SCROLL);
			/* SPR#2266 - SH - Sending 'key up' has the effect of selecting the bottom available
			 * link on the scrolled page */
			ATB_wap_card_key_event(View, WAP_KEY_UP);
			break;

		/* Scroll down a page */
		
		case KCD_8:
			ATB_wap_card_scroll(View,View->cardYPosition+WAP_PAGE_SCROLL);
			/* SPR#2266 - SH - Sending 'key down' has the effect of selecting the top available
			 * link on the scrolled page */
			ATB_wap_card_key_event(View, WAP_KEY_DOWN);
			break;

		/* Bottom of card */
		
		case KCD_0:
			ATB_wap_card_scroll(View,View->cardHeight-WAP_SCREEN_HEIGHT);
			break;

		/* Select*/
		
		case KCD_MNUSELECT:
      	case KCD_CALL:
      		ATB_wap_card_key_event(View, WAP_KEY_SELECT);
      		break;

      	/* Exit WAP */
      	
      	case KCD_HUP:
      		ATB_wap_stop_download(View);
      		AUI_destroy(data->win,RETURN_TO_MENU);
      		break;

		/* Toggle image scaling */
		
      	case KCD_STAR:
      		View->Status ^= WAP_STATUS_SCALEIMAGES;
      		ATB_wap_profile_save(data->View);
      		ATB_wap_card_refresh(View);
      		break;
      	
    	default:
			break;
	}
	return MFW_EVENT_CONSUMED;
}


static int AUI_kbd_long_cb(T_MFW_EVENT event, T_MFW_KBD *keyboard)
{
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_goto_www

 $Description:	Opens up a text edit screen for entering URLs with "www." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_www(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_www");
#endif

	AUI_edit(GET_TEXT(TxtWWWdot),WAP_GOTO_URL,TxtEnterURL,URL_MAX_LEN);	

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_goto_wap

 $Description:	Opens up a text edit screen for entering URLs with "wap." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_wap(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_wap");
#endif

	AUI_edit(GET_TEXT(TxtWAPdot),WAP_GOTO_URL, TxtEnterURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	MMI_AUI_goto_other

 $Description:	Opens up a blank text edit screen for entering URLs
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_goto_other(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_other");
#endif

	AUI_edit("",WAP_GOTO_URL, TxtEnterURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_edit

 $Description:	Opens up a text edit screen for editing URLs
    	     
 $Returns:		

 $Arguments:	shortcut	- pointer to a string that will appear in the editor
 				identifier	- specifies what to do with the URL (connect, store etc).
 				prompt		- textId of prompt to display
 				maxlen		- maximum length of the edited string
 
*******************************************************************************/

int AUI_edit(char *shortcut, USHORT identifier, USHORT prompt, USHORT maxlen)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit");
#endif

	if (!data)
	{
		return;
	}

	/* Ensure requested buffer size is not too big */
	
	if (maxlen>INPUT_MAX_LEN)
		maxlen = INPUT_MAX_LEN;

	/* 'shortcut' is what is placed into the buffer before editing */

	if (identifier==WAP_EDIT_HOMEPAGE)
		shortcut = data->View->Profile->Homepage;

	if (identifier==WAP_EDIT_APN)
		shortcut = data->View->Profile->APN;

	
	if (identifier==WAP_EDIT_BOOKMARK || identifier==WAP_EDIT_HISTORY)
	{
		/* Clear editor for name */
#ifdef NEW_EDITOR
		ATB_uc_text_copy((USHORT *)data->Buffer, (USHORT *)shortcut, CARD_TITLE_MAX_LEN);
		AUI_edit_create(data->win, identifier, prompt, maxlen, TRUE);
#else
		data->Buffer[0] = 0x80;
		data->Buffer[1] = 0x7F;
		ATB_uc_text_copy((USHORT *)&data->Buffer[2], (USHORT *)shortcut, CARD_TITLE_MAX_LEN);
		AUI_edit_create(data->win, identifier, prompt, maxlen*2+2, TRUE);
#endif
	}
	else
	{
		strcpy(data->Buffer, shortcut);
	   	AUI_edit_create(data->win, identifier, prompt, maxlen, FALSE);
	}

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_edit_create

 $Description:	Creates the edit screen
    	     
 $Returns:		none.

 $Arguments:	parent_win	- the originating window
 				identifier	- purpose for edit window (e.g. go to URL)
 				prompt		- textId of prompt to display
 				maxlen		- maximum length of the editor
 				unicode		- TRUE if editor is unicode
 
*******************************************************************************/

static T_MFW_HND AUI_edit_create(MfwHnd parent_win, USHORT identifier, USHORT prompt, USHORT maxlen, BOOL unicode)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit_create");
#endif

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, identifier, ED_MODE_ALPHA, prompt, (T_AUI_EDIT_CB)AUI_edit_cb);

	if (unicode)
	{
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, maxlen);
 	}
	else
	{
		AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, maxlen);
	}
	
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, maxlen, ALPHA_MODE, (T_EDIT_CB)AUI_edit_cb);
	editor_data.TextId				= prompt;			/* Prompt to display above editor */
	editor_data.Identifier			= identifier;		/* Purpose of edit window (for callback) */

	data->edit_win = editor_start(data->win,&editor_data);
#endif /* NEW_EDITOR */

	return data->edit_win;
}


/*******************************************************************************

 $Function:    	AUI_edit_cb

 $Description:	Callback function for edit screen.  This performs the following functions,
 				the user having provided a new or updated URL:
 				
 				- Goto URL
 				- Editing of Bookmark and History entries
 				- Add new bookmark
 				- Edit homepage
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_edit_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_edit_cb");
#endif

	if (!data)
	{
		return;
	}
	
	View = data->View;

	switch (reason)
	{
		case INFO_KCD_LEFT:
			switch (identifier)
   			{
       			/* Go to URL */
       			
       			case WAP_GOTO_URL:
       				AUI_connect_URL(data->win, data->Buffer);
		    		break;

				/* Edit Bookmark name */
		
				case WAP_EDIT_BOOKMARK:
					AUI_destroy(data->win, LIST_WIN);		/* Destroy the old list */
#ifdef NEW_EDITOR
					ATB_wap_entry_change(View->Bookmarks, data->Buffer, data->OptionSelect);
#else /* NEW_EDITOR */
					ATB_wap_entry_change(View->Bookmarks, &data->Buffer[2], data->OptionSelect);
#endif /* NEW_EDITOR */
					ATB_wap_profile_save(View);	
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtChanged);
					break;

				/* Edit Bookmark URL */
		
				case WAP_EDIT_BOOKMARK_URL:
		    		AUI_destroy(data->win, LIST_WIN);										/* Destroy the old list */
					ATB_wap_entry_change(View->BookmarksURL, data->Buffer, data->OptionSelect);
					ATB_wap_profile_save(View);			/* Save change to flash */
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtChanged);	/* Display "Changed" message */
					break;
				
				/* Edit History name */
		
				case WAP_EDIT_HISTORY:
		    		AUI_destroy(data->win, LIST_WIN);		/* Destroy the old list */
#ifdef NEW_EDITOR
					ATB_wap_entry_change(View->History, data->Buffer, data->OptionSelect);
#else /* NEW_EDITOR */
					ATB_wap_entry_change(View->History, &data->Buffer[2], data->OptionSelect);
#endif /* NEW_EDITOR */
					ATB_wap_profile_save(View);		/* Save change to flash */
					AUI_list_redraw(WAP_HISTORY_LIST, TxtChanged);		/* Display "Changed" message */
					break;

				/* Edit History URL */
		
				case WAP_EDIT_HISTORY_URL:
		    		AUI_destroy(data->win, LIST_WIN);										/* Destroy the old list */
		    		ATB_wap_entry_change(View->HistoryURL, data->Buffer, data->OptionSelect);
					ATB_wap_profile_save(View);		/* Save change to flash */
					AUI_list_redraw(WAP_HISTORY_LIST, TxtChanged);		/* Display "Changed" message */
					break;

				/* Add Bookmark */
		
				case WAP_ADD_BOOKMARK:
					AUI_destroy(data->win, EDIT_WIN);		/* Destroy editor */
					strcpy(data->Buffer2, data->Buffer);	/* Store URL in second buffer */
					/* Clear editor for name */
#ifdef NEW_EDITOR
					data->Buffer[0] = 0;
					data->Buffer[1] = 0;
#else	/* NEW_EDITOR */
					data->Buffer[0] = 0x80;
					data->Buffer[1] = 0x7F;
					data->Buffer[2] = 0;
					data->Buffer[3] = 0;
#endif /* NEW_EDITOR */
					AUI_edit_create(data->win, WAP_ADD_BOOKMARK_NAME, TxtEditName, CARD_TITLE_MAX_LEN, TRUE);
		    		break;

		    	/* Add Bookmark name */
		
				case WAP_ADD_BOOKMARK_NAME:
					AUI_destroy(data->win, LIST_WIN);	/* Destroy the old list */
					if (ATB_wap_entry_add(View->BookmarksURL, data->Buffer2)==WAP_FAIL)		/* Add URL entry */
					{
						AUI_info_dialog(data->win, TxtBookmarks, TxtFull);  /* If list is full, say so */
					}
					else
					{
#ifdef NEW_EDITOR
						ATB_wap_entry_add(View->Bookmarks, data->Buffer);
#else /* NEW_EDITOR */
						ATB_wap_entry_add(View->Bookmarks, &data->Buffer[2]);
#endif /* NEW_EDITOR */
						ATB_wap_profile_save(View);		/* Save change to flash */
						AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtStored);						
					}
					break;

				/* Edit Homepage URL */

				case WAP_EDIT_HOMEPAGE:
			 	  	strcpy(View->Profile->Homepage, data->Buffer);				/* Change the homepage */
			 	  	ATB_wap_profile_save(View);									/* Save change to flash */
					AUI_destroy(data->win, EDIT_WIN);							/* Kill the editor */
					AUI_info_dialog(data->win, TxtChanged, NULL);				/* "Changed" */
					break;

				/* Edit APN */

				case WAP_EDIT_APN:
			 	  	strcpy(View->Profile->APN, data->Buffer);					/* Change the homepage */
			 	  	ATB_wap_profile_save(View);									/* Save change to flash */
			 	  	AUI_destroy(data->win, EDIT_WIN);
					AUI_info_dialog(data->win, TxtChanged, NULL);				/* "Changed" */
					break;

				default:
					break;
    		}
			break;

		/* RSK or HUP key exits menu */
		
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:													/* (Exit from Editor) */
			AUI_destroy(data->win,EDIT_WIN);									/* Destroy edit window */
			if (identifier == WAP_ADD_BOOKMARK_NAME)							/* If we've destroyed the name editor, */
			{
				strcpy(data->Buffer, data->Buffer2);							/* copy the URL back into the editor */
				AUI_edit_create(data->win, WAP_ADD_BOOKMARK, TxtEditURL, CARD_TITLE_MAX_LEN, FALSE);
			}
			break;
		
		default:
			break;
	}

	return;
}

/*******************************************************************************

 $Function:    	AUI_list_redraw

 $Description:	When changing, adding, or deleting bookmarks or history list items,
 				this function is called to display the appropriate dialog.  On callback,
 				the AUI_list_redraw_cb() function redraws the appropriate list.

 $Returns:		None.

 $Arguments:	list	- The type of list to be redrawn
 				TxtId	- The text string to be displayed in a dialog for 3s
 
*******************************************************************************/

static void AUI_list_redraw(USHORT list, USHORT TxtId)
{
	T_WAP_DATA *data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

	if (!data)
	{
		return;
	}
	
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtId, TxtNull, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_list_redraw_cb, THREE_SECS, 0 );
	display_info.Identifier		= list;
	
	info_dialog(data->win, &display_info);

	return;
}


/*******************************************************************************

 $Function:    	AUI_list_redraw_cb

 $Description:	Called when a 3s info dialog times out: the appropriate list is
 				redrawn (history, bookmarks).

 $Returns:		None.

 $Arguments:	win - the parent window
 				identifier - stores the type of list
 				reson - not used.
 
*******************************************************************************/

static void AUI_list_redraw_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data		= AUI_wap_data();	
  
	TRACE_FUNCTION("AUI_list_redraw_cb()");

	if (!data)
	{
		return;
	}
	
	/* SPR#2324 - SH - Kill any residual list, editor or options window */

	AUI_destroy(data->win, LIST_WIN | EDIT_WIN | OPTIONS_WIN);	

	/* Redraw the appropriate list */
	
	switch(identifier)
	{
		case WAP_BOOKMARKS_LIST:
			AUI_entry_list(data->win, data->View->Bookmarks, (ListCbFunc)AUI_bookmarks_list_cb,0);
			break;

		case WAP_HISTORY_LIST:
			AUI_entry_list(data->win, data->View->History, (ListCbFunc)AUI_history_list_cb,0);
			break;

		/* SPR#2324 - SH - Cursor now indicates current profile */
		case WAP_PROFILES_LIST:
			AUI_entry_list(data->win, data->View->ProfilesList, (ListCbFunc)AUI_profiles_setup_cb, data->View->ProfileId);
			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add

 $Description:	New bookmark menu item.  Checks to see if bookmarks are full;
 				if so, displays message and exits.  Otherwise, brings up usual
 				new bookmark shortcut menu.
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_add(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data		= AUI_wap_data();
	T_MMI_WAP_NEW_VIEW_IND		wap_view;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_start_done");
#endif
	
	if (!data)
	{
		return;
	}

	/* If there is space in the bookmarks list */

	if (data->View->Bookmarks->no_of_entries < data->View->Bookmarks->max_entries)
	{
		/* Destroy any previous options menu existing */
		if (data->options_win)
		{
			AUI_destroy(data->win, OPTIONS_WIN);
		}
		/* Create Add Bookmark Menu */
		data->options_win = bookMenuStart(data->win, WAPNewBookmarkAttributes(), 0);
	}
	else
	{
		AUI_info_dialog(data->win, TxtBookmarks, TxtFull);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_www

 $Description:	Opens up a text edit screen for entering URLs with "www." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_www(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_www");
#endif

	AUI_edit(GET_TEXT(TxtWWWdot),WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_wap

 $Description:	Opens up a text edit screen for entering URLs with "wap." entered.
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_wap(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_wap");
#endif

	AUI_edit(GET_TEXT(TxtWAPdot),WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_add_other

 $Description:	Opens up a blank text edit screen for entering URLs
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_bookmarks_add_other(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_add_other");
#endif

	AUI_edit("",WAP_ADD_BOOKMARK, TxtEnterURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_list

 $Description:	List Bookmarks menu option
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_list(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_list");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* Create the list menu */
	
	AUI_entry_list(data->win, data->View->Bookmarks, (ListCbFunc) AUI_bookmarks_list_cb,0);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_list_cb

 $Description:	Callback function for bookmarks list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of bookmarks list
 
*******************************************************************************/

static void AUI_bookmarks_list_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_list_cb");
	TRACE_EVENT_P1("Exit reason: %d", EntryListData->Reason);
#endif

	if (!data)
	{
		return;
	}

	View = data->View;

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:									
			/* Option is selected... */
			
			data->OptionSelect = EntryListData->ListPosition;					/* Store selected bookmark no. */
			data->URLSelect = View->BookmarksURL->Entry[data->OptionSelect]; 	/* Store the URL of the bookmark */

			/* Destroy any previous options menu existing */
			if (data->options_win)
			{
				AUI_destroy(data->win, OPTIONS_WIN);
			}
			data->options_win = bookMenuStart(win, WAPBookOptMenuAttributes(), 0);	/* Create bookmark options menu */
	  		break;

		case LISTS_REASON_SEND:
			data->OptionSelect = EntryListData->ListPosition;					/* Store selected bookmark no. */
			data->URLSelect = View->BookmarksURL->Entry[data->OptionSelect]; 	/* Store the URL of the bookmark */

			AUI_connect_URL(data->win, data->URLSelect);						/* The selected menu item is the new URL */
			break;
			
		case LISTS_REASON_CLEAR:
		case LISTS_REASON_HANGUP:
  		case LISTS_REASON_BACK:													/* Exit list menu */
  			AUI_destroy(data->win,LIST_WIN);									/* Kill the list window */
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_goto

 $Description:	Open up the selected bookmark in the WAP browser
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_goto(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_goto");
#endif

	return AUI_entry_goto(WAP_BOOKMARKS_LIST);	
}	


/*******************************************************************************

 $Function:    	AUI_bookmarks_edit

 $Description:	Edit the name of the selected bookmark
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	char			*Entry;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_edit()");
#endif

	if (!data)
	{
		return 0;
	}

	Entry = data->View->Bookmarks->Entry[data->OptionSelect];			/* The bookmark name to be edited */
			
	AUI_edit(Entry, WAP_EDIT_BOOKMARK, TxtEditName, CARD_TITLE_MAX_LEN);

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_edit_url

 $Description:	Edit the URL of the selected bookmark
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_edit_url(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	char			*Entry;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_edit_url()");
#endif

	if (!data)
	{
		return 0;
	}
	
	Entry = data->View->BookmarksURL->Entry[data->OptionSelect];	/* The bookmark URL to be edited */

	AUI_edit(Entry, WAP_EDIT_BOOKMARK_URL, TxtEditURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_delete

 $Description:	Delete the selected bookmark from the bookmarks list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_bookmarks_delete(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_delete");
#endif

	AUI_entry_delete(WAP_DELETE_BOOKMARK);
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_bookmarks_sendSMS

 $Description:	Open up a bookmark in an SMS write editor
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_bookmarks_sendSMS(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_sendSMS");
#endif

	AUI_entry_sendSMS();
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_history_list

 $Description:	List History menu option
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_history_list(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	char			*Entry;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_list()");
#endif

	if (!data)
	{
		return 0;
	}

	/* Create the history list menu */
	
	AUI_entry_list(data->win, data->View->History, (ListCbFunc) AUI_history_list_cb,0);
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_history_list_cb

 $Description:	Callback function for history list menu
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of history lsit
 
*******************************************************************************/

static void AUI_history_list_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_list_cb()");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:									
			/* Option is selected... */
			
			data->OptionSelect = EntryListData->ListPosition;			/* Store selected history entry no.*/
			data->URLSelect = View->HistoryURL->Entry[data->OptionSelect];    /* Store the URL of the history entry*/

			/* Destroy any previous options menu existing */

			if (data->options_win)
			{
				AUI_destroy(data->win, OPTIONS_WIN);
			}
			
			/* Create history options menu */

			data->options_win = bookMenuStart(data->win, WAPHistOptMenuAttributes(), 0);
  			break;

		case LISTS_REASON_SEND:									
			data->OptionSelect = EntryListData->ListPosition;		/* Store selected bookmark no..*/
			data->URLSelect = View->HistoryURL->Entry[data->OptionSelect]; /* Store the URL of the bookmark.*/

			/* Download the selected page */
			
			AUI_connect_URL(data->win, data->URLSelect);
  			break;

  		case LISTS_REASON_BACK:			/* Exit menu */
			AUI_destroy(data->win,LIST_WIN);			/* Destroy list window */
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_history_goto

 $Description:	Open up the selected history entry in the WAP browser
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_goto(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_goto");
#endif

	return AUI_entry_goto(WAP_HISTORY_LIST);	
}	


/*******************************************************************************

 $Function:    	AUI_history_edit

 $Description:	Edit the name of the selected history entry
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	USHORT			*EntryUC;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_edit");
#endif

	if (!data)
	{
		return 0;
	}

	/* Edit string after NUMBER_PADDING */

	EntryUC			= (USHORT *)data->View->History->Entry[data->OptionSelect];
	
	AUI_edit((char *)&EntryUC[NUMBER_PADDING], WAP_EDIT_HISTORY, TxtEditName, CARD_TITLE_MAX_LEN);
	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_history_edit_url

 $Description:	Edit the URL of the selected history entry
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_edit_url(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	char			*Entry;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_bookmarks_edit()");
#endif

	if (!data)
	{
		return 0;
	}

	Entry = data->View->HistoryURL->Entry[data->OptionSelect];
	
	AUI_edit(Entry, WAP_EDIT_HISTORY_URL, TxtEditURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_history_delete

 $Description:	Delete the selected entry from the history list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_delete(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_delete");
#endif

	AUI_entry_delete(WAP_DELETE_HISTORY);
	
	return MFW_EVENT_CONSUMED;
}	


/*******************************************************************************

 $Function:    	AUI_history_clear

 $Description:	Deletes all entries in history list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_clear(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_clear");
#endif

	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtExit, TxtOkToDelete, TxtNull, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_entry_delete_cb, FOREVER, KEY_CLEAR | KEY_LEFT | KEY_RIGHT );
	display_info.Identifier = WAP_CLEAR_HISTORY;
	info_dialog(data->win, &display_info);
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_history_addbook

 $Description:	Adds a history item to the bookmarks list
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item	
 
*******************************************************************************/

int AUI_history_addbook(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	USHORT			*EntryUC;
	char			*URL;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_addbook()");
#endif
	
	if (!data)
	{
		return 0;
	}
	
	View		= data->View;

	/* Add string after NUMBER_PADDING in unicode */

	EntryUC		= (USHORT *)View->History->Entry[data->OptionSelect];		/* Text of the history entry */
	URL			= View->HistoryURL->Entry[data->OptionSelect];				/* URL of the entry */
 
	/* Try to add history item to bookmarks */
	
	if (ATB_wap_entry_add(View->Bookmarks, (char *)&EntryUC[NUMBER_PADDING])==NULL)
	{
		AUI_info_dialog(data->win, TxtBookmarks, TxtFull);		/* if it's full, say "Bookmarks Full" */
	}
	else
	{
		ATB_wap_entry_add(View->BookmarksURL, URL);
		ATB_wap_profile_save(View);								/* Save change to flash */
		AUI_info_dialog(data->win, TxtStored, NULL);			/* Display "Stored" message */
	}
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_history_sendSMS

 $Description:	Open up a history entry in an SMS write editor
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_history_sendSMS(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_history_sendSMS");
#endif

	AUI_entry_sendSMS();
	
	return MFW_EVENT_CONSUMED;
}


/* SPR#2324 - SH - Removed AUI_profiles_list */


/*******************************************************************************

 $Function:    	AUI_profiles_setup

 $Description:	Lists names of all profiles in flash, in order to change settings
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profiles_setup(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_WAP_VIEW		*View;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_setup");
#endif

	if (!data)
	{
		return 0;
	}

	View = data->View;
	
	/* Create the profile list menu
	 * SPR#2324 - SH - Don't store current profile yet */

	AUI_entry_list(data->win, View->ProfilesList, (ListCbFunc) AUI_profiles_setup_cb, View->ProfileId);
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profiles_setup_cb

 $Description:	Callback function for profiles list menu
 				SPR#2324 - SH - Changed menu behaviour
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				EntryListData	- list menu data of profiles list
 
*******************************************************************************/

static void AUI_profiles_setup_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_WAP_VIEW		*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_setup_cb");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;
	data->OptionSelect = EntryListData->ListPosition; /* The id of the selected profile */

	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SEND:
		case LISTS_REASON_SELECT:									
			/* The user has chosen a profile.  Store the original profile ID */
			data->profile_store = data->View->ProfileId;

			/* If it's different from the original, read in the new profile. */
			
			if (data->OptionSelect!=data->View->ProfileId)
			{
				ATB_wap_profile_read(View, data->OptionSelect);
			}
			
			/* Destroy any previous options menu existing */
			
			if (data->options_win)
			{
				AUI_destroy(data->win, OPTIONS_WIN);
			}
			data->options_win = bookMenuStart(data->win, WAPProfOptionsAttributes(), 0);
			SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_profiles_options_cb);
  			break;

  		case LISTS_REASON_BACK:		
			AUI_destroy(data->win,LIST_WIN);	
  			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_profiles_options_cb

 $Description:	Callback function for profiles options window
 
 $Returns:		void		

 $Arguments:	win				- WAP data window
 				identifier, reason  - Not used
 
*******************************************************************************/

static void AUI_profiles_options_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_options_cb");
#endif

	if (!data)
	{
		return;
	}

	data->options_win = NULL;
	
	/* If the edited profile is different from the selected profile, change back */

	if (data->profile_store!=data->View->ProfileId)
	{
		ATB_wap_profile_read(data->View, data->profile_store);
		/* Recreate list menu so it points to original profile */
		AUI_destroy(data->win, LIST_WIN);
		AUI_entry_list(data->win, data->View->ProfilesList, (ListCbFunc)AUI_profiles_setup_cb,data->profile_store);
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_profile_select

 $Description:	Profile is selected, return to main menu
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_select(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

	/* Store the current profile */
	data->profile_store = data->View->ProfileId;
	ATB_wap_profile_save(data->View);
	
	AUI_info_dialog(data->win, TxtChanged, TxtNull);			
  			
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_change

 $Description:	Bring up slightly different menus depending on whether profile is
 				GPRS or Dialup.
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_change(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

	/* Only allow modification of the GPRS settings if GPRS is switched on */
#ifdef GPRS
	if (data->View->Profile->AccessType==WAP_GPRS_DATA)
	{
		data->sub_options_win = bookMenuStart(data->win, WAPGPRSProfileAttributes(), 0);
	}
	else
#endif
	{
		data->sub_options_win = bookMenuStart(data->win, WAPDialupProfileAttributes(), 0);
	}
	
	SEND_EVENT(data->sub_options_win, ADD_CALLBACK, NULL, (void *)AUI_profile_change_cb);
  			
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_change_cb

 $Description:	Callback function for profile change window
 
 $Returns:		void		

 $Arguments:	Standard menu callback parameters
 
*******************************************************************************/

static void AUI_profile_change_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profiles_options_cb");
#endif

	if (!data)
	{
		return;
	}

	data->sub_options_win = NULL;

	return;
}


/*******************************************************************************

 $Function:    	AUI_profile_delete

 $Description:	Delete the highlighted profile
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_delete(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	/* Don't let user delete last profile */

	if (data->View->ProfilesList->no_of_entries==1)
	{
		AUI_info_dialog(data->win, TxtNotAllowed, TxtNull);
	}
	else
	{
		/* Present option to delete profile */
		AUI_entry_delete(WAP_DELETE_PROFILE);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_new

 $Description:	Add a new profile
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_new(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE newProfileId;

	/* Check if profiles are full */

	if (data->View->ProfilesList->no_of_entries==data->View->ProfilesList->max_entries)
	{
		AUI_info_dialog(data->win, TxtProfiles, TxtFull);
	}
	else
	{
		/* Add the profile */
		newProfileId = data->View->ProfilesList->no_of_entries;
		ATB_wap_profile_default(newProfileId);
		ATB_wap_entry_add(data->View->ProfilesList, data->View->ProfilesList->Entry[newProfileId]);
		ATB_wap_profile_save(data->View);
		AUI_list_redraw(WAP_PROFILES_LIST, TxtStored);
	}
	
	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_reset

 $Description:	Reset profiles to default values
 
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_reset(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_reset");
#endif

	if (!data)
	{
		return;
	}

	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtResetProfiles, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_profile_reset_cb, FIVE_SECS, KEY_LEFT | KEY_RIGHT | KEY_CLEAR | KEY_HUP );
	
	info_dialog(data->parent_win, &display_info);
	return;
}


/*******************************************************************************

 $Function:    	AUI_profile_reset_cb

 $Description:	Callback from reset profiles dialog
 
 $Returns:		None

 $Arguments:	Standard info dialog callback arguments
 
*******************************************************************************/

static void AUI_profile_reset_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_reset_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch(reason)
	{
		case INFO_KCD_LEFT:
			AUI_destroy(data->win, LIST_WIN);
			ATB_wap_profile_default_create(TRUE);
			ATB_wap_profile_names_read(data->View);
			ATB_wap_profile_read(data->View, data->View->ProfileId);
			AUI_list_redraw(WAP_PROFILES_LIST, TxtReset);
			break;
			
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			break;
	} 
	
	return ;
}


/*******************************************************************************

 $Function:    	AUI_entry_list

 $Description:	Create an entry list and store its pointer in list_win/list_data
 
 $Returns:		pointer to list menu data

 $Arguments:	win			- the WAP data window
 				EntryList	- pointer to entry list table
 				Callback	- the callback function
 				pos			- the default highlighted option
 
*******************************************************************************/

static int AUI_entry_list (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_list");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* Destroy previous list, if it exists */
	
	if (data->list_win)
	{
		AUI_destroy(data->win, LIST_WIN);
	}

	/* Create new list */
	
	data->list_data = AUI_entry_list_create (data->win, EntryList, Callback, pos);
	if (data->list_data)
		data->list_win = data->list_data->win;		/* Attach the resulting window to the data */
	else
	{
		data->list_win = NULL;	/* No window created */
	}
	return 1;		
}


/*******************************************************************************

 $Function:    	AUI_entry_list_create

 $Description:	Create an entry list for Bookmarks/History/Profiles, or options menu
 
 $Returns:		pointer to list menu data

 $Arguments:	win			- the WAP data window
 				EntryList	- pointer to bookmarks table
 				Callback	- the callback function for the entry list
 				pos			- the default highlighted option
 
*******************************************************************************/

static ListMenuData * AUI_entry_list_create (T_MFW_HND win, T_WAP_LIST *EntryList, ListCbFunc Callback, UBYTE pos)
{
	ListMenuData *EntryListData;
	USHORT 		entryIndex;
	USHORT		no_of_entries	= EntryList->no_of_entries;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_list_create");
#endif

	/* If list is empty, display "Empty List */
	
	if (no_of_entries==0)
	{
		AUI_info_dialog(win, TxtEmpty, NULL);
		return NULL;
	}
	
	/* Allocate memory for list data */

	EntryListData = (ListMenuData *)AUI_wap_memory_alloc (sizeof(ListMenuData));
	
	if (EntryListData==NULL)
		return NULL;

	EntryListData->List = (T_MFW_MNU_ITEM *) AUI_wap_memory_alloc (no_of_entries*sizeof (T_MFW_MNU_ITEM));

	if (EntryListData->List==NULL)
		return NULL;
	
	/* Fill Menu List */
	
	for (entryIndex=0; entryIndex < no_of_entries; entryIndex++)
	{
		mnuInitDataItem(&EntryListData->List[entryIndex]);
		
		if (EntryList->Entry[entryIndex]!=NULL)
			EntryListData->List[entryIndex].str = (char *)EntryList->Entry[entryIndex];   /* Copy Entry into list */
		else
			EntryListData->List[entryIndex].str = GET_TEXT(TxtEmpty);			/* ...otherwise "Empty" */
		
		EntryListData->List[entryIndex].flagFunc = item_flag_none;
	}

	/* Fill common parameters for list handling */

	EntryListData->ListLength		= no_of_entries;
	EntryListData->CursorPosition	= 1;				/* Starting position */
	EntryListData->ListPosition		= pos+1;
	if (pos>3)
		EntryListData->CursorPosition = pos-3;			/* Make sure highlight is on screen */
	EntryListData->SnapshotSize		= 5;				/* 5 entries on the screen at once */
	EntryListData->Font				= 0;

	/* SPR#2324 - SH - Now only options list uses 'Select' */
	
	if (EntryList->type==WAP_OPTIONS_LIST)		// For these lists, left soft key is Select
		EntryListData->LeftSoftKey	= TxtSoftSelect;
	else
		EntryListData->LeftSoftKey	= TxtSoftOptions;
	
	EntryListData->RightSoftKey	= TxtSoftBack;
	EntryListData->KeyEvents	= KEY_ALL;
	EntryListData->Reason		= 0;
	EntryListData->Strings		= TRUE;		/* Use strings not text ID's */
	EntryListData->Attr			= &list_menuAttrib;
	EntryListData->autoDestroy	= FALSE;	/* Don't destroy on exit */

	/* Display the list */
	 
	listDisplayListMenu(win, EntryListData, (ListCbFunc)Callback,(UBYTE)EntryList->unicode);

	return EntryListData;
}


/*******************************************************************************

 $Function:    	AUI_entry_goto

 $Description:	Open up the selected bookmark/history entry in the WAP browser
 
 $Returns:		

 $Arguments:	identifier	- specifies whether history or bookmarks list
 
*******************************************************************************/

int AUI_entry_goto(WAP_LIST_TYPE identifier)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_goto");
#endif

	if (!data)
	{
		return 0;
	}
	
	switch(identifier)
	{
		case WAP_BOOKMARKS_LIST:
		case WAP_HISTORY_LIST:
			AUI_connect_URL(data->win, data->URLSelect);
			break;
	}

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_entry_delete

 $Description:	Delete the selected entry from the history/bookmarks list
 
 $Returns:		

 $Arguments:	identifier	- specifies history list or bookmarks list	
 
*******************************************************************************/

int AUI_entry_delete(UBYTE identifier)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_delete");
#endif

	if (!data)
	{
		return 0;
	}
	
	dlg_initDisplayData_TextId( &display_info, TxtSoftOK, TxtSoftBack, TxtPressOk, TxtDelete, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_entry_delete_cb, FOREVER, KEY_CLEAR | KEY_LEFT | KEY_RIGHT );
	display_info.Identifier= identifier;  /* Type of list */
	
	info_dialog(data->win, &display_info);

	return MFW_EVENT_CONSUMED;	
}


/*******************************************************************************

 $Function:    	AUI_entry_delete_cb

 $Description:	Callback function for delete confirmation
 
 $Returns:		

 $Arguments:	win			- WAP data window
 				identifier	- Type of list
 				reason		- reason for callback	
 
*******************************************************************************/

void AUI_entry_delete_cb(T_MFW_HND win, UBYTE identifier, UBYTE reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();	
	T_WAP_VIEW		*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_delete_cb");
#endif

	if (!data)
	{
		return;
	}
	
	View = data->View;
	
	switch(identifier)
	{
		case WAP_DELETE_BOOKMARK:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					/* Destroy the old list */
				
					AUI_destroy(data->win, LIST_WIN);

					/* Delete the selected bookmark name and URL */
					
					ATB_wap_entry_remove(View->Bookmarks, data->OptionSelect);     
					ATB_wap_entry_remove(View->BookmarksURL, data->OptionSelect);
					ATB_wap_profile_save(View);	/* Save change to flash */

					/* Redraw list */
					
					AUI_list_redraw(WAP_BOOKMARKS_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;

		case WAP_DELETE_HISTORY:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					/* Destroy the old list */
				
					AUI_destroy(data->win, LIST_WIN);

					/* Delete the selected bookmark name and URL */
					
					ATB_wap_entry_remove(View->History, data->OptionSelect);
					ATB_wap_entry_remove(View->HistoryURL, data->OptionSelect);
					ATB_wap_renumber_history(View->History);	/* Renumber history list */
					ATB_wap_profile_save(View);					/* Save change to flash */

					/* Redraw list */
					
					AUI_list_redraw(WAP_HISTORY_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;

		/* SPR#2324 - SH - For deleting connection profile */
		
		case WAP_DELETE_PROFILE:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					AUI_destroy(data->win, LIST_WIN);										/* Destroy the old list */
					ATB_wap_profile_delete(data->View, data->OptionSelect);	/* Shifts profile data up */
					if (data->OptionSelect==(data->View->ProfilesList->no_of_entries-1))
					{
						/* It's the last entry in the list: read in the previous entry */
						data->OptionSelect--;
					}
					/* Read in the new profile */
					ATB_wap_profile_read(data->View, data->OptionSelect);
					ATB_wap_profile_save(View);									// Save change to flash
					AUI_list_redraw(WAP_PROFILES_LIST, TxtEntryDeleted);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;

		case WAP_CLEAR_HISTORY:
			switch (reason)
			{
				case INFO_KCD_LEFT:
					/* Delete all history names and URLs */
					
					ATB_wap_entry_remove_all(View->History);
					ATB_wap_entry_remove_all(View->HistoryURL);
					ATB_wap_profile_save(View);		/* Save change to flash */

					/* Redraw list */
					
					AUI_entry_list(data->win, View->History, (ListCbFunc)AUI_history_list_cb,0);
					break;
				case INFO_KCD_RIGHT:
		    	case INFO_KCD_CLEAR:
					break;
				default:
					break;
			}
			break;
    }

	return;
}


/*******************************************************************************

 $Function:    	AUI_entry_sendSMS

 $Description:	Open up an SMS editing screen with the selected URL
 
 $Returns:		

 $Arguments:	none
 
*******************************************************************************/

int AUI_entry_sendSMS(void)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_SmsUserData	UserData;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_entry_sendSMS");
#endif

 	if (!data)
 	{
 		return 0;
 	}

 	/* Copy name into SMS editing buffer with a blank number */
 	
	strcpy((char *)UserData.TextBuffer, data->URLSelect);
	UserData.NumberBuffer[0] = 0;
	UserData.CentreBuffer[0] = 0;


    //CRR 25259: xpradipg 28 sep 2004
    //the window handler assignment to data->edit_win is removed
	SmsSend_SEND_start(data->parent_win, &UserData); // Start editing SMS

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_profile_name_edit

 $Description:	Opens up a text edit screen for editing the name of a profile
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_profile_name_edit(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_profile_name_edit");
#endif

	if (!data)
	{
		return 0;
	}
   

#ifdef NEW_EDITOR
	/* Store name in editor buffer */
	
	ATB_uc_text_copy((USHORT *)data->Buffer, data->View->Profile->Title, PROFILENAME_MAX_LEN);

	/* Set up editor. */
	
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA, TxtProfileName, (T_AUI_EDIT_CB)AUI_profile_name_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, PROFILENAME_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
			
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
	
#else /* NEW_EDITOR */
	/* Clear editor for name */

	data->Buffer[0] = 0x80;
	data->Buffer[1] = 0x7F;
	ATB_uc_text_copy((USHORT *)&data->Buffer[2], data->View->Profile->Title, PROFILENAME_MAX_LEN);

	/* Set up editor.  */
	
	AUI_standard_editor(&editor_data, data->Buffer, (PROFILENAME_MAX_LEN+2)*sizeof(USHORT), ALPHA_MODE, (T_EDIT_CB)AUI_profile_name_edit_cb);
	
	editor_data.TextId				= TxtProfileName;
	editor_data.min_enter			= 1;				/* Avoid returning empty strings */
			
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_profile_name_edit_cb

 $Description:	Callback function for editing a profile's title
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_profile_name_edit_cb(T_MFW_HND parent_win, UBYTE identifier, UBYTE reason)
{
   	T_WAP_DATA 		*data		= AUI_wap_data();
   	T_WAP_VIEW	*View;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_profile_name_edit_cb");
#endif

	if (!data)
	{
		return;
	}
	
	View = data->View;
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win, EDIT_WIN);	/* Right soft key kills editor */
			break;
		
		case INFO_KCD_LEFT:

			/* cq12466 MZ Destroy the editor related window */
			AUI_destroy(data->win, EDIT_WIN  );

			/* Change profile name */
#ifdef NEW_EDITOR
			ATB_wap_entry_change(View->ProfilesList, data->Buffer, View->ProfileId);
#else /* NEW_EDITOR */
			ATB_wap_entry_change(View->ProfilesList, &data->Buffer[2], View->ProfileId);
#endif /* NEW_EDITOR */			
			ATB_wap_profile_save(View); /* Save change to flash */
			
			/* cq12466 MZ Display the confirmation screen only and return to the WAP profile 
			     settings list. */
			AUI_info_dialog(data->win, TxtChanged, NULL);	
			
			break;
			
		default:
			break;
	}
	
	return;
}
		

/*******************************************************************************

 $Function:    	AUI_dialupNumber

 $Description:	Opens up a numeric edit screen for editing the dialup number
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_dialupNumber(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_dialup_number");
#endif

	if (!data)
	{
		return 0;
	}

	strcpy(data->Buffer, data->View->Profile->DialupNumber);
	AUI_number_edit(data->win, WAP_DIALUP_NUMBER, TxtDialupNumber);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_IPAddress1

 $Description:	Opens up a numeric edit screen for editing the primary IP address
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_IPAddress1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress1");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy IP address into edit buffer */
	
	strncpy(data->Buffer, data->View->Profile->IPAddress1, IPADDRESS_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_IP_ADDRESS1, ED_MODE_FORMATTED, TxtIPAddress, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS1;             
	editor_data.TextId				= TxtIPAddress; /* "IP Address" rather than "IP Address 1" (less confusing)*/
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_IPAddress2

 $Description:	Opens up a numeric edit screen for editing the secondary IP address
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_IPAddress2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_IPAddress2");
#endif

   	if (!data)
   	{
   		return 0;
   	}

	/* Copy IP address into edit buffer */

	strncpy(data->Buffer, data->View->Profile->IPAddress2, IPADDRESS_MAX_LEN+1);
	
	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, WAP_IP_ADDRESS2, ED_MODE_FORMATTED, TxtIPAddress2, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, IPADDRESS_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	AUI_edit_SetFormatStr(&editor_data, "NNN\\.NNN\\.NNN\\.NNN", TRUE, '0');
	
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, IPADDRESS_MAX_LEN, FORMAT_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	editor_data.Identifier			= WAP_IP_ADDRESS2;             
	editor_data.TextId				= TxtIPAddress2;
	editor_data.min_enter			= 1;
	editor_data.FormatString		= "NNN\\.NNN\\.NNN\\.NNN";		
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_Port1

 $Description:	Opens up a numeric edit screen for editing the primary port
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_Port1(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_Port1");
#endif

   	if (!data)
   	{
   		return 0;
	}

	sprintf(data->Buffer, "%d", data->View->Profile->Port1);
	AUI_number_edit(data->win, WAP_PORT1, TxtPort1);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_Port2

 $Description:	Opens up a numeric edit screen for editing the secondary port
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_Port2(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_Port2");
#endif

   	if (!data)
   	{
   		return 0;
   	}
   	
	sprintf(data->Buffer, "%d", data->View->Profile->Port2);
	AUI_number_edit(data->win, WAP_PORT2, TxtPort2);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_APN

 $Description:	Opens up a numeric edit screen for editing the APN
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_APN(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_APN");
#endif

	AUI_edit(NULL,WAP_EDIT_APN, TxtAPN, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_username

 $Description:	Opens up a text edit screen for editing the ISP username
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_username(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_username");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy name into editing buffer */

	strncpy(data->Buffer, data->View->Profile->Username, USERNAME_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA, TxtISPUsername, (T_AUI_EDIT_CB)AUI_username_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, USERNAME_MAX_LEN+1);
			
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
	
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_username_cb);
	
	editor_data.TextId				= TxtISPUsername;
	editor_data.hide				= FALSE;
			
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_username_cb

 $Description:	Callback function for editing the ISP username
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_username_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
   	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_username_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win, EDIT_WIN);	/* Right soft key kills editor */
			break;
		
		case INFO_KCD_LEFT:
			AUI_destroy(data->win, EDIT_WIN);						/* Kill editor */
			strcpy(data->View->Profile->Username, data->Buffer);	/* Change username */
			ATB_wap_profile_save(data->View);						/* Save change to flash */
			AUI_info_dialog(data->win, TxtChanged, NULL);			/* Display "Changed" message */
			break;
		default:
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_password

 $Description:	Opens up a text edit screen for editing the ISP password
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_password(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password");
#endif

	if (!data)
	{
		return 0;
	}

	/* Copy password into editing buffer */
	
	strncpy(data->Buffer, data->View->Profile->Password, PASSWORD_MAX_LEN+1);

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, 0, ED_MODE_ALPHA | ED_MODE_HIDDEN, TxtISPPassword, (T_AUI_EDIT_CB)AUI_password_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, PASSWORD_MAX_LEN+1);
			
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, PASSWORD_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb);
	
	editor_data.TextId				= TxtISPPassword;
	editor_data.hide				= TRUE;				/* Password is hidden (*****) */
			
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_password_cb

 $Description:	Callback function for editing the ISP password
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (just 0 so far)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_password_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
  	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION(" AUI_password_cb");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win, EDIT_WIN);					/* Right soft key kills editor */
			break;
		
		case INFO_KCD_LEFT:
			AUI_destroy(data->win, EDIT_WIN);					/* Kill editor */
			strcpy(data->View->Profile->Password, data->Buffer);	/* Change password */
			ATB_wap_profile_save(data->View);					/* Save change to flash */
			AUI_info_dialog(data->win, TxtChanged, NULL);		/* Display "Changed" message */
			break;
		default:
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_response_timer

 $Description:	Opens up a numeric edit screen for editing the server number
    	     
 $Returns:		none.

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

int AUI_response_timer(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_response_timer");
#endif

	if (!data)
	{
		return 0;
	}

	sprintf(data->Buffer, "%d", data->View->Profile->ResponseTimer);
	AUI_number_edit(data->win, WAP_RESPONSE_TIMER, TxtResponseTimer);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_number_edit

 $Description:	Opens up a numeric edit screen.
 				The digits to be edited should be in data->Buffer.
    	     
 $Returns:		none.

 $Arguments:	parent_win	- the WAP data window
 				identifier	- specifies which edit screen it is (server no. etc)
 				prompt		- prompt, e.g "IP Address"
 
*******************************************************************************/

int AUI_number_edit(T_MFW_HND parent_win, int identifier, USHORT prompt)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA	editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */

	if (!data)
	{
		return 0;
	}

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, identifier, 0, prompt, (T_AUI_EDIT_CB)AUI_number_edit_cb);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, NUMBER_MAX_LEN+1);
	AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
			
	data->edit_win = AUI_edit_Start(parent_win, &editor_data);
	
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, NUMBER_MAX_LEN, DIGITS_MODE, (T_EDIT_CB)AUI_number_edit_cb);
	
	editor_data.Identifier			= identifier;       
	editor_data.TextId				= prompt;
	editor_data.min_enter			= 1;
			
	data->edit_win = editor_start(parent_win, &editor_data);
#endif /* NEW_EDITOR */

	return 1;
}


/*******************************************************************************

 $Function:    	validate_IP_address

 $Description:	Check the validity of an IP address in the form 255.255.255.255
 
 $Returns:		BOOL, TRUE if valid, else FALSE

 $Arguments:	buffer - the ASCIIZ string containing the IP address to validate
 
*******************************************************************************/

static BOOL validate_IP_address(char *buffer)
{
    char temp[16];
    char *token;
    int  value;
    
    if (strlen(buffer) > sizeof(temp)-1)
        return FALSE;

    strcpy(temp, buffer);
    for (token = strtok(temp, ".");
         token != NULL;
         token = strtok(NULL, "."))
    {
        value = atoi(token);

		if ((value < 0) || (value > 255))
            return FALSE;
    }
         
    return TRUE;
}


/*******************************************************************************

 $Function:    	AUI_number_edit_cb

 $Description:	Callback function for editing a number
 
 $Returns:		void

 $Arguments:	parent_win	- the WAP data window
 				identifier	- identifier for the edit type (server or service no.)
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_number_edit_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	T_WAP_PROFILE	*Profile;
	int				value;
    BOOL valid;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_number_edit_cb");
#endif

	if (!data)
	{
		return;
	}

	View	= data->View;
	Profile	= View->Profile;

	switch (reason)				
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win, EDIT_WIN);		/* Just kill window if back pressed */
			break;
		
		case INFO_KCD_LEFT:
		    {		        
    			switch(identifier)
    			{
    				case WAP_DIALUP_NUMBER:
    					/* Copy the dialup number to the Profile */
    					strcpy(Profile->DialupNumber, data->Buffer);
						valid = TRUE;
    					break;

    				case WAP_IP_ADDRESS1:
    					valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    				    	/* Copy the IP address to the Profile */
    					    strcpy(Profile->IPAddress1, data->Buffer);
						}
    					else
						{
    					    bookShowInformation(data->win, TxtOutofRange, NULL, NULL);
						}
    					break;

    				case WAP_IP_ADDRESS2:
    				    valid = validate_IP_address(data->Buffer);
    					
    				    if (valid)
    				    {
    				    	/* Copy the IP address to the Profile */
    					    strcpy(Profile->IPAddress2, data->Buffer);
						}
    					else
						{
    					    bookShowInformation(data->win, TxtOutofRange, NULL, NULL);
						}
    					break;

    				case WAP_PORT1:
    					value = atoi(data->Buffer);
    					if (value>=0 && value<=0xFFFF)
    					{
    						/* Store the port number in the Profile */
    						valid = TRUE;
    						Profile->Port1 = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    bookShowInformation(data->win, TxtOutofRange, NULL, NULL);
						}
    					break;

    				case WAP_PORT2:
   						value = atoi(data->Buffer);
    					if (value>=0 && value<=0xFFFF)
    					{
    						/* Store the port number in the Profile */
    						valid = TRUE;
    						Profile->Port2 = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    bookShowInformation(data->win, TxtOutofRange, NULL, NULL);
						}
    					break;

    				case WAP_RESPONSE_TIMER:
    					value = atoi(data->Buffer);
    					if (value>=0 && value<=0xFFFF)
    					{
    						/* Store the response timer in the Profile */
    						valid = TRUE;
    						Profile->ResponseTimer = value;
    					}
    					else
    					{
    						valid = FALSE;
    					    bookShowInformation(data->win, TxtOutofRange, NULL, NULL);
						}
    					break;
    			}
    			
    			if (valid)
    			{
        			AUI_destroy(data->win, EDIT_WIN);
        			ATB_wap_profile_save(View);						/* Save change to flash */
        			AUI_info_dialog(data->win, TxtChanged, NULL);	/* Display "Changed" message */
    			}
		    } 
			break;
		
		default:
			break;
	}
	
	return;
}


/*******************************************************************************

 $Function:    	MMI_AUI_homepage_edit

 $Description:	Opens up a text edit screen for changing the homepage URL
    	     
 $Returns:		MFW_EVENT_CONSUMED

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_homepage_edit(MfwMnu* menu, MfwMnuItem* item)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_homepage_edit");
#endif

	AUI_edit(NULL,WAP_EDIT_HOMEPAGE, TxtEditURL, URL_MAX_LEN);

	return MFW_EVENT_CONSUMED;
}


/*******************************************************************************

 $Function:    	AUI_connectionType

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionType(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 	*data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionType");
#endif

	if (!data)
	{
		return 0;
	}

	/* Open the menu */
	/* cq12466 MZ store sub options info for later use. */
	data->sub_sub_options_win  = bookMenuStart(data->win, WAPConnectionTypeAttributes(), 0);
	SEND_EVENT(data->sub_sub_options_win, DEFAULT_OPTION, NULL, &data->View->Profile->ConnectionType);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_connectionType_set

 $Description:	Set WAP connection to temporary or permanent
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionType_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 	*data	= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionType_set");
#endif

	if (!data)
	{
		return 0;
	}

	/* Change connection type */
	
	data->View->Profile->ConnectionType = menu->lCursor[menu->level];
	ATB_wap_profile_save(data->View);		/* Save change to flash */
	AUI_info_dialog(data->win, TxtChanged, NULL);    /* "Changed" */
	
       /* cq 12466 MZ return to sub menu options dialog.*/
	bookMenuDestroy(data->sub_sub_options_win);
	data->sub_sub_options_win = NULL;
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_connectionSpeed

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionSpeed(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 	*data	= AUI_wap_data();
	T_MFW_HND setting_win;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionSpeed");
#endif

	if (!data)
	{
		return 0;
	}
	
	/* Open the menu */
	
	setting_win = bookMenuStart(data->win, WAPConnectionSpeedAttributes(), 0);
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &data->View->Profile->ConnectionSpeed);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_connectionSpeed_set

 $Description:	Set WAP connection speed to analogue, digital
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_connectionSpeed_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_connectionSpeed_set");
#endif

	if (!data)
	{
		return 0;
	}

	/* Change connection speed */

	data->View->Profile->ConnectionSpeed = menu->lCursor[menu->level];
	ATB_wap_profile_save(data->View);	/* Save change to flash */
	AUI_info_dialog(data->win, TxtChanged, NULL);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_security

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_security(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 	*data	= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_security_on");
#endif

	if (!data)
	{
		return 0;
	}

	/* Open up the menu */
	/* cq12466 MZ store submenu window info .*/	
	data->sub_sub_options_win  = bookMenuStart(data->win, WAPSecurityOptionAttributes(), 0);
	SEND_EVENT(data->sub_sub_options_win , DEFAULT_OPTION, NULL, &data->View->Profile->Security);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_security_set

 $Description:	Switch security on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_security_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_security_off");
#endif

	if (!data)
	{
		return 0;
	}

	/* Change security value */
	
	data->View->Profile->Security = (BOOL)menu->lCursor[menu->level];
	ATB_wap_profile_save(data->View);	/* Save change to flash */	
	AUI_info_dialog(data->win, TxtChanged, NULL);

	/* cq12466 MZ destroy sub menu option return to previous menu. */
	bookMenuDestroy(data->sub_sub_options_win);
	data->sub_sub_options_win = NULL;
	
	return 1;
}


/*******************************************************************************

 $Function:    	AUI_access

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_access(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_access");
#endif

	if (!data)
	{
		return 0;
	}

	/* SPR#2324 - SH - Need to keep a handle of this menu,
	 * as we'll explicitly destroy it when GPRS or Dialup is chosen */
		
	data->sub_sub_options_win = bookMenuStart(data->win, WAPGPRSDialupAttributes(), 0);
	SEND_EVENT(data->sub_sub_options_win, DEFAULT_OPTION, NULL, &data->View->Profile->AccessType); // Add our own callback

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_access_set

 $Description:	Set access type
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_access_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_access_set");
#endif

	if (!data)
	{
		return 0;
	}

	/* Change access type */

	data->View->Profile->AccessType  = menu->lCursor[menu->level];
	ATB_wap_profile_save(data->View);	
	AUI_info_dialog(data->win, TxtChanged, NULL);

	/* SPR#2324 - SH - Display "Changed" dialogue.  On callback, will redisplay the
	 * appropriate settings menu - GPRS or Dialup */
	 
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtChanged, TxtNull, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_access_menu, THREE_SECS, 0 );
		
	info_dialog(data->win, &display_info);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_access_menu

 $Description:	Display the appropriate menu for the access type.
 				SPR#2324 - SH - Added

 $Returns:		None.

 $Arguments:	win - the parent window
 				identifier - stores the access type
 				reson - not used.
 
*******************************************************************************/

static void AUI_access_menu(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_access_menu");
#endif

	if (!data)
	{
		return;
	}

	/* Destroy the GPRS/Dialup menu */
	
	bookMenuDestroy(data->sub_sub_options_win);
	data->sub_sub_options_win = NULL;

	/* Destroy the old settings menu */
	
	bookMenuDestroy(data->sub_options_win);
	data->sub_options_win = NULL;

	/* Create a new settings menu of the appropriate type */
	
	switch(data->View->Profile->AccessType)
	{
		case WAP_GPRS_DATA:
			data->sub_options_win = bookMenuStart(win, WAPGPRSProfileAttributes(), 0);
			break;
		case WAP_CS_DATA:
			data->sub_options_win = bookMenuStart(win, WAPDialupProfileAttributes(), 0);
			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_savehist

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_savehist(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE			SaveHistory;
	T_MFW_HND setting_win;
	
#ifdef TRACE_AUIWAP	
	TRACE_FUNCTION("AUI_savehist");
#endif

	if (!data)
	{
		return 0;
	}

	/* Open the menu */

	setting_win = bookMenuStart(data->win, WAPSaveHistoryAttributes(), 0);
	
	/* SaveHistory = 1 or 0 depending on flag */

	SaveHistory = (data->View->Status & WAP_STATUS_SAVEHISTORY)/WAP_STATUS_SAVEHISTORY;
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &SaveHistory);

	return 1;
}

/*******************************************************************************

 $Function:    	AUI_savehist_set

 $Description:	Set save history on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_savehist_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_savehist_set");
#endif

	if (!data)
	{
		return 0;
	}

	if (menu->lCursor[menu->level])
		data->View->Status |= WAP_STATUS_SAVEHISTORY;
	else
		data->View->Status &= ~WAP_STATUS_SAVEHISTORY;
	
	ATB_wap_profile_save(data->View);	/* Save change to flash */
	AUI_info_dialog(data->win, TxtChanged, NULL);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_scaleimages

 $Description:	Sets cursor position for this menu based on the current settings
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_scaleimages(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE			ScaleImages;
	T_MFW_HND setting_win;
	
#ifdef TRACE_AUIWAP	
	TRACE_FUNCTION("AUI_scaleimages");
#endif

	if (!data)
	{
		return 0;
	}

	/* Open the menu */
	
	setting_win = bookMenuStart(data->win, WAPScaleImagesAttributes(), 0);

	/* ScaleImages =  1 or 0 depending on flag */
	
	ScaleImages = (data->View->Status & WAP_STATUS_SCALEIMAGES)/WAP_STATUS_SCALEIMAGES;
	SEND_EVENT(setting_win, DEFAULT_OPTION, NULL, &ScaleImages);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_scaleimages_set

 $Description:	Set image scaling on or off
 
 $Returns:		

 $Arguments:	menu		- pointer to the current menu
 				item		- pointer to the current menu item
 
*******************************************************************************/

int AUI_scaleimages_set(MfwMnu* menu, MfwMnuItem* item)
{
	T_WAP_DATA *data = AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_scaleimages_set");
#endif

	if (!data)
	{
		return 0;
	}

	if (menu->lCursor[menu->level])
		data->View->Status |= WAP_STATUS_SCALEIMAGES;
	else
		data->View->Status &= ~WAP_STATUS_SCALEIMAGES;
	
	ATB_wap_profile_save(data->View);	/* Save change to flash */
	AUI_info_dialog(data->win, TxtChanged, NULL);

	return 1;
}


/*******************************************************************************

 $Function:    	AUI_info_dialog

 $Description:	Display message for three seconds
 
 $Returns:		None.

 $Arguments:	parent_win		- Parent window
 				TextId 			- Id of text string to display
 
*******************************************************************************/

static void AUI_info_dialog(T_MFW_HND parent_win, USHORT TxtId1, USHORT TxtId2)
{
	T_DISPLAY_DATA	display_info;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_info_dialog");
#endif
	dlg_initDisplayData_TextId( &display_info, TxtNull, TxtNull, TxtId1, TxtId2, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, NULL, THREE_SECS, 0 );
	display_info.Identifier		= 0;
	
	info_dialog(parent_win, &display_info);
	return;
}


/*******************************************************************************

 $Function:    	AUI_error_dialog

 $Description:	Display error message for three seconds
 
 $Returns:		None.

 $Arguments:	View			- The current view
 				errorCode		- Number of the error
 
*******************************************************************************/

void AUI_error_dialog(T_WAP_VIEW *View, SHORT errorCode)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	static char errorNumber[20];
	USHORT errId1, errId2;
	USHORT lsk, rsk;
	SHORT newCode;
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_error_dialog");
#endif

	if (!data)
	{
		return;
	}
	
	/* Intercept fatal error */

	if (errorCode==8002)
	{
		TRACE_EVENT("WAP MEMORY FULL");
			
		dlg_initDisplayData_TextId( &display_info, TxtNull, TxtSoftOK, TxtFatalError, TxtErrorOutOfMem, COLOUR_WAP_POPUP);
		dlg_initDisplayData_events( &display_info, NULL, FOREVER, KEY_RIGHT);
		info_dialog(data->parent_win, &display_info);
		AUI_destroy(data->win, ALL_WIN);

		return;
	}

	/* Convert the error code to text */
	TRACE_EVENT_P1("WAP Error: %d", errorCode);

	/* Handle standard error */
	
	errId1 = TxtNull;
	errId2 = TxtNull;
	newCode = errorCode;
	
	if ((errorCode>=69 && errorCode<=101)
		|| (errorCode>=64 && errorCode<=67)
		|| errorCode==1013)
	{
		newCode = ERROR_COMMUNICATION_SERVER;
	}

	else if ((errorCode>=0 && errorCode<=9)
		|| (errorCode>=224 && errorCode<=227)
		|| (errorCode>=229 && errorCode<=234)
		|| (errorCode>=5300 && errorCode<=5399)
		|| errorCode==1010 || errorCode==1018)
	{
		newCode = ERROR_COMMUNICATION_GATEWAY;
	}

	else if ((errorCode>=1301 && errorCode<=3014)
		|| (errorCode>=4002 && errorCode<=5099)
		|| (errorCode>=5200 && errorCode<=5299)
		|| (errorCode>=5400 && errorCode<=5499)
		|| (errorCode>=6001 && errorCode<=8001)
		|| errorCode==1003 || errorCode==1004
		|| errorCode==1012 || errorCode==1015
		|| errorCode==1016 || errorCode==1019
		|| errorCode==1104)
	{
		newCode = ERROR_UNEXPECTED;
	}

	else if (errorCode>=5100 && errorCode<=5199)
	{
		newCode = ERROR_SECURITY;
	}
	
	switch(newCode)
	{	
		case ERROR_GPRS_NOT_SUPPORTED:
			errId1 = TxtGPRS;
			errId2 = TxtNotSupported;
			break;

		case ERROR_CALL_DISCONNECTED:
			errId1 = TxtConnection;
			errId2 = TxtFailed;
			break;

		case 8001:
			errId1 = TxtErrorMemLow; break;
			
		/* Error type 1 */
		case 68:
			errId2 = TxtPageNotFound; break;
		/* Error type 2 */
		case 1008:
			errId2 = TxtInvalidURL; break;
		/* Error type 3 */
		case 1009:
			errId2 = TxtNoResponse; break;
		/* Error type 4 */
		case 1011: case 1017: case 1207:
			errId2 = TxtAccessDenied; break;
		/* Error type 5 */
		case 1005: case 1006: case 1007:
		case 1020: case 1101: case 1102:
		case 1105: case 1108:
			errId2 = TxtErrorInPage; break;
		/* Error type 6 */	
		case 1202: case 1203: case 1204:
		case 1205: case 1206: case 1208:
		case 1209: case 1210: case 1211:
		case 1212: case 1213:
			errId2 = TxtScriptError; break;
		/* Error type 7 */
		case ERROR_COMMUNICATION_SERVER:
			errId2 = TxtServerError; break;
		/* Error type 8 */
		case ERROR_COMMUNICATION_GATEWAY:
			errId2 = TxtGatewayError; break;
		/* Error type 9 */
		case ERROR_UNEXPECTED:
			errId2 = TxtUnexpectedErr; break;
		/* Error type 10 */
		case 1103:
			errId2 = TxtCharacterSet; break;
		/* Error type 11 */
		case 1106:
			errId2 = TxtWBXMLError; break;
		/* Error type 13 */
		case 8002:
			/* This error already intercepted above */
		case 1001:
			errId2 = TxtErrorOutOfMem; break;
		/* Error type 14 */
		case 228:
			errId2 = TxtGatewayBusy; break;
		/* Error type 15 */
		case 1014:
			errId2 = TxtNoResponse; break;
		/* Error type 16 */
		case ERROR_SECURITY:
			errId2 = TxtSecurityFail; break;
			
		case 4001:
			errId2 = TxtNoResponse;
			break;

		default:
			if (errorCode<10)
				errId2 = TxtErrorWTP;
			else if (errorCode<100)
				errId2 = TxtErrorHTTP;
			else if (errorCode<1000)
				errId2 = TxtErrorWSP;
			else if (errorCode<2000)
				errId2 = TxtErrorWAE;
			else if (errorCode<3000)
				errId2 = TxtErrorWSPCL;
			else if (errorCode<4000)
				errId2 = TxtErrorWSPCM;
			else if (errorCode<5000)
				errId2 = TxtErrorWTP;
			else if (errorCode<6000)
				errId2 = TxtErrorWTLS;
			else if (errorCode<7000)
				errId2 = TxtErrorWDP;
			else if (errorCode<8000)
				errId2 = TxtErrorUDCP;
			break;
	}
	
	/* Decide on soft keys.  If browser is not present, can only exit. */

	if (data->browser_win)
	{
		lsk = TxtReload;
		rsk = TxtSoftBack;
	}
	else
	{
		lsk = TxtNull;
		rsk = TxtExit;
	}
	
	/* Set up dialog display data */
	
	dlg_initDisplayData_TextId( &display_info, lsk, rsk, errId1, errId2, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, NULL, FOREVER, KEY_LEFT | KEY_RIGHT);

	/* If no errId1, use "Error <num>" */

	if (errId1==TxtNull)
	{
		sprintf(errorNumber, "%s %d", GET_TEXT(TxtError), errorCode);
		display_info.TextString = errorNumber;
	}

	if (errId2==TxtNull)
	{
		errId2 = TxtUnknown;
	}

	display_info.Callback		= (T_VOID_FUNC)AUI_error_cb;

	/* Destroy any previous error dialog */
	
	if (data->error_win)
	{
		SEND_EVENT(data->error_win, DIALOG_DESTROY, 0, 0);
	}
	data->error_win = info_dialog(data->win, &display_info);
	
	return;
}


/*******************************************************************************

 $Function:    	AUI_error_cb

 $Description:	Callback function for the WAP error dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_error_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
   	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_error_cb");
#endif

	if (!data)
	{
		return;
	}

	/* Error window has been destroyed */
	
	data->error_win = NULL;
	data->update_forbid = FALSE;

	/* Destroy any connecting dialog */
	
	AUI_destroy(data->win, CONNECT_WIN);

	switch(reason)
	{
		/* Right soft key: Back*/
		
		case INFO_KCD_RIGHT:
			if (data->browser_win && data->View)
			{
				ATB_wap_card_go_back(data->View);
			}
			else	/* Connecting failed, exit */
			{
				AUI_destroy(data->win, RETURN_TO_MENU);
			}
			break;

		/* Left soft key: Reload */
		
		case INFO_KCD_LEFT:
			/* If browser window is not present, try
			 * to connect again */
			if (data->browser_win)
			{
				ATB_wap_card_refresh(data->View);
			}
			else
			{
				AUI_connect_URL(data->win, data->View->URL);
			}
			break;
	}
	
	return;
}


#ifdef NEW_EDITOR
//    Nov 05, 2005 REF: OMAPS00044867 Sumanth Kumar.C
//    Fix: Define an alternate positon for the standard editor.
#define EDT_ALT_POS 1

/*******************************************************************************

 $Function:    	AUI_standard_editor

 $Description:	Sets up standard attributes for a WAP editor
 
 $Returns:		None

 $Arguments:	editor_data		- pointer to existing editor_data
 				buffer			- Text buffer to edit
 				size 			- maximum length of editor
 				mode			- editor mode
 				callback		- callback function
 				unicode			- TRUE if editor is unicode
 
*******************************************************************************/

static void AUI_standard_editor(T_AUI_EDITOR_DATA *editor_data, USHORT identifier, USHORT mode, USHORT titleId, T_AUI_EDIT_CB Callback)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_standard_editor");
#endif

	AUI_edit_SetDefault(editor_data);
	AUI_edit_SetEvents(editor_data, identifier, FALSE, FOREVER, Callback);
	AUI_edit_SetTextStr(editor_data, TxtSoftOK, TxtDelete, titleId, NULL);

//    Nov 05, 2005 REF: OMAPS00044867 Sumanth Kumar.C
//    Fix: AUI_edit_SetAltTextStr is added in the AUI_Standard_editor() with soft key back option.

	AUI_edit_SetAltTextStr(editor_data, EDT_ALT_POS, TxtSoftOK, TRUE, TxtSoftBack);
	AUI_edit_SetMode(editor_data, mode, DS_CURSOR_BAR);
	AUI_edit_SetDisplay(editor_data, ZONE_WAP_EDITOR, COLOUR_EDITOR, EDITOR_FONT);
	
    return;
}

#else /* NEW_EDITOR */

/*******************************************************************************

 $Function:    	AUI_standard_editor

 $Description:	Sets up standard attributes for a WAP editor
 
 $Returns:		None

 $Arguments:	editor_data		- pointer to existing editor_data
 				buffer			- Text buffer to edit
 				size 			- maximum length of editor
 				mode			- editor mode
 				callback		- callback function
 
*******************************************************************************/

static void AUI_standard_editor(T_EDITOR_DATA *editor_data, char *buffer, U16 size, UBYTE mode, T_EDIT_CB callback)
{
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_standard_editor");
#endif
	editor_attr_init(&editor_data->editor_attr, ZONE_WAP_EDITOR, edtCurBar1, NULL, buffer, size, COLOUR_EDITOR );
	editor_data->editor_attr.font		= 0;

	editor_data_init( editor_data, callback, TxtSoftOK, TxtDelete, NULL, 0, mode, FOREVER);
	editor_data->destroyEditor			= FALSE;		/* Default: don't destroy editor on exit */
	editor_data->hide					= FALSE;		/* Default: input not hidden */
	editor_data->Identifier				= 0;
	
    return;
}

#endif /* NEW_EDITOR */


/*******************************************************************************

 $Function:    	AUI_wap_input_dialog_open

 $Description:	Prompts the MMI to open an input dialog given a particular format and
 				string.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog)
{
	T_WAP_DATA 		*data		= AUI_wap_data();												/* WAP data */
	USHORT			formatIndex;
	USHORT			bufferIndex;
	USHORT			bufferLength;
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	USHORT			titlelen;
	USHORT			mode;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_input_dialog_open");
#endif
	
	if (!data)
	{
		return 0;
	}

	/* Set up editor */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, Dialog->dialog_id, ED_MODE_ALPHA, TxtNull, (T_AUI_EDIT_CB)AUI_input_cb);
#endif /* NEW_EDITOR */

	data->gen_pointer = Dialog->dialog_pointer;		/* Needed by GLE */

	if (Dialog->size > INPUT_MAX_LEN)
	{
		Dialog->size = INPUT_MAX_LEN;
	}

	/* SPR#2393 - SH - Ensure input buffer isn't > max size */
	
	if (Dialog->input_length > Dialog->size)
	{
		Dialog->input_length = Dialog->size;
	}
	
	/* Terminate buffer */
	
	Dialog->Input[Dialog->input_length] = 0;
	
	/* Convert input string */
	ATB_uc_text_convert(Dialog->Input, Dialog->input_length);

#ifdef NEW_EDITOR
	/* Buffer is unicode */
	bufferLength = ATB_uc_text_copy((USHORT *)data->Buffer, Dialog->Input, INPUT_MAX_LEN);
#else
	/* Buffer is ascii */
	bufferLength = ATB_uc_to_char(data->Buffer, Dialog->Input, INPUT_MAX_LEN);
#endif /* NEW_EDITOR */

	/* Convert title to MMI unicode and crop it to fit screen */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);

	if (Dialog->title_length>0)
	{
		titlelen = AUI_text_to_uc(data->Message.text, Dialog->Title, CARD_TITLE_MAX_LEN); 
		ATB_uc_text_crop(&data->Message.text[1], titlelen, WAP_SCREEN_WIDTH);
#ifdef NEW_EDITOR
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtNull, (UBYTE *)data->Message.text);
#endif /* NEW_EDITOR */
	}
	else
	{
#ifdef NEW_EDITOR
		AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtUntitled, NULL);
#else
		data->Message.text[0] = 0x7F80;
		AUI_wap_stringID(&data->Message.text[1], CARD_TITLE_MAX_LEN, WAP_STRING_UNTITLED);
#endif /* NEW_EDITOR */
	}
	
	/* Convert format characters to ascii */

	ATB_uc_text_convert((USHORT *)Dialog->Format, (USHORT)Dialog->format_length);
	ATB_uc_to_char(data->Buffer2, Dialog->Format, (USHORT)Dialog->format_length);

	/* Set up standard editor parameters */

#ifdef NEW_EDITOR
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_UNICODE, (UBYTE *)data->Buffer, Dialog->size+1);

	mode = ED_MODE_ALPHA;
	
	if (Dialog->format_length != 0)
	{
		AUI_edit_SetFormatStr(&editor_data, data->Buffer2, TRUE, ' ');
		mode |= ED_MODE_FORMATTED;
	}
	
	if (Dialog->is_password)
	{
		mode |= ED_MODE_HIDDEN;
	}
	
	if (!Dialog->empty_ok)
	{
		AUI_edit_SetAltTextStr(&editor_data, 1, TxtNull, TRUE, TxtSoftBack);
	}

	AUI_edit_SetMode(&editor_data, mode, DS_CURSOR_BAR);
	
	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else
	AUI_standard_editor(&editor_data, data->Buffer, (Dialog->size+1), ALPHA_MODE, (T_EDIT_CB)AUI_input_cb);

	/* Need to set input mode & put fixed characters into input buffer */
	
	if (Dialog->format_length != 0)
	{	
		editor_data.mode = FORMAT_MODE;
		formatIndex = 0;
		bufferIndex = 0;
		
		while (bufferIndex<Dialog->size && formatIndex<strlen(data->Buffer2))
		{
			/* Backslash character indicates fixed character */

			if (data->Buffer2[formatIndex] == '\\')
			{
				formatIndex++;
				/* Put fixed char into buffer */
				data->Buffer[bufferIndex] = data->Buffer2[formatIndex];
			}

			/* In a delimited field... */

			else if (strchr("123456789*", data->Buffer2[formatIndex]))
			{
				if (bufferIndex<bufferLength)	/* if we're not at the end of the string,  */
					formatIndex--;				/* stay where we are in the formatstring */
				else
					formatIndex++;				/* otherwise go to end of string */
			}
			
			/* If we're past the end of the existing buffer... */
			
			else if (bufferIndex>=bufferLength)
			{
				data->Buffer[bufferIndex] = ' ';	/* Fill it with empty space */
			}
			bufferIndex++;
			formatIndex++;
		}
	
		data->Buffer[bufferIndex] = 0;				/* Terminate the buffer string */
	}

	editor_data.Identifier = Dialog->dialog_id;		/* this is the dialog identity (to be passed to callback) */
	editor_data.TextString = (char *)data->Message.text;	/* String to be displayed in output buffer */
	editor_data.FormatString = data->Buffer2;			/* Provide the editor with the format string */

	/* Check if input needs to be hidden */
	
	if (Dialog->is_password)
	{
		editor_data.hide = TRUE;	
	}

	/* Is an empty response OK? */
	
	if (!Dialog->empty_ok)
		editor_data.min_enter = 1;

	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = editor_start(data->win, &editor_data);
#endif

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_input_cb

 $Description:	Callback function for the WAP input dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_input_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MMI_WAP_INPUT_DIALOG_CNF DialogCnf;
	BOOL edited;
	USHORT textlen;

	TRACE_FUNCTION("AUI_input_cb()");

	if (!data)
	{
		return;
	}
	
	/* Allow WAP browser window updates */
	
	data->update_forbid = FALSE;
	
	/* Destroy editor */
	
	AUI_destroy(data->win,EDIT_WIN);

	/* Free message string */
	AUI_wap_string_free(&data->Message);
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			edited = FALSE;		/* Don't change text */
			break;

		default:
			edited = TRUE;		/* Text is changed */
			break;
	}

	DialogCnf.object_id		= data->View->object_id;
	DialogCnf.dialog_id		= identifier;				/* Dialog id is passed from AUI_input */
	DialogCnf.edited 		= edited;					/* TRUE if text changed */
	DialogCnf.dialog_pointer    = data->gen_pointer;	/* Needed by GLE */

#ifdef NEW_EDITOR
	textlen = ATB_string_UCLength((USHORT *)data->Buffer);
#else /* NEW_EDITOR */
	textlen = strlen(data->Buffer);
#endif /* NEW_EDITOR */
	
	DialogCnf.Text = (USHORT *)AUI_wap_memory_alloc((textlen+1)*sizeof(USHORT));

#ifdef NEW_EDITOR
	/* Copy buffer text */
	DialogCnf.text_length	= ATB_uc_text_copy(DialogCnf.Text, (USHORT *)data->Buffer, textlen);
#else /* NEW_EDITOR */
	/* Convert buffer text to MMI unicode */
	DialogCnf.text_length	= ATB_char_to_uc(DialogCnf.Text, data->Buffer);
#endif /* NEW_EDITOR */
	
	/* Convert to standard unicode */
	ATB_uc_text_convert((USHORT *)DialogCnf.Text, (USHORT)DialogCnf.text_length);

	ATB_trace_ushort_string(DialogCnf.Text, (USHORT)DialogCnf.text_length);

	/* Send data to ATB */
	
	ATB_wap_input_dialog_closed(&DialogCnf);

	AUI_wap_memory_free((UBYTE *)DialogCnf.Text, (textlen+1)*sizeof(USHORT));

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_password_dialog_open

 $Description:	Prompts the MMI to open a password dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_password_dialog_open");
#endif

	if (!data)
	{
		return WAP_FAIL;
	}

	/* SPR#2393 - Clear buffer */
	
	memset(data->Buffer, 0, USERNAME_MAX_LEN+1);	/* Input field is char type */
	
	/* Need to prompt for two separate things: the username and password! */

#ifdef NEW_EDITOR
	AUI_standard_editor(&editor_data, Dialog->dialog_id, ED_MODE_ALPHA, TxtISPUsername, (T_AUI_EDIT_CB)AUI_password_cb_1);
	AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer, USERNAME_MAX_LEN+1);
	AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtISPUsername, NULL);

	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	data->edit_win = AUI_edit_Start(data->win, &editor_data);
#else /* NEW_EDITOR */
	AUI_standard_editor(&editor_data, data->Buffer, USERNAME_MAX_LEN, ALPHA_MODE, (T_EDIT_CB)AUI_password_cb_1);

	editor_data.Identifier = Dialog->dialog_id; /* this is the dialog identity (to be passed to callback) */
	editor_data.TextId = TxtISPUsername; /* SPR#2393 */
	
	/* Don't update WAP browser window while editor is open */
	data->update_forbid = TRUE;
	
	data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_password_cb_1

 $Description:	Callback function for the WAP password dialog, after username entered.
 				Prompts for password.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_password_cb_1(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
#ifdef NEW_EDITOR
	T_AUI_EDITOR_DATA editor_data;
#else
	T_EDITOR_DATA	editor_data;
#endif /* NEW_EDITOR */
	T_MMI_WAP_PASSWORD_DIALOG_CNF DialogCnf; /* SPR#2393 */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password_dialog_cb_1");
#endif

	if (!data)
	{
		return;
	}
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win,EDIT_WIN);	/* Destroy edit window */
			
			/* SPR#2393 - SH - WAP browser can update again */
			data->update_forbid = FALSE;

			/* SPR#2393 - SH - Force an update, otherwise editor screen
			 * shows forever */
			win_show(data->browser_win);

			/* SPR#2393 - SH - Send NULL username/password to indicate dialog cancelled */
			DialogCnf.object_id		= data->View->object_id;
			DialogCnf.dialog_id		= identifier;
			DialogCnf.input_length	= 0;
			DialogCnf.Input 		= NULL;
			DialogCnf.password_length  = 0;
			DialogCnf.Password		= NULL;
			ATB_wap_password_dialog_closed(&DialogCnf);
			break;

		case INFO_KCD_LEFT:
			data->Buffer2[0] = NULL;		/* Empty string for password */

#ifdef NEW_EDITOR
			AUI_standard_editor(&editor_data, identifier, ED_MODE_ALPHA | ED_MODE_HIDDEN, TxtNull, (T_AUI_EDIT_CB)AUI_password_cb_2);
			AUI_edit_SetBuffer(&editor_data, ATB_DCS_ASCII, (UBYTE *)data->Buffer2, PASSWORD_MAX_LEN+1);
			AUI_edit_SetTextStr(&editor_data, TxtSoftOK, TxtDelete, TxtISPPassword, NULL);

			data->temp_win = data->edit_win;				/* Store pointer to this edit window */
			data->edit_win = AUI_edit_Start(data->win, &editor_data); /* Create input window */

#else /* NEW_EDITOR */
			AUI_standard_editor(&editor_data, data->Buffer2, PASSWORD_MAX_LEN, ALPHA_MODE,
				(T_EDIT_CB)AUI_password_cb_2);

			editor_data.Identifier	= identifier;					/* this is the dialog identity */
			editor_data.TextString	= (char *)data->Message.text;
			editor_data.hide		= TRUE;

			data->temp_win = data->edit_win;				/* Store pointer to this edit window */
			data->edit_win = editor_start(data->win, &editor_data);
#endif /* NEW_EDITOR */

			return;
   			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_password_cb_2

 $Description:	Callback function for the WAP password dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_password_cb_2(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();	
	T_MMI_WAP_PASSWORD_DIALOG_CNF DialogCnf;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_password_cb_2");
#endif

	if (!data)
	{
		return;
	}

	/* SPR#2393 - SH - Only allow browser updates if editor is accepted */
	
	switch (reason)
	{
		case INFO_KCD_HUP:
		case INFO_KCD_RIGHT:
			AUI_destroy(data->win,EDIT_WIN);		/* Destroy this edit window */
			data->edit_win = data->temp_win;		/* Reinstate previous edit window */
			data->temp_win = NULL; /* SPR#2393 */
			break;

		case INFO_KCD_LEFT:
			/* SPR#2393 - Allow WAP browser window updates */
			data->update_forbid = FALSE;
	
			/* Destroy password dialog first so that
			 * password is stored in original buffer */
			AUI_destroy(data->win,EDIT_WIN);		/* Destroy 2nd edit window */
			data->edit_win = data->temp_win;
			AUI_destroy(data->win,EDIT_WIN);		/* Destroy 1st edit window */
			data->temp_win = NULL;  /* SPR#2393 */
			
			DialogCnf.object_id		= data->View->object_id;
			DialogCnf.dialog_id		= identifier;
			DialogCnf.input_length	= strlen(data->Buffer);
			DialogCnf.Input 		= data->Buffer;
			DialogCnf.password_length  = strlen(data->Buffer2);
			DialogCnf.Password		= data->Buffer2;
			ATB_wap_password_dialog_closed(&DialogCnf);
   			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_confirm_dialog_open

 $Description:	Prompts the MMI to open a confirmation dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_confirm_dialog_open(T_WAP_MMI_CONFIRM_DIALOG_REQ *Dialog)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	USHORT			titlelen;


#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_confirm_dialog_open");
#endif
	
	if (!data)
	{
		return 0;
	}

	/* Title, Left SK, Right SK */

	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);
	
	titlelen = AUI_text_to_uc(data->Message.text, Dialog->Message, CARD_TITLE_MAX_LEN);
	ATB_uc_text_crop(data->Message.text, titlelen, WAP_SCREEN_WIDTH);
	AUI_text_to_uc(data->LeftSoftKey, Dialog->Ok_key, Dialog->ok_key_length);
	AUI_text_to_uc(data->RightSoftKey, Dialog->Cancel_key, Dialog->cancel_key_length);

	dlg_initDisplayData_TextStr( &display_info, TxtNull, TxtNull, (char *)data->Message.text, NULL, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_confirm_cb, FOREVER, KEY_LEFT | KEY_RIGHT );
	display_info.LSKString		= (char *)data->LeftSoftKey;
	display_info.RSKString		= (char *)data->RightSoftKey;
	display_info.Identifier		= Dialog->dialog_id;

	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	info_dialog_softkeystrings (data->win, &display_info);
	return WAP_OK;
}

			
/*******************************************************************************

 $Function:    	AUI_confirm_cb

 $Description:	Callback function for the WAP confirmation dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window 
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_confirm_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MMI_WAP_CONFIRM_DIALOG_CNF DialogCnf;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_confirm_cb");
#endif

	if (!data)
	{
		return;
	}

	/* Allow WAP browser window updates */
	
	data->update_forbid = FALSE;

	/* SPR#2393 - SH - Set up DialogCnf structure */
	
	DialogCnf.object_id = data->View->object_id;
	DialogCnf.dialog_id = identifier;	/* Dialog id is passed from AUI_input */
   	
	/* Free message string */
	
	AUI_wap_string_free(&data->Message);
	
	switch (reason)
	{
		case INFO_KCD_LEFT:
		   	DialogCnf.answer = TRUE;		/* Confirmation is false */
   			break;

   		default:
		case INFO_KCD_RIGHT:
		   	DialogCnf.answer = FALSE;		/* Confirmation is false */
			break;
	}

	ATB_wap_confirm_dialog_closed(&DialogCnf);		/* Send data to ATB */
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_info_dialog_open

 $Description:	Prompts the MMI to open an info dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_info_dialog_open(T_WAP_MMI_INFO_DIALOG_REQ *Dialog)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_DISPLAY_DATA	display_info;
	USHORT			titlelen;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_info_dialog_open");
#endif

	if (!data)
	{
		return 0;
	}

	/* Message */
	
	AUI_wap_string_alloc(&data->Message, CARD_TITLE_MAX_LEN);
	
	titlelen = AUI_text_to_uc(data->Message.text, Dialog->Message, CARD_TITLE_MAX_LEN);
	ATB_uc_text_crop(data->Message.text, titlelen, WAP_SCREEN_WIDTH);
	
	dlg_initDisplayData_TextStr( &display_info, TxtNull, TxtNull, (char *)data->Message.text, NULL, COLOUR_WAP_POPUP);
	dlg_initDisplayData_events( &display_info, (T_VOID_FUNC)AUI_info_cb, THREE_SECS, 0 );

	/* Set identifier to dialog id */
	display_info.Identifier = Dialog->dialog_id;
	
	/* Don't update WAP browser window while editor is open */
	
	data->update_forbid = TRUE;
	
	info_dialog(data->win, &display_info);

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_info_cb

 $Description:	Callback function for the WAP confirmation dialog.
 
 $Returns:		void

 $Arguments:	win			- the WAP data window
 				identifier	- this is the dialog id
 				reason		- reason for callback
 
*******************************************************************************/

static void AUI_info_cb(T_MFW_HND win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();
	T_MMI_WAP_INFO_DIALOG_CNF DialogCnf;  /* SPR#2393 */

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_info_cb");
#endif

	if (!data)
	{
		return;
	}

	/* Allow WAP browser window updates */
	
	data->update_forbid = FALSE;

	/* Free message string */
	
	AUI_wap_string_free(&data->Message);

	DialogCnf.object_id = data->View->object_id;  /* SPR#2393 */
	DialogCnf.dialog_id = identifier;			/* Dialog id is passed from AUI_input */

   	/* Send data to ATB */
   	
  	ATB_wap_info_dialog_closed(&DialogCnf);  /* SPR#2393 */

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_options_menu_open

 $Description:	The ATB will send to the AUI the contents of the menu list
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	contextType	- the context, to specify the first item in the menu
 
*******************************************************************************/

static T_WAP_RES AUI_wap_options_menu_open(UBYTE contextType)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	UBYTE 			startIndex;
	UBYTE			optionIndex;
	const USHORT	optionsItems[]		= {TxtBookmark, TxtBookmarks, TxtGoTo, TxtHomepage, TxtSoftBack, TxtReload, TxtExit };
	const USHORT	contextItem[]		= {TxtGoToLink, TxtEdit, TxtSelect, TxtSelect, TxtSelect, TxtSelect, TxtSelect, TxtSelect};
	T_WAP_LIST		*OptionsList;

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_options_menu_open");
#endif

	if (!data)
	{
		return WAP_FAIL;
	}

	OptionsList = (T_WAP_LIST *)data->OptionsList;
	data->update_forbid = TRUE;
	startIndex = 0;

	OptionsList->no_of_entries = MAX_OPTIONS;

	/* If context key is supplied, insert it as first item in menu */

	if (contextType!=NULL)
	{
		OptionsList->no_of_entries++;
		/* Allocate memory and convert first entries from text tag */
		OptionsList->Entry[0] = (char *) AUI_wap_memory_alloc((SOFTKEY_MAX_LEN+1)*sizeof(USHORT));
		AUI_textid_to_uc((USHORT *)OptionsList->Entry[0], contextItem[contextType-1], SOFTKEY_MAX_LEN);
		
		startIndex = 1;		/* Start filling menu from second entry */
	}

	/* Fill in rest of entries */

	for (optionIndex=startIndex; optionIndex<OptionsList->no_of_entries; optionIndex++)
	{
		/* Allocate memory and convert options entries from text tags */
		OptionsList->Entry[optionIndex] = (char *) AUI_wap_memory_alloc((SOFTKEY_MAX_LEN+1)*sizeof(USHORT));

		AUI_textid_to_uc((USHORT *)OptionsList->Entry[optionIndex], optionsItems[optionIndex-startIndex], SOFTKEY_MAX_LEN);
	}

	/* Create the options list */
	
	data->optionsmenu_data = AUI_entry_list_create (data->win, OptionsList, (ListCbFunc)AUI_options_menu_cb,0);
	data->optionsmenu_win = data->optionsmenu_data->win;

	return WAP_OK;
}


/*******************************************************************************

 $Function:    	AUI_options_menu_cb

 $Description:	Callback function for options menu
 
 $Returns:		void		

 $Arguments:	win				- parent window
 				EntryListData	- list menu data of bookmarks lsit
 
*******************************************************************************/

static void AUI_options_menu_cb(T_MFW_HND win, ListMenuData *EntryListData)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	T_WAP_VIEW		*View;
	UBYTE			no_of_entries;	

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_options_menu_cb");
#endif

	if (!data)
	{
		return;
	}

	View = data->View;
	
	switch(EntryListData->Reason)
	{
		case LISTS_REASON_SELECT:	
			/* Option is selected... */
			no_of_entries = EntryListData->ListLength;
			data->OptionSelect = EntryListData->ListPosition;	/* Store selected option no. */

			/* Check if there's a contextual key in menu */
			
			if (no_of_entries>MAX_OPTIONS)
			{
				if (data->OptionSelect==0)					/* if we've selected it... */
				{
					AUI_destroy(win, OPTIONSMENU_WIN);		/* Destroy options menu */
					ATB_wap_options_menu_select(View);		/* Inform ATB */
					return;
				}
				else
					data->OptionSelect--;					/* Otherwise, pretend it isn't there */
			}

			switch(data->OptionSelect)
			{
  				case WAP_ADDBOOKMARK:	
  					/* Try to add current title to bookmarks */
  				
					if (ATB_wap_entry_add(View->Bookmarks, (char *)View->Title)==WAP_FAIL)
						AUI_info_dialog(data->win, TxtBookmarks, TxtFull);		/* if it's full, say "Bookmarks Full" */
					else
					{
						ATB_wap_entry_add(View->BookmarksURL, View->URL);		/* Store URL */
						ATB_wap_profile_save(View);								/* Save change to flash */
						AUI_info_dialog(data->win, TxtStored, NULL);			/* Display "Stored" message */
					}
					break;
    			
				case WAP_BOOKMARKS:
					/* Open up bookmarks list */
					AUI_entry_list(win, View->Bookmarks, (ListCbFunc) AUI_bookmarks_list_cb,0);
    				break;

    			case WAP_GOTO:
    				/* Destroy any previous options menu existing */
					if (data->options_win)
					{
						AUI_destroy(data->win, OPTIONS_WIN);
					}
					
					/* Create "Go To" options menu */

					data->options_win = bookMenuStart(win, WAPGoToAttributes(), 0);
					SEND_EVENT(data->options_win, ADD_CALLBACK, NULL, (void *)AUI_goto_cb);
  					break;
  				
    			case WAP_HOMEPAGE:	
    				/* Connect to homepage */
    				AUI_destroy(win, OPTIONSMENU_WIN);
    				AUI_connect_URL(win, View->Profile->Homepage);
    				break;
    			
    			case WAP_BACK:
    				/* Go back */
    				AUI_destroy(win, OPTIONSMENU_WIN);
    				ATB_wap_card_go_back(View);
    				break;

    			case WAP_RELOAD:
    				/* Reload current card */
    				AUI_destroy(win, OPTIONSMENU_WIN);
    				ATB_wap_card_refresh(View);
    				break;
    			
    			case WAP_EXIT:
    				/* Exit WAP, return to menu */
    				AUI_destroy(win, RETURN_TO_MENU);
    				break;
			}
			break;

		/* Exit menu  */
		
  		case LISTS_REASON_BACK:
  		case LISTS_REASON_CLEAR:	
			AUI_destroy(win,OPTIONSMENU_WIN);	/* Return to browser */
  			break;

  		default:
  			break;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_goto_cb

 $Description:	Callback function for the goto URL menu
 
 $Returns:		

 $Arguments:	menu 	- pointer to current menu
 				item 	- pointer to current menu item
 
*******************************************************************************/

static void AUI_goto_cb(T_MFW_HND parent_win, USHORT identifier, SHORT reason)
{
	T_WAP_DATA *data = AUI_wap_data();

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_goto_cb");
#endif

	if (!data)
	{
		return;
	}
	
	data->menu_win = NULL;
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_memory_alloc

 $Description:	Allocate a block of memory
 
 $Returns:		Address if successful, null if not.

 $Arguments:	size of memory to be allocated.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

UBYTE* AUI_wap_memory_alloc(U32 size)
{
#ifdef TRACE_MEMALLOC
	memUsed += size;
	if (size<110)
	{
		memTracker[size]++;
		TRACE_EVENT_P2("ALLOC %d, tracking = %d", size, memTracker[size]);
	}
	else
	{
		TRACE_EVENT_P2("ALLOC %d, used = %d", size, memUsed);
	}
#endif

	return mfwAlloc(size);
}


/*******************************************************************************

 $Function:    	AUI_wap_memory_free

 $Description:	Called by the WAP.ATB to free memory
 
 $Returns:		

 $Arguments:	address and size of memory to be freed.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

void AUI_wap_memory_free(UBYTE* address,U32 size)
{
#ifdef TRACE_MEMALLOC
	memUsed -= size;
	if (size<110)
	{
		memTracker[size]--;
		TRACE_EVENT_P2("FREE %d, tracking = %d", size, memTracker[size]);
	}
	else
	{
		TRACE_EVENT_P2("FREE %d, used = %d", size, memUsed);
	}
#endif

	mfwFree(address,size);
	return;
}

/*******************************************************************************

 $Function:    	AUI_wap_string_alloc

 $Description:	Allocates memory for a string.  Will free any existing
 				stored string.
 
 $Returns:		None.

 $Arguments:	Size of string to be allocated, in unicode characters, not including
 				null terminator.
 
*******************************************************************************/

static void AUI_wap_string_alloc(T_WAP_STRING *string, USHORT size)
{
	if (string->length!=0)
	{
		/* If the size is correct, no allocation or freeing required */
		
		if (string->length==size)
			return;
			
		/* Otherwise, free the current message block */

		AUI_wap_string_free(string);
	}

	string->text = (USHORT *)AUI_wap_memory_alloc((size+1)*sizeof(USHORT));
	string->length = size;
	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_string_free

 $Description:	Frees an allocated string
 
 $Returns:		None.

 $Arguments:	string - Pointer to the string
 
*******************************************************************************/

static void AUI_wap_string_free(T_WAP_STRING *string)
{		
	if (string->length!=0)
	{
		AUI_wap_memory_free((UBYTE *)string->text, (string->length+1)*sizeof(USHORT));
		string->text = NULL;
		string->length = 0;
	}

	return;
}


/*******************************************************************************

 $Function:    	ATB_wap_card_show

 $Description:	Called by the WAP ATB to show the and/or create the card window.
 
 $Returns:		None.

 $Arguments:	View	- The current view

 
*******************************************************************************/

void AUI_wap_card_show_req(T_WAP_VIEW *View)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_card_show_req");
#endif

	if (!data)
	{
		return;
	}
	
	/* If the connecting window or list window are still extant,
	 * destroy them */

	AUI_destroy(data->win, CONNECT_WIN | LIST_WIN);
						
	/* If WAP browser window doesn't exist, create it */
	
	if (data->browser_win==NULL)
	{
		data->browser_win = AUI_win_create(data->win);
	}

	/* Initialise browser window */
	
	SEND_EVENT(data->browser_win,WAP_SHOW_CARD,0,0);

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_status_notify

 $Description:	Called by the WAP ATB when a status flag has changed
 
 $Returns:		None.

 $Arguments:	View			- The current view
				status			- parameter which status has changed
 
*******************************************************************************/

void AUI_wap_status_notify(T_WAP_VIEW *View, USHORT status)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_status_notify");
#endif

	if (!data)
	{
		return;
	}
	
	switch (status)
	{

		/* If no status, destroy connecting window */

		case ATB_WAP_NO_STATUS:
			TRACE_EVENT("ATB_WAP_NO_STATUS");
			AUI_destroy(data->win, CONNECT_WIN);
			break;

		/* GPRS attach in progress */
		
		case ATB_WAP_ATTACHING:
			TRACE_EVENT("ATB_WAP_ATTACHING");	
			data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_ATTACHING);
			break;

		/* GPRS failed to attach */
		
		case ATB_WAP_ATTACH_FAILED:
			TRACE_EVENT("ATB_WAP_ATTACH_FAILED");
			AUI_destroy(data->win, BROWSER_WIN | CONNECT_WIN);
			AUI_info_dialog(data->win, TxtGPRS, TxtNotAvailable);
			break;

		/* GPRS error occurred */
		
		case ATB_WAP_ERROR:
			TRACE_EVENT("ATB_WAP_ERROR");
			if (wap_callActive || data->connected)
			{
				AUI_destroy(data->win, BROWSER_WIN | CONNECT_WIN);	
				AUI_info_dialog(data->win, TxtGPRS, TxtError);
				wap_callActive = FALSE;
				data->connected = FALSE;
			}
			break;

		/* PDP context activation failed */
		
		case ATB_WAP_ACTIVATE_FAILED:
			TRACE_EVENT("ATB_WAP_ACTIVATE_FAILED");
			AUI_destroy(data->win, CONNECT_WIN);
			AUI_wap_end_call(-1);		/* End GPRS data call */
			AUI_info_dialog(data->win, TxtConnection, TxtFailed);
			wap_callActive = FALSE;
			data->connected = FALSE;
			break;

		/* Connection to WAP gateway is proceeding */
		
		case ATB_WAP_CONNECTING:
			TRACE_EVENT("ATB_WAP_CONNECTING");
			
			wap_callActive = TRUE;
			data->connected = TRUE;
			data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_CONNECTING);
			break;

		/* Connection has been established */
		
		case ATB_WAP_LOGGING_IN:
			TRACE_EVENT("ATB_WAP_LOGGING_IN");
			/* If browser window is present, destroy it,
			 * so on re-creation it will be the top window */

			AUI_destroy(data->win, BROWSER_WIN);
			
			/* Display dialog with "Logging In" */
			data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_LOGGING_IN);
			break;

		/* Card is being downloaded from network */
		
		case ATB_WAP_DOWNLOADING:
			TRACE_EVENT("ATB_WAP_DOWNLOADING");
			data->connected = TRUE;
			break;

		/* Status to indicate card is being read
		 * from cache or from network */
		 
		case ATB_WAP_CARD_READING:
			TRACE_EVENT("ATB_WAP_CARD_READING");
			if (data->connect_win)
			{
				data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_CARD_READING);
			}
			break;

		/* The connection has been closed */
		
		case ATB_WAP_ONLINE_CONNECTION_CLOSED:
			TRACE_EVENT("ATB_WAP_ONLINE_CONNECTION_CLOSED");
			AUI_destroy(data->win, BROWSER_WIN | CONNECT_WIN | OPTIONS_WIN | OPTIONSMENU_WIN);
			data->connected = FALSE;
			wap_callActive = FALSE;
			break;

		/* WAP is waiting for a signal from the network */
		
		case ATB_WAP_PLEASE_WAIT:
			TRACE_EVENT("ATB_WAP_PLEASE_WAIT");
			data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_PLEASE_WAIT);
			break;

		/* WAP is shutting down */
		
		case ATB_WAP_SHUTTING_DOWN:
			TRACE_EVENT("ATB_WAP_SHUTTING_DOWN");
			break;

		/* Waiting for PDP context to deactivate */
		
		case ATB_WAP_DEACTIVATING:
			TRACE_EVENT("ATB_WAP_DEACTIVATING");
			data->connect_win =  AUI_connecting_dialog(data->win, ATB_WAP_DEACTIVATING);
			break;
			
		default:
			TRACE_EVENT("** UNKNOWN STATUS **");
			return;		
	}

	if (data->browser_win)	/*The card is prompted to show the status*/
	{
		TRACE_EVENT("Updating card view for status.");
		win_show(data->browser_win);
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_change_soft_key

 $Description:	Called by the WAP.ATB when the card requests a custom text for a
 				soft key
 
 $Returns:		None

 $Arguments:	View			- The current view
 				Label			- The text of the custom soft key
 				length			- Length of the text
 				keyId			- The id of the key, to send to the AUS Browser
 									when the key is pressed.
 
*******************************************************************************/

void AUI_wap_change_soft_key(T_WAP_VIEW *View, USHORT *Label, USHORT length, USHORT keyId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	SHORT			optionsWidth;
	USHORT			optionsLength;
	SHORT			labelWidth;
	char			*LeftKeyTag	= (char *)data->LeftSoftKey;
	char			*RightKeyTag = (char *)data->RightSoftKey;
	USHORT			*LeftKeyText = &data->LeftSoftKey[1];
	USHORT			*RightKeyText = &data->RightSoftKey[1];

#ifdef TRACE_AUIWAP
	TRACE_FUNCTION("AUI_wap_change_soft_key");
#endif

	if (!data)
	{
		return;
	}
	
	if (length > 0)
	{
		/* Insert unicode tag and convert to MMI unicode */
		
		LeftKeyTag[0] = 0x80;
		LeftKeyTag[1] = 0x7F;
		optionsLength = AUI_textid_to_uc(LeftKeyText, TxtSoftOptions, SOFTKEY_MAX_LEN);
		RightKeyTag[0] = 0x80;
		RightKeyTag[1] = 0x7F;
		ATB_uc_text_copy(RightKeyText, Label, length);
		ATB_uc_text_convert(RightKeyText, length);
		
		/* Make sure softkeys fit into the space by cropping them if necessary */

		optionsWidth	= ATB_uc_text_width(LeftKeyText, optionsLength);
		labelWidth		= ATB_uc_text_width(RightKeyText, length);

		if ((labelWidth+optionsWidth) > WAP_TOTAL_WIDTH)						/* If they don't fit... */
		{
			optionsWidth = WAP_TOTAL_WIDTH-labelWidth-WAP_SOFTKEY_SPACING;		/* Try shortening "options" */
			if (optionsWidth<ATB_uc_text_width(LeftKeyText, WAP_SOFTKEY_MIN_LENGTH))    /* If it's too short.... */
			{
				optionsWidth = ATB_uc_text_width(LeftKeyText, WAP_SOFTKEY_MIN_LENGTH); /* Shorten the other key */
				labelWidth = WAP_TOTAL_WIDTH-optionsWidth-WAP_SOFTKEY_SPACING;
			}
		}
		ATB_uc_text_crop(LeftKeyText, optionsLength, optionsWidth);	/* Crop the texts */
		ATB_uc_text_crop(RightKeyText, length, labelWidth);
		View->CustSoftKeys = TRUE;									/* We are using cust. soft keys */
		View->CustSoftKeyId = keyId;
	}
	else
		View->CustSoftKeys = FALSE;

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_stringID

 $Description:	Gives the ATB the text of a required string (specific for now)
 
 $Returns:		The length of the destination string.

 $Arguments:	dest - The destination string (MMI Unicode)
				destlen - Maximum length the destination string can be in Unicode characters.
				stringID - The string required.
 
*******************************************************************************/

USHORT AUI_wap_stringID(USHORT *dest, USHORT destlen, USHORT stringID)
{
	USHORT *temp;
	USHORT src;
	USHORT length;

	switch (stringID)
	{
		case WAP_STRING_DOWNLOADING:
			src = TxtDownloading;
			break;

		case WAP_STRING_UPDATING:
			src = TxtUpdating;
			break;

		case WAP_STRING_UNTITLED:
			src = TxtUntitled;
			break;
			
		default:
			src = TxtError;
			break;
	}

	length = AUI_textid_to_uc(dest, src, destlen);
	
	return length;
}


/*******************************************************************************

 $Function:    	AUI_textid_to_uc

 $Description:	Converts a string from a text ID to an MMI-converted unicode string.
 
 $Returns:		Length of resulting string

 $Arguments:	dest	- Place to store the result.
 				textId	- The string to translate.
				destlen	- Maximum length of result
 
*******************************************************************************/

static USHORT AUI_textid_to_uc(USHORT *dest, int textId, USHORT destlen)
{
	USHORT length;
	char *srctext = MmiRsrcGetText(textId);

	if (Mmi_getCurrentLanguage() == CHINESE_LANGUAGE)
	{
		length = ATB_uc_text_copy(dest, (USHORT *)srctext, destlen);
	}
	else
	{
		length = ATB_char_to_uc(dest, srctext);
	}
	
	return length;
}


/*******************************************************************************

 $Function:    	AUI_text_to_uc

 $Description:	Converts a standard unicode string to an MMI-converted unicode string,
 				including the 0x80 at the start
 
 $Returns:		N/A

 $Arguments:	dest	- Place to store the result.
 				src		- The string to translate.
 				destLen	- Size of destination array in unicode characters
 
*******************************************************************************/

static USHORT AUI_text_to_uc(USHORT *dest, USHORT *src, USHORT destlen)
{
	USHORT length;

	length = ATB_uc_text_copy(&dest[1], src, destlen);
	ATB_uc_text_convert(&dest[1], length);

	dest[0] = 0x7F80;
		
	return length;
}


/*******************************************************************************

 $Function:    	AUI_wap_launch_browser

 $Description:	Launches the browser to a given URL and a bearer list arranged by priority. 
 
 $Returns:		TRUE-> succesfully launched, FALSE -> error

 $Arguments:	The URL and the bearer list.
 
*******************************************************************************/

T_MFW_HND AUI_wap_launch_browser(char *URL,UBYTE* bearer_list,UBYTE bearer_list_len)
{
    T_MFW_HND wap_window;

	if (!(wap_window = AUI_create(idle_get_window())))
		return NULL; /*Error */

	AUI_connect_URL(wap_window,URL);

    return wap_window;
}


/*******************************************************************************

 $Function:    	AUI_wap_extDestroy

 $Description:	Allows external files to destroy the WAP application
 
 $Returns:		None.

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_extDestroy(void)
{	
	T_WAP_DATA 		*data		= AUI_wap_data();

	if (!data)
	{
		return;
	}
	
	AUI_destroy(data->win, ALL_WIN);

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_call_connect

 $Description:	Called when a CSD call is connected
 
 $Returns:		None.

 $Arguments:	
 
*******************************************************************************/

void AUI_wap_call_connect(SHORT cId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	if (!data)
	{
		return;
	}
	
	if (data->View)
	{	
		TRACE_FUNCTION("AUI_wap_call_connect()");
		data->View->cId = cId;
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_call_disconnect

 $Description:	Called when a CSD call is terminated - informs WAP of this.
 				
 $Returns:		None.

 $Arguments:	The ID of the call.
 
*******************************************************************************/

void AUI_wap_call_disconnect(SHORT cId)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	TRACE_FUNCTION("AUI_wap_call_disconnect()");
	
	if (!data)
	{
		return;
	}
	
	if (data->View)
	{	
		/* View exists; are we in the connected, or in the connecting screen? */

		if (data->connected || data->connect_win || data->browser_win)
		{
			/* Check it's the right call */
			
			if (cId==data->View->cId)
			{
				ATB_wap_disconnect(data->View);  /* Disconnect WAP browser */
				data->View->cId = -1;
				ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
				AUI_error_dialog(data->View, ERROR_CALL_DISCONNECTED);
			}
		}
	}

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_end_call

 $Description:	Determine whether call is CSD or GPRS, and attempt to end it.
 
 $Returns:		None.

 $Arguments:	cId - call ID of the CSD call (ignored for GPRS profile).
 
*******************************************************************************/

void AUI_wap_end_call(SHORT cId)
{
	T_WAP_DATA *data = AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_end_call()");

	if (!data)
	{
		return;
	}
	
	/* If WAP browser is active, inform it of disconnection */
	
	if (data->View)
	{
		/* If there is a waiting incoming call, accept it now */
		
		if (data->call_waiting)
		{
			cm_mt_accept();
			data->call_waiting = FALSE;
			return;
		}
		
		ATB_wap_disconnect(data->View);
		
		if (data->View->Profile->AccessType == WAP_CS_DATA)
		{
			/* If call ID is not -1, call is active.
			 * End it using cm_disconnect */
			 
			if (data->View->cId!=-1)
			{
				TRACE_EVENT_P1("Disconnecting CSD call: %d", data->View->cId);
				cm_disconnect(data->View->cId);
				data->View->cId = -1;
			}
			
			if (call_get_window())
			{
				TRACE_EVENT("Destroying calling window.");
				SEND_EVENT(call_get_window(), CALL_DESTROY_CALLING_WINDOW, 0, 0);
				data->View->cId = -1;
			}
			return;
		}
		else
		{
			TRACE_EVENT("Disconnect GPRS call.");

			/* If GPRS call is not yet terminated, set
			 * status so "Please Wait" is shown until it is. */
			 
			if (!disconnect_wap_call(WAP_GPRS_DATA))
			{
				TRACE_EVENT("Waiting for disconnection.");
				ATB_wap_status_change(data->View, ATB_WAP_DEACTIVATING);
			}
			return;
		}
	}

	/* If we've reached here, the the WAP application
	 * is closed, but the call is still open */

	TRACE_EVENT("WAP is closed; attempting to end call");

	/* If call ID is not -1, call is active.
	 * End it using cm_disconnect */
	 
	if (cId!=-1)
	{
		TRACE_EVENT("Disconnecting CSD call in progress.");
		cm_disconnect(cId);
	}
				
	/* Destroy calling window */
		
	if (call_get_window())
	{
		TRACE_EVENT("Destroying calling window.");
		SEND_EVENT(call_get_window(), CALL_DESTROY_CALLING_WINDOW, 0, 0);
	}

#ifdef MMI_GPRS_ENABLED
	/* Terminate any GPRS call in progress.
	 * If GPRS call is not yet terminated, set
	 * status so "Please Wait" is shown until it is. */
	if (!disconnect_wap_call(WAP_GPRS_DATA))
	{
		TRACE_EVENT("Waiting for disconnection.");
		ATB_wap_status_change(data->View, ATB_WAP_DEACTIVATING);
	}
#endif

	return;
}


/*******************************************************************************

 $Function:    	AUI_wap_in_call

 $Description:	Returns TRUE if a WAP CSD call is currently active.
 
 $Returns:		TRUE or FALSE

 $Arguments:	None.
 
*******************************************************************************/

UBYTE AUI_wap_in_call(void)
{
	T_WAP_DATA 		*data		= AUI_wap_data();

	UBYTE result;

	TRACE_FUNCTION("AUI_wap_in_call()");
	
	if (!data)
	{
		return FALSE;
	}

	result = FALSE;

	/* Ensure that view is open */
		
	if (data->View)
	{
		/* If the call ID is not -1, there is a call in progress */
		if (data->View->cId!=-1)
		{
			result = TRUE;
		}
	}

	return result;
}


/*******************************************************************************

 $Function:    	AUI_wap_browser_disconnect()

 $Description:	Shuts down browser.  Only use in the case where
 				there is an incoming call waiting to be accepted.
 
 $Returns:		TRUE or FALSE

 $Arguments:	None.
 
*******************************************************************************/

void AUI_wap_browser_disconnect()
{
	T_WAP_DATA 		*data		= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_browser_disconnect()");
	
	if (!data)
	{
		return;
	}
	
	if (data->View)
	{
		data->call_waiting = TRUE;				/* There is a waiting call */
		ATB_wap_stop_download(data->View);		/* Stop any active download */
		ATB_wap_disconnect(data->View);			/* Disconnect the WAP browser */
		AUI_destroy(data->win, ALL_WIN);		/* Shut down WAP */
	}

	return;
}


#ifdef MMI_GPRS_ENABLED

/*******************************************************************************

 $Function:    	AUI_wap_GPRS_status

 $Description:	Called when GPRS state changes.  If WAP is active, updates status.
 
 $Returns:		None.

 $Arguments:	status - The GPRS status
 
*******************************************************************************/

void AUI_wap_gprs_status(UBYTE status)
{
	T_WAP_DATA 		*data	= AUI_wap_data();
	
	TRACE_FUNCTION("AUI_wap_gprs_status()");

	if (!data)
	{
		return;
	}
	
	if (data->View->Profile->AccessType==WAP_GPRS_DATA)
	{
		switch (status)
		{
			case GPRS_ATTACHED:
				TRACE_EVENT("STATUS: Attached.");
				
				/* Check that login is still proceeding */

				if (ATB_wap_status_get(data->View, ATB_WAP_ATTACHING))
				{
					ATB_wap_status_change(data->View, ATB_WAP_LOGGING_IN);
					/* Are now attached, can connect */
					connect_gprs(data->View->object_id);
				}
				break;
				
			case GPRS_OFF:
				TRACE_EVENT("STATUS: Detached");
				disconnect_wap_call(WAP_GPRS_DATA);
				ATB_wap_status_change(data->View, ATB_WAP_ATTACH_FAILED);
				break;

			case GPRS_CONTEXT_ACTIVATE:
				TRACE_EVENT("STATUS: Context Activated");
				break;

			case GPRS_CONTEXT_DEACTIVATE:
					TRACE_EVENT("STATUS: Context Deactivated");
					
					/* If we're deactivating, this is OK, finish closing */
					
					if (ATB_wap_status_get(data->View, ATB_WAP_DEACTIVATING))
					{
						ATB_wap_status_change(data->View, ATB_WAP_ONLINE_CONNECTION_CLOSED);
					}
					
					/* Otherwise, PDP context activation has failed */
					
					else if (ATB_wap_status_get(data->View, ATB_WAP_PLEASE_WAIT)
						|| ATB_wap_status_get(data->View, ATB_WAP_CONNECTING)
						|| ATB_wap_status_get(data->View, ATB_WAP_LOGGING_IN))
					{
						ATB_wap_status_change(data->View, ATB_WAP_ACTIVATE_FAILED);
					}
					break;


			case GPRS_ERROR:
				TRACE_EVENT("STATUS: ERROR");
				AUI_wap_end_call(-1);				/* Call ID is -1 for GPRS */
				ATB_wap_status_change(data->View, ATB_WAP_ERROR);
				break;
		}
	}
	return;
}
#endif /* MMI_GPRS_ENABLED */
#endif /* !#ifdef FF_GPF_TCPIP */
