/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	                                                      
 $Project code:	                                                           
 $Module:		
 $File:		    ATBWapAUI.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Contains definitions and prototypes for the ATB.
    
                        
********************************************************************************

 $History: ATBWapAUI.h
 
    xreddymn Jun-29-2005 MMI-ENH-32467:
    Handling of animated GIF images


    xrashmic 29 Jun, 2005 MMI-SPR-32462
    Patch given by Kyle for display of table border
       
    Apr 28 2005  REF:  MMI-SPR-30400  x0012849
    To display the contents of Drop down menu correctly when a page is browsed through  D sample.

    xreddymn Mar-25-2005 MMI-SPR-26144
    Added changes to display progress information when sending MMS

    xreddymn Mar-22-2005 MMI-SPR-29767
    Modified behaviour of SL push message handling in MMI

    xreddymn Mar-25-2005 MMI-SPR-26144
    Added changes to display progress information when sending MMS

    Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
    Description: MFW memory size variable changed from U16 -> U32
    Solution: The use of variable U16 has been replaced with U32

    Dec-10-2003 MMI-SPR-26159 - xreddymn: Prevent duplicate entries in History List

	14/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/
#include "MmiResources.h"

//#define CO_UDP_IP temp till xml file ready

/* FUNCTIONS FOR TRACING */

#if defined(TRACE_ATBWAPAUI) || defined(TRACE_ATBWAPACI)
void ATB_trace_string(char *String, USHORT length);
void ATB_trace_ushort_string(USHORT *String, USHORT length);
#endif

/* SPR#1437 - SH - All display constants stored here, except checkbox sizes
 * which are in wap_types.h */

#define WAP_CHAR_HEIGHT			(LINE_HEIGHT)	/* Height of a line of text */
#define WAP_CHAR_WIDTH  		(CHAR_WIDTH)	/* Width of a character */
#define WAP_TOTAL_WIDTH			SCREEN_SIZE_X	/* Total width of screen */
#define WAP_TOTAL_HEIGHT		SCREEN_SIZE_Y	/* Total height of screen */
#define WAP_LEFT_BORDER			0				/* Border at left of screen */
#define WAP_RIGHT_BORDER		4				/* Border at right of screen */
#define WAP_TOP_BORDER			(Mmi_layout_TitleHeight())	/* Border at top of screen (title) */
#define WAP_BOTTOM_BORDER		(Mmi_layout_softkeyHeight())	/* Border at bottom of screen (softkeys) */
#define WAP_SCREEN_RIGHT		(WAP_TOTAL_WIDTH - WAP_RIGHT_BORDER)
#define WAP_SCREEN_BOTTOM		(WAP_TOTAL_HEIGHT - WAP_BOTTOM_BORDER)
#define WAP_SCREEN_WIDTH		(WAP_TOTAL_WIDTH - WAP_LEFT_BORDER - WAP_RIGHT_BORDER)		/* No of pixels available to the wap browser in width... */
#define WAP_SCREEN_HEIGHT		(WAP_TOTAL_HEIGHT - WAP_TOP_BORDER - WAP_BOTTOM_BORDER)		/* and height (not including title & softkeys) */
#define WAP_PAGE_SCROLL 		(WAP_SCREEN_HEIGHT-WAP_CHAR_HEIGHT)		/* Long scrolling size */
#define WAP_TEXT_LOWEST			(WAP_SCREEN_HEIGHT-WAP_CHAR_HEIGHT)	 /* Lowest point we can draw text */
#define WAP_VSCROLLBAR_WIDTH	3		/* Total width of the vertical scrollbar */
#define WAP_HSCROLLBAR_WIDTH	4		/* Total width of the horizontal scrollbar */
#define WAP_SOFTKEY_SPACING	 2			/* Minimum spacing between softkey texts */
#define WAP_SOFTKEY_MIN_LENGTH 5		/* Minimum length for softkey text (including two dots for truncated strings) */

/*******************************************************************************

 $Function:    	ATB_wap_start

 $Description:	Starts the WAP application
 
 $Returns:		

 $Arguments:	parameter - a dummy parameter
 
*******************************************************************************/

#ifdef CO_UDP_IP
void ATB_wap_start(T_MMI_WAP_START_IND *parameter);
#else
void ATB_wap_start(T_MMI_WAP_START_USER_AGENT_REQ *parameter);
#endif



/*******************************************************************************

 $Function:    	ATB_wap_new_view

 $Description:	Starts a new view, defining the graphical size of the screen to
 				be handled.
 
 $Returns:		Pointer to the data structure of the new view

 $Arguments:	parameter		- width and height of the WAP view
 				UIdata			- Optional generic pointer, for use by the user
 								interface.  This can point to window information, etc,
 								but is not used by ATB.
 
*******************************************************************************/
T_WAP_VIEW* ATB_wap_new_view(T_MMI_WAP_NEW_VIEW_IND *parameter, void* UIdata);
#ifdef FF_GPF_TCPIP
T_WAP_VIEW* ATB_wap_new_view_invisible(UBYTE object_id); /* SPR#2086 */
#endif

/*******************************************************************************

 $Function:    	ATB_wap_get_view

 $Description:	Returns a pointer to a view, given its object_id
 
 $Returns:		Pointer to the data structure of the specified view

 $Arguments:	object_id  - the id of the view
 
*******************************************************************************/

T_WAP_VIEW* ATB_wap_get_view(UBYTE object_id);


/*******************************************************************************

 $Function:    	ATB_wap_terminate

 $Description:	Closes the WAP application and frees all the memory allocated
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES ATB_wap_terminate();
T_WAP_RES ATB_wap_config_int(T_WAP_VIEW *View, USHORT param, U32 value);
T_WAP_RES ATB_wap_config_str(T_WAP_VIEW *View, USHORT param, char *string, U32 length);
T_WAP_RES ATB_wap_conn_config_int(T_WAP_VIEW *View, USHORT param, U32 value);
T_WAP_RES ATB_wap_conn_config_str(T_WAP_VIEW *View, USHORT param, char *string, U32 length);

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_wap_config_int

 $Description:	SPR#1921 - SH - Added
 				Sends integer configuration information to the browser
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View	- The current view
 				param	- ID of the configuration
 				value	- Integer value of the configuration
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES ATB_wap_config_int(T_WAP_VIEW *View, USHORT param, U32 value);


/*******************************************************************************

 $Function:    	ATB_wap_config_str

 $Description:	SPR#1921 - SH - Added
 				Sends string configuration information to the browser
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View	- The current view
 				param	- ID of the configuration
 				value	- Integer value of the configuration
 				string	- String value of the configuration
 				length	- Length of the string value
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES ATB_wap_config_str(T_WAP_VIEW *View, USHORT param, char *string, U32 length);


/*******************************************************************************

 $Function:    	ATB_wap_conn_config_int

 $Description:	SPR#1921 - SH - Added
 				Sends integer configuration information to the browser
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View	- The current view
 				param	- ID of the configuration
 				value	- Integer value of the configuration
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES ATB_wap_conn_config_int(T_WAP_VIEW *View, USHORT param, U32 value);


/*******************************************************************************

 $Function:    	ATB_wap_conn_config_str

 $Description:	SPR#1921 - SH - Added
 				Sends string configuration information to the browser
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View	- The current view
 				param	- ID of the configuration
 				value	- Integer value of the configuration
 				string	- String value of the configuration
 				length	- Length of the string value
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES ATB_wap_conn_config_str(T_WAP_VIEW *View, USHORT param, char *string, U32 length);


/*******************************************************************************

 $Function:    	ATB_wap_destroy

 $Description:	Destroys the wap application, including all views (calls ATB_wap_terminate)
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				
 
*******************************************************************************/
#endif
T_WAP_RES ATB_wap_destroy();


/*******************************************************************************

 $Function:    	ATB_wap_UIdata

 $Description:	Returns the UI pointer, for use by AUI
 
 $Returns:		The void pointer

 $Arguments:	
 				
 
*******************************************************************************/

void *ATB_wap_UIdata();
T_WAP_RES ATB_wap_download_url(T_WAP_VIEW *View, char *URL, BOOL reload);


/*******************************************************************************

 $Function:    	ATB_wap_stop_download

 $Description:	Requests the WAP browser to stop downloading a particular URL
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 
*******************************************************************************/

T_WAP_RES ATB_wap_stop_download(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_card_refresh

 $Description:	Requests the WAP browser to refresh the current card from the network
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 
*******************************************************************************/

T_WAP_RES ATB_wap_card_refresh(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_card_display

 $Description:	Requests the WAP browser to redisplay a card held in the cache
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 
*******************************************************************************/

T_WAP_RES ATB_wap_card_display(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_card_go_back

 $Description:	Requests the WAP browser to go to the previous card
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 
*******************************************************************************/

T_WAP_RES ATB_wap_card_go_back(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_card_key_event

 $Description:	Requests the WAP browser react to a key event, up/down etc.
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 
*******************************************************************************/

T_WAP_RES ATB_wap_card_key_event(T_WAP_VIEW *View, WAP_CONTROL_TYPES keyType);


/*******************************************************************************

 $Function:    	ATB_wap_key_selected

 $Description:	Send the id of the selected WAP key to the AUS browser.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 				keyId - Key identifier
 
*******************************************************************************/

T_WAP_RES ATB_wap_key_selected(T_WAP_VIEW *View, USHORT keyId);


/*******************************************************************************

 $Function:    	ATB_wap_card scroll

 $Description:	Scroll to a y position on the current card
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	scrollPos			- Y position on card to which to scroll
 
*******************************************************************************/

T_WAP_RES ATB_wap_card_scroll(T_WAP_VIEW *View, SHORT scrollPos);


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	AUI_wap_input_dialog_open

 $Description:	Prompts the MMI to open an input dialog given a particular format and
 				string.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	Dialog			- Dialog information
 				View			- The current view
 
*******************************************************************************/

T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog, T_WAP_VIEW *View);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_input_dialog_closed

 $Description:	Provides the answer of an input dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				DialogCnf		- Dialog confirmation information
 
*******************************************************************************/


T_WAP_RES ATB_wap_input_dialog_closed(T_MMI_WAP_INPUT_DIALOG_CNF *DialogCnf);


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	AUI_wap_password_dialog_open

 $Description:	Prompts the MMI to open a password dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog, T_WAP_VIEW *View);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_password_dialog_closed

 $Description:	Provides the answer of a password dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				DialogCnf		- Dialog confirmation information
 
*******************************************************************************/

T_WAP_RES ATB_wap_password_dialog_closed(T_MMI_WAP_PASSWORD_DIALOG_CNF *DialogCnf);


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	AUI_wap_confirm_dialog_open

 $Description:	Prompts the MMI to open a confirmation dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_confirm_dialog_open(T_WAP_MMI_CONFIRM_DIALOG_REQ *Dialog, T_WAP_VIEW *View);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_confirm_dialog_closed

 $Description:	Provides the answer of a confirmation dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				DialogCnf		- Dialog confirmation information
 
*******************************************************************************/

T_WAP_RES ATB_wap_confirm_dialog_closed(T_MMI_WAP_CONFIRM_DIALOG_CNF *DialogCnf);


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	AUI_wap_info_dialog_open

 $Description:	Prompts the MMI to open an info dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				Dialog			- Dialog information
 
*******************************************************************************/

T_WAP_RES AUI_wap_info_dialog_open(T_WAP_MMI_INFO_DIALOG_REQ *Dialog, T_WAP_VIEW *View);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_info_dialog_closed

 $Description:	Provides the answer of an info dialog.
 				
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 				DialogCnf		- Dialog confirmation information
 
*******************************************************************************/

T_WAP_RES ATB_wap_info_dialog_closed(T_MMI_WAP_INFO_DIALOG_CNF *DialogCnf);


/*******************************************************************************

 $Function:    	ATB_wap_update_display_cnf

 $Description:	The WAP AUI will ask the ATB to finally display the card.
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 
*******************************************************************************/

T_WAP_RES ATB_wap_update_display_cnf();

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	AUI_wap_options_menu_open

 $Description:	The ATB will send to the AUI the contents of the menu list
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	contextType	- the context, to specify the first item in the menu
 
*******************************************************************************/

T_WAP_RES AUI_wap_options_menu_open(UBYTE contextType);


/*******************************************************************************

 $Function:    	AUI_wap_options_menu_select

 $Description:	The AUI will notify to the WAP.ATB the id of the selected item
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	
 
*******************************************************************************/

T_WAP_RES AUI_wap_options_menu_select();
#endif

/*******************************************************************************

 $Function:    	ATB_wap_options_menu_select

 $Description:	The AUI will notify to the WAP.ATB the id of the selected item
 
 $Returns:		WAP_OK if successful, WAP_FAIL if otherwise

 $Arguments:	View - the current view
 
*******************************************************************************/

T_WAP_RES ATB_wap_options_menu_select(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_add_element

 $Description:	Add a new element to the element chain
 
 $Returns:		Pointer to the element

 $Arguments:	SPR#1721 - SH - Modified parameters slightly
 				View - 	the current view
 				type - the type of element (text, fieldset, image)
 
*******************************************************************************/

T_WAP_ELEMENT * ATB_wap_buffer_add_element(T_WAP_VIEW *View, WAP_ELEMENT_TYPE type);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_display

 $Description:	Displays the card from the buffer
 
 $Returns:		

 $Arguments:	View - the current view
 
*******************************************************************************/

void ATB_wap_buffer_display(T_WAP_VIEW *View);

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_wap_buffer_image_display

 $Description:	Trims an image to fit into the specified space, then displays it
 
 $Returns:		

 $Arguments:	View - pointer to the appropriate view
 
*******************************************************************************/

void ATB_wap_buffer_image_display(T_WAP_MMI_SEND_IMAGE_IND *image);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_text_draw

 $Description:	Draws text
 
 $Returns:		

 $Arguments:	pX, pY			- position of text
 				pWidth, pHeight	- dimensions of text
 				text_length		- length of text
 				Text			- text itself
 				type			- type of text
 				invert			- TRUE if text is highlighted
 				format			- format of text
 				selected		- TRUE if option is selected
 				is_link			- TRUE if text is a link
 
*******************************************************************************/

void ATB_wap_buffer_text_draw(T_WAP_MMI_SEND_TEXT_IND *parameter);

//kyle 29 Jun, 2005 MMI-SPR-32462
static void ATB_wap_buffer_border_draw(T_WAP_MMI_DRAW_BORDER_IND *parameter);

/*******************************************************************************

 $Function:    	ATB_wap_buffer_table_draw

 $Description:	Draws a table, or a fieldset
 
 $Returns:		

 $Arguments:	pX, pY			- position of table
 				pWidth, pHeight	- dimensions of table
 				title_length	- length of title
 				Title			- title text
 				noOfCols		- number of columns (tables only)
 				noOfRows		- number of rows (tables only)
 				ColWidth		- list of column widths (tables only)
 				RowHeight		- list of row heights (tables only)
 
*******************************************************************************/

void ATB_wap_buffer_table_draw(T_WAP_MMI_SEND_TABLE_IND *parameter);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_line_draw

 $Description:	Draws a line, making sure it fits on-screen
 
 $Returns:		

 $Arguments:	x1,y1 - Coordinates of the start of the line
 				x2,y2 - Coordinates of the end of the line
 
*******************************************************************************/

void ATB_wap_buffer_line_draw(SHORT x1, SHORT y1, SHORT x2, SHORT y2);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_onscreen

 $Description:	Returns TRUE if the point supplied is on-screen
 
 $Returns:		

 $Arguments:	x,y - coordinates of the point
 				deltaX, deltaY - returns offset from screen
 
*******************************************************************************/

static BOOL ATB_wap_buffer_onscreen(SHORT x, SHORT y, SHORT *deltaX, SHORT *deltaY);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_clear

 $Description:	Clears the element buffer
 
 $Returns:		

 $Arguments:	View - the current view
 
*******************************************************************************/
#endif /* #ifdef FF_GPF_TCPIP */
void ATB_wap_buffer_clear(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_buffer_identify_element

 $Description:	Identifies which element is selected (based on the invert property) and
 				returns an appropriate type.
 
 $Returns:		The type of the element that is selected, or NULL if none

 $Arguments:	View	- pointer to the view
 
*******************************************************************************/

UBYTE ATB_wap_buffer_identify_element(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_profile_create

 $Description:	Allocates memory for profile information in RAM
 
 $Returns:		Pointer to the newly created profile

 $Arguments:	
 
*******************************************************************************/

T_WAP_PROFILE* ATB_wap_profile_create();


/*******************************************************************************

 $Function:    	ATB_wap_profile_destroy

 $Description:	Destroys a profile
 
 $Returns:		

 $Arguments:	Profile		- pointer to the profile to destroy
 
*******************************************************************************/

void ATB_wap_profile_destroy(T_WAP_PROFILE *Profile);


/*******************************************************************************

 $Function:    	ATB_wap_profile_read

 $Description:	Reads in the current profile (specified by a number in ProfileId)
 				from the flash.
 
 $Returns:		

 $Arguments:	View		- Pointer to the current view
 				ProfileId	- the id of the profile to read from the flash
 
*******************************************************************************/

T_WAP_RES ATB_wap_profile_read(T_WAP_VIEW *View, UBYTE ProfileId);


/*******************************************************************************

 $Function:    	ATB_wap_profile_names_read

 $Description:	Reads in the names of all profiles stored in flash
 
 $Returns:		

 $Arguments:	Profile		- Pointer to the current profile
 
*******************************************************************************/

T_WAP_RES ATB_wap_profile_names_read(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_profiles_save

 $Description:	Store the current updated profile in flash
 
 $Returns:		

 $Arguments:	Profile		- Pointer to the current profile
 
*******************************************************************************/

T_WAP_RES ATB_wap_profile_save(T_WAP_VIEW *View);

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_wap_profile_default_create

 $Description:	Creates a default profile in the flash if one isn't already there
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

T_WAP_RES ATB_wap_profile_default_create();

//TISHMMS Project
T_WAP_RES ATB_mms_profile_default_create();



/*******************************************************************************

 $Function:    	ATB_wap_profile_send

 $Description:	Reads the current profile and sends it to WAP task.
 
 $Returns:		

 $Arguments:	Profile 	- Pointer to the current selected profile.
 
*******************************************************************************/

#else /* #ifdef FF_GPF_TCPIP */
T_WAP_RES ATB_wap_profile_delete(T_WAP_VIEW *View, UBYTE ProfileId); /* SPR#2324 - SH - added */
T_WAP_RES ATB_wap_profile_default_create(UBYTE only_reset_profiles); /* SPR#2324 - SH - modified */
#endif
void ATB_wap_profile_default(UBYTE ProfileId); /* SPR#2324 - SH - added */
void ATB_wap_profile_send(T_WAP_VIEW *View);

/*******************************************************************************

 $Function:    	ATB_wap_secondary_IP

 $Description:	SPR#1688 - SH - Added this function
 				If first IP address fails, try using secondary one.
 
 $Returns:		None.

 $Arguments:	View  - the current view
 
*******************************************************************************/

void ATB_wap_secondary_IP(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	ATB_wap_entry_list_create

 $Description:	Creates an entries list
 				SPR#1816 - SH - Added unicode parameter
 
 $Returns:		Pointer to entry list

 $Arguments:	type		- type of list
 				max_entries	- maximum number of entries in list
 				entry_size	- size of entries in characters
 				unicode		- TRUE if entries are unicode
 
*******************************************************************************/

T_WAP_LIST * ATB_wap_entry_list_create(WAP_LIST_TYPE type, UBYTE max_entries, UBYTE entry_size, BOOL unicode);


/*******************************************************************************

 $Function:    	ATB_wap_entry_list_destroy

 $Description:	Destroys an entries list
 
 $Returns:		

 $Arguments:	EntryList	- pointer to entry list data
 
*******************************************************************************/

T_WAP_RES ATB_wap_entry_list_destroy(T_WAP_LIST *EntryList);


/*******************************************************************************

 $Function:    	ATB_wap_entry_add

 $Description:	Adds an entry in the bookmarks or history list
 
 $Returns:		

 $Arguments:	Entrylist	- Pointer to entries table
 				Entry		- Entry to add
 
*******************************************************************************/

T_WAP_RES ATB_wap_entry_add(T_WAP_LIST *EntryList, char *Entry);

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_wap_entry_change

 $Description:	Changes an entry in an entry list, destroying the old entry and
 				creating a new one.
 
 $Returns:		

 $Arguments:	type			- Type of entry list
 				Entrylist 		- Pointer to entries table
 				Entry			- New entry text
 				entryIndex		- Number of entry to change
 
*******************************************************************************/

T_WAP_RES ATB_wap_entry_change(WAP_LIST_TYPE type, T_WAP_LIST *EntryList, char *Entry, UBYTE entryIndex);


/*******************************************************************************

 $Function:    	ATB_wap_entry_insert

 $Description:	Insert an entry into an entry list, shifting all subsequent entries up one.
 				If the maximum limit of the entry list is reached, the last entry is
 				deleted.
 
 $Returns:		

 $Arguments:	type			- Type of entry list
 				Entrylist 		- Pointer to entries table
 				Entry			- Entry to insert
 				entryIndex 		- Position at which to insert the new entry
 
*******************************************************************************/

T_WAP_RES ATB_wap_entry_insert(WAP_LIST_TYPE type, T_WAP_LIST *EntryList, char *Entry, UBYTE entryIndex);


/*******************************************************************************

 $Function:    	ATB_wap_entry_remove

 $Description:	Removes an entry from the bookmarks or history list
 
 $Returns:		

 $Arguments:	Entrylist 		- Pointer to entries table
 				entryIndex 		- Number of the entry to delete
 
*******************************************************************************/

#else /* #ifdef FF_GPF_TCPIP */
T_WAP_RES ATB_wap_entry_change(T_WAP_LIST *EntryList, char *Entry, UBYTE entryIndex);
T_WAP_RES ATB_wap_entry_insert(T_WAP_LIST *EntryList, char *Entry, UBYTE entryIndex);
#endif

T_WAP_RES ATB_wap_entry_remove(T_WAP_LIST *EntryList, UBYTE entryIndex);


/*******************************************************************************

 $Function:    	ATB_wap_entry_remove_all

 $Description:	Removes all entries from a Entry List
 
 $Returns:		

 $Arguments:	EntryList 	- Pointer to bookmarks table
 				string_size	- Size of string for each entry
 
*******************************************************************************/

T_WAP_RES ATB_wap_entry_remove_all(T_WAP_LIST *EntryList);


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_wap_renumber_history

 $Description:	Renumber history list, changing prefixes to all entries
 
 $Returns:		

 $Arguments:	History - pointer to history list	
 
*******************************************************************************/

int ATB_wap_renumber_history(T_WAP_LIST *History);


/*******************************************************************************

 $Function:    	AUI_wap_memory_alloc

 $Description:	Requests memory allocation through the AUI.
 
 $Returns:		address of the allocated block.

 $Arguments:	size - amount of memory to allocate.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32
U8* AUI_wap_memory_alloc(U32 size);


/*******************************************************************************

 $Function:    	AUI_wap_memory_free.

 $Description:	Requests AUI to free memory.
 
 $Returns:		error code.

 $Arguments:	address - address of the memory to be freed.
	
				size    - amount of memory to free.
 
*******************************************************************************/
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32
U8 AUI_wap_memory_free(U8* address,U32 size);


/*******************************************************************************

 $Function:    	ATB_wap_card_show

 $Description:	Called by the WAP.ATB to show the and/or create the card window.
 
 $Returns:		

 $Arguments:	View			- The current view

 
*******************************************************************************/

void AUI_wap_card_show_req(T_WAP_VIEW *View);


/*******************************************************************************

 $Function:    	AUI_wap_status_notify

 $Description:	Called by the WAP.ATB when a status flag has changed
 				SPR#1574 - SH - Removed parameter
 
 $Returns:		

 $Arguments:	View			- The current view
				status			- New value of status
 
*******************************************************************************/


void AUI_wap_status_notify(T_WAP_VIEW *View, USHORT status);

#else /* #ifdef FF_GPF_TCPIP */
T_WAP_RES ATB_wap_renumber_history(T_WAP_LIST *History);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_status_change

 $Description:	Called to change a status flag
 				SPR#1574 - SH - Removed parameter
 
 $Returns:		

 $Arguments:	View			- The current view
				status			- New value of status
 
*******************************************************************************/


void ATB_wap_status_change(T_WAP_VIEW *View, USHORT status);

/*******************************************************************************

 $Function:    	ATB_wap_status_get

 $Description:	
 
 $Returns:		The status (TRUE/FALSE) of a particular flag

 $Arguments:	View			- The current view
				flag			- parameter which status has changed
 
*******************************************************************************/


BOOL ATB_wap_status_get(T_WAP_VIEW *View, USHORT status);

#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	ATB_uc_text_len

 $Description:	SPR#1816 - SH - Added
 				Returns length of unicode string
 
 $Returns:		Length of string

 $Arguments:	str		- the string
 
*******************************************************************************/

USHORT ATB_uc_text_len(USHORT *str);
#endif

/*******************************************************************************

 $Function:    	ATB_uc_text_copy

 $Description:	SPR#1816 - SH - Added
 				Copies src into dest
 
 $Returns:		Length of string copied

 $Arguments:	dest		- the destination string
 				src			- the source string
				destlen		- the maximum string length to copy
 
*******************************************************************************/

USHORT ATB_uc_text_copy(USHORT *dst, USHORT *src, USHORT destlen);


/*******************************************************************************

 $Function:    	ATB_uc_text_width

 $Description:	SPR#1816 - SH - Added
 				Returns width of string in pixels
 
 $Returns:		

 $Arguments:	str			- the string
				length		- the length of string to measure
 
*******************************************************************************/

USHORT ATB_uc_text_width(USHORT *str, USHORT length);


  // Apr 28 2005  REF:  MMI-SPR-30400 x0012849
  // Thos function is called to see that text is not displayed on the scroll bar space
/*******************************************************************************

 $Function:    	ATB_uc_text_cut 
 $Description:	  To see that the displayed string wont appear on the scroll bar space.
 
 $Returns:		The number of characters that can be displayed

 $Arguments:	str			- the string
 				length		- the original length
				width		- the maximum permitted width in pixels of the string
 
*******************************************************************************/

USHORT ATB_uc_text_cut(USHORT *str, USHORT length, SHORT width);
/*******************************************************************************

 $Function:    	ATB_uc_text_crop
 
 $Description:	SPR#1816 - SH - Added
 				Crops text if necessary to fit the supplied width
 
 $Returns:		The number of characters that can be displayed

 $Arguments:	str			- the string
 				length		- the original length
				width		- the maximum permitted width in pixels of the string
 
*******************************************************************************/

USHORT ATB_uc_text_crop(USHORT *str, USHORT length, SHORT width);


/*******************************************************************************

 $Function:    	ATB_text_convert

 $Description:	SPR#1816 - SH - Added
 				Swap the upper and lower bytes of each unicode character in a string
 
 $Returns:		the string

 $Arguments:	str			- the source/destination string
				strlen		- the length of the string
 
*******************************************************************************/

USHORT* ATB_uc_text_convert (USHORT *str, USHORT strlen);


/*******************************************************************************

 $Function:    	ATB_uc_to_char

 $Description:	SPR#1816 - SH - Added
 				Converts a MMI-converted unicode string to a char string
 
 $Returns:		Length of the copy

 $Arguments:	dst			- the destination string
				src			- the source string
				srclen		- the length of the source string
 
*******************************************************************************/

USHORT ATB_uc_to_char(char *dst, USHORT *src, USHORT srclen);


/*******************************************************************************

 $Function:    	ATB_char_to_uc

 $Description:	SPR#1816 - SH - Added
 				Converts a char string to a MMI-converted unicode string
 
 $Returns:		the length of the destination string

 $Arguments:	dst			- the destination string
				src			- the source string
 
*******************************************************************************/

USHORT ATB_char_to_uc (USHORT *dst, char *src);


/*******************************************************************************

 $Function:    	ATB_uc_text_copy

 $Description:	Compares unicode strings
 
 $Returns:		zero if strings match, non zero otherwise

 $Arguments:	dst			- the destination string
 				src			- the source string
				len			- Number of UCS2 characters to compare

				xreddymn Dec-10-2004 for MMI-SPR-26159
*******************************************************************************/

USHORT ATB_uc_text_compare(USHORT *dst, USHORT *src, USHORT len);

/*******************************************************************************

 $Function:    	ATB_conv_str_to_IP

 $Description:	Converts a string IP address to a long type IP address
 
 $Returns:		

 $Arguments:	str			- the string
 				len			- the original length
				ip			- pointer to where the result will be placed
 
*******************************************************************************/

GLOBAL const void ATB_conv_str_to_IP(const char* str, USHORT len, ULONG* ip);

#ifdef FF_GPF_TCPIP
void ATB_wap_data_call_connect(T_WAP_VIEW *View); /* SPR#2086 */
void ATB_data_call_connected(T_WAP_VIEW *View); /* SPR#2086 */
void ATB_wap_data_call_disconnected(T_WAP_VIEW *View);	/* SPR#2086 */

#else
void ATB_data_call_connected(void);
#endif
/*******************************************************************************

 $Function:    	ATB_wap_cache_prepare

 $Description:	SPR#1824 - SH - Added
 				WAP_CACHE_PREPARE
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/


void ATB_wap_cache_prepare(void);

/*******************************************************************************

 $Function:    	ATB_wap_start_done

 $Description:	Confirms that WAP_START has completed
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void ATB_wap_start_done(void);
#ifdef FF_GPF_TCPIP
void AUI_wap_start_done(void);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_new_view_done

 $Description:	Confirms that WAP_NEW_VIEW has completed
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void ATB_wap_new_view_done(void);
#ifdef FF_GPF_TCPIP
void AUI_wap_new_view_done(void);
#endif


/*******************************************************************************

 $Function:    	ATB_wap_terminate_done

 $Description:	Confirms that WAP_TERMINATE has completed
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void ATB_wap_terminate_done(void);
#ifdef FF_GPF_TCPIP
void AUI_wap_terminate_done(void);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_close_view_done

 $Description:	Confirms that WAP_CLOSE_VIEW has completed
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void ATB_wap_close_view_done(void);
#ifdef FF_GPF_TCPIP
void AUI_wap_close_view_done(void);
#endif


/*******************************************************************************

 $Function:    	ATB_wap_cache_prepare_done

 $Description:	SPR#1824 - SH - Added
 				Confirms that WAP_CACHE_PREPARE has completed
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void ATB_wap_cache_prepare_done(void);
#ifdef FF_GPF_TCPIP
void AUI_wap_cache_prepare_done(void);
#endif

/*******************************************************************************

 $Function:    	ATB_wap_disconnect

 $Description:	SPR#1189 - SH - Added this function
 				Informs WAP browser that a disconnection has occurred
 
 $Returns:		

 $Arguments:	View - the current View
 
*******************************************************************************/

void ATB_wap_disconnect(T_WAP_VIEW *View);

#ifdef FF_GPF_TCPIP
/* SPR#2086 - SH - Prototypes for SAR functions */

T_WAP_RES ATB_wap_content_get(
	UBYTE urlID,
	char *Url,
	BOOL reload,
	char *acceptHeader);

void ATB_wap_content(
	UBYTE urlID,
	char *Data,
	ULONG data_length,
	BOOL moreData,
	char *ContentType,
	ULONG contentType_length,
	ULONG totalSize,
	SHORT errorNo);
	
void AUI_wap_content(
	UBYTE urlID,
	char *Data,
	ULONG data_length,
	BOOL moreData,
	char *ContentType,
	ULONG contentType_length,
	ULONG totalSize);

T_WAP_RES ATB_wap_content_post(
	UBYTE urlID,
	char *Url,
	BOOL reload,
	char *acceptHeader,
	char *Data,
	ULONG data_length,
	BOOL moreData,
	char *ContentType,
	UBYTE sendMode,
	char *ContentDisp,
	ULONG totalSize);

T_WAP_RES ATB_wap_content_post_more(
	UBYTE urlID,
	char *Data,
	ULONG data_length,
	BOOL moreData);
	
void ATB_wap_content_cancel(UBYTE urlID);
void ATB_wap_change_view(UBYTE object_id);
void AUI_wap_view_changed(T_WAP_VIEW *View);


/* SPR#2086 - SH - PUSH functions */
void ATB_wap_push_load_SI(T_WAP_VIEW *View, SHORT id);
void ATB_wap_push_delete_SI(SHORT id, UBYTE selection);
void ATB_wap_push_get_SI_info(SHORT id, UBYTE selection);
void ATB_wap_push_save_to_flash(void);

void ATB_wap_push_SI_new(
	SHORT id,
	ULONG created,
	ULONG expires,
	USHORT *Message,
	ULONG message_length,
	BOOL expired,
	char *Url,
	ULONG url_length,
	UBYTE priority,
	char *InitURL,
	ULONG initURL_length,
	UBYTE applicationType,
	UBYTE newChannelId
	);
void ATB_wap_push_SI_info(
	SHORT id,
	UBYTE status,
	ULONG created,
	ULONG expires,
	USHORT *Message,
	ULONG message_length,
	BOOL expired,
	char *Url,
	ULONG url_length,
	UBYTE priority,
	char *InitURL,
	ULONG initURL_length
	);

void ATB_wap_push_SMS_received(
	char *smsc,
	UBYTE tosca,
	char *number,
	UBYTE toa,
	char *Udh,
	ULONG udh_length,
	char *Data,
	ULONG data_length);
	
void ATB_wap_push_SMS_send(
	char *Smsc,
	ULONG smsc_length,
	char *Destination,
	ULONG destination_length,
	char *Data,
	ULONG data_length);
	
void ATB_wap_push_SMS_sent(void);
void ATB_wap_push_SMS_error(UBYTE error);

void AUI_wap_push_show(
	USHORT *Text,
	USHORT text_length,
	SHORT identifier,
	char *Url,
	USHORT url_length);
	
void AUI_wap_push_info(
	USHORT *Text,
	USHORT text_length,
	SHORT id,
	char *Url,
	USHORT url_length,
	UBYTE status,
	ULONG created,
	BOOL expired,
	UBYTE priority);

// xreddymn Mar-16-2005 MMI-SPR-29767 - modified SL message handling in MMI
void ATB_wap_push_SL_new(
	SHORT id,
	char *Url,
	ULONG url_length,
	UBYTE priority,
	char *InitURL,
	ULONG initURL_length,
	UBYTE applicationType,
	UBYTE newChannelId
	);

void AUI_wap_push_load_SL(SHORT identifier, char *Url, USHORT url_length);
// xreddymn Mar-25-2005 MMI-SPR-26144: changes to display MMS send progress

void AUI_wap_net_send_ind(void);

UBYTE ATB_wap_profile_setting(UBYTE setting);
void ATB_wap_profile_setting_change(UBYTE setting, UBYTE value);
void ATB_wap_profile_add(T_WAP_PROFILE *p);

#else /* #ifdef FF_GPF_TCPIP */

/* INTERFACE WITH AUI */
// Dec 22, 2004 REF: CRR MFW-SPR-27847 xnkulkar
// Description: MFW memory size variable changed from U16 -> U32
// Solution: The use of variable U16 has been replaced with U32

T_WAP_RES AUI_wap_input_dialog_open(T_WAP_MMI_INPUT_DIALOG_REQ *Dialog);
T_WAP_RES AUI_wap_password_dialog_open(T_WAP_MMI_PASSWORD_DIALOG_REQ *Dialog);
T_WAP_RES AUI_wap_confirm_dialog_open(T_WAP_MMI_CONFIRM_DIALOG_REQ *Dialog);
T_WAP_RES AUI_wap_info_dialog_open(T_WAP_MMI_INFO_DIALOG_REQ *Dialog);
UBYTE* AUI_wap_memory_alloc(U32 size);
void AUI_wap_memory_free(UBYTE* address, U32 size);


void AUI_wap_card_show_req(T_WAP_VIEW *View);
void AUI_wap_status_notify(T_WAP_VIEW *View, USHORT status);
void AUI_wap_change_soft_key(T_WAP_VIEW *View, USHORT *Label, USHORT length, USHORT keyId);

#endif /* !#ifdef FF_GPF_TCPIP */
USHORT AUI_wap_stringID(USHORT *dest, USHORT destlen, USHORT stringID);

#ifdef CO_UDP_IP
void AUI_wap_start_done(void);
void AUI_wap_new_view_done(void);
void AUI_wap_terminate_done(void);
void AUI_wap_close_view_done(void);
void AUI_wap_cache_prepare_done(void);
void AUI_wap_end_call(SHORT cId);

void AUI_error_dialog(T_WAP_VIEW *View, SHORT errorCode);
#endif
 
/*******************************************************************************

 $Function:    	writeerrorFFS/writeflagFFS

 $Description:	SH - These functions are provided for debugging purposes
 
 $Returns:		

 $Arguments:	
*******************************************************************************/

void writeerrorFFS(SHORT error);
void writeflagFFS(UBYTE flag);

// xreddymn Jun-28-2005 MMI-SPR-32467
void ATB_animated_GIF_clear(void);

