/*******************************************************************************

					CONDAT (UK)

********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	                                                      
 $Project code:	                                                           
 $Module:		
 $File:		    ATBWapACI.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Function prototypes for ATB->WAP interface.
    
                        
********************************************************************************

 $History: ATBWapACI.h

    xreddymn Jun-21-2005 MMI-SPR-30291: Send one message for the entire profile,
    instead of sending one parameter at a time, to the WAP adapter

    xrashmic 29 Jun, 2005 MMI-SPR-32462
    Patch given by Kyle for display of table border
       
 
    May-14-2005 MMI-SPR-30834 - xreddymn: added send memory free indication
    					                from MMI to WAP

    Mar-25-2005 MMI-SPR-26144 - xreddymn: Added changes to display
    MMS send progress

    15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/
//#define CO_UDP_IP temp till xml file ready

/*******************************************************************************

 $Function:    	M_M_MMI_WAP_READY_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_READY_IND(T_MMI_WAP_READY_IND *parameter);


/*******************************************************************************

 $Function:    	M_M_MMI_WAP_START_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

#ifdef CO_UDP_IP
	void M_MMI_WAP_START_IND(T_MMI_WAP_START_IND *parameter);
#else
	void M_MMI_WAP_START_IND(T_MMI_WAP_START_USER_AGENT_REQ *parameter);
#endif



/*******************************************************************************

 $Function:    	M_MMI_WAP_NEW_VIEW_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_NEW_VIEW_IND(T_MMI_WAP_NEW_VIEW_IND *parameter);


/*******************************************************************************

 $Function:    	M_MMI_WAP_TERMINATE_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_TERMINATE_IND(T_MMI_WAP_TERMINATE_IND *parameter);


/*******************************************************************************

 $Function:    	M_MMI_WAP_CLOSE_VIEW_IND
 
 $Description:	Close the specified view.
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CLOSE_VIEW_IND(T_MMI_WAP_CLOSE_VIEW_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONFIGURE_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CONFIGURE_IND(T_MMI_WAP_CONFIGURE_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONNECTION_CONFIGURE_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CONNECTION_CONFIGURE_IND(T_MMI_WAP_CONNECTION_CONFIGURE_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_DOWNLOAD_URL_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_DOWNLOAD_URL_IND(T_MMI_WAP_DOWNLOAD_URL_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_BROWSE_CONTROL_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_BROWSE_CONTROL_IND(T_MMI_WAP_BROWSE_CONTROL_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_KEY_SELECTED_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_KEY_SELECTED_IND(T_MMI_WAP_KEY_SELECTED_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_INPUT_DIALOG_CNF
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_INPUT_DIALOG_CNF(T_MMI_WAP_INPUT_DIALOG_CNF *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_PASSWORD_DIALOG_CNF
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_PASSWORD_DIALOG_CNF(T_MMI_WAP_PASSWORD_DIALOG_CNF *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONFIRM_DIALOG_CNF
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CONFIRM_DIALOG_CNF(T_MMI_WAP_CONFIRM_DIALOG_CNF *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_INFO_DIALOG_CNF
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_INFO_DIALOG_CNF(T_MMI_WAP_INFO_DIALOG_CNF *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_DRAW_CARD_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
******************************************************************************/

void M_MMI_WAP_DRAW_CARD_REQ(T_MMI_WAP_DRAW_CARD_REQ *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONNECT_CNF
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CONNECT_CNF(T_MMI_WAP_CONNECT_CNF *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_DISCONNECT_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_DISCONNECT_IND(T_MMI_WAP_DISCONNECT_IND *parameter);


/*******************************************************************************


 $Function:    	M_MMI_WAP_CACHE_PREPARE_IND
 
 $Description:	SPR#1824 - SH - Added this function
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_MMI_WAP_CACHE_PREPARE_IND(T_MMI_WAP_CACHE_PREPARE_IND *parameter);

#ifdef FF_GPF_TCPIP
 /* SPR#2086 - SH - Prototypes for SAR */

void M_MMI_WAP_CONFIG_CNF(T_MMI_WAP_CONFIG_CNF *parameter);
void M_MMI_WAP_CONTENT_REQ(T_MMI_WAP_CONTENT_REQ *parameter);
void M_MMI_WAP_CONTENT_POST_REQ(T_MMI_WAP_CONTENT_POST_REQ *parameter);
void M_MMI_WAP_CONTENT_POST_MORE_REQ(T_MMI_WAP_CONTENT_POST_MORE_REQ *parameter);
void M_MMI_WAP_CONTENT_CNF(T_MMI_WAP_CONTENT_CNF *parameter);
void M_MMI_WAP_CONTENT_CANCEL_IND(T_MMI_WAP_CONTENT_CANCEL_IND *parameter);

/* SPR#2086 - SH - Prototypes for PUSH */


void M_MMI_WAP_PUSH_LOAD_SI_IND(T_MMI_WAP_PUSH_LOAD_SI_IND *parameter);
void M_MMI_WAP_PUSH_DELETE_SI_IND(T_MMI_WAP_PUSH_DELETE_SI_IND *parameter);
void M_MMI_WAP_PUSH_GET_SI_INFO_REQ(T_MMI_WAP_PUSH_GET_SI_INFO_REQ *parameter);
void M_MMI_WAP_PUSH_LOAD_SL_IND(T_MMI_WAP_PUSH_LOAD_SL_IND *parameter);
void M_MMI_WAP_PUSH_DELETE_SL_IND(T_MMI_WAP_PUSH_DELETE_SL_IND *parameter);
void M_MMI_WAP_PUSH_GET_SL_INFO_REQ(T_MMI_WAP_PUSH_GET_SL_INFO_REQ *parameter);
void M_MMI_WAP_PUSH_CONNECTION_CNF(T_MMI_WAP_PUSH_CONNECTION_CNF *parameter);
void M_MMI_WAP_PUSH_CHANGE_STATUS_IND(T_MMI_WAP_PUSH_CHANGE_STATUS_IND *parameter);
void M_MMI_WAP_PUSH_REMOVE_MESSAGE_IND(T_MMI_WAP_PUSH_REMOVE_MESSAGE_IND *parameter);
void M_MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ(T_MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ *parameter);
void M_MMI_WAP_PUSH_SAVE_TO_FLASH_IND(T_MMI_WAP_PUSH_SAVE_TO_FLASH_IND *parameter);
void M_MMI_WAP_PUSH_SMS_RECEIVED_IND(T_MMI_WAP_PUSH_SMS_RECEIVED_IND *parameter);
void M_MMI_WAP_PUSH_SMS_SENT_IND(T_MMI_WAP_PUSH_SMS_SENT_IND *parameter);
void M_MMI_WAP_PUSH_SMS_ERROR_IND(T_MMI_WAP_PUSH_SMS_ERROR_IND *parameter);
#endif

/*******************************************************************************


 $Function:    	M_WAP_MMI_DISCONNECTED_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_DISCONNECTED_IND(T_WAP_MMI_DISCONNECTED_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_CONTROL_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_CONTROL_IND(T_WAP_MMI_CONTROL_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_NEW_KEY_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_NEW_KEY_IND(T_WAP_MMI_NEW_KEY_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_INPUT_DIALOG_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_INPUT_DIALOG_REQ(T_WAP_MMI_INPUT_DIALOG_REQ *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_PASSWORD_DIALOG_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_PASSWORD_DIALOG_REQ(T_WAP_MMI_PASSWORD_DIALOG_REQ *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_CONFIRM_DIALOG_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_CONFIRM_DIALOG_REQ(T_WAP_MMI_CONFIRM_DIALOG_REQ *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_INFO_DIALOG_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_INFO_DIALOG_REQ(T_WAP_MMI_INFO_DIALOG_REQ *parameter);

	
/*******************************************************************************


 $Function:    	M_WAP_MMI_NEW_CARD_IND
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_NEW_CARD_IND(T_WAP_MMI_NEW_CARD_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_DRAW_CARD_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_DRAW_CARD_IND(T_WAP_MMI_DRAW_CARD_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_CLEAR_CARD_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_CLEAR_CARD_IND(T_WAP_MMI_CLEAR_CARD_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_SEND_TEXT_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_SEND_TEXT_IND(T_WAP_MMI_SEND_TEXT_IND *parameter);

#ifdef FF_GPF_TCPIP
/*******************************************************************************


 $Function:    	M_WAP_MMI_RADIO_BUTTON_IND


 $Description:	

 $Returns:		

 $Arguments:	

*******************************************************************************/

void M_WAP_MMI_RADIO_BUTTON_IND(T_WAP_MMI_RADIO_BUTTON_IND *parameter);

/*******************************************************************************


 $Function:    	M_WAP_MMI_DRAW_BORDER_IND
	            //kyle 29 Jun, 2005 MMI-SPR-32462

 $Description:	

 $Returns:		

 $Arguments:	

*******************************************************************************/

void M_WAP_MMI_DRAW_BORDER_IND(T_WAP_MMI_DRAW_BORDER_IND *parameter);

#endif

/*******************************************************************************

 $Function:    	M_WAP_MMI_SEND_IMAGE_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_SEND_IMAGE_IND();


/*******************************************************************************


 $Function:    	M_WAP_MMI_CARD_DRAW_COMPLETED_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_CARD_DRAW_COMPLETED_IND(T_WAP_MMI_CARD_DRAW_COMPLETED_IND *parameter);
 

/*******************************************************************************


 $Function:    	M_WAP_MMI_SEND_TABLE_IND

 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_SEND_TABLE_IND(T_WAP_MMI_SEND_TABLE_IND *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_CONNECT_REQ
 
 $Description:	
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_CONNECT_REQ(T_WAP_MMI_CONNECT_REQ *parameter);


/*******************************************************************************


 $Function:    	M_WAP_MMI_READY_CNF
 
 $Description:	Comfirm that WAP has completed the operation.
 
 $Returns:		

 $Arguments:	
 
*******************************************************************************/

void M_WAP_MMI_READY_CNF(T_WAP_MMI_READY_CNF *parameter);


/*******************************************************************************

 $Function:    	disconnect_wap_call
 
 $Description:	Disconnect GPRS WAP call in progress.

 $Returns:		SPR#1982 - SH
 				TRUE if connection is disconnected, FALSE if disconnection in progress

 $Arguments:	access_type - WAP_GPRS_DATA or WAP_CS_DATA
 
*******************************************************************************/

UBYTE disconnect_wap_call(UBYTE access_type);


void connect_gprs(UBYTE object_id);

#ifdef FF_GPF_TCPIP
void connect(UBYTE object_id);
/* SPR#2086 - SH - Prototypes for SAR */

void M_WAP_MMI_CONFIG_REQ(T_WAP_MMI_CONFIG_REQ *parameter);
void M_WAP_MMI_CONTENT_IND(T_WAP_MMI_CONTENT_IND *parameter);
void M_WAP_MMI_CONTENT_POST_CNF(T_WAP_MMI_CONTENT_POST_CNF *parameter);

/* SPR#2086 - SH - Prototypes for OTA */
void M_WAP_MMI_BROWSER_SET_CSD_IND(T_WAP_MMI_BROWSER_SET_CSD_IND *parameter);
void M_WAP_MMI_BROWSER_SET_GPRS_IND(T_WAP_MMI_BROWSER_SET_GPRS_IND *parameter);
void M_WAP_MMI_MMS_SET_CSD_IND(T_WAP_MMI_MMS_SET_CSD_IND *parameter);
void M_WAP_MMI_MMS_SET_GPRS_IND(T_WAP_MMI_MMS_SET_GPRS_IND *parameter);

void M_WAP_MMI_BROWSER_BOOKMARKS_IND(T_WAP_MMI_BROWSER_BOOKMARKS_IND *parameter);
void M_WAP_MMI_SYNCML_GENERAL_SET_IND(T_WAP_MMI_SYNCML_GENERAL_SET_IND *parameter);
void M_WAP_MMI_SYNCML_CONTENT_SET_IND(T_WAP_MMI_SYNCML_CONTENT_SET_IND *parameter);
/* SPR#2086 - SH - Prototypes for PUSH */

void M_WAP_MMI_PUSH_NEW_SI_IND(T_WAP_MMI_PUSH_NEW_SI_IND *parameter);
void M_WAP_MMI_PUSH_SI_INFO_IND(T_WAP_MMI_PUSH_SI_INFO_IND *parameter);
void M_WAP_MMI_PUSH_NEW_SL_IND(T_WAP_MMI_PUSH_NEW_SL_IND *parameter);
void M_WAP_MMI_PUSH_SL_INFO_IND(T_WAP_MMI_PUSH_SL_INFO_IND *parameter);
void M_WAP_MMI_PUSH_MESSAGE_CHANGE_IND(T_WAP_MMI_PUSH_MESSAGE_CHANGE_IND *parameter);
void M_WAP_MMI_PUSH_REPOSITORY_FULL_IND(T_WAP_MMI_PUSH_REPOSITORY_FULL_IND *parameter);
void M_WAP_MMI_PUSH_CONNECTION_REQ(T_WAP_MMI_PUSH_CONNECTION_REQ *parameter);
void M_WAP_MMI_PUSH_UNLOADED_MSG_CNF(T_WAP_MMI_PUSH_UNLOADED_MSG_CNF *parameter);
void M_WAP_MMI_PUSH_SMS_SEND_IND(T_WAP_MMI_PUSH_SMS_SEND_IND *parameter);

// xreddymn Mar-25-2005 MMI-SPR-26144: Added to display MMS send progress
void M_WAP_MMI_NET_SEND_IND(T_WAP_MMI_NET_SEND_IND *parameter);

// xreddymn MMI-SPR-30834 May-14-2005: Called by MMI to free data in WAP memory
void M_MMI_WAP_FREE_MEM_IND(T_MMI_WAP_MEM_FREE_IND *parameter);

// xreddymn Jun-21-2005 MMI-SPR-30291: Sends profile data from MMI to WAP adapter
void M_MMI_WAP_SEND_PROFILE_IND(T_MMI_WAP_SEND_PROFILE_IND *parameter);

#endif
