/*******************************************************************************

					CONDAT (UK)

********************************************************************************

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.

********************************************************************************

 $Project name:
 $Project code:
 $Module:
 $File:		    ATBWapACI.c
 $Revision:

 $Author:		Condat(UK)
 $Date:

********************************************************************************

 Description:
 	Provides an interface between the ATB and the ACI.


********************************************************************************

 $History: ATBWapACI.c

    x0035544Nov 29, 2005 REF: MMI-SPR-33833(OMAPS00055207) 
    MMI making Riviera calls without using proper header files. So added appropriate header files.
    
   xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
   Displaying of error message when image decoding fails
   
    xrashmic 30 Aug, 2005 MMI-SPR-34024(OMAPS00048918) mem leak fix
    Freeing ImageReq data in WAP memory only for plugin images.

	Nov 02, 2005    DR OMAPS00052132   xdeepadh
	Bug:Not able to access the SMS inbox and also not able to send SMS in Locosto Lite build
	Fix: The ATI Enums usage has been put under the FF_ATI flag.

    xrashmic 17 Aug, 2005 MMI-SPR-31364
    When it is detected that a very large page is being opened, the wap adapter sends a message.
    We need to exit wap and display a error dialog as we have memory constraints.
    
    xreddymn Jun-29-2005 MMI-ENH-32467:
    Handling of animated GIF images

    July 18 2005  REF:  MMI-SPR-32012  x0012849	
    To change the functionality of RSK , when there is no page to go back.
 
    xrashmic 29 Jun, 2005 MMI-SPR-32462
    Patch given by Kyle for display of table border
       
    xreddymn Jun-21-2005 MMI-SPR-30291: Send one message for the entire profile,
    instead of sending one parameter at a time, to the WAP adapter

    xreddymn May-15-2005 MMI-SPR-30962: Added changes to maintain WAP busy state
    during MMS transactions.

    xreddymn May-14-2005 MMI-SPR-30834: added send memory free indication
    from MMI to WAP

    xrashmic 12 May, 2005 MMI-SPR-30834
    For input text box, adding of [] is moved from wap adapter to bmi

    xreddymn Mar-22-2005 MMI-SPR-29767
    Modified behaviour of SL push message handling in MMI

    xreddymn Mar-11-2005 MMI-SPR-29510
    Enabled listing of SL WAP push messages

    xreddymn Mar-05-2005 MMI-SPR-26144
    Disabled dialog boxes that affect MMS send display

       xrashmic 08 Feb, 2005 MMI-SPR-27853
       Error handling in sending MMS and also displaying the progress value
       
    xreddymn Mar-11-2005 MMI-SPR-29510
    Enabled listing of SL WAP push messages

    Jan-24-2005 MMI-SPR-28135 - xreddymn: WAP_OTA settings saved in WAP profiles

   	xrashmic 21 Jan, 2005 MMI-SPR-28223
	Saving the information passed by wap adapter if the image is from plugin or normal wap page.

	Dec-10-2003 MMI-SPR-26159 - xreddymn: Prevent duplicate entries in History List

	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.

 $End

*******************************************************************************/



#ifndef PSA_WAPS_C
#define PSA_WAPS_C
#endif

#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif

#define ACI_MEMBER

/*==== INCLUDES ===================================================*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "message.h"
#include "prim.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#ifndef NEPTUNE_BOARD
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/
#include "ffs/ffs.h"
/* BEGIN ADD: Sumit : Req ID: : 31-Mar-2005*/
#else
#include "ffs.h"
#endif
/* END ADD: Sumit : Req ID: : 31-Mar-2005*/

#ifdef FF_GPF_TCPIP
#include "leconfig.h"
#include "capimic.h"
#include "aapimic.h"


#include "wapmic_types.h"
#include "wapmic_codec.h"
#else
#include "gledef.h"
#include "capiclnt.h"
#include "aapiclnt.h"

#include "wap_types.h"
#include "wap_codec.h"
#endif


#include "ATBData.h"
#include "ATBWapACI.h"

#include "ATBWapAUI.h"
#include "dspl.h"

#ifdef GPRS
#include "gaci_cmh.h"
#endif

//x0035544 29 Nov, 2005 MMI-SPR-55207
#ifndef NEPTUNE_BOARD //x0035544 Sudha - Guarded the below header files for Neptune.
#include "rvf/rvf_api.h" // for the function rvf_delay()
#endif
#ifdef FF_GPF_TCPIP
#include "tapimmi.h"

#include "socket_api.h"
#include "wapmic_sdlh.h"

// xreddymn Jan-24-2005 MMI-SPR-28135: WAP_OTA settings saved in WAP profiles
#include "mfw_ss.h" // For definitions of MFW_ASCII, MFW_DCS_UCS2

int 	ATB_convert_String(			char * ipString,	UBYTE ipDataType,	int ipLength,
										char * opString, 	UBYTE opDataType,	int opLength, UBYTE addNull);
void ATB_wap_profile_add(T_WAP_PROFILE *p);

#endif


EXTERN char *atD (char *cl,UBYTE srcId);

//xrashmic 21 Jan, 2005 MMI-SPR-28223

/*******************************************************************************

 $Function:    	M_MMI_WAP_READY_IND

 $Description:	Indicate to WAP that MMI is ready to receive events

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/


void M_MMI_WAP_READY_IND(T_MMI_WAP_READY_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_READY_IND");
#endif

	mmi_coder(WAP_READY_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_START_IND

 $Description:	Tell WAP Browser to start up

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

#ifdef CO_UDP_IP
void M_MMI_WAP_START_IND(T_MMI_WAP_START_IND *parameter)
#else
void M_MMI_WAP_START_IND(T_MMI_WAP_START_USER_AGENT_REQ *parameter)
#endif
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_START_IND");
#endif

	mmi_coder(WAP_START_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_NEW_VIEW_IND

 $Description:	Tell WAP Browser to start a new view

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/


void M_MMI_WAP_NEW_VIEW_IND(T_MMI_WAP_NEW_VIEW_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_NEW_VIEW_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2("id/uamode: %d, %d", parameter->object_id, parameter->uaMode);
	TRACE_EVENT_P2("width/height: %d, %d", parameter->view_width, parameter->view_height);
	TRACE_EVENT_P2("font height: %d, width of 'A': %d", parameter->font_height, parameter->font_width[65]);
	TRACE_EVENT_P2("unicode height: %d, unicode width: %d", parameter->unicode_width, parameter->unicode_height);
#endif

	mmi_coder(WAP_NEW_VIEW_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_TERMINATE_IND

 $Description:	Tell WAP Browser to terminate.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_TERMINATE_IND(T_MMI_WAP_TERMINATE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_TERMINATE_IND");
#endif

	mmi_coder(WAP_TERMINATE_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_CLOSE_VIEW_IND

 $Description:	Close the specified view.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CLOSE_VIEW_IND(T_MMI_WAP_CLOSE_VIEW_IND *parameter)
{
#ifdef TRACE_WAP_WAPMMI
	TRACE_FUNCTION("M_MMI_WAP_CLOSE_VIEW_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	mmi_coder(WAP_CLOSE_VIEW_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONFIGURE_IND

 $Description:	Send configuration information to WAP Browser

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONFIGURE_IND(T_MMI_WAP_CONFIGURE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONFIGURE_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P3( "Type, Param, Length: %d, %d, %d", parameter->type, parameter->param, parameter->length);
	TRACE_EVENT_P1( "Integer Value: %d", parameter->intvalue);
	if (parameter->length>0)
		ATB_trace_string(parameter->strvalue, parameter->length);
#endif

	mmi_coder(WAP_CONFIGURE_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONNECTION_CONFIGURE_IND

 $Description:	Send configuration information to WAP Browser

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONNECTION_CONFIGURE_IND(T_MMI_WAP_CONNECTION_CONFIGURE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONNECTION_CONFIGURE_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P3( "Type, Channel_id, Length: %d, %d, %d", parameter->type, parameter->channel_id, parameter->length);
	TRACE_EVENT_P1( "Integer Value: %d", parameter->intvalue);
	ATB_trace_string(parameter->strvalue, parameter->length);
#endif

	mmi_coder(WAP_CONNECTION_CONFIGURE_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_DOWNLOAD_URL_IND

 $Description:	Requests WAP Browser to download a URL

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_DOWNLOAD_URL_IND(T_MMI_WAP_DOWNLOAD_URL_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_DOWNLOAD_URL_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "URL length, Reload: %d, %d", parameter->url_length, parameter->reload);
	ATB_trace_string(parameter->Url, parameter->url_length);
#endif

	mmi_coder(WAP_DOWNLOAD_URL_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_BROWSE_CONTROL_IND

 $Description:	Sends browsing request to WAP Browser

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_BROWSE_CONTROL_IND(T_MMI_WAP_BROWSE_CONTROL_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_BROWSE_CONTROL_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "Browse command: %d", parameter->browse_command);
#endif

	mmi_coder(WAP_BROWSE_CONTROL_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_KEY_SELECTED_IND

 $Description:	Indicate to Browser that a WAP Key has been selected.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_KEY_SELECTED_IND(T_MMI_WAP_KEY_SELECTED_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_KEY_SELECTED_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "keyId: %d", parameter->keyId);
#endif

	mmi_coder(WAP_KEY_SELECTED_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_INPUT_DIALOG_CNF

 $Description:	Confirmation of input dialog.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_INPUT_DIALOG_CNF(T_MMI_WAP_INPUT_DIALOG_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_INPUT_DIALOG_CNF");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "dialog_id, edited: %d, %d", parameter->dialog_id, parameter->edited);
	ATB_trace_ushort_string(parameter->Text, parameter->text_length);
#endif

	mmi_coder(WAP_INPUT_DIALOG_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_PASSWORD_DIALOG_CNF

 $Description:	Confirmation of password dialog.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_PASSWORD_DIALOG_CNF(T_MMI_WAP_PASSWORD_DIALOG_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_PASSWORD_DIALOG_CNF");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "MMI dialog_id: %d", parameter->dialog_id);
	ATB_trace_string(parameter->Input, parameter->input_length);
	ATB_trace_string(parameter->Password, parameter->password_length);
#endif

	mmi_coder(WAP_PASSWORD_DIALOG_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONFIRM_DIALOG_CNF

 $Description:	Confirmation of confirm dialog.

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONFIRM_DIALOG_CNF(T_MMI_WAP_CONFIRM_DIALOG_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONFIRM_DIALOG_CNF");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "MMI dialog_id: %d, Answer: %d", parameter->dialog_id, parameter->answer);
#endif

	mmi_coder(WAP_CONFIRM_DIALOG_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_INFO_DIALOG_CNF

 $Description:	Confirmation of info dialog.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_INFO_DIALOG_CNF(T_MMI_WAP_INFO_DIALOG_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_INFO_DIALOG_CNF");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "MMI dialog_id: %d", parameter->dialog_id);
#endif

	mmi_coder(WAP_INFO_DIALOG_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_DRAW_CARD_REQ

 $Description:	Request WAP Browser to draw the current card.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_DRAW_CARD_REQ(T_MMI_WAP_DRAW_CARD_REQ *parameter)
{
	T_WAP_VIEW *View = ATB_wap_get_view(parameter->object_id);

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_DRAW_CARD_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	if (View)
	mmi_coder(WAP_DRAW_CARD_REQ_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_CONNECT_CNF

 $Description:	Confirmation to WAP Browser that WAP call is connected

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONNECT_CNF(T_MMI_WAP_CONNECT_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONNECT_CNF");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	mmi_coder(WAP_CONNECT_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_DISCONNECT_IND

 $Description:	Tell WAP Browser to disconnect

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_DISCONNECT_IND(T_MMI_WAP_DISCONNECT_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_DISCONNECT_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	mmi_coder(WAP_DISCONNECT_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************


 $Function:    	M_MMI_WAP_CACHE_PREPARE_IND

 $Description:	Tell WAP Browser to prepare the cache for shutdown

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CACHE_PREPARE_IND(T_MMI_WAP_CACHE_PREPARE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CACHE_PREPARE_IND");
#endif

	mmi_coder(WAP_CACHE_PREPARE_IND_ID,(void*)parameter);

	return;
}


#ifdef FF_GPF_TCPIP
/*******************************************************************************

 $Function:    	M_MMI_WAP_CONFIG_CNF

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONFIG_CNF(T_MMI_WAP_CONFIG_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONFIG_CNF");
#endif

	mmi_coder(WAP_CONFIG_CNF_ID,(void*)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_CONTENT_REQ

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONTENT_REQ(T_MMI_WAP_CONTENT_REQ *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_GET_CONTENT_REQ");
#endif

	mmi_coder(WAP_CONTENT_REQ_ID,(void*)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_CONTENT_POST_REQ

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONTENT_POST_REQ(T_MMI_WAP_CONTENT_POST_REQ *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONTENT_POST_REQ");
#endif

	mmi_coder(WAP_CONTENT_POST_REQ_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_CONTENT_POST_MORE_IND

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONTENT_POST_MORE_REQ(T_MMI_WAP_CONTENT_POST_MORE_REQ *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONTENT_POST_MORE_REQ");
#endif

	mmi_coder(WAP_CONTENT_POST_MORE_REQ_ID,(void*)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_CONTENT_CNF

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONTENT_CNF(T_MMI_WAP_CONTENT_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONTENT_CNF");
#endif

	mmi_coder(WAP_CONTENT_CNF_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_CONTENT_CANCEL_IND

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_MMI_WAP_CONTENT_CANCEL_IND(T_MMI_WAP_CONTENT_CANCEL_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_CONTENT_CANCEL_IND");
#endif

	mmi_coder(WAP_CONTENT_CANCEL_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_LOAD_SI_IND

 $Description:	Load the service pointed to by a SI
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_LOAD_SI_IND(T_MMI_WAP_PUSH_LOAD_SI_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_PUSH_LOAD_SI_IND");
#endif

	mmi_coder(WAP_PUSH_LOAD_SI_IND_ID,(void*)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_DELETE_SI_IND

 $Description:	Delete an SI
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_DELETE_SI_IND(T_MMI_WAP_PUSH_DELETE_SI_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_PUSH_DELETE_SI_IND");
#endif

	mmi_coder(WAP_PUSH_DELETE_SI_IND_ID,(void*)parameter);

	return;

}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_GET_SI_INFO_REQ

 $Description:	Request info on an SI
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_GET_SI_INFO_REQ(T_MMI_WAP_PUSH_GET_SI_INFO_REQ *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_MMI_WAP_PUSH_GET_SI_INFO_REQ");
#endif

	mmi_coder(WAP_PUSH_GET_SI_INFO_REQ_ID,(void*)parameter);

	return;

}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_LOAD_SL_IND

 $Description:	Load the service pointed to by an SL
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_LOAD_SL_IND(T_MMI_WAP_PUSH_LOAD_SL_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_LOAD_SL_IND");
#endif

	mmi_coder(WAP_PUSH_LOAD_SL_IND_ID,(void*)parameter);

	return;
}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_DELETE_SL_IND

 $Description:	Delete an SL
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_DELETE_SL_IND(T_MMI_WAP_PUSH_DELETE_SL_IND *parameter)
{
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_DELETE_SL_IND");
#endif

	mmi_coder(WAP_PUSH_DELETE_SL_IND_ID,(void*)parameter);

	return;

}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_GET_SL_INFO_REQ

 $Description:	Request info on an SL
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_GET_SL_INFO_REQ(T_MMI_WAP_PUSH_GET_SL_INFO_REQ *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_GET_SL_INFO_REQ");
#endif

	mmi_coder(WAP_PUSH_GET_SL_INFO_REQ_ID,(void*)parameter);

	return;

}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_CONNECTION_CNF

 $Description:	Confirm that Push connection information has been set up
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_CONNECTION_CNF(T_MMI_WAP_PUSH_CONNECTION_CNF *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_CONNECTION_CNF");
#endif

	mmi_coder(WAP_PUSH_CONNECTION_CNF_ID,(void*)parameter);

	return;

}


/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_CHANGE_STATUS_IND

 $Description:	Change the status of a push message
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_CHANGE_STATUS_IND(T_MMI_WAP_PUSH_CHANGE_STATUS_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_CHANGE_STATUS_IND");
#endif

	mmi_coder(WAP_PUSH_CHANGE_STATUS_IND_ID,(void*)parameter);

	return;

}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_REMOVE_MESSAGE_IND

 $Description:	Remove a push message
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_REMOVE_MESSAGE_IND(T_MMI_WAP_PUSH_REMOVE_MESSAGE_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_REMOVE_MESSAGE_IND");
#endif

	mmi_coder(WAP_PUSH_REMOVE_MESSAGE_IND_ID,(void*)parameter);

	return;

}

/*******************************************************************************

 $Function:    	MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ

 $Description:	Check if there are any unloaded messages
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ(T_MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_CHECK_UNLOADED_MSG_REQ");
#endif

	mmi_coder(WAP_PUSH_CHECK_UNLOADED_MSG_REQ_ID,(void*)parameter);

	return;

}


/*******************************************************************************


 $Function:    	M_MMI_WAP_PUSH_SAVE_TO_FLASH_IND

 $Description:	Save push repository to flash
 				SPR#2086 - Added

 $Returns:		None.

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_SAVE_TO_FLASH_IND(T_MMI_WAP_PUSH_SAVE_TO_FLASH_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_SAVE_TO_FLASH_IND");
#endif

	mmi_coder(WAP_PUSH_SAVE_TO_FLASH_IND_ID,(void*)parameter);

	return;

}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_SMS_RECEIVED_IND

 $Description:	WAP SMS has been received
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_SMS_RECEIVED_IND(T_MMI_WAP_PUSH_SMS_RECEIVED_IND *parameter)
{
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_SMS_RECEIVED_IND");
#endif

	mmi_coder(WAP_PUSH_SMS_RECEIVED_IND_ID, (void*)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_SMS_SENT_IND

 $Description:	WAP SMS has been sent
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_SMS_SENT_IND(T_MMI_WAP_PUSH_SMS_SENT_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_SMS_SENT_IND");
#endif

	mmi_coder(WAP_PUSH_SMS_SENT_IND_ID, (void *)parameter);

	return;
}

/*******************************************************************************

 $Function:    	M_MMI_WAP_PUSH_SMS_ERROR_IND

 $Description:	WAP SMS has not been sent
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_MMI_WAP_PUSH_SMS_ERROR_IND(T_MMI_WAP_PUSH_SMS_ERROR_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_PUSH_SMS_ERROR_IND");
#endif

	mmi_coder(WAP_PUSH_SMS_ERROR_IND_ID, (void *)parameter);

	return;
}

#endif


#ifdef FF_GPF_TCPIP
/*******************************************************************************


 $Function:    	M_WAP_MMI_CONTROL_IND

 $Description:

 $Returns:

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_CONTROL_IND(T_WAP_MMI_CONTROL_IND *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CONTROL_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P3( "Status, Error, Click: %d, %d, %d", parameter->status_code, parameter->error_code,
 parameter->play_standard_click);
#endif

	View = ATB_wap_get_view(parameter->object_id);

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	/* Intercept fatal error */
	//if (parameter->error_code==8002)
	//OUT OF MEMORY code 0x903
	if (parameter->error_code==2307)
	{
		AUI_error_dialog(View, parameter->error_code);
		return;
	}

	/* SPR#2086 - SH - Modified slightly to report status values
	 * correctly when downloading content using SAR */

	/* If WSP session failed, try using second IP address */

	if (parameter->error_code==1014 && !View->secondaryIP)
	{
		ATB_wap_secondary_IP(View);
		return;
	}

	/* For any other error, display the error dialog */

	if (parameter->error_code!=0 && parameter->error_code != 0x20)
	{
		AUI_error_dialog(View, parameter->error_code);
		return;
	}

	/* Otherwise, report selected status values */

	switch(parameter->status_code)
	{
		case 12:	/* Data is being downloaded */
			ATB_wap_status_change(View, ATB_WAP_DOWNLOADING);
			break;

		case 13:	/* Data is no longer being downloaded */
			ATB_wap_status_change(View, ATB_WAP_NO_STATUS);
			break;

		case 7:		/* Content taken from network server */
			if (View->object_id==WAP_DOWNLOAD_VIEW)
			{
				ATB_wap_status_change(View, ATB_WAP_DOWNLOADING);
			}
			break;

		case 9:		/* Content no longer being taken */
			if (View->object_id==WAP_DOWNLOAD_VIEW)
			{
				ATB_wap_status_change(View, ATB_WAP_NO_STATUS);
			}
			break;
	}

	return;
}

#else /* #ifdef FF_GPF_TCPIP */

/*******************************************************************************

 $Function:    	M_WAP_MMI_CONTROL_IND

 $Description:	Send control information to MMI

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CONTROL_IND(T_WAP_MMI_CONTROL_IND *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CONTROL_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P3( "Status, Error, Click: %d, %d, %d", parameter->status_code, parameter->error_code,
 parameter->play_standard_click);
#endif

	View = ATB_wap_get_view(parameter->object_id);

	/* Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	/* Intercept fatal error */

	if (parameter->error_code==8002)

	{
		AUI_error_dialog(View, parameter->error_code);
		return;
	}

	/* For non-fatal error, do not report if there is no view open */

	if (!View)
	{
		TRACE_EVENT("View is NULL");
		return;
	}

	/* Data is being downloaded; update status display */

	if (parameter->status_code==14)
	{
		ATB_wap_status_change(View, ATB_WAP_DOWNLOADING);
	}

	/* Data is no longer being downloaded */

	if (parameter->status_code==15)
	{
		ATB_wap_status_change(View, ATB_WAP_NO_STATUS);
	}

	/* If WSP session failed, try using second IP address */

	if (parameter->error_code==1014 && !View->secondaryIP)
	{
		ATB_wap_secondary_IP(View);
		return;
	}

	/* Create error dialog if required */

	if (parameter->error_code!=0 && parameter->error_code != 0x20)
	{
		AUI_error_dialog(View, parameter->error_code);

	}

	return;
}


#endif /* ! #ifdef FF_GPF_TCPIP */

/*******************************************************************************


 $Function:    	M_WAP_MMI_NEW_KEY_IND

 $Description:	A new WAP key is to be created.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_NEW_KEY_IND(T_WAP_MMI_NEW_KEY_IND *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_NEW_KEY_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "Key ID, Key Type: %d, %d", parameter->keyId, parameter->key_type);
	ATB_trace_ushort_string(parameter->Label, parameter->label_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	if (parameter->key_type == WAP_KEY_PREV)
		AUI_wap_change_soft_key(View, parameter->Label,
			(USHORT)parameter->label_length, parameter->keyId);

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_INPUT_DIALOG_REQ

 $Description:	An input dialog is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_INPUT_DIALOG_REQ(T_WAP_MMI_INPUT_DIALOG_REQ *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_INPUT_DIALOG_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "MMI dialog_id, is_password: %d, %d", parameter->dialog_id, parameter->is_password);
	TRACE_EVENT_P3( "MMI empty_ok, visible, size: %d, %d, %d", parameter->empty_ok,
parameter->visible, parameter->size);
	ATB_trace_ushort_string(parameter->Title, parameter->title_length);
	ATB_trace_ushort_string(parameter->Input, parameter->input_length);
	ATB_trace_ushort_string(parameter->Format, parameter->format_length);
#endif // TRACE_ATBWAPACI

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

#ifdef FF_GPF_TCPIP
	AUI_wap_input_dialog_open(parameter, View);
#else
	AUI_wap_input_dialog_open(parameter);
#endif

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_PASSWORD_DIALOG_REQ

 $Description:	A password dialog is to be displayed.

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_PASSWORD_DIALOG_REQ(T_WAP_MMI_PASSWORD_DIALOG_REQ *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_PASSWORD_DIALOG_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P2( "MMI dialog_id, dialog_type: %d, %d", parameter->dialog_id, parameter->dialog_type);
	/* SPR#2393 - SH - Changed password fields */
	ATB_trace_string(parameter->Realm, parameter->realm_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

#ifdef FF_GPF_TCPIP
	AUI_wap_password_dialog_open(parameter, View);
#else
	AUI_wap_password_dialog_open(parameter);
#endif

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_CONFIRM_DIALOG_REQ

 $Description:	A confirmation dialog is to be displayed.

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CONFIRM_DIALOG_REQ(T_WAP_MMI_CONFIRM_DIALOG_REQ *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CONFIRM_DIALOG_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "MMI dialog_id: %d", parameter->dialog_id);
	ATB_trace_ushort_string(parameter->Message, parameter->message_length);
	ATB_trace_ushort_string(parameter->Ok_key, parameter->ok_key_length);
	ATB_trace_ushort_string(parameter->Cancel_key, parameter->cancel_key_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

#ifdef FF_GPF_TCPIP
	AUI_wap_confirm_dialog_open(parameter, View);
#else
	AUI_wap_confirm_dialog_open(parameter);
#endif

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_INFO_DIALOG_REQ

 $Description:	An info/alert dialog is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_INFO_DIALOG_REQ(T_WAP_MMI_INFO_DIALOG_REQ *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_INFO_DIALOG_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "MMI dialog_id: %d", parameter->dialog_id);
	ATB_trace_ushort_string(parameter->Message, parameter->message_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

#ifdef FF_GPF_TCPIP
	AUI_wap_info_dialog_open(parameter, View);
#else
	AUI_wap_info_dialog_open(parameter);
#endif

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_NEW_CARD_IND

 $Description:	A new card is to be created.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_NEW_CARD_IND(T_WAP_MMI_NEW_CARD_IND *parameter)
{
	T_WAP_VIEW	*View;
#ifdef CO_UDP_IP
	UBYTE *History = (UBYTE *)parameter->History;
	U32	historyPointer = History[4] + History[5]*0x100 + History[6]*0x10000 + History[7]*0x1000000;
	/* Look at second history entry (bytes 4 to 7) - this is the previous card.
	 * If this is zero, then there shouldn't be a "back" key */
	USHORT historyIndex;
#endif


#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_NEW_CARD_IND");
	TRACE_EVENT_P1("object ID: %d",parameter->object_id);
	TRACE_EVENT_P1( "is_bookmarkable: %d", parameter->is_bookmarkable);
	ATB_trace_ushort_string(parameter->Title, parameter->title_length);
	ATB_trace_string(parameter->Url, parameter->url_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
	{
		return;
	}

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	/* SPR#1816 - SH - Store title, or "Untitled" if title is blank */

	if (parameter->title_length > 0)
	{
		/* Copy a max of CARD_TITLE_MAX_LEN unicode characters */
		parameter->title_length = ATB_uc_text_copy(View->Title, parameter->Title, CARD_TITLE_MAX_LEN);
		/* Convert to MMI unicode, store in View->Title */
		ATB_uc_text_convert(View->Title, parameter->title_length);
	}
	else
	{
		/* Use "Untitled" text tag */
		parameter->title_length = AUI_wap_stringID(View->Title, CARD_TITLE_MAX_LEN, WAP_STRING_UNTITLED);
	}

	/* SPR#1816 - SH - Copy URL, making sure it's not too long */

	strncpy(View->URL, parameter->Url, URL_MAX_LEN);

	/* Add card name & URL to top of history list
	 * SPR#1816 - SH - Do this before cropping title */

#ifdef FF_GPF_TCPIP
	if (ATB_wap_profile_setting(WAP_STATUS_SAVEHISTORY))
	{
// xreddymn Dec-10-2004 MMI-SPR-26159 - Insert title only if insert URL was successful
#if(0) // If set to 1, allows duplicate URLs to be inserted into history list
		ATB_wap_entry_insert(WAP_HISTORY_LIST, View->History, (char *)View->Title, 0);	// Add as entry 0 (last entry lost)
		ATB_wap_entry_insert(WAP_URL_LIST, View->HistoryURL, View->URL, 0);
#else // Insert title only if insert URL was successful
		if(ATB_wap_entry_insert(WAP_URL_LIST, View->HistoryURL, View->URL, 0)!=WAP_FAIL)
			ATB_wap_entry_insert(WAP_HISTORY_LIST, View->History, (char *)View->Title, 0);	// Add as entry 0 (last entry lost)
#endif
	}
//changes
#else
	if (View->Status & WAP_STATUS_SAVEHISTORY)
	{
		ATB_wap_entry_insert(View->History, (char *)View->Title, 0);	/* Add as entry 0 (last entry lost) */
		ATB_wap_entry_insert(View->HistoryURL, View->URL, 0);

	}
#endif
//changes
	/* Crop title so it fits on screen */

	ATB_uc_text_crop(View->Title, parameter->title_length, WAP_SCREEN_WIDTH-WAP_CHAR_WIDTH);

	/* Check to see if user can go back from this card */

#ifdef CO_UDP_IP
	if (historyPointer != 0)
	{
		View->CanGoBack = TRUE;
	}
	else
	{
		View->CanGoBack = FALSE;
	}
#else
    View->CanGoBack = TRUE;
#endif

	View->CustSoftKeys = FALSE;		/* Use default softkeys */

	/* SPR#1575 - SH - New card is being read in */

	ATB_wap_status_change(View, ATB_WAP_CARD_READING);

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_DRAW_CARD_IND

 $Description:	Tell MMI to draw the card.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_DRAW_CARD_IND(T_WAP_MMI_DRAW_CARD_IND *parameter)
{
	T_WAP_VIEW	*View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_DRAW_CARD_IND");
	TRACE_EVENT_P1("object ID: %d",parameter->object_id);
	TRACE_EVENT_P2("contentWidth: %d, contentHeight: %d",parameter->contentWidth, parameter->contentHeight);
	TRACE_EVENT_P2("contentPosX: %d, contentPosY: %d",parameter->contentPosX, parameter->contentPosY);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	View->cardWidth		= parameter->contentWidth;
	View->cardHeight	= parameter->contentHeight;
	View->cardXPosition	= parameter->contentPosX;
	View->cardYPosition	= parameter->contentPosY;

	View->acceptUpdate	= FALSE;
	/* Set to FALSE as default, to ignore any attempts to redraw parts of the card
	 * rather than the whole card (e.g. when selecting an option).  Only allows a card
	 * to be updated if M_WAP_MMI_CLEAR_CARD_IND is called. */

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_CLEAR_CARD_IND

 $Description:	Clear the card display.  Allows card to be updated.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CLEAR_CARD_IND(T_WAP_MMI_CLEAR_CARD_IND *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CLEAR_CARD_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	View->acceptUpdate = TRUE;

	/* Clearing the card means we're going to update the whole thing, so this update
	 * is permitted (see M_WAP_MMI_DRAW_CARD_IND). */

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_SEND_TEXT_IND


 $Description:	A text is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_SEND_TEXT_IND(T_WAP_MMI_SEND_TEXT_IND *parameter)
{
	T_WAP_VIEW					*View;
	T_WAP_ELEMENT				*Element;
	T_WAP_MMI_SEND_TEXT_IND		*copy;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_SEND_TEXT_IND");
	ATB_trace_ushort_string(parameter->Text, parameter->text_length);
	ATB_trace_ushort_string(parameter->Formatstring, parameter->formatstring_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
	{
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated by us in wapadapter.
		if(TRUE == parameter->free_flag)
		{
			T_MMI_WAP_MEM_FREE_IND free_mem_ind;
			free_mem_ind.data = (UBYTE*)parameter->Text;
			free_mem_ind.imageObject=FALSE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}
	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated by us in wapadapter.
		if(TRUE == parameter->free_flag)
		{
			T_MMI_WAP_MEM_FREE_IND free_mem_ind;
			free_mem_ind.data = (UBYTE*)parameter->Text;
			free_mem_ind.imageObject=FALSE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}

	/* If an update is forbidden, ignore this event */

	if (!View->acceptUpdate)
	{
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated by us in wapadapter.
		if(TRUE == parameter->free_flag)
		{
			T_MMI_WAP_MEM_FREE_IND free_mem_ind;
			free_mem_ind.data = (UBYTE*)parameter->Text;
			free_mem_ind.imageObject=FALSE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}

	/* Allocate memory and copy the data */

 	Element = ATB_wap_buffer_add_element(View, WAP_TEXT);	/* SPR#1921 - SH */

	copy = (T_WAP_MMI_SEND_TEXT_IND *)AUI_wap_memory_alloc(sizeof(T_WAP_MMI_SEND_TEXT_IND));
	memcpy((void *)copy, (void *)parameter, sizeof(T_WAP_MMI_SEND_TEXT_IND));
        //xrashmic 12 May, 2005 MMI-SPR-30834
        //For input text box, adding of [] is moved from wap adapter to bmi
        if(WAP_TEXT_INPUT == parameter->type)
        {
            if(parameter->text_length==0)
            {
                copy->text_length=2;
                copy->Text 			= (USHORT *)AUI_wap_memory_alloc((copy->text_length+1)*sizeof(USHORT));
            }
            else
            {
                copy->text_length=parameter->text_length+2;
                copy->Text 			= (USHORT *)AUI_wap_memory_alloc((copy->text_length+1)*sizeof(USHORT));
                memcpy((void *)(copy->Text+1), (void *)parameter->Text, parameter->text_length*sizeof(USHORT));                   
            }
            copy->Text[0] = (USHORT) '[';
            copy->Text[copy->text_length-1] = (USHORT) ']';
            copy->Text[copy->text_length] = (USHORT) '\0';
        }
        else
        {
		if (parameter->text_length != 0)
		{
			copy->Text 			= (USHORT *)AUI_wap_memory_alloc(parameter->text_length*sizeof(USHORT));
			memcpy((void *)copy->Text, (void *)parameter->Text, parameter->text_length*sizeof(USHORT));
		}
        }
	if (parameter->formatstring_length != 0)
	{
		copy->Formatstring 	=  (USHORT *)AUI_wap_memory_alloc(parameter->formatstring_length*sizeof(USHORT));
		memcpy((void *)copy->Formatstring, (void *)parameter->Text, parameter->formatstring_length*sizeof(USHORT));
	}

	Element->data = (void *)copy;

#ifdef FF_GPF_TCPIP
	// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
	// Need to free if the memory was allocated by us in wapadapter.
	if(TRUE == parameter->free_flag)
	{
		T_MMI_WAP_MEM_FREE_IND free_mem_ind;
		free_mem_ind.data = (UBYTE*)parameter->Text;
		free_mem_ind.imageObject=FALSE;
		M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
	}
#endif
	return;
}

#ifdef FF_GPF_TCPIP
/*******************************************************************************


 $Function:    	M_WAP_MMI_RADIO_BUTTON_IND


 $Description:	A radio button is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_RADIO_BUTTON_IND(T_WAP_MMI_RADIO_BUTTON_IND *parameter)
{

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_RADIO_BUTTON_IND");
	TRACE_EVENT_P2("MMI object ID: %d, element ID: %d",parameter->object_id, parameter->element_id);
	TRACE_EVENT_P2("MMI active, selected: %d, %d", parameter->active, parameter->selected);
	TRACE_EVENT_P2("MMI pX, pY: %d, %d", parameter->pX, parameter->pY);
	TRACE_EVENT_P2("MMI pWidth, pHeight: %d, %d", parameter->pWidth, parameter->pHeight);
#endif

	return;
}

/*******************************************************************************


 $Function:    	M_WAP_MMI_DRAW_BORDER_IND

 $Description:	A border element is to be displayed.
	            //kyle 29 Jun, 2005 MMI-SPR-32462
 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_DRAW_BORDER_IND(T_WAP_MMI_DRAW_BORDER_IND *parameter)
{

	T_WAP_VIEW					*View;
	T_WAP_ELEMENT				*Element;
	T_WAP_MMI_DRAW_BORDER_IND		*copy;

#ifdef TRACE_ATBWAPACI
  	TRACE_FUNCTION("M_WAP_MMI_DRAW_BORDER_IND");
	TRACE_EVENT_P1("WAP object ID: %d",parameter->object_id);
	TRACE_EVENT_P4("Bottom border pX, pY, pWidth, pHeight: %d, %d, %d, %d", parameter->borderBottom.pX, parameter->borderBottom.pY, parameter->borderBottom.pWidth, parameter->borderBottom.pHeight);
	TRACE_EVENT_P4("Left border pX, pY, pWidth, pHeight: %d, %d, %d, %d", parameter->borderLeft.pX, parameter->borderLeft.pY, parameter->borderLeft.pWidth, parameter->borderLeft.pHeight);
	TRACE_EVENT_P4("Right border pX, pY, pWidth, pHeight: %d, %d, %d, %d", parameter->borderRight.pX, parameter->borderRight.pY, parameter->borderRight.pWidth, parameter->borderRight.pHeight);
	TRACE_EVENT_P4("Top border pX, pY, pWidth, pHeight: %d, %d, %d, %d", parameter->borderTop.pX, parameter->borderTop.pY, parameter->borderTop.pWidth, parameter->borderTop.pHeight);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	/* If an update is forbidden, ignore this event */

	if (!View->acceptUpdate)
		return;

	/* Allocate memory and copy the data */

 	Element = ATB_wap_buffer_add_element(View, WAP_BORDER);	/* SPR#1921 - SH */

	copy = (T_WAP_MMI_DRAW_BORDER_IND *)AUI_wap_memory_alloc(sizeof(T_WAP_MMI_DRAW_BORDER_IND));
	memcpy((void *)copy, (void *)parameter, sizeof(T_WAP_MMI_DRAW_BORDER_IND));

	Element->data = (void *)copy;

	return;
}

#endif

/*******************************************************************************

 $Function:    	M_WAP_MMI_SEND_IMAGE_IND

 $Description:	An image is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_SEND_IMAGE_IND(T_WAP_MMI_SEND_IMAGE_IND *parameter)
{
	T_WAP_VIEW					*View;
	T_WAP_ELEMENT				*Element;
	T_WAP_MMI_SEND_IMAGE_IND	*copy;
#ifdef FF_GPF_TCPIP
    T_MMI_WAP_MEM_FREE_IND free_mem_ind; //xrashmic 30 Aug, 2005 MMI-SPR-34024(OMAPS00048918) mem leak fix
#endif

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_SEND_IMAGE_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
	{
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated for plugin image in wapadapter.
		if(parameter->pluginImage)
        	{
			free_mem_ind.data = parameter->ImageReq;
			free_mem_ind.imageObject=TRUE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}
	
	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated for plugin image in wapadapter.
		if(parameter->pluginImage)
        	{
			free_mem_ind.data = parameter->ImageReq;
			free_mem_ind.imageObject=TRUE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}

	/* If an update is forbidden, ignore this event */

	if (!View->acceptUpdate)
	{
#ifdef FF_GPF_TCPIP
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Need to free if the memory was allocated for plugin image in wapadapter.
		if(parameter->pluginImage)
        	{
			free_mem_ind.data = parameter->ImageReq;
			free_mem_ind.imageObject=TRUE;
			M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
		}
#endif
		return;
	}
#ifdef FF_GPF_TCPIP
	//xrashmic 21 Jan, 2005 MMI-SPR-28223
	//Saving the information passed by wap adapter if the image is from plugin or normal wap page.
	if(parameter->pluginImage)
	    	Element = ATB_wap_buffer_add_element(View, WAP_PLUGIN_IMAGE);	/* SPR#1921 - SH */
	else
#endif
	    	Element = ATB_wap_buffer_add_element(View, WAP_IMAGE);	/* SPR#1921 - SH */
	copy = (T_WAP_MMI_SEND_IMAGE_IND *)AUI_wap_memory_alloc(sizeof(T_WAP_MMI_SEND_IMAGE_IND));
	if (copy)
	{
	memcpy((void *)copy, (void *)parameter, sizeof(T_WAP_MMI_SEND_IMAGE_IND));


#ifdef FF_GPF_TCPIP
	//xrashmic 30 Aug, 2005 MMI-SPR-34024(OMAPS00048918) mem leak fix
	// Only for plugin images make a copy at bmi.
	if(parameter->pluginImage) 
        {
            if (parameter->image_length != 0)
		{
			copy->Image 		= (UBYTE *)AUI_wap_memory_alloc(parameter->image_length*sizeof(UBYTE));
			memcpy((void *)copy->Image, (void *)parameter->Image, parameter->image_length*sizeof(UBYTE));
		}
	}
    else
		copy->Image = (UBYTE*)parameter->Image;	
#else
		if (parameter->image_length != 0)
		{
			copy->Image 		= (UBYTE *)AUI_wap_memory_alloc(parameter->image_length*sizeof(UBYTE));
			memcpy((void *)copy->Image, (void *)parameter->Image, parameter->image_length*sizeof(UBYTE));
		}
#endif
	}

	Element->data = (void *)copy;

#ifdef FF_GPF_TCPIP
    	//xrashmic 30 Aug, 2005 MMI-SPR-34024(OMAPS00048918) mem leak fix
    	//freeing ImageReq data in WAP memory only for plugin images.
	if(parameter->pluginImage) 
        {
        	// xreddymn MMI-SPR-30834 May-14-2005: free ImageReq data in WAP memory
        	free_mem_ind.data = parameter->ImageReq;
		// xrashmic 20 Dec, 2005 OMAPS00061232  (on behalf of xreddymn)
		// Add this to differentiate between image objects and text objects to be freed in wap adapter
		free_mem_ind.imageObject=TRUE;
        	M_MMI_WAP_FREE_MEM_IND(&free_mem_ind);
	}
#endif
	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_SEND_TABLE_IND

 $Description:	A table/fieldset is to be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_SEND_TABLE_IND(T_WAP_MMI_SEND_TABLE_IND *parameter)
{
	T_WAP_VIEW					*View;
	T_WAP_ELEMENT				*Element;
	T_WAP_MMI_SEND_TABLE_IND	*copy;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_SEND_TABLE_IND");
	TRACE_EVENT_P1("object ID: %d",parameter->object_id);
	TRACE_EVENT_P2("Columns: %d, Rows: %d",parameter->cols_length, parameter->rows_length);
	TRACE_EVENT_P4("pX: %d, pY: %d, pWidth: %d, pHeight: %d",parameter->pX, parameter->pY, parameter->pWidth, parameter->pHeight);
	ATB_trace_ushort_string(parameter->Title, parameter->title_length);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	/* If an update is forbidden, ignore this event */

	if (!View->acceptUpdate)
		return;

	/* Allocate memory and copy the data */

 	Element = ATB_wap_buffer_add_element(View, WAP_TABLE); 	/* SPR#1921 - SH */

	copy = (T_WAP_MMI_SEND_TABLE_IND *)AUI_wap_memory_alloc(sizeof(T_WAP_MMI_SEND_TABLE_IND));
	memcpy((void *)copy, (void *)parameter, sizeof(T_WAP_MMI_SEND_TABLE_IND));

	if (parameter->title_length != 0)
	{
		copy->Title = (USHORT *)AUI_wap_memory_alloc(parameter->title_length*sizeof(USHORT));
		memcpy((void *)copy->Title, (void *)parameter->Title, parameter->title_length*sizeof(USHORT));
	}
	if (parameter->cols_length != 0)
	{
		copy->ColWidth = (SHORT *)AUI_wap_memory_alloc(parameter->cols_length*sizeof(SHORT));
		memcpy((void *)copy->ColWidth, (void *)parameter->ColWidth, parameter->cols_length*sizeof(SHORT));
	}
	if (parameter->rows_length != 0)
	{
		copy->RowHeight = (SHORT *)AUI_wap_memory_alloc(parameter->rows_length*sizeof(SHORT));
		memcpy((void *)copy->RowHeight, (void *)parameter->RowHeight, parameter->rows_length*sizeof(SHORT));
	}
	Element->data = (void *)copy;

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_CARD_DRAW_COMPLETED_IND

 $Description:	Card drawing is completed, card may be displayed.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CARD_DRAW_COMPLETED_IND(T_WAP_MMI_CARD_DRAW_COMPLETED_IND *parameter)
{
	T_WAP_VIEW *View;
	UBYTE temp;
      // July 13 2005  REF:  MMI-SPR-32012  x0012849
     // To change the functionality of RSK, when there is no page to go back
#ifdef FF_GPF_TCPIP
 	 if(HISTORY_NOT_AVAILABLE==  parameter->object_id)
   	 {
            ExitWAP(WAP_NONE);	 	
	     return;
 	 }
         //xrashmic 17 Aug, 2005 MMI-SPR-31364
         //When it is detected that a very large page is being opened, the wap adapter sends this message.
         //We need to exit wap and display a error dialog as we have memory constraints.
        else if(OUT_OF_MEM_LARGE_PAGE ==  parameter->object_id )
        { 
            ExitWAP(WAP_OUT_OF_MEM);	 	
	     return;
        }

#endif	 
	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	temp = dspl_Enable(0);

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CARD_DRAW_COMPLETED_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	/* If an update is forbidden, ignore this event */

	if (!View->acceptUpdate)
	{
		dspl_Enable(temp);
		return;
	}

	/* Destroy the current card, and make the new buffered card the current card */

	ATB_wap_buffer_clear(View);
	View->ElementHeader = View->NewElementHeader;
	View->NewElementHeader = NULL;

	AUI_wap_card_show_req(View);
	dspl_Enable(temp);

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_CONNECT_REQ

 $Description:	The connection (GSM or GPRS) can now be made.
 				The GSM connection occurs in this function.
 				The GPRS attachment is made in this function.  Once GPRS is
 				attached, the connection proceeds in function connect_gprs() below.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/
#ifdef FF_GPF_TCPIP

extern void M4_DebugStringMessage(char *in_string, UINT8 ucNumber,unsigned long para);
// xreddymn Mar-05-2005 MMI-SPR-26144: This function is called to check if
//    a MMS send operation was cancelled by the user
extern UBYTE AUI_mms_cancel_status(void);

void M_WAP_MMI_CONNECT_REQ(T_WAP_MMI_CONNECT_REQ *parameter)
{
	T_WAP_VIEW *View;
	char temp[NUMBER_MAX_LEN+1];
	T_ACI_BS_SPEED speed;


	T_SOCK_BEARER_INFO bearer_data;
	T_SOCKET_NODE *bearer_node = NULL;
	T_SOCK_RESULT result;


#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CONNECT_REQ");
	TRACE_EVENT_P2("MMI object ID: %d, bearer status: %d", parameter->object_id, parameter->bearer_status);
#endif

	// xreddymn Feb-23-2005 MMI-SPR-26144: If the user has pressed Cancel, do not connect
	if(AUI_mms_cancel_status()) return;

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}



	if(parameter->bearer_status == 1)
		{

				TRACE_EVENT("SAPI_BEARER_REQUEST");

				bearer_data.bearer_handle = 0;
			  	bearer_data.app_handle    = parameter->wap_app_handle;

				switch (View->Profile->AccessType)
				{
					case WAP_CS_DATA:
					{
						bearer_data.bearer_type   = SOCK_BEARER_GSM;
						bearer_data.phone_nr_valid = TRUE;
			       		bearer_data.cid = 1;
						bearer_data.user_id_valid = TRUE;
						bearer_data.password_valid = TRUE;
						strcpy(bearer_data.phone_nr, View->Profile->DialupNumber);
						strcpy(bearer_data.user_id, View->Profile->Username);
			    		strcpy(bearer_data.password, View->Profile->Password);
						bearer_data.precedence = 0;
			    		bearer_data.delay = 0;
			    		bearer_data.reliability = 0;
			    		bearer_data.peak_throughput = 0;
			    		bearer_data.mean_througput = 0;

			 			bearer_data.ip_address = SOCK_IPADDR_ANY;
			  			bearer_data.dns1 = SOCK_IPADDR_ANY;
			  			bearer_data.dns2 = SOCK_IPADDR_ANY;
			  			bearer_data.gateway = SOCK_IPADDR_ANY;
			  			bearer_data.authtype = SOCK_AUTH_NO;
			  			bearer_data.data_compr = FALSE;
			  			bearer_data.header_comp = FALSE;
			  			bearer_data.shareable = FALSE;

						break;
					}
#ifdef GPRS
					case WAP_GPRS_DATA:
					{
						bearer_data.bearer_type   = SOCK_BEARER_GPRS;
						bearer_data.apn_valid = TRUE;
			       		bearer_data.cid = 1;
						bearer_data.user_id_valid = TRUE;
						bearer_data.password_valid = TRUE;
						strcpy(bearer_data.apn, View->Profile->APN);
			    			strcpy(bearer_data.user_id, View->Profile->Username);
			    			strcpy(bearer_data.password, View->Profile->Password);
						bearer_data.precedence = 0;
			    			bearer_data.delay = 0;
			    			bearer_data.reliability = 0;
			    			bearer_data.peak_throughput = 0;
			    			bearer_data.mean_througput = 0;
						bearer_data.user_id_valid = TRUE;
			  			bearer_data.password_valid = TRUE;

			 			bearer_data.ip_address = SOCK_IPADDR_ANY;
			  			bearer_data.dns1 = SOCK_IPADDR_ANY;
			  			bearer_data.dns2 = SOCK_IPADDR_ANY;
			  			bearer_data.gateway = SOCK_IPADDR_ANY;
			  			bearer_data.authtype = SOCK_AUTH_NO;
			  			bearer_data.data_compr = FALSE;
			  			bearer_data.header_comp = FALSE;
			  			bearer_data.shareable = FALSE;

						break;
					}
		}
#endif

				bearer_node = (T_SOCKET_NODE *)parameter->node;

				if(bearer_node == NULL)
				{
					TRACE_ERROR("Error: M_WAP_MMI_CONNECT_REQ()");
					return;
				}

				result = sock_open_bearer((T_SOCK_API_INSTANCE)parameter->instance, SOCK_BEARER_AS_SPECIFIED, 0,&bearer_data, wap_sock_app_callback, bearer_node);

				if(result != SOCK_RESULT_OK)
				{
					TRACE_ERROR("M_WAP_MMI_CONNECT_REQ(): error in sock_open_bearer()");
					TRACE_EVENT_P1("result: %d", result);
					return;
				}
				else
				{
					TRACE_EVENT_P1("sock_open_bearer(): socket_api_instance: %d", result);
				}
			}
	else
			{
				TRACE_ERROR("M_WAP_MMI_CONNECT_REQ(): Unknown bearer status");
		}



	return;
}


/*******************************************************************************

 $Function:    	connect

 $Description:	Connect
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	object_id - the current session

*******************************************************************************/

void connect(UBYTE object_id)
{
	T_WAP_VIEW *View;
	char temp[NUMBER_MAX_LEN+1];
	T_ACI_BS_SPEED speed;

    char TraceBuffer[100];


  sprintf(TraceBuffer, "connect called");
  //M4_DebugStringMessage( TraceBuffer,(strlen(TraceBuffer)), 0);

	if (!(View = ATB_wap_get_view(object_id)))
		return;

	switch (View->Profile->AccessType)
	{
		case WAP_CS_DATA:
			/* CSD call - connect straight away */

			sAT_PercentPPP(0,1,View->Profile->Username, View->Profile->Password, USE_NO_PPP_FOR_AAA);
			sAT_PercentWAP(0,0);
			sAT_PercentWAP(0,1);

			/* Set the connection speed */

			switch(View->Profile->ConnectionSpeed)
			{
				case WAP_ANALOGUE:
					speed = BS_SPEED_AUTO;
					break;
				case WAP_ISDN9600:
					speed = BS_SPEED_9600_V110;
					break;
				case WAP_ISDN14400:
					speed = BS_SPEED_14400_V110;
					break;
				default:
					speed = BS_SPEED_9600_V34;
					break;
			}
			//Nov 02, 2005    DR OMAPS00052132   xdeepadh			
			//The usage of ATI enum is put under the flag FF_ATI			
#ifdef FF_ATI
			sAT_PlusCBST(CMD_SRC_ATI_1, speed, CBST_NAM_Asynch, CBST_CE_NonTransparent);
			/* Make the call */
			sprintf(temp, "=%s", View->Profile->DialupNumber);
			atD(temp,CMD_SRC_ATI_1);
#endif   //FF_ATI
			break;

#ifdef GPRS
		case WAP_GPRS_DATA:
		{
			/* GPRS call - attach now.  If attached, connect.
			 * If not, wait until attach succeeds */

			T_CGATT_STATE regstate;

			/* Check to see if attached */

			qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );
#ifdef TRACE_ATBWAPACI
	  		TRACE_EVENT_P1("Reg state: %d", regstate);
#endif

			/* If we're not attached, attempt to do so */

	  		if (regstate!=CGATT_STATE_ATTACHED)
	  		{
	  			/* Display status "attaching" */
				ATB_wap_status_change(View, ATB_WAP_ATTACHING);
				/* Attempt to attach */
	  			sAT_PlusCGATT ( CMD_SRC_LCL, CGATT_STATE_ATTACHED );
	  		}
			/* Otherwise, go straight to GPRS connection */
	  		else
	  		{
	  			connect_gprs(object_id);
			}
		}
		break;
#endif

	default:
		TRACE_EVENT("ERROR: Illegal access type!");
		AUI_error_dialog(View, ERROR_CALL_DISCONNECTED);
		break;
	}
}

#else /* #ifdef FF_GPF_TCPIP */

void M_WAP_MMI_CONNECT_REQ(T_WAP_MMI_CONNECT_REQ *parameter)
{
	T_WAP_VIEW *View;
	char temp[NUMBER_MAX_LEN+1];
	T_ACI_BS_SPEED speed;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_CONNECT_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

	switch (View->Profile->AccessType)
	{
		case WAP_CS_DATA:
			/* CSD call - connect straight away */

			sAT_PercentPPP(0,1,View->Profile->Username, View->Profile->Password, USE_NO_PPP_FOR_AAA);
			sAT_PercentWAP(0,0);
			sAT_PercentWAP(0,1);

			/* Set the connection speed */

			switch(View->Profile->ConnectionSpeed)
			{
				case WAP_ANALOGUE:
					speed = BS_SPEED_AUTO;
					break;
				case WAP_ISDN9600:
					speed = BS_SPEED_9600_V110;
					break;
				case WAP_ISDN14400:
					speed = BS_SPEED_14400_V110;
					break;
				default:
					speed = BS_SPEED_9600_V34;
					break;
			}
			//Nov 02, 2005    DR OMAPS00052132   xdeepadh			
			//The usage of ATI enum is put under the flag FF_ATI			
#ifdef FF_ATI 
			sAT_PlusCBST(CMD_SRC_ATI_1, speed, CBST_NAM_Asynch, CBST_CE_NonTransparent);
			/* Make the call */
			sprintf(temp, "=%s", View->Profile->DialupNumber);
			atD(temp,CMD_SRC_ATI_1);
#endif		//FF_ATI
			break;

#ifdef GPRS
		case WAP_GPRS_DATA:
		{
			/* GPRS call - attach now.  If attached, connect.
			 * If not, wait until attach succeeds */

			T_CGATT_STATE regstate;

			/* Check to see if attached */

			qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );
#ifdef TRACE_ATBWAPACI
	  		TRACE_EVENT_P1("Reg state: %d", regstate);
#endif

			/* If we're not attached, attempt to do so */

	  		if (regstate!=CGATT_STATE_ATTACHED)
	  		{
	  			/* Display status "attaching" */
				ATB_wap_status_change(View, ATB_WAP_ATTACHING);
				/* Attempt to attach */
	  			sAT_PlusCGATT ( CMD_SRC_LCL, CGATT_STATE_ATTACHED );
	  		}
			/* Otherwise, go straight to GPRS connection */
	  		else
	  		{
	  			connect_gprs(parameter->object_id);
			}
		}
#endif
	}

	return;
}


#endif /* ! #ifdef FF_GPF_TCPIP */

#ifdef GPRS
#ifdef FF_GPF_TCPIP
extern  void M4_DebugStringMessage(char *in_string, UINT8 ucNumber,unsigned long para);
void PowerOnGPRSAttach(void)
{
    T_CGATT_STATE regstate;
    char temp[50];

    /* Modified to detect if GPRS attach fails. Check to see if attached */
    qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );

    sprintf(temp, "PowerOnGPRSAttach called!");
    //M4_DebugStringMessage( temp,(strlen(temp)), 0);

    /* If we're not attached, attempt to do so */
    if (regstate!=CGATT_STATE_ATTACHED)
    {
        sprintf(temp, "sAT_PlusCGATT called!");
        //M4_DebugStringMessage( temp,(strlen(temp)), 0);

        /* Attempt to attach */
        sAT_PlusCGATT ( CMD_SRC_LCL, CGATT_STATE_ATTACHED );
    }
}

void mms_gprs_deattach(void)
{
    T_CGATT_STATE regstate;
    char temp[50];

    sprintf(temp, "mms_gprs_deattach called!");
    //M4_DebugStringMessage( temp,(strlen(temp)), 0);

    qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );

    if (regstate == CGATT_STATE_ATTACHED)
    {
        sprintf(temp, "mms_gprs_deattach need to deattach!");
        //M4_DebugStringMessage( temp, (strlen(temp)), 0);

        /* Attempt to deattach */
        sAT_PlusCGATT ( CMD_SRC_LCL, CGATT_STATE_DETACHED );
        rvf_delay(100);
    }

    return;
}

void mms_gprs_attach(void)
{
    T_CGATT_STATE regstate;
    char temp[50];
    UINT8 i;
    UINT8 ucAttachTime;

    /* Modified to detect if GPRS attach fails. Check to see if attached */
    qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );
    TRACE_EVENT_P1("Reg state: %d", regstate);

    sprintf(temp, "mms_gprs_attach called!");
    //M4_DebugStringMessage( temp,(strlen(temp)), 0);

    /* If we're not attached, attempt to do so */
    if (regstate!=CGATT_STATE_ATTACHED)
    {
        sprintf(temp, "sAT_PlusCGATT called!");
        //M4_DebugStringMessage( temp,(strlen(temp)), 0);

        /* Attempt to attach */
        sAT_PlusCGATT ( CMD_SRC_LCL, CGATT_STATE_ATTACHED );

        ucAttachTime = 24;

        for (i = 0;i < ucAttachTime;i++)//120s for GPRS
        {
            qAT_PlusCGATT ( CMD_SRC_LCL, &regstate );
            if (regstate == CGATT_STATE_ATTACHED)
            {
                break;
            }

            /*delay 5s*/
            rvf_delay(1000);
        }

        if (i == ucAttachTime)
        {
            sprintf(temp, "mms_gprs_attach failed after 5s %03d* ",ucAttachTime);
            //M4_DebugStringMessage( temp,(strlen(temp)), 0);
        }
        else
        {
            sprintf(temp, "mms_gprs_attach success!");
            //M4_DebugStringMessage( temp,(strlen(temp)), i);
        }
    }

}

/*******************************************************************************


 $Function:    	connect_gprs

 $Description:	GPRS is attached; now activate PDP context
 				SPR#1982 - SH
 				- Tidy up variables a little.
 				- Change '1' to GPRS_CID_1
 				- Put traces inside #ifdefs

 $Returns:		None.

 $Arguments:	View - the current view

*******************************************************************************/

void connect_gprs(UBYTE object_id)
{
	SHORT cids[MAX_CID_PLUS_EINS];
	BOOL states[MAX_CID_PLUS_EINS];
	T_GPRS_CONT_REC context;
	T_ACI_RETURN ret;
	T_WAP_VIEW *View;
	SHORT contextId;
	SHORT arrayPos;
	char dialString[10];

	TRACE_FUNCTION("connect_gprs()");

	if (!(View = ATB_wap_get_view(object_id)))
		return;

	/* Select the context ID */

	contextId = GPRS_CID_1;


	if (object_id==WAP_PUSH_VIEW)
	{
		contextId = GPRS_CID_2;
	}


	/* Check to see if context already active */
	memset (states, FALSE, sizeof(states));
	memset (cids, 0, sizeof(cids));

	qAT_PlusCGACT ( CMD_SRC_LCL, states, cids );

	if (contextId==cids[0] || cids[0]==INVALID_CID)
		arrayPos = 0;
	else
		arrayPos = 1;

#ifdef TRACE_ATBWAPACI
	TRACE_EVENT_P1("Context 0: %d", cids[0]);
#endif

	/* If context doesn't exist, define it
	 * Use GPRS_CID_1 rather than number '1'*/

    if ( cids[arrayPos] == INVALID_CID)
	{
#ifdef TRACE_ATBWAPACI
        TRACE_EVENT("Defining new context.");
#endif

		states[arrayPos] = FALSE;

		strncpy((char *)context.apn, View->Profile->APN, MAX_APN_LEN);
		strcpy((char*)context.pdp_type, "IP");
		memset(context.pdp_addr, '\0', MAX_PDP_ADDR_LEN);
		context.d_comp = CGDCONT_D_COMP_OMITTED;
		context.h_comp = CGDCONT_H_COMP_OMITTED;
		memset(&context.qos, 0, sizeof(T_QOS));
		memset(&context.min_qos, 0 ,sizeof(T_QOS));

		ret = sAT_PlusCGDCONT(CMD_SRC_LCL, contextId, &context);

#ifdef TRACE_ATBWAPACI
	TRACE_EVENT_P1("CGDCONT Return = %d",ret);
#endif

	if (ret==AT_FAIL)
	{
			ATB_wap_data_call_disconnected(View);
		AUI_error_dialog(View, ERROR_GPRS_NOT_SUPPORTED);
		return;
	}
	}

	/* Removed duplicate call to qAT_PlusCGACT.
	 * If context isn't activated, call CGPCO */

	if (states[arrayPos])
	{
#ifdef TRACE_ATBWAPACI
		TRACE_EVENT("Context is activated.");
#endif
		ATB_data_call_connected(View); /* SPR#2086 */
	}
	else
	{
#ifdef TRACE_ATBWAPACI
		TRACE_EVENT("Context not activated.");
#endif

		ret = sAT_PercentCGPCO (
			CMD_SRC_LCL,
			contextId,
			ACI_PCO_AUTH_PROT_PAP,
			(CHAR *)View->Profile->Username,
			(CHAR *)View->Profile->Password,
			NULL,
			NULL);//liuyu add NULL for build

#ifdef TRACE_ATBWAPACI
		TRACE_EVENT_P1("CGPCO Return = %d", ret);
#endif

		if (ret==AT_FAIL)
		{
			ATB_wap_data_call_disconnected(View); /* SPR#2086 */
			AUI_error_dialog(View, ERROR_GPRS_NOT_SUPPORTED);
			return;
		}

		//sprintf(dialString, "*98**1*%d#", contextId);
		//"*98*1#"
		//sAT_Dn(CMD_SRC_LCL,"*98*1#",D_CLIR_OVRD_Default,D_CUG_CTRL_NotPresent,D_TOC_Data);
		ret = sAT_Dn(
			CMD_SRC_LCL,
			//dialString,
			"*98*1#",
			D_CLIR_OVRD_Default,
			D_CUG_CTRL_NotPresent,
			D_TOC_Data);

	  switch (ret)
	  {
	      case (AT_CMPL):   /*operation completed*/
	      case (AT_EXCT):
	    	  break;

	      default:
		  		ATB_wap_data_call_disconnected(View);
	  		  AUI_error_dialog(View, ERROR_CALL_DISCONNECTED);
  #ifdef TRACE_ATBWAPACI
	    	  TRACE_EVENT("Error occurred in connection.");
  #endif
	    	  return;
			  break;
	  }
	}

  	return;
  }
#else /* #ifdef FF_GPF_TCPIP */

void connect_gprs(UBYTE object_id)
{
	SHORT cids[MAX_CID_PLUS_EINS];
	BOOL states[MAX_CID_PLUS_EINS];
	T_GPRS_CONT_REC context;
	T_ACI_RETURN ret;
	UBYTE minsize;
	T_WAP_VIEW *View;

	TRACE_FUNCTION("connect_gprs()");

	if (!(View = ATB_wap_get_view(object_id)))
		return;

	/* Check to see if context already active */
	memset (states, FALSE, sizeof(states));
	memset (cids, 0, sizeof(cids));

	qAT_PlusCGACT ( CMD_SRC_LCL, states, cids );

#ifdef TRACE_ATBWAPACI
	TRACE_EVENT_P1("Context 0: %d", cids[0]);
#endif

	/* If context doesn't exist, define it */

    if ( cids[0] == INVALID_CID)
	{
#ifdef TRACE_ATBWAPACI
        TRACE_EVENT("Defining new context.");
#endif
		/* SPR#2138 - SH - If context not defined, it is not activated */
		states[0] = FALSE;
	}

	/* SPR#2415 - SH - Define context, whether or not it was defined before */

    minsize = (MAX_APN_LEN<(URL_MAX_LEN+1))?MAX_APN_LEN:(URL_MAX_LEN+1);
	memset(&context.apn,'\0',MAX_APN_LEN);
	memcpy(&context.apn,&View->Profile->APN,minsize);
	strcpy((char*)context.pdp_type,"IP");
	minsize = (MAX_PDP_ADDR_LEN<(IPADDRESS_MAX_LEN+1))?MAX_PDP_ADDR_LEN:(IPADDRESS_MAX_LEN+1);
	memset(&context.pdp_addr,'\0',MAX_PDP_ADDR_LEN);
	context.d_comp = CGDCONT_D_COMP_OMITTED;
	context.h_comp = CGDCONT_H_COMP_OMITTED;
	memset(&context.qos,0,sizeof(T_QOS));
	memset(&context.min_qos,0,sizeof(T_QOS));

	ret = sAT_PlusCGDCONT(CMD_SRC_LCL,GPRS_CID_1,&context);

#ifdef TRACE_ATBWAPACI
	TRACE_EVENT_P1("CGDCONT Return = %d",ret);
#endif

	if (ret==AT_FAIL)
	{
		AUI_error_dialog(View, ERROR_GPRS_NOT_SUPPORTED);
		return;
	}

	/* Removed duplicate call to qAT_PlusCGACT.
	 * If context isn't activated, call CGPCO */

	if (states[0])
	{
#ifdef TRACE_ATBWAPACI
		TRACE_EVENT("Context is activated.");
#endif
		ATB_data_call_connected();	/* SPR#2138 */
	}
	else
	{
#ifdef TRACE_ATBWAPACI
		TRACE_EVENT("Context not activated.");
#endif

		ret = sAT_PercentCGPCO (
			CMD_SRC_LCL,
			GPRS_CID_1,
			ACI_PCO_AUTH_PROT_PAP,
			(CHAR *)View->Profile->Username,
			(CHAR *)View->Profile->Password,
			NULL,
			NULL
			);

#ifdef TRACE_ATBWAPACI
		TRACE_EVENT_P1("CGPCO Return = %d", ret);
#endif

		if (ret==AT_FAIL)
		{
			AUI_error_dialog(View, ERROR_GPRS_NOT_SUPPORTED);
			return;
		}

	  ret = sAT_Dn(CMD_SRC_LCL,"*98*1#",D_CLIR_OVRD_Default,D_CUG_CTRL_NotPresent,D_TOC_Data);

	  switch (ret)
	  {
	      case (AT_CMPL):   /*operation completed*/
	      case (AT_EXCT):
	    	  break;

	      default:
	  		  AUI_error_dialog(View, ERROR_CALL_DISCONNECTED);
  #ifdef TRACE_ATBWAPACI
	    	  TRACE_EVENT("Error occurred in connection.");
  #endif
	    	  return;
			  break;
	  }

  	return;
  }
}

#endif /* #ifdef FF_GPF_TCPIP */
#endif

// xreddymn May-15-2005 MMI-SPR-30962: external functions
extern void MMS_set_WAP_busy(void);
extern void MMS_reset_WAP_busy(void);
extern void MMS_process_push_queue(void);

/*******************************************************************************


 $Function:    	M_WAP_MMI_DISCONNECTED_IND

 $Description:	A disconnection has occurred.

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_DISCONNECTED_IND(T_WAP_MMI_DISCONNECTED_IND *parameter)
{
	T_WAP_VIEW *View;

#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_DISCONNECTED_IND");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif
#ifdef FF_GPF_TCPIP
	// xreddymn Feb-23-2005 MMI-SPR-26144
	AUI_mms_cancel_status();
#endif
	if (!(View = ATB_wap_get_view(parameter->object_id)))
		return;

	/* SPR#1816 - SH - Check if we're shutting down */

	if (ATB_wap_status_get(View, ATB_WAP_SHUTTING_DOWN))
	{
		TRACE_EVENT("*** SHUTTING DOWN ***");
		return;
	}

#ifdef FF_GPF_TCPIP
        // xreddymn Feb-17-2005 MMI-SPR-26144: Disabled info dialogs
        //    as they appear when sending MMS
	if(ATB_WAP_ATTACH_FAILED == parameter->error)
	{
                //xrashmic 08 Feb, 2005 MMI-SPR-27853
                //Need to indicate the BMI when there are GPRS errors
                ATB_wap_status_change(View, ATB_WAP_ATTACH_FAILED);
	}
	else if(ATB_WAP_ACTIVATE_FAILED == parameter->error)
	{
            //xrashmic 08 Feb, 2005 MMI-SPR-27853
            //Need to indicate the BMI when there are GPRS errors
            ATB_wap_status_change(View, ATB_WAP_ACTIVATE_FAILED);        
	}
#endif

	/* SPR#1574 - SH - Removed parameter */
	ATB_wap_status_change(View,ATB_WAP_ONLINE_CONNECTION_CLOSED);

#ifdef FF_GPF_TCPIP
	// xreddymn May-15-2005 MMI-SPR-30962: If MMS transaction is complete,
	// clear WAP busy state.
	MMS_reset_WAP_busy();
	MMS_process_push_queue();
#endif

	return;
}


/*******************************************************************************


 $Function:    	M_WAP_MMI_READY_CNF

 $Description:	SPR#1569 - SH - Added this function
 				Confirm that WAP has completed the operation.

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_READY_CNF(T_WAP_MMI_READY_CNF *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_READY_CNF");
	TRACE_EVENT_P1("Event id = %d", parameter->event_id);
#endif

	switch (parameter->event_id)
	{
		case WAP_START_IND_ID:
			ATB_wap_start_done();
			break;
		case WAP_NEW_VIEW_IND_ID:
			ATB_wap_new_view_done();
			break;
		case WAP_CLOSE_VIEW_IND_ID:
			ATB_wap_close_view_done();
			break;
		case WAP_TERMINATE_IND_ID:
			ATB_wap_terminate_done();
			break;
		/* SPR#1824 - SH - Cache is prepared */
		case WAP_CACHE_PREPARE_IND_ID:
			ATB_wap_cache_prepare_done();
			break;
	}
	return;
}


/*******************************************************************************

 $Function:    	disconnect_wap_call

 $Description:	Disconnect GPRS WAP call in progress.

 $Returns:		SPR#1982 - SH
 				TRUE if connection is disconnected, FALSE if disconnection in progress

 $Arguments:	access_type - WAP_GPRS_DATA or WAP_CS_DATA

*******************************************************************************/

UBYTE disconnect_wap_call(UBYTE access_type)
{
	UBYTE disconnected;
	T_ACI_RETURN ret;
#ifdef GPRS
	SHORT cids[MAX_CID_PLUS_EINS] = {GPRS_CID_1, INVALID_CID};
#endif

	TRACE_FUNCTION("disconnect_wap_call()");

	disconnected = TRUE;

#ifdef GPRS
	if (access_type==WAP_GPRS_DATA)
	{
		/* SPR#1875 - SH - Update data counter */

		sAT_PercentSNCNT(CMD_SRC_LCL, TRUE);

		ret = sAT_PlusCGACT(CMD_SRC_LCL, CGACT_STATE_DEACTIVATED, cids);

#ifdef TRACE_ATBWAPACI
		TRACE_EVENT_P1("Result of sAT_PlusCGACT = %d", ret);
#endif

		/* If detaching will take a little time, show a please wait dialog */

		if (ret==AT_EXCT)
		{
			disconnected = FALSE;
		}
	}
#endif
	return disconnected;
}

#ifdef FF_GPF_TCPIP
/*******************************************************************************


 $Function:    	M_WAP_MMI_CONFIG_REQ

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CONFIG_REQ(T_WAP_MMI_CONFIG_REQ *parameter)
{
	T_MMI_WAP_CONFIG_CNF parameter2;
	T_WAP_VIEW *View;
	T_WAP_PROFILE		*httpClientProfile;


#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_CONFIG_REQ");
	TRACE_EVENT_P1("MMI object ID: %d",parameter->object_id);
#endif

    parameter2.object_id = parameter->object_id;

    /* Check if any view exists, create a new invisible view if not */

	if (!(View = ATB_wap_get_view(parameter->object_id)))
	{
		View = ATB_wap_new_view_invisible(parameter->object_id);
		ATB_wap_change_view(parameter->object_id);
	}

	ATB_wap_profile_send(View);

	/* Set default channel */
	ATB_wap_config_int(View, configDEFAULT_CHANNEL, View->channel);

	/* Setup stack mode */
	httpClientProfile = View->Profile;
	if (httpClientProfile->Port1 == 9201)
	{
		ATB_wap_conn_config_int(View, configCONNECTION_TYPE, CONNECTION_TYPE_WSP_CO);
		TRACE_EVENT("CONNECTION_TYPE_WSP_CO at the location 2 called");
	}
	else
	{
		ATB_wap_conn_config_int(View, configCONNECTION_TYPE, CONNECTION_TYPE_TCP);
		TRACE_EVENT("CONNECTION_TYPE_TCP at the location 2 called");
	}


	/* Set connection port */
	ATB_wap_conn_config_int(View, configCLIENT_PORT, WAP_DOWNLOAD_LOCAL_PORT);

	/* Set online status (FALSE = not always online) */
	//ATB_wap_conn_config_int(View, configONLINE, FALSE);

	parameter2.success = TRUE;

	M_MMI_WAP_CONFIG_CNF(&parameter2);

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_CONTENT_IND

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CONTENT_IND(T_WAP_MMI_CONTENT_IND *parameter)
{
	T_MMI_WAP_CONTENT_CNF parameter2;

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("W_WAP_MMI_CONTENT_IND");
	TRACE_EVENT_P2("URL ID: %d, data length = %d", parameter->urlID, parameter->data_length);
	TRACE_EVENT_P2("moreData: %d, totalSize = %d", parameter->moreData, parameter->totalSize);
#endif

	ATB_wap_content(
		parameter->urlID,
		parameter->Data,
		parameter->data_length,
		parameter->moreData | parameter->moreSegments,
		parameter->ContentType,
		parameter->contentType_length,
		parameter->totalSize,
		parameter->errorNo
		);

	if (parameter->moreSegments==FALSE && parameter->moreData==TRUE)
	{
		TRACE_EVENT("Fetching more data");
		parameter2.urlID = parameter->urlID;
		M_MMI_WAP_CONTENT_CNF(&parameter2);
	}

	return;
}

/*******************************************************************************

 $Function:    	M_WAP_MMI_CONTENT_POST_CNF

 $Description:	SPR#2086 - SH - SAR

 $Returns:		None

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_CONTENT_POST_CNF(T_WAP_MMI_CONTENT_POST_CNF *parameter)
{
    extern    void mms_proc_content_post_cnf(UINT8 urlID);

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_CONTENT_POST_CNF");
	TRACE_EVENT_P1("urlID = %d", parameter->urlID);
#endif

    //TISHMMS Project
    ////xmzhou_trace_string_value("M_WAP_MMI_CONTENT_POST_CNF called parameter->urlID = ", parameter->urlID);
    mms_proc_content_post_cnf(parameter->urlID);
	return;
}

/*******************************************************************************

 $Function:    	copy_IP_address

 $Description:	Copies IP address from one string to another. Ensures that the
                destination string is in the form: AAA.BBB.CCC.DDD

 $Returns:		None

 $Arguments:	dst: Pointer to the destination string. On returning from this
                     function, this will contain the form: AAA.BBB.CCC.DDD
                src: Pointer to the source string. This is a string representing
                     an IP address, where each field is seperated by a Dot (.)

                     xreddymn Jan-24-2005 MMI-SPR-28135: WAP_OTA

*******************************************************************************/

void copy_IP_address(char *dst, char *src, S32 length)
{
	S32 i=0, j, k=0, count, number;
	U8 number_string[8];
	for(count=0;count<4;count++)
	{
		j=0;
		while((src[i]!='\0') && (src[i]!='.') && (j<4))
		{
			number_string[j]=src[i];
			i++;
			j++;
		}
		if(src[i]=='.') i++;
		number_string[j]='\0';
		number=atoi((char*)number_string);
		if(count==3) sprintf((char*)&dst[k],"%03d",number);
		else sprintf((char*)&dst[k],"%03d.",number);
      k+=4;
	}
}

void M_WAP_MMI_BROWSER_SET_CSD_IND(T_WAP_MMI_BROWSER_SET_CSD_IND *parameter)
{
	T_WAP_PROFILE new_profile;
	S32 length;
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_BROWSER_SET_CSD_IND");
	TRACE_EVENT_P1("Profile name = %s", parameter->OTA_profileName);
	TRACE_EVENT_P1("Homepage URL = %s", parameter->OTA_homepageUrl);
	TRACE_EVENT_P1("Dialstring = %s", parameter->OTA_CSD_dialstring);
	TRACE_EVENT_P1("Proxy = %s", parameter->OTA_proxy);
	TRACE_EVENT_P1("Port = %d", parameter->OTA_port);
#endif
	// xreddymn Jan-24-2005 MMI-SPR-28135: WAP_OTA settings saved in WAP profiles
	new_profile.AccessType=WAP_CS_DATA;
	if(parameter->OTA_profileName_length==0)
	{
		ATB_convert_String((char*)"No name", MFW_ASCII, strlen("No name"),
						(char*)new_profile.Title, MFW_DCS_UCS2, CARD_TITLE_MAX_LEN, TRUE);
	}
	else
	{
		ATB_convert_String((char*)parameter->OTA_profileName, MFW_ASCII, parameter->OTA_profileName_length, 
						(char*)new_profile.Title, MFW_DCS_UCS2, CARD_TITLE_MAX_LEN, TRUE);
	}
	length=parameter->OTA_homepageUrl_length;
	if(length>(URL_MAX_LEN+1)) length=URL_MAX_LEN+1;
	strncpy(new_profile.Homepage,parameter->OTA_homepageUrl,length);
	new_profile.ConnectionType=WAP_CONTINUOUS;
	if((strncmp(parameter->OTA_CSD_callType,"ISDN",parameter->OTA_CSD_callType_length)==0) || (strncmp(parameter->OTA_CSD_callType,"isdn",parameter->OTA_CSD_callType_length)==0))
	{
		new_profile.ConnectionSpeed=WAP_ISDN9600;
	}
	else
	{
		new_profile.ConnectionSpeed=WAP_ANALOGUE;
	}
	new_profile.ResponseTimer=60;
	new_profile.Port1=parameter->OTA_port;
	new_profile.Port2=parameter->OTA_port;
	length=parameter->OTA_proxy_length;
	if(length>(IPADDRESS_MAX_LEN+1)) length=IPADDRESS_MAX_LEN+1;
	copy_IP_address(new_profile.IPAddress1,parameter->OTA_proxy,length);
	copy_IP_address(new_profile.IPAddress2,parameter->OTA_proxy,length);
	length=parameter->OTA_CSD_dialstring_length;
	if(length>(NUMBER_MAX_LEN+1)) length=NUMBER_MAX_LEN+1;
	strncpy(new_profile.DialupNumber,parameter->OTA_CSD_dialstring,length);
	length=parameter->OTA_PPP_username_length;
	if(length==0)
	{
		strcpy(new_profile.Username,"");
	}
	else
	{
		if(length>(USERNAME_MAX_LEN+1)) length=USERNAME_MAX_LEN+1;
		strncpy(new_profile.Username,parameter->OTA_PPP_username,length);
	}
	length=parameter->OTA_PPP_password_length;
	if(length==0)
	{
		strcpy(new_profile.Password,"");
	}
	else
	{
		if(length>(PASSWORD_MAX_LEN+1)) length=PASSWORD_MAX_LEN+1;
		strncpy(new_profile.Password,parameter->OTA_PPP_password,length);
	}
	new_profile.Security=FALSE;
	strcpy(new_profile.NameServer1,"");
	strcpy(new_profile.NameServer2,"");
	new_profile.PPGAuthentication=FALSE;
	new_profile.WirelessProfiledHTTP=TRUE;
	ATB_wap_profile_add(&new_profile);
	return;
}

void M_WAP_MMI_BROWSER_SET_GPRS_IND(T_WAP_MMI_BROWSER_SET_GPRS_IND *parameter)
{
	T_WAP_PROFILE new_profile;
	S32 length;
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_BROWSER_SET_GPRS_IND");
	TRACE_EVENT_P1("Profile name = %s", parameter->OTA_profileName);
	TRACE_EVENT_P1("Homepage URL = %s", parameter->OTA_homepageUrl);
	TRACE_EVENT_P1("APN = %s", parameter->OTA_GPRS_APN);
	TRACE_EVENT_P1("Proxy = %s", parameter->OTA_proxy);
	TRACE_EVENT_P1("Port = %d", parameter->OTA_port);
#endif
	// xreddymn Jan-24-2005 MMI-SPR-28135: WAP_OTA settings saved in WAP profiles
	new_profile.AccessType=WAP_GPRS_DATA;
	if(parameter->OTA_profileName_length==0)
	{
		ATB_convert_String((char*)"No name", MFW_ASCII, strlen("No name"),
						(char*)new_profile.Title, MFW_DCS_UCS2, CARD_TITLE_MAX_LEN, TRUE);
	}
	else
	{
		ATB_convert_String((char*)parameter->OTA_profileName, MFW_ASCII, parameter->OTA_profileName_length, 
						(char*)new_profile.Title, MFW_DCS_UCS2, CARD_TITLE_MAX_LEN, TRUE);
	}
	length=parameter->OTA_homepageUrl_length;
	if(length>(URL_MAX_LEN+1)) length=URL_MAX_LEN+1;
	strncpy(new_profile.Homepage,parameter->OTA_homepageUrl,length);
	new_profile.ConnectionType=WAP_CONTINUOUS;
	new_profile.ResponseTimer=60;
	new_profile.Port1=parameter->OTA_port;
	new_profile.Port2=parameter->OTA_port;
	length=parameter->OTA_proxy_length;
	if(length>(IPADDRESS_MAX_LEN+1)) length=IPADDRESS_MAX_LEN+1;
	copy_IP_address(new_profile.IPAddress1,parameter->OTA_proxy,length);
	copy_IP_address(new_profile.IPAddress2,parameter->OTA_proxy,length);
	length=parameter->OTA_GPRS_APN_length;
	if(length>(URL_MAX_LEN+1)) length=URL_MAX_LEN+1;
	strncpy(new_profile.APN,parameter->OTA_GPRS_APN,length);
	length=parameter->OTA_proxy_username_length;
	if(length==0)
	{
		strcpy(new_profile.Username,"");
	}
	else
	{
		if(length>(USERNAME_MAX_LEN+1)) length=USERNAME_MAX_LEN+1;
		strncpy(new_profile.Username,parameter->OTA_proxy_username,length);
	}
	length=parameter->OTA_proxy_password_length;
	if(length==0)
	{
		strcpy(new_profile.Password,"");
	}
	else
	{
		if(length>(PASSWORD_MAX_LEN+1)) length=PASSWORD_MAX_LEN+1;
		strncpy(new_profile.Password,parameter->OTA_proxy_password,length);
	}
	new_profile.Security=FALSE;
	strcpy(new_profile.NameServer1,"");
	strcpy(new_profile.NameServer2,"");
	new_profile.PPGAuthentication=FALSE;
	new_profile.WirelessProfiledHTTP=TRUE;
	ATB_wap_profile_add(&new_profile);
	return;
}


void M_WAP_MMI_MMS_SET_CSD_IND(T_WAP_MMI_MMS_SET_CSD_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_MMS_SET_CSD_IND");
	TRACE_EVENT_P1("Profile name = %s", parameter->OTA_profileName);
	TRACE_EVENT_P1("MMSC URL = %s", parameter->OTA_mmsUrl);
	TRACE_EVENT_P1("Dialstring = %s", parameter->OTA_CSD_dialstring);
	TRACE_EVENT_P1("Proxy = %s", parameter->OTA_proxy);
	TRACE_EVENT_P1("Port = %d", parameter->OTA_port);
#endif

	return;
}

void M_WAP_MMI_MMS_SET_GPRS_IND(T_WAP_MMI_MMS_SET_GPRS_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_MMS_SET_GPRS_IND");
	TRACE_EVENT_P1("Profile name = %s", parameter->OTA_profileName);
	TRACE_EVENT_P1("MMSC URL = %s", parameter->OTA_mmsUrl);
	TRACE_EVENT_P1("APN = %s", parameter->OTA_GPRS_APN);
	TRACE_EVENT_P1("Proxy = %s", parameter->OTA_proxy);
	TRACE_EVENT_P1("Port = %d", parameter->OTA_port);
#endif

	return;
}

void M_WAP_MMI_BROWSER_BOOKMARKS_IND(T_WAP_MMI_BROWSER_BOOKMARKS_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_BROWSER_BOOKMARKS_IND");
	TRACE_EVENT_P1("Number of bookmarks = %d", parameter->OTA_numberOfBookmarks);
	TRACE_EVENT_P1("First bookmark name = %s", parameter->OTA_bookmarkName_1);
	TRACE_EVENT_P1("First bookmark url  = %s", parameter->OTA_bookmarkUrl_1);
#endif

	return;
}
void M_WAP_MMI_SYNCML_GENERAL_SET_IND(T_WAP_MMI_SYNCML_GENERAL_SET_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_SYNCML_GENERAL_SET_IND");
	TRACE_EVENT_P1("Host address  = %s", parameter->OTASYNC_HostAddr);
	TRACE_EVENT_P1("Database URI  = %s", parameter->OTASYNC_URI);
	TRACE_EVENT_P1("Connection port   = %d", parameter->OTASYNC_Port);
#endif

	return;
}

void M_WAP_MMI_SYNCML_CONTENT_SET_IND(T_WAP_MMI_SYNCML_CONTENT_SET_IND *parameter)
{

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_SYNCML_CONTENT_SET_IND");
	TRACE_EVENT_P1("Content type	 = %s", parameter->OTASYNC_CTType);
	TRACE_EVENT_P1("Content version  = %s", parameter->OTASYNC_CTVer);
#endif

	return;
}
/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_NEW_SI_IND

 $Description:	New SI is received
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_NEW_SI_IND(T_WAP_MMI_PUSH_NEW_SI_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_NEW_SI_IND");
#endif

	ATB_wap_push_SI_new(
		parameter->id,
		parameter->created,
		parameter->expires,
		parameter->Message,
		parameter->message_length,
		parameter->expired,
		parameter->Url,
		parameter->url_length,
		parameter->priority,
		parameter->InitURL,
		parameter->initURL_length,
		parameter->applicationType,
		parameter->newChannelId	);

	return;
}

/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_SI_INFO_IND

 $Description:	SI info is received
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_SI_INFO_IND(T_WAP_MMI_PUSH_SI_INFO_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_SI_INFO_IND");
#endif

	ATB_wap_push_SI_info(
		parameter->id,
		parameter->status,
		parameter->created,
		parameter->expires,
		parameter->Message,
		parameter->message_length,
		parameter->expired,
		parameter->Url,
		parameter->url_length,
		parameter->priority,
		parameter->InitURL,
		parameter->initURL_length);

	return;
}

/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_NEW_SL_IND

 $Description:	New SL is received
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_NEW_SL_IND(T_WAP_MMI_PUSH_NEW_SL_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_NEW_SL_IND");
#endif

	// xreddymn Mar-22-2005 MMI-SPR-29767: Modified handling of SL messages
	// xreddymn Mar-11-2005 MMI-SPR-29510: Enabled support for SL messages
	ATB_wap_push_SL_new(
		parameter->id,
		parameter->Url,
		parameter->url_length,
		parameter->priority,
		parameter->InitURL,
		parameter->initURL_length,
		parameter->applicationType,
		parameter->newChannelId	);

	return;
}

/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_SL_INFO_IND

 $Description:	SL info is received
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_SL_INFO_IND(T_WAP_MMI_PUSH_SL_INFO_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_SL_INFO_IND");
#endif


	return;
}

/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_MESSAGE_CHANGE_IND

 $Description:	A message status has changed
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_MESSAGE_CHANGE_IND(T_WAP_MMI_PUSH_MESSAGE_CHANGE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_MESSAGE_CHANGE_IND");
#endif

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_REPOSITORY_FULL_IND

 $Description:	The push repository is full
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_REPOSITORY_FULL_IND(T_WAP_MMI_PUSH_REPOSITORY_FULL_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_WAP_MMI_PUSH_REPOSITORY_FULL_IND");
#endif

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_CONNECTION_REQ

 $Description:	A request to set up the push connection
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_CONNECTION_REQ(T_WAP_MMI_PUSH_CONNECTION_REQ *parameter)
{
	T_MMI_WAP_PUSH_CONNECTION_CNF parameter2;
	T_WAP_VIEW *View;
	ULONG IPAddressLong;

#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_PUSH_CONNECTION_REQ");
#endif

    /* Check if any view exists, create a new invisible view if not */

	if (!(View = ATB_wap_get_view(PUSH_USER_AGENT)))
	{
		View = ATB_wap_new_view_invisible(PUSH_USER_AGENT);
	}

	/* Setup stack mode */
	ATB_wap_conn_config_int(View, configACCESS_TYPE, parameter->stackMode);

	/* Setup access type- CSD by default */
	if (parameter->accessType!=BEARER_ANY)
	{
		ATB_wap_conn_config_int(View, configACCESS_TYPE, parameter->accessType);
	}
	else
	{
		ATB_wap_conn_config_int(View, configACCESS_TYPE, BEARER_GSM_CSD);
	}

	/* Setup gateway address */
	ATB_conv_str_to_IP(parameter->Address, parameter->address_length, &IPAddressLong);
	ATB_wap_conn_config_str(View, configPROXY_ADDRESS, (CHAR *)&IPAddressLong, sizeof(ULONG));

	/* Set connection port */
	ATB_wap_conn_config_int(View, configCLIENT_PORT, WAP_LOCAL_PORT);

	/* Set online status (FALSE = not always online) */
	//ATB_wap_conn_config_int(View, configONLINE, FALSE);

	/* Setup timeout */
	ATB_wap_conn_config_int(View, configTIMEOUT, WAP_DEFAULT_RESPONSE_TIME);

	/* Set connection port 1 */
	ATB_wap_conn_config_int(View, WAP_setPort1, WAP_DEFAULT_PORT);

	/* Set connection port 2 */
	ATB_wap_conn_config_int(View, WAP_setPort2, WAP_DEFAULT_PORT);

	ATB_wap_config_int(View, configPPG_AUTHENTICATION_REQUIRED, 0);

	parameter2.siaId = parameter->siaId;
	parameter2.channelId = WAP_CHANNEL_ID;
	parameter2.success = TRUE;

	M_MMI_WAP_PUSH_CONNECTION_CNF(&parameter2);

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_UNLOADED_MSG_CNF

 $Description:	Indicates if there are unloaded messages in the Push inbox
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_UNLOADED_MSG_CNF(T_WAP_MMI_PUSH_UNLOADED_MSG_CNF *parameter)
{
	TRACE_FUNCTION("M_WAP_MMI_PUSH_UNLOADED_MSG_CNF");

	return;
}


/*******************************************************************************

 $Function:    	M_WAP_MMI_PUSH_SMS_SEND_IND

 $Description:	Request for MMI to send an SMS
 				SPR#2086 - Added

 $Returns:		None

 $Arguments:	parameter - Data block

*******************************************************************************/

void M_WAP_MMI_PUSH_SMS_SEND_IND(T_WAP_MMI_PUSH_SMS_SEND_IND *parameter)
{
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_WAP_MMI_PUSH_SMS_SEND_IND");
	TRACE_EVENT_P1("destination_length: %d", parameter->destination_length);
	TRACE_EVENT_P1("data_length: %d", parameter->data_length);
#endif

	ATB_wap_push_SMS_send(
		parameter->Smsc,
		parameter->smsc_length,
		parameter->Destination,
		parameter->destination_length,
		parameter->Data,
		parameter->data_length);

	return;
}

// xreddymn Mar-25-2005 MMI-SPR-26144: send data indication
// this is used to update progress when sending MMS
/*******************************************************************************

 $Function:    	M_WAP_MMI_NET_SEND_IND

 $Description:	NET SEND indication

 $Returns:		None.

 $Arguments:	parameter - data block

*******************************************************************************/

void M_WAP_MMI_NET_SEND_IND(T_WAP_MMI_NET_SEND_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_FUNCTION("M_WAP_MMI_NET_SEND_IND");
#endif
#ifdef FF_GPF_TCPIP
	AUI_wap_net_send_ind();
#endif
}

// xreddymn MMI-SPR-30834 May-14-2005
/*******************************************************************************

 $Function:    	M_MMI_WAP_FREE_MEM_IND
 
 $Description:  Called by MMI to free data in WAP memory
 
 $Returns:		None.

 $Arguments:    parameter - data block

*******************************************************************************/

void M_MMI_WAP_FREE_MEM_IND(T_MMI_WAP_MEM_FREE_IND *parameter)
{
#ifdef TRACE_ATBWAPACI
	TRACE_EVENT("M_MMI_WAP_FREE_MEM_IND");
#endif

	mmi_coder(WAP_MEM_FREE_IND_ID, (void *)parameter);

	return;
}

// xreddymn Jun-21-2005 MMI-SPR-30291
/*******************************************************************************

 $Function:    	M_MMI_WAP_SEND_PROFILE_IND
 
 $Description:  Sends profile data from MMI to WAP adapter
 
 $Returns:		None.

 $Arguments:    parameter - data block

*******************************************************************************/

void M_MMI_WAP_SEND_PROFILE_IND(T_MMI_WAP_SEND_PROFILE_IND *parameter)
{
#ifdef TRACE_WAP_WAPMMI
	TRACE_EVENT("M_MMI_WAP_SEND_PROFILE_IND");
#endif

	mmi_coder(WAP_SEND_PROFILE_IND_ID, (void *)parameter);

	return;
}

#endif
/* #ifdef FF_GPF_TCPIP */
