/********************************************************************************                                                                              

 This software product is the property of Condat (UK) Ltd and may not be
 disclosed to any third party without the express permission of the owner.                                 
                                                                              
********************************************************************************

 $Project name:	                                                      
 $Project code:	                                                           
 $Module:		
 $File:		    ATBData.h
 $Revision:		                                                      
                                                                              
 $Author:		Condat(UK)                                                         
 $Date:		                                                          
                                                                               
********************************************************************************
                                                                              
 Description:
 	Common data for the ATB.
    
                        
********************************************************************************

 $History: ATBData.h

       xrashmic 17 Aug, 2005 MMI-SPR-31364
       When it is detected that a very large page is being opened, the wap adapter sends a message.
       We need to exit wap and display a error dialog as we have memory constraints.       
       
       xrashmic 29 Jun, 2005 MMI-SPR-32462
       Patch given by Kyle for display of table border
       May 11 2005  REF:  MMI-SPR-29887  x0012849
       To Implement the deferred MMS retrieval.

       xrashmic 23 Feb, 2005 MMI-SPR-28222  
       Display appropriate dialogs when receive MMS fails due to MMS folder being full

       xrashmic 08 Feb, 2005 MMI-SPR-27853
       Error handling in sending MMS and also displaying the progress  value
       
	xreddymn Jan-11-2005 MMI-SPR-27618: 
	Added length parameter for WAP push messages

	xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42

	15/05/2003 - SPR#1983 - SH - Updated to latest from 1.6.3 version.
	   
 $End

*******************************************************************************/
//#define CO_UDP_IP temp till xml file ready

#ifndef ATBDATA
#define ATBDATA

#define URL_MAX_LEN 			150		/* SPR#1824 - SH - Increased - Max no. of characters for URL */
#define NUMBER_PADDING 			4		/* History list has a number in front of it; this is how long this is in characters, including "." and " " */
#define PROFILENAME_MAX_LEN		20		/* Max no. of characters for profile title. SPR#2112 - Increased to 20.  */
#define OPTIONS_MAX_LEN 		20		/* ...options menu entries. SPR#2112 - Increased to 20. */
#define NUMBER_MAX_LEN    		20		/* ...dialup number */
#define IPADDRESS_MAX_LEN		15		/* ...IP address */
#define SOFTKEY_MAX_LEN			20		/* ...soft key text SPR#1816 - SH - Increased this a little */
#define INPUT_MAX_LEN			100		/* ...standard WML editor */
#define USERNAME_MAX_LEN 		20		/* ...ISP username */
#define PASSWORD_MAX_LEN 		20		/* ...ISP password */
#define CARD_TITLE_MAX_LEN		20		/* ...title of card */
#define TEXT_MAX_LEN			255		/* ...any text on the WAP card */
#define ERROR_MAX_LEN			50		/* ...error messages */
#define WAP_PUSH_TITLE_MAX_LEN		32		/* MMI-SPR-27618 Jan 11 2005 - xreddymn: Max number of characters displayed when listing push messages */

#define MAX_BOOKMARKS			15		/* maximum number of bookmarks */
#define MAX_HISTORY 			10		/* maximum number of history entries */
#define MAX_PROFILES 			9		/* SPR#1824 - SH - Increased - Maximum number of profiles */

#define WAP_OBJECT_ID 1					/* Default View ID */
#define WAP_CHANNEL_ID 1				/* Default Channel ID */

/* SPR#2112 - SH - Some default profile values */ 
#define WAP_DEFAULT_PORT 9201
#define WAP_LOCAL_PORT 3

#define WAP_DEFAULT_RESPONSE_TIME 180
#ifdef FF_GPF_TCPIP
#define WAP_DOWNLOAD_LOCAL_PORT 4
#define WAP_DOWNLOAD_ID 1
#define WAP_NO_VIEW 0xFF			/* Indicates no currently open view */
#define WAP_DOWNLOAD_VIEW 128

/* SPR#2086 - SH - Constants for PUSH */

#define WAP_PUSH_VIEW 130
#define WAP_DEFAULT_PORT_PUSH 2948
#define WAP_PUSH_MAX_MESSAGES 15 /* Maximum number of push messages that will be shown in list */

//xrashmic 17 Aug, 2005 MMI-SPR-31364
void ExitWAP(BOOL value);
#define WAP_OUT_OF_MEM  1
#define WAP_NONE    0
#endif

/*
*		Status values
*/

enum
{
	ATB_WAP_NO_STATUS = 0,			/* Idle */
	ATB_WAP_DOWNLOADING,			/* Card is downloading */
	ATB_WAP_ONLINE_CONNECTION_CLOSED,		/* Connection has been closed */
	ATB_WAP_CONNECTING,				/* Connecting to WAP gateway */
	ATB_WAP_LOGGING_IN,				/* Logging in */
	ATB_WAP_ATTACHING,				/* Attaching GPRS */
	ATB_WAP_ATTACH_FAILED,			/* GPRS Attach failed */
	ATB_WAP_CARD_READING,			/* Card is being read in from cache or network */
	ATB_WAP_PLEASE_WAIT,			/* Please wait window */
	ATB_WAP_ACTIVATE_FAILED,		/* PDP Context Activation Failed */
	ATB_WAP_SHUTTING_DOWN,			/* WAP is shutting down */
	ATB_WAP_ERROR, 					/* General GPRS Error */
	ATB_WAP_DEACTIVATING			/* Waiting for a context to deactivate */
};

#define WAP_STATUS_SAVEHISTORY			0x00000001		/* Whether history list is saved */
#define WAP_STATUS_SCALEIMAGES			0x00000002		/* Whether images are scaled to fit the screen */
#ifdef FF_GPF_TCPIP
#define WAP_STATUS_PUSHMESSAGES			0x00000004		/* SPR#2086 - Whether or not push messages are displayed on receipt */
#endif

/* Extra error codes */

#define ERROR_GPRS_NOT_SUPPORTED				-1
#define ERROR_CALL_DISCONNECTED					-2	/* SPR#1656 - SH - Added this */
#define ERROR_COMMUNICATION_SERVER				-3  /* SPR#1793 - SH - Corresponds to error type 7 */
#define ERROR_COMMUNICATION_GATEWAY				-4	/* SPR#1793 - SH - Corresponds to error type 8 */
#define ERROR_UNEXPECTED						-5 /* SPR#1793 - SH - Corresponds to error type 9 */
#define ERROR_SECURITY							-6 /* SPR#1793 - SH - Corresponds to error type 16 */

#if defined (FF_MMI_MMS) && defined (FF_GPF_TCPIP)
//xrashmic 19 Aug, 2004 Bug: 2, 3, 36 and 42
//xrashmic 08 Feb, 2005 MMI-SPR-27853
// To display the different stages of MMS sending and receiving
typedef enum 
{
    MMS_SEND_PROGRESS = -30,
    MMS_SEND_SUCCESS,	
    MMS_SEND_FAIL,
    MMS_RECEIVE_PROGRESS, //Need to Modify this in mms_wap_comm.c
    MMS_RECEIVE_SUCCESS, //xrashmic 23 Feb, 2005 MMI-SPR-28222  Need to Modify this in Mms_device_driver.c 
    MMS_RECEIVE_FAIL, //xrashmic 23 Feb, 2005 MMI-SPR-28222  Need to Modify this in Mms_device_driver.c 
    MMS_PLEASEWAIT,
    MMS_ERROR,
    MMS_SEND_START,
    MMS_NO_MEMORY, //xrashmic 23 Feb, 2005 MMI-SPR-28222  Need to Modify this in Mms_device_driver.c 
    MMS_NOTIFICATION_PROGRESS, // x0012849 May 11 MMI-SPR-29887   Need to Modify this in  Mms_Device_Driver.c  Value = -20
    MMS_NOTIFICATION_RECEIVED  // x0012849 May 11 MMI-SPR-29887   Need to Modify this in  Mms_Device_cust.c  Value = -19
}MMS_STATUS_EVENT;
#endif

/* Text Strings
*		
*  These are strings that the ATB will request from AUI.
*/

typedef enum
{
	WAP_STRING_DOWNLOADING,
	WAP_STRING_UPDATING,
	WAP_STRING_UNTITLED	/* SPR#1816 - SH */
};


/* Type of list
 *
 * As well as a generic type, lists are for bookmarks, history, profiles, options menu and
 * for URLs.  A URL list is associated with each of the bookmarks and history lists.
 */

typedef enum
{
	WAP_GENERIC_LIST,
	WAP_BOOKMARKS_LIST,
	WAP_HISTORY_LIST,
	WAP_PROFILES_LIST,
	WAP_OPTIONS_LIST,
	WAP_URL_LIST
#ifdef FF_GPF_TCPIP	/* SPR#2086 */
	,WAP_PROFILES_SETUP,
	WAP_PUSH_LIST,
	WAP_LIST_FINAL
#endif

} WAP_LIST_TYPE;


/* T_WAP_LIST
 *
 * This is a generic list type for ATB and AUI.  The size of the list and the size of the entries
 * are stored so that the list can be handled by standard routines.  The generic list handling routines
 * have function names starting "ATB_wap_entry_".
 * SPR#1816 - SH - Added unicode flag
 */
 
typedef struct
{
	WAP_LIST_TYPE	type;							/* Type of list */
	UBYTE			no_of_entries;					/* Number of entries stored */
	UBYTE			entry_size;						/* Entry size in characters */
	UBYTE			max_entries;					/* Maximum no. of entries */
	char			**Entry;						/* Pointers to the entries */
	BOOL			unicode;						/* TRUE if entries are unicode */
} T_WAP_LIST;


/* T_WAP_CONNECTION
 *
 * Connection type
 */
 
typedef enum
{
	WAP_TEMPORARY,
	WAP_CONTINUOUS
}T_WAP_CONNECTION;


/* T_WAP_SPEED
 *
 * SPR#1827 - SH - Connection speed
 */
 
typedef enum
{
	WAP_ANALOGUE,
	WAP_ISDN9600,
	WAP_ISDN14400
}T_WAP_SPEED;


/* T_WAP_ACCESS
 *
 * Access type
 */

typedef enum
{
	WAP_GPRS_DATA = 0,
	WAP_CS_DATA,
	WAP_SMS
} T_WAP_ACCESS;


/* T_WAP_PROFILE
 *
 * Structure to hold profile information.  All information here is stored in flash and
 * loaded into RAM for each session.  There may be many profiles stored in flash.
 */

typedef struct
{	
	USHORT		Title[CARD_TITLE_MAX_LEN+1];		/* The name of the profile. SPR#1816 - SH - Now unicode */
	char		Homepage[URL_MAX_LEN+1];					// The URL of the homepage
	UBYTE		ConnectionType;				// Temporary or Continuous
	BOOL		Security;
	UBYTE		AccessType;							/* CSD or GPRS */
	USHORT		ResponseTimer;
	char		IPAddress1[IPADDRESS_MAX_LEN+1];
	char		IPAddress2[IPADDRESS_MAX_LEN+1];
	char		DialupNumber[NUMBER_MAX_LEN+1];
	USHORT		Port1;
	USHORT		Port2;
	char		APN[URL_MAX_LEN+1];
	char		Username[USERNAME_MAX_LEN+1];
	char		Password[PASSWORD_MAX_LEN+1];
	UBYTE		ConnectionSpeed;				/* SPR#1827 - SH - Store connection speed */
//xpradipg - Aug 4: Added four new members to the structure to extend the menu to accomdate
//				  WAP 2.0 menu items
#ifdef FF_GPF_TCPIP

	char	NameServer1[IPADDRESS_MAX_LEN+1];
	char	NameServer2[IPADDRESS_MAX_LEN+1];
	BOOL	PPGAuthentication;
	BOOL	WirelessProfiledHTTP;
#endif

} T_WAP_PROFILE;



#ifdef FF_GPF_TCPIP
//TISHMMS Project
typedef struct
{	
    char		MmscAddress[URL_MAX_LEN+1];					// The MMS address
    //UINT8_M4_E_IMAGE_SCALE_RULE_ENUM  ucImageScaleRule; //M4_E_IMAGE_SCALE_RULE
    //BOOL              bIsDeliverReportNeed;
    //BOOL              bIsReadReplyNeed; 
    //M_TRISTATE_OPTION    MmsHideOrigin;
    //MM_S_TIME_STAMP MmsExpiryTime;//liuyu how to implement it?
    
    //BOOL              bIsStoreSent;
    //BOOL              bIsPayForReply;
    //MM_E_PRIORITY  MmsPriority;
    //BOOL              bIsReportsAllowed;
} T_MMS_PROFILE;
#endif

/* WAP_ELEMENT_TYPE
 *
 * For buffering of WAP elements, specifies which of the four types an element is.
 */

typedef enum
{
	WAP_TEXT,
	WAP_FIELDSET,
	WAP_IMAGE,
	WAP_TABLE,
	WAP_BORDER			//kyle 29 Jun, 2005 MMI-SPR-32462
#ifdef FF_GPF_TCPIP
        ,
	WAP_PLUGIN_IMAGE//xrashmic 21 Jan, 2005 MMI-SPR-28223
#endif
} WAP_ELEMENT_TYPE;

/* T_WAP_ELEMENT
 *
 * To speed up redraws, the SEND_TEXT type events are buffered by the ATB.  This means that
 * WAP does not have to resend the entire card in the event of a redraw.  Each element is
 * stored as part of a chain, with a pointer to the next element in the chain.
 */
 
typedef struct WAP_ELEMENT
{
	WAP_ELEMENT_TYPE	type;
	void				*data;			/* Generic pointer to WAP_MMI_SEND_TEXT_IND etc */
	struct WAP_ELEMENT	*NextElement;
} T_WAP_ELEMENT;


/* T_WAP_VIEW
 *
 * Structure to hold view information.  Used to pass information between ATB and the UI.
 */

typedef struct WAP_VIEW
{
	UBYTE				object_id;				/* Object id, as used by GLE */
	UBYTE				channel;				/* channel, as used by AUS */
	UBYTE				ProfileId;				/* The id of the current profile */
	USHORT				browser_status;			/* Container of status flags. */
	T_WAP_PROFILE		*Profile;				/* Pointer to the current profile in RAM */
	T_WAP_LIST			*ProfilesList;			/* List of the names of all profiles in flash */
	#ifdef CO_UDP_IP
	UBYTE				Status;					/* Status flags (see above) */
	#endif
	BOOL				CanGoBack;				/* True if the user can go "back" from the card */
	char				*URL;					/* The current URL */
	USHORT				*Title;					/* The title of the current card. */
	BOOL				CustSoftKeys;			/* True if softkeys are customised */
	USHORT				CustSoftKeyId;			/* Id of customised softkey */
	USHORT				cardWidth;				/* The width in pixels of the current card */
	USHORT				cardHeight;				/* The height in pixels of the current card */
	USHORT				cardXPosition;			/* X displacement of the view of the card */
	USHORT				cardYPosition;			/* Y displacement of the view of the card */
	BOOL				acceptUpdate;			/* TRUE if we can draw to the card */
	void				*UIdata;				/* Generic pointer for use by the User Interface */
	T_WAP_ELEMENT		*ElementHeader;			/* Pointer to the first element in the existing element chain */
	T_WAP_ELEMENT		*NewElementHeader;		/*Pointer to element chain currently being built */
	struct WAP_VIEW		*NextView;				/* Pointer to next element in the view chain */
	T_WAP_LIST			*History;				/* History */
	T_WAP_LIST			*HistoryURL;
	T_WAP_LIST			*Bookmarks;				/* ...and bookmark list */
	T_WAP_LIST			*BookmarksURL;
	SHORT				cId;					/* Call ID of CSD connection */
	BOOL				secondaryIP;			/* TRUE if secondary IP has been used */
} T_WAP_VIEW;
#endif
