/*
+-----------------------------------------------------------------------------
|  Project :
|  Modul   :  J:\g23m-gsm\alr\alr_tim.c
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :
+-----------------------------------------------------------------------------
*/
#ifndef ALR_TIM_C
#define ALR_TIM_C

#define ENTITY_PL

/*==== INCLUDES ===================================================*/
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_alr.h"
#include "mon_alr.h"
#include "pei.h"
#include "tok.h"
#include "pcm.h"

#ifdef GPRS
#include "alr_gprs.h"
#endif

#include "alr.h"

/*==== PRIVAT =====================================================*/
#if defined(TIMER_TRACE)
  #define TRACE_TIMER(FMT)              TRACE_EVENT((FMT))
  #define TRACE_TIMER_P1(FMT,P1)        TRACE_EVENT_P1((FMT),(P1))
  #define TRACE_TIMER_P2(FMT,P1,P2)     TRACE_EVENT_P2((FMT),(P1),(P2))
  #define TRACE_TIMER_P3(FMT,P1,P2,P3)  TRACE_EVENT_P3((FMT),(P1),(P2),(P3))
#else
  #define TRACE_TIMER(FMT)
  #define TRACE_TIMER_P1(FMT,P1)
  #define TRACE_TIMER_P2(FMT,P1,P2)
  #define TRACE_TIMER_P3(FMT,P1,P2,P2)
#endif

static const char* const tim_names[] =
{
  "TIM_POWERMEAS",
  "TIM_NW_SYNC_GUARD",
#if defined(FF_HOMEZONE)
  "TIM_HOMEZONE",
#endif  /* FF_HOMEZONE */
  "???"
};

/*==== EXPORT =====================================================*/


/*==== FUCTIONS ===================================================*/
#if defined(TIMER_TRACE)
void  trace_timer (USHORT index, long value)
{
  switch(value)
  {
    default:/* >0: start */
      TRACE_TIMER_P2 ("T-Start:%s=%lu", tim_names[index], value);
      break;
    case 0:/* ==0: stop */
      TRACE_TIMER_P1 ("T-Stop:%s", tim_names[index]);
      break;
    case -1:/* -1: expire */
      TRACE_TIMER_P1 ("T-Expired:%s ", tim_names[index]);
      break;
    case -2:/* -2: check */
      TRACE_TIMER_P2 ("T-Check:%s %sactive", tim_names[index],
        alr_data->tim_data.running[index] ? "" : "in");
      break;
    case -3:/* -2: set expire function */
      TRACE_TIMER_P1 ("T-Set:%s expire function", tim_names[index]);
      break;
  }
}
#else
#define trace_timer(index,value)
#endif  /* TIMER_TRACE */

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : RR_TIM                   |
| STATE   : code                  ROUTINE : tim_exec_timeout         |
+--------------------------------------------------------------------+

  PURPOSE : reset timeout functions and values.

*/

GLOBAL void tim_init (void)
{
  TRACE_FUNCTION ("tim_init()");

  memset (&alr_data->tim_data, 0, sizeof (alr_data->tim_data));
  alr_data->tim_data.expire[TIM_POWERMEAS] = ma_cs_rxlev_req;
  alr_data->tim_data.expire[TIM_NW_SYNC_GUARD] = tim_stop_sync_to_nw;
#if defined(FF_HOMEZONE)
  alr_data->tim_data.expire[TIM_HOMEZONE] = cb_tim_homezone;
#endif /* FF_HOMEZONE */
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : RR_TIM                   |
| STATE   : code                  ROUTINE : tim_exec_timeout         |
+--------------------------------------------------------------------+

  PURPOSE : execute timeout for the new frame variant.

*/

GLOBAL void tim_exec_timeout (USHORT index)
{
#if !defined(TIMER_TRACE)
  TRACE_FUNCTION ("tim_exec_timeout()");
#endif  /* !TIMER_TRACE */

  if (index < NUM_OF_ALR_TIMERS)
  {
    trace_timer (index, -1);
    alr_data->tim_data.running[index] = 0;

    if (alr_data->tim_data.expire[index])
      alr_data->tim_data.expire[index] ();
  }
  else
  {
    SYST_TRACE_P ((SYST, "tim_exec_timeout: index=%u (>=%u)", index, NUM_OF_ALR_TIMERS));
    TRACE_ASSERT (index < NUM_OF_ALR_TIMERS);
  }
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : RR_TIM                   |
| STATE   : code                  ROUTINE : tim_stop_timer           |
+--------------------------------------------------------------------+

  PURPOSE : stop timer in the new frame variant.

*/

GLOBAL void tim_stop_timer (USHORT index)
{
#if !defined(TIMER_TRACE)
  TRACE_FUNCTION ("tim_stop_timer()");
#endif  /* !TIMER_TRACE */

  if (index < NUM_OF_ALR_TIMERS)
  {
    trace_timer (index, 0);
    alr_data->tim_data.running[index] = 0;

    /*
     * stop physical timer.
     */
    vsi_t_stop (VSI_CALLER index);
  }
  else
  {
    SYST_TRACE_P ((SYST,"tim_stop_timer: index=%u (>=%u)", index, NUM_OF_ALR_TIMERS));
    TRACE_ASSERT (index < NUM_OF_ALR_TIMERS);
  }
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : RR_TIM                   |
| STATE   : code                  ROUTINE : tim_start_timer          |
+--------------------------------------------------------------------+

  PURPOSE : start timer in the new frame variant.

*/

GLOBAL void tim_start_timer (USHORT index, T_TIME value)
{
#if !defined(TIMER_TRACE)
  TRACE_FUNCTION ("tim_start_timer()");
#endif  /* !TIMER_TRACE */

  if (index < NUM_OF_ALR_TIMERS)
  {
    trace_timer (index, value);
    alr_data->tim_data.running[index] = 1;

    /*
     * start physical timer.
     */
    vsi_t_start (VSI_CALLER index, value);
  }
  else
  {
    SYST_TRACE_P ((SYST,"tim_start_timer: index=%u (>=%u)", index, NUM_OF_ALR_TIMERS));
    TRACE_ASSERT (index < NUM_OF_ALR_TIMERS);
  }
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : RR_TIM                   |
| STATE   : code                  ROUTINE : tim_check_timer          |
+--------------------------------------------------------------------+

  PURPOSE : check timer in the new frame variant.

*/
GLOBAL BOOL tim_check_timer(USHORT index)
{
  T_TIME value = 0;

#if !defined(TIMER_TRACE)
  TRACE_FUNCTION ("tim_check_timer()");
#endif  /* !TIMER_TRACE */

  if (index < NUM_OF_ALR_TIMERS)
  {
#if defined(TIMER_TRACE)
    if (alr_data->tim_data.running[index])
    {
      SHORT vsi_ret;
      vsi_ret = vsi_t_status(VSI_CALLER index, &value);
      if ((vsi_ret EQ VSI_OK) AND (value NEQ 0))
      {
        TRACE_TIMER_P2 ("T-Check:%s active (%u left)", tim_names[index], value);
      }
      else
      {
        TRACE_TIMER_P1 ("T-Check:%s inactive", tim_names[index]);
      }
    }
    else
    {
      TRACE_TIMER_P1 ("T-Check:%s inactive", tim_names[index]);
    }
#endif  /* TIMER_TRACE */

    return alr_data->tim_data.running[index];
  }
  else
  {
    SYST_TRACE_P ((SYST,"tim_check_timer: index=%u (>=%u)", index, NUM_OF_ALR_TIMERS));
    TRACE_ASSERT (index < NUM_OF_ALR_TIMERS);
    return FALSE;
  }
}

#endif  /* ALR_TIM_C */

