#include "alr_constraints.h"
#include "alr_ncell_steps.h"

/*------------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested. The multiframe
 *              period is set to two multiframes. It is expected that the
 *              initial report to RR is send after eleven reports of layer 1
 *              and successive reports are send to RR after ten reports.
 *              The number of TDMA frames between measurement reports to RR is
 *              102 TDMA frames which is equal to two multiframes.
 *-------------------------------------------------------------------------------*/
T_STEP meas_rep_bs_pa_mfrms_2()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=2")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_1()     );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_2()     );
  }
}

/*-------------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested. The multiframe
 *              period is set to three multiframes. It is expected that the initial
 *              report to RR is send after eight reports of layer 1 and successive
 *              reports are send to RR after seven reports. The number of TDMA frames
 *              between measurement reports to RR is 153 TDMA frames which is equal to
 *              three multiframes.
 *-------------------------------------------------------------------------------*/
T_STEP meas_rep_bs_pa_mfrms_3()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=3")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_3()     );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_4()     );
  }
}

/*--------------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested. The multiframe
 *              period is set to four multiframes. It is expected that the initial
 *              report to RR is send after six reports of layer 1 and successive
 *              reports are send to RR after five reports. The number of TDMA frames
 *              between measurement reports to RR is 204 TDMA frames which is
 *              equal to four multiframes.
 *-------------------------------------------------------------------------------*/
T_STEP meas_rep_bs_pa_mfrms_4()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=4")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_1()     );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_5()     );
  }
}

/*------------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested.
 *              The multiframe period is set to five multiframes. It is expected
 *              that the initial  report to RR is send after five reports of
 *              layer 1 and successive  reports are send to RR after four reports.
 *              The number of TDMA frames between measurement reports to RR is
 *              255 TDMA frames which is equal to five multiframes.
 *-------------------------------------------------------------------------------*/

T_STEP meas_rep_bs_pa_mfrms_5()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=5")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_1()     );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_6()     );
  }
}


/*-----------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested. The multiframe
 *              period is set to six multiframes. It is expected that the initial
 *              report to RR is send after five reports of layer 1 and successive
 *              reports are send to RR after three reports. The number of TDMA frames
 *              between measurement reports to RR is 306 TDMA frames which is equal
 *              to six multiframes.
 *-------------------------------------------------------------------------------*/
T_STEP meas_rep_bs_pa_mfrms_6()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=6")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_7()     );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_8()     );
  }
}

/*---------------------------------------------------------------------------------
 *
 * Description:	Measurement reporting for the serving cell is tested. The multiframe
 *              period is set to eight multiframes. It is expected that the initial
 *              report to RR is send after five reports of layer 1 and successive
 *              reports are send to RR after two reports. The number of TDMA frames
 *              between measurement reports to RR is 408 TDMA frames which is equal to
 *              eight multiframes.
 *-------------------------------------------------------------------------------*/
T_STEP meas_rep_bs_pa_mfrms_8()
{
  BEGIN_STEP ("measurement reporting bs_pa_mfrms=8")
  {
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_10()    );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    SEND  ( mphc_rxlev_periodic_ind_1() );
    AWAIT ( mph_measurement_ind_11()    );
  }
}


/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in idle 
 *              mode is effected by sending (42/bs_pa_mfrms) measurement reports.
 *              This function sends (count*3) number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_idle_2_14(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in idle mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_rxlev_periodic_ind_2() );
      SEND  ( mphc_rxlev_periodic_ind_2() );
      SEND  ( mphc_rxlev_periodic_ind_2() );
      AWAIT ( mph_measurement_ind_14()    );
    }
    SEND    ( mphc_rxlev_periodic_ind_2() );
    SEND    ( mphc_rxlev_periodic_ind_2() );
    SEND    ( mphc_rxlev_periodic_ind_2() );
  }
}

/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in idle 
 *              mode is effected by sending (42/bs_pa_mfrms) measurement reports.
 *              This function sends (count*2) number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_idle_2_31(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in idle mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_rxlev_periodic_ind_2() );
      SEND  ( mphc_rxlev_periodic_ind_2() );
      AWAIT ( mph_measurement_ind_31()    );
    }
    SEND    ( mphc_rxlev_periodic_ind_2() );
    SEND    ( mphc_rxlev_periodic_ind_2() );
  }
}

/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in idle 
 *              mode is effected by sending (42/bs_pa_mfrms) measurement reports.
 *              This function sends (count*3) number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_idle_3_33(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in idle mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_rxlev_periodic_ind_3() );
      SEND  ( mphc_rxlev_periodic_ind_3() );
      SEND  ( mphc_rxlev_periodic_ind_3() );
      AWAIT ( mph_measurement_ind_33()    );
    }
    SEND    ( mphc_rxlev_periodic_ind_3() );
    SEND    ( mphc_rxlev_periodic_ind_3() );
    SEND    ( mphc_rxlev_periodic_ind_3() );
  }
}

/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_meas_report_4()     );
      AWAIT ( mph_measurement_ind_34() );
    }
    SEND    ( mphc_meas_report_4()     );
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated_102(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_meas_report_4()     );
      AWAIT ( mph_measurement_ind_dummy(ARFCN_23,25)  );
    }
    SEND    ( mphc_meas_report_4()     );
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated_102a(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_meas_report_5()     );
      AWAIT ( mph_measurement_ind_dummy(ARFCN_23,25)  );
    }
    SEND    ( mphc_meas_report_5()     );
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated_102b(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_meas_report_6()     );
      AWAIT ( mph_measurement_ind_dummy(ARFCN_23,25)  );
    }
    SEND    ( mphc_meas_report_6()     );
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated_102c(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  ( mphc_meas_report_6a()     );
      AWAIT ( mph_measurement_ind_dummy(ARFCN_23,25)  );
    }
    SEND    ( mphc_meas_report_6a()     );
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description: The 10 seconds interval for next ncell synchronization in dedicated 
 *              mode is effected by sending 21 measurement reports. This function sends 
 *              'count' number of measurement reports.
 *-------------------------------------------------------------------------------*/
T_STEP wait_ncsync_dedicated_1020A(int count)
{
  BEGIN_STEP ("wait for ncsync expiry in dedicated mode alr1020A")
  {
    int i;
    for( i=1 ; i<count ; i++ )
    {
      SEND  (mphc_meas_report_4a()                     );
      AWAIT ( mph_measurement_ind_dummy(ARFCN_23,0x19) );
    }
    SEND    ( mphc_meas_report_4a()     );
  }
}

/*------------------------------------------------------------------------------
 *
 * Description:	The BA list contains the serving cell 23 and
 *              the neighbour cells 1, 14 and 124.
 *              The fieldstrength is 56 for channel 23, 12 for channel 1,
 *              44 for channel 14 and 25 for channel 124 (all values in GSM range).
 *              The ranking for the neighbour cells is 14, 124 and at least channel 1.
 *              Each reports contains two fieldstrength values per channel.
 *              The multiframe period is set to 6. The first measurement report
 *              is send to RR after five reports from PL. Then after each
 *              three reports from PL a measurement report is send to RR.
 *              Synchronisation to channel 14 fails.
 *-------------------------------------------------------------------------------*/

T_STEP sync_to_ncell_14_fails_once()
{
  BEGIN_STEP ("sync to ncell 14 failes once")
  {
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
      AWAIT ( mphc_ncell_sync_req_initial(ARFCN_124)       );
      AWAIT ( mphc_ncell_sync_req_initial(ARFCN_1)       );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_13()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind_failed(ARFCN_14)       );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind(ARFCN_124,FN_OFF_ARFCN_124,TIME_ALIGNMT_124,BSIC_1)       );
      AWAIT ( mphc_ncell_bcch_req (ARFCN_124, FN_OFF_ARFCN_124, TIME_ALIGNMT_124));
      SEND  ( mphc_ncell_sync_ind_3()       );
      AWAIT ( mphc_ncell_bcch_req (ARFCN_1, FN_OFF_ARFCN_1, TIME_ALIGNMT_1)       );
      SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_1)       );
      AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_1)  );
      SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_124)       );
      AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_124)  );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_15()      );
      AWAIT ( mph_unitdata_ind_si3(ARFCN_1)          );
      AWAIT ( mph_unitdata_ind_si3(ARFCN_124)          );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
      AWAIT ( mph_measurement_ind_15()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind (ARFCN_14)       );
      AWAIT ( mphc_ncell_bcch_req (ARFCN_14)       );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_15()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)       );
      AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14)  );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      AWAIT ( mph_unitdata_ind_si3(ARFCN_14)          );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mphc_ncell_list_sync_req_1a() );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind(ARFCN_124,FN_OFF_ARFCN_124,TIME_ALIGNMT_124,BSIC_1)       );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind_3()       );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      SEND  ( mphc_ncell_sync_ind (ARFCN_14)       );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
      AWAIT ( mph_measurement_ind_14()      );
      SEND  ( mphc_rxlev_periodic_ind_2()   );
  }
}
/*------------------------------------------------------------------------------
 *
 * Description: ALR requests successive reading of BCCH for all neighbour cells.
 *              This failed for channel 14.
 *-------------------------------------------------------------------------------*/
T_STEP ncell_bcch_read_fails_for_ncell_14()
{
  BEGIN_STEP ("ncell BCCH read fails for ncell 14")
  {
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_124)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_1)      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_13()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)      );
    SEND  ( mphc_ncell_bcch_ind_invalid(ARFCN_14)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)      );
    SEND  ( mphc_ncell_bcch_ind_invalid(ARFCN_14)      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)      );
    SEND  ( mphc_ncell_bcch_ind_invalid(ARFCN_14)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)      );
    SEND  ( mphc_ncell_bcch_ind_invalid(ARFCN_14)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_16()     );
    SEND  ( mphc_ncell_sync_ind(ARFCN_124,FN_OFF_ARFCN_124,TIME_ALIGNMT_124,BSIC_1)      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_sync_ind_5()      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_124, FN_OFF_ARFCN_124, TIME_ALIGNMT_124));
    AWAIT ( mphc_ncell_bcch_req (ARFCN_1, FN_OFF_ARFCN_1, TIME_ALIGNMT_1)      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mphc_ncell_sync_req_1a()     );
    AWAIT ( mph_measurement_ind_16()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_124)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_124) );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_1)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_1) );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_15()     );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_1)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_124)         );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)      );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_14()     );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)         );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_14()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_14()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mphc_ncell_list_sync_req_1a());
  }
}
/*------------------------------------------------------------------------------
 *
 * Description:	The multiband parameter is set to 0, that means the neighbourcells
 *              are ranked after the fieldstrength. The serving cell is 23
 *              (that means in the GSM 900 frequency band). The neighbourcell list
 *              contains eight channels : 1, 14, 25, 124, 512 580, 637 and 885.
 *              It is expected, that ALR starts synchronization to the six
 *              strongest cells 637, 25, 14, 512, 580, 885. This channels must
 *              be included in the measurement report to RR.
 *-------------------------------------------------------------------------------*/
T_STEP ncell_reporting_multiband_0_scell_is_gsm900()
{
  BEGIN_STEP("ncell: multiband 0/scell is gsm900")
  {
    START_TIMEOUT(29500);
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_637)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_25)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_512)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_580)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_885)      );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    AWAIT ( mph_measurement_ind_7()       );
    SEND  ( mphc_ncell_sync_ind_12()      );
    AWAIT ( mphc_ncell_bcch_req_10()      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_25)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_25)      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)       );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)       );
    SEND  ( mphc_ncell_sync_ind (ARFCN_512)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_512)      );
    SEND  ( mphc_ncell_sync_ind_15()      );
    AWAIT ( mphc_ncell_bcch_req_13()      );
    SEND  ( mphc_ncell_sync_ind_16()      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_885)      );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_637)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_637)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_25)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_25)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_512)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_512)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_580)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_580) );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_885)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_885) );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    AWAIT ( mph_measurement_ind_21()      );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)          );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_25)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_512)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_580)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_637)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_885)         );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    SEND  ( mphc_rxlev_periodic_ind_3()   );
    AWAIT ( mph_measurement_ind_21()      );
    SEND  ( mphc_ncell_sync_ind(ARFCN_124,FN_OFF_ARFCN_124,TIME_ALIGNMT_124,BSIC_1)       );
    WAIT_TIMEOUT();
  }
}
/*---------------------------------------------------------------------------------
 *
 * Description:	The multiband parameter is set to 0, that means the neighbourcells
 *              are ranked after the fieldstrength. The serving cell is 578
 *              (that means in the DCS 1800 frequency band). The neighbourcell list
 *              contains eight channels : 1, 14, 25, 124, 512 580, 637 and 885. It is
 *              expected, that ALR starts synchronization to the six strongest cells
 *              14, 25, 512, 580, 637, 885. These channels must be included in
 *              the measurement report to RR.
 *-------------------------------------------------------------------------------*/
T_STEP ncell_reporting_multiband_0_scell_is_gsm1800()
{
  BEGIN_STEP("ncell: multiband 0/scell is gsm1800")
  {
    START_TIMEOUT(29500);
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_637)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_25)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_512)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_580)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_885)      );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    AWAIT ( mph_measurement_ind_22()      );
    SEND  ( mphc_ncell_sync_ind_12()      );
    AWAIT ( mphc_ncell_bcch_req_10()      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_25)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_25)      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)       );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)       );
    SEND  ( mphc_ncell_sync_ind (ARFCN_512)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_512)      );
    SEND  ( mphc_ncell_sync_ind_15()      );
    AWAIT ( mphc_ncell_bcch_req_13()      );
    SEND  ( mphc_ncell_sync_ind_16()      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_885)      );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_637)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_637)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_25)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_25)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_512)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_512)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_580)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_580) );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_885)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_885) );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    AWAIT ( mph_measurement_ind_23()      );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)          );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_25)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_512)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_580)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_637)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_885)         );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    SEND  ( mphc_rxlev_periodic_ind_4()   );
    AWAIT ( mph_measurement_ind_23()      );
    WAIT_TIMEOUT();
  }
}
/*------------------------------------------------------------------------------
 *
 * Description:	The BA list contains the serving cell 23 and the
 *              neighbour cells 1, 14 and 124.
 *              The fieldstrength is 56 for channel 23, 12 for channel 1,
 *              44 for channel 14 and 25 for channel 124 (all values in GSM range).
 *              The ranking for the neighbour cells is 14, 124 and channel 1.
 *              Each reports contains two fieldstrength values per channel.
 *              The multiframe period is set to 6. The first measurement report
 *              is send to RR after five reports from PL. Then after each three
 *              reports from PL a measurement report is send to RR. The NCC permitted
 *              check for neighbour cell 124 fails. The cell shall be excluded
 *              from further attempts.
 *-------------------------------------------------------------------------------*/

T_STEP ncell_sync_ncc_permitted_check()
{
  BEGIN_STEP ("ncell sync, NCC is not permitted for ncell 124")
  {
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_124)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_1)      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_13()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_sync_ind(ARFCN_14,FN_OFF_ARFCN_14,TIME_ALIGNMT_14,BSIC_16)      );
    AWAIT ( mphc_ncell_bcch_req_4()      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_sync_ind(ARFCN_124,FN_OFF_ARFCN_124,TIME_ALIGNMT_124,BSIC_1)      );
    SEND  ( mphc_ncell_sync_ind(ARFCN_1,FN_OFF_ARFCN_1,TIME_ALIGNMT_1,BSIC_16)      );
    AWAIT ( mphc_ncell_bcch_req_5()      );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_16()     );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14) );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_1)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_1) );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );

    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_124)      );

    AWAIT ( mph_measurement_ind_17()     );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_1)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)         );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    SEND  ( mphc_rxlev_periodic_ind_2()  );
    AWAIT ( mph_measurement_ind_17()     );
  }
}
/*------------------------------------------------------------------------------
 *
 * Description:	The multiband parameter is set to 1, that means at least one of
 *              the neighbourcells is member of the non-serving cell band
 *              (that means in the DCS 1800 frequency band). The serving cell
 *              is 23 (that means in the GSM 900 frequency band). The neighbourcell
 *              list contains eight channels : 1, 11, 14, 25,87, 124, 512 and 885.
 *              It is expected, that ALR starts synchronization to the six
 *              cells 14, 87, 25, 11, 1 and 512. This channels must be included
 *              in the measurement report to RR. ALR shall not synchronize to 885,
 *              although the cell has a better fieldstrength than most channels
 *              of the GSM 900 frequency band.
 *-------------------------------------------------------------------------------*/
T_STEP ncell_reporting_multiband_1_scell_is_gsm900()
{
  BEGIN_STEP("ncell: multiband 1/scell is gsm900")
  {
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_25)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_512)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_11)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_87)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_124)      );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    AWAIT ( mph_measurement_ind_13()                    );
    SEND  ( mphc_ncell_sync_ind (ARFCN_25)              );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_25)              );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)              );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)              );
    SEND  ( mphc_ncell_sync_ind (ARFCN_512)             );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_512)             );
    SEND  ( mphc_ncell_sync_ind (ARFCN_11)              );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_11)              );
    SEND  ( mphc_ncell_sync_ind (ARFCN_87)              );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_87)              );
    SEND  ( mphc_ncell_sync_ind (ARFCN_124)             );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_124)             );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_25)           );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_25)          );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)           );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14)          );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_512)          );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_512)         );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_11)           );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_11)          );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_87)           );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_87)          );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_124)          );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_124)         );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    AWAIT ( mph_measurement_ind_24()                    );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_11)              );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)              );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_25)              );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_87)              );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_124)             );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_512)             );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    SEND  ( mphc_rxlev_periodic_ind_5()                 );
    AWAIT ( mph_measurement_ind_24()                    );
  }
}


T_STEP ncell_reporting_multiband_1_scell_is_gsm900_4ch()
{
  BEGIN_STEP("ncell: multiband 1/scell is gsm900 4ch")
  {
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_14)       );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_512)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_885)      );
    AWAIT ( mphc_ncell_sync_req_initial(ARFCN_1)       );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    AWAIT ( mph_measurement_ind_13()      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_14)       );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_14)       );
    SEND  ( mphc_ncell_sync_ind (ARFCN_512)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_512)      );
    SEND  ( mphc_ncell_sync_ind_16()      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_885)      );
    SEND  ( mphc_ncell_sync_ind (ARFCN_1)      );
    AWAIT ( mphc_ncell_bcch_req (ARFCN_1)      );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_14)       );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_14)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_512)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_512)  );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_885)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_885) );
    SEND  ( mphc_ncell_bcch_ind_si3(ARFCN_1)      );
    AWAIT ( mphc_stop_ncell_bcch_req(ARFCN_1)  );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    AWAIT ( mph_measurement_ind_25()      );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_1)          );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_14)          );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_512)         );
    AWAIT ( mph_unitdata_ind_si3(ARFCN_885)         );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    SEND  ( mphc_rxlev_periodic_ind_6()   );
    AWAIT ( mph_measurement_ind_25()      );
  }
}
