/*
  +------------------------------------------------------------------------------
  |  File:       alr_ncell_constraints.cpp
  +------------------------------------------------------------------------------
  |              Copyright 2003 Texas Instruments
  |              All rights reserved.
  |
  |              This file is confidential and a trade secret of Texas Instruments.
  |              The receipt of or possession of this file does not convey
  |              any rights to reproduce or disclose its contents or to
  |              manufacture, use, or sell anything it may describe, in
  |              whole, or in part, without the specific written consent of
  |              Texas Instruments.
  +------------------------------------------------------------------------------
  | Purpose:     Contains test constraints for alr
  |
  +------------------------------------------------------------------------------
*/
#include "alr_constraints.h"

#define OTD_30            30
#define TDMA_FRAMES_PER_HYPERFRAME  2715648
#define ARFCN_1_RXLEVEL     11
#define ARFCN_11_RXLEVEL    22
#define ARFCN_14_RXLEVEL    44
#define ARFCN_23_RXLEVEL    30
#define ARFCN_25_RXLEVEL    55
#define ARFCN_87_RXLEVEL    21
#define ARFCN_124_RXLEVEL   12
#define ARFCN_512_RXLEVEL   43
#define ARFCN_580_RXLEVEL   25
#define ARFCN_637_RXLEVEL   56
#define ARFCN_885_RXLEVEL   25


const U16 CHLIST_1_14_124_FFFF_elements[4] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_124,
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_1_14_124_FFFF(CHLIST_1_14_124_FFFF_elements, SKIP_TO_END);

const U16 CHLIST_1_11_15_20_24_25_26_FFFF_elements[8] = {
  ARFCN_1,
  ARFCN_11,
  ARFCN_15,
  ARFCN_20,
  ARFCN_24,
  ARFCN_25,
  ARFCN_26,
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_1_11_15_20_24_25_26_FFFF(CHLIST_1_11_15_20_24_25_26_FFFF_elements, SKIP_TO_END);

const U16 RF_23_1_14_124_elements[4] = {
  ARFCN_23,
  ARFCN_1,
  ARFCN_14,
  ARFCN_124
};
T_ARRAY<U16> RF_23_1_14_124(RF_23_1_14_124_elements, SKIP_TO_END);

const U16 RF_1_14_124_elements[3] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_124
};
T_ARRAY<U16> RF_1_14_124(RF_1_14_124_elements, SKIP_TO_END);

const U16 CHLIST_23_1_124_FFFF_elements[4] = {
  ARFCN_23,
  ARFCN_1,
  ARFCN_124,
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_23_1_124_FFFF(CHLIST_23_1_124_FFFF_elements, SKIP_TO_END);

const U16 CHLIST_512_637_885_FFFF_elements[4] = {
  ARFCN_512,
  ARFCN_637,
  ARFCN_885,
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_512_637_885_FFFF(CHLIST_512_637_885_FFFF_elements, SKIP_TO_END);

const U16 EMPTY_NCELL_LIST_elements[1] = {
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> EMPTY_NCELL_LIST(EMPTY_NCELL_LIST_elements, SKIP_TO_END);

const U16 RF_23_elements[1] = {
  ARFCN_23
};
T_ARRAY<U16> RF_23(RF_23_elements, SKIP_TO_END);

const U16 RF_1_14_25_124_512_580_637_885_23_elements[9] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_25,
  ARFCN_124,
  ARFCN_512,
  ARFCN_580,
  ARFCN_637,
  ARFCN_885,
  ARFCN_23
};
T_ARRAY<U16> RF_1_14_25_124_512_580_637_885_23(RF_1_14_25_124_512_580_637_885_23_elements, SKIP_TO_END);

const U16 RF_DEDI_LARGE_1_elements[14] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_24,
  ARFCN_30,
  ARFCN_34,
  ARFCN_40,
  ARFCN_42,
  ARFCN_46,
  ARFCN_23,
  ARFCN_124,
  ARFCN_52,
  ARFCN_59,
  ARFCN_66,
  ARFCN_73
};
T_ARRAY<U16> RF_DEDI_LARGE_1(RF_DEDI_LARGE_1_elements, SKIP_TO_END);

const U16 RF_DEDI_LARGE_2_elements[24] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_24,
  ARFCN_30,
  ARFCN_34,
  ARFCN_40,
  ARFCN_42,
  ARFCN_46,
  ARFCN_23,
  ARFCN_124,
  ARFCN_52,
  ARFCN_59,
  ARFCN_66,
  ARFCN_73,
  ARFCN_580,
  ARFCN_581,
  ARFCN_582,
  ARFCN_583,
  ARFCN_584,
  ARFCN_585,
  ARFCN_586,
  ARFCN_587,
  ARFCN_588,
  ARFCN_589,
};
T_ARRAY<U16> RF_DEDI_LARGE_2(RF_DEDI_LARGE_2_elements, SKIP_TO_END);

const U16 RF_AFTER_HO_LARGE_1_elements[11] = {
  ARFCN_580,
  ARFCN_581,
  ARFCN_582,
  ARFCN_583,
  ARFCN_584,
  ARFCN_595,
  ARFCN_596,
  ARFCN_597,
  ARFCN_23,
  ARFCN_598,
  ARFCN_599,
};
T_ARRAY<U16> RF_AFTER_HO_LARGE_1(RF_AFTER_HO_LARGE_1_elements, SKIP_TO_END);

const U16 RF_AFTER_HO_LARGE_2_elements[24] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_23,
  ARFCN_24,
  ARFCN_34,
  ARFCN_40,
  ARFCN_42,
  ARFCN_74,
  ARFCN_582,
  ARFCN_87,
  ARFCN_124,
  ARFCN_580,
  ARFCN_581,
  ARFCN_583,
  ARFCN_584,
  ARFCN_595,
  ARFCN_596,
  ARFCN_598,
  ARFCN_599,
  ARFCN_597,
  ARFCN_75,
  ARFCN_76,
  ARFCN_80
};
T_ARRAY<U16> RF_AFTER_HO_LARGE_2(RF_AFTER_HO_LARGE_2_elements, SKIP_TO_END);

const U16 CHLIST_14_25_512_580_637_885_elements[6] = {
  ARFCN_14,
  ARFCN_25,
  ARFCN_512,
  ARFCN_580,
  ARFCN_637,
  ARFCN_885
};
T_ARRAY<U16> CHLIST_14_25_512_580_637_885(CHLIST_14_25_512_580_637_885_elements, SKIP_TO_END);

const U8 NCELLS_SC_900_8_RXLEVS_elements[6] = {
  ARFCN_14_RXLEVEL,
  ARFCN_25_RXLEVEL,
  ARFCN_512_RXLEVEL,
  ARFCN_580_RXLEVEL,
  ARFCN_637_RXLEVEL,
  ARFCN_885_RXLEVEL
};
T_ARRAY<U8> NCELLS_SC_900_8_RXLEVS(NCELLS_SC_900_8_RXLEVS_elements, SKIP_TO_END);


const U8 NCELLS_SC_900_8_BSICS_elements[6] = {
  1, 1, 1, 1, 1, 1
};
T_ARRAY<U8> NCELLS_SC_900_8_BSICS(NCELLS_SC_900_8_BSICS_elements, SKIP_TO_END);

const U32 NCELLS_SC_900_8_TA_elements[6] = {
  TIME_ALIGNMT_14,
  TIME_ALIGNMT_14,
  TIME_ALIGNMT_14,
  TIME_ALIGNMT_14,
  TIME_ALIGNMT_14,
  TIME_ALIGNMT_14
};
T_ARRAY<U32> NCELLS_SC_900_8_TA(NCELLS_SC_900_8_TA_elements, SKIP_TO_END);

const U32 NCELLS_SC_900_8_FO_elements[6] = {
  FN_OFF_ARFCN_14,
  FN_OFF_ARFCN_14,
  FN_OFF_ARFCN_14,
  FN_OFF_ARFCN_14,
  FN_OFF_ARFCN_14,
  FN_OFF_ARFCN_14
};
T_ARRAY<U32> NCELLS_SC_900_8_FO(NCELLS_SC_900_8_FO_elements, SKIP_TO_END);

const U32 NCELLS_SC_900_8_FO_EOTD_elements[6] = {
  FN_OFFSET_224,
  FN_OFFSET_102,
  FN_OFFSET_153,
  FN_OFFSET_204,
  FN_OFF_ARFCN_14,
  FN_OFFSET_255
};
T_ARRAY<U32> NCELLS_SC_900_8_FO_EOTD(NCELLS_SC_900_8_FO_EOTD_elements, SKIP_TO_END);

const U16 CHLIST_1_14_512_885_elements[4] = {
  ARFCN_1,
  ARFCN_14,
  ARFCN_512,
  ARFCN_885
};
T_ARRAY<U16> CHLIST_1_14_512_885(CHLIST_1_14_512_885_elements, SKIP_TO_END);


const U16 EOTD_CROSSCOR_6[18] = {
  0x01FF, 0x00FF, 0x007F, 0x003F, 0x001F, 0x000F, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000
};
const U16 EOTD_CROSSCOR_9[18] = {
  0x000F, 0x07FF, 0x001F, 0x007F, 0x003F, 0x00FF, 0x03FF, 0x01FF,
  0x0FFF, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000
};
const U16 EOTD_CROSSCOR_12[18] = {
  0x000F, 0x001F, 0x003F, 0x007F, 0x00FF, 0x01FF, 0x03FF, 0x07FF,
  0x0FFF, 0x1FFF, 0x3FFF, 0x7FFF, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000
};
const U16 RADIO_FREQ_100[33] = {
	1,46,47,124,23,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0
};
T_ARRAY<T_res_list> res_list_100()
{
  T_res_list array[33];

  array[0]->bcch_freq      = CONST_1;
  array[0]->rxlev_acc      = CONST_30;
  array[0]->rxlev_nbr_meas = CONST_1;

  array[1]->bcch_freq      = CONST_46;
  array[1]->rxlev_acc      = CONST_6;
  array[1]->rxlev_nbr_meas = CONST_1;

  array[2]->bcch_freq      = CONST_47;
  array[2]->rxlev_acc      = CONST_53;
  array[2]->rxlev_nbr_meas = CONST_1;

  array[3]->bcch_freq      = CONST_124;
  array[3]->rxlev_acc      = CONST_13;
  array[3]->rxlev_nbr_meas = CONST_1;

  array[4]->bcch_freq      = CONST_23;
  array[4]->rxlev_acc      = CONST_1;
  array[4]->rxlev_nbr_meas = CONST_1;
  for(int i=5;i<BA_LIST_SIZE;i++) {
    array[i]->bcch_freq      ._skip;
    array[i]->rxlev_acc      ._skip;
    array[i]->rxlev_nbr_meas ._skip;
  }

  return array;
}

T_ncells ncells_sc_900_8()
{
  T_ncells pstruct;
  pstruct->no_of_ncells = 6;
  pstruct->arfcn = CHLIST_14_25_512_580_637_885;
  pstruct->rx_lev = NCELLS_SC_900_8_RXLEVS;
  pstruct->bsic = NCELLS_SC_900_8_BSICS;
  pstruct->time_alignmt = NCELLS_SC_900_8_TA;
  pstruct->frame_offset = NCELLS_SC_900_8_FO;
  return pstruct;
}
T_ncells ncells_no_content()
{
  T_ncells pstruct;
  pstruct->no_of_ncells=0;
  pstruct->arfcn._skip;/*or _skip test this*/
  pstruct->rx_lev._skip;
  pstruct->bsic._skip;
  pstruct->time_alignmt._skip;
  pstruct->frame_offset._skip;
  return pstruct;
}
T_ncells ncells_no_content_skip()
{
  T_ncells pstruct;
  pstruct->no_of_ncells._skip;
  pstruct->arfcn._skip;
  pstruct->rx_lev._skip;
  pstruct->bsic._skip;
  pstruct->time_alignmt._skip;
  pstruct->frame_offset._skip;
  return pstruct;
}
T_ncells ncells_1_14_124()
{
  const U16 CHLIST_1_14_124_elements[3] = {
 	  ARFCN_1,
	  ARFCN_14,
	  ARFCN_124
  };
  T_ARRAY<U16> CHLIST_1_14_124(CHLIST_1_14_124_elements, SKIP_TO_END);
  const U8 NCELLS_1_14_124_RXLEVS_elements[3] = {
 	  12,44,25
  };
  T_ARRAY<U8> NCELLS_1_14_124_RXLEVS(NCELLS_1_14_124_RXLEVS_elements, SKIP_TO_END);

  const U8 NCELLS_1_14_124_BSICS_elements[3] = {
 	  1,1,1
  };
  T_ARRAY<U8> NCELLS_1_14_124_BSICS(NCELLS_1_14_124_BSICS_elements, SKIP_TO_END);

 #if 0
  const U32 NCELLS_1_14_124_TA[32] = {
 	  1,14,124,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
  };
  const U32 NCELLS_1_14_124_FO[32] = {
 	  0x65,0x72,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00
  };
  #else
  const U32 NCELLS_1_14_124_TA_elements[3] = {
 	  1,14,124
  };
  T_ARRAY<U32> NCELLS_1_14_124_TA(NCELLS_1_14_124_TA_elements, SKIP_TO_END);
  const U32 NCELLS_1_14_124_FO_elements[3] = {
 	  0x65,0x72,0xE0
  };
  T_ARRAY<U32> NCELLS_1_14_124_FO(NCELLS_1_14_124_FO_elements, SKIP_TO_END);
  #endif //0|1

  T_ncells pstruct;
  pstruct->no_of_ncells = NO_OF_CELLS_3;
  pstruct->arfcn = CHLIST_1_14_124;
  pstruct->rx_lev = NCELLS_1_14_124_RXLEVS;
  pstruct->bsic = NCELLS_1_14_124_BSICS;
  pstruct->time_alignmt = NCELLS_1_14_124_TA;
  pstruct->frame_offset = NCELLS_1_14_124_FO;
  return pstruct;
}

T_ncell_eotd arfcn_23_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_23;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_637_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_637;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_25_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_25;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_14_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_14;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_512_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_512;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_580_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_580;
  pstruct->bsic = BSIC_1;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_ncell_eotd arfcn_885_eotd()
{
  T_ncell_eotd pstruct;
  pstruct->arfcn = ARFCN_885;
  pstruct->bsic = BSIC_2;
  pstruct->mfrm_offset = MFRM_OFFSET_44;
  pstruct->otd_type = EXPECTED_OTD;
  pstruct->exp_otd = OTD_666;
  pstruct->uncertainty = UNC_MAX_2BIT;
  pstruct->rough_rtd = OTD_666;
  return pstruct;
}
T_eotd_sc_res eotd_sc_res_ok()
{
  T_eotd_sc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_23;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_12;
  pstruct->d_eotd_nrj = RSSI_61440;
  pstruct->time_tag = NOM_POS_1000;
  return pstruct;
}
T_eotd_sc_res1 eotd_sc_res1_ok()
{
  T_eotd_sc_res1 pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_23;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_12;
  pstruct->d_eotd_nrj = RSSI_61440;
  pstruct->time_tag = NOM_POS_2000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_637()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_637;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_9;
  pstruct->d_eotd_nrj = RSSI_61952;
  pstruct->time_tag = NOM_POS_2000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_25()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_25;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_6;
  pstruct->d_eotd_nrj = RSSI_61440;
  pstruct->time_tag = NOM_POS_2000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_14()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_14;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_9;
  pstruct->d_eotd_nrj = RSSI_61952;
  pstruct->time_tag = NOM_POS_1000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_512()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_512;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_6;
  pstruct->d_eotd_nrj = RSSI_61440;
  pstruct->time_tag = NOM_POS_2000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_580()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_1;
  pstruct->arfcn = ARFCN_580;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_9;
  pstruct->d_eotd_nrj = RSSI_61952;
  pstruct->time_tag = NOM_POS_1000;
  return pstruct;
}
T_eotd_nc_res eotd_nc_res_885()
{
  T_eotd_nc_res pstruct;
  pstruct->sb_flag = SB_TRUE;
  pstruct->bsic = BSIC_2;
  pstruct->arfcn = ARFCN_885;
  pstruct->eotd_crosscor = EOTD_CROSSCOR_6;
  pstruct->d_eotd_nrj = RSSI_61440;
  pstruct->time_tag = NOM_POS_2000;
  return pstruct;
}
T_ncell_list ncell_arfcn_14()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_14;
  pstruct->fn_offset = FN_OFFSET_224;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_25()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_25;
  pstruct->fn_offset = FN_OFFSET_102;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_512()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_512;
  pstruct->fn_offset = FN_OFFSET_153;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_580()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_580;
  pstruct->fn_offset = FN_OFFSET_204;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_637()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_637;
  pstruct->fn_offset = FN_OFF_ARFCN_14;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_885()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = ARFCN_885;
  pstruct->fn_offset = FN_OFFSET_255;
  pstruct->time_alignment = TIME_ALIGNMT_14;
  pstruct->timing_validity = TV_VALID_TIMING_INFO;
  return pstruct;
}
T_ncell_list ncell_arfcn_empty()
{
  T_ncell_list pstruct;
  pstruct->radio_freq = 0;
  pstruct->fn_offset = 0;
  pstruct->time_alignment = 0;
  pstruct->timing_validity = 0;
  return pstruct;
}
T_l2_frame l2_sys_info_7()
{
  const U8 L2_SYS_INFO_7_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x1F,
	  0x2b, 0x2b, 0x2b, 0x2b, 0x2b,
	  0x2b, 0x2b,
	  0x2b, 0x2b, 0x2b,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_7_ARRAY;
  return pstruct;
}
T_l2_frame l2_sys_info_8()
{
  const U8 L2_SYS_INFO_8_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x18,
	  0x2b, 0x2b, 0x2b, 0x2b, 0x2b,
	  0x2b, 0x2b,
	  0x2b, 0x2b, 0x2b,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_8_ARRAY;
  return pstruct;
}


/*-------------------------------------------------------------------------------
 *
 *                            PSTRUCT ARRAYS
 *
 *-------------------------------------------------------------------------------*/

T_ARRAY<T_ncell_list> ncell_list_6_eotd_idle()
{
  T_ncell_list array[12] = {
    ncell_arfcn_14(),
    ncell_arfcn_25(),
    ncell_arfcn_512(),
    ncell_arfcn_580(),
    ncell_arfcn_637(),
    ncell_arfcn_885(),
    ncell_arfcn_empty(),
    ncell_arfcn_empty(),
    ncell_arfcn_empty(),
    ncell_arfcn_empty(),
    ncell_arfcn_empty(),
    ncell_arfcn_empty()
  };
  return array;
}
T_ARRAY<T_eotd_nc_res> eotd_result_6()
{
  T_eotd_nc_res array[6] = {
    eotd_nc_res_637(),
    eotd_nc_res_25(),
    eotd_nc_res_14(),
    eotd_nc_res_512(),
    eotd_nc_res_580(),
    eotd_nc_res_885()
  };
  return array;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_1(CHAR variant)
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  if (variant == 'A')   prim->arfcn = CHLIST_23_1_124_FFFF;
  if (variant == 'B')   prim->arfcn = EMPTY_NCELL_LIST;
  if (variant == 'C')   prim->arfcn = CHLIST_23_1_124_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_2()
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_1_14_124_FFFF;
  prim->sync_only._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_2a()
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_1_11_15_20_24_25_26_FFFF;
  prim->sync_only._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_3()
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = EMPTY_NCELL_LIST;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_4(CHAR variant)
{
  const U16 CHLIST_23_1_14_124_FFFF_elements[5] = {
    ARFCN_23,
    ARFCN_1,
    ARFCN_14,
    ARFCN_124,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_23_1_14_124_FFFF(CHLIST_23_1_14_124_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  if (variant == 'A')   prim->arfcn = CHLIST_1_14_124_FFFF;
  if (variant == 'B')   prim->arfcn = CHLIST_23_1_14_124_FFFF;
  if (variant == 'C')   prim->arfcn = EMPTY_NCELL_LIST;
  if (variant == 'D')   prim->arfcn = CHLIST_1_14_124_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_5(CHAR variant)
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  if (variant == 'A')   prim->arfcn = CHLIST_512_637_885_FFFF;
  if (variant == 'B')   prim->arfcn = EMPTY_NCELL_LIST;
  if (variant == 'C')   prim->arfcn = CHLIST_512_637_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_6()
{
  const U16 CHLIST_512_580_885_FFFF_elements[4] = {
    ARFCN_512,
    ARFCN_580,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_512_580_885_FFFF(CHLIST_512_580_885_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_512_580_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_7(CHAR variant)
{
  const U16 CHLIST_1_14_23_124_512_580_885_FFFF_elements[8] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_23,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_1_14_23_124_512_580_885_FFFF(CHLIST_1_14_23_124_512_580_885_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_1;
  if (variant == 'A')   prim->arfcn = CHLIST_1_14_23_124_512_580_885_FFFF;
  if (variant == 'B')   prim->arfcn = EMPTY_NCELL_LIST;
  prim->sync_only._skip;
  return prim;
}

T_PRIMITIVE_UNION prim_tb_meas_ind_1()
{
   T_TB_MEAS_IND prim;
   prim->tb_meas_result = tb_list_1();
   return prim;
}

T_PRIMITIVE_UNION prim_tb_meas_ind_2()
{
   T_TB_MEAS_IND prim;
   prim->tb_meas_result = tb_list_2();
   return prim;
}

T_PRIMITIVE_UNION prim_tb_meas_ind_3()
{
   T_TB_MEAS_IND prim;
   prim->tb_meas_result = tb_list_3();
   return prim;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_7A(CHAR variant)
{
  const U16 CHLIST_512_FFFF_elements[2] = {
      ARFCN_512,
      NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_512_FFFF(CHLIST_512_FFFF_elements, SKIP_TO_END);

  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_1;
  if (variant == 'A')   prim->arfcn = CHLIST_512_FFFF;
  if (variant == 'B')   prim->arfcn = EMPTY_NCELL_LIST;
  prim->sync_only._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_8()
{
  const U16 CHLIST_1_14_124_512_580_637_885_FFFF_elements[8] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_637,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_1_14_124_512_580_637_885_FFFF(CHLIST_1_14_124_512_580_637_885_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_2;
  prim->arfcn = CHLIST_1_14_124_512_580_637_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_9()
{
  const U16 CHLIST_1_14_25_124_512_580_637_885_FFFF[9] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_25,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_637,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_1_14_25_124_512_580_637_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_10()
{
  const U16 CHLIST_1_11_14_25_87_124_512_885_FFFF_elements[9] = {
    ARFCN_1,
    ARFCN_11,
    ARFCN_14,
    ARFCN_25,
    ARFCN_87,
    ARFCN_124,
    ARFCN_512,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_1_11_14_25_87_124_512_885_FFFF(CHLIST_1_11_14_25_87_124_512_885_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_1;
  prim->arfcn = CHLIST_1_11_14_25_87_124_512_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_11()
{
  const U16 CHLIST_1_14_512_885_FFFF[5] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_512,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_1;
  prim->arfcn = CHLIST_1_14_512_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_12()
{
  const U16 CHLIST_1_14_512_513_600_700_810_885_FFFF[9] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_512,
    ARFCN_513,
    ARFCN_600,
    ARFCN_700,
    ARFCN_810,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_1;
  prim->arfcn = CHLIST_1_14_512_513_600_700_810_885_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_13()
{
  const U16 CHLIST_1_15_FFFF_elements[3] = {
    ARFCN_1,
    ARFCN_15,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_1_15_FFFF(CHLIST_1_15_FFFF_elements, SKIP_TO_END);
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_1_15_FFFF;
  prim->sync_only._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_15()
{
  const U16 NCELL_LIST_EOTD[9] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_25,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_637,
    ARFCN_885,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = NCELL_LIST_EOTD;
  prim->sync_only = NORMAL_BA;
  return prim;
}
T_PRIMITIVE_UNION  mph_neighbourcell_req_16(){
  const U16 NCELL_LIST_DEDI_LARGE_1[14] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_24,
    ARFCN_30,
    ARFCN_34,
    ARFCN_40,
    ARFCN_42,
    ARFCN_46,
    ARFCN_52,
    ARFCN_59,
    ARFCN_66,
    ARFCN_73,
    ARFCN_124,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = NCELL_LIST_DEDI_LARGE_1;
  prim->sync_only = NORMAL_BA;
  return prim;
}

T_PRIMITIVE_UNION  mph_neighbourcell_req_17(){
  const U16 NCELL_LIST_DEDI_LARGE_2[24] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_24,
    ARFCN_30,
    ARFCN_34,
    ARFCN_40,
    ARFCN_42,
    ARFCN_46,
    ARFCN_52,
    ARFCN_59,
    ARFCN_66,
    ARFCN_73,
    ARFCN_124,
    ARFCN_580,
    ARFCN_581,
    ARFCN_582,
    ARFCN_583,
    ARFCN_584,
    ARFCN_585,
    ARFCN_586,
    ARFCN_587,
    ARFCN_588,
    ARFCN_589,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = NCELL_LIST_DEDI_LARGE_2;
  prim->sync_only = NORMAL_BA;
  return prim;
}

T_PRIMITIVE_UNION  mph_neighbourcell_req_18(){
  const U16 NCELL_LIST_AFTER_HO_LARGE_1[11] = {
    ARFCN_580,
    ARFCN_581,
    ARFCN_582,
    ARFCN_583,
    ARFCN_584,
    ARFCN_595,
    ARFCN_596,
    ARFCN_597,
    ARFCN_598,
    ARFCN_599,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = NCELL_LIST_AFTER_HO_LARGE_1;
  prim->sync_only = NORMAL_BA;
  return prim;
}

T_PRIMITIVE_UNION  mph_neighbourcell_req_19(){
  const U16 NCELL_LIST_AFTER_HO_LARGE_2[24] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_23,
    ARFCN_24,
    ARFCN_34,
    ARFCN_40,
    ARFCN_42,
    ARFCN_74,
    ARFCN_75,
    ARFCN_76,
    ARFCN_80,
    ARFCN_87,
    ARFCN_124,
    ARFCN_580,
    ARFCN_581,
    ARFCN_582,
    ARFCN_583,
    ARFCN_584,
    ARFCN_595,
    ARFCN_596,
    ARFCN_597,
    ARFCN_598,
    ARFCN_599,
    NOT_PRESENT_16BIT
  };
  T_MPH_NEIGHBOURCELL_REQ prim;

  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = NCELL_LIST_AFTER_HO_LARGE_2;
  prim->sync_only = NORMAL_BA;
  return prim;
}

T_PRIMITIVE_UNION  mph_neighbourcell_req_sync_reconfirm(){
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band._skip;
  prim->arfcn._show;
  prim->sync_only = RECONFIRM_SYNC_LIST;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_1(CHAR variant)
{
  const U16 RF_14_23_1_124_elements[4] = {
    ARFCN_14,
    ARFCN_23,
    ARFCN_1,
    ARFCN_124
  };
  T_ARRAY<U16> RF_14_23_1_124(RF_14_23_1_124_elements, SKIP_TO_END);
  const U16 RF_14_elements[1] = {
    ARFCN_14
  };
  T_ARRAY<U16> RF_14(RF_14_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  if (variant == 'A')   prim->chan_list.radio_freq = RF_14_23_1_124;
  if (variant == 'B')   prim->chan_list.radio_freq = RF_14;
  if (variant == 'C')   prim->chan_list.radio_freq = RF_14_23_1_124;
  if (variant == 'A')   prim->num_of_chans = CHANNELS_4;
  if (variant == 'B')   prim->num_of_chans = CHANNELS_1;
  if (variant == 'C')   prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_2()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_1_14_124;
  prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_2i()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_124;
  prim->num_of_chans = CHANNELS_3;
  prim->ba_id = BA_ID_2;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_3()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23;
  prim->num_of_chans = CHANNELS_1;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_4(CHAR variant)
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  if (variant == 'A')   prim->chan_list.radio_freq = RF_23_1_14_124;
  if (variant == 'B')   prim->chan_list.radio_freq = RF_23_1_14_124;
  if (variant == 'C')   prim->chan_list.radio_freq = RF_23;
  if (variant == 'D')   prim->chan_list.radio_freq = RF_23_1_14_124;
  if (variant == 'A')   prim->num_of_chans = CHANNELS_4;
  if (variant == 'B')   prim->num_of_chans = CHANNELS_4;
  if (variant == 'C')   prim->num_of_chans = CHANNELS_1;
  if (variant == 'D')   prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_5(CHAR variant)
{
  const U16 RF_580_512_637_885_elements[4] = {
    ARFCN_580,
    ARFCN_512,
    ARFCN_637,
    ARFCN_885
  };
  T_ARRAY<U16> RF_580_512_637_885(RF_580_512_637_885_elements, SKIP_TO_END);

  const U16 RF_580_elements[1] = {
    ARFCN_580
  };
  T_ARRAY<U16> RF_580(RF_580_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  if (variant == 'A')   prim->chan_list.radio_freq = RF_580_512_637_885;
  if (variant == 'B')   prim->chan_list.radio_freq = RF_580;
  if (variant == 'C')   prim->chan_list.radio_freq = RF_580_512_637_885;
  if (variant == 'A')   prim->num_of_chans = CHANNELS_4;
  if (variant == 'B')   prim->num_of_chans = CHANNELS_1;
  if (variant == 'C')   prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_6()
{
  const U16 RF_637_512_580_885_elements[4] = {
    ARFCN_637,
    ARFCN_512,
    ARFCN_580,
    ARFCN_885
  };
  T_ARRAY<U16> RF_637_512_580_885(RF_637_512_580_885_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_637_512_580_885;
  prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_7(CHAR variant)
{
  const U16 RF_637_1_14_23_124_512_580_885_elements[8] = {
    ARFCN_637,
    ARFCN_1,
    ARFCN_14,
    ARFCN_23,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_885
  };
  T_ARRAY<U16> RF_637_1_14_23_124_512_580_885(RF_637_1_14_23_124_512_580_885_elements, SKIP_TO_END);

  const U16 RF_637_elements[1] = {
    ARFCN_637
  };
  T_ARRAY<U16> RF_637(RF_637_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  if (variant == 'A')   prim->chan_list.radio_freq = RF_637_1_14_23_124_512_580_885;
  if (variant == 'B')   prim->chan_list.radio_freq = RF_637;
  if (variant == 'A')   prim->num_of_chans = CHANNELS_8;
  if (variant == 'B')   prim->num_of_chans = CHANNELS_1;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_8()
{
  const U16 RF_23_1_14_124_512_580_637_885_elements[8] = {
    ARFCN_23,
    ARFCN_1,
    ARFCN_14,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_637,
    ARFCN_885
  };
  T_ARRAY<U16> RF_23_1_14_124_512_580_637_885(RF_23_1_14_124_512_580_637_885_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_1_14_124_512_580_637_885;
  prim->num_of_chans = CHANNELS_8;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_9()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_25_124_512_580_637_885_23;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_10()
{
  const U16 RF_1_14_25_124_512_580_637_885_578_elements[9] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_25,
    ARFCN_124,
    ARFCN_512,
    ARFCN_580,
    ARFCN_637,
    ARFCN_885,
    ARFCN_578
  };
  T_ARRAY<U16> RF_1_14_25_124_512_580_637_885_578(RF_1_14_25_124_512_580_637_885_578_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_25_124_512_580_637_885_578;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_11()
{
  const U16 RF_1_11_14_25_87_124_512_885_23_elements[9] = {
    ARFCN_1,
    ARFCN_11,
    ARFCN_14,
    ARFCN_25,
    ARFCN_87,
    ARFCN_124,
    ARFCN_512,
    ARFCN_885,
    ARFCN_23
  };
  T_ARRAY<U16> RF_1_11_14_25_87_124_512_885_23(RF_1_11_14_25_87_124_512_885_23_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_11_14_25_87_124_512_885_23;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_12()
{
  const U16 RF_23_1_14_512_885_elements[5] = {
    ARFCN_23,
    ARFCN_1,
    ARFCN_14,
    ARFCN_512,
    ARFCN_885
  };
  T_ARRAY<U16> RF_23_1_14_512_885(RF_23_1_14_512_885_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_1_14_512_885;
  prim->num_of_chans = CHANNELS_5;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_13()
{
  const U16 RF_1_14_512_513_600_700_810_885_637_elements[9] = {
    ARFCN_1,
    ARFCN_14,
    ARFCN_512,
    ARFCN_513,
    ARFCN_600,
    ARFCN_700,
    ARFCN_810,
    ARFCN_885,
    ARFCN_637
  };
  T_ARRAY<U16> RF_1_14_512_513_600_700_810_885_637(RF_1_14_512_513_600_700_810_885_637_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_512_513_600_700_810_885_637;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_14()
{
  const U16 RF_637_1_14_512_885_elements[5] = {
 	  ARFCN_637,
	  ARFCN_1,
	  ARFCN_14,
	  ARFCN_512,
	  ARFCN_885
  };
  T_ARRAY<U16> RF_637_1_14_512_885(RF_637_1_14_512_885_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_637_1_14_512_885;
  prim->num_of_chans = CHANNELS_5;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_15()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_1_14_124;
  prim->num_of_chans = CHANNELS_4;
  prim->ba_id = BA_ID_2;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}


T_PRIMITIVE_UNION mphc_rxlev_periodic_req_16()
{
  const U16 RF_1_14_15_elements[3] = {
 	  ARFCN_1,
    ARFCN_14,
    ARFCN_15
  };
  T_ARRAY<U16> RF_1_14_15(RF_1_14_15_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_15;
  prim->num_of_chans = CHANNELS_3;
  prim->ba_id = BA_ID_3;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_17()
{
  const U16 RF_23_1_15_elements[3] = {
 	  ARFCN_23,
	  ARFCN_1,
	  ARFCN_15
  };
  T_ARRAY<U16> RF_23_1_15(RF_23_1_15_elements, SKIP_TO_END);

  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_1_15;
  prim->num_of_chans = CHANNELS_3;
  prim->ba_id = BA_ID_3;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_18()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list._skip;
  prim->num_of_chans._skip;
  prim->ba_id._skip;
  prim->next_radio_freq_measured._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_20()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_1_14_25_124_512_580_637_885_23;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_21()
{
  const U16 RF_23_512_elements[2] = {
        ARFCN_23,
        ARFCN_512
  };
  T_ARRAY<U16> RF_23_512(RF_23_512_elements, SKIP_TO_END);
  T_MPHC_RXLEV_PERIODIC_REQ prim;
  prim->chan_list.radio_freq = RF_23_512;
  prim->num_of_chans = CHANNELS_2;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_1()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  //   prim->result = ncell_result_no_content();
  prim->nbr_of_carriers = CHANNELS_0;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;

  int i=0;
  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }

  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_2()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  //   prim->result = ncell_result_1();
  prim->nbr_of_carriers = CHANNELS_8;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_23;
  prim->result[i].rxlev      = 56;
  i++;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = 12;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = 25;
  i++;

  /*this is no cut and paste error.*/
  prim->result[i].radio_freq = ARFCN_23;
  prim->result[i].rxlev      = 56;
  i++;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = 12;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = 25;
  i++;

  prim->nbr_of_carriers = i;

  for(;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq._skip;
    prim->result[i].rxlev     ._skip;
  }
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_3()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  //prim->result          = ncell_res_sc_23_8();
  prim->nbr_of_carriers = CHANNELS_8;
  prim->s_rxlev         = RXLEV_56;
  prim->ba_id           = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_23;
  prim->result[i].rxlev      = ARFCN_23_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = ARFCN_14_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_25;
  prim->result[i].rxlev      = ARFCN_25_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = ARFCN_124_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = ARFCN_512_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_580;
  prim->result[i].rxlev      = ARFCN_580_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_637;
  prim->result[i].rxlev      = ARFCN_637_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = ARFCN_885_RXLEVEL;
  i++;

  //  T_TDC_INTERFACE_U8 x;
  //  U8 y= i;
  //  x=y;
  //  if(x != prim->nbr_of_carriers) ;/*do something! what?*/
  /* or do: */
  prim->nbr_of_carriers = i;
  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }

  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_4()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  prim->nbr_of_carriers = CHANNELS_8;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_578;
  prim->result[i].rxlev      = 30;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_25;
  prim->result[i].rxlev      = 55;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = 12;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = 43;
  i++;

  prim->result[i].radio_freq = ARFCN_580;
  prim->result[i].rxlev      = 25;
  i++;
  prim->result[i].radio_freq = ARFCN_637;
  prim->result[i].rxlev      = 56;
  i++;
  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = 25;
  i++;

  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }

  //   prim->result = ncell_res_sc_578_8();
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_5()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  //   prim->result = ncell_res_sc_23_8_1();
  prim->nbr_of_carriers = CHANNELS_8;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = ARFCN_14_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = ARFCN_1_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_11;
  prim->result[i].rxlev      = ARFCN_11_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_25;
  prim->result[i].rxlev      = ARFCN_25_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_87;
  prim->result[i].rxlev      = ARFCN_87_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = ARFCN_124_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = ARFCN_512_RXLEVEL;
  i++;

  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = ARFCN_885_RXLEVEL;
  i++;

  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }

  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_6()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  prim->nbr_of_carriers = CHANNELS_4;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = 11;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = 43;
  i++;

  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = 23;
  i++;

  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }


  //   prim->result = ncell_res_sc_23_4_1();
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_7()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;

  prim->nbr_of_carriers = CHANNELS_8;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = 33;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = 12;
  i++;

  prim->result[i].radio_freq = ARFCN_513;
  prim->result[i].rxlev      = 21;
  i++;

  prim->result[i].radio_freq = ARFCN_600;
  prim->result[i].rxlev      = 24;
  i++;

  prim->result[i].radio_freq = ARFCN_700;
  prim->result[i].rxlev      = 27;
  i++;

  prim->result[i].radio_freq = ARFCN_810;
  prim->result[i].rxlev      = 18;
  i++;

  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = 15;
  i++;

  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }
  //   prim->result = ncell_res_sc_637_8_1();
  return prim;
}
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_8()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;
  prim->nbr_of_carriers = CHANNELS_4;
  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = 44;
  i++;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = 11;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = 43;
  i++;

  prim->result[i].radio_freq = ARFCN_885;
  prim->result[i].rxlev      = 23;
  i++;

  prim->nbr_of_carriers = i;

  for (;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq ._skip;
    prim->result[i].rxlev      ._skip;
  }
  //prim->result = ncell_res_sc_637_4_1();
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_9(U16 rx_1, U16 rx_2, U16 rx_3, U16 rx_4)
{
  T_MPHC_RXLEV_PERIODIC_IND prim;

  prim->nbr_of_carriers = CHANNELS_4;
  prim->s_rxlev = rx_1;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_23;
  prim->result[i].rxlev      = rx_1;
  i++;

  prim->result[i].radio_freq = ARFCN_1;
  prim->result[i].rxlev      = rx_2;
  i++;

  prim->result[i].radio_freq = ARFCN_14;
  prim->result[i].rxlev      = rx_3;
  i++;

  prim->result[i].radio_freq = ARFCN_124;
  prim->result[i].rxlev      = rx_4;
  i++;

  prim->nbr_of_carriers = i;

  for(;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq._skip;
    prim->result[i].rxlev     ._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_9A(U16 rx_1, U16 rx_2)
{
  T_MPHC_RXLEV_PERIODIC_IND prim;

  prim->nbr_of_carriers = CHANNELS_2;
  prim->s_rxlev = rx_1;
  prim->ba_id = BA_ID_1;
  int i=0;

  prim->result[i].radio_freq = ARFCN_23;
  prim->result[i].rxlev      = rx_1;
  i++;

  prim->result[i].radio_freq = ARFCN_512;
  prim->result[i].rxlev      = rx_2;
  i++;

  prim->nbr_of_carriers = i;

  for(;i<MAX_MEAS_VALUES;i++) {
    prim->result[i].radio_freq._skip;
    prim->result[i].rxlev     ._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_1()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_1020;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_2()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_102;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_3()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_1071;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_4()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_153;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_5()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_204;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_6()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_255;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_7()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_8()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_9()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_357;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_10()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_816;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_11()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_408;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}



T_PRIMITIVE_UNION mph_measurement_ind_dummy(U16 s_arfcn, U8 rxlev_full)
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = s_arfcn;
  prim->rx_lev_full = rxlev_full;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset._show;
  prim->ncells._show;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_bho_1(U16 s_arfcn, U8 rxlev_full)
{
  T_MPH_MEASUREMENT_IND prim;
  int     i;
  prim->arfcn = s_arfcn;
  prim->rx_lev_full = rxlev_full;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset._show;
  prim->ncells.no_of_ncells = i = 3;

  prim->ncells.arfcn[0] = ARFCN_14;
  prim->ncells.arfcn[1] = ARFCN_23;

  prim->ncells.arfcn[2] = ARFCN_124;

  prim->ncells.bsic[0] = 1;
  prim->ncells.bsic[1] = 1;
  prim->ncells.bsic[2] = 1;

  prim->ncells.rx_lev[0] = 0x2C;
  prim->ncells.rx_lev[1] = 0x1E;
  prim->ncells.rx_lev[2] = 0x19;

  prim->ncells.frame_offset[0] = 0xD;
  prim->ncells.frame_offset[1] = 0x296F9C;
  prim->ncells.frame_offset[2] = 0xE0;

  prim->ncells.time_alignmt[0] = 0xD;
  prim->ncells.time_alignmt[1] = 0x1387;
  prim->ncells.time_alignmt[2] = 0x7C;

#ifdef FF_EGPRS
  int maxnum = MAX_NUM_CELLS_IN_REPORT;
#else // FF_EGPRS
  int maxnum = 6;
#endif  // FF_EGPRS

  for(;i<maxnum;i++)
  {
    prim->ncells.arfcn[i]=0;
    prim->ncells.bsic[i]=0;
    prim->ncells.rx_lev[i]=0;
    prim->ncells.frame_offset[i]=0;
    prim->ncells.time_alignmt[i]=0;
  }
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}


T_PRIMITIVE_UNION mph_measurement_ind_12()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_459;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_13()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells = ncells_no_content();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_14()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  prim->ncells = ncells_1_14_124();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_15()
{
  const U16 CHLIST_1_124_elements[2] = {
 	  ARFCN_1,
	  ARFCN_124
  };
  T_ARRAY<U16> CHLIST_1_124(CHLIST_1_124_elements, SKIP_TO_END);

  const U8 NCELLS_1_124_RXLEVS_elements[2] = {
 	  12, 25
  };
  T_ARRAY<U8> NCELLS_1_124_RXLEVS(NCELLS_1_124_RXLEVS_elements, SKIP_TO_END);

  const U8 NCELLS_1_124_BSICS_elements[2] = {
 	  1,1
  };
  T_ARRAY<U8> NCELLS_1_124_BSICS(NCELLS_1_124_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_1_124_TA_elements[2] = {
 	  1, 124
  };
  T_ARRAY<U32> NCELLS_1_124_TA(NCELLS_1_124_TA_elements, SKIP_TO_END);

  const U32 NCELLS_1_124_FO_elements[2] = {
 	  101, 224               /* not interpreted in old tap ? wrong field length */
  };
  T_ARRAY<U32> NCELLS_1_124_FO(NCELLS_1_124_FO_elements, SKIP_TO_END);

  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  //   prim->ncells = ncells_1_124();
  prim->ncells.no_of_ncells = 2;
  prim->ncells.arfcn = CHLIST_1_124;
  prim->ncells.rx_lev = NCELLS_1_124_RXLEVS;
  prim->ncells.bsic = NCELLS_1_124_BSICS;
  prim->ncells.time_alignmt = NCELLS_1_124_TA;
  prim->ncells.frame_offset = NCELLS_1_124_FO;

  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_16()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  prim->ncells = ncells_no_content();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_17()
{
  const U16 CHLIST_1_14_elements[2] = {
 	  ARFCN_1,
	  ARFCN_14
  };
  T_ARRAY<U16> CHLIST_1_14(CHLIST_1_14_elements, SKIP_TO_END);
  const U8 NCELLS_1_14_NCC_RXLEVS_elements[2] = {
 	  12, 44
  };
  T_ARRAY<U8> NCELLS_1_14_NCC_RXLEVS(NCELLS_1_14_NCC_RXLEVS_elements, SKIP_TO_END);

  const U8 NCELLS_1_14_NCC_BSICS_elements[2] = {
 	  16,16
  };
  T_ARRAY<U8> NCELLS_1_14_NCC_BSICS(NCELLS_1_14_NCC_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_1_14_NCC_TA_elements[2] = {
 	  1, 14
  };
  T_ARRAY<U32> NCELLS_1_14_NCC_TA(NCELLS_1_14_NCC_TA_elements, SKIP_TO_END);

  const U32 NCELLS_1_14_NCC_FO_elements[2] = {
 	  101, 114      /* not interpreted in old TAP  */
  };
  T_ARRAY<U32> NCELLS_1_14_NCC_FO(NCELLS_1_14_NCC_FO_elements, SKIP_TO_END);

  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  //   prim->ncells = ncells_1_14_ncc();
  prim->ncells.no_of_ncells = 2;
  prim->ncells.arfcn = CHLIST_1_14;
  prim->ncells.rx_lev = NCELLS_1_14_NCC_RXLEVS;
  prim->ncells.bsic = NCELLS_1_14_NCC_BSICS;
  prim->ncells.time_alignmt = NCELLS_1_14_NCC_TA;
  prim->ncells.frame_offset = NCELLS_1_14_NCC_FO;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_18()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_816;
  prim->ncells = ncells_no_content();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_19()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_408;
  prim->ncells = ncells_1_14_124();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_20()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = CONST_23;
  prim->rx_lev_full = CONST_63;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid._skip;
  prim->fn_offset._skip;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_21()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  prim->ncells = ncells_sc_900_8();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_22()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_578;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells = ncells_no_content();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_23()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_578;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_306;
  prim->ncells = ncells_sc_900_8();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_24()
{
  T_MPH_MEASUREMENT_IND prim;
  const U16 CHLIST_11_14_25_87_124_512_elements[6] = {
    ARFCN_11,
    ARFCN_14,
    ARFCN_25,
    ARFCN_87,
    ARFCN_124,
    ARFCN_512
  };
  T_ARRAY<U16> CHLIST_11_14_25_87_124_512(CHLIST_11_14_25_87_124_512_elements, SKIP_TO_END);

  const U8 NCELLS_SC_900_8_1_RXLEVS_elements[6] = {
    ARFCN_11_RXLEVEL,
    ARFCN_14_RXLEVEL,
    ARFCN_25_RXLEVEL,
    ARFCN_87_RXLEVEL,
    ARFCN_124_RXLEVEL,
    ARFCN_512_RXLEVEL
  };
  T_ARRAY<U8> NCELLS_SC_900_8_1_RXLEVS(NCELLS_SC_900_8_1_RXLEVS_elements, SKIP_TO_END);

  const U8 NCELLS_SC_900_8_1_BSICS_elements[6] = {
    1, 1, 1, 1, 1, 1
  };
  T_ARRAY<U8> NCELLS_SC_900_8_1_BSICS(NCELLS_SC_900_8_1_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_SC_900_8_1_TA_elements[6] = {
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14
  };
  T_ARRAY<U32> NCELLS_SC_900_8_1_TA(NCELLS_SC_900_8_1_TA_elements, SKIP_TO_END);

  const U32 NCELLS_SC_900_8_1_FO_elements[6] = {
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14
  };
  T_ARRAY<U32> NCELLS_SC_900_8_1_FO(NCELLS_SC_900_8_1_FO_elements, SKIP_TO_END);

  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  //   prim->ncells = ncells_sc_900_8_1();
  prim->ncells.no_of_ncells = 6;
  prim->ncells.arfcn = CHLIST_11_14_25_87_124_512;
  prim->ncells.rx_lev = NCELLS_SC_900_8_1_RXLEVS;
  prim->ncells.bsic = NCELLS_SC_900_8_1_BSICS;
  prim->ncells.time_alignmt = NCELLS_SC_900_8_1_TA;
  prim->ncells.frame_offset = NCELLS_SC_900_8_1_FO;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_25()
{
  const U8 NCELLS_SC_900_4_1_RXLEVS_elements[4] = {
    11, 44, 43, 23
  };
  T_ARRAY<U8> NCELLS_SC_900_4_1_RXLEVS(NCELLS_SC_900_4_1_RXLEVS_elements, SKIP_TO_END);
  const U8 NCELLS_SC_900_4_1_BSICS_elements[4] = {
    1, 1, 1, 1
  };
  T_ARRAY<U8> NCELLS_SC_900_4_1_BSICS(NCELLS_SC_900_4_1_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_SC_900_4_1_TA_elements[4] = {
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14
  };
  T_ARRAY<U32> NCELLS_SC_900_4_1_TA(NCELLS_SC_900_4_1_TA_elements, SKIP_TO_END);

  const U32 NCELLS_SC_900_4_1_FO_elements[4] = {
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14
  };
  T_ARRAY<U32> NCELLS_SC_900_4_1_FO(NCELLS_SC_900_4_1_FO_elements, SKIP_TO_END);

  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  //   prim->ncells = ncells_sc_900_4_1(); prim->ncells.
  prim->ncells.no_of_ncells = 4;
  prim->ncells.arfcn = CHLIST_1_14_512_885;
  prim->ncells.rx_lev = NCELLS_SC_900_4_1_RXLEVS;
  prim->ncells.bsic = NCELLS_SC_900_4_1_BSICS;
  prim->ncells.time_alignmt = NCELLS_SC_900_4_1_TA;
  prim->ncells.frame_offset = NCELLS_SC_900_4_1_FO;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_26()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_637;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells = ncells_no_content();
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_27()
{
  const U16 CHLIST_14_513_600_700_810_885_elements[6] = {
    ARFCN_14,
    ARFCN_513,
    ARFCN_600,
    ARFCN_700,
    ARFCN_810,
    ARFCN_885
  };
  T_ARRAY<U16> CHLIST_14_513_600_700_810_885(CHLIST_14_513_600_700_810_885_elements, SKIP_TO_END);

  const U8 NCELLS_SC_1800_8_1_RXLEVS_elements[6] = {
    44,21,24,27,18,15
  };
  T_ARRAY<U8> NCELLS_SC_1800_8_1_RXLEVS(NCELLS_SC_1800_8_1_RXLEVS_elements, SKIP_TO_END);

  const U8 NCELLS_SC_1800_8_1_BSICS_elements[6] = {
    1,1,1,1,1,1
  };
  T_ARRAY<U8> NCELLS_SC_1800_8_1_BSICS(NCELLS_SC_1800_8_1_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_SC_1800_8_1_TA_elements[6] = {
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14,
    TIME_ALIGNMT_14
  };
  T_ARRAY<U32> NCELLS_SC_1800_8_1_TA(NCELLS_SC_1800_8_1_TA_elements, SKIP_TO_END);

  const U32 NCELLS_SC_1800_8_1_FO_elements[6] = {
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14,
    FN_OFF_ARFCN_14
  };
  T_ARRAY<U32> NCELLS_SC_1800_8_1_FO(NCELLS_SC_1800_8_1_FO_elements, SKIP_TO_END);

  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_637;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_306;
  //   prim->ncells = ncells_sc_1800_8_1();
  prim->ncells.no_of_ncells = 6;
  prim->ncells.arfcn = CHLIST_14_513_600_700_810_885;
  prim->ncells.rx_lev = NCELLS_SC_1800_8_1_RXLEVS;
  prim->ncells.bsic = NCELLS_SC_1800_8_1_BSICS;
  prim->ncells.time_alignmt = NCELLS_SC_1800_8_1_TA;
  prim->ncells.frame_offset = NCELLS_SC_1800_8_1_FO;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}




T_PRIMITIVE_UNION mph_measurement_ind_28()
{
  const U8 NCELLS_SC_1800_4_1_RXLEVS_elements[4] = {
 	  11,44,43,23
  };
  T_ARRAY<U8> NCELLS_SC_1800_4_1_RXLEVS(NCELLS_SC_1800_4_1_RXLEVS_elements, SKIP_TO_END);
  const U8 NCELLS_SC_1800_4_1_BSICS_elements[4] = {
 	  1,1,1,1
  };
  T_ARRAY<U8> NCELLS_SC_1800_4_1_BSICS(NCELLS_SC_1800_4_1_BSICS_elements, SKIP_TO_END);

  const U32 NCELLS_SC_1800_4_1_TA_elements[4] = {
 	  TIME_ALIGNMT_14,
	  TIME_ALIGNMT_14,
	  TIME_ALIGNMT_14,
	  TIME_ALIGNMT_14
  };
  T_ARRAY<U32> NCELLS_SC_1800_4_1_TA(NCELLS_SC_1800_4_1_TA_elements, SKIP_TO_END);

  const U32 NCELLS_SC_1800_4_1_FO_elements[4] = {
 	  FN_OFF_ARFCN_14,
	  FN_OFF_ARFCN_14,
	  FN_OFF_ARFCN_14,
	  FN_OFF_ARFCN_14
  };
  T_ARRAY<U32> NCELLS_SC_1800_4_1_FO(NCELLS_SC_1800_4_1_FO_elements, SKIP_TO_END);


  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_637;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_306;
  //   prim->ncells = ncells_sc_1800_4_1();
  prim->ncells.no_of_ncells = 4;
  prim->ncells.arfcn = CHLIST_1_14_512_885;
  prim->ncells.rx_lev = NCELLS_SC_1800_4_1_RXLEVS;
  prim->ncells.bsic = NCELLS_SC_1800_4_1_BSICS;
  prim->ncells.time_alignmt = NCELLS_SC_1800_4_1_TA;
  prim->ncells.frame_offset = NCELLS_SC_1800_4_1_FO;

  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_29()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells = ncells_no_content;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_30()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  prim->ncells = ncells_no_content;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_31()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub = RX_0;
  prim->rx_qual_full = RX_0;
  prim->rx_qual_sub = RX_0;
  prim->dtx = RX_0;
  prim->otd = OTD_0;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_816;
  prim->ncells = ncells_no_content_skip();
  prim->gprs_sync = NORMAL_MEAS_REP;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_32()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub = RX_0;
  prim->rx_qual_full = RX_0;
  prim->rx_qual_sub = RX_0;
  prim->dtx = RX_0;
  prim->otd = OTD_0;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_918;
  prim->ncells._skip;
  prim->gprs_sync = NORMAL_MEAS_REP;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_33()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full = RXLEV_56;
  prim->rx_lev_sub = RX_0;
  prim->rx_qual_full = RX_0;
  prim->rx_qual_sub = RX_0;
  prim->dtx = RX_0;
  prim->otd = OTD_0;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFF_ARFCN_23;
  //prim->ncells = ncells_sc_900_eotd();
  prim->ncells.no_of_ncells = 6;
  prim->ncells.arfcn = CHLIST_14_25_512_580_637_885;
  prim->ncells.rx_lev = NCELLS_SC_900_8_RXLEVS;
  prim->ncells.bsic = NCELLS_SC_900_8_BSICS;
  prim->ncells.time_alignmt = NCELLS_SC_900_8_TA;
  prim->ncells.frame_offset = NCELLS_SC_900_8_FO_EOTD;
  prim->bcch_rxlev_of_sc._skip;
  prim->gprs_sync = NORMAL_MEAS_REP;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_34()
{
const U16 RADIO_FREQ_23_124_1[6] = {
	ARFCN_23, ARFCN_124, ARFCN_1, 0,0,0
};
const U8 RXLEVS_FOR_23_124_1[6] = {
  30, CONST_30, 15, 0, 0, 0
};
const U8 BSICS_FOR_23_124_1[6] = {
  BSIC_1, BSIC_1, BSIC_1, 0, 0, 0
};
const U32 TA_FOR_23_124_1[6] = {
 	5000 - TIME_ALIGNMT_124,
	0,
	5000 - TIME_ALIGNMT_124 + TIME_ALIGNMT_1,
	0,
	0,
	0
};
const U32 FO_FOR_23_124_1[6] = {
 	TDMA_FRAMES_PER_HYPERFRAME - FN_OFF_ARFCN_124 + 1,
	0,
	TDMA_FRAMES_PER_HYPERFRAME - FN_OFF_ARFCN_124 + FN_OFF_ARFCN_1 + 1,
	0,
	0,
	0
};

  T_MPH_MEASUREMENT_IND prim;
  U8      i=6;
  prim->arfcn = ARFCN_124;
  prim->rx_lev_full = 25;
  prim->rx_lev_sub = 25;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx = DTX_USED;
  prim->otd = OTD_30;
  prim->valid = VALID_REPORT;
  prim->fn_offset = 103;
  //prim->ncells = ncells_sc_900_eotd();
  prim->ncells.no_of_ncells = 3;
  prim->ncells.arfcn = RADIO_FREQ_23_124_1;
  prim->ncells.rx_lev = RXLEVS_FOR_23_124_1;
  prim->ncells.bsic = BSICS_FOR_23_124_1;
  prim->ncells.time_alignmt = TA_FOR_23_124_1;
  prim->ncells.frame_offset = FO_FOR_23_124_1;

#ifdef FF_EGPRS
  int maxnum = MAX_NUM_CELLS_IN_REPORT;
#else // FF_EGPRS
  int maxnum = 6;
#endif  // FF_EGPRS

  for(;i<maxnum;i++)
  {
    prim->ncells.arfcn[i]        =0;//._skip;
    prim->ncells.bsic[i]         =0;//._skip;
    prim->ncells.frame_offset[i] =0;//._skip;
    prim->ncells.rx_lev[i]       =0;//._skip;
    prim->ncells.time_alignmt[i] =0;//._skip;
  }

  prim->gprs_sync = NORMAL_MEAS_REP;
  prim->bcch_rxlev_of_sc = CONST_30;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_35()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full._skip;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_1020;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_36()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full._skip;
  prim->rx_lev_sub._skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub._skip;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_816;
  prim->ncells._skip;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_36A()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full._show;
  prim->rx_lev_sub._show;
  prim->rx_qual_full._show;
  prim->rx_qual_sub._show;
  prim->dtx._skip;
  prim->otd._skip;
  prim->valid = VALID_REPORT;
  prim->fn_offset = FN_OFFSET_816;
  prim->ncells.no_of_ncells =1;
  prim->ncells.arfcn._show;
  prim->ncells.rx_lev._show;
  prim->ncells.bsic._show;
  prim->gprs_sync._skip;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_req_initial(U16 arfcn)
{
  T_MPHC_NCELL_SYNC_REQ prim;
  prim->radio_freq      = arfcn;
  prim->timing_validity = TV_INVALID_TIMING_INFO;
  prim->fn_offset       ._skip;
  prim->time_alignment  ._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_req_fn(U16 arfcn)
{
  T_MPHC_NCELL_SYNC_REQ prim;
  if(arfcn == 0xFFFF) prim->radio_freq._show;
  else  prim->radio_freq      = arfcn;

  prim->timing_validity = TV_INVALID_TIMING_INFO;
  prim->fn_offset       ._skip;
  prim->time_alignment  ._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_req_1a()
{
  T_MPHC_NCELL_SYNC_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment= TIME_ALIGNMT_14;
  prim->timing_validity = TV_APPROX_TIMING_INFO;
  return prim;
}

T_PRIMITIVE_UNION  mphc_ncell_sync_ind (U16 arfcn, U32 fn_offset, U32 ta, U8 bsic, U8 sb)
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = arfcn;
  prim->sb_flag = sb;
  prim->fn_offset = fn_offset;
  prim->time_alignment = ta;
  prim->bsic = bsic;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_3()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_1;
  prim->time_alignment = TIME_ALIGNMT_1;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_3a()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = TDMA_FRAMES_PER_HYPERFRAME - FN_OFFSET_224 + FN_OFF_ARFCN_1 + 1;
  prim->time_alignment = 5000 - TIME_ALIGNMT_124 + TIME_ALIGNMT_1;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_5()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_1;
  prim->time_alignment = TIME_ALIGNMT_1;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_8()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = CONST_1023;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = CONST_12;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_fn(U16 arfcn)
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = arfcn;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = CONST_12;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}




T_PRIMITIVE_UNION mphc_ncell_sync_ind_12()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_15()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_16()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id._skip;
  prim->attempt._skip;
  prim->pm._skip;
  prim->toa._skip;
  prim->angle._skip;
  prim->snr._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode._skip;
  prim->d_eotd_first._skip;
  prim->d_eotd_max._skip;
  prim->d_eotd_nrj._skip;
  prim->a_eotd_crosscor._skip;
  prim->time_tag._skip;
  prim->fn_sb_neigh._skip;
  prim->fn_in_sb._skip;
  prim->toa_correction._skip;
  prim->delta_fn._skip;
  prim->delta_qbit._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_24()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_25()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_26()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_27()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_2;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_28()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_29()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_25;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_102;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_30()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_153;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_31()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_204;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_32()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_255;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_33()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_918;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_34()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_35()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_25;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_102;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_36()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_37()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_153;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_38()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_204;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_39()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_255;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = EOTD_0L;
  prim->a_eotd_crosscor._skip;
  prim->time_tag = EOTD_0L;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_40()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_918;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_12;
  prim->time_tag = NOM_POS_1000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_41()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61952;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_9;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_42()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_25;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_6;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_43()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61952;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_9;
  prim->time_tag = NOM_POS_1000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_44()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_6;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_45()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61952;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_9;
  prim->time_tag = NOM_POS_1000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_46()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_2;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_6;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_47()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_918;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_1;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_12;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_48()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_516;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_102;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_10;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61440;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_6;
  prim->time_tag = NOM_POS_1000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_sync_ind_49()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq = ARFCN_525;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_114;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->bsic = BSIC_10;
  prim->neigh_id = EOTD_00;
  prim->attempt = EOTD_00;
  prim->pm = EOTD_0L;
  prim->toa = EOTD_0L;
  prim->angle = EOTD_0L;
  prim->snr = EOTD_0L;
  prim->eodt_data_valid = EOTD_PRES;
  prim->mode = EOTD_00;
  prim->d_eotd_first = EOTD_0000;
  prim->d_eotd_max = EOTD_0000;
  prim->d_eotd_nrj = RSSI_61952;
  prim->a_eotd_crosscor = EOTD_CROSSCOR_9;
  prim->time_tag = NOM_POS_2000;
  prim->fn_sb_neigh = EOTD_0L;
  prim->fn_in_sb = EOTD_0L;
  prim->delta_fn = EOTD_0L;
  prim->delta_qbit = EOTD_0L;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_cell32()
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq      = ARFCN_32;
  prim->sb_flag         = SB_FOUND;
  prim->fn_offset       = FN_OFFSET_32;
  prim->time_alignment  = TIME_ALIGNMT_32;
  prim->bsic            = BSIC_3;
  prim->neigh_id        ._skip;
  prim->attempt         ._skip;
  prim->pm              ._skip;
  prim->toa             ._skip;
  prim->angle           ._skip;
  prim->snr             ._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode            ._skip;
  prim->d_eotd_first    ._skip;
  prim->d_eotd_max      ._skip;
  prim->d_eotd_nrj      ._skip;
  prim->a_eotd_crosscor ._skip;
  prim->time_tag        ._skip;
  prim->fn_sb_neigh     ._skip;
  prim->fn_in_sb        ._skip;
  prim->toa_correction  ._skip;
  prim->delta_fn        ._skip;
  prim->delta_qbit      ._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_failed(U16 arfcn)
{
  T_MPHC_NCELL_SYNC_IND prim;
  prim->radio_freq      = arfcn;
  prim->sb_flag         = NO_SB_FOUND;
  prim->fn_offset       = INVALID_PATTERN;
  prim->time_alignment  = INVALID_PATTERN;
  prim->bsic            = INVALID_PATTERN;
  prim->neigh_id        ._skip;
  prim->attempt         ._skip;
  prim->pm              ._skip;
  prim->toa             ._skip;
  prim->angle           ._skip;
  prim->snr             ._skip;
  prim->eodt_data_valid = EOTD_NOT_PRES;
  prim->mode            ._skip;
  prim->d_eotd_first    ._skip;
  prim->d_eotd_max      ._skip;
  prim->d_eotd_nrj      ._skip;
  prim->a_eotd_crosscor ._skip;
  prim->time_tag        ._skip;
  prim->fn_sb_neigh     ._skip;
  prim->fn_in_sb        ._skip;
  prim->toa_correction  ._skip;
  prim->delta_fn        ._skip;
  prim->delta_qbit      ._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req(U16 arfcn, U32 fn_offset, U32 ta, U8 bsic, U8 blocks)
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = arfcn;
  prim->fn_offset=fn_offset;
  prim->time_alignment=ta;
  /*
   * The training sequence code on broadcast and common control channels
   * has to be equal to the Base Station Colour Code (BCC),
   * see 3GPP TS 5.02, section 5.2.3 and
   * 3GPP TS 03.03, section 4.3.2 Base Station Identify Code (BSIC)
   */
  prim->tsc=bsic & 7;
  prim->bcch_blocks_required=blocks;
  prim->gprs_prio._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = arfcn;
  prim->fn_offset._show;
  prim->time_alignment._show;
  prim->tsc._show;
  prim->bcch_blocks_required._show;
  prim->gprs_prio._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req_cell32(U16 blocks_required)
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq           = ARFCN_32;
  prim->fn_offset            = FN_OFFSET_32;
  prim->time_alignment       = TIME_ALIGNMT_32;
  prim->tsc                  = BSIC_3;
  prim->bcch_blocks_required = blocks_required;
  prim->gprs_prio._show;  // good question
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req_4()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_0;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_5()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFF_ARFCN_1;
  prim->time_alignment = TIME_ALIGNMT_1;
  prim->tsc = BSIC_0;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
  prim->gprs_prio._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req_10()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_637;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_13()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_580;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_22()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_7_8;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_23()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFF_ARFCN_1;
  prim->time_alignment = TIME_ALIGNMT_1;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_7_8;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_24()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_124;
  prim->fn_offset = FN_OFF_ARFCN_124;
  prim->time_alignment = TIME_ALIGNMT_124;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_7_8;
  prim->gprs_prio._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_25()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_26()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_124;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_27()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_28()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_2;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_30()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_25;
  prim->fn_offset = FN_OFFSET_102;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_31()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_512;
  prim->fn_offset = FN_OFFSET_153;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_32()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_580;
  prim->fn_offset = FN_OFFSET_204;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_req_33()
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = ARFCN_885;
  prim->fn_offset = FN_OFFSET_255;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  prim->bcch_blocks_required = NCELL_BCCH_SI_3_4;
#if defined GPRS
  prim->gprs_prio = GPRS_PRIO_NORM;
#else
  prim->gprs_prio._skip;
#endif
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_bcch_req(U16 arfcn)
{
  T_MPHC_STOP_NCELL_BCCH_REQ prim;
  prim->radio_freq_array_size = STOP_SIZE_1;

  int i=0;
  prim->radio_freq_array[i] = arfcn;
  i++;

  for(;i<MAX_NCELL;i++) {
    prim->radio_freq_array[i] = 0;
  }
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si3(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_3();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si2(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_2();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si4(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_4();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si4_acs(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_4_acs();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_14;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si7(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_7();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si8(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame   = l2_sys_info_8();
  prim->tc         = TC_2;
  prim->fn         = FN_OFFSET_224;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_ind_invalid(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = arfcn;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame   = l2_no_content();
  prim->tc         = TC_2;
  prim->fn         = FN_OFF_ARFCN_14;
  return prim;
}
#if 0
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_1()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_ind_2()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_3()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_4()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_5()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_1;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_6()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_0;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_7()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_0;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_8()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_9()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_25;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_10()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_11()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_12()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_13()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_87;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_14()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_11;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_15()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_16()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_700;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_17()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_600;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_18()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_513;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_19()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_810;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_20()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_21()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_22()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_23()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4_acs();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_24()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4_acs();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_25()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4_acs();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_26()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_7();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_27()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_7();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_28()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_7();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_29()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_8();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_30()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_8();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_31()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_8();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_32()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_33()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_34()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_35()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_124;
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_36()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFFSET_224;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_bcch_ind_37()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_bcch_ind_38()
{
  T_MPHC_NCELL_BCCH_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->fn = FN_OFFSET_224;
  return prim;
}
#endif

T_PRIMITIVE_UNION mphc_update_ba_list_1()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CONST_5;
  prim->chan_list.radio_freq = RADIO_FREQ_100;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = CONST_129;
  return prim;
}
T_PRIMITIVE_UNION mphc_update_ba_list_2()
{
  const U16 RADIO_FREQ_101[33] = {
	  23,1,14,124,0,0,0,0,
	  0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,
	  0,0,0,0,0,0,0,0,
	  0
  };
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CONST_4;
  prim->chan_list.radio_freq = RADIO_FREQ_101;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = CONST_2;
  return prim;
}

T_PRIMITIVE_UNION mphc_update_ba_list_2a()
{
  const U16 RADIO_FREQ_101[33] = {
      23,1,11,15,20,24,25,26,
      0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
      0,0,0,0,0,0,0,0,
      0
  };
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = 8;
  prim->chan_list.radio_freq._show;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = CONST_2;
  return prim;
}

T_PRIMITIVE_UNION mphc_update_ba_list_3()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CONST_5;
  prim->chan_list.radio_freq = RADIO_FREQ_100;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = CONST_130;
  return prim;
}

T_PRIMITIVE_UNION mphc_update_ba_list_4()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_14;
  prim->chan_list.radio_freq = RF_DEDI_LARGE_1;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_2;
  return prim;
}
T_PRIMITIVE_UNION mphc_update_ba_list_5()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_24;
  prim->chan_list.radio_freq = RF_DEDI_LARGE_2;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_3;
  return prim;
}
T_PRIMITIVE_UNION mphc_update_ba_list_6()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_11;
  prim->chan_list.radio_freq = RF_AFTER_HO_LARGE_1;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_4;
  return prim;
}
T_PRIMITIVE_UNION mphc_update_ba_list_7()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_23;
  prim->chan_list.radio_freq = RF_AFTER_HO_LARGE_2;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_5;
  return prim;
}

T_PRIMITIVE_UNION mphc_update_ba_list_8()
{
const U16 RADIO_FREQ_23_1_124[33] = {
	ARFCN_23, ARFCN_1,ARFCN_124,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,
	0
};
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_3;
  prim->chan_list.radio_freq = RADIO_FREQ_23_1_124;
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_3;
  return prim;
}
T_PRIMITIVE_UNION mphc_meas_report_1()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = CONST_1;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = CONST_1;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = CONST_5;
  prim->ncell_meas.res_list = res_list_100();
  prim->ba_id = CONST_129;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_meas_report_2()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = CONST_63;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = CONST_63;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = CONST_5;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = CONST_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_46;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_6;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_47;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_53;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_124;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_13;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_23;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_1;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      ._skip;
    prim->ncell_meas.res_list[i].rxlev_acc      ._skip;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas ._skip;
  }

  prim->ba_id = CONST_1;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}
/********************************************************************* remove ?
T_PRIMITIVE_UNION mphc_meas_report_4()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = CONST_63;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = CONST_63;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = CONST_5;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_46;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_6;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_47;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_53;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_124;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_13;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = CONST_23;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_1;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      ._skip;
    prim->ncell_meas.res_list[i].rxlev_acc      ._skip;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas ._skip;
  }

  prim->ba_id = CONST_1;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}
***************************************************************/
T_PRIMITIVE_UNION mphc_meas_report_3()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = CONST_1;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = CONST_1;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = CONST_5;
  prim->ncell_meas.res_list = res_list_100();
  prim->ba_id = CONST_130;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_meas_report_4()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = 25;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = 25;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = 3;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_23;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_2;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_124;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;


  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      = NOT_PRESENT_16BIT;
    prim->ncell_meas.res_list[i].rxlev_acc      = 0;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas = 0;
  }

  prim->ba_id = BA_ID_3;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_meas_report_4a()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = 25;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = 25;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = 3;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_20;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_14;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_46;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;
  
  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_124;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;


  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      = NOT_PRESENT_16BIT;
    prim->ncell_meas.res_list[i].rxlev_acc      = 0;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas = 0;
  }

  prim->ba_id = BA_ID_3;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_meas_report_5()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = 25;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = 25;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = 3;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_14;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_2;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_124;
  prim->ncell_meas.res_list[i].rxlev_acc      = 25;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;


  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      = NOT_PRESENT_16BIT;
    prim->ncell_meas.res_list[i].rxlev_acc      = 0;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas = 0;
  }

  prim->ba_id = BA_ID_3;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_meas_report_6()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = 25;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = 25;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = 3;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_23;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = 60;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_11;
  prim->ncell_meas.res_list[i].rxlev_acc      = 50;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_15;
  prim->ncell_meas.res_list[i].rxlev_acc      = 40;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_20;
  prim->ncell_meas.res_list[i].rxlev_acc      = 30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_24;
  prim->ncell_meas.res_list[i].rxlev_acc      = 20;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_25;
  prim->ncell_meas.res_list[i].rxlev_acc      = 15;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_26;
  prim->ncell_meas.res_list[i].rxlev_acc      = 10;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      = NOT_PRESENT_16BIT;
    prim->ncell_meas.res_list[i].rxlev_acc      = 0;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas = 0;
  }

  prim->ba_id = BA_ID_3;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_meas_report_6a()
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = 25;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = 25;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  prim->no_of_ncells_meas = 3;
  //prim->ncell_meas.res_list = res_list_102();
  int i=0;
  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_23;
  prim->ncell_meas.res_list[i].rxlev_acc      = CONST_30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_1;
  prim->ncell_meas.res_list[i].rxlev_acc      = 60;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_11;
  prim->ncell_meas.res_list[i].rxlev_acc      = 50;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_15;
  prim->ncell_meas.res_list[i].rxlev_acc      = 40;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_20;
  prim->ncell_meas.res_list[i].rxlev_acc      = 30;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_24;
  prim->ncell_meas.res_list[i].rxlev_acc      = 20;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_25;
  prim->ncell_meas.res_list[i].rxlev_acc      = 10;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->ncell_meas.res_list[i].bcch_freq      = ARFCN_26;
  prim->ncell_meas.res_list[i].rxlev_acc      = 16;
  prim->ncell_meas.res_list[i].rxlev_nbr_meas = CONST_1;
  i++;

  prim->no_of_ncells_meas = i;

  for(;i<BA_LIST_SIZE;i++) {
    prim->ncell_meas.res_list[i].bcch_freq      = NOT_PRESENT_16BIT;
    prim->ncell_meas.res_list[i].rxlev_acc      = 0;
    prim->ncell_meas.res_list[i].rxlev_nbr_meas = 0;
  }

  prim->ba_id = BA_ID_3;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = NO_NCELLS_6;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_11;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_15;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_20;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_24;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_25;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6b()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = NO_NCELLS_6;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_11;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_15;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_20;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_24;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_26;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6a()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = 2;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_20;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_24;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = NO_NCELLS_2;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_224;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
  i++;

  prim->ncell_list[i]                 = ncell_arfcn_14();
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_114;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1a()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_1;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_1;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_14;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_14;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_124;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_124;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1b()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_2;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_23;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = TDMA_FRAMES_PER_HYPERFRAME - FN_OFF_ARFCN_124 + 1;
  prim->ncell_list[i].time_alignment  = 5000 - TIME_ALIGNMT_124;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = TDMA_FRAMES_PER_HYPERFRAME - FN_OFF_ARFCN_124 + FN_OFF_ARFCN_1 + 1;
  prim->ncell_list[i].time_alignment  = 5000 - TIME_ALIGNMT_124 + TIME_ALIGNMT_1;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1c()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = 0x01;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_14;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_14;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_124;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_124;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1d()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = NO_NCELLS_2;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1e()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd      = NC_MON;
  prim->list_size = 1;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1f()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_14;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1h()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_1;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_14;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_0;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_0;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32a()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_32;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_32;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_32;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32b()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_124;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_124;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_32;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFFSET_32;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_32;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}


T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32c()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_124;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_124;
  i++;

  prim->ncell_list[i].radio_freq      = ARFCN_25;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_14;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32d()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_3;
  int i=0;

  prim->ncell_list[i].radio_freq      = ARFCN_124;
  prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
  prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_124;
  prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_124;
  i++;

  //if(i != prim->list_size) ;/*do something! what?*/
  /* or do: */
  prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
  return prim;
  //prim->ncell_list = ncell_list_3_eotd_a();
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_2()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = NC_MON;
  prim->list_size = NO_NCELLS_6;
  prim->ncell_list = ncell_list_6_eotd_idle();
  return prim;
}



T_PRIMITIVE_UNION mphc_ncell_list_sync_req_3()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = EOTD_MON;
  prim->list_size = NO_NCELLS_6;
  prim->ncell_list = ncell_list_6_eotd_idle();
  return prim;
}
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_4(CHAR variant)
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd = EOTD_MON;
  if (variant == 'A')   prim->list_size = NO_NCELLS_6;
  if (variant == 'B')   prim->list_size = NO_NCELLS_8;
  if (variant == 'C')   prim->list_size = NO_NCELLS_6;

  if (variant == 'A') {
    int i=0;

    prim->ncell_list[i] = ncell_arfcn_637();
    i++;

    prim->ncell_list[i] = ncell_arfcn_25 ();
    i++;

    prim->ncell_list[i] = ncell_arfcn_14 ();
    i++;

    prim->ncell_list[i] = ncell_arfcn_512();
    i++;

    prim->ncell_list[i] = ncell_arfcn_580();
    i++;

    prim->ncell_list[i] = ncell_arfcn_885();
    i++;

    for(;i<MAX_NCELL_EOTD_L1;i++) {
      prim->ncell_list[i].radio_freq    ._skip;
      prim->ncell_list[i].time_alignment._skip;
      prim->ncell_list[i].fn_offset     ._skip;
      prim->ncell_list[i].timing_validity._skip;
    }
  } //prim->ncell_list = ncell_list_6_eotd_dedi();

  if (variant == 'B') {
    int i=0;

    prim->ncell_list[i] = ncell_arfcn_637();
    i++;

    prim->ncell_list[i] = ncell_arfcn_25 ();
    i++;

    prim->ncell_list[i] = ncell_arfcn_14 ();
    i++;

    prim->ncell_list[i] = ncell_arfcn_512();
    i++;

    prim->ncell_list[i] = ncell_arfcn_580();
    i++;

    prim->ncell_list[i] = ncell_arfcn_885();
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_516;
    prim->ncell_list[i].time_alignment= TIME_ALIGN_2328;
    prim->ncell_list[i].fn_offset     = FN_OFFSET_6;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_525;
    prim->ncell_list[i].time_alignment= TIME_ALIGN_2328;
    prim->ncell_list[i].fn_offset     = FN_OFFSET_6;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    for(;i<MAX_NCELL_EOTD_L1;i++) {
      prim->ncell_list[i].radio_freq    ._skip;
      prim->ncell_list[i].time_alignment._skip;
      prim->ncell_list[i].fn_offset     ._skip;
      prim->ncell_list[i].time_alignment._skip;
    }

    //  prim->ncell_list = ncell_list_8_eotd_dedi();
  }
  if (variant == 'C') {
    int i=0;

    prim->ncell_list[i].radio_freq    = ARFCN_23;
    prim->ncell_list[i].fn_offset     = 2715425;
    prim->ncell_list[i].time_alignment=  4986;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_637;
    prim->ncell_list[i].fn_offset     = 2715538;
    prim->ncell_list[i].time_alignment= 0;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_25;
    prim->ncell_list[i].fn_offset     = 796;
    prim->ncell_list[i].time_alignment= 0;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_512;
    prim->ncell_list[i].fn_offset     = 847;
    prim->ncell_list[i].time_alignment= 0;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_580;
    prim->ncell_list[i].fn_offset     = 796;
    prim->ncell_list[i].time_alignment= 0;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    prim->ncell_list[i].radio_freq    = ARFCN_885;
    prim->ncell_list[i].fn_offset     = 796;
    prim->ncell_list[i].time_alignment= 0;
    prim->ncell_list[i].timing_validity= TV_VALID_TIMING_INFO;
    i++;

    for(;i<MAX_NCELL_EOTD_L1;i++) {
      prim->ncell_list[i].radio_freq    ._skip;
      prim->ncell_list[i].fn_offset     ._skip;
      prim->ncell_list[i].time_alignment._skip;
      prim->ncell_list[i].timing_validity._skip;
    }
    //prim->ncell_list = ncell_list_6_eotd_dedi_after_ho();
  }
  return prim;
}




T_PRIMITIVE_UNION mphc_stop_ncell_sync_req(U16 arfcn)
{
  T_MPHC_STOP_NCELL_SYNC_REQ prim;
  prim->radio_freq_array_size = STOP_SIZE_1;

  int i=0;
  prim->radio_freq_array[i] = arfcn;
  i++;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->radio_freq_array[i] = 0;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_sync_req_all()
{
  T_MPHC_STOP_NCELL_SYNC_REQ prim;
  prim->radio_freq_array_size = STOP_SIZE_12;
  for(int i=0; i<STOP_SIZE_12;i++) {
    prim->radio_freq_array[i] = 0;
  }
  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->radio_freq_array[i]._require;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_sync_con()
{
  T_MPHC_STOP_NCELL_SYNC_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_sync_req_dummy()
{
  T_MPHC_STOP_NCELL_SYNC_REQ prim;
  prim->radio_freq_array_size._show;
  prim->radio_freq_array._show;
  return prim;
}

T_PRIMITIVE_UNION mph_ncell_pos_ind_1()
{
  T_MPH_NCELL_POS_IND prim;
  prim->req_id = REQ_ID_FFFF;
  prim->eotd_res = EOTD_SUCC;
  prim->ta = TA_NOT_AVAIL;
  prim->fn = FN_OFFSET_0;
  prim->eotd_sc_res = eotd_sc_res_ok();
  prim->eotd_sc_res1 = eotd_sc_res1_ok();
  prim->eotd_nc_res = eotd_result_6();
  return prim;
}
T_PRIMITIVE_UNION mph_ncell_pos_ind_3()
{
  T_MPH_NCELL_POS_IND prim;
  prim->req_id = REQ_ID_1;
  prim->eotd_res = EOTD_SUCC;
  prim->ta._skip;
  prim->fn = FN_OFFSET_0;
  prim->eotd_sc_res = eotd_sc_res_ok();
  prim->eotd_sc_res1 = eotd_sc_res1_ok();
  prim->eotd_nc_res = eotd_result_6();
  return prim;
}


T_PRIMITIVE_UNION mph_ncell_pos_ind_4()
{
  T_MPH_NCELL_POS_IND prim;
  prim->req_id = REQ_ID_8;
  prim->eotd_res = EOTD_SUCC;
  prim->ta._skip;
  prim->fn = FN_OFFSET_0;
  prim->eotd_sc_res = eotd_sc_res_ok();
  prim->eotd_sc_res1 = eotd_sc_res1_ok();
  //   prim->eotd_nc_res = eotd_result_8();
  int i=0;
  prim->eotd_nc_res[i] = eotd_nc_res_637();
  i++;
  prim->eotd_nc_res[i] = eotd_nc_res_25();
  i++;
  prim->eotd_nc_res[i] = eotd_nc_res_14();
  i++;
  prim->eotd_nc_res[i] = eotd_nc_res_512();
  i++;
  prim->eotd_nc_res[i] = eotd_nc_res_580();
  i++;
  prim->eotd_nc_res[i] = eotd_nc_res_885();
  i++;
  prim->eotd_nc_res[i].arfcn         = ARFCN_516;
  prim->eotd_nc_res[i].bsic          = BSIC_10;
  prim->eotd_nc_res[i].sb_flag       = SB_TRUE;
  prim->eotd_nc_res[i].d_eotd_nrj    = RSSI_61440;
  prim->eotd_nc_res[i].eotd_crosscor = EOTD_CROSSCOR_6;
  prim->eotd_nc_res[i].time_tag      = NOM_POS_1000;
  i++;
  prim->eotd_nc_res[i].arfcn         = ARFCN_525;
  prim->eotd_nc_res[i].bsic          = BSIC_10;
  prim->eotd_nc_res[i].sb_flag       = SB_TRUE;
  prim->eotd_nc_res[i].d_eotd_nrj    = RSSI_61952;
  prim->eotd_nc_res[i].eotd_crosscor = EOTD_CROSSCOR_9;
  prim->eotd_nc_res[i].time_tag      = NOM_POS_2000;
  i++;
  return prim;
}



T_PRIMITIVE_UNION mphc_stop_rxlev_periodic_con_1()
{
  T_MPHC_STOP_RXLEV_PERIODIC_CON prim;
  prim->param._skip;
  return prim;
}


T_PRIMITIVE_UNION mph_ncell_pos_req_2(CHAR variant)
{
  T_MPH_NCELL_POS_REQ prim;
  if (variant == 'A')   prim->req_id = REQ_ID_1;
  if (variant == 'B')   prim->req_id = REQ_ID_8;
  if (variant == 'A') {
    //prim->ncell_eotd = ncell_eotd_7();
    int i=0;

    prim->ncell_eotd[i] = arfcn_23_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_637_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_25_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_14_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_512_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_580_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_885_eotd();
    i++;
    /* this is a [1..MAX_NCELL_EOTD_ALR] array */
    /* so we don't have to skip the rest */
  }
  if (variant == 'B') {
    //    prim->ncell_eotd = ncell_eotd_9();
    int i=0;

    prim->ncell_eotd[i] = arfcn_23_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_637_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_25_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_14_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_512_eotd();
    i++;

    prim->ncell_eotd[i].arfcn       = ARFCN_516;
    prim->ncell_eotd[i].bsic        = BSIC_10;
    prim->ncell_eotd[i].mfrm_offset = MFRM_OFFSET_44;
    prim->ncell_eotd[i].otd_type    = EXPECTED_OTD;
    prim->ncell_eotd[i].exp_otd     = OTD_666;
    prim->ncell_eotd[i].uncertainty = UNC_MAX_2BIT;
    prim->ncell_eotd[i].rough_rtd   = OTD_666;
    i++;

    prim->ncell_eotd[i].arfcn       = ARFCN_525;
    prim->ncell_eotd[i].bsic        = BSIC_10;
    prim->ncell_eotd[i].mfrm_offset = MFRM_OFFSET_44;
    prim->ncell_eotd[i].otd_type    = EXPECTED_OTD;
    prim->ncell_eotd[i].exp_otd     = OTD_666;
    prim->ncell_eotd[i].uncertainty = UNC_MAX_2BIT;
    prim->ncell_eotd[i].rough_rtd   = OTD_666;
    i++;

    prim->ncell_eotd[i] = arfcn_580_eotd();
    i++;

    prim->ncell_eotd[i] = arfcn_885_eotd();
    i++;

    /* this is a [1..MAX_NCELL_EOTD_ALR] array */
    /* so we don't have to skip the rest */
  }
  return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_3g()
{
   T_MPH_NEIGHBOURCELL_REQ prim;
   prim->multi_band = MULTI_BAND_0;
   prim->arfcn = CHLIST_1_14_124_FFFF;
   prim->sync_only = SYNC_LIST;
   return prim;
}
const U8 NCELLS_14_BSIC_PBCCH_elements[1] = {
 	BSIC_1
};
T_ARRAY<U8> NCELLS_14_BSIC_PBCCH(NCELLS_14_BSIC_PBCCH_elements, SKIP_TO_END);

const U8 NCELLS_124_BSIC_PBCCH_elements[1] = {
 	NOT_PRESENT_8BIT
};
T_ARRAY<U8> NCELLS_124_BSIC_PBCCH(NCELLS_124_BSIC_PBCCH_elements, SKIP_TO_END);

const U8 NCELLS_10_BSIC_PBCCH_elements[1] = {
 	BSIC_2
};
T_ARRAY<U8> NCELLS_10_BSIC_PBCCH(NCELLS_10_BSIC_PBCCH_elements, SKIP_TO_END);

const U16 CHLIST_14_PBCCH_elements[1] = {
 	ARFCN_14
};
T_ARRAY<U16> CHLIST_14_PBCCH(CHLIST_14_PBCCH_elements, SKIP_TO_END);

const U16 CHLIST_124_PBCCH_elements[1] = {
 	ARFCN_124
};
T_ARRAY<U16> CHLIST_124_PBCCH(CHLIST_124_PBCCH_elements, SKIP_TO_END);

const U16 CHLIST_10_PBCCH_elements[1] = {
 	ARFCN_10
};
T_ARRAY<U16> CHLIST_10_PBCCH(CHLIST_10_PBCCH_elements, SKIP_TO_END);
const U16 CHLIST_14_124_10_PBCCH_elements[4] = {
 	ARFCN_14,
	ARFCN_124,
	ARFCN_10,
	NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_14_124_10_PBCCH(CHLIST_14_124_10_PBCCH_elements, SKIP_TO_END);


T_ncells ncells_14_pbcch()
{
   T_ncells pstruct;
   pstruct->no_of_ncells = 1;
   pstruct->arfcn = CHLIST_14_PBCCH;
   pstruct->rx_lev._skip;
   pstruct->bsic = NCELLS_14_BSIC_PBCCH;
   pstruct->time_alignmt._skip;
   pstruct->frame_offset._skip;
   return pstruct;
}
T_ncells ncells_124_pbcch()
{
   T_ncells pstruct;
   pstruct->no_of_ncells = 1;
   pstruct->arfcn = CHLIST_124_PBCCH;
   pstruct->rx_lev._skip;
   pstruct->bsic = NCELLS_124_BSIC_PBCCH;
   pstruct->time_alignmt._skip;
   pstruct->frame_offset._skip;
   return pstruct;
}
T_ncells ncells_10_pbcch()
{
   T_ncells pstruct;
   pstruct->no_of_ncells = 1;
   pstruct->arfcn = CHLIST_10_PBCCH;
   pstruct->rx_lev._skip;
   pstruct->bsic = NCELLS_10_BSIC_PBCCH;
   pstruct->time_alignmt._skip;
   pstruct->frame_offset._skip;
   return pstruct;
}

T_PRIMITIVE_UNION mph_measurement_ind_1g()
{
   T_MPH_MEASUREMENT_IND prim;
   prim->arfcn._skip;
   prim->rx_lev_full._skip;
   prim->rx_lev_sub._skip;
   prim->rx_qual_full._skip;
   prim->rx_qual_sub._skip;
   prim->dtx._skip;
   prim->otd._skip;
   prim->valid._skip;
   prim->fn_offset._skip;
   prim->ncells = ncells_14_pbcch();
   prim->gprs_sync = SYNC_RESULTS;
   prim->bcch_rxlev_of_sc._skip;
   return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_2g()
{
   T_MPH_MEASUREMENT_IND prim;
   prim->arfcn._skip;
   prim->rx_lev_full._skip;
   prim->rx_lev_sub._skip;
   prim->rx_qual_full._skip;
   prim->rx_qual_sub._skip;
   prim->dtx._skip;
   prim->otd._skip;
   prim->valid._skip;
   prim->fn_offset._skip;
   prim->ncells = ncells_124_pbcch();
   prim->gprs_sync = SYNC_RESULTS;
   prim->bcch_rxlev_of_sc._skip;
   return prim;
}
T_PRIMITIVE_UNION mph_neighbourcell_req_4g()
{
   T_MPH_NEIGHBOURCELL_REQ prim;
   prim->multi_band = MULTI_BAND_0;
   prim->arfcn = CHLIST_14_124_10_PBCCH;
   prim->sync_only = SYNC_LIST;
   return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_req_4g()
{
   T_MPHC_NCELL_SYNC_REQ prim;
   prim->radio_freq = ARFCN_10;
   prim->fn_offset._skip;
   prim->time_alignment._skip;
   prim->timing_validity = TV_INVALID_TIMING_INFO;
   return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_3g()
{
   T_MPH_MEASUREMENT_IND prim;
   prim->arfcn.       _skip;
   prim->rx_lev_full. _skip;
   prim->rx_lev_sub.  _skip;
   prim->rx_qual_full._skip;
   prim->rx_qual_sub. _skip;
   prim->dtx.         _skip;
   prim->otd.         _skip;
   prim->valid.       _skip;
   prim->fn_offset.   _skip;
   prim->ncells     = ncells_10_pbcch();
   prim->gprs_sync  = SYNC_RESULTS;
   prim->bcch_rxlev_of_sc._skip;
   return prim;
}
T_PRIMITIVE_UNION mph_measurement_ind_4g()
{
  const U16 arfcn_elements[] = {
 	  ARFCN_1
  };
  T_ARRAY<U16> arfcn(arfcn_elements, SKIP_TO_END);

  const U8 bsics_elements[] = {
 	  MPH_BSIC_UNKNOWN
  };
  T_ARRAY<U8> bsics(bsics_elements, SKIP_TO_END);


  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn.       _skip;
  prim->rx_lev_full. _skip;
  prim->rx_lev_sub.  _skip;
  prim->rx_qual_full._skip;
  prim->rx_qual_sub. _skip;
  prim->dtx.         _skip;
  prim->otd.         _skip;
  prim->valid.       _skip;
  prim->fn_offset.   _skip;
  prim->ncells.no_of_ncells = 1;
  prim->ncells.arfcn = arfcn;
  prim->ncells.rx_lev._skip;
  prim->ncells.bsic = bsics;
  prim->ncells.time_alignmt._skip;
  prim->ncells.frame_offset._skip;
  prim->gprs_sync  = SYNC_RESULTS;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1g()
{
   T_MPHC_NCELL_LIST_SYNC_REQ prim;
   prim->eotd._skip;
   prim->list_size  = LIST_SIZE2;
   int i=0;

   prim->ncell_list[i].radio_freq      = ARFCN_14;
   prim->ncell_list[i].fn_offset       = FN_OFF_ARFCN_14;
   prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_14;
   prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
   i++;

   prim->ncell_list[i].radio_freq      = ARFCN_10;
   prim->ncell_list[i].fn_offset       = FN_OFFSET_10;
   prim->ncell_list[i].time_alignment  = TIME_ALIGNMT_10;
   prim->ncell_list[i].timing_validity = TV_VALID_TIMING_INFO;
   i++;

   //if(i != prim->list_size) ;/*do something! what?*/
   /* or do: */
   prim->list_size = i;

  for(;i<MAX_NCELL_EOTD_L1;i++) {
    prim->ncell_list[i].radio_freq    ._skip;
    prim->ncell_list[i].time_alignment._skip;
    prim->ncell_list[i].fn_offset     ._skip;
    prim->ncell_list[i].time_alignment._skip;
  }
   return prim;
}

T_PRIMITIVE_UNION mphc_ncell_sync_ind_3g()
{
   T_MPHC_NCELL_SYNC_IND prim;
   prim->radio_freq     = ARFCN_10;
   prim->sb_flag        = SB_FOUND;
   prim->fn_offset      = FN_OFFSET_10;
   prim->time_alignment = TIME_ALIGNMT_10;
   prim->bsic           = BSIC_2;
   prim->neigh_id.        _skip;
   prim->attempt._skip;
   prim->pm._skip;
   prim->toa._skip;
   prim->angle._skip;
   prim->snr._skip;
   prim->eodt_data_valid = EOTD_NOT_PRES;
   prim->mode._skip;
   prim->d_eotd_first._skip;
   prim->d_eotd_max._skip;
   prim->d_eotd_nrj._skip;
   prim->a_eotd_crosscor._skip;
   prim->time_tag._skip;
   prim->fn_sb_neigh._skip;
   prim->fn_in_sb._skip;
   prim->toa_correction._skip;
   prim->delta_fn._skip;
   prim->delta_qbit._skip;
   return prim;
}

T_PRIMITIVE_UNION mph_neighbourcell_req_plmn_search(U16 cell1, U16 cell2)
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  U16 elems[] = { cell1, cell2, NOT_PRESENT_16BIT };
  T_ARRAY<U16> a(elems, SKIP_TO_END);
  prim->arfcn = a;
  prim->sync_only = SYNC_LIST;
  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_plmn_search(U16 cell1, U8 bsic1, U16 cell2, U8 bsic2)
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn        ._skip;
  prim->rx_lev_full  ._skip;
  prim->rx_lev_sub   ._skip;
  prim->rx_qual_full ._skip;
  prim->rx_qual_sub  ._skip;
  prim->dtx          ._skip;
  prim->otd          ._skip;
  prim->valid        ._skip;
  prim->fn_offset    ._skip;

  int i = 0;

  if(cell2 != NOT_PRESENT_16BIT) {
    prim->ncells.no_of_ncells = i = 2;
    prim->ncells.arfcn[1]        = cell2;
    prim->ncells.bsic[1]         = bsic2;
    prim->ncells.rx_lev[1]       = 0;
    prim->ncells.frame_offset[1] = 0;
    prim->ncells.time_alignmt[1] = 0;
  } else {
    prim->ncells.no_of_ncells = i = 1;
  }
  prim->ncells.arfcn[0]       = cell1;
  prim->ncells.bsic[0]        = bsic1;
  prim->ncells.frame_offset[0]= 0;
  prim->ncells.rx_lev[0]      = 0;
  prim->ncells.time_alignmt[0]= 0;

#ifdef FF_EGPRS
  int maxnum = MAX_NUM_CELLS_IN_REPORT;
#else // FF_EGPRS
  int maxnum = 6;
#endif  // FF_EGPRS

  for(;i<maxnum;i++)
  {
    prim->ncells.arfcn[i]        =0;//._skip;
    prim->ncells.bsic[i]         =0;//._skip;
    prim->ncells.frame_offset[i] =0;//._skip;
    prim->ncells.rx_lev[i]       =0;//._skip;
    prim->ncells.time_alignmt[i] =0;//._skip;
  }
  prim->gprs_sync = SYNC_RESULTS;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}

#ifdef  FF_EGPRS
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_emr()
{
  T_MPHC_NCELL_LIST_SYNC_REQ prim;
  prim->eotd._show;
  prim->list_size._show;
  prim->ncell_list._show;
  return prim;
}

const U16 CHLIST_BA_BCCH_EMR_FFFF_elements[9] = {
 	ARFCN_1,
	ARFCN_15,
  ARFCN_30,
	ARFCN_46,
	ARFCN_59,
	ARFCN_73,
	ARFCN_90,
	ARFCN_108,
	NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_BA_BCCH_EMR_FFFF(CHLIST_BA_BCCH_EMR_FFFF_elements, SKIP_TO_END);

T_PRIMITIVE_UNION mph_neighbourcell_req_emr_1()
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_0;
  prim->arfcn = CHLIST_BA_BCCH_EMR_FFFF;
  prim->sync_only._skip;
  return prim;
}

const U16 RF_23_EMR_BA_BCCH_elements[9] = {
  ARFCN_1,
	ARFCN_15,
  ARFCN_30,
	ARFCN_46,
	ARFCN_59,
	ARFCN_73,
	ARFCN_90,
	ARFCN_108,
  ARFCN_23
};

T_ARRAY<U16> RF_23_EMR_BA_BCCH(RF_23_EMR_BA_BCCH_elements, SKIP_TO_END);

T_PRIMITIVE_UNION mphc_rxlev_periodic_req_emr_1()
{
  T_MPHC_RXLEV_PERIODIC_REQ prim;

  prim->chan_list.radio_freq = RF_23_EMR_BA_BCCH;
  prim->num_of_chans = CHANNELS_9;
  prim->ba_id = BA_ID_1;
  prim->next_radio_freq_measured = CHAN_LIST_IDX_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_emr_1()
{
  T_MPHC_RXLEV_PERIODIC_IND prim;

  prim->s_rxlev = RXLEV_56;
  prim->ba_id = BA_ID_1;

  prim->nbr_of_carriers = 8;
  prim->result[0].radio_freq = ARFCN_1;
  prim->result[0].rxlev   = CONST_10;
	prim->result[1].radio_freq = ARFCN_15;
  prim->result[1].rxlev   = CONST_12;
  prim->result[2].radio_freq = ARFCN_30;
  prim->result[2].rxlev   = CONST_13;
	prim->result[3].radio_freq = ARFCN_46;
  prim->result[3].rxlev   = CONST_20;
	prim->result[4].radio_freq = ARFCN_59;
  prim->result[4].rxlev   = CONST_23;
	prim->result[5].radio_freq = ARFCN_73;
  prim->result[5].rxlev   = CONST_30;
	prim->result[6].radio_freq = ARFCN_90;
  prim->result[6].rxlev   = CONST_46;
	prim->result[7].radio_freq = ARFCN_108;
  prim->result[7].rxlev   = CONST_47;

  return prim;
}

T_PRIMITIVE_UNION mph_measurement_ind_emr_1()
{
  T_MPH_MEASUREMENT_IND prim;
  prim->arfcn = ARFCN_23;
  prim->rx_lev_full._show;
  prim->rx_lev_sub._show;
  prim->rx_qual_full._show;
  prim->rx_qual_sub._show;
  prim->dtx._show;
  prim->otd._show;
  prim->valid = VALID_REPORT;
  prim->fn_offset._show;
  prim->ncells._show;
  prim->gprs_sync._show;
  prim->bsic_seen._show;
  prim->mean_bep._show;
  prim->cv_bep._show;
  prim->nbr_rcvd_blks._show;
  prim->nc_index._show;
  prim->rxlev_val._show;
  prim->scale_used._show;
  prim->bcch_rxlev_of_sc._skip;
  return prim;
}


T_PRIMITIVE_UNION mphc_ncell_sync_ind_emr(U16 arfcn, U8 bsic,U8 sb_status)
{
   T_MPHC_NCELL_SYNC_IND prim;
   prim->radio_freq     = arfcn;
   prim->sb_flag        = sb_status;
   prim->fn_offset      = FN_OFFSET_10;
   prim->time_alignment = TIME_ALIGNMT_10;
   prim->bsic           = bsic;
   prim->neigh_id.        _skip;
   prim->attempt._skip;
   prim->pm._skip;
   prim->toa._skip;
   prim->angle._skip;
   prim->snr._skip;
   prim->eodt_data_valid = EOTD_NOT_PRES;
   prim->mode._skip;
   prim->d_eotd_first._skip;
   prim->d_eotd_max._skip;
   prim->d_eotd_nrj._skip;
   prim->a_eotd_crosscor._skip;
   prim->time_tag._skip;
   prim->fn_sb_neigh._skip;
   prim->fn_in_sb._skip;
   prim->toa_correction._skip;
   prim->delta_fn._skip;
   prim->delta_qbit._skip;
   return prim;
}

T_PRIMITIVE_UNION mphc_ncell_bcch_req_emr(U16 arfcn)
{
  T_MPHC_NCELL_BCCH_REQ prim;
  prim->radio_freq = arfcn;
  prim->fn_offset._show;
  prim->time_alignment._show;
  prim->tsc._show;
  prim->bcch_blocks_required._show;
  prim->gprs_prio._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_bcch_req_emr()
{
  T_MPHC_STOP_NCELL_BCCH_REQ prim;
  prim->radio_freq_array_size._show;
  prim->radio_freq_array._show;
  return prim;
}

T_ARRAY<T_res_list> res_list_emr_A()
{
  T_res_list array[33];

  array[0]->bcch_freq      = ARFCN_1;
  array[0]->rxlev_acc      = CONST_30;
  array[0]->rxlev_nbr_meas = CONST_1;

  array[1]->bcch_freq      = ARFCN_15;
  array[1]->rxlev_acc      = CONST_6;
  array[1]->rxlev_nbr_meas = CONST_1;

  array[2]->bcch_freq      = ARFCN_30;
  array[2]->rxlev_acc      = CONST_53;
  array[2]->rxlev_nbr_meas = CONST_1;

  array[3]->bcch_freq      = ARFCN_46;
  array[3]->rxlev_acc      = CONST_13;
  array[3]->rxlev_nbr_meas = CONST_1;

  array[4]->bcch_freq      = ARFCN_59;
  array[4]->rxlev_acc      = CONST_10;
  array[4]->rxlev_nbr_meas = CONST_1;

  array[5]->bcch_freq      = ARFCN_73;
  array[5]->rxlev_acc      = CONST_20;
  array[5]->rxlev_nbr_meas = CONST_1;

  array[6]->bcch_freq      = ARFCN_90;
  array[6]->rxlev_acc      = CONST_47;
  array[6]->rxlev_nbr_meas = CONST_1;

  array[7]->bcch_freq      = ARFCN_108;
  array[7]->rxlev_acc      = CONST_73;
  array[7]->rxlev_nbr_meas = CONST_1;

  for(int i=8;i<BA_LIST_SIZE;i++) {
    array[i]->bcch_freq      ._skip;
    array[i]->rxlev_acc      ._skip;
    array[i]->rxlev_nbr_meas ._skip;
  }

  return array;
}



T_ARRAY<T_res_list> res_list_emr_B()
{
  T_res_list array[33];

  array[0]->bcch_freq      = ARFCN_30;
  array[0]->rxlev_acc      = CONST_10;
  array[0]->rxlev_nbr_meas = CONST_1;

  array[1]->bcch_freq      = ARFCN_46;
  array[1]->rxlev_acc      = CONST_63;
  array[1]->rxlev_nbr_meas = CONST_1;

  array[2]->bcch_freq      = ARFCN_59;
  array[2]->rxlev_acc      = CONST_13;
  array[2]->rxlev_nbr_meas = CONST_1;

  array[3]->bcch_freq      = ARFCN_73;
  array[3]->rxlev_acc      = CONST_53;
  array[3]->rxlev_nbr_meas = CONST_1;

  array[4]->bcch_freq      = ARFCN_90;
  array[4]->rxlev_acc      = CONST_30;
  array[4]->rxlev_nbr_meas = CONST_1;

  array[5]->bcch_freq      = ARFCN_108;
  array[5]->rxlev_acc      = CONST_73;
  array[5]->rxlev_nbr_meas = CONST_1;

  array[6]->bcch_freq      = ARFCN_512;
  array[6]->rxlev_acc      = CONST_5;
  array[6]->rxlev_nbr_meas = CONST_1;

  array[7]->bcch_freq      = ARFCN_513;
  array[7]->rxlev_acc      = CONST_47;
  array[7]->rxlev_nbr_meas = CONST_1;

  array[8]->bcch_freq      = ARFCN_516;
  array[8]->rxlev_acc      = CONST_12;
  array[8]->rxlev_nbr_meas = CONST_1;

  array[9]->bcch_freq      = ARFCN_525;
  array[9]->rxlev_acc      = CONST_16;
  array[9]->rxlev_nbr_meas = CONST_1;

  array[10]->bcch_freq      = ARFCN_578;
  array[10]->rxlev_acc      = CONST_20;
  array[10]->rxlev_nbr_meas = CONST_1;

  array[11]->bcch_freq      = ARFCN_580;
  array[11]->rxlev_acc      = CONST_63;
  array[11]->rxlev_nbr_meas = CONST_1;

  array[12]->bcch_freq      = ARFCN_581;
  array[12]->rxlev_acc      = CONST_23;
  array[12]->rxlev_nbr_meas = CONST_1;

  array[13]->bcch_freq      = ARFCN_582;
  array[13]->rxlev_acc      = CONST_5;
  array[13]->rxlev_nbr_meas = CONST_1;

  array[14]->bcch_freq      = ARFCN_583;
  array[14]->rxlev_acc      = CONST_8;
  array[14]->rxlev_nbr_meas = CONST_1;

  array[15]->bcch_freq      = ARFCN_584;
  array[15]->rxlev_acc      = CONST_53;
  array[15]->rxlev_nbr_meas = CONST_1;


  for(int i=16;i<BA_LIST_SIZE;i++) {
    array[i]->bcch_freq      ._skip;
    array[i]->rxlev_acc      ._skip;
    array[i]->rxlev_nbr_meas ._skip;
  }

  return array;
}


T_ARRAY<T_res_list> res_list_emr_C()
{
  T_res_list array[33];

  array[0]->bcch_freq      = ARFCN_30;
  array[0]->rxlev_acc      = CONST_10;
  array[0]->rxlev_nbr_meas = CONST_1;

  array[1]->bcch_freq      = ARFCN_46;
  array[1]->rxlev_acc      = CONST_10;
  array[1]->rxlev_nbr_meas = CONST_1;

  array[2]->bcch_freq      = ARFCN_59;
  array[2]->rxlev_acc      = CONST_13;
  array[2]->rxlev_nbr_meas = CONST_1;

  array[3]->bcch_freq      = ARFCN_73;
  array[3]->rxlev_acc      = CONST_20;
  array[3]->rxlev_nbr_meas = CONST_1;

  array[4]->bcch_freq      = ARFCN_90;
  array[4]->rxlev_acc      = CONST_30;
  array[4]->rxlev_nbr_meas = CONST_1;

  array[5]->bcch_freq      = ARFCN_108;
  array[5]->rxlev_acc      = CONST_73;
  array[5]->rxlev_nbr_meas = CONST_1;

  array[6]->bcch_freq      = ARFCN_512;
  array[6]->rxlev_acc      = CONST_53;
  array[6]->rxlev_nbr_meas = CONST_1;

  array[7]->bcch_freq      = ARFCN_513;
  array[7]->rxlev_acc      = CONST_30;
  array[7]->rxlev_nbr_meas = CONST_1;

  array[8]->bcch_freq      = ARFCN_516;
  array[8]->rxlev_acc      = CONST_63;
  array[8]->rxlev_nbr_meas = CONST_1;

  array[9]->bcch_freq      = ARFCN_525;
  array[9]->rxlev_acc      = CONST_16;
  array[9]->rxlev_nbr_meas = CONST_1;

  array[10]->bcch_freq      = ARFCN_578;
  array[10]->rxlev_acc      = CONST_30;
  array[10]->rxlev_nbr_meas = CONST_1;

  array[11]->bcch_freq      = ARFCN_580;
  array[11]->rxlev_acc      = CONST_20;
  array[11]->rxlev_nbr_meas = CONST_1;

  array[12]->bcch_freq      = ARFCN_581;
  array[12]->rxlev_acc      = CONST_23;
  array[12]->rxlev_nbr_meas = CONST_1;

  array[13]->bcch_freq      = ARFCN_582;
  array[13]->rxlev_acc      = CONST_47;
  array[13]->rxlev_nbr_meas = CONST_1;

  array[14]->bcch_freq      = ARFCN_583;
  array[14]->rxlev_acc      = CONST_53;
  array[14]->rxlev_nbr_meas = CONST_1;

  array[15]->bcch_freq      = ARFCN_584;
  array[15]->rxlev_acc      = CONST_20;
  array[15]->rxlev_nbr_meas = CONST_1;


  for(int i=16;i<BA_LIST_SIZE;i++) {
    array[i]->bcch_freq      ._skip;
    array[i]->rxlev_acc      ._skip;
    array[i]->rxlev_nbr_meas ._skip;
  }

  return array;
}

T_PRIMITIVE_UNION mphc_meas_report_emr(char variant)
{
  T_MPHC_MEAS_REPORT prim;
  prim->dtx_used = DTX_USED;
  prim->meas_valid = MEAS_ARE_VALID;
  prim->rxlev_full_acc = CONST_63;
  prim->rxlev_full_nbr_meas = CONST_1;
  prim->rxlev_sub_acc = CONST_30;
  prim->rxlev_sub_nbr_meas = CONST_1;
  prim->rxqual_full_acc_errors = CONST_1;
  prim->rxqual_full_nbr_bits = CONST_1;
  prim->rxqual_sub_acc_errors = CONST_1;
  prim->rxqual_sub_nbr_bits = CONST_1;
  if (variant == 'A')
  {
    prim->no_of_ncells_meas = CONST_8;
    prim->ncell_meas.res_list = res_list_emr_A();
    prim->mean_bep_block_acc = 16856941;
    prim->cv_bep_block_acc = 145;
  }
  else if (variant == 'B')
  {
    prim->no_of_ncells_meas = CONST_16;
    prim->ncell_meas.res_list = res_list_emr_B();
    prim->mean_bep_block_acc = 6710886;
    prim->cv_bep_block_acc = 384;
  } else if (variant == 'C')
  {
    prim->no_of_ncells_meas = CONST_16;
    prim->ncell_meas.res_list = res_list_emr_C();
    prim->mean_bep_block_acc = 168443;
    prim->cv_bep_block_acc = 448;
  }
  prim->ba_id = CONST_1;
  prim->timing_advance = CONST_1;
  prim->txpwr_used = CONST_1;
  prim->bep_block_num = CONST_6;
  prim->nbr_rcvd_blocks = CONST_4;
  prim->rxlev_val_acc = CONST_73;
  prim->rxlev_val_nbr_meas = CONST_1;
  return prim;
}

const U16 CHLIST_BA_SACCH_EMR_FFFF_elements[17] = {
 	ARFCN_30,
	ARFCN_46,
	ARFCN_59,
	ARFCN_73,
	ARFCN_90,
	ARFCN_108,
  ARFCN_512,
  ARFCN_513,
  ARFCN_516,
  ARFCN_525,
  ARFCN_578,
  ARFCN_580,
  ARFCN_581,
  ARFCN_582,
  ARFCN_583,
  ARFCN_584,
	NOT_PRESENT_16BIT
};

T_ARRAY<U16> CHLIST_BA_SACCH_EMR_FFFF(CHLIST_BA_SACCH_EMR_FFFF_elements, SKIP_TO_END);

T_PRIMITIVE_UNION mph_neighbourcell_req_emr_2()
{
  T_MPH_NEIGHBOURCELL_REQ prim;
  prim->multi_band = MULTI_BAND_2;
  prim->arfcn = CHLIST_BA_SACCH_EMR_FFFF;
  prim->sync_only._skip;
  return prim;
}

const U16 RF_23_EMR_BA_SACCH_elements[17] = {
  ARFCN_30,
	ARFCN_46,
	ARFCN_59,
	ARFCN_73,
	ARFCN_90,
	ARFCN_108,
  ARFCN_23,
  ARFCN_512,
  ARFCN_513,
  ARFCN_516,
  ARFCN_525,
  ARFCN_578,
  ARFCN_580,
  ARFCN_581,
  ARFCN_582,
  ARFCN_583,
  ARFCN_584
};

T_ARRAY<U16> RF_23_EMR_BA_SACCH(RF_23_EMR_BA_SACCH_elements, SKIP_TO_END);

T_PRIMITIVE_UNION mphc_update_ba_list_emr()
{
  T_MPHC_UPDATE_BA_LIST prim;
  prim->num_of_chans = CHANNELS_17;
  prim->chan_list.radio_freq._show; /* = RF_23_EMR_BA_SACCH;*/
  prim->pwrc = PWRC_NOT_SET;
  prim->dtx_allowed = DTX_NOTALLOWED;
  prim->ba_id = BA_ID_2;
  return prim;
}
#endif  // FF_EGPRS

T_PRIMITIVE_UNION mph_meas_rep_req( U8 meas_cause)
{
  T_MPH_MEAS_REP_REQ prim;
  prim->cause = meas_cause;
  return prim;
}

T_PRIMITIVE_UNION mph_meas_rep_cnf_sc()
{
  T_MPH_MEAS_REP_CNF prim;

  int count = 0;
  prim->meas_rep[count].arfcn = ARFCN_23;
  prim->meas_rep[count].bsic = BA_ID_1;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = 0xffff;
  prim->meas_rep[count].bsic = 0xff;
  prim->meas_rep[count].rx_lev = 0xff;
  count++;


  for (;count<7;count++) {
    prim->meas_rep[count].arfcn._show;
    prim->meas_rep[count].bsic._show;
    prim->meas_rep[count].rx_lev._show;
  }
  return prim;

}

T_PRIMITIVE_UNION mph_meas_rep_cnf_sc_n1()
{
  T_MPH_MEAS_REP_CNF prim;

  int count = 0;
  prim->meas_rep[count].arfcn = ARFCN_23;
  prim->meas_rep[count].bsic = BA_ID_1;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = ARFCN_512;
  prim->meas_rep[count].bsic = BSIC_10;
  prim->meas_rep[count].rx_lev._show;
  count++;


  for (;count<7;count++) {
    prim->meas_rep[count].arfcn._show;
    prim->meas_rep[count].bsic._show;
    prim->meas_rep[count].rx_lev._show;
  }
  return prim;

}


T_PRIMITIVE_UNION mph_meas_rep_cnf_sc_n3()
{
  T_MPH_MEAS_REP_CNF prim;

  int count = 0;
  prim->meas_rep[count].arfcn = ARFCN_23;
  prim->meas_rep[count].bsic = BA_ID_1;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = ARFCN_1;
  prim->meas_rep[count].bsic = BSIC_16;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = ARFCN_14;
  prim->meas_rep[count].bsic ._show;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = ARFCN_124;
  prim->meas_rep[count].bsic ._show;
  prim->meas_rep[count].rx_lev._show;
  count ++;

  prim->meas_rep[count].arfcn = 0xffff;
  prim->meas_rep[count].bsic = 0xff;
  prim->meas_rep[count].rx_lev = 0xff;

  count++;


  for (;count<7;count++) {
    prim->meas_rep[count].arfcn._show;
    prim->meas_rep[count].bsic._show;
    prim->meas_rep[count].rx_lev._show;
  }
  return prim;

}

