/*
  +------------------------------------------------------------------------------
  |  File:       alr_dedicated_constraints.cpp
  +------------------------------------------------------------------------------
  |              Copyright 2003 Texas Instruments
  |              All rights reserved.
  |
  |              This file is confidential and a trade secret of Texas Instruments.
  |              The receipt of or possession of this file does not convey
  |              any rights to reproduce or disclose its contents or to
  |              manufacture, use, or sell anything it may describe, in
  |              whole, or in part, without the specific written consent of
  |              Texas Instruments.
  +------------------------------------------------------------------------------
  | Purpose:     Contains test constraints for alr
  |
  +------------------------------------------------------------------------------
*/
#include "alr_constraints.h"

const U16 CHLIST_14_23_69_115_FFFF_elements[5] = {
 	ARFCN_14,
  ARFCN_23,
  ARFCN_69,
  ARFCN_115,
  NOT_PRESENT_16BIT
};
T_ARRAY<U16> CHLIST_14_23_69_115_FFFF(CHLIST_14_23_69_115_FFFF_elements, SKIP_TO_END);

T_start starting_time()
{
  T_start pstruct;
  pstruct->v_start = 1;
  pstruct->t1 = 11;
  pstruct->t2 = 22;
  pstruct->t3 = 33;
  return pstruct;
}
T_starting_time s_time_mphc()
{
  T_starting_time pstruct;
  pstruct->start_time_present = 1;
  pstruct->start_time.t1=11;
  pstruct->start_time.t2=22;
  pstruct->start_time.t3=33;
  return pstruct;
}
T_starting_time s_time_t1()
{
  T_starting_time pstruct;
  pstruct->start_time_present = 1;
  pstruct->start_time.t1 = 11;
  pstruct->start_time.t2 = 22;
  pstruct->start_time.t3 = 33;
  return pstruct;
}
T_ch_type ch_type_tch2()
{
  T_ch_type pstruct;
  pstruct->ch = 0x01;
  pstruct->tn = 1;
  pstruct->tsc = 0;
  pstruct->h = 1;
  pstruct->arfcn = 0;
  pstruct->maio = 1;
  pstruct->hsn = 0;
  pstruct->ma = CHLIST_14_23_69_115_FFFF;
  return pstruct;
}
T_ch_type ch_type_tch3()
{
  T_ch_type pstruct;
  pstruct->ch = 0x01;
  pstruct->tn = 3;
  pstruct->tsc = 0;
  pstruct->h = 1;
  pstruct->arfcn = 0;
  pstruct->maio = 1;
  pstruct->hsn = 0;
  pstruct->ma = CHLIST_14_23_69_115_FFFF;
  return pstruct;
}
T_ho_param ho_param()
{
  T_ho_param pstruct;
  pstruct->ho_ref = NCI_TA_OUT_OF_RANGE_OK;
  pstruct->ho_pow = 0;
  pstruct->ho_acc_type = 0;
  pstruct->ho_nci = 0;
  return pstruct;
}
T_ho_param ho_param_1()
{
  T_ho_param pstruct;
  pstruct->ho_ref = HO_REF;
  pstruct->ho_pow = HO_POW;
  pstruct->ho_acc_type = 0;
  pstruct->ho_nci = 0;
  return pstruct;
}
T_tr_para tr_param()
{
  T_tr_para pstruct;
  pstruct->power = 10;
  pstruct->dtx = DTX_NOT_USED;
  pstruct->rlt = 5;
  pstruct->tav = 30;
  pstruct->pwrc = PWRC_NOT_SET;
  pstruct->mode = MODE_SPEECH_VER1;
  return pstruct;
}
T_ciph ciph_param()
{
  const U8 CIPH_PARAM_KC[8] = {
 	  0,1,2,3,4,5,6,7
  };

  T_ciph pstruct;
  pstruct->stat = STAT_CIPH_OFF;
  pstruct->algo = ALGO_A5_1;
  pstruct->kc = CIPH_PARAM_KC;
  return pstruct;
}
T_channel_desc channel_desc_2_tch()
{
  T_channel_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 1;
  pstruct->chan_sel.rf_channel.hsn = 0;
  pstruct->channel_type = 0x01;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 1;
  pstruct->tsc = 0;
  return pstruct;
}
T_channel_desc channel_desc_3_tch()
{
  T_channel_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 1;
  pstruct->chan_sel.rf_channel.hsn = 0;
  pstruct->channel_type = 0x01;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 3;
  pstruct->tsc = 0;
  return pstruct;
}
T_cell_description cell_description_2()
{
  T_cell_description pstruct;
  pstruct->ncc = 0;
  pstruct->bcc = 1;
  pstruct->bcch_carrier = 14;
  return pstruct;
}
T_channel_desc channel_desc_ia()
{
  T_channel_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 0;
  pstruct->chan_sel.rf_channel.hsn = 1;
  pstruct->channel_type = CH_TCH_F;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 1;
  pstruct->tsc = 5;
  return pstruct;
}
T_amr_conf s_amr_conf_4_icmi()
{
  T_amr_conf pstruct;
  pstruct->nscb = NSCB;
  pstruct->icmi = ICMI_S;
  pstruct->st_mode = ST_MODE_1;
  pstruct->acs = ACS_4;
  pstruct->v_cod_prop = V_COD_PROP;
  pstruct->c_cod_prop = C_COD_PROP_4;
  pstruct->cod_prop[0].codec_hyst = 0x01;
  pstruct->cod_prop[0].codec_thr  = 0x01;
  pstruct->cod_prop[1].codec_hyst = 0x03;
  pstruct->cod_prop[1].codec_thr  = 0x03;
  pstruct->cod_prop[2].codec_hyst = 0x05;
  pstruct->cod_prop[2].codec_thr  = 0x05;
  // = sa_cod_prop_4();
  return pstruct;
}
T_amr_configuration s_amr_configuration()
{
  T_amr_configuration pstruct;
  pstruct->noise_suppression_control_bit = NSCB;
  pstruct->initial_codec_mode_indicator = ICMI_S;
  pstruct->initial_codec_mode = ST_MODE_1;
  pstruct->active_codec_set = ACS_4;
  pstruct->threshold [0] = 0x01;
  pstruct->threshold [1] = 0x03;
  pstruct->threshold [2] = 0x05;
  pstruct->hysteresis[0] = 0x01;
  pstruct->hysteresis[1] = 0x03;
  pstruct->hysteresis[2] = 0x05;
  return pstruct;
}
T_frequency_list freq_list_ia()
{
  const U16 FREQ_LIST_IA_FREQ_elements[5] = {
 	  26, 34, 	42, 52, 	59
  };
  T_ARRAY<U16> FREQ_LIST_IA_FREQ(FREQ_LIST_IA_FREQ_elements, SKIP_TO_END);

  T_frequency_list pstruct;
  pstruct->rf_chan_cnt = 5;
  pstruct->rf_chan_no.radio_freq = FREQ_LIST_IA_FREQ;
  return pstruct;
}
T_channel_desc channel_desc_fr()
{
  T_channel_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 1;
  pstruct->chan_sel.rf_channel.hsn = 1;
  pstruct->channel_type = CH_TCH_F;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 1;
  pstruct->tsc = 5;
  return pstruct;
}
T_frequency_list freq_list_fr()
{
  const U16 CHLIST_10_52_59_73_108_114_elements[6] = {
 	  ARFCN_10,
    ARFCN_52,
    ARFCN_59,
    ARFCN_73,
    ARFCN_108,
    ARFCN_114
  };
  T_ARRAY<U16> CHLIST_10_52_59_73_108_114(CHLIST_10_52_59_73_108_114_elements, SKIP_TO_END);

  T_frequency_list pstruct;
  pstruct->rf_chan_cnt = 6;
  pstruct->rf_chan_no.radio_freq = CHLIST_10_52_59_73_108_114;
  return pstruct;
}

T_PRIMITIVE_UNION mph_dedicated_req_1()
{
  const U16 CHLIST_0_elements[1] = {
 	  0x00
  };
  T_ARRAY<U16> CHLIST_0(CHLIST_0_elements, SKIP_TO_END);
  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_IMM_ASSIGN;
  prim->start = starting_time();
  //   prim->ch_type = ch_type_hop();
  prim->ch_type.ch = CH_SDCCH_8_0;
  prim->ch_type.tn = 0;
  prim->ch_type.tsc = 0;
  prim->ch_type.h = 1;
  prim->ch_type.arfcn = 0;
  prim->ch_type.maio = 1;
  prim->ch_type.hsn = 0;
  prim->ch_type.ma = CHLIST_14_23_69_115_FFFF;
  //   prim->ch_type2. = ch_type2();
  prim->ch_type2.ch = 0x00;
  prim->ch_type2.tn = 3;
  prim->ch_type2.tsc = 6;
  prim->ch_type2.h = 0;
  prim->ch_type2.arfcn = 0;
  prim->ch_type2.maio = 0;
  prim->ch_type2.hsn = 0;
  prim->ch_type2.ma = CHLIST_0;
  prim->arfcn = ARFCN_23;
  prim->bsic = BSIC_1;
  prim->ho_param = ho_param();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_2()
{
  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_ASYNC_HANDOVER;
  prim->start._skip;
  prim->ch_type = ch_type_tch2();
  prim->ch_type2._skip;
  prim->arfcn = ARFCN_14;
  prim->bsic = BSIC_1;
  prim->ho_param = ho_param_1();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_3()
{
  const U16 CHLIST_26_34_42_52_59_FFFF_elements[6] = {
 	  ARFCN_26,
    ARFCN_34,
    ARFCN_42,
    ARFCN_52,
    ARFCN_59,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_26_34_42_52_59_FFFF(CHLIST_26_34_42_52_59_FFFF_elements, SKIP_TO_END);

  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_IMM_ASSIGN;
  prim->start.v_start=0;
  prim->start.t1._skip;
  prim->start.t2._skip;
  prim->start.t3._skip;
  //   prim->ch_type. = ch_type_imm_ass();
  prim->ch_type.ch = CH_TCH_F;
  prim->ch_type.tn = 1;
  prim->ch_type.tsc = 5;
  prim->ch_type.h = H_FREQ;
  prim->ch_type.arfcn = 0;
  prim->ch_type.maio = 0;
  prim->ch_type.hsn = 1;
  prim->ch_type.ma = CHLIST_26_34_42_52_59_FFFF;
  prim->ch_type2._skip;
  prim->arfcn = ARFCN_14;
  prim->bsic = BSIC_1;
  prim->ho_param = ho_param();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_4()
{
  const U16 CHLIST_73_74_75_76_FFFF_elements[5] = {
 	  ARFCN_73,
	  ARFCN_74,
	  ARFCN_75,
	  ARFCN_76,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_73_74_75_76_FFFF(CHLIST_73_74_75_76_FFFF_elements, SKIP_TO_END);
  const U16 CHLIST_46_52_59_66_73_74_FFFF_elements[7] = {
 	  ARFCN_46,
	  ARFCN_52,
	  ARFCN_59,
	  ARFCN_66,
	  ARFCN_73,
	  ARFCN_74,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_46_52_59_66_73_74_FFFF(CHLIST_46_52_59_66_73_74_FFFF_elements, SKIP_TO_END);

  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_CHAN_ASSIGN;
  prim->start.v_start = 1;
  prim->start.t1 = 45;
  prim->start.t2 = 22;
  prim->start.t3 = 33;
  prim->ch_type.ch = CH_TCH_F;
  prim->ch_type.tn = 0;
  prim->ch_type.tsc = 5;
  prim->ch_type.h = H_FREQ;
  prim->ch_type.arfcn = 0;
  prim->ch_type.maio = 0;
  prim->ch_type.hsn = 1;
  prim->ch_type.ma = CHLIST_73_74_75_76_FFFF;
  /* before time */
  prim->ch_type2.ch = CH_TCH_F;
  prim->ch_type2.tn = 0;
  prim->ch_type2.tsc = 5;
  prim->ch_type2.h = H_FREQ;
  prim->ch_type2.arfcn = 0;
  prim->ch_type2.maio = 1;
  prim->ch_type2.hsn = 7;
  prim->ch_type2.ma = CHLIST_46_52_59_66_73_74_FFFF;
  prim->arfcn = ARFCN_14;
  prim->bsic = BSIC_1;
  prim->ho_param._skip;
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_5()
{
  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_ASYNC_HANDOVER;
  prim->start = starting_time();
  prim->ch_type = ch_type_tch2();
  prim->ch_type2 = ch_type_tch3();
  prim->arfcn = ARFCN_14;
  prim->bsic = BSIC_1;
  prim->ho_param = ho_param_1();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_6(CHAR variant)
{
  T_MPH_DEDICATED_REQ prim;
  prim->mod = MODE_ASYNC_HANDOVER;
  prim->start = starting_time();
  prim->ch_type = ch_type_tch2();
  prim->ch_type2 = ch_type_tch3();
  if (variant == 'A') prim->arfcn = ARFCN_23;
  if (variant == 'B') prim->arfcn = ARFCN_23;
  if (variant == 'C') prim->arfcn = ARFCN_14;
  if (variant == 'D') prim->arfcn = ARFCN_1;
  if (variant == 'E') prim->arfcn = ARFCN_124;
  prim->bsic = BSIC_1;
  prim->ho_param = ho_param_1();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  if (variant == 'A')   prim->amr_conf._skip;
  if (variant == 'B')   prim->amr_conf = s_amr_conf_4_icmi();
  if (variant == 'C')   prim->amr_conf._skip;
  if (variant == 'D')   prim->amr_conf._skip;
  if (variant == 'E')   prim->amr_conf._skip;
  return prim;
}



T_PRIMITIVE_UNION mphc_immed_assign_req_1()
{
  T_MPHC_IMMED_ASSIGN_REQ prim;
  //prim->channel_desc. = channel_desc_1();
  prim->channel_desc.chan_sel.h = 1;
  prim->channel_desc.chan_sel.rf_channel.maio = 1;
  prim->channel_desc.chan_sel.rf_channel.hsn = 0;
  prim->channel_desc.channel_type = 0x04;
  prim->channel_desc.sub_channel = 0;
  prim->channel_desc.timeslot_no = 0;
  prim->channel_desc.tsc = 0;

  prim->timing_advance = TIMING_ADVANCE;
  prim->frequency_list = freq_list();
  prim->starting_time = s_time_mphc();
  prim->frequency_list_bef_sti._skip;
  prim->maio_bef_sti._skip;
  prim->dtx_allowed._skip;
  prim->bcch_allocation._skip;
  prim->ba_id._skip;
  prim->pwrc._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_immed_assign_req_2()
{
  T_MPHC_IMMED_ASSIGN_REQ prim;
  prim->channel_desc = channel_desc_ia();
  prim->timing_advance = TIMING_ADVANCE;
  prim->frequency_list = freq_list_ia();
  prim->starting_time.start_time_present = 0;
  prim->starting_time.start_time._skip;
  prim->frequency_list_bef_sti._skip;
  prim->maio_bef_sti._skip;
  prim->dtx_allowed._skip;
  prim->bcch_allocation._skip;
  prim->ba_id._skip;
  prim->pwrc._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_immed_assign_con_1()
{
  T_MPHC_IMMED_ASSIGN_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_dedicated_cnf_1(CHAR success)
{
  T_MPH_DEDICATED_CNF prim;
  prim->dedi_res = success;
  return prim;
}

T_PRIMITIVE_UNION mphc_async_ho_req_1(U8 ho_type)
{
  T_MPHC_ASYNC_HO_REQ prim;
  //prim->handover_command. = async_ho_cmd();
  prim->handover_command.cell_description = cell_description_2();
  prim->handover_command.channel_desc_1 = channel_desc_2_tch();
  prim->handover_command.channel_mode_1 = MODE_SPEECH_VER1;
  prim->handover_command.starting_time._skip;
  prim->handover_command.ho_acc = HO_REF;
  prim->handover_command.txpwr = HO_POW;
  prim->handover_command.report_time_diff._skip;
  prim->handover_command.frequency_list = freq_list();
  prim->handover_command.channel_desc_2._skip;
  prim->handover_command.channel_mode_2._skip;
  prim->handover_command.frequency_list_bef_sti._skip;
  prim->handover_command.channel_desc_1_bef_sti._skip;
  prim->handover_command.channel_desc_2_bef_sti._skip;
  prim->handover_command.cipher_mode._skip;
  prim->handover_command.a5_algorithm._skip;

  prim->fn_offset._skip;
  prim->time_alignmnt._skip;
  prim->cipher_key._skip;
  prim->amr_configuration._skip;
#ifdef  FF_EGPRS
  prim->handover_type = ho_type;
#endif  // FF_EGPRS
  return prim;
}
T_PRIMITIVE_UNION mphc_async_ho_req_2()
{
  T_MPHC_ASYNC_HO_REQ prim;
  //   prim->handover_command. = async_ho_cmd_2();
  prim->handover_command.cell_description = cell_description_2();
  prim->handover_command.channel_desc_1 = channel_desc_2_tch();
  prim->handover_command.channel_mode_1 = MODE_SPEECH_VER1;
  prim->handover_command.starting_time = s_time_mphc();
  prim->handover_command.ho_acc = HO_REF;
  prim->handover_command.txpwr = HO_POW;
  prim->handover_command.report_time_diff._skip;
  prim->handover_command.frequency_list = freq_list();
  prim->handover_command.channel_desc_2._skip;
  prim->handover_command.channel_mode_2._skip;
  prim->handover_command.frequency_list_bef_sti = freq_list();
  prim->handover_command.channel_desc_1_bef_sti = channel_desc_3_tch();
  prim->handover_command.channel_desc_2_bef_sti._skip;
  prim->handover_command.cipher_mode._skip;
  prim->handover_command.a5_algorithm._skip;

  prim->fn_offset._skip;
  prim->time_alignmnt._skip;
  prim->cipher_key._skip;
  prim->amr_configuration._skip;
#ifdef  FF_EGPRS
  prim->handover_type = HOT_REGULAR;
#endif  // FF_EGPRS
  return prim;
}
T_PRIMITIVE_UNION mphc_async_ho_req_3(CHAR variant)
{
  T_MPHC_ASYNC_HO_REQ prim;
  //prim->handover_command. = async_ho_cmd_3();
  prim->handover_command.cell_description.ncc = 0;
  prim->handover_command.cell_description.bcc = 1;
  if (variant == 'A' || variant == 'B')
    prim->handover_command.cell_description.bcch_carrier = ARFCN_23;
  else if (variant == 'E')
    prim->handover_command.cell_description.bcch_carrier = ARFCN_124;
  else if (variant == 'D')
    prim->handover_command.cell_description.bcch_carrier = ARFCN_1;
  else
    prim->handover_command.cell_description.bcch_carrier = ARFCN_14;
  prim->handover_command.channel_desc_1 = channel_desc_2_tch();
  prim->handover_command.channel_mode_1 = MODE_SPEECH_VER1;
  prim->handover_command.starting_time = s_time_mphc();
  prim->handover_command.ho_acc = HO_REF;
  prim->handover_command.txpwr = HO_POW;
  prim->handover_command.report_time_diff._skip;
  prim->handover_command.frequency_list = freq_list();
  prim->handover_command.channel_desc_2._skip;
  prim->handover_command.channel_mode_2._skip;
  prim->handover_command.frequency_list_bef_sti = freq_list();
  prim->handover_command.channel_desc_1_bef_sti = channel_desc_3_tch();
  prim->handover_command.channel_desc_2_bef_sti._skip;
  prim->handover_command.cipher_mode._skip;
  prim->handover_command.a5_algorithm._skip;

  prim->fn_offset._skip;
  prim->time_alignmnt._skip;
  prim->cipher_key._skip;
  if (variant == 'A')   prim->amr_configuration._skip;
  if (variant == 'B')   prim->amr_configuration = s_amr_configuration();
#ifdef  FF_EGPRS
  if (variant == 'D')
    prim->handover_type = HOT_BLIND;
  else
  prim->handover_type = HOT_REGULAR;
#endif  // FF_EGPRS
  return prim;
}




T_PRIMITIVE_UNION mph_freq_redef_req_1()
{
  const U16 CHLIST_10_52_59_73_108_114_FFFF_elements[7] = {
 	  ARFCN_10,
    ARFCN_52,
    ARFCN_59,
    ARFCN_73,
    ARFCN_108,
    ARFCN_114,
    NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CHLIST_10_52_59_73_108_114_FFFF(CHLIST_10_52_59_73_108_114_FFFF_elements, SKIP_TO_END);

  T_MPH_FREQ_REDEF_REQ prim;
  prim->start.v_start = 1;
  prim->start.t1 = 11;
  prim->start.t2 = 22;
  prim->start.t3 = 33;
  //   prim->ch_type. = ch_type_freq_redef();
  prim->ch_type.ch = CH_TCH_F;
  prim->ch_type.tn = 1;
  prim->ch_type.tsc = 5;
  prim->ch_type.h = H_FREQ;
  prim->ch_type.arfcn = 0;
  prim->ch_type.maio = 1;
  prim->ch_type.hsn = 1;
  prim->ch_type.ma = CHLIST_10_52_59_73_108_114_FFFF;
  return prim;
}
T_PRIMITIVE_UNION mph_freq_redef_req_2()
{
  T_MPH_FREQ_REDEF_REQ prim;
  prim->start = starting_time();
  //prim->ch_type. = ch_type_sdcch4();
  prim->ch_type.ch = CH_SDCCH_8_0;
  prim->ch_type.tn = 4;
  prim->ch_type.tsc = 0;
  prim->ch_type.h = 1;
  prim->ch_type.arfcn = 0;
  prim->ch_type.maio = 1;
  prim->ch_type.hsn = 0;
  prim->ch_type.ma = CHLIST_14_23_69_115_FFFF;
  return prim;
}


T_PRIMITIVE_UNION mphc_change_frequency_1()
{
  T_MPHC_CHANGE_FREQUENCY prim;
  prim->channel_desc = channel_desc_fr();
  prim->frequency_list = freq_list_fr();
  prim->starting_time = s_time_t1();
  return prim;
}
T_PRIMITIVE_UNION mphc_change_frequency_2()
{
  T_MPHC_CHANGE_FREQUENCY prim;
  //prim->channel_desc. = channel_desc_4();
  prim->channel_desc.chan_sel.h = 1;
  prim->channel_desc.chan_sel.rf_channel.maio = 1;
  prim->channel_desc.chan_sel.rf_channel.hsn = 0;
  prim->channel_desc.channel_type = 0x04;
  prim->channel_desc.sub_channel = 0;
  prim->channel_desc.timeslot_no = 4;
  prim->channel_desc.tsc = 0;

  prim->frequency_list = freq_list();
  prim->starting_time = s_time_mphc();
  return prim;
}


T_PRIMITIVE_UNION mphc_channel_assign_req_1()
{

  T_MPHC_CHANNEL_ASSIGN_REQ prim;
  prim->channel_desc_1.chan_sel.h = 1;
  prim->channel_desc_1.chan_sel.rf_channel.maio = 0;
  prim->channel_desc_1.chan_sel.rf_channel.hsn = 1;
  prim->channel_desc_1.channel_type = CH_TCH_F;
  prim->channel_desc_1.sub_channel = 0;
  prim->channel_desc_1.timeslot_no = 0;
  prim->channel_desc_1.tsc = 5;

  const U16 CHLIST_73_74_75_76_elements[4] = {
 	  ARFCN_73,
	  ARFCN_74,
	  ARFCN_75,
	  ARFCN_76
  };
  T_ARRAY<U16> CHLIST_73_74_75_76(CHLIST_73_74_75_76_elements, SKIP_TO_END);

  prim->channel_mode_1._skip;
  prim->txpwr = TXPWR0;
  prim->frequency_list.rf_chan_cnt = 4;
  prim->frequency_list.rf_chan_no.radio_freq = CHLIST_73_74_75_76;
  prim->starting_time.start_time_present = 1;
  prim->starting_time.start_time.t1 = 45;
  prim->starting_time.start_time.t2 = 22;
  prim->starting_time.start_time.t3 = 33;

  const U16 CHLIST_46_52_59_66_73_74_elements[6] = {
 	  ARFCN_46,
  	ARFCN_52,
	  ARFCN_59,
	  ARFCN_66,
  	ARFCN_73,
	  ARFCN_74
  };
  T_ARRAY<U16> CHLIST_46_52_59_66_73_74(CHLIST_46_52_59_66_73_74_elements, SKIP_TO_END);

  prim->channel_desc_2._skip;
  prim->channel_mode_2._skip;
  prim->frequency_list_bef_sti.rf_chan_cnt = 6;
  prim->frequency_list_bef_sti.rf_chan_no.radio_freq = CHLIST_46_52_59_66_73_74;
  prim->channel_desc_1_bef_sti.chan_sel.h = 1;
  prim->channel_desc_1_bef_sti.chan_sel.rf_channel.maio = 1;
  prim->channel_desc_1_bef_sti.chan_sel.rf_channel.hsn = 7;
  prim->channel_desc_1_bef_sti.channel_type = CH_TCH_F;
  prim->channel_desc_1_bef_sti.sub_channel = 0;
  prim->channel_desc_1_bef_sti.timeslot_no = 0;
  prim->channel_desc_1_bef_sti.tsc = 5;

  prim->channel_desc_2_bef_sti._skip;
  prim->cipher_mode._skip;
  prim->a5_algorithm._skip;
  prim->cipher_key._skip;
  prim->dtx_allowed._skip;
  prim->amr_configuration._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_channel_assign_req_2()
{
  T_MPHC_CHANNEL_ASSIGN_REQ prim;
  prim->channel_desc_1 = channel_desc_fr();
  prim->channel_mode_1._skip;
  prim->txpwr = POWER_12;
  prim->frequency_list = freq_list_fr();
  prim->starting_time = s_time_t1();
  prim->channel_desc_2._skip;
  prim->channel_mode_2._skip;
  prim->frequency_list_bef_sti = freq_list_ia();
  prim->channel_desc_1_bef_sti = channel_desc_ia();
  prim->channel_desc_2_bef_sti._skip;
  prim->cipher_mode._skip;
  prim->a5_algorithm._skip;
  prim->cipher_key._skip;
  prim->dtx_allowed._skip;
  prim->amr_configuration._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_channel_assign_con_1()
{
  T_MPHC_CHANNEL_ASSIGN_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_dedicated_fail_req_1()
{
  T_MPH_DEDICATED_FAIL_REQ prim;
  prim->param._skip;
  return prim;
}


T_PRIMITIVE_UNION mph_dedicated_fail_cnf_1()
{
  T_MPH_DEDICATED_FAIL_CNF prim;
  prim->param._skip;
  return prim;
}


T_PRIMITIVE_UNION mphc_async_ho_con_1()
{
  T_MPHC_ASYNC_HO_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_handover_finished_1(CHAR success)
{
  T_MPHC_HANDOVER_FINISHED prim;
  prim->cause = success;
#ifdef  FF_EGPRS
  /*valid only for BHO*/
  prim->fn_offset = FN_OFF_ARFCN_1;
  prim->time_alignment = TIME_ALIGNMT_1;
#endif  // FF_EGPRS
  return prim;
}

T_PRIMITIVE_UNION mphc_handover_fail_req_1()
{
  T_MPHC_HANDOVER_FAIL_REQ prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_handover_fail_con_1()
{
  T_MPHC_HANDOVER_FAIL_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_change_frequency_con_1()
{
  T_MPHC_CHANGE_FREQUENCY_CON prim;
  prim->param._skip;
  return prim;
}

T_RADIO_FRAME copy_array_to_l2_frame(U8 ch_type, const U8 const array[])
{
  T_RADIO_FRAME l2_frame;
  U16   sdu_len = (array[0] + (array[1] << 8)) >> 3;  /* sdu length in bytes */
  U8    l2_header_off = (ch_type == L2_CHANNEL_SACCH) ? 6 : 4;
  U8    l2_len = array[l2_header_off+2] >> 2;  /* length in bytes from l2 header */

  tdc_usi_trace ("copy_array_to_l2_frame(): sdu_len=%u l2_len=%u", sdu_len, l2_len);
  /*
   * Due to the incorrect SDU lengths in some message sdus, we use the length
   * indicator field of the layer 2 header instead. The remain of the
   * information will be filled with fill bytes. Please note the layer 1 header
   * in frames on SACCH.
   */
  l2_len += 3/*l2 header*/ + (l2_header_off-4)/*l1 header*/;
  for (int i = 0; i < l2_len;i++) /* without sdu length and sdu offset */
  {
    l2_frame->A[i] = array[i+4];
  }
  for (; i < 23; i++)
  {
    l2_frame->A[i] = 0x2b;       /* fill bytes */
  }

  return l2_frame;
}

T_PRIMITIVE_UNION ph_data_ind_1()
{
  const U8 I_SMS[27] = {
    0xA8, 0x00,
    0x10, 0x00,
    0xFF, 0xAA,
    0x0F,
    0x02,
    0x19,
    0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  T_PH_DATA_IND prim;

  prim->rf_chan_num._skip;
  prim->l2_channel_type= L2_CHANNEL_SACCH;
  prim->l2_frame = copy_array_to_l2_frame (L2_CHANNEL_SACCH, I_SMS);
  prim->error_cause = VALID_BLOCK;
  prim->bsic._skip;
  prim->tc._skip;

  return prim;
}

T_PRIMITIVE_UNION mph_channel_mode_req_1()
{
  T_MPH_CHANNEL_MODE_REQ prim;
  prim->mode = CHANNEL_MODE_AMR;
  prim->ch = CHANNEL_0;
  prim->amr_conf = s_amr_conf_4_icmi();
  return prim;
}

T_PRIMITIVE_UNION mphc_channel_mode_modify_req_1()
{
  T_MPHC_CHANNEL_MODE_MODIFY_REQ prim;
  prim->sub_channel = CHANNEL_0;
  prim->channel_mode = CHM_AHS;
  prim->amr_configuration = s_amr_configuration();
  return prim;
}

T_PRIMITIVE_UNION mphc_channel_mode_modify_con_1()
{
  T_MPHC_CHANNEL_MODE_MODIFY_CON prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_stop_dedicated_req()
{
  T_MPHC_STOP_DEDICATED_REQ prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_stop_dedicated_con()
{
  T_MPHC_STOP_DEDICATED_CON prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_stop_dedicated_req()
{
  T_MPH_STOP_DEDICATED_REQ prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_stop_dedicated_cnf()
{
  T_MPH_STOP_DEDICATED_CNF prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_dedicated_req_2g()
{
   T_MPH_DEDICATED_REQ prim;
   prim->mod = MODE_PDCH_ASSIGN;
   prim->start._skip;
   prim->ch_type._skip;
   prim->ch_type2._skip;
   prim->arfcn._skip;
   prim->bsic._skip;
   prim->ho_param._skip;
   prim->tr_para._skip;
   prim->ciph._skip;
   prim->amr_conf._skip;
   return prim;
}
T_PRIMITIVE_UNION mph_dedicated_fail_req_1g()
{
   T_MPH_DEDICATED_FAIL_REQ prim;
   prim->param._skip;
   return prim;
}
#if 0
T_PRIMITIVE_UNION mphc_immed_assign_req_2g()
{
   T_MPHC_IMMED_ASSIGN_REQ prim;
   prim->channel_desc = channel_desc_1();
   prim->timing_advance = TIMING_ADVANCE;
   prim->frequency_list = freq_list();
   prim->starting_time._skip;
   prim->frequency_list_bef_sti._skip;
   prim->maio_bef_sti._skip;
   prim->dtx_allowed._skip;
   prim->bcch_allocation._skip;
   prim->ba_id._skip;
   prim->pwrc._skip;
   return prim;
}
#endif
T_PRIMITIVE_UNION mphc_channel_assign_req_1g()
{
   T_MPHC_CHANNEL_ASSIGN_REQ prim;
   prim->channel_desc_1._skip;
   prim->channel_mode_1._skip;
   prim->txpwr._skip;
   prim->frequency_list._skip;
   prim->starting_time._skip;
   prim->channel_desc_2._skip;
   prim->channel_mode_2._skip;
   prim->frequency_list_bef_sti._skip;
   prim->channel_desc_1_bef_sti._skip;
   prim->channel_desc_2_bef_sti._skip;
   prim->cipher_mode._skip;
   prim->a5_algorithm._skip;
   prim->cipher_key._skip;
   prim->dtx_allowed._skip;
   prim->amr_configuration._skip;
   return prim;
}

T_PRIMITIVE_UNION mphc_channel_assign_con_1g()
{
   T_MPHC_CHANNEL_ASSIGN_CON prim;
   prim->param._skip;
   return prim;
}

T_PRIMITIVE_UNION mph_dedicated_fail_cnf_1g()
{
   T_MPH_DEDICATED_FAIL_CNF prim;
   prim->param._skip;
   return prim;
}


T_PRIMITIVE_UNION mph_dedicated_req_fn(U8 mode, U16 arfcn, U8 bsic)
{
  T_MPH_DEDICATED_REQ prim;
  prim->mod = mode;
  prim->start._skip;
  prim->ch_type = ch_type_tch2();
  prim->ch_type2._skip;
  prim->arfcn = arfcn;
  prim->bsic = bsic;
  prim->ho_param = ho_param_1();
  prim->tr_para = tr_param();
  prim->ciph = ciph_param();
  prim->amr_conf._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_async_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment)
{
  T_MPHC_ASYNC_HO_REQ prim;
  prim->handover_command._skip;
  prim->fn_offset = fn_offset;
  prim->time_alignmnt = time_alignment;
  prim->cipher_key._skip;
  prim->amr_configuration._skip;
#ifdef  FF_EGPRS
  prim->handover_type = ho_type;
#endif  // FF_EGPRS
  return prim;
}

T_PRIMITIVE_UNION mphc_sync_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment)
{
  T_MPHC_SYNC_HO_REQ prim;
  prim->handover_command._skip;
  prim->fn_offset = fn_offset;
  prim->time_alignmnt = time_alignment;
  prim->cipher_key._skip;
  prim->amr_configuration._skip;
#ifdef  FF_EGPRS
  prim->handover_type = ho_type;
#endif  // FF_EGPRS
  return prim;
}

T_PRIMITIVE_UNION mphc_presync_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment)
{
  T_MPHC_PRE_SYNC_HO_REQ prim;
  prim->handover_command._skip;
  prim->fn_offset = fn_offset;
  prim->time_alignmnt = time_alignment;
  prim->cipher_key._skip;
  prim->amr_configuration._skip;
#ifdef  FF_EGPRS
  prim->handover_type = ho_type;
#endif  // FF_EGPRS
  return prim;
}


T_PRIMITIVE_UNION mphc_handover_finished_fn(U8 cause)
{
  T_MPHC_HANDOVER_FINISHED prim;
  if(cause == 0xFF) prim->cause._show;
  else prim->cause = cause;
  return prim;
}


T_PRIMITIVE_UNION mph_dedicated_cnf_fn(U8 cause)
{
  T_MPH_DEDICATED_CNF prim;
  if(cause == 0xFF) prim->dedi_res._show;
  else prim->dedi_res = cause;
  return prim;
}

