/*
  +------------------------------------------------------------------------------
  |  File:       alr_constraints.h
  +------------------------------------------------------------------------------
  |              Copyright 2003 Texas Instruments
  |              All rights reserved.
  |
  |              This file is confidential and a trade secret of Texas Instruments.
  |              The receipt of or possession of this file does not convey
  |              any rights to reproduce or disclose its contents or to
  |              manufacture, use, or sell anything it may describe, in
  |              whole, or in part, without the specific written consent of
  |              Texas Instruments.
  +------------------------------------------------------------------------------
  | Purpose:     Contains protype constraints for alr
  |
  +------------------------------------------------------------------------------
*/
#ifndef ALR_CONSTRAINTS_H
#define ALR_CONSTRAINTS_H

#include "p_mphc.h"
#include "p_mph.h"
#include "p_mmi.h"
#include "p_mon.h"
#include "p_em.h"
#include "p_ph.h"
#include "p_dl.h"
#include "m_rr.h"
//#include "m_rr_fix.h"
#include "P_TB.h"
#include "tdc.h"


#ifndef  FF_EGPRS
#define HOT_REGULAR                     0
#define HOT_BLIND                       1
#define HOT_NONE                        255
#define HO_SYNC_FAIL                    2
#define DEDI_RES_SYNC_FAIL              2
#endif  // !FF_EGPRS

//#define RR	CCDENT_RR
#define	NO_OF_CELLS_3		                3
#define RAND_BURSTS_2		                2
#define	TI_0	                          0
#define NCC_PERMIT_1	                  0x01
#define NCC_PERMIT_2	                  0x00
#define	CELL_IDENT_1	                  0x3748
#define CELL_IDENT_2 	                  0x0004
#define CELL_IDENT_3	                  0x0104
#define	ACC_0005	                      0x0040
#define	HO_REF	                        23
#define	HO_POW	                        10
#define	RXLEV_IDX_1	                    0
#define	RXLEV_IDX_2	                    1
#define	RXLEV_IDX_3_1800	              2
#define	RXLEV_IDX_DUAL	                3
#define	RXLEV_IDX_2_DUAL	              1
#define	RXLEV_IDX_7	                    7
#define RXLEV_IDX_8                     8
#define RXLEV_IDX_9                     9
#define RXLEV_IDX_10                    10
#define RXLEV_IDX_11                    11
#define RXLEV_IDX_12                    12
#define RXLEV_IDX_13                    13
#define RXLEV_IDX_14                    14
#define RXLEV_IDX_15                    15
#define RXLEV_IDX_16                    16
#define RXLEV_IDX_17                    17
#define	SCHED_SIZE_1	                  1
#define	SCHED_LEN_0	                    0
#define	CHAN_LIST_IDX_0	                0
#define	ONE_ELEM	                      1
#define	PERIODIC_SCELL_BCCH_ARRAY_SIZE	8
#define	CBCH_LEN_88	                    88
#define	ENTITY	                        0x01
#define	Bitm_L	                        0x0040
#define	Bitm_H	                        0x0000
#define	ARFCN_0	                        0
#define ARFCN_0_STD_EGSM                12288
#define	ARFCN_1	                        1
#define	ARFCN_1_STD_900	                2049 /* 1 | (1<<11) */
#define	ARFCN_1_STD_EGSM	            12289 /* 1 | (6<<11) */
#define	ARFCN_1_STD_DUAL	              10241 /* 1 | (5<<11) */
#define	ARFCN_2	                        2
#define	ARFCN_3_STD_900	                2051 /* 3 | (1<<11) */
#define	ARFCN_3_STD_EGSM                12291/* 3 | (6<<11) */
#define	ARFCN_4_STD_EGSM                12292/* 4 | (6<<11) */
#define	ARFCN_5_STD_EGSM                12293/* 4 | (6<<11) */
#define	ARFCN_6_STD_900	                2054 /* 6 | (1<<11) */
#define	ARFCN_6_STD_EGSM                12294 /* 6 | (6<<11) */
#define	ARFCN_7_STD_EGSM                12295 /* 7 | (6<<11) */
#define	ARFCN_8	                        8
#define	ARFCN_8_STD_EGSM                12296 /* 8 | (6<<11) */
#define	ARFCN_9_STD_EGSM	              12297 /* 9 | (6<<11) */
#define	ARFCN_10	                      10
#define	ARFCN_10_STD_EGSM	              12298 /* 10 | (6<<11) */
#define	ARFCN_11	                      11
#define	ARFCN_11_STD_900	              2059 /* 11 | (1<<11) */
#define	ARFCN_11_STD_EGSM                 12299 /* 12 | (6<<11) */
#define	ARFCN_12_STD_900	              2060 /* 12 | (1<<11) */
#define	ARFCN_12_STD_EGSM                 12300/* 12 | (6<<11) */
#define	ARFCN_13_STD_EGSM                 12301/* 13 | (6<<11) */
#define	ARFCN_14	                      14
#define	ARFCN_14_STD_900	              2062 /* 14 | (1<<11) */
#define	ARFCN_14_STD_EGSM	              12302 /* 14 | (6<<11) */
#define	ARFCN_14_STD_DUAL	              10254 /* 14 | (5<<11) */
#define	ARFCN_15	                      15
#define	ARFCN_15_STD_EGSM	              12303 /* 15 | (6<<11) */
#define	ARFCN_16_STD_900                  2064 /* 16 | (1<<11) */
#define	ARFCN_16_STD_EGSM                 12304 /* 16 | (6<<11) */
#define	ARFCN_17_STD_900	              2065 /* 17 | (1<<11) */
#define	ARFCN_17_STD_EGSM                 12305 /* 17 | (6<<11) */
#define	ARFCN_18_STD_EGSM                 12306 /* 18 | (6<<11) */
#define	ARFCN_19_STD_EGSM                 12307 /* 19 | (6<<11) */
#define	ARFCN_20	                      20
#define	ARFCN_20_STD_EGSM                 12308 /* 20 | (6<<11) */
#define	ARFCN_21_STD_EGSM                 12309 /* 21 | (6<<11) */
#define	ARFCN_22_STD_900	              2070 /* 22 | (1<<11) */
#define	ARFCN_22_STD_EGSM                 12310 /* 22 | (6<<11) */
#define	ARFCN_23	                      23
#define	ARFCN_24	                      24
#define	ARFCN_23_STD_900	              2071 /* 23 | (1<<11) */
#define	ARFCN_23_STD_DUAL	              10263 /* 23 | (5<<11) */
#define	ARFCN_23_STD_EGSM	              12311 /* 23 | (6<<11) */
#define	ARFCN_24_STD_900	              2072 /* 24 | (1<<11) */
#define	ARFCN_24_STD_EGSM	              12312 /* 24 | (6<<11) */
#define	ARFCN_25_STD_EGSM	              12313 /* 25 | (6<<11) */
#define	ARFCN_25	                      25
#define	ARFCN_26	                      26
#define	ARFCN_26_STD_EGSM	              12314 /* 26 | (6<<11) */
#define	ARFCN_27_STD_900	              2075 /* 27 | (1<<11) */
#define	ARFCN_27_STD_EGSM                 12315 /* 27 | (6<<11) */
#define	ARFCN_28_STD_EGSM                 12316 /* 28 | (6<<11) */
#define	ARFCN_29_STD_EGSM                 12317 /* 29 | (6<<11) */
#define	ARFCN_30	                      30
#define	ARFCN_30_STD_EGSM                 12318 /* 30 | (6<<11) */
#define	ARFCN_31_STD_EGSM                 12319 /* 31 | (6<<11) */
#define	ARFCN_32_STD_EGSM                 12320 /* 32 | (6<<11) */
#define	ARFCN_32	                      32
#define	ARFCN_32_STD_900                (32 | (1<<11))
#define	ARFCN_33_STD_EGSM                 12321 /* 33 | (6<<11) */
#define	ARFCN_34	                      34
#define	ARFCN_34_STD_EGSM                 12322 /* 34 | (6<<11) */
#define	ARFCN_35_STD_EGSM                 12323 /* 35 | (6<<11) */
#define	ARFCN_36_STD_EGSM                 12324 /* 36 | (6<<11) */
#define	ARFCN_37_STD_EGSM                 12325 /* 37 | (6<<11) */
#define	ARFCN_38_STD_EGSM                 12326 /* 38 | (6<<11) */
#define	ARFCN_39_STD_EGSM                 12327 /* 39 | (6<<11) */
#define	ARFCN_40	                      40
#define	ARFCN_40_STD_EGSM                 12328 /* 40 | (6<<11) */
#define	ARFCN_41_STD_EGSM                 12329 /* 41 | (6<<11) */
#define	ARFCN_42	                      42
#define	ARFCN_42_STD_EGSM                 12330 /* 42 | (6<<11) */
#define	ARFCN_43_STD_EGSM                 12331 /* 43 | (6<<11) */
#define	ARFCN_44_STD_EGSM                 12332 /* 44 | (6<<11) */
#define	ARFCN_45_STD_EGSM                 12333 /* 45 | (6<<11) */
#define	ARFCN_46	                      46
#define	ARFCN_46_STD_EGSM                 12334 /* 46 | (6<<11) */
#define	ARFCN_47_STD_EGSM                 12335 /* 47 | (6<<11) */
#define	ARFCN_48_STD_EGSM                 12336 /* 48 | (6<<11) */
#define	ARFCN_49_STD_EGSM                 12337 /* 49 | (6<<11) */
#define	ARFCN_50_STD_EGSM                 12338 /* 50 | (6<<11) */
#define	ARFCN_52	                      52
#define	ARFCN_59	                      59
#define	ARFCN_66	                      66
#define	ARFCN_69	                      69
#define	ARFCN_73	                      73
#define	ARFCN_74	                      74
#define	ARFCN_75	                      75
#define	ARFCN_76	                      76
#define	ARFCN_80	                      80
#define	ARFCN_87	                      87
#define	ARFCN_90	                      90
#define	ARFCN_100	                      100
#define	ARFCN_108	                      108
#define	ARFCN_110	                      110
#define	ARFCN_114	                      114
#define	ARFCN_115	                      115
#define	ARFCN_120	                      120
#define	ARFCN_123_STD_900	              2171 /* 123 | (1<<11) */
#define	ARFCN_123_STD_EGSM                12411 /* 123 | (6<<11) */
#define	ARFCN_124	                      124
#define	ARFCN_124_STD_900	              2172 /* 124 | (1<<11) */
#define	ARFCN_124_STD_DUAL	            10364 /* 124 | (5<<11) */
#define	ARFCN_124_STD_EGSM	            12412 /* 124 | (6<<11) */
#define ARFCN_130_STD_850               47234
#define ARFCN_130_STD_DUAL_US           49282
#define ARFCN_131_STD_DUAL_US           49283
#define ARFCN_132_STD_DUAL_US           49284
#define ARFCN_133_STD_DUAL_US           49285
#define ARFCN_134_STD_DUAL_US           49286
#define ARFCN_135_STD_DUAL_US           49287
#define	ARFCN_135_STD_EGSM	            12423 /* 135 | (6<<11) */
#define ARFCN_136_STD_DUAL_US           49288
#define	ARFCN_136_STD_EGSM	            12424 /* 136 | (6<<11) */
#define ARFCN_137_STD_DUAL_US           49289
#define	ARFCN_137_STD_EGSM	            12424 /* 137 | (6<<11) */
#define ARFCN_138_STD_DUAL_US           49290
#define ARFCN_139_STD_DUAL_US           49291
#define ARFCN_140_STD_850               47244
#define ARFCN_140_STD_DUAL_US           49292
#define ARFCN_141_STD_DUAL_US           49293
#define ARFCN_142_STD_DUAL_US           49294
#define ARFCN_143_STD_DUAL_US           49295  /* 143 | (8<<11) */
#define ARFCN_144_STD_DUAL_US           49296  /* 144 | (8<<11) */
#define ARFCN_145_STD_DUAL_US           49297  /* 145 | (8<<11) */
#define ARFCN_146_STD_DUAL_US           49298  /* 146 | (8<<11) */
#define ARFCN_147_STD_DUAL_US           49299  /* 147 | (8<<11) */
#define ARFCN_148_STD_DUAL_US           49300  /* 148 | (8<<11) */
#define ARFCN_149_STD_DUAL_US           49301  /* 149 | (8<<11) */
#define ARFCN_150_STD_850               47254
#define ARFCN_150_STD_DUAL_US           49302
#define ARFCN_151_STD_DUAL_US           49303
#define ARFCN_152_STD_DUAL_US           49304
#define ARFCN_153_STD_DUAL_US           49305
#define ARFCN_154_STD_DUAL_US           49306
#define ARFCN_155_STD_DUAL_US           49307
#define ARFCN_156_STD_DUAL_US           49308
#define ARFCN_157_STD_DUAL_US           49309
#define ARFCN_158_STD_DUAL_US           49310
#define ARFCN_159_STD_DUAL_US           49311
#define ARFCN_160_STD_DUAL_US           49312
#define ARFCN_161_STD_DUAL_US           49313
#define ARFCN_162_STD_DUAL_US           49314
#define ARFCN_163_STD_DUAL_US           49315
#define ARFCN_164_STD_DUAL_US           49316
#define ARFCN_165_STD_DUAL_US           49317
#define ARFCN_166_STD_DUAL_US           49318
#define ARFCN_167_STD_DUAL_US           49319
#define ARFCN_168_STD_DUAL_US           49320
#define ARFCN_169_STD_DUAL_US           49321
#define ARFCN_170_STD_DUAL_US           49322
#define ARFCN_250_STD_850               47354
#define ARFCN_250_STD_DUAL_US           49402
#define ARFCN_251_STD_DUAL_US           49403
#define ARFCN_252_STD_DUAL_US           49404
#define ARFCN_253_STD_DUAL_US           49405
#define ARFCN_254_STD_DUAL_US           49406
#define ARFCN_255_STD_DUAL_US           49407
#define ARFCN_256_STD_DUAL_US           49408
#define ARFCN_257_STD_DUAL_US           49409
#define ARFCN_258_STD_DUAL_US           49410
#define ARFCN_259_STD_DUAL_US           49411
#define ARFCN_260_STD_DUAL_US           49412
#define ARFCN_261_STD_DUAL_US           49413
#define	ARFCN_512	                      512
#define	ARFCN_512_STD_1800	            8704 /* 512 | (4<<11) */
#define	ARFCN_512_STD_DUAL	            10752 /* 512 | (5<<11) */
#define	ARFCN_512_STD_EGSM              12800 /* 512 | (6<<11) */
#define	ARFCN_513	                      513
#define	ARFCN_513_STD_EGSM              12801 /* 513 | (6<<11) */
#define	ARFCN_514_STD_EGSM              12802 /* 516 | (6<<11) */
#define	ARFCN_514_STD_DUAL_US            49666 /* 514 | (8<<11) */
#define	ARFCN_515_STD_EGSM              12803 /* 516 | (6<<11) */
#define	ARFCN_516	                      516
#define	ARFCN_516_STD_EGSM              12804 /* 516 | (6<<11) */
#define	ARFCN_517_STD_EGSM              12805 /* 517 | (6<<11) */
#define	ARFCN_518_STD_EGSM              12806 /* 518 | (6<<11) */
#define	ARFCN_519_STD_EGSM              12807 /* 519 | (6<<11) */
#define	ARFCN_520_STD_EGSM              12808 /* 520 | (6<<11) */
#define	ARFCN_521_STD_EGSM              12809 /* 521 | (6<<11) */
#define	ARFCN_522_STD_EGSM              12810 /* 522 | (6<<11) */
#define	ARFCN_523_STD_EGSM              12811 /* 523 | (6<<11) */
#define	ARFCN_524_STD_EGSM              12812 /* 526 | (6<<11) */
#define	ARFCN_525	                      525
#define	ARFCN_525_STD_EGSM              12813 /* 526 | (6<<11) */
#define	ARFCN_526_STD_EGSM              12814 /* 526 | (6<<11) */
#define	ARFCN_527_STD_EGSM              12815 /* 527 | (6<<11) */
#define	ARFCN_528_STD_EGSM              12816 /* 528 | (6<<11) */
#define	ARFCN_529_STD_EGSM              12817 /* 529 | (6<<11) */
#define	ARFCN_530_STD_EGSM              12818 /* 530 | (6<<11) */
#define	ARFCN_531_STD_EGSM              12819 /* 531 | (6<<11) */
#define	ARFCN_532_STD_EGSM              12820 /* 532 | (6<<11) */
#define	ARFCN_533_STD_EGSM              12821 /* 533 | (6<<11) */
#define	ARFCN_534_STD_EGSM              12822 /* 534 | (6<<11) */
#define	ARFCN_534_STD_DUAL_US            49686 /* 534 | (8<<11) */
#define	ARFCN_535_STD_DUAL_US            49687 /* 535 | (8<<11) */
#define	ARFCN_535_STD_EGSM              12823 /* 535 | (6<<11) */
#define	ARFCN_536_STD_EGSM              12824 /* 536 | (6<<11) */
#define	ARFCN_536_STD_DUAL_US            49688 /* 536 | (8<<11) */
#define	ARFCN_537_STD_EGSM              12825 /* 537 | (6<<11) */
#define	ARFCN_537_STD_DUAL_US            49689 /* 537 | (8<<11) */
#define	ARFCN_538_STD_EGSM              12826 /* 538 | (6<<11) */
#define	ARFCN_538_STD_DUAL_US            49690 /* 538 | (8<<11) */
#define	ARFCN_539_STD_DUAL_US            49691 /* 539 | (8<<11) */
#define	ARFCN_539_STD_EGSM              12827 /* 539 | (6<<11) */
#define	ARFCN_540_STD_DUAL_US            49692 /* 540 | (8<<11) */
#define ARFCN_540_STD_EGSM              12828 /* 540 | (6<<11) */
#define ARFCN_541_STD_EGSM              12829 /* 541 | (6<<11) */
#define ARFCN_541_STD_DUAL_US            49693 /* 541 | (8<<11) */
#define ARFCN_542_STD_EGSM              12830 /* 542 | (6<<11) */
#define ARFCN_542_STD_DUAL_US            49694 /* 542 | (8<<11) */
#define ARFCN_543_STD_EGSM              12831 /* 543 | (6<<11) */
#define ARFCN_543_STD_DUAL_US            49695 /* 543 | (8<<11) */
#define ARFCN_544_STD_EGSM              12832 /* 544 | (6<<11) */
#define ARFCN_544_STD_DUAL_US            49696 /* 54 | (8<<11) */
#define ARFCN_545_STD_EGSM              12833 /* 545 | (6<<11) */
#define ARFCN_545_STD_DUAL_US            49697 /* 545 | (8<<11) */
#define ARFCN_546_STD_EGSM              12834 /* 546 | (6<<11) */
#define ARFCN_546_STD_DUAL_US            49698 /* 546 | (8<<11) */
#define ARFCN_547_STD_EGSM              12835 /* 547 | (6<<11) */
#define ARFCN_547_STD_DUAL_US            49699 /* 547 | (8<<11) */
#define ARFCN_548_STD_DUAL_US            49700 /* 548 | (8<<11) */
#define ARFCN_548_STD_EGSM              12836 /* 548 | (6<<11) */
#define ARFCN_549_STD_DUAL_US            49701 /* 549 | (8<<11) */
#define ARFCN_549_STD_EGSM              12837 /* 549 | (6<<11) */
#define ARFCN_550_STD_DUAL_US            49702 /* 550 | (8<<11) */
#define ARFCN_550_STD_EGSM              12838 /* 550 | (6<<11) */
#define ARFCN_551_STD_DUAL_US            49703 /* 551 | (8<<11) */
#define ARFCN_551_STD_EGSM              12839 /* 551 | (6<<11) */
#define	ARFCN_552_STD_DUAL_US            49704 /* 552 | (8<<11) */ 
#define ARFCN_552_STD_EGSM              12840 /* 552 | (6<<11) */
#define	ARFCN_553_STD_DUAL_US            49705 /* 553 | (8<<11) */
#define	ARFCN_554_STD_DUAL_US            49706 /* 554 | (8<<11) */
#define	ARFCN_555_STD_DUAL_US            49707 /* 555 | (8<<11) */
#define	ARFCN_556_STD_DUAL_US            49708 /* 556 | (8<<11) */ 
#define	ARFCN_557_STD_DUAL_US            49709 /* 557 | (8<<11) */
#define	ARFCN_558_STD_DUAL_US            49710 /* 558 | (8<<11) */
#define	ARFCN_559_STD_DUAL_US            49711 /* 559 | (8<<11) */
#define	ARFCN_560_STD_DUAL_US            49712 /* 560 | (8<<11) */
#define	ARFCN_561_STD_DUAL_US            49713 /* 561 | (8<<11) */
#define	ARFCN_562_STD_DUAL_US            49714 /* 562 | (8<<11) */
#define	ARFCN_563_STD_DUAL_US            49715 /* 563 | (8<<11) */
#define	ARFCN_564_STD_DUAL_US            49716 /* 564 | (8<<11) */
#define	ARFCN_565_STD_EGSM               12853 /* 565 | (6<<11) */
#define	ARFCN_565_STD_DUAL_US            49717 /* 565 | (8<<11) */
#define	ARFCN_566_STD_EGSM               12854 /* 566 | (6<<11) */
#define	ARFCN_566_STD_DUAL_US            49718 /* 566 | (8<<11) */
#define	ARFCN_567_STD_DUAL_US            49719 /* 567 | (8<<11) */
#define	ARFCN_567_STD_EGSM               12855 /* 567 | (6<<11) */
#define	ARFCN_568_STD_DUAL_US            49720 /* 568 | (8<<11) */
#define	ARFCN_568_STD_EGSM               12856 /* 568 | (6<<11) */
#define	ARFCN_569_STD_DUAL_US            49721 /* 568 | (8<<11) */
#define	ARFCN_570_STD_DUAL_US            49722 /* 570 | (8<<11) */
#define	ARFCN_571_STD_DUAL_US            49723 /* 571 | (8<<11) */
#define	ARFCN_572_STD_DUAL_US            49724 /* 572 | (8<<11) */
#define	ARFCN_573_STD_DUAL_US            49725 /* 573 | (8<<11) */
#define	ARFCN_574_STD_DUAL_US            49726 /* 574 | (8<<11) */
#define	ARFCN_578	                      578
#define	ARFCN_580	                      580
#define	ARFCN_580_STD_1800	            8772 /* 580 | (4<<11) */
#define	ARFCN_580_STD_DUAL	            10820 /* 580 | (5<<11) */
#define	ARFCN_581	                      581
#define	ARFCN_582	                      582
#define	ARFCN_583	                      583
#define	ARFCN_584	                      584
#define	ARFCN_585	                      585
#define	ARFCN_586	                      586
#define	ARFCN_587	                      587
#define	ARFCN_588	                      588
#define	ARFCN_589	                      589
#define	ARFCN_595	                      595
#define	ARFCN_596	                      596
#define	ARFCN_597	                      597
#define	ARFCN_598	                      598
#define	ARFCN_599	                      599
#define	ARFCN_600	                      600
#define	ARFCN_637	                      637
#define	ARFCN_637_STD_1800	            8829 /* 637 | (4<<11) */
#define	ARFCN_637_STD_DUAL	            10877 /* 637 | (5<<11) */
#define	ARFCN_700	                      700
#define	ARFCN_810	                      810
#define	ARFCN_810_STD_1800	            9002 /* 810 | (4<<11) */
#define	ARFCN_885	                      885
#define	ARFCN_885_STD_1800	            9077 /* 885 | (4<<11) */
#define	ARFCN_885_STD_DUAL	            11125 /* 885 | (5<<11) */

#define ARFCN_1023_STD_900              3071
#define ARFCN_1024_STD_900              3072
#define ARFCN_0_STD_900                 2048
#define ARFCN_974_STD_900               3022
#define ARFCN_124_STD_900               2172
#define ARFCN_123_STD_900               2171
#define ARFCN_20_STD_900                2068
#define ARFCN_10_STD_900                2058

#define	ARFCN_975	                      975
#define	ARFCN_1023	                    1023
#define	BA_ID_1	                        1
#define	BA_ID_2                       	2
#define	BA_ID_3	                        3
#define	BA_ID_4	                        4
#define	BA_ID_5	                        5
#define	BS_AG_BLKS_RES_2	              2
#define	BS_AG_BLKS_RES_3 	              3
#define	BS_AG_BLKS_RES_5	              5
#define	BS_AG_BLKS_RES_7	              7
#define	BS_PA_MFRMS_0	                  0
#define	BS_PA_MFRMS_1	                  1
#define	BS_PA_MFRMS_2	                  2
#define	BS_PA_MFRMS_3	                  3
#define	BS_PA_MFRMS_4	                  4
#define	BS_PA_MFRMS_5	                  5
#define	BS_PA_MFRMS_6	                  6
#define	BS_PA_MFRMS_7	                  7
#define	BS_PA_MFRMS_8	                  8
#define	BS_PA_MFRMS_9	                  9
#define	BSIC_0	                        0
#define	BSIC_1	                        1
#define	BSIC_2	                        2
#define	BSIC_3	                        3
#define	BSIC_10	                        10
#define	BSIC_16	                        16
#define	CCCH_GROUP_0	                  0
#define	CCCH_GROUP_2	                  2
#define	CHANNEL_REQUEST_1	              0xA0
#define	CHANNEL_REQUEST_2	              0xA3
#define	CHANNEL_REQUEST_GO_1	          0x01
#define	CHANNELS_0	                    0
#define	CHANNELS_1	                    1
#define	CHANNELS_2	                    2
#define	CHANNELS_3	                    3
#define	CHANNELS_4	                    4
#define	CHANNELS_5 	                    5
#define	CHANNELS_6 	                    6
#define	CHANNELS_8	                    8
#define	CHANNELS_9	                    9
#define	CHANNELS_10	                    10
#define	CHANNELS_11	                    11
#define	CHANNELS_14	                    14
#define	CHANNELS_17	                    17
#define	CHANNELS_23	                    23
#define	CHANNELS_24	                    24
#define CHANNELS_32                     32
#define CHANNELS_35                     35
#define CHANNELS_43                     43
#define CHANNELS_160                    160
#define	CONST_0	                        0
#define	CONST_1	                        1
#define	CONST_2	                        2
#define	CONST_4	                        4
#define	CONST_5	                        5
#define	CONST_6	                        6
#define CONST_8                         8
#define	CONST_10 	                      10
#define	CONST_12	                      12
#define	CONST_13	                      13
#define	CONST_16	                      16
#define	CONST_20	                      20
#define	CONST_23	                      23
#define	CONST_30	                      30
#define	CONST_46	                      46
#define	CONST_47	                      47
#define	CONST_53	                      53
#define	CONST_63	                      63
#define CONST_73                        73
#define	CONST_123	                      123
#define	CONST_124	                      124
#define	CONST_129	                      129
#define	CONST_130	                      130
#define	CONST_974	                      974
#define	CONST_975	                      975
#define	CONST_1022	                    1022
#define	CONST_1023	                    1023
#define	DLT_10	                        10
#define	DLT_24	                        24
#define	FN_BURST_1	                    61434

#define acc_level_4                     2264
#define acc_nbr_4                       42
#define acc_level_3                     2321
#define acc_nbr_3                       43
#define acc_level_2                     2265
#define acc_nbr_2                       42
#define acc_level_0                     0
#define acc_nbr_0                       0
#define acc_level_5                     2156
#define acc_nbr_5                       49
#define acc_level_6                     2112
#define acc_nbr_6                       48
#define acc_level_7                     2114
#define acc_nbr_7                       48


/*sync*/
#define FN_OFFSET_0                     0
#define FN_OFFSET_6                     6
#define FN_OFFSET_114                   114
#define FN_OFFSET_224                   224
#define FN_OFF_ARFCN_1                  101
#define FN_OFF_ARFCN_14                 114
#define FN_OFF_ARFCN_124                224
#define FN_OFF_ARFCN_512                322
/*meas*/
#define FN_OFF_ARFCN_23                 (3*306)
#define FN_OFFSET_306                   (3*306)
#define FN_OFFSET_357                   (3*357)
#define FN_OFFSET_408                   (2*408)
#define FN_OFFSET_459                   (2*459)
#define FN_OFFSET_816                   816
#define FN_OFFSET_1020                  1020
#define FN_OFFSET_1071                  1071
/*both*/
#define FN_OFFSET_918                   918
#define FN_OFFSET_102                   (10*102)
#define FN_OFFSET_204                   (5*204)
#define FN_OFFSET_153                   (7*153)
#define FN_OFFSET_255                   (4*255)
#define FN_OFFSET_32                    32

#define TIME_ALIGN_2328                 2328
#define TIME_ALIGNMT_0                  0
#define TIME_ALIGNMT_1                  1
#define TIME_ALIGNMT_14                 14
#define TIME_ALIGNMT_124                124
#define TIME_ALIGNMT_512                512
#define TIME_ALIGNMT_32                 32

#define	NCC_PERMITTED_4	                4
#define	PBI_0	                          0
#define	PBI_1	                          1
#define	PBI_2	                          2
#define	PBI_4	                          4
#define	PG_0	                          0
#define	PG_1	                          1
#define	PG_11	                          11
#define	PG_20	                          20
#define	PG_23	                          23
#define	POWER_12	                      12
#define	RAND_BURST_1	                  6
#define	RAND_BURST_2	                  8
#define	RXLEV_56	                      56
#define	TC_0	                          0
#define	TC_1	                          1
#define	TC_2	                          2
#define	TC_3	                          3
#define	TC_4	                          4
#define	TC_5	                          5
#define	TC_6 	                          6
#define	TC_7	                          7
#define	TIMING_ADVANCE	                0x1E
#define	TN_0	                          0
#define	TN_4	                          4
#define	TXPWR0			                    10
#define	VALID_REPORT		                1
#define	STOP_SIZE_1		                  1
#define FIRST_BLOCKS_0_B	              0x032042
#define FIRST_BLOCKS_0_DRX	              0x012040
#define FIRST_BLOCKS_0_UNSCH	              0x0C8
#define SCHED_LEN_8	                  	0x08
#define SCHED_LEN_30	                  	0x30
#define FIRST_BLOCKS_1_B	              0
/*amr*/
#define	CHANNEL_MODE_AMR	              0x41
#define	CHM_AHS	                        0x0A
#define	NSCB	                          0x00
#define	ICMI_S	                        0x01
#define	ST_MODE_1	                      0x01
#define	ACS_4	                          0x0F
#define	V_COD_PROP	                    0x01
#define	C_COD_PROP_4	                  0x03
/*eotd*/
#define	NO_NCELLS_2	                    0x02
#define	NO_NCELLS_3	                    0x03
#define	NO_NCELLS_6	                    0x06
#define	NO_NCELLS_8	                    0x08
#define	SB_TRUE	                        0x01
#define	STOP_SIZE_12	                  0x0C
#define	MFRM_OFFSET_44	                0x2C
#define	SB_TRUE	                        0x01
#define	EOTD_00	                        0x00
#define	RX_0	                          0x00
#define	REQ_ID_1	                      0x0001
#define	REQ_ID_FFFF	                    0xFFFF
#define	REQ_ID_8	                      0x0008
#define	OTD_666	                        0x029A
#define	EOTD_0000	                      0x0000
#define	OTD_0	                          0x0000
#define	NOM_POS_1000	                  0x000003E8
#define	NOM_POS_2000	                  0x000007D0
#define	RSSI_61440	                    0x0000F000
#define	RSSI_61952	                    0x0000F200
#define	EOTD_0L	                        0x00000000
#define	LIST_SIZE2		                  2
#define	FN_OFFSET_10	                  10
#define	TIME_ALIGNMT_10	                10
// used to check if a value is used from
// a primitive when the value from the prim should not be used.
#define INVALID_PATTERN                 0x2B

typedef enum { VAR_PLMN_POWER_CNF, VAR_PLMN_BSIC_CNF, VAR_PLMN_SI } T_VAR_ABORT_PLMN_SEARCH;
typedef enum { VAR_NMO_1, VAR_NMO_3 } T_VAR_NMO;

extern T_ARRAY<T_tb_meas_result> tb_list_1();
extern T_ARRAY<T_tb_meas_result> tb_list_2();
extern T_ARRAY<T_tb_meas_result> tb_list_3();
extern T_tb_meas_result tb_meas_result_1(U16 acc_lev,U8 acc_nbr);
extern T_tb_meas_result tb_meas_result_2(U16 acc_lev,U8 acc_nbr);
extern T_tb_meas_result tb_meas_result_empty();

/* shared IE */
T_l2_frame l2_sys_info_3();
T_l2_frame l2_sys_info_3_new();
T_l2_frame l2_sys_info_2();
T_l2_frame l2_sys_info_4();
T_l2_frame l2_sys_info_4_acs();
T_l2_frame l2_no_content();
T_l2_frame l2_sys_info_2q();
T_frequency_list freq_list();
/*
 * primitives, these need to be split up later to
 * the relevant header file
 */
T_PRIMITIVE_UNION  mph_power_req_1                ();
T_PRIMITIVE_UNION  mph_power_req_variant          (U8 search_mode, CHAR variant);
T_PRIMITIVE_UNION  mphc_init_l1_req_1             ();
T_PRIMITIVE_UNION  mphc_init_l1_con_1             ();
T_PRIMITIVE_UNION  mphc_rxlev_req                 ();
T_PRIMITIVE_UNION  mphc_rxlev_ind                 (U8 idx);
T_PRIMITIVE_UNION  mph_power_cnf_1                ();
T_PRIMITIVE_UNION  mph_power_cnf_variant          (CHAR variant);
T_PRIMITIVE_UNION  mph_power_cnf_max              ();
T_PRIMITIVE_UNION  mph_power_cnf_overlap          ();
T_PRIMITIVE_UNION  mph_power_cnf_overlap1         ();
T_PRIMITIVE_UNION  mph_power_cnf_black            ();
T_PRIMITIVE_UNION  mph_power_cnf_same_white_black ();
T_PRIMITIVE_UNION  mph_power_cnf_lrxt             ();
T_PRIMITIVE_UNION  mph_power_cnf_rxlevel          (CHAR variant);
T_PRIMITIVE_UNION  mph_power_cnf_2                ();
T_PRIMITIVE_UNION  mph_power_cnf_32_whitelist     ();
T_PRIMITIVE_UNION  mph_power_cnf_american         ();
T_PRIMITIVE_UNION  mph_power_cnf_american1        ();
T_PRIMITIVE_UNION  mph_bsic_req                   (U16 arfcn);
T_PRIMITIVE_UNION  mphc_network_sync_req          (U16 arfcn, U8 mode);
T_PRIMITIVE_UNION  mphc_network_sync_ind_1        ();
T_PRIMITIVE_UNION  mph_bsic_cnf_1                 ();
T_PRIMITIVE_UNION  mphc_new_scell_req_1           ();
T_PRIMITIVE_UNION  mphc_new_scell_con_1           ();
T_PRIMITIVE_UNION  mphc_scell_nbcch_req_full      ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_6        ();
T_PRIMITIVE_UNION  mph_bsic_cnf_6                 ();
T_PRIMITIVE_UNION  mphc_new_scell_req_2           ();
T_PRIMITIVE_UNION  mphc_data_ind_1                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_1             ();
T_PRIMITIVE_UNION  mphc_data_ind_2                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_2             ();
T_PRIMITIVE_UNION  mphc_data_ind_3                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_3             ();
T_PRIMITIVE_UNION  mphc_data_ind_4                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_4             ();
T_PRIMITIVE_UNION  mphc_data_ind_5                ();
T_PRIMITIVE_UNION  mph_error_ind_1                ();
T_PRIMITIVE_UNION  mphc_stop_scell_bcch_req       ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_7        ();
T_PRIMITIVE_UNION  mph_bsic_cnf_7                 ();
T_PRIMITIVE_UNION  mphc_new_scell_req_3           ();
T_PRIMITIVE_UNION  mphc_data_ind_6                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_5             ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_8        ();
T_PRIMITIVE_UNION  mph_bsic_cnf_8                 ();
T_PRIMITIVE_UNION  mphc_new_scell_req_4           ();
T_PRIMITIVE_UNION  mphc_data_ind_7                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_6             ();
T_PRIMITIVE_UNION  mph_classmark_req_1            ();
T_PRIMITIVE_UNION  mph_idle_req_1                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_stop_scell_bcch_con       ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_1          (CHAR variant);
T_PRIMITIVE_UNION  mph_identity_req_1             ();
T_PRIMITIVE_UNION  mph_cbch_req_1                 ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_1        (CHAR variant);
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_1      (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_2                 ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_2          ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_2        ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_2a        ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_2      ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_2i();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_9      (U16 rx_1, U16 rx_2, U16 rx_3, U16 rx_4);
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_9A     (U16 rx_1, U16 rx_2);
T_PRIMITIVE_UNION  mph_power_cnf_3                ();
T_PRIMITIVE_UNION  mph_power_cnf_3_new            ();
T_PRIMITIVE_UNION  mph_sync_req                   (U8 cs);
T_PRIMITIVE_UNION  em_l1_event_req_1              ();
T_PRIMITIVE_UNION  em_data_ind_1                  ();
T_PRIMITIVE_UNION  mphc_stop_network_sync_req_1   ();
T_PRIMITIVE_UNION  mphc_stop_network_sync_con_1   ();
T_PRIMITIVE_UNION  mph_bsic_cnf_9                 ();
T_PRIMITIVE_UNION  mph_idle_req_3                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_start_ccch_req_3          (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_8                (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_9                ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_4          ();
T_PRIMITIVE_UNION  mphc_start_ccch_req            (U8 bs_pa_mfrms, U8 bs_ag_blks_res, U8 bcch_combined, U8 ccch_group, U8 page_group, U8 page_block_index, U8 page_mode);
T_PRIMITIVE_UNION  mphc_start_ccch_req_4_reorg    ();
T_PRIMITIVE_UNION  mphc_scell_nbcch_req_periodic  ();
T_PRIMITIVE_UNION  mphc_data_ind_10               ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_5          ();
T_PRIMITIVE_UNION  mphc_data_ind_11               ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_6          ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_6_reorg    ();
T_PRIMITIVE_UNION  mphc_data_ind_12               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_13               (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_4                 (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_resel             ();
T_PRIMITIVE_UNION  mph_idle_req_cell_sel          ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_7          (CHAR variant);
T_PRIMITIVE_UNION  mph_neighbourcell_req_3        ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_3      ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_1      ();
T_PRIMITIVE_UNION  mph_measurement_ind_1          ();
T_PRIMITIVE_UNION  mph_measurement_ind_2          ();
T_PRIMITIVE_UNION  mph_measurement_ind_3          ();
T_PRIMITIVE_UNION  mph_measurement_ind_4          ();
T_PRIMITIVE_UNION  mph_measurement_ind_5          ();
T_PRIMITIVE_UNION  mph_measurement_ind_6          ();
T_PRIMITIVE_UNION  mph_measurement_ind_7          ();
T_PRIMITIVE_UNION  mph_measurement_ind_8          ();
T_PRIMITIVE_UNION  mph_measurement_ind_9          ();
T_PRIMITIVE_UNION  mph_measurement_ind_10         ();
T_PRIMITIVE_UNION  mph_measurement_ind_11         ();
T_PRIMITIVE_UNION  mph_measurement_ind_12         ();
T_PRIMITIVE_UNION  mphc_data_ind_14               ();
T_PRIMITIVE_UNION  mphc_data_ind_15               ();
T_PRIMITIVE_UNION  mphc_data_ind_16               ();
T_PRIMITIVE_UNION  mphc_data_ind_17               ();
T_PRIMITIVE_UNION  mphc_data_ind_18               ();
T_PRIMITIVE_UNION  mphc_data_ind_19               ();
T_PRIMITIVE_UNION  mph_error_ind_2                ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_8          ();
T_PRIMITIVE_UNION  mphc_stop_ccch_req             ();
T_PRIMITIVE_UNION  mphc_stop_ncell_sync_req_1     ();
T_PRIMITIVE_UNION  mphc_stop_ncell_sync_req_dummy ();
T_PRIMITIVE_UNION  mphc_stop_ncell_bcch_req_1     ();
T_PRIMITIVE_UNION  mphc_stop_rxlev_periodic_req   ();
T_PRIMITIVE_UNION  mph_idle_req_5                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_start_ccch_req_9          ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_4        (CHAR variant);
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_4      (CHAR variant);
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_2      ();
T_PRIMITIVE_UNION  mphc_ncell_sync_req_1a         ();
T_PRIMITIVE_UNION  mph_measurement_ind_13         ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind            (U16 arfcn,
                                                   U32 fn_offset=FN_OFF_ARFCN_14,
                                                   U32 ta=TIME_ALIGNMT_14,
                                                   U8 bsic=BSIC_1,
                                                   U8 sb=SB_FOUND);
T_PRIMITIVE_UNION  mphc_ncell_bcch_req            (U16 arfcn,
                                                   U32 fn_offset=FN_OFF_ARFCN_14,
                                                   U32 ta=TIME_ALIGNMT_14,
                                                   U8 bsic=BSIC_1,
                                                   U8 blocks=NCELL_BCCH_SI_3_4);
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_3          ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_3a         ();
T_PRIMITIVE_UNION  mph_measurement_ind_14         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_7             ();
T_PRIMITIVE_UNION  mph_unitdata_ind_8             ();
T_PRIMITIVE_UNION  mph_unitdata_ind_9             ();
T_PRIMITIVE_UNION  mph_measurement_ind_15         ();
T_PRIMITIVE_UNION  mph_measurement_ind_16         ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_5          ();
T_PRIMITIVE_UNION  mph_random_access_req_1        ();
T_PRIMITIVE_UNION  mphc_ra_req_1                  ();
T_PRIMITIVE_UNION  mphc_ra_con_1                  ();
T_PRIMITIVE_UNION  mph_random_access_cnf_1        ();
T_PRIMITIVE_UNION  mphc_ra_req_2                  ();
T_PRIMITIVE_UNION  mphc_data_ind_20               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_10            ();
T_PRIMITIVE_UNION  mph_dedicated_req_1            ();
T_PRIMITIVE_UNION  mphc_stop_ra_req_1             ();
T_PRIMITIVE_UNION  mphc_immed_assign_req_1        ();
T_PRIMITIVE_UNION  mphc_immed_assign_con_1        ();
T_PRIMITIVE_UNION  mph_dedicated_cnf_1            (CHAR success);
T_PRIMITIVE_UNION  mphc_data_ind_21               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_11            ();
T_PRIMITIVE_UNION  mph_random_access_req_2        ();
T_PRIMITIVE_UNION  mphc_data_ind_22               ();
T_PRIMITIVE_UNION  mph_idle_req_6                 ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_10         ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_4          ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_5          ();
T_PRIMITIVE_UNION  mph_measurement_ind_17         ();
T_PRIMITIVE_UNION  mph_ext_meas_req_1             ();
T_PRIMITIVE_UNION  mphc_init_l1_req_2             ();
T_PRIMITIVE_UNION  mphc_init_l1_req               ();
T_PRIMITIVE_UNION  mph_ext_meas_cnf_1             ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_8          ();
T_PRIMITIVE_UNION  mph_bsic_cnf_10                ();
T_PRIMITIVE_UNION  mph_sync_ind_1                 ();
T_PRIMITIVE_UNION  mphc_data_ind_23               ();
T_PRIMITIVE_UNION  mphc_data_ind_24               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_1               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_25               (CHAR variant);
T_PRIMITIVE_UNION  mph_identity_req_2             ();
T_PRIMITIVE_UNION  mphc_data_ind_26               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_2               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_27               ();
T_PRIMITIVE_UNION  mphc_data_ind_28               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_3               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_29               ();
T_PRIMITIVE_UNION  mphc_data_ind_30               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_4               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_31               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_5               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_32               ();
T_PRIMITIVE_UNION  mphc_data_ind_33               (CHAR variant);
T_PRIMITIVE_UNION  mph_paging_ind_6               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_34               ();
T_PRIMITIVE_UNION  mphc_data_ind_35               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_12            ();
T_PRIMITIVE_UNION  mph_measurement_ind_18         ();
T_PRIMITIVE_UNION  mph_measurement_ind_19         ();
T_PRIMITIVE_UNION  mph_power_req_2                ();
T_PRIMITIVE_UNION  mph_bsic_cnf_14                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_13            ();
T_PRIMITIVE_UNION  mph_error_ind_3                ();
T_PRIMITIVE_UNION  mph_error_ind_5                ();
T_PRIMITIVE_UNION  mph_bsic_cnf_15                ();
T_PRIMITIVE_UNION  mph_bsic_cnf_16                ();
T_PRIMITIVE_UNION  mph_unitdata_ind_14            ();
T_PRIMITIVE_UNION  mph_emo_req_1                  ();
T_PRIMITIVE_UNION  mphc_update_ba_list_1          ();
T_PRIMITIVE_UNION  mphc_meas_report_1             ();
T_PRIMITIVE_UNION  mph_emo_meas_ind_1             ();
T_PRIMITIVE_UNION  mphc_update_ba_list_2          ();
T_PRIMITIVE_UNION mphc_update_ba_list_2a          ();
T_PRIMITIVE_UNION  mphc_meas_report_2             ();
T_PRIMITIVE_UNION  mph_measurement_ind_20         ();
T_PRIMITIVE_UNION  mph_emo_req_2                  ();
T_PRIMITIVE_UNION  mphc_update_ba_list_3          ();
T_PRIMITIVE_UNION  mphc_update_ba_list_4          ();
T_PRIMITIVE_UNION  mphc_update_ba_list_5          ();
T_PRIMITIVE_UNION  mphc_update_ba_list_6          ();
T_PRIMITIVE_UNION  mphc_update_ba_list_7          ();
T_PRIMITIVE_UNION  mphc_update_ba_list_8          ();
T_PRIMITIVE_UNION  mphc_meas_report_3             ();
T_PRIMITIVE_UNION  mphc_meas_report_4             ();
T_PRIMITIVE_UNION  mphc_meas_report_4a            ();
T_PRIMITIVE_UNION  mph_emo_meas_ind_2             ();
T_PRIMITIVE_UNION  mph_dedicated_req_2            ();
T_PRIMITIVE_UNION  mphc_async_ho_req_1            (U8 ho_type);
T_PRIMITIVE_UNION  mphc_data_ind_36               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_15            ();
T_PRIMITIVE_UNION  mph_dedicated_req_3            ();
T_PRIMITIVE_UNION  mphc_immed_assign_req_2        ();
T_PRIMITIVE_UNION  mph_freq_redef_req_1           ();
T_PRIMITIVE_UNION  mphc_change_frequency_1        ();
T_PRIMITIVE_UNION  mph_dedicated_req_4            ();
T_PRIMITIVE_UNION  mphc_channel_assign_req_1      ();
T_PRIMITIVE_UNION  mphc_channel_assign_con_1      ();
T_PRIMITIVE_UNION  mph_dedicated_fail_req_1       ();
T_PRIMITIVE_UNION  mphc_channel_assign_req_2      ();
T_PRIMITIVE_UNION  mph_dedicated_fail_cnf_1       ();
T_PRIMITIVE_UNION  mph_freq_redef_req_2           ();
T_PRIMITIVE_UNION  mphc_change_frequency_2        ();
T_PRIMITIVE_UNION  mph_dedicated_req_5            ();
T_PRIMITIVE_UNION  mphc_async_ho_req_2            ();
T_PRIMITIVE_UNION  mphc_async_ho_con_1            ();
T_PRIMITIVE_UNION  mphc_handover_finished_1       (CHAR success);
T_PRIMITIVE_UNION  mphc_handover_fail_req_1       ();
T_PRIMITIVE_UNION  mphc_handover_fail_con_1       ();
T_PRIMITIVE_UNION  mphc_change_frequency_con_1    ();
T_PRIMITIVE_UNION  mphc_data_ind_37               ();
T_PRIMITIVE_UNION  mphc_data_ind_sacch_error      ();
T_PRIMITIVE_UNION  mph_unitdata_ind_16            ();
T_PRIMITIVE_UNION  mphc_data_ind_38               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_17            ();
T_PRIMITIVE_UNION  mphc_data_ind_39               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_18            ();
T_PRIMITIVE_UNION  mphc_data_ind_40               ();
T_PRIMITIVE_UNION  ph_data_ind_1                  ();
T_PRIMITIVE_UNION  mphc_data_ind_41               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_19            ();
T_PRIMITIVE_UNION  mph_dedicated_req_6            (CHAR variant);
T_PRIMITIVE_UNION  mphc_async_ho_req_3            (CHAR variant);
T_PRIMITIVE_UNION  mph_power_req_3                ();
T_PRIMITIVE_UNION  mphc_init_l1_req_3             ();
T_PRIMITIVE_UNION  mph_power_cnf_4                ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_9        ();
T_PRIMITIVE_UNION  mph_bsic_cnf_17                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_5           ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_14       ();
T_PRIMITIVE_UNION  mph_bsic_cnf_22                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_6           ();
T_PRIMITIVE_UNION  mphc_data_ind_42               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_20            ();
T_PRIMITIVE_UNION  mphc_data_ind_43               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_21            ();
T_PRIMITIVE_UNION  mphc_data_ind_44               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_22            ();
T_PRIMITIVE_UNION  mphc_data_ind_45               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_23            ();
T_PRIMITIVE_UNION  mphc_data_ind_46               ();
T_PRIMITIVE_UNION  mph_error_ind_4                ();
T_PRIMITIVE_UNION  mph_error_ind_radio_link_fail  ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_15       ();
T_PRIMITIVE_UNION  mph_bsic_cnf_23                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_7           ();
T_PRIMITIVE_UNION  mphc_data_ind_47               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_24            ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_16       ();
T_PRIMITIVE_UNION  mph_bsic_cnf_24                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_8           ();
T_PRIMITIVE_UNION  mphc_data_ind_48               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_25            ();
T_PRIMITIVE_UNION  mph_classmark_req_2            ();
T_PRIMITIVE_UNION  mph_idle_req_7                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_start_ccch_req_11         (CHAR variant);
T_PRIMITIVE_UNION  mph_neighbourcell_req_5        (CHAR variant);
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_5      (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_8                 ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_6        ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_6      ();
T_PRIMITIVE_UNION  mph_power_req_4                ();
T_PRIMITIVE_UNION  mphc_init_l1_req_4             ();
T_PRIMITIVE_UNION  mphc_init_l1_req               (CHAR band);
T_PRIMITIVE_UNION  mph_power_cnf_5                ();
T_PRIMITIVE_UNION  mph_bsic_cnf_25                ();
T_PRIMITIVE_UNION  mphc_network_sync_ind_17       ();
T_PRIMITIVE_UNION  mph_bsic_cnf_33                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_9           ();
T_PRIMITIVE_UNION  mph_bsic_cnf_34                ();
T_PRIMITIVE_UNION  mphc_data_ind_49               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_26            ();
T_PRIMITIVE_UNION  mph_bsic_cnf_35                ();
T_PRIMITIVE_UNION  mphc_data_ind_50               ();
T_PRIMITIVE_UNION  mph_unitdata_ind_27            ();
T_PRIMITIVE_UNION  mph_classmark_req_3            ();
T_PRIMITIVE_UNION  mph_idle_req_9                 ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_7        (CHAR variant);
T_PRIMITIVE_UNION  mph_neighbourcell_req_7A       (CHAR variant);
T_PRIMITIVE_UNION  prim_tb_meas_ind_1             ();
T_PRIMITIVE_UNION  prim_tb_meas_ind_2             ();
T_PRIMITIVE_UNION  prim_tb_meas_ind_3             ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_7      (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_10                ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_8        ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_8      ();
T_PRIMITIVE_UNION  mph_idle_req_11                ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_9        ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_9      ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_3      ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_12         ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_10         ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_15         ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_13         ();
T_PRIMITIVE_UNION  mphc_ncell_sync_ind_16         ();
T_PRIMITIVE_UNION  mph_measurement_ind_21         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_28            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_29            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_30            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_31            ();
T_PRIMITIVE_UNION  mph_idle_req_12                ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_10     ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_4      ();
T_PRIMITIVE_UNION  mph_measurement_ind_22         ();
T_PRIMITIVE_UNION  mph_measurement_ind_23         ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_10       ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_11     ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_5      ();
T_PRIMITIVE_UNION  mph_measurement_ind_24         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_32            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_33            ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_11       ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_12     ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_6      ();
T_PRIMITIVE_UNION  mph_measurement_ind_25         ();
T_PRIMITIVE_UNION  mph_idle_req_13                ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_12       ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_13     ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_7      ();
T_PRIMITIVE_UNION  mph_measurement_ind_26         ();
T_PRIMITIVE_UNION  mph_measurement_ind_27         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_34            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_35            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_36            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_37            ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_14     ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_ind_8      ();
T_PRIMITIVE_UNION  mph_measurement_ind_28         ();
T_PRIMITIVE_UNION  mphc_data_ind_51               ();
T_PRIMITIVE_UNION  mphc_data_ind_52               ();
T_PRIMITIVE_UNION  mph_paging_ind_7               ();
T_PRIMITIVE_UNION  mph_channel_mode_req_1         ();
T_PRIMITIVE_UNION  mphc_channel_mode_modify_req_1 ();
T_PRIMITIVE_UNION  mphc_channel_mode_modify_con_1 ();
T_PRIMITIVE_UNION  mph_idle_req_14                ();
T_PRIMITIVE_UNION  mph_cbch_req_2                 (CHAR variant);
T_PRIMITIVE_UNION  mmi_cbch_req_1                 ();
T_PRIMITIVE_UNION  mphc_config_cbch_req_1         (CHAR variant);
T_PRIMITIVE_UNION  mphc_cbch_schedule_req_1       ();
T_PRIMITIVE_UNION  mphc_cbch_schedule_req_2       ();
T_PRIMITIVE_UNION  mmi_cbch_req_2                 (CHAR variant);
T_PRIMITIVE_UNION  mph_cbch_req_3                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_config_cbch_req_2         (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_53               ();
T_PRIMITIVE_UNION  mphc_data_ind_54               (CHAR variant);
T_PRIMITIVE_UNION  mphc_cbch_info_req_1           ();
T_PRIMITIVE_UNION  mphc_cbch_info_req_2           ();
T_PRIMITIVE_UNION  mphc_cbch_info_req_3           ();
T_PRIMITIVE_UNION  mphc_data_ind_55               ();
T_PRIMITIVE_UNION  mphc_data_ind_56               ();
T_PRIMITIVE_UNION  mphc_data_ind_57               ();
T_PRIMITIVE_UNION  mmi_cbch_ind_1                 (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_58               ();
T_PRIMITIVE_UNION  mphc_data_ind_59               ();
T_PRIMITIVE_UNION  mphc_data_ind_60               ();
T_PRIMITIVE_UNION  mphc_data_ind_61               ();
T_PRIMITIVE_UNION  mphc_data_ind_62               ();
T_PRIMITIVE_UNION  mphc_data_ind_66               ();
T_PRIMITIVE_UNION  mphc_data_ind_67               ();
T_PRIMITIVE_UNION  mphc_data_ind_68               (CHAR variant);
T_PRIMITIVE_UNION  mphc_data_ind_69               ();
T_PRIMITIVE_UNION  mphc_data_ind_70               ();
T_PRIMITIVE_UNION  mphc_data_ind_71               ();
T_PRIMITIVE_UNION  mphc_data_ind_72               ();
T_PRIMITIVE_UNION  mphc_data_ind_73               ();
T_PRIMITIVE_UNION  mphc_cbch_schedule_req_3       ();
T_PRIMITIVE_UNION  mphc_cbch_schedule_req_4       (CHAR variant);
T_PRIMITIVE_UNION  mph_idle_req_15                ();
T_PRIMITIVE_UNION  mphc_new_scell_req_10          ();
T_PRIMITIVE_UNION  mphc_data_ind_63               ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_12         ();
T_PRIMITIVE_UNION  mphc_data_ind_64               ();
T_PRIMITIVE_UNION  mphc_start_ccch_req_13         ();
T_PRIMITIVE_UNION  mphc_data_ind_65               ();
T_PRIMITIVE_UNION  mph_idle_req_16                ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_15     ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_13       ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_16     ();
T_PRIMITIVE_UNION  mph_idle_req_17                ();
T_PRIMITIVE_UNION  mphc_stop_dedicated_req        ();
T_PRIMITIVE_UNION  mphc_stop_dedicated_con        ();
T_PRIMITIVE_UNION  mph_stop_dedicated_req         ();
T_PRIMITIVE_UNION  mph_stop_dedicated_cnf         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_38            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_39            ();
T_PRIMITIVE_UNION  mphc_rxlev_periodic_req_17     ();
T_PRIMITIVE_UNION  mph_measurement_ind_29         ();
T_PRIMITIVE_UNION  mph_measurement_ind_30         ();
T_PRIMITIVE_UNION  mph_unitdata_ind_40            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_41            ();
T_PRIMITIVE_UNION  mph_unitdata_ind_42            ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_22         ();
T_PRIMITIVE_UNION  mphc_ncell_bcch_req_23         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_24         ();
T_PRIMITIVE_UNION mph_unitdata_ind_43            ();
T_PRIMITIVE_UNION mph_unitdata_ind_44            ();
T_PRIMITIVE_UNION mph_unitdata_ind_45            ();
T_PRIMITIVE_UNION mph_unitdata_ind_46            ();
T_PRIMITIVE_UNION mph_unitdata_ind_47            ();
T_PRIMITIVE_UNION mph_unitdata_ind_48            ();
T_PRIMITIVE_UNION mph_unitdata_ind_49            ();
T_PRIMITIVE_UNION mph_unitdata_ind_50            ();
T_PRIMITIVE_UNION mph_unitdata_ind_51            ();
T_PRIMITIVE_UNION mphc_ra_req_3                  ();
T_PRIMITIVE_UNION mphc_ra_req_4                  ();
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_18     ();
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_21     ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_24         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_25         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_26         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_25         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_26         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_27         ();
T_PRIMITIVE_UNION mph_measurement_ind_31         ();
T_PRIMITIVE_UNION mph_unitdata_ind_54            ();
T_PRIMITIVE_UNION mph_unitdata_ind_55            ();
T_PRIMITIVE_UNION mph_unitdata_ind_56            ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1     ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6     ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6a    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_6b    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1a    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1b    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1c    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1d    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1e    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1f    ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1h    ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_27         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_28         ();
T_PRIMITIVE_UNION mph_idle_req_20                ();
T_PRIMITIVE_UNION mphc_stop_ncell_sync_req_all   ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_1g    ();
T_PRIMITIVE_UNION mphc_stop_ncell_sync_req       (U16 arfcn);
T_PRIMITIVE_UNION mphc_new_scell_req_12          ();
T_PRIMITIVE_UNION mphc_start_ccch_req_14         ();
T_PRIMITIVE_UNION mphc_start_ccch_req_normal     ();
T_PRIMITIVE_UNION mph_idle_req_21                ();
T_PRIMITIVE_UNION mph_neighbourcell_req_15       ();
T_PRIMITIVE_UNION mph_neighbourcell_req_16       ();
T_PRIMITIVE_UNION mph_neighbourcell_req_17       ();
T_PRIMITIVE_UNION mph_neighbourcell_req_18       ();
T_PRIMITIVE_UNION mph_neighbourcell_req_19       ();
T_PRIMITIVE_UNION  mph_neighbourcell_req_sync_reconfirm();
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_20     ();
T_PRIMITIVE_UNION mph_measurement_ind_32         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_28         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_29         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_30         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_30         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_31         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_31         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_32         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_32         ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_33         ();
T_PRIMITIVE_UNION mph_measurement_ind_33         ();
T_PRIMITIVE_UNION mph_measurement_ind_34         ();
T_PRIMITIVE_UNION mph_unitdata_ind_57            ();
T_PRIMITIVE_UNION mph_unitdata_ind_58            ();
T_PRIMITIVE_UNION mph_unitdata_ind_59            ();
T_PRIMITIVE_UNION mph_unitdata_ind_60            ();
T_PRIMITIVE_UNION mph_unitdata_ind_61            ();
T_PRIMITIVE_UNION mph_unitdata_ind_62            ();
T_PRIMITIVE_UNION mphc_stop_ncell_sync_con     ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_2     ();
T_PRIMITIVE_UNION mph_idle_req_22                ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_33         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_34         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_35         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_36         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_37         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_38         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_39         ();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_3     ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_40         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_41         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_42         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_43         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_44         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_45         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_46         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_47         ();
T_PRIMITIVE_UNION mph_ncell_pos_ind_1            ();
T_PRIMITIVE_UNION mph_idle_req_23                ();
T_PRIMITIVE_UNION mphc_new_scell_req_13          ();
T_PRIMITIVE_UNION mphc_stop_rxlev_periodic_con_1 ();
T_PRIMITIVE_UNION mphc_ra_req_5                  ();
T_PRIMITIVE_UNION mphc_ra_req_6                  ();
T_PRIMITIVE_UNION mph_ncell_pos_req_2            (CHAR variant);
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_4     (CHAR variant);
T_PRIMITIVE_UNION mph_ncell_pos_ind_3            ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_48         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_49         ();
T_PRIMITIVE_UNION mph_ncell_pos_ind_4            ();
T_PRIMITIVE_UNION mphc_stop_rxlev_req            ();
T_PRIMITIVE_UNION  mphc_stop_rxlev_con           ();
T_PRIMITIVE_UNION mph_deactivate_req             (void);
T_PRIMITIVE_UNION em_l1_event_req_2              ();
T_PRIMITIVE_UNION mph_identity_req_2g            ();
T_PRIMITIVE_UNION mph_idle_req_1g                ();
T_PRIMITIVE_UNION mphc_data_ind_8g               ();
T_PRIMITIVE_UNION mph_paging_ind_1g              ();
T_PRIMITIVE_UNION mphc_data_ind_9g               ();
T_PRIMITIVE_UNION mphc_data_ind_10g              ();
T_PRIMITIVE_UNION mph_idle_req_4g                ();
T_PRIMITIVE_UNION mph_mon_ctrl_req               (U8 action);
T_PRIMITIVE_UNION mph_neighbourcell_req_3g       ();
T_PRIMITIVE_UNION mph_measurement_ind_1g         ();
T_PRIMITIVE_UNION mph_measurement_ind_2g         ();
T_PRIMITIVE_UNION mph_neighbourcell_req_4g       ();
T_PRIMITIVE_UNION mphc_stop_ncell_sync_req_1g    ();
T_PRIMITIVE_UNION mphc_ncell_sync_req_4g         ();
T_PRIMITIVE_UNION mph_measurement_ind_3g         ();
T_PRIMITIVE_UNION mph_measurement_ind_4g         ();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_3g         ();
T_PRIMITIVE_UNION mph_dedicated_req_2g           ();
T_PRIMITIVE_UNION mph_idle_req_2g                ();
T_PRIMITIVE_UNION mph_dedicated_fail_cnf_1g      ();
T_PRIMITIVE_UNION mphc_channel_assign_con_1g     ();
T_PRIMITIVE_UNION mphc_channel_assign_req_1g     ();
T_PRIMITIVE_UNION mphc_immed_assign_req_2g       ();
T_PRIMITIVE_UNION mph_dedicated_req_2g           ();
T_PRIMITIVE_UNION mph_dedicated_fail_req_1g      ();
T_PRIMITIVE_UNION mph_power_cnf_one_ncell        ();
T_PRIMITIVE_UNION mphc_network_sync_ind_32       ();
T_PRIMITIVE_UNION mphc_network_sync_ind_failed   (U16 arfcn);
T_PRIMITIVE_UNION mph_bsic_cnf_failed            (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_sync_req_initial    (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_sync_ind_failed     (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_sync_ind_cell32     ();
T_PRIMITIVE_UNION mphc_new_scell_req_cell32      ();
T_PRIMITIVE_UNION mph_bsic_cnf_cell32            ();
T_PRIMITIVE_UNION mphc_ncell_bcch_req_cell32     (U16 blocks_required);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si3        (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si2        (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si4        (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si7        (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si8        (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_invalid    (U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_bcch_ind_si4_acs    (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si3(U16 arfcn, U16 cell_id = CELL_IDENT_1);
T_PRIMITIVE_UNION mph_unitdata_ind_si2           (U16 arfcn);
T_PRIMITIVE_UNION mphc_stop_ncell_bcch_req       (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si1           (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si1_chg       (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si7           (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si4_diff_cs   (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si4           (U16 arfcn);
T_PRIMITIVE_UNION mph_unitdata_ind_si8           (U16 arfcn);
T_PRIMITIVE_UNION mph_idle_req_15g               ();
T_PRIMITIVE_UNION mph_neighbourcell_req_plmn_search(U16 cell1, U16 cell2=NOT_PRESENT_16BIT);
T_PRIMITIVE_UNION mph_measurement_ind_plmn_search (U16 cell1, U8 bsic1, U16 cell2=NOT_PRESENT_16BIT, U8 bsic2=NOT_PRESENT_8BIT);
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32a();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32b();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32c();
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_cell32d();
T_PRIMITIVE_UNION mphc_stop_cbch_req();
#ifdef FF_EGPRS
T_PRIMITIVE_UNION mphc_data_ind_si2quater(int ch_type);
T_PRIMITIVE_UNION mph_unitdata_ind_si2q(U16 arfcn);
T_PRIMITIVE_UNION mph_enhpara_update_req_1 (char variant);
T_PRIMITIVE_UNION mph_mon_ctrl_req_1(U8 action, U8 si_read);
T_PRIMITIVE_UNION mphc_ncell_list_sync_req_emr();
T_PRIMITIVE_UNION mphc_scell_ebcch_req_si2q();
T_PRIMITIVE_UNION mphc_scell_nbcch_req_1();
T_PRIMITIVE_UNION mph_neighbourcell_req_emr_1();
T_PRIMITIVE_UNION mphc_rxlev_periodic_req_emr_1();
T_PRIMITIVE_UNION mph_enhpara_update_req_2 ();
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_emr_1();
T_PRIMITIVE_UNION mph_measurement_ind_emr_1();
T_PRIMITIVE_UNION mphc_ncell_sync_ind_emr(U16 arfcn, U8 bsic,U8 sb_status);
T_PRIMITIVE_UNION mphc_ncell_bcch_req_emr(U16 arfcn);
T_PRIMITIVE_UNION mphc_stop_ncell_bcch_req_emr();
T_PRIMITIVE_UNION mphc_meas_report_emr(char variant);
T_PRIMITIVE_UNION mph_neighbourcell_req_emr_2();
T_PRIMITIVE_UNION mphc_update_ba_list_emr();
T_PRIMITIVE_UNION mph_idle_req_15_si2q(int mode);
#endif  // FF_EGPRS
T_PRIMITIVE_UNION mphc_new_scell_req_20();
T_PRIMITIVE_UNION mphc_ncell_sync_req_fn(U16 arfcn);
T_PRIMITIVE_UNION mphc_ncell_sync_ind_fn(U16 arfcn);
T_PRIMITIVE_UNION mphc_meas_report_4();
T_PRIMITIVE_UNION mphc_meas_report_5();
T_PRIMITIVE_UNION mphc_meas_report_6();
T_PRIMITIVE_UNION mphc_meas_report_6a();
T_PRIMITIVE_UNION mph_measurement_ind_dummy(U16 s_arfcn, U8 rxlev_full);
T_PRIMITIVE_UNION mph_measurement_ind_bho_1(U16 s_arfcn, U8 rxlev_full);
T_PRIMITIVE_UNION mph_dedicated_req_fn(U8 mode, U16 arfcn, U8 bsic);
T_PRIMITIVE_UNION mphc_async_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment);
T_PRIMITIVE_UNION mphc_sync_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment);
T_PRIMITIVE_UNION mphc_presync_ho_req_ho_type_fn(U8 ho_type, U32 fn_offset, U32 time_alignment);
T_PRIMITIVE_UNION mphc_handover_finished_fn(U8 cause);
T_PRIMITIVE_UNION mph_dedicated_cnf_fn(U8 cause);
T_PRIMITIVE_UNION mph_meas_rep_cnf();
T_PRIMITIVE_UNION mph_meas_rep_req( U8 meas_cause);
T_PRIMITIVE_UNION mphc_rxlev_periodic_ind_9(U16 rx_1, U16 rx_2, U16 rx_3, U16 rx_4);
T_PRIMITIVE_UNION mph_meas_rep_cnf_sc();
T_PRIMITIVE_UNION mph_meas_rep_cnf_sc_n1();
T_PRIMITIVE_UNION mph_meas_rep_cnf_sc_n3();
T_PRIMITIVE_UNION mph_measurement_ind_35();
T_PRIMITIVE_UNION mph_measurement_ind_36();
T_PRIMITIVE_UNION mph_measurement_ind_36A();
#endif

