/*
  +------------------------------------------------------------------------------
  |  File:       alr_constraints.cpp
  +------------------------------------------------------------------------------
  |              Copyright 2003 Texas Instruments
  |              All rights reserved.
  |
  |              This file is confidential and a trade secret of Texas Instruments.
  |              The receipt of or possession of this file does not convey
  |              any rights to reproduce or disclose its contents or to
  |              manufacture, use, or sell anything it may describe, in
  |              whole, or in part, without the specific written consent of
  |              Texas Instruments.
  +------------------------------------------------------------------------------
  | Purpose:     Contains test constraints for alr
  |
  +------------------------------------------------------------------------------
*/
#include "alr_constraints.h"


/*-------------------------------------------------------------------------------
 *
 *                            ARRAYS
 *
 *-------------------------------------------------------------------------------*/
const U8 L2_PAG_2_T1_A_ARRAY[23] = {
 	0x1D,
	0x06,
	0x22,
	0x00,
	0x05, 0x22, 0x33, 0x66,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B
};

T_raw cell_chan_desc_1() {
  T_raw bitbuf;
  bitbuf->l_buf = 128;
  bitbuf->o_buf = 0;
  const U8 CELL_CHAN_DESC_1[] = {
    0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
  	0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };
  bitbuf->buf = CELL_CHAN_DESC_1;
  return bitbuf;
}

T_raw cell_chan_desc_1_new() {
  T_raw bitbuf;
  bitbuf->l_buf = 128;
  bitbuf->o_buf = 0;
  const U8 CELL_CHAN_DESC_1_NEW[] = {
    0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
  	0x00, 0x18, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };
  bitbuf->buf = CELL_CHAN_DESC_1_NEW;
  return bitbuf;
}

T_raw neigh_cell_desc_1() {
  T_raw bitbuf;
  bitbuf->l_buf = 128;
  bitbuf->o_buf = 0;
  const U8 NEIGH_CELL_DESC_1[] = {
    0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
  	0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x04
  };
  bitbuf->buf = NEIGH_CELL_DESC_1;
  return bitbuf;
}

T_raw neigh_cell_desc_2() {
  T_raw bitbuf;
  bitbuf->l_buf = 128;
  bitbuf->o_buf = 0;
  const U8 NEIGH_CELL_DESC_2[] = {
    0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
  	0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };
  bitbuf->buf = NEIGH_CELL_DESC_2;
  return bitbuf;
}

const U16 A_ARFCN_EMO_000[4] = {
	1,46,47,124
};

const U8 LIST_no_carriers[LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const U8 LIST_1_14_euro [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01
      };

const U8 LIST_140_150_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x08, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      };

const U8 LIST_155_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
      };

const U8 LIST_975_euro[] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const U8 LIST_130_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

    /*  Constant for Whitelist with more than 35 carriers  */

const U8 LIST_garbage_euro[LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0xFF, 0x00, 0x00, 0x00, 0xFF, 
      0xFF, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0x00, 0x00,
      0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
};

const U8 LIST_130_140_150_250_155_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x04, 0x20, 0x08, 0x02, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const U8 LIST_1_14_23_124_euro [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x20, 0x01
};

const U8 LIST_131_143_152_251_156_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x08, 0x80, 0x40, 0x04,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const U8 LIST_1024_1023_10_20_amr [LIST_MAX_SIZE] = {
      0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x02, 0x00
};

const U8 LIST_1_euro [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
      };

const U8 LIST_130_250_155_amr [LIST_MAX_SIZE] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x02, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

const U8 L_RXT5_30_25_20_20_20 [MAX_NUM_BANDS] = {
      0x1E, 0x19, 0x14, 0x14, 0x14
};


const U8 L_RXT5_20 [MAX_NUM_BANDS] = {
      0x14, 0x14, 0x14, 0x14, 0x14
};

/*-------------------------------------------------------------------------------
 *
 *                            PSTRUCTS
 *
 *-------------------------------------------------------------------------------*/
T_loc_area_ident loc_area_ident_2()
{
  const U8 MCC_2[3] = {
    0, 0, 0
  };
  const U8 MNC_2[3] = {
    0, 0, 0
  };
  T_loc_area_ident mstruct;
  mstruct->mcc = MCC_2;
  mstruct->mnc = MNC_2;
  mstruct->lac = 0x0200;
  return mstruct;
}
T_l2_frame l2_sys_info_1()
{
  const U8 L2_SYS_INFO_1_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x19,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x40,
	  0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_1_ARRAY;
  return pstruct;
}
T_l2_frame l2_sys_info_2()
{
  const U8 L2_SYS_INFO_2_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x1A,
	  0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x04,
	  0x01,
	  0x00, 0x00, 0x40
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_2_ARRAY;
  return pstruct;
}

T_l2_frame l2_sys_info_3()
{
  const U8 L2_SYS_INFO_3_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x1B,
	  0x37, 0x48,
	  0x21, 0xF3, 0x33, 0x21, 0x47,
	  0x28, 0x02, 0x06,
	  0x5F,
	  0x42, 0x56,
	  0x00, 0x00, 0x40,
	  0x2B, 0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_3_ARRAY;
  return pstruct;
}
T_l2_frame l2_sys_info_3_new()
{
  const U8 L2_SYS_INFO_3_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x1B,
	  0x00, 0x04,
	  0x21, 0xF3, 0x33, 0x21, 0x47,
	  0x28, 0x02, 0x06,
	  0x5F,
	  0x42, 0x56,
	  0x00, 0x00, 0x40,
	  0x2B, 0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_3_ARRAY;
  return pstruct;
}

T_l2_frame l2_sys_info_4()
{
  const U8 L2_SYS_INFO_4_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x1C,
	  0x21, 0xF3, 0x33, 0x21, 0x47,
	  0x42, 0x56,
	  0x00, 0x00, 0x40,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_4_ARRAY;
  return pstruct;
}
T_l2_frame l2_sys_info_4_acs()
{
  const U8 L2_SYS_INFO_4_ACS_ARRAY[23] = {
    0x59,
    0x06,
    0x1C,
    0x21, 0xF3, 0x33, 0x21, 0x47,
    0x42, 0xD6,
    0x00, 0x00, 0x40,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_4_ACS_ARRAY;
  return pstruct;
}

T_l2_frame l2_sys_info_2q()
{
  const U8 L2_SYS_INFO_2Q_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x07, /*Msg type*/
	  0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x04,
	  0x01,
	  0x00, 0x00, 0x40
  };

  T_l2_frame pstruct;
  pstruct->content = L2_SYS_INFO_2Q_ARRAY;
  return pstruct;
}


T_cell_opt_sacch cell_opt_sacch_1()
{

  T_cell_opt_sacch mstruct;
  mstruct->dtx2_s = 0;
  mstruct->pow_ctrl = POW_CTRL_NO;
  mstruct->dtx_s = S_DTX_F_MAYUSE_H_DONTUSE;
  mstruct->rlt = 1;
  return mstruct;
}
T_rach_ctrl rach_ctrl_1()
{
  T_rach_ctrl mstruct;
  mstruct->max_retrans     = MAX_RETRANS_1;
  mstruct->tx_integer      = SPREAD_TRANS_3;
  mstruct->cell_bar_access = BARRED_NO;
  mstruct->re              = REESTAB_YES;
  mstruct->ac              = ACC_0005;
  return mstruct;
}
T_loc_area_ident loc_area_ident_1()
{
  const U8 MCC_1[3] = {
	  1,2,3
  };
  const U8 MNC_1[2] = {
	  3,3
  };
  T_loc_area_ident mstruct;
  mstruct->mcc = MCC_1;
  mstruct->mnc = MNC_1;
  mstruct->lac = 0x2147;
  return mstruct;
}
T_ctrl_chan_desc ctrl_chan_desc_1()
{
  T_ctrl_chan_desc mstruct;
  mstruct->att = CCD_ATT_NO;
  mstruct->bs_ag_blks_res = 5;
  mstruct->ccch_conf = CCD_CCCH_1_NOT_COMB;
  mstruct->bs_pa_mfrms = 2;
  mstruct->t3212 = 6;
  return mstruct;
}
T_cell_opt_bcch cell_opt_bcch_1()
{
  T_cell_opt_bcch mstruct;
  mstruct->pow_ctrl = POW_CTRL_YES;
  mstruct->dtx_b = B_DTX_SHALL_USE;
  mstruct->rlt = 15;
  return mstruct;
}
T_cell_select cell_select_1()
{
  T_cell_select mstruct;
  mstruct->cell_resel_hyst = CELL_HYST_4_DB;
  mstruct->ms_txpwr_max_cch = 2;
  mstruct->acs = ACS_USE_SI4	;
  mstruct->neci = NECI_YES;
  mstruct->rxlev_access_min = 22;
  return mstruct;
}
T_cell_select cell_select_2()
{
  T_cell_select mstruct;
  mstruct->cell_resel_hyst = CELL_HYST_4_DB;
  mstruct->ms_txpwr_max_cch = 2;
  mstruct->acs = ACS_USE_SI7	;
  mstruct->neci = NECI_YES;
  mstruct->rxlev_access_min = 22;
  return mstruct;
}
T_si7_rest_oct si7_rest_oct_1()
{
  T_si7_rest_oct mstruct;
  mstruct->opt_sel_par._skip;
  mstruct->pow_offs._skip;
  mstruct->gprs_indic._skip;
  mstruct->si4_rest_octets_s._skip;
  return mstruct;
}
T_si8_rest_oct si8_rest_oct_1()
{
  T_si8_rest_oct mstruct;
  mstruct->opt_sel_par._skip;
  mstruct->pow_offs._skip;
  mstruct->gprs_indic._skip;
  mstruct->si4_rest_octets_s._skip;
  return mstruct;
}
T_l2_frame l2_paging_req_1()
{
  const U8 L2_PAGING_REQ_1_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x21,
	  PAGING_NORM,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  T_l2_frame pstruct;
  pstruct->content = L2_PAGING_REQ_1_ARRAY;
  return pstruct;
}
T_l2_frame l2_paging_req_1_sab()
{
  const U8 L2_PAGING_REQ_1_SAB_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x21,
	  PAGING_SAME,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_PAGING_REQ_1_SAB_ARRAY;
  return pstruct;
}
T_l2_frame l2_paging_req_1_ext()
{
  const U8 L2_PAGING_REQ_1_EXT_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x21,
	  PAGING_EXT,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_PAGING_REQ_1_EXT_ARRAY;
  return pstruct;
}
T_l2_frame l2_paging_req_1_reo()
{
  const U8 L2_PAGING_REQ_1_REO_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x21,
	  PAGING_REORG,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  T_l2_frame pstruct;
  pstruct->content = L2_PAGING_REQ_1_REO_ARRAY;
  return pstruct;
}

T_l2_frame l2_imm_ass_hop()
{
  const U8 L2_IMM_ASS_HOP_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x3F,
	  0x00,
	  0x40, 0x10, 0x40,
	  0xFB, 0x21, 0x06,
	  0x1E,
	  0x01, 0x16,
	  0x2B,0x2B,0x2B,0x2B,0x2B,
	  0x2B,0x2B,0x2B,0x2B,0x2B
  };

  T_l2_frame pstruct;
  pstruct->content = L2_IMM_ASS_HOP_ARRAY;
  return pstruct;
}
T_page_mode page_mode_1()
{
  T_page_mode mstruct;
  mstruct->pm = PAGING_NORM;
  return mstruct;
}
T_chan_desc chan_desc_1()
{
  T_chan_desc mstruct;
  mstruct->chan_type = SDCCH_8_S0;
  mstruct->tn = 0;
  mstruct->tsc = 0;
  mstruct->hop = HOP_YES;
  mstruct->arfcn._skip;
  mstruct->maio = 1;
  mstruct->hsn = 0;
  return mstruct;
}
T_req_ref req_ref_1()
{
  T_req_ref mstruct;
  mstruct->ra = 0xFB;
  mstruct->t1 = 4;
  mstruct->t3 = 8;
  mstruct->t2 = 6;
  return mstruct;
}
T_time_advance time_advance_1()
{
  T_time_advance mstruct;
  mstruct->ta = 0x1E;
  return mstruct;
}
T_mob_alloc mob_alloc_1()
{
  const U8 MAC_1_elements[1] = {
	  0x16
  };
  T_ARRAY<U8> MAC_1(MAC_1_elements, SKIP_TO_END);

  T_mob_alloc mstruct;
  mstruct->mac = MAC_1;
  return mstruct;
}
T_l2_frame l2_no_content()
{
  const U8 EMPTY_FRAME_elements[1] = {
    0
  };
  T_ARRAY<U8> EMPTY_FRAME(EMPTY_FRAME_elements, SKIP_TO_END);

  T_l2_frame pstruct;
  pstruct->content = EMPTY_FRAME;
  return pstruct;
}

T_tb_meas_result tb_meas_result_1(U16 acc_lev,U8 acc_nbr)
{
   T_tb_meas_result pstruct;
   pstruct->arfcn = ARFCN_23;
   pstruct->rxlev = acc_lev;
   pstruct->num_meas = acc_nbr;
   return pstruct;
}

T_tb_meas_result tb_meas_result_2(U16 acc_lev,U8 acc_nbr)
{
   T_tb_meas_result pstruct;
   pstruct->arfcn = ARFCN_512;
   pstruct->rxlev = acc_lev;
   pstruct->num_meas = acc_nbr;
   return pstruct;
}
T_tb_meas_result tb_meas_empty()
{
   T_tb_meas_result pstruct;
   pstruct->arfcn = TB_INVALID_ARFCN;
   pstruct->rxlev = acc_level_0;
   pstruct->num_meas = acc_nbr_0;
   return pstruct;
}

T_ARRAY<T_tb_meas_result> tb_list_1()
{
   T_tb_meas_result array[TB_BA_LIST_SIZE] = {
        tb_meas_result_1(acc_level_4,acc_nbr_4), tb_meas_result_2(acc_level_5,acc_nbr_5), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty()
   };
   return array;
}
T_ARRAY<T_tb_meas_result> tb_list_2()
{
   T_tb_meas_result array[TB_BA_LIST_SIZE] = {
        tb_meas_result_1(acc_level_3,acc_nbr_3), tb_meas_result_2(acc_level_6,acc_nbr_6), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty()
   };
   return array;
}
T_ARRAY<T_tb_meas_result> tb_list_3()
{
   T_tb_meas_result array[TB_BA_LIST_SIZE] = {
        tb_meas_result_1(acc_level_2,acc_nbr_2), tb_meas_result_2(acc_level_7,acc_nbr_7), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty(), tb_meas_empty(), tb_meas_empty(),
        tb_meas_empty(), tb_meas_empty()
   };
   return array;
}


T_ARRAY<T_meas_results> s_emo_meas_res_000()
{
  T_meas_results array[5];
  array[0]->arfcn  = CONST_1;
  array[0]->rx_lev = CONST_30;
  array[1]->arfcn  = CONST_46;
  array[1]->rx_lev = CONST_6;
  array[2]->arfcn  = CONST_47;
  array[2]->rx_lev = CONST_53;
  array[3]->arfcn  = CONST_124;
  array[3]->rx_lev = CONST_13;
  array[4]->arfcn  = CONST_23;
  array[4]->rx_lev = CONST_1;
  return array;
}
T_frequency_list freq_list()
{
  const U16 CHLIST_14_23_69_115_elements[4] = {
	  ARFCN_14,
	  ARFCN_23,
	  ARFCN_69,
	  ARFCN_115
  };
  T_ARRAY<U16> CHLIST_14_23_69_115(CHLIST_14_23_69_115_elements, SKIP_TO_END);

  T_frequency_list pstruct;
  pstruct->rf_chan_cnt = 4;
  pstruct->rf_chan_no.radio_freq = CHLIST_14_23_69_115;
  return pstruct;
}

/*-------------------------------------------------------------------------------
 *
 *                            PRIMITIVES
 *
 *-------------------------------------------------------------------------------*/

T_PRIMITIVE_UNION mph_power_req_1()
{
  T_MPH_POWER_REQ prim;
  prim->pch_interrupt = PCH_INTERRUPT;
  prim->freq_bands    = BAND_GSM_900;
  // New Element added in Cell Selection Improvement
  prim->search_mode   = FULL_SEARCH_MODE;
  prim->black_list.list[EUROPEAN_REGION].channels = LIST_no_carriers;
  prim->black_list.list[AMERICAN_REGION].channels = LIST_no_carriers;
  prim->white_list.white_list_valid               = TRUE;
  prim->white_list.region                         = EUROPEAN_REGION;
  prim->white_list.list.channels                  = LIST_no_carriers;
  // New Element added in Cell Selection Improvement ends here
  return prim;
}


T_PRIMITIVE_UNION mph_power_req_variant(U8 search_mode, CHAR variant)
{
  T_MPH_POWER_REQ prim;
  prim->pch_interrupt = PCH_INTERRUPT;
  prim->freq_bands    = 0x1F;
  prim->search_mode   = search_mode;
  prim->black_list.list[EUROPEAN_REGION].channels = LIST_no_carriers;
  prim->black_list.list[AMERICAN_REGION].channels = LIST_no_carriers;
  prim->white_list.white_list_valid               = TRUE;
  prim->white_list.region                         = EUROPEAN_REGION;
  prim->white_list.list.channels                  = LIST_no_carriers;
  prim->lower_rxlevel_threshold = L_RXT5_20;
  switch(variant)
  {  // Variant X will be used to execute the default case
    case 'A' :
      prim->pch_interrupt = NO_PCH_INTERRUPT;
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_1_14_euro;
      prim->white_list.list.channels                  = LIST_1_14_euro;
      break;
    case 'B' :
      prim->white_list.list.channels = LIST_1_14_euro;
      break;
    case 'C' :
      prim->white_list.list.channels = LIST_garbage_euro;
      break;
    case 'D' :
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_1024_1023_10_20_amr;
      break;
    case 'F' :
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_1_14_euro;
      prim->white_list.list.channels                  = LIST_1_14_euro;
      break;
    case 'G' :
      prim->freq_bands    = BAND_GSM_850;
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_1_14_euro;
      prim->white_list.list.channels                  = LIST_130_amr;
      break;
    case 'H' :
      prim->freq_bands    = BAND_GSM_850;
      prim->black_list.list[AMERICAN_REGION].channels = LIST_140_150_amr;
      prim->white_list.region                         = AMERICAN_REGION;
      prim->white_list.list.channels                  = LIST_130_amr;
      break;
    case 'I' :
      prim->freq_bands    = BAND_DUAL_US;
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_1_14_euro;
      prim->white_list.list.channels                  = LIST_1_14_euro;
      break;
    case 'J' :
      prim->white_list.white_list_valid               = FALSE;
      break;
    case 'K':
      prim->white_list.region                         = AMERICAN_REGION;
      prim->white_list.list.channels                  = LIST_130_amr;
      break;
    case 'L':
      prim->white_list.region                         = AMERICAN_REGION;
      prim->white_list.list.channels                  = LIST_131_143_152_251_156_amr;
      break;
    case 'M':
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_140_150_amr;
      prim->white_list.list.channels                  = LIST_1_14_euro;
      break;
    case 'N':
      prim->black_list.list[EUROPEAN_REGION].channels = LIST_975_euro;
      prim->white_list.list.channels                  = LIST_1_14_euro;
      break;
    case 'O':
      prim->lower_rxlevel_threshold = L_RXT5_30_25_20_20_20;
    default  :
      break;
  }
  return prim;
}


T_PRIMITIVE_UNION mph_power_req_2()
{
  T_MPH_POWER_REQ prim;
  prim->pch_interrupt = NO_PCH_INTERRUPT;
  prim->freq_bands = BAND_GSM_900;
  prim->search_mode   = FULL_SEARCH_MODE;
  prim->black_list.list[EUROPEAN_REGION].channels = LIST_no_carriers;
  prim->black_list.list[AMERICAN_REGION].channels = LIST_no_carriers;
  prim->white_list.white_list_valid               = TRUE;
  prim->white_list.region                         = EUROPEAN_REGION;
  prim->white_list.list.channels                  = LIST_no_carriers;
  return prim;
}

T_PRIMITIVE_UNION mph_power_req_3()
{
  T_MPH_POWER_REQ prim;
  prim->pch_interrupt = PCH_INTERRUPT;
  prim->freq_bands = BAND_DCS_1800;
  prim->search_mode   = FULL_SEARCH_MODE;
  prim->black_list.list[EUROPEAN_REGION].channels = LIST_no_carriers;
  prim->black_list.list[AMERICAN_REGION].channels = LIST_no_carriers;
  prim->white_list.white_list_valid               = TRUE;
  prim->white_list.region                         = EUROPEAN_REGION;
  prim->white_list.list.channels                  = LIST_no_carriers;
  return prim;
}

T_PRIMITIVE_UNION mph_power_req_4()
{
  T_MPH_POWER_REQ prim;
  prim->pch_interrupt = PCH_INTERRUPT;
  prim->freq_bands = BAND_DUAL;
  prim->search_mode                               = FULL_SEARCH_MODE;
  prim->black_list.list[EUROPEAN_REGION].channels = LIST_no_carriers;
  prim->black_list.list[AMERICAN_REGION].channels = LIST_no_carriers;
  prim->white_list.white_list_valid               = TRUE;
  prim->white_list.region                         = EUROPEAN_REGION;
  prim->white_list.list.channels                  = LIST_no_carriers;
  return prim;
}

T_PRIMITIVE_UNION mphc_init_l1_req_1()
{
  T_MPHC_INIT_L1_REQ prim;
  prim->radio_band_config = STD_900;
  return prim;
}
T_PRIMITIVE_UNION mphc_init_l1_req_2()
{
  T_MPHC_INIT_L1_REQ prim;
  prim->radio_band_config = STD_EGSM;
  return prim;
}
T_PRIMITIVE_UNION mphc_init_l1_req_3()
{
  T_MPHC_INIT_L1_REQ prim;
  prim->radio_band_config = STD_1800;
  return prim;
}
T_PRIMITIVE_UNION mphc_init_l1_req_4()
{
  T_MPHC_INIT_L1_REQ prim;
  prim->radio_band_config = STD_DUAL;
  return prim;
}

T_PRIMITIVE_UNION mphc_init_l1_req(CHAR band)
{
  T_MPHC_INIT_L1_REQ prim;
  prim->radio_band_config = band;
  return prim;
}

T_PRIMITIVE_UNION mphc_init_l1_con_1()
{
  T_MPHC_INIT_L1_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_req()
{
  T_MPHC_RXLEV_REQ prim;
  prim->shared_ptr._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_rxlev_ind(U8 idx)
{
  T_MPHC_RXLEV_IND prim;
  prim->shared_ptr = idx;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_1()
{
  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_4;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn._skip;
  prim->rx_lev._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_one_ncell()
{
  const U16 ARFCN_32_elements[] = { ARFCN_32_STD_900 };
  T_ARRAY<U16> ARFCN_32a(ARFCN_32_elements, SKIP_TO_END);
  const U16 RXLEV_20_elements[] = { 20 };
  T_ARRAY<U16> RXLEV_20(RXLEV_20_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = 1;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn  = ARFCN_32a;
  prim->rx_lev = RXLEV_20;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_2()
{
  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_0;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn._skip;
  prim->rx_lev._skip;
  prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
  prim->inactive_carrier_list.list[1].channels = LIST_no_carriers;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_american()
{
  const U16 ARFCN_23_14_124_1_WITH_STD_elements[] = {
    ARFCN_150_STD_850, ARFCN_140_STD_850, ARFCN_250_STD_850, ARFCN_130_STD_850
  };
  T_ARRAY<U16> ARFCN_23_14_124_1_WITH_STD(ARFCN_23_14_124_1_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_14_124_1_elements[] = {
    250, 220, 125, 105
  };
  T_ARRAY<U8> RXLEV_23_14_124_1(RXLEV_23_14_124_1_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_4;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_23_14_124_1_WITH_STD;
  prim->rx_lev = RXLEV_23_14_124_1;
  prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
  prim->inactive_carrier_list.list[1].channels = LIST_155_amr;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_american1()
{
  const U16 ARFCN_23_14_124_1_WITH_STD_elements[] = {
    ARFCN_130_STD_850, ARFCN_250_STD_850
  };
  T_ARRAY<U16> ARFCN_23_14_124_1_WITH_STD(ARFCN_23_14_124_1_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_14_124_1_elements[] = {
    105, 125
  };
  T_ARRAY<U8> RXLEV_23_14_124_1(RXLEV_23_14_124_1_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_2;
  prim->num_of_white_list_chan = CHANNELS_1;
  prim->arfcn = ARFCN_23_14_124_1_WITH_STD;
  prim->rx_lev = RXLEV_23_14_124_1;
  prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
  prim->inactive_carrier_list.list[1].channels = LIST_155_amr;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_3()
{
  const U16 ARFCN_23_14_124_1_WITH_STD_elements[] = {
	  ARFCN_23_STD_900, ARFCN_14_STD_900, ARFCN_124_STD_900, ARFCN_1_STD_900
  };
  T_ARRAY<U16> ARFCN_23_14_124_1_WITH_STD(ARFCN_23_14_124_1_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_14_124_1_elements[] = {
    56, 44, 25, 21
  };
  T_ARRAY<U8> RXLEV_23_14_124_1(RXLEV_23_14_124_1_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_4;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_23_14_124_1_WITH_STD;
  prim->rx_lev = RXLEV_23_14_124_1;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_32_whitelist()
{
  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_43;
  prim->num_of_white_list_chan = CHANNELS_32;
  prim->arfcn._show;
  prim->rx_lev._show;
  prim->inactive_carrier_list.list[0].channels._show;
  prim->inactive_carrier_list.list[1].channels._show;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_3_new()
{
  const U16 ARFCN_23_14_124_1_WITH_STD_elements[] = {
     ARFCN_14_STD_EGSM, ARFCN_1_STD_EGSM, ARFCN_23_STD_EGSM, ARFCN_150_STD_DUAL_US, 
       ARFCN_140_STD_DUAL_US,ARFCN_124_STD_EGSM, ARFCN_250_STD_DUAL_US, ARFCN_130_STD_DUAL_US
  };
  T_ARRAY<U16> ARFCN_23_14_124_1_WITH_STD(ARFCN_23_14_124_1_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_14_124_1_elements[] = {
    44, 21, 56, 50, 44, 25, 25, 21
  };
  T_ARRAY<U8> RXLEV_23_14_124_1(RXLEV_23_14_124_1_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_8;
  prim->num_of_white_list_chan = CHANNELS_2;
  prim->arfcn = ARFCN_23_14_124_1_WITH_STD;
  prim->rx_lev = RXLEV_23_14_124_1;
  prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
  prim->inactive_carrier_list.list[1].channels = LIST_155_amr;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_same_white_black()
{
  const U16 ARFCN_23_124_WITH_STD_elements[] = {
     ARFCN_23_STD_EGSM, ARFCN_150_STD_DUAL_US, ARFCN_140_STD_DUAL_US, 
         ARFCN_124_STD_EGSM, ARFCN_250_STD_DUAL_US, ARFCN_130_STD_DUAL_US
  };
  T_ARRAY<U16> ARFCN_23_124_WITH_STD(ARFCN_23_124_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_124_elements[] = {
    24, 50, 44, 25,  25, 21
  };
  T_ARRAY<U8> RXLEV_23_124(RXLEV_23_124_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_6;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_23_124_WITH_STD;
  prim->rx_lev._skip;
  prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
  prim->inactive_carrier_list.list[1].channels = LIST_155_amr;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_rxlevel(CHAR variant)
{
  U8 no_of_channels;
  const U16 ARFCN_23_124_WITH_STD_elements[] = {
     ARFCN_23_STD_EGSM, ARFCN_150_STD_DUAL_US, ARFCN_140_STD_DUAL_US, 
         ARFCN_124_STD_EGSM, ARFCN_250_STD_DUAL_US, ARFCN_130_STD_DUAL_US
  };

  T_ARRAY<U16> ARFCN_23_124_WITH_STD(ARFCN_23_124_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_124_elements[] = {
    24, 250, 220, 125, 125, 105
  };

  const U8 FIVE_RXLEV_23_124_elements[] = {
    56, 50, 44, 25,  25, 21
  };

  T_ARRAY<U8> RXLEV_23_124(RXLEV_23_124_elements, SKIP_TO_END);

  T_ARRAY<U8> FIVE_RXLEV_23_124(FIVE_RXLEV_23_124_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;

  no_of_channels = CHANNELS_6;
  switch(variant)
  {
    case 'A' :
      prim->rx_lev = FIVE_RXLEV_23_124;
      break;
    case 'C' :
      prim->num_of_chan = CHANNELS_0;
    case 'B' :
      prim->rx_lev = RXLEV_23_124;
      break;
  }
  prim->num_of_chan = no_of_channels;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_23_124_WITH_STD;
  prim->inactive_carrier_list.list[0].channels._skip;
  prim->inactive_carrier_list.list[1].channels._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_lrxt()
{
  const U16 ARFCN_23_124_WITH_STD_elements[] = {
     ARFCN_23_STD_EGSM, ARFCN_150_STD_DUAL_US, ARFCN_14_STD_EGSM, 
     ARFCN_140_STD_DUAL_US, ARFCN_124_STD_EGSM
  };

  T_ARRAY<U16> ARFCN_23_124_WITH_STD(ARFCN_23_124_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_23_124_elements[] = {
    56, 50, 44, 44, 25
  };

  T_ARRAY<U8> RXLEV_23_124(RXLEV_23_124_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;

  prim->num_of_chan = CHANNELS_5;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_23_124_WITH_STD;
  prim->rx_lev = RXLEV_23_124;
  prim->inactive_carrier_list.list[0].channels = LIST_1_euro;
  prim->inactive_carrier_list.list[1].channels = LIST_130_250_155_amr;
  return prim;
}


T_PRIMITIVE_UNION mph_power_cnf_black()
{
  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_6;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn._show;
  prim->rx_lev._show;
  prim->inactive_carrier_list.list[0].channels._show;
  prim->inactive_carrier_list.list[1].channels._show;
  return prim;
}


T_PRIMITIVE_UNION mph_power_cnf_4()
{
  const U16 ARFCN_637_580_885_512_WITH_STD_elements[CHANNELS_4] = {
	  ARFCN_637_STD_1800,
	  ARFCN_580_STD_1800,
	  ARFCN_885_STD_1800,
	  ARFCN_512_STD_1800
  };
  T_ARRAY<U16> ARFCN_637_580_885_512_WITH_STD(ARFCN_637_580_885_512_WITH_STD_elements, SKIP_TO_END);
  const U8 RXLEV_637_580_885_512_elements[CHANNELS_4] = {
	  56, 44, 25, 21
  };
  T_ARRAY<U8> RXLEV_637_580_885_512(RXLEV_637_580_885_512_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_4;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_637_580_885_512_WITH_STD;
  prim->rx_lev = RXLEV_637_580_885_512;
  return prim;
}
T_PRIMITIVE_UNION mph_power_cnf_5()
{
  const U16 ARFCN_DUAL_WITH_STD_elements[CHANNELS_8] = {
	  ARFCN_23_STD_DUAL,
	  ARFCN_637_STD_DUAL,
	  ARFCN_14_STD_DUAL,
	  ARFCN_580_STD_DUAL,
	  ARFCN_124_STD_DUAL,
	  ARFCN_885_STD_DUAL,
	  ARFCN_1_STD_DUAL,
	  ARFCN_512_STD_DUAL
  };
  T_ARRAY<U16> ARFCN_DUAL_WITH_STD(ARFCN_DUAL_WITH_STD_elements, SKIP_TO_END);

  const U8 RXLEV_DUAL_elements[CHANNELS_8] = {
	  56, 55, 44, 43, 25, 23, 21, 11
  };
  T_ARRAY<U8> RXLEV_DUAL(RXLEV_DUAL_elements, SKIP_TO_END);

  T_MPH_POWER_CNF prim;
  prim->num_of_chan = CHANNELS_8;
  prim->num_of_white_list_chan = CHANNELS_0;
  prim->arfcn = ARFCN_DUAL_WITH_STD;
  prim->rx_lev = RXLEV_DUAL;
  return prim;
}

T_PRIMITIVE_UNION mph_bsic_req(U16 arfcn)
{
  T_MPH_BSIC_REQ prim;
  prim->arfcn = arfcn;
  return prim;
}

T_PRIMITIVE_UNION mphc_network_sync_req(U16 arfcn, U8 mode)
{
  T_MPHC_NETWORK_SYNC_REQ prim;
  prim->radio_freq      = arfcn;
  prim->timing_validity = TV_INVALID_TIMING_INFO;
  prim->fn_offset       ._skip;
  prim->time_alignment  ._skip;
  prim->search_mode     = mode;
  return prim;
}

T_PRIMITIVE_UNION mphc_network_sync_ind_1()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_network_sync_ind_32()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq     = ARFCN_32;
  prim->sb_flag        = SB_FOUND;
  prim->fn_offset      = FN_OFFSET_32;
  prim->time_alignment = TIME_ALIGNMT_32;
  prim->bsic           = BSIC_3;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_failed(U16 arfcn)
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq     = arfcn;
  prim->sb_flag        = NO_SB_FOUND;
  prim->fn_offset      = INVALID_PATTERN;
  prim->time_alignment = INVALID_PATTERN;
  prim->bsic           = INVALID_PATTERN;
  return prim;
}

T_PRIMITIVE_UNION mphc_network_sync_ind_6()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_7()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_8()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_9()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_14()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_15()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_16()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_network_sync_ind_17()
{
  T_MPHC_NETWORK_SYNC_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->sb_flag = SB_FOUND;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->bsic = BSIC_0;
  return prim;
}


T_PRIMITIVE_UNION mph_bsic_cnf_failed(U16 arfcn)
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = arfcn; //ARFCN_23_STD_900;
  prim->bsic  ._show; // the value is not defined, but it should not be INVALID_PATTERN
                      // but i don't know how to test this.
  prim->cs    = CS_NO_BCCH_AVAIL;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_cell32()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_32;
  prim->cs    = CS_NO_ERROR;
  prim->bsic  = BSIC_3;
  return prim;
}

T_PRIMITIVE_UNION mph_bsic_cnf_1()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_23_STD_900;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_6()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_14_STD_900;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_7()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_124_STD_900;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_8()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_1_STD_900;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_9()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn._skip;
  prim->bsic._skip;
  prim->cs = CS_NO_BCCH_AVAIL;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_10()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = CONST_1023;
  prim->bsic = CONST_12;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_14()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_14;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_15()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_124;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_16()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_1;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_17()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_637_STD_1800;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_22()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_580_STD_1800;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_23()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_885_STD_1800;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_24()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_512_STD_1800;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_25()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_23_STD_DUAL;
  prim->bsic = BSIC_1;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_33()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_637_STD_DUAL;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_34()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_14_STD_DUAL;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}
T_PRIMITIVE_UNION mph_bsic_cnf_35()
{
  T_MPH_BSIC_CNF prim;
  prim->arfcn = ARFCN_580_STD_DUAL;
  prim->bsic = BSIC_0;
  prim->cs = CS_NO_ERROR;
  return prim;
}

T_PRIMITIVE_UNION mphc_new_scell_req_1()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_23;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_2()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_3()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_124;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_4()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_5()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_637;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_6()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_580;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_7()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_885;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_8()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_512;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_9()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_637;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_10()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFF_ARFCN_14;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_12()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_1;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_2;
  return prim;
}
T_PRIMITIVE_UNION mphc_new_scell_req_13()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFFSET_224;
  prim->time_alignment = TIME_ALIGNMT_14;
  prim->tsc = BSIC_1;
  return prim;
}

T_PRIMITIVE_UNION mphc_new_scell_req_cell32()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq     = ARFCN_32;
  prim->fn_offset      = FN_OFFSET_32;
  prim->time_alignment = TIME_ALIGNMT_32;
  prim->tsc            = BSIC_3;
  return prim;
}


T_PRIMITIVE_UNION mphc_new_scell_con_1()
{
  T_MPHC_NEW_SCELL_CON prim;
  prim->param._skip;
  return prim;
}

/* BCCH */

T_PRIMITIVE_UNION mphc_data_ind_1()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_2()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_3()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_4()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4();
  prim->tc = TC_3;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_5()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_3;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_6()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_124;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_7()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_1;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_14()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_2;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_15()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_4;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_16()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_5;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_17()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_6;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_18()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_7;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_35()
{
  const U8 L2_SYS_INFO_1_NEW_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x19,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x18, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00,
	  0x00, 0x00, 0x40,
	  0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_SYS_INFO_1_NEW_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_42()
{
T_MPHC_DATA_IND prim;
prim->radio_freq = ARFCN_637;
prim->l2_channel = L2_CHANNEL_NBCCH;
prim->error_flag = VALID_BLOCK;
prim->l2_frame = l2_sys_info_1();
prim->tc = TC_0;
prim->ccch_lev._skip;
prim->fn = FN_OFFSET_0;
return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_43()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_44()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_2;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_45()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_4();
  prim->tc = TC_3;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_46()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_637;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_3;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_47()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_885;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_48()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_512;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_49()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_50()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_580;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_63()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_64()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_1();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_65()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFF_ARFCN_14;
  return prim;
}

/* PCH, CCCH */


T_PRIMITIVE_UNION mphc_data_ind_8(CHAR variant)
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame = l2_paging_req_1_ext();
  if (variant == 'B')   prim->l2_frame = l2_paging_req_1_reo();
  if (variant == 'C')   prim->l2_frame = l2_paging_req_1_sab();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_9()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_paging_req_1_ext();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_10()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_paging_req_1_reo();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_11()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_paging_req_1();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_12(CHAR variant)
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame = l2_paging_req_1();
  if (variant == 'B')   prim->l2_frame = l2_paging_req_1_sab();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_13(CHAR variant)
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame = l2_paging_req_1_ext();
  if (variant == 'B')   prim->l2_frame = l2_paging_req_1_sab();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_19()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame = l2_no_content();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_20()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_imm_ass_hop();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_21()
{
  const U8 L2_IMM_ASS_REJ_ARRAY[13] = {
 	  0x31,
	  0x06,
	  0x3F,
	  0x00,
	  0x2B, 0x54, 0x94,
	  0xFB, 0x21, 0x06,
	  0x1B,
	  0x01, 0x16
  };
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_IMM_ASS_REJ_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_22()
{
  const U8 L2_IMM_ASS_ARRAY[13] = {
 	  0x31,
	  0x06,
	  0x3F,
	  0x00,
	  0x2B, 0x54, 0x94,
	  0xFB, 0x21, 0x06,
	  0x1B,
	  0x01, 0x16
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_IMM_ASS_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_23()
{
  const U8 L2_PAG_1_EMPTY_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x21,
	  0x00,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_1_EMPTY_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_24(CHAR variant)
{
  const U8 L2_PAG_1_I1_A_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x21,
	  0x00,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54, 0x17, 0x08,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_I2_A_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x21,
	  0x00,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x23,
	  0x03, 0x95, 0x54, 0x17, 0x08,
	  0x09, 0x10, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54
  };
  const U8 L2_PAG_1_I3_A_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x21,
	  0x00,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54, 0x17, 0x07,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x08
  };
  const U8 L2_PAG_1_T1_T_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x21,
	  0x20,
	  0x05,
	  0xF4, 0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_T2_T_ARRAY[23] = {
 	  0x41,
	  0x06,
	  0x21,
	  0x80,
	  0x05,
	  0xF4, 0x06, 0x22, 0x33, 0x66,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_TX_T_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x21,
	  0x20,
	  0x05,
	  0xF4, 0xFF, 0xEE, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_I1_S_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x21,
	  0x10,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_I2_S_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x21,
	  0x40,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x23,
	  0x03, 0x95, 0x54, 0x17, 0x08,
	  0x09, 0x10, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54
  };
  const U8 L2_PAG_1_T1_D_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x21,
	  0x30,
	  0x05,
	  0xF4, 0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_T2_D_ARRAY[23] = {
 	  0x41,
	  0x06,
	  0x21,
	  0xC0,
	  0x05,
	  0xF4, 0x06, 0x22, 0x33, 0x66,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_1_I1_A_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_1_I2_A_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_1_T1_T_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_1_T2_T_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_1_I1_S_ARRAY;
  if (variant == 'F')   prim->l2_frame.content = L2_PAG_1_I2_S_ARRAY;
  if (variant == 'G')   prim->l2_frame.content = L2_PAG_1_T1_D_ARRAY;
  if (variant == 'H')   prim->l2_frame.content = L2_PAG_1_T2_D_ARRAY;
  if (variant == 'I')   prim->l2_frame.content = L2_PAG_1_I3_A_ARRAY;
  if (variant == 'J')   prim->l2_frame.content = L2_PAG_1_TX_T_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_25(CHAR variant)
{
  const U8 L2_PAG_1_WI1_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x21,
	  0x10,
	  0x08,
	  0x09, 0x12, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_WI2_ARRAY[23] = {
 	  0x59,
	  0x06,
	  0x21,
	  0x40,
	  0x08,
	  0x09, 0x10, 0x10, 0x83, 0x23,
	  0x03, 0x95, 0x54, 0x17, 0x08,
	  0x09, 0x12, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54
  };
  const U8 L2_PAG_1_WT1_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x21,
	  0x30,
	  0x05,
	  0xF4, 0x06, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_WT2_ARRAY[23] = {
 	  0x41,
	  0x06,
	  0x21,
	  0xC0,
	  0x05,
	  0xF4, 0x06, 0x22, 0x33, 0x66,
	  0x17, 0x05, 0xF4, 0x05, 0x23,
	  0x33, 0x66, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_WTYPE_ARRAY[23] = {
 	  0x31,
	  0x06,
	  0x21,
	  0x10,
	  0x08,
	  0x0B, 0x12, 0x10, 0x83, 0x32,
	  0x03, 0x95, 0x54, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_1_WI1_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_1_WT1_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_1_WI1_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_1_WT2_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_1_WTYPE_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_26(CHAR variant)
{
  const U8 L2_PAG_1_ST1_A1_ARRAY[23] = {
 	  0x19,
	  0x06,
	  0x21,
	  0x00,
	  0x02,
	  0xF4, 142, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_ST2_T3_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x21,
	  0x80,
	  0x02,
	  0xF4, 143, 0x17, 0x03, 0xF4,
	  0x00, 142, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_SI1_S_ARRAY[23] = {
 	  0x29,
	  0x06,
	  0x21,
	  0x10,
	  0x06,
	  0x01, 0x10, 0x10, 0x83, 0x32,
	  0xF3, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_SI2_D_ARRAY[23] = {
 	  0x39,
	  0x06,
	  0x21,
	  0xC0,
	  0x02,
	  0xF4, 143, 0x17, 0x06, 0x01,
	  0x10, 0x10, 0x83, 0x32, 0xF3,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_1_ST1_A2_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x21,
	  0x00,
	  0x03,
	  0xF4, 0, 142, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B
  };
  const U8 L2_PAG_1_ST2_T4_ARRAY[23] = {
 	  0x35,
	  0x06,
	  0x21,
	  0x80,
	  0x02,
	  0xF4, 143, 0x17, 0x05, 0xF4,
	  0x00, 0x00, 0x00, 142, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_1_ST1_A1_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_1_ST2_T3_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_1_SI1_S_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_1_SI2_D_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_1_ST1_A2_ARRAY;
  if (variant == 'F')   prim->l2_frame.content = L2_PAG_1_ST2_T4_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_27()
{
  const U8 L2_PAG_2_EMPTY_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x22,
	  0x00,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_2_EMPTY_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_28(CHAR variant)
{
  const U8 L2_PAG_2_T1_S_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x22,
	  0x10,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_2_T1_T_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x22,
	  0x20,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_2_T1_D_ARRAY[23] = {
 	  0x1D,
	  0x06,
	  0x22,
	  0x30,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_2_T2_A_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x22,
	  0x00,
	  0x06, 0x22, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T2_S_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x22,
	  0x40,
	  0x05, 0x23, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T2_T_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x22,
	  0x80,
	  0x05, 0x22, 0x31, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T2_D_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x22,
	  0xC0,
	  0x05, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_2_T1_A_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_2_T1_S_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_2_T1_T_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_2_T1_D_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_2_T2_A_ARRAY;
  if (variant == 'F')   prim->l2_frame.content = L2_PAG_2_T2_S_ARRAY;
  if (variant == 'G')   prim->l2_frame.content = L2_PAG_2_T2_T_ARRAY;
  if (variant == 'H')   prim->l2_frame.content = L2_PAG_2_T2_D_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_29()
{
  const U8 L2_PAG_2_WRONG_ARRAY[23] = {
 	  0x2D,
	  0x06,
	  0x22,
	  0x30,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_2_WRONG_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_30(CHAR variant)
{
  const U8 L2_PAG_2_I3_A_ARRAY[23] = {
 	  0x55,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x08, 0x09, 0x10, 0x10,
	  0x83, 0x32, 0x03, 0x95, 0x54,
	  0x8B
  };
  const U8 L2_PAG_2_I3_S_ARRAY[23] = {
 	  0x55,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x08, 0x09, 0x10, 0x10,
	  0x83, 0x32, 0x03, 0x95, 0x54,
	  0xAB
  };
  const U8 L2_PAG_2_I3_T_ARRAY[23] = {
 	  0x55,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x08, 0x09, 0x10, 0x10,
	  0x83, 0x32, 0x03, 0x95, 0x54,
	  0xCB
  };
  const U8 L2_PAG_2_I3_D_ARRAY[23] = {
 	  0x55,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x08, 0x09, 0x10, 0x10,
	  0x83, 0x32, 0x03, 0x95, 0x54,
	  0xEB
  };
  const U8 L2_PAG_2_I3_N_ARRAY[23] = {
 	  0x55,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x08, 0x09, 0x10, 0x10,
	  0x83, 0x32, 0x03, 0x95, 0x54,
	  0x2B
  };
  const U8 L2_PAG_2_T3_A_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0x8B, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T3_S_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0xAB, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T3_T_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0xCB, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T3_D_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0xEB, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_T3_N_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0x05, 0x22,
	  0x33, 0x66, 0x2B, 0x2B, 0x2B,
	  0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_2_I3_A_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_2_I3_S_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_2_I3_T_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_2_I3_D_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_2_I3_N_ARRAY;
  if (variant == 'F')   prim->l2_frame.content = L2_PAG_2_T3_A_ARRAY;
  if (variant == 'G')   prim->l2_frame.content = L2_PAG_2_T3_S_ARRAY;
  if (variant == 'H')   prim->l2_frame.content = L2_PAG_2_T3_T_ARRAY;
  if (variant == 'I')   prim->l2_frame.content = L2_PAG_2_T3_D_ARRAY;
  if (variant == 'J')   prim->l2_frame.content = L2_PAG_2_T3_N_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_31(CHAR variant)
{
  const U8 L2_PAG_2_SI3_A_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x06, 0x01, 0x10, 0x10,
	  0x83, 0x32, 0xF3, 0x8B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_ST3_S_ARRAY[23] = {
 	  0x3D,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x02, 0xF4, 142, 0xAB,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B
  };
  const U8 L2_PAG_2_ST3_T_ARRAY[23] = {
 	  0x41,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x03, 0xF4, 0, 142, 0xCB,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_2_ST3_D_ARRAY[23] = {
 	  0x45,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x04, 0xF4, 0,0,142, 0xEB,
	  0x2B, 0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_2_ST3_N_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x22,
	  0x00,
	  0x01, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x17, 0x05, 0xF4, 0, 0,0,142, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_2_SI3_A_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_2_ST3_S_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_2_ST3_T_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_2_ST3_D_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_2_ST3_N_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_32()
{
  const U8 L2_PAG_3_EMPTY_ARRAY[23] = {
 	  0x11,
	  0x06,
	  0x24,
	  0x00,
	  0x00,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_3_EMPTY_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_33(CHAR variant)
{
  const U8 L2_PAG_3_T1_A_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x05, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T1_S_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x10,
	  0x05, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T1_T_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x20,
	  0x05, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T1_D_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x30,
	  0x05, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T2_A_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T2_S_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x40,
	  0x04, 0x22, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T2_T_ARRAY[23] = {
	  0x4D,
	  0x06,
	  0x24,
	  0x80,
	  0x04, 0x22, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T2_D_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0xC0,
	  0x04, 0x22, 0x33, 0x66,
	  0x05, 0x22, 0x33, 0x66,
	  0x03, 0x22, 0x33, 0x65,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T3_A_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x02, 0x22, 0x33, 0x65,
	  0x83, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T3_S_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x02, 0x22, 0x33, 0x65,
	  0xA3, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T3_T_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x02, 0x22, 0x33, 0x65,
	  0xC3, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T3_D_ARRAY[23] = {
	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x02, 0x22, 0x33, 0x65,
	  0xE3, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T3_N_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x10,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x05, 0x22, 0x33, 0x66,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T4_A_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x05, 0x22, 0x33, 0x66,
	  0xA3, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T4_S_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x05, 0x22, 0x33, 0x66,
	  0x8B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T4_T_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x05, 0x22, 0x33, 0x66,
	  0x93, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T4_D_ARRAY[23] = {
	  0x4D,
	  0x06,
	  0x24,
	  0x00,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x05, 0x22, 0x33, 0x66,
	  0x9B, 0x2B, 0x2B
  };
  const U8 L2_PAG_3_T4_N_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x50,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x05, 0x22, 0x33, 0x66,
	  0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A')   prim->l2_frame.content = L2_PAG_3_T1_A_ARRAY;
  if (variant == 'B')   prim->l2_frame.content = L2_PAG_3_T1_S_ARRAY;
  if (variant == 'C')   prim->l2_frame.content = L2_PAG_3_T1_T_ARRAY;
  if (variant == 'D')   prim->l2_frame.content = L2_PAG_3_T1_D_ARRAY;
  if (variant == 'E')   prim->l2_frame.content = L2_PAG_3_T2_A_ARRAY;
  if (variant == 'F')   prim->l2_frame.content = L2_PAG_3_T2_S_ARRAY;
  if (variant == 'G')   prim->l2_frame.content = L2_PAG_3_T2_T_ARRAY;
  if (variant == 'H')   prim->l2_frame.content = L2_PAG_3_T2_D_ARRAY;
  if (variant == 'I')   prim->l2_frame.content = L2_PAG_3_T3_A_ARRAY;
  if (variant == 'J')   prim->l2_frame.content = L2_PAG_3_T3_S_ARRAY;
  if (variant == 'K')   prim->l2_frame.content = L2_PAG_3_T3_T_ARRAY;
  if (variant == 'L')   prim->l2_frame.content = L2_PAG_3_T3_D_ARRAY;
  if (variant == 'M')   prim->l2_frame.content = L2_PAG_3_T3_N_ARRAY;
  if (variant == 'N')   prim->l2_frame.content = L2_PAG_3_T4_A_ARRAY;
  if (variant == 'O')   prim->l2_frame.content = L2_PAG_3_T4_S_ARRAY;
  if (variant == 'P')   prim->l2_frame.content = L2_PAG_3_T4_T_ARRAY;
  if (variant == 'Q')   prim->l2_frame.content = L2_PAG_3_T4_D_ARRAY;
  if (variant == 'R')   prim->l2_frame.content = L2_PAG_3_T4_N_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_34()
{
  const U8 L2_PAG_3_WRONG_ARRAY[23] = {
 	  0x4D,
	  0x06,
	  0x24,
	  0x50,
	  0x04, 0x22, 0x33, 0x66,
	  0x04, 0x22, 0x33, 0x65,
	  0x04, 0x22, 0x33, 0x67,
	  0x02, 0x22, 0x33, 0x65,
	  0x2B, 0x2B, 0x2B
  };
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_3_WRONG_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_36()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_CCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_imm_ass_hop();
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_51()
{
  const U8 L2_IMM_ASS_EXT_REO_ARRAY[23] = {
 	  0x49,
	  0x06,
	  0x39,
	  0x02,
	  0x20, 0xA0, 0x14,
	  0x00, 0x00, 0x00,
	  0x00,
	  0x20, 0xA0, 0x14,
	  0x00, 0x00, 0x00,
	  0x00,
	  0x00,
	  0x2b,0x2b,0x2b,0x2b
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_IMM_ASS_EXT_REO_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_52()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_PCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_PAG_2_T1_A_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

/* SACCH  */
T_PRIMITIVE_UNION mphc_data_ind_37()
{
  const U8 L2_SYS_INFO_5_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x03, 0x03, 0x01,
	  0x06,
	  0x1D,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_SYS_INFO_5_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_sacch_error()
{
  const U8 L2_SYS_INFO_5_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x03, 0x03, 0x01,
	  0x06,
	  0x1D,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame.content = L2_SYS_INFO_5_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_38()
{
  const U8 L2_SYS_INFO_5BIS_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x03, 0x03, 0x01,
	  0x06,
	  0x05,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_SYS_INFO_5BIS_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_39()
{
  const U8 L2_SYS_INFO_6_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x03, 0x03, 0x01,
	  0x06,
	  0x1E,
	  0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_SYS_INFO_6_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_40()
{
  const U8 L2_I_SMS_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x0F,
	  0x02,
	  0x19,
	  0x3A, 0x3B, 0x3C, 0x3D, 0x3E, 0x3F,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B, 0x2B
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_I_SMS_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_41()
{
  const U8 L2_CHANGED_SYS_INFO_6_ARRAY[23] = {
 	  0xFF, 0xAA,
	  0x03, 0x03, 0x01,
	  0x06,
	  0x1E,
	  0x01, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x01,
	  0x00, 0x08, 0x00, 0x00, 0x81, 0x00, 0x00, 0x00
  };

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_14;
  prim->l2_channel = L2_CHANNEL_SACCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = L2_CHANGED_SYS_INFO_6_ARRAY;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}


/* UNITDATA BCCH */
T_PRIMITIVE_UNION mph_unitdata_ind_si1(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = arfcn;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl          = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si1_chg(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = arfcn;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1_new();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl          = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si2(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit          = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl           = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_si3(U16 arfcn, U16 cell_id)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident     = cell_id;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch  = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select    = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl      = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si7(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_7.si7_rest_oct = si7_rest_oct_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si4(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select    = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl      = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si4_diff_cs(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select    = cell_select_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl      = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_si8(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_8.si8_rest_oct = si8_rest_oct_1();
  return prim;
}

#if 0
T_PRIMITIVE_UNION mph_unitdata_ind_1()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_5()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_6()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_12()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1_new();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_20()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_637;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_24()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_885;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_25()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_512;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_38()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn = FN_OFFSET_0;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
_PRIMITIVE_UNION mph_unitdata_ind_26()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_27()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_580;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.cell_chan_desc.raw = cell_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_1.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_2()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_13()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_14()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_21()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_637;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_39()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn = FN_OFFSET_0;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.neigh_cell_desc.raw = neigh_cell_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.ncc_permit = NCC_PERMIT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2.rach_ctrl = rach_ctrl_1();
  return prim;
}


T_PRIMITIVE_UNION mph_unitdata_ind_3()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}


T_PRIMITIVE_UNION mph_unitdata_ind_7()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_8()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_9()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_22()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_637;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_28()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_25;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_29()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_512;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_30()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_580;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_31()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_885;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_32()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_11;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_33()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_87;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_34()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_513;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_35()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_600;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_36()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_700;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_37()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_810;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_54()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn = FN_OFFSET_224;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_55()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn = FN_OFFSET_224;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_56()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn = FN_OFFSET_114;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_57()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_58()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_25;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_59()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_512;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_60()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_580;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_61()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_637;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_62()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_885;
  prim->fn = FN_OFF_ARFCN_14;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_ident = CELL_IDENT_1;
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.ctrl_chan_desc = ctrl_chan_desc_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_opt_bcch = cell_opt_bcch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_3.rach_ctrl = rach_ctrl_1();
  return prim;
}




T_PRIMITIVE_UNION mph_unitdata_ind_4()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_23()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_637;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_40()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_41()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_42()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_43()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}


T_PRIMITIVE_UNION mph_unitdata_ind_45()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_47()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.loc_area_ident = loc_area_ident_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.cell_select = cell_select_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_4.rach_ctrl = rach_ctrl_1();
  return prim;
}


T_PRIMITIVE_UNION mph_unitdata_ind_49()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_1;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_8.si8_rest_oct = si8_rest_oct_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_50()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_8.si8_rest_oct = si8_rest_oct_1();
  return prim;
}

T_PRIMITIVE_UNION mph_unitdata_ind_51()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_124;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_8.si8_rest_oct = si8_rest_oct_1();
  return prim;
}
#endif
/* UNITDATA PCH,CCCH */
T_PRIMITIVE_UNION mph_unitdata_ind_10()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.tma = TMA_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.dl = DL_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.d_t = D_T_DED;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.page_mode = page_mode_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc = chan_desc_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.pck_chan_desc._skip;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.req_ref = req_ref_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.time_advance = time_advance_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.mob_alloc = mob_alloc_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_11()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_23;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.tma = TMA_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.dl = DL_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.d_t = D_T_DED;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.page_mode = page_mode_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.chan_type= SDCCH_4_S1; //chan_desc_2();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.tn=3;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.tsc=2;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.hop=HOP_YES;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.arfcn._skip;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.maio=18;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc.hsn=20;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.pck_chan_desc._skip;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.req_ref = req_ref_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.time_advance.ta = 0x1B;//time_advance_2();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.mob_alloc = mob_alloc_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_15()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.tma = TMA_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.dl = DL_0;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.d_t = D_T_DED;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.page_mode = page_mode_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.chan_desc = chan_desc_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.pck_chan_desc._skip;
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.req_ref = req_ref_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.time_advance = time_advance_1();
  prim->sdu.aim.entity.RR->D_IMM_ASSIGN.mob_alloc = mob_alloc_1();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_16()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_5.neigh_cell_desc.raw = neigh_cell_desc_2();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_17()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_5BIS.neigh_cell_desc.raw = neigh_cell_desc_2();
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_18()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.cell_ident = CELL_IDENT_2;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.loc_area_ident = loc_area_ident_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.cell_opt_sacch = cell_opt_sacch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.ncc_permit = NCC_PERMIT_2;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.si6_rest_oct._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_unitdata_ind_19()
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn = ARFCN_14;
  prim->fn._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.cell_ident = CELL_IDENT_3;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.loc_area_ident = loc_area_ident_2();
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.cell_opt_sacch = cell_opt_sacch_1();
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.ncc_permit = NCC_PERMIT_2;
  prim->sdu.aim.entity.RR->D_SYS_INFO_6.si6_rest_oct._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_error_ind_1()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_BCCH_READ_ERROR;
  prim->arfcn = ARFCN_23;
  return prim;
}

T_PRIMITIVE_UNION mph_error_ind_radio_link_fail()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_RADIO_LINK_FAIL;
  prim->arfcn = ARFCN_14;
  return prim;
}

T_PRIMITIVE_UNION mph_error_ind_2()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_DOWN_LINK_FAIL;
  prim->arfcn = ARFCN_23;
  return prim;
}

T_PRIMITIVE_UNION mph_error_ind_3()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_BCCH_READ_ERROR;
  prim->arfcn = ARFCN_14;
  return prim;
}
T_PRIMITIVE_UNION mph_error_ind_4()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_BCCH_READ_ERROR;
  prim->arfcn = ARFCN_637;
  return prim;
}

T_PRIMITIVE_UNION mph_error_ind_5()
{
  T_MPH_ERROR_IND prim;
  prim->cs = CS_NC_SYNC_FAILED;
  prim->arfcn = ARFCN_14;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_scell_bcch_req()
{
  T_MPHC_STOP_SCELL_BCCH_REQ prim;
  prim->param._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_stop_scell_bcch_con()
{
  T_MPHC_STOP_SCELL_BCCH_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_classmark_req_1()
{
  T_MPH_CLASSMARK_REQ prim;
  prim->classmark.pclass  = 4;
  prim->classmark.pclass2 = 0;
  return prim;
}
T_PRIMITIVE_UNION mph_classmark_req_2()
{
  T_MPH_CLASSMARK_REQ prim;
  prim->classmark.pclass2=CLASS_1;
  prim->classmark.pclass=CLASS_1;
  return prim;
}
T_PRIMITIVE_UNION mph_classmark_req_3()
{
  T_MPH_CLASSMARK_REQ prim;
  prim->classmark.pclass = CLASS_4;
  prim->classmark.pclass2 = CLASS_2; //class_dual();
  return prim;
}

T_PRIMITIVE_UNION mph_idle_req_1(CHAR variant)
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  if (variant == 'A')   prim->comb_ccch = COMB_CCCH_COMB;
  if (variant == 'B')   prim->comb_ccch = COMB_CCCH_COMB;
  if (variant == 'C')   prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_2()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_3(CHAR variant)
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_COMB;
  if (variant == 'A')   prim->tn = TN_0;
  if (variant == 'B')   prim->tn = TN_4;
  prim->dlt = DLT_24;
  prim->pg = PG_23;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_2;
  prim->bs_pa_mfrms = BS_PA_MFRMS_5;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_4(CHAR variant)
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_24;
  prim->pg = PG_11;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_2;
  if (variant == 'A')   prim->bs_pa_mfrms = BS_PA_MFRMS_0;
  if (variant == 'B')   prim->bs_pa_mfrms = BS_PA_MFRMS_1;
  if (variant == 'C')   prim->bs_pa_mfrms = BS_PA_MFRMS_2;
  if (variant == 'D')   prim->bs_pa_mfrms = BS_PA_MFRMS_3;
  if (variant == 'E')   prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  if (variant == 'F')   prim->bs_pa_mfrms = BS_PA_MFRMS_5;
  if (variant == 'G')   prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  if (variant == 'H')   prim->bs_pa_mfrms = BS_PA_MFRMS_7;

  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
#ifdef FF_EGPRS
  prim->si2quater_status = SI2QUATER_ABSENT;
  prim->si2quater_pos = SI2QUATER_ON_NBCCH;
#endif  // FF_EGPRS
  if (variant == 'I')   {
    prim->bs_pa_mfrms = BS_PA_MFRMS_7;
#ifdef FF_EGPRS
    prim->si2quater_status = SI2QUATER_CONFIGURE;
    prim->si2quater_pos = SI2QUATER_ON_EBCCH;
#endif  // FF_EGPRS
    prim->gprs_support = MPH_GPRS_PROCS_NOT_USED;
  }
  if (variant == 'J')   {
    prim->bs_pa_mfrms = BS_PA_MFRMS_7;
#ifdef FF_EGPRS
    prim->si2quater_status = SI2QUATER_CONFIGURE;
    prim->si2quater_pos = SI2QUATER_ON_NBCCH;
#endif  // FF_EGPRS
    prim->gprs_support = MPH_GPRS_PROCS_NOT_USED;
  }
  if (variant == 'K')   {
    prim->bs_pa_mfrms = BS_PA_MFRMS_7;
#ifdef FF_EGPRS
    prim->si2quater_status = SI2QUATER_CONFIGURE;
    prim->si2quater_pos = SI2QUATER_ON_EBCCH;
#endif  // FF_EGPRS
    prim->gprs_support = MPH_GPRS_PROCS_USED;
  }
  return prim;
}

T_PRIMITIVE_UNION mph_idle_req_resel()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_24;
  prim->pg = PG_11;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_2;
  prim->bs_pa_mfrms = BS_PA_MFRMS_0;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_idle_req_cell_sel()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_24;
  prim->pg = PG_11;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_2;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}


T_PRIMITIVE_UNION mph_idle_req_5(CHAR variant)
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  if (variant == 'E')
    prim->mod = MODE_CELL_RESELECTION;
  else  // variant 'A' .. 'D'
    prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  if (variant == 'E')
    prim->ext_bcch = BSIC_16;  // just for stressing the entity with a wrong value
  else  // variant 'A' .. 'D'
    prim->ext_bcch = BSIC_1;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  if (variant == 'A')   prim->ncc_permitted = NOT_PRESENT_8BIT;
  if (variant == 'B')   prim->ncc_permitted = NOT_PRESENT_8BIT;
  if (variant == 'C')   prim->ncc_permitted = NOT_PRESENT_8BIT;
  if (variant == 'D')   prim->ncc_permitted = NCC_PERMITTED_4;
  if (variant == 'E')   prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_6()
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_7(CHAR variant)
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_580;
  prim->ext_bcch._skip;
  if (variant == 'A')   prim->comb_ccch = COMB_CCCH_COMB;
  if (variant == 'B')   prim->comb_ccch = COMB_CCCH_COMB;
  if (variant == 'C')   prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_8()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_637;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_9()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_637;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_10()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_11()
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_12()
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  prim->arfcn = ARFCN_578;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_13()
{
  T_MPH_IDLE_REQ prim;
  prim->mod._skip;
  prim->arfcn = ARFCN_637;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_14()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_15()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_15g()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support = MPH_GPRS_PROCS_USED;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_16()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_1;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_5;
  prim->bs_pa_mfrms = BS_PA_MFRMS_2;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_17()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_20()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_1;
  prim->ext_bcch = NORMAL_PGM;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_21()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch = NORMAL_PGM;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_22()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_SELECTION;
  prim->arfcn = ARFCN_23;
  prim->ext_bcch = NORMAL_PGM;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_PRES;
  prim->gprs_support._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_idle_req_23()
{
  T_MPH_IDLE_REQ prim;
  prim->mod = MODE_CELL_RESELECTION;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_PRES;
  prim->gprs_support._skip;
  return prim;
}


T_PRIMITIVE_UNION mphc_start_ccch_req_1(CHAR variant)
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  if (variant == 'A')   prim->bcch_combined = COMB_CCCH_COMB;
  if (variant == 'B')   prim->bcch_combined = COMB_CCCH_COMB;
  if (variant == 'C')   prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  if (variant == 'A')   prim->page_block_index = PBI_0;
  if (variant == 'B')   prim->page_block_index = PBI_0;
  if (variant == 'C')   prim->page_block_index = PBI_2;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_2()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_3(CHAR variant)
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_COMB;
  if (variant == 'A')   prim->ccch_group = CCCH_GROUP_0;
  if (variant == 'B')   prim->ccch_group = CCCH_GROUP_2;
  prim->page_group = PG_23;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_4()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_2;
  prim->page_group = PG_23;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_EXTENDED;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req(U8 bs_pa_mfrms, U8 bs_ag_blks_res, U8 bcch_combined, U8 ccch_group, U8 page_group, U8 page_block_index, U8 page_mode )
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms      = bs_pa_mfrms     ;
  prim->bs_ag_blks_res   = bs_ag_blks_res  ;
  prim->bcch_combined    = bcch_combined   ;
  prim->ccch_group       = ccch_group      ;
  prim->page_group       = page_group      ;
  prim->page_block_index = page_block_index;
  prim->page_mode        = page_mode       ;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_4_reorg()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_2;
  prim->page_group = PG_23;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_REORG;
  return prim;
}

T_PRIMITIVE_UNION mphc_start_ccch_req_5()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_2;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_7;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_0;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_REORG;
  return prim;
}


T_PRIMITIVE_UNION mphc_start_ccch_req_6()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_2;
  prim->page_group = PG_23;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_NORMAL;
  return prim;
}

T_PRIMITIVE_UNION mphc_start_ccch_req_6_reorg()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_2;
  prim->page_group = PG_23;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_REORG;
  return prim;
}

T_PRIMITIVE_UNION mphc_start_ccch_req_7(CHAR variant)
{
  T_MPHC_START_CCCH_REQ prim;
  if (variant == 'A')   prim->bs_pa_mfrms = BS_PA_MFRMS_2;
  if (variant == 'B')   prim->bs_pa_mfrms = BS_PA_MFRMS_3;
  if (variant == 'C')   prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  if (variant == 'D')   prim->bs_pa_mfrms = BS_PA_MFRMS_5;
  if (variant == 'E')   prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  if (variant == 'F')   prim->bs_pa_mfrms = BS_PA_MFRMS_7;
  if (variant == 'G')   prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  if (variant == 'H')   prim->bs_pa_mfrms = BS_PA_MFRMS_9;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_2;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_11;
  prim->page_block_index = PBI_4;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_8()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  prim->bcch_combined = COMB_CCCH_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  prim->page_block_index = PBI_0;
  prim->page_mode = PGM_NORMAL;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_9()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  prim->page_block_index = PBI_2;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_10()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  prim->page_block_index = PBI_2;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_11(CHAR variant)
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_8;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_3;
  if (variant == 'A')   prim->bcch_combined = COMB_CCCH_COMB;
  if (variant == 'B')   prim->bcch_combined = COMB_CCCH_COMB;
  if (variant == 'C')   prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_20;
  if (variant == 'A')   prim->page_block_index = PBI_0;
  if (variant == 'B')   prim->page_block_index = PBI_0;
  if (variant == 'C')   prim->page_block_index = PBI_2;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_12()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_5;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_1;
  prim->page_block_index = PBI_1;
  prim->page_mode = PGM_REORG;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_13()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms = BS_PA_MFRMS_4;
  prim->bs_ag_blks_res = BS_AG_BLKS_RES_5;
  prim->bcch_combined = COMB_CCCH_NOT_COMB;
  prim->ccch_group = CCCH_GROUP_0;
  prim->page_group = PG_1;
  prim->page_block_index = PBI_1;
  prim->page_mode = PGM_NORMAL;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_14()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms._skip;
  prim->bs_ag_blks_res._skip;
  prim->bcch_combined._skip;
  prim->ccch_group._skip;
  prim->page_group._skip;
  prim->page_block_index._skip;
  prim->page_mode._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_start_ccch_req_normal()
{
  T_MPHC_START_CCCH_REQ prim;
  prim->bs_pa_mfrms._show;      /* = BS_PA_MFRMS_9;*/
  prim->bs_ag_blks_res._show;   /* = BS_AG_BLKS_RES_2;*/
  prim->bcch_combined._show;    /* = COMB_CCCH_NOT_COMB;*/
  prim->ccch_group._show;       /* = CCCH_GROUP_0;*/
  prim->page_group._show;       /* = PG_11;*/
  prim->page_block_index._show; /* = PBI_4;*/
  prim->page_mode = PGM_NORMAL;
  return prim;
}
T_PRIMITIVE_UNION mph_identity_req_1()
{
  const U8 IMSI[15] = {
    0,0,1,0,1,3,8,2,3,3,0,5,9,4,5
  };

  T_MPH_IDENTITY_REQ prim;
  prim->mid.len_imsi = 15;
  prim->mid.imsi = IMSI;
  prim->mid.v_tmsi = 1;
  prim->mid.tmsi = 0x05223366L;
  prim->mid.v_ptmsi._skip;
  prim->mid.ptmsi._skip;
  return prim;
}
T_PRIMITIVE_UNION mph_identity_req_2()
{
  const U8 IMSI2[15] = {
    0,0,1,0,1,3,8,2,3,3,0xF,0xF,0xF,0xF,0xF
  };

  T_MPH_IDENTITY_REQ prim;
  prim->mid.len_imsi = 10;
  prim->mid.imsi     = IMSI2;
  prim->mid.v_tmsi   = 1;
  prim->mid.tmsi     = 142;
  prim->mid.v_ptmsi  ._skip;
  prim->mid.ptmsi    ._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_sync_req(U8 cs)
{
  T_MPH_SYNC_REQ prim;
  prim->cs = cs;
  return prim;
}

T_PRIMITIVE_UNION em_l1_event_req_1()
{
  T_EM_L1_EVENT_REQ prim;
  prim->bitmask_l1_h = Bitm_H;
  prim->bitmask_l1_l = Bitm_L;
  return prim;
}
T_PRIMITIVE_UNION em_l1_event_req_2()
{
  T_EM_L1_EVENT_REQ prim;
  prim->bitmask_l1_h = 0xFFFFFFFF;
  prim->bitmask_l1_l = 0xFFFFFFFF;
  return prim;
}

T_PRIMITIVE_UNION em_data_ind_1()
{
  T_EM_DATA_IND prim;
  prim->entity = ENTITY;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_network_sync_req_1()
{
  T_MPHC_STOP_NETWORK_SYNC_REQ prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_network_sync_con_1()
{
  T_MPHC_STOP_NETWORK_SYNC_CON prim;
  prim->param._skip;
  return prim;
}


T_PRIMITIVE_UNION mphc_scell_nbcch_req_full()
{
  T_MPHC_SCELL_NBCCH_REQ prim;
  prim->schedule_array_size = SCHED_SIZE_1;
  prim->schedule_array[0].modulus           = 1;
  prim->schedule_array[0].relative_position = 0;
  prim->schedule_array[1].modulus._skip;
  prim->schedule_array[1].relative_position._skip;
  prim->schedule_array[2].modulus._skip;
  prim->schedule_array[2].relative_position._skip;
  prim->schedule_array[3].modulus._skip;
  prim->schedule_array[3].relative_position._skip;
  prim->schedule_array[4].modulus._skip;
  prim->schedule_array[4].relative_position._skip;
  prim->schedule_array[5].modulus._skip;
  prim->schedule_array[5].relative_position._skip;
  prim->schedule_array[6].modulus._skip;
  prim->schedule_array[6].relative_position._skip;
  prim->schedule_array[7].modulus._skip;
  prim->schedule_array[7].relative_position._skip;
  prim->schedule_array[8].modulus._skip;
  prim->schedule_array[8].relative_position._skip;
  prim->schedule_array[9].modulus._skip;
  prim->schedule_array[9].relative_position._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_scell_nbcch_req_periodic()
{
  T_MPHC_SCELL_NBCCH_REQ prim;
  prim->schedule_array_size = PERIODIC_SCELL_BCCH_ARRAY_SIZE;
  prim->schedule_array[0].modulus           = 128;
  prim->schedule_array[0].relative_position = 0;
  prim->schedule_array[1].modulus           = 128;
  prim->schedule_array[1].relative_position = 1;
  prim->schedule_array[2].modulus           = 128;
  prim->schedule_array[2].relative_position = 2;
  prim->schedule_array[3].modulus           = 128;
  prim->schedule_array[3].relative_position = 3;
  prim->schedule_array[4].modulus           = 128;
  prim->schedule_array[4].relative_position = 4;
  prim->schedule_array[5].modulus           = 128;
  prim->schedule_array[5].relative_position = 5;
  prim->schedule_array[6].modulus           = 128;
  prim->schedule_array[6].relative_position = 6;
  prim->schedule_array[7].modulus           = 128;
  prim->schedule_array[7].relative_position = 7;
  prim->schedule_array[8].modulus           ._skip;
  prim->schedule_array[8].relative_position ._skip;
  prim->schedule_array[9].modulus           ._skip;
  prim->schedule_array[9].relative_position ._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ccch_req()
{
  T_MPHC_STOP_CCCH_REQ prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_sync_req_1()
{
  T_MPHC_STOP_NCELL_SYNC_REQ prim;
  prim->radio_freq_array_size = 12;
  prim->radio_freq_array._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ncell_bcch_req_1     ()
{
  T_MPHC_STOP_NCELL_BCCH_REQ prim;
  prim->radio_freq_array_size = 6;

  int i=0;
  prim->radio_freq_array[i] = 0;
  i++;

  for(;i<MAX_NCELL;i++) {
    prim->radio_freq_array[i] = 0;
  }
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_rxlev_periodic_req()
{
  T_MPHC_STOP_RXLEV_PERIODIC_REQ prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_random_access_req_1()
{
  const U8 BURST_DELTA[8] = {
 	  5,7,0,0,0,0,0,0
  };
#if defined FF_EGPRS
  const U16 BURST_RACH[8] = {
	  CHANNEL_REQUEST_1,CHANNEL_REQUEST_2,0,0,0,0,0,0
  };
  const U8 BURST_TS[8] = {
	  0xA0,0xA3,0,0,0,0,0,0
  };
#else
  const U8 BURST_RACH[8] = {
	  CHANNEL_REQUEST_GO_1,CHANNEL_REQUEST_GO_1,0,0,0,0,0,0
  };
#endif
  T_MPH_RANDOM_ACCESS_REQ prim;
  prim->send_mode.c     ._skip;
  prim->send_mode.no    = RAND_BURSTS_2;
  prim->send_mode.delta = BURST_DELTA;
  prim->send_mode.rach  = BURST_RACH;
#if defined FF_EGPRS
  prim->send_mode.train_seq = BURST_TS;
#endif

  return prim;
}
T_PRIMITIVE_UNION mph_random_access_req_2()
{
  T_MPH_RANDOM_ACCESS_REQ prim;
  prim->send_mode.c._skip;
  prim->send_mode.no._skip;
  prim->send_mode.delta._skip;
  prim->send_mode.rach._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_ra_req_1()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_1;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_1;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm = POWER_CLASS_5;
  prim->powerclass_dcs._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ra_req_2()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_2;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_2;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm = POWER_CLASS_5;
  prim->powerclass_dcs._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ra_req_3()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_1;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_1;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm._skip;
  prim->powerclass_dcs._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ra_req_4()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_2;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_2;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm._skip;
  prim->powerclass_dcs._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_ra_req_5()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_1;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_1;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm = POWER_CLASS_4;
  prim->powerclass_dcs = POW_CLASS_2;
  return prim;
}

T_PRIMITIVE_UNION mphc_ra_req_6()
{
  T_MPHC_RA_REQ prim;
  prim->txpwr = POWER_12;
  prim->rand = RAND_BURST_2;
#if defined FF_EGPRS
  prim->channel_request = CHANNEL_REQUEST_2;
#else
  prim->channel_request = CHANNEL_REQUEST_GO_1;
#endif
  prim->powerclass_gsm = POWER_CLASS_4;
  prim->powerclass_dcs = POW_CLASS_2;
  return prim;
}

T_PRIMITIVE_UNION mphc_ra_con_1()
{
  T_MPHC_RA_CON prim;
  prim->fn = FN_BURST_1;
  prim->channel_request = CHANNEL_REQUEST_1;
  return prim;
}

T_PRIMITIVE_UNION mph_random_access_cnf_1()
{
  T_MPH_RANDOM_ACCESS_CNF prim;
  prim->frame_no.t1 = 14;
  prim->frame_no.t2 = 22;
  prim->frame_no.t3 = 30;
  return prim;
}

T_PRIMITIVE_UNION mphc_stop_ra_req_1()
{
  T_MPHC_STOP_RA_REQ prim;
  prim->param._skip;
  return prim;
}



T_PRIMITIVE_UNION mph_ext_meas_req_1()
{
  const U16 ARFCN_EXT_MEAS_000_elements[] = {
	  CONST_20,
	  CONST_0,
	  CONST_974,
	  CONST_10,
	  CONST_1,
	  CONST_1023,
	  CONST_124,
	  CONST_1022,
	  CONST_123,
	  CONST_975
  };
  T_ARRAY<U16> ARFCN_EXT_MEAS_000(ARFCN_EXT_MEAS_000_elements, SKIP_TO_END);

  T_MPH_EXT_MEAS_REQ prim;
  prim->pch_interrupt = NO_PCH_INTERRUPT;
  prim->freq_bands = BAND_E_GSM;
  prim->num_of_chan = CHANNELS_4;
  prim->arfcn = ARFCN_EXT_MEAS_000;
  return prim;
}



T_PRIMITIVE_UNION mph_ext_meas_cnf_1()
{
  const U16 ARFCN_EXT_MEAS_SORT_000_elements[] = {
	  (CONST_1023|0x1000),
	  (CONST_1022|0x1000),
	  (CONST_0|0x1000),
	  (CONST_974|0x1000),
	  (CONST_124|0x1000),
	  (CONST_123|0x1000),
	  (CONST_20|0x1000),
	  (CONST_10|0x1000),
	  (CONST_1|0x1000),
	  (CONST_975|0x1000)
  };
  T_ARRAY<U16> ARFCN_EXT_MEAS_SORT_000(ARFCN_EXT_MEAS_SORT_000_elements, SKIP_TO_END);

  const U8 RXLEV_EXT_MEAS_000_elements[] = {
	  80,70,60,50,40,30,20,10,0,-10
  };
  T_ARRAY<U8> RXLEV_EXT_MEAS_000(RXLEV_EXT_MEAS_000_elements, SKIP_TO_END);

  T_MPH_EXT_MEAS_CNF prim;
  prim->num_of_chan = CHANNELS_10;
  prim->arfcn = ARFCN_EXT_MEAS_SORT_000;
  prim->rx_lev = RXLEV_EXT_MEAS_000;
  return prim;
}






T_PRIMITIVE_UNION mph_sync_ind_1()
{
  T_MPH_SYNC_IND prim;
  prim->cs = CS_STOP_PLMN_SEARCH;
  prim->arfcn._skip;
  return prim;
}



T_PRIMITIVE_UNION mph_paging_ind_1(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  if (variant == 'A')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'B')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'C')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'D')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'E')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'F')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'G')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'H')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'I')    prim->identity_type = ID_TYPE_IMSI;

  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'C')   prim->channel_needed = CN_TCH_F;
  if (variant == 'D')   prim->channel_needed = CN_TCH_F;
  if (variant == 'E')   prim->channel_needed = CN_SDCCH;
  if (variant == 'F')   prim->channel_needed = CN_SDCCH;
  if (variant == 'G')   prim->channel_needed = CN_TCH;
  if (variant == 'H')   prim->channel_needed = CN_TCH;
#if defined GPRS
  if (variant == 'I')   prim->channel_needed = CN_PACKET;
#else
  if (variant == 'I')   prim->channel_needed = CN_ANY_CHAN;
#endif
  return prim;
}




T_PRIMITIVE_UNION mph_paging_ind_2(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  if (variant == 'A')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'B')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'C')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'D')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'E')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'F')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_TCH_F;
  if (variant == 'C')   prim->channel_needed = CN_SDCCH;
  if (variant == 'D')   prim->channel_needed = CN_TCH;
  if (variant == 'E')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'F')   prim->channel_needed = CN_TCH_F;
  return prim;
}


T_PRIMITIVE_UNION mph_paging_ind_3(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_SDCCH;
  if (variant == 'C')   prim->channel_needed = CN_TCH_F;
  if (variant == 'D')   prim->channel_needed = CN_TCH;
  if (variant == 'E')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'F')   prim->channel_needed = CN_SDCCH;
  if (variant == 'G')   prim->channel_needed = CN_TCH_F;
  if (variant == 'H')   prim->channel_needed = CN_TCH;
  return prim;
}


T_PRIMITIVE_UNION mph_paging_ind_4(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  if (variant == 'A')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'B')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'C')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'D')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'E')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'F')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'G')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'H')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'I')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'J')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_SDCCH;
  if (variant == 'C')   prim->channel_needed = CN_TCH_F;
  if (variant == 'D')   prim->channel_needed = CN_TCH;
  if (variant == 'E')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'F')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'G')   prim->channel_needed = CN_SDCCH;
  if (variant == 'H')   prim->channel_needed = CN_TCH_F;
  if (variant == 'I')   prim->channel_needed = CN_TCH;
  if (variant == 'J')   prim->channel_needed = CN_ANY_CHAN;
  return prim;
}


T_PRIMITIVE_UNION mph_paging_ind_5(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  if (variant == 'A')   prim->identity_type = ID_TYPE_IMSI;
  if (variant == 'B')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'C')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'D')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'E')   prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_SDCCH;
  if (variant == 'C')   prim->channel_needed = CN_TCH_F;
  if (variant == 'D')   prim->channel_needed = CN_TCH;
  if (variant == 'E')   prim->channel_needed = CN_ANY_CHAN;
  return prim;
}


T_PRIMITIVE_UNION mph_paging_ind_6(CHAR variant)
{
  T_MPH_PAGING_IND prim;
  prim->identity_type = ID_TYPE_TMSI;
  if (variant == 'A')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'B')   prim->channel_needed = CN_SDCCH;
  if (variant == 'C')   prim->channel_needed = CN_TCH_F;
  if (variant == 'D')   prim->channel_needed = CN_TCH;
  if (variant == 'E')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'F')   prim->channel_needed = CN_SDCCH;
  if (variant == 'G')   prim->channel_needed = CN_TCH_F;
  if (variant == 'H')   prim->channel_needed = CN_TCH;
  if (variant == 'I')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'J')   prim->channel_needed = CN_SDCCH;
  if (variant == 'K')   prim->channel_needed = CN_TCH_F;
  if (variant == 'L')   prim->channel_needed = CN_TCH;
  if (variant == 'M')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'N')   prim->channel_needed = CN_ANY_CHAN;
  if (variant == 'O')   prim->channel_needed = CN_SDCCH;
  if (variant == 'P')   prim->channel_needed = CN_TCH_F;
  if (variant == 'Q')   prim->channel_needed = CN_TCH;
  if (variant == 'R')   prim->channel_needed = CN_ANY_CHAN;
  return prim;
}

T_PRIMITIVE_UNION mph_paging_ind_7()
{
  T_MPH_PAGING_IND prim;
  prim->identity_type = ID_TMSI;
  prim->channel_needed = CN_ANY_CHAN;
  return prim;
}

T_PRIMITIVE_UNION mph_emo_req_1()
{
  T_MPH_EMO_REQ prim;
  prim->ba_id = CONST_129;
  prim->arfcn = A_ARFCN_EMO_000;
  return prim;
}
T_PRIMITIVE_UNION mph_emo_req_2()
{
  T_MPH_EMO_REQ prim;
  prim->ba_id = CONST_130;
  prim->arfcn = A_ARFCN_EMO_000;
  return prim;
}


T_PRIMITIVE_UNION mph_emo_meas_ind_1()
{
  T_MPH_EMO_MEAS_IND prim;
  prim->ba_id = CONST_129;
  prim->dtx = CONST_1;
  prim->meas_results = s_emo_meas_res_000();
  return prim;
}



T_PRIMITIVE_UNION mph_emo_meas_ind_2()
{
  T_MPH_EMO_MEAS_IND prim;
  prim->ba_id = CONST_130;
  prim->dtx = CONST_1;
  prim->meas_results = s_emo_meas_res_000();
  return prim;
}


T_PRIMITIVE_UNION  mphc_stop_rxlev_req(void)
{
  T_MPHC_STOP_RXLEV_REQ prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION  mphc_stop_rxlev_con(void)
{
  T_MPHC_STOP_RXLEV_CON prim;
  prim->param._skip;
  return prim;
}

T_PRIMITIVE_UNION  mph_deactivate_req(void)
{
  T_MPH_DEACTIVATE_REQ prim;
  return prim;
}

T_mid ms_id_imsi_ptmsi()
{
  const U8 IMSI[15] = {
    0,0,1,0,1,3,8,2,3,3,0,5,9,4,5
  };
  #define TMSI                    0x05223366L
   T_mid pstruct;
   pstruct->len_imsi = 15;
   pstruct->imsi = IMSI;
   pstruct->v_tmsi = 1;
   pstruct->tmsi = TMSI;
   pstruct->v_ptmsi = 1;
   pstruct->ptmsi = 143;
   pstruct->v_ptmsi2 = 1;
   pstruct->ptmsi2 = 144;
   return pstruct;
}

T_PRIMITIVE_UNION mph_identity_req_2g()
{
   T_MPH_IDENTITY_REQ prim;
   prim->mid = ms_id_imsi_ptmsi();
   return prim;
}

T_PRIMITIVE_UNION mph_idle_req_1g()
{
   T_MPH_IDLE_REQ prim;
   prim->mod = MODE_CELL_SELECTION;
   prim->arfcn = ARFCN_23;
   prim->ext_bcch._skip;
   prim->comb_ccch = COMB_CCCH_COMB;
   prim->tn = TN_0;
   prim->dlt = DLT_10;
   prim->pg = PG_20;
   prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
   prim->bs_pa_mfrms = BS_PA_MFRMS_6;
   prim->power = POWER_12;
   prim->ncc_permitted = NOT_PRESENT_8BIT;
   prim->reorg_only._skip;
   prim->eotd_avail._skip;
   prim->gprs_support = MPH_GPRS_PROCS_USED;
   return prim;
}
const U8 L2_PAG_1_PT1_A1_ARRAY[23] = {
 	0x19,
	0x06,
	0x21,
	0x00,
	0x02,
	0xF4, 143, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B
};

T_l2_frame l2_pag_1_pt1_a1()
{
   T_l2_frame pstruct;
   pstruct->content = L2_PAG_1_PT1_A1_ARRAY;
   return pstruct;
}
T_PRIMITIVE_UNION mphc_data_ind_8g()
{
   T_MPHC_DATA_IND prim;
   prim->radio_freq = ARFCN_23;
   prim->l2_channel = L2_CHANNEL_PCH;
   prim->error_flag = VALID_BLOCK;
   prim->l2_frame   = l2_pag_1_pt1_a1();
   prim->tc         = TC_0;
   prim->ccch_lev._skip;
   prim->fn         = FN_OFFSET_0;
   return prim;
}

T_PRIMITIVE_UNION mph_paging_ind_1g()
{
   T_MPH_PAGING_IND prim;
   prim->identity_type  = ID_PTMSI;
   prim->channel_needed = CN_PACKET;
   return prim;
}

const U8 L2_PAG_1_EMPTY_ARRAY[23] = {
 	0x11,
	0x06,
	0x21,
	0x00,
	0x00,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B
};

T_l2_frame l2_pag_1_empty()
{
   T_l2_frame pstruct;
   pstruct->content = L2_PAG_1_EMPTY_ARRAY;
   return pstruct;
}

T_PRIMITIVE_UNION mphc_data_ind_9g()
{
   T_MPHC_DATA_IND prim;
   prim->radio_freq = ARFCN_23;
   prim->l2_channel = L2_CHANNEL_PCH;
   prim->error_flag = VALID_BLOCK;
   prim->l2_frame   = l2_pag_1_empty();
   prim->tc         = TC_0;
   prim->ccch_lev._skip;
   prim->fn         = FN_OFFSET_0;
   return prim;
}
const U8 L2_PAG_1_PT2_A1_ARRAY[23] = {
 	0x19,
	0x06,
	0x21,
	0x00,
	0x02,
	0xF4, 144, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	0x2B, 0x2B, 0x2B
};

T_l2_frame l2_pag_1_pt2_a1()
{
   T_l2_frame pstruct;
   pstruct->content = L2_PAG_1_PT2_A1_ARRAY;
   return pstruct;
}

T_PRIMITIVE_UNION mphc_data_ind_10g()
{
   T_MPHC_DATA_IND prim;
   prim->radio_freq = ARFCN_23;
   prim->l2_channel = L2_CHANNEL_PCH;
   prim->error_flag = VALID_BLOCK;
   prim->l2_frame   = l2_pag_1_pt2_a1();
   prim->tc         = TC_0;
   prim->ccch_lev._skip;
   prim->fn         = FN_OFFSET_0;
   return prim;
}

T_PRIMITIVE_UNION mph_idle_req_4g()
{
   T_MPH_IDLE_REQ prim;
   prim->mod = MODE_CONFIG_PL;
   prim->arfcn = ARFCN_23;
   prim->ext_bcch._skip;
   prim->comb_ccch = COMB_CCCH_COMB;
   prim->tn = TN_0;
   prim->dlt = DLT_10;
   prim->pg = PG_20;
   prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
   prim->bs_pa_mfrms = BS_PA_MFRMS_6;
   prim->power = POWER_12;
   prim->ncc_permitted = NOT_PRESENT_8BIT;
   prim->reorg_only = NORMAL_PGM;
   prim->eotd_avail = EOTD_NOT_PRES;
   prim->gprs_support = MPH_GPRS_PROCS_USED;
   return prim;
}
T_PRIMITIVE_UNION mph_mon_ctrl_req(U8 action)
{
   T_MPH_MON_CTRL_REQ prim;
   prim->action = action;
   prim->si_to_read._skip;
   return prim;
}

T_PRIMITIVE_UNION mph_idle_req_2g()
{
   T_MPH_IDLE_REQ prim;
   prim->mod = MODE_PACKET_TRANSFER;
   prim->arfcn = ARFCN_23;
   prim->ext_bcch._skip;
   prim->comb_ccch = COMB_CCCH_NOT_COMB;
   prim->tn = TN_0;
   prim->dlt = DLT_10;
   prim->pg = PG_20;
   prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
   prim->bs_pa_mfrms = BS_PA_MFRMS_6;
   prim->power = POWER_12;
   prim->ncc_permitted = NOT_PRESENT_8BIT;
   prim->reorg_only._skip;
   prim->eotd_avail._skip;
   prim->gprs_support = MPH_GPRS_PROCS_USED;
   return prim;
}

#ifdef FF_EGPRS
T_PRIMITIVE_UNION mph_unitdata_ind_si2q(U16 arfcn)
{
  T_MPH_UNITDATA_IND prim;
  prim->arfcn      = arfcn;
  prim->fn         ._skip;
  prim->sdu.aim.ti = TI_0;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2QUATER.msg_type._show;
  prim->sdu.aim.entity.RR->D_SYS_INFO_2QUATER.si_2qua_octets._show;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_si2quater(int ch_type)
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = ch_type;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_2q();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
#endif  // FF_EGPRS

T_PRIMITIVE_UNION mph_mon_ctrl_req_1(U8 action, U8 si_read)
{
   T_MPH_MON_CTRL_REQ prim;
   prim->action = action;
   prim->si_to_read = si_read;
   return prim;
}

T_PRIMITIVE_UNION mphc_scell_ebcch_req_si2q()
{
  T_MPHC_SCELL_EBCCH_REQ  prim;
  prim->schedule_array_size = 1;
  prim->schedule_array._show;
  return prim;
}

T_PRIMITIVE_UNION mphc_scell_nbcch_req_1()
{
  T_MPHC_SCELL_NBCCH_REQ prim;
  prim->schedule_array_size._show;
  prim->schedule_array._show;
  return prim;
}

#ifdef FF_EGPRS
T_PRIMITIVE_UNION mph_enhpara_update_req_1 (char variant)
{
  T_MPH_ENHPARA_UPDATE_REQ      prim;
  int i = MAX_NEIGHBOURCELLS;

  switch(variant) {
  case 'A':
    {
      prim->rep_type = REP_TYPE_ENH;
      prim->enh_para.num_valid_cells = 3;
      prim->enh_para.enh_cell_list._skip ;
      prim->enh_para.enh_rep_data._skip ;
      prim->enh_para.inv_bsic_enabled = TRUE;
      prim->enh_para.multiband_rep = 2;
      prim->enh_para.ncc_permitted = NCC_PERMITTED_4;
      prim->enh_para.rep_rate = NORMAL_REP_RATE;
      prim->enh_para.scale_order = SCALE_0dB;
      prim->enh_para.servingband_rep = 2;
    }
  	break;
  case 'B':
    {
        prim->rep_type = REP_TYPE_ENH;
        prim->enh_para.num_valid_cells = 8;
        /*GSM NC List Idle*/

        while ( i)
        {
          prim->enh_para.enh_cell_list[i-1].arfcn = 0;
          prim->enh_para.enh_cell_list[i-1].bsic = 0;
          prim->enh_para.enh_cell_list[i-1].rep_priority = REP_PRIOR_HIGH;
          i--;
        }

        prim->enh_para.enh_cell_list[0].arfcn = 1;
        prim->enh_para.enh_cell_list[0].bsic = 16;

        prim->enh_para.enh_cell_list[1].arfcn = 15;
        prim->enh_para.enh_cell_list[1].bsic = 17;


        prim->enh_para.enh_cell_list[2].arfcn = 30;
        prim->enh_para.enh_cell_list[2].bsic = 18;


        prim->enh_para.enh_cell_list[3].arfcn = 46;
        prim->enh_para.enh_cell_list[3].bsic = 19;


        prim->enh_para.enh_cell_list[4].arfcn = 59;
        prim->enh_para.enh_cell_list[4].bsic = 20;


        prim->enh_para.enh_cell_list[5].arfcn = 73;
        prim->enh_para.enh_cell_list[5].bsic = 21;


        prim->enh_para.enh_cell_list[6].arfcn = 90;
        prim->enh_para.enh_cell_list[6].bsic = 22;


        prim->enh_para.enh_cell_list[7].arfcn = 108;
        prim->enh_para.enh_cell_list[7].bsic = 24;


        i=5;
        while (i)
        {
          prim->enh_para.enh_rep_data[i-1].rep_threshold = REP_THRESHOLD_0;
          prim->enh_para.enh_rep_data[i-1].rep_offset    = REP_OFFSET_0;
          i--;
        }
        prim->enh_para.inv_bsic_enabled = TRUE;
        prim->enh_para.multiband_rep = 2;
        prim->enh_para.ncc_permitted = NCC_PERMITTED_4;
        prim->enh_para.rep_rate = NORMAL_REP_RATE;
        prim->enh_para.scale_order = SCALE_AUTO;
        prim->enh_para.servingband_rep = 2;
      }
  	break;
  case 'C':
    prim->rep_type = REP_TYPE_NORM;
    prim->enh_para._skip;
    break;
  case 'D':
  case 'E':
    {
        prim->rep_type = REP_TYPE_ENH;
        prim->enh_para.num_valid_cells = 16;
        /*GSM NC List Idle*/

        if (variant == 'D')
        {
          while ( i)
          {
            prim->enh_para.enh_cell_list[i-1].arfcn = 0;
            prim->enh_para.enh_cell_list[i-1].bsic = 0;
            prim->enh_para.enh_cell_list[i-1].rep_priority = REP_PRIOR_HIGH;
            i--;
          }
          prim->enh_para.rep_rate = NORMAL_REP_RATE;
        }
        else
        {
          while ( i)
          {
            prim->enh_para.enh_cell_list[i-1].arfcn = 0;
            prim->enh_para.enh_cell_list[i-1].bsic = 0;
            if ( i%2 == 0)
              prim->enh_para.enh_cell_list[i-1].rep_priority = REP_PRIOR_HIGH;
            else
              prim->enh_para.enh_cell_list[i-1].rep_priority = REP_PRIOR_NORM;
            i--;
          }
          prim->enh_para.rep_rate = REDUCED_REP_RATE;
        }


        prim->enh_para.enh_cell_list[0].arfcn = 30;
        prim->enh_para.enh_cell_list[0].bsic = 18;

        prim->enh_para.enh_cell_list[1].arfcn = 46;
        prim->enh_para.enh_cell_list[1].bsic = 19;


        prim->enh_para.enh_cell_list[2].arfcn = 59;
        prim->enh_para.enh_cell_list[2].bsic = 20;


        prim->enh_para.enh_cell_list[3].arfcn = 73;
        prim->enh_para.enh_cell_list[3].bsic = 21;


        prim->enh_para.enh_cell_list[4].arfcn = 90;
        prim->enh_para.enh_cell_list[4].bsic = 22;


        prim->enh_para.enh_cell_list[5].arfcn = 108;
        prim->enh_para.enh_cell_list[5].bsic = 24;


        prim->enh_para.enh_cell_list[6].arfcn = 512;
        prim->enh_para.enh_cell_list[6].bsic = 16;


        prim->enh_para.enh_cell_list[7].arfcn = 513;
        prim->enh_para.enh_cell_list[7].bsic = 17;

        prim->enh_para.enh_cell_list[8].arfcn = 516;
        prim->enh_para.enh_cell_list[8].bsic = 25;

        prim->enh_para.enh_cell_list[9].arfcn = 525;
        prim->enh_para.enh_cell_list[9].bsic = 26;

        prim->enh_para.enh_cell_list[10].arfcn = 578;
        prim->enh_para.enh_cell_list[10].bsic = 27;

        prim->enh_para.enh_cell_list[11].arfcn = 580;
        prim->enh_para.enh_cell_list[11].bsic = 28;

        prim->enh_para.enh_cell_list[12].arfcn = 581;
        prim->enh_para.enh_cell_list[12].bsic = 29;

        prim->enh_para.enh_cell_list[13].arfcn = 582;
        prim->enh_para.enh_cell_list[13].bsic = 30;

        prim->enh_para.enh_cell_list[14].arfcn = 583;
        prim->enh_para.enh_cell_list[14].bsic = 31;

        prim->enh_para.enh_cell_list[15].arfcn = 584;
        prim->enh_para.enh_cell_list[15].bsic = 48;

        i=5;
        while (i)
        {
          prim->enh_para.enh_rep_data[i-1].rep_threshold = REP_THRESHOLD_0;
          prim->enh_para.enh_rep_data[i-1].rep_offset    = REP_OFFSET_0;
          i--;
        }
        prim->enh_para.inv_bsic_enabled = TRUE;
        prim->enh_para.multiband_rep = 2;
        prim->enh_para.ncc_permitted = NCC_PERMITTED_4;
        prim->enh_para.scale_order = SCALE_AUTO;
        prim->enh_para.servingband_rep = 2;
      }
  	break;
  default:
    break;
  }
  return prim;
}

T_PRIMITIVE_UNION mph_idle_req_15_si2q(int mode)
{
  T_MPH_IDLE_REQ prim;
  prim->mod = mode;
  prim->arfcn = ARFCN_14;
  prim->ext_bcch._skip;
  prim->comb_ccch = COMB_CCCH_NOT_COMB;
  prim->tn = TN_0;
  prim->dlt = DLT_10;
  prim->pg = PG_20;
  prim->bs_ag_blocks_res = BS_AG_BLKS_RES_3;
  prim->bs_pa_mfrms = BS_PA_MFRMS_6;
  prim->power = POWER_12;
  prim->ncc_permitted = NOT_PRESENT_8BIT;
  prim->reorg_only._skip;
  prim->eotd_avail = EOTD_NOT_PRES;
  prim->gprs_support._skip;
  prim->si2quater_status = SI2QUATER_CONFIGURE;
  prim->si2quater_pos = SI2QUATER_ON_EBCCH;

  return prim;
}
#endif  // FF_EGPRS

T_PRIMITIVE_UNION mphc_new_scell_req_20()
{
  T_MPHC_NEW_SCELL_REQ prim;
  prim->radio_freq = ARFCN_14;
  prim->fn_offset = FN_OFFSET_0;
  prim->time_alignment = TIME_ALIGNMT_0;
  prim->tsc = BSIC_1;
   return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_variant(CHAR variant)
{
  T_MPH_POWER_CNF prim;
  int no_of_channels = CHANNELS_0, no_of_white_channels = CHANNELS_0;

  const U16 ARFCN_23_14_124_1_WITH_STD_elements[] = {
     ARFCN_23_STD_EGSM, ARFCN_150_STD_DUAL_US, ARFCN_14_STD_EGSM, ARFCN_140_STD_DUAL_US, 
       ARFCN_124_STD_EGSM, ARFCN_250_STD_DUAL_US, ARFCN_1_STD_EGSM,  ARFCN_130_STD_DUAL_US
  };
  T_ARRAY<U16> ARFCN_23_14_124_1_WITH_STD(ARFCN_23_14_124_1_WITH_STD_elements, SKIP_TO_END);

  const U16 ARFCN_130_STD_DUAL_US_elements[] = { ARFCN_130_STD_DUAL_US };

  T_ARRAY<U16>  ARFCN_130_WITH_STD(ARFCN_130_STD_DUAL_US_elements, SKIP_TO_END);

  switch(variant)
  {
    case 'A' :
      no_of_channels = 110;
      no_of_white_channels = 1;
      prim->arfcn = ARFCN_130_WITH_STD;
      break;
    case 'B' :
      prim->inactive_carrier_list.list[0].channels = LIST_1_14_23_124_euro;
      prim->inactive_carrier_list.list[1].channels = LIST_130_140_150_250_155_amr;
      prim->arfcn._skip;
      break;
    case 'C':
      no_of_channels = CHANNELS_8;
      prim->inactive_carrier_list.list[0].channels = LIST_no_carriers;
      prim->inactive_carrier_list.list[1].channels = LIST_155_amr;
      prim->arfcn = ARFCN_23_14_124_1_WITH_STD;
      break;
    case 'D':
      prim->inactive_carrier_list.list[0].channels._show;
      prim->inactive_carrier_list.list[1].channels = LIST_no_carriers;
      prim->arfcn._skip;
      break;
    default :
      prim->inactive_carrier_list.list[0].channels._skip;
      prim->inactive_carrier_list.list[1].channels._skip;
      prim->arfcn._skip;
      break;
  }

  prim->rx_lev._skip;
  prim->num_of_chan = no_of_channels;
  prim->num_of_white_list_chan = no_of_white_channels;
  return prim;
}


T_PRIMITIVE_UNION mph_power_cnf_max()
{
  T_MPH_POWER_CNF prim;

  prim->num_of_chan = CHANNELS_160;
  prim->num_of_white_list_chan._show;
  prim->arfcn._show;
  prim->rx_lev._show;
  prim->inactive_carrier_list.list[0].channels._skip;
  prim->inactive_carrier_list.list[1].channels._skip;
  return prim;
}


T_PRIMITIVE_UNION mph_power_cnf_overlap()
{
  T_MPH_POWER_CNF prim;

  prim->num_of_chan._show;
  prim->num_of_white_list_chan._show;
  prim->arfcn._show;
  prim->rx_lev._show;
  prim->inactive_carrier_list.list[0].channels._skip;
  prim->inactive_carrier_list.list[1].channels._skip;
  return prim;
}

T_PRIMITIVE_UNION mph_power_cnf_overlap1()
{
  T_MPH_POWER_CNF prim;

  prim->num_of_chan = CHANNELS_160;
  prim->num_of_white_list_chan._show;
  prim->arfcn._show;
  prim->rx_lev._show;
  prim->inactive_carrier_list.list[0].channels._skip;
  prim->inactive_carrier_list.list[1].channels._skip;
  return prim;
}
