/*
  +------------------------------------------------------------------------------
  |  File:       alr_cbch_constraints.cpp
  +------------------------------------------------------------------------------
  |              Copyright 2003 Texas Instruments
  |              All rights reserved.
  |
  |              This file is confidential and a trade secret of Texas Instruments.
  |              The receipt of or possession of this file does not convey
  |              any rights to reproduce or disclose its contents or to
  |              manufacture, use, or sell anything it may describe, in
  |              whole, or in part, without the specific written consent of
  |              Texas Instruments.
  +------------------------------------------------------------------------------
  | Purpose:     Contains test constraints for alr
  |
  +------------------------------------------------------------------------------
*/
#include "alr_constraints.h"
const U8 MSG_ID_3_7_11_TO_13[40] = {
 	3, 0, 3, 0,
	7, 0, 7, 0,
	11, 0, 13, 0,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF
};
const U8 DCS_ID_EMPTY[40] = {
 	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF,
	0xFF, 0xFF, 0xFF, 0xFF
};

T_cbch cbch_description_8()
{
  const U16 CBCH_DESCRIPTION_8_MA_elements[5] = {
 	  0x0E,
	  0x17,
	  0x45,
	  0x73,
	  NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CBCH_DESCRIPTION_8_MA(CBCH_DESCRIPTION_8_MA_elements, SKIP_TO_END);

  T_cbch pstruct;
  pstruct->stat = STAT_ACT;
  pstruct->ch = CH_SDCCH_8_0;
  pstruct->tn = 3;
  pstruct->tsc = 3;
  pstruct->h = H_FREQ;
  pstruct->arfcn = 0;
  pstruct->maio = 1;
  pstruct->hsn = 0;
  pstruct->ma = CBCH_DESCRIPTION_8_MA;
  return pstruct;
}
T_cbch cbch_description_4()
{
  const U16 CBCH_DESCRIPTION_4_MA_elements[5] = {
    0x0E, 0x17, 0x45, 0x73, NOT_PRESENT_16BIT
  };
  T_ARRAY<U16> CBCH_DESCRIPTION_4_MA(CBCH_DESCRIPTION_4_MA_elements, SKIP_TO_END);

  T_cbch pstruct;
  pstruct->stat = STAT_ACT;
  pstruct->ch = CH_SDCCH_4_0;
  pstruct->tn = 0;
  pstruct->tsc = 3;
  pstruct->h = H_FREQ;
  pstruct->arfcn = 0;
  pstruct->maio = 1;
  pstruct->hsn = 0;
  pstruct->ma = CBCH_DESCRIPTION_4_MA;
  return pstruct;
}
T_cbch_desc channel_desc_cbch_8()
{
  T_cbch_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 1;
  pstruct->chan_sel.rf_channel.hsn = 0;
  pstruct->channel_type = 0x04;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 3;
  pstruct->tsc = 3;
  return pstruct;
}
T_cbch_desc channel_desc_cbch_4()
{
  T_cbch_desc pstruct;
  pstruct->chan_sel.h = 1;
  pstruct->chan_sel.rf_channel.maio = 1;
  pstruct->chan_sel.rf_channel.hsn = 0;
  pstruct->channel_type = 0x03;
  pstruct->sub_channel = 0;
  pstruct->timeslot_no = 0;
  pstruct->tsc = 3;
  return pstruct;
}

T_PRIMITIVE_UNION mphc_data_ind_53()
{
  const U8 NULL_MESSAGE_CONTENT_elements[23] = {
 	  0x0F,
	  0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B
  };
  T_ARRAY<U8> NULL_MESSAGE_CONTENT(NULL_MESSAGE_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = NULL_MESSAGE_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_54(CHAR variant)
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  if (variant == 'A') {
    const U8 CBCH_1_7_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x00,
	    0x00, 0x07,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_7_CONTENT(CBCH_1_7_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_7_CONTENT;
  }
  if (variant == 'B') {
    const U8 CBCH_1_11_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x00,
	    0x00, 0x0B,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_11_CONTENT(CBCH_1_11_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_11_CONTENT;
  }
  if (variant == 'C') {
    const U8 CBCH_1_12_CONTENT_elements[23] = {
      0x00,
      0x00, 0x00,
      0x00, 0x0C,
      0x00,
      0x01,
      0xAA, 0xAB, 0xAC, 0xAD,
      0xAE, 0xAF, 0xB0, 0xB1,
      0xB2, 0xB3, 0xB4, 0xB5,
      0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_12_CONTENT(CBCH_1_12_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_12_CONTENT;
  }
  if (variant == 'D') {
    const U8 CBCH_1_13_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x00,
	    0x00, 0x0D,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_13_CONTENT(CBCH_1_13_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_13_CONTENT;
  }
  if (variant == 'E') {
    const U8 CBCH_1_7_2_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x02,
	    0x00, 0x07,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_7_2_CONTENT(CBCH_1_7_2_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_7_2_CONTENT;
  }
  if (variant == 'F') {
    const U8 CBCH_1_7_B_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x0B,
	    0x00, 0x07,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_7_B_CONTENT(CBCH_1_7_B_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_7_B_CONTENT;
  }
  if (variant == 'G') {
    const U8 CBCH_1_7_scope_la_CONTENT_elements[23] = {
 	    0x00,
	    0x80, 0x00,
	    0x00, 0x07,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_7_scope_la_CONTENT(CBCH_1_7_scope_la_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_7_scope_la_CONTENT;
  }
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_55()
{
  const U8 CBCH_2_CONTENT_elements[23] = {
 	  0x01,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF
  };
  T_ARRAY<U8> CBCH_2_CONTENT(CBCH_2_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_2_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_56()
{
  const U8 CBCH_3_CONTENT_elements[23] = {
 	  0x02,
	  0xD0, 0xD1, 0xD2, 0xD3,
	  0xD4, 0xD5, 0xD6, 0xD7,
	  0xD8, 0xD9, 0xDA, 0xDB,
	  0xDC, 0xDD, 0xDE, 0xDF,
	  0xE0, 0xE1, 0xE2, 0xE3,
	  0xE4, 0xE5
  };
  T_ARRAY<U8> CBCH_3_CONTENT(CBCH_3_CONTENT_elements, SKIP_TO_END);


  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_3_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_57()
{
  const U8 CBCH_4_CONTENT_elements[23] = {
 	  0x03,
	  0xE6, 0xE7, 0xE8, 0xE9,
	  0xEA, 0xEB, 0xEC, 0xED,
	  0xEE, 0xEF, 0xF0, 0xF1,
	  0xF2, 0xF3, 0xF4, 0xF5,
	  0xF6, 0xF7, 0xF8, 0xF9,
	  0xFA, 0xFB
  };
  T_ARRAY<U8> CBCH_4_CONTENT(CBCH_4_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_4_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_58()
{
  const U8 CBCH_1_8_CONTENT_elements[23] = {
 	  0x00,
	  0x00, 0x00,
	  0x00, 0x08,
	  0x00,
	  0x01,
	  0xAA, 0xAB, 0xAC, 0xAD,
	  0xAE, 0xAF, 0xB0, 0xB1,
	  0xB2, 0xB3, 0xB4, 0xB5,
	  0xB6, 0xB7, 0xB8, 0xB9
  };
  T_ARRAY<U8> CBCH_1_8_CONTENT(CBCH_1_8_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_1_8_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_59()
{
  const U8 SCHEDULE_1_B_CONTENT_elements[23] = {
 	  0x08,
	  0x0B, 0x12,
	  0x12, 0x04, 0x80,
	  0x00, 0x00, 0x00,
	  0x80, 0x05,
	  0x41,
	  0x80, 0x07,
	  0x41,
	  0x40,
	  0x80, 0x03,
	  0x40, 0x40, 0x40, 0x40, 0x40
  };
  T_ARRAY<U8> SCHEDULE_1_B_CONTENT(SCHEDULE_1_B_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = SCHEDULE_1_B_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_60()
{
  const U8 SCHEDULE_2_CONTENT_elements[23] = {
    0x01,
    0x40, 0x40, 0x40, 0x40, 0x40,
    0x80, 0x08,
    0x02,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
    0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
    0x2B, 0x2B, 0x2B, 0x2B
  };
  T_ARRAY<U8> SCHEDULE_2_CONTENT(SCHEDULE_2_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = SCHEDULE_2_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_61()
{
  const U8 SCHEDULE_3_CONTENT_elements[23] = {
 	  0x02,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B
  };
  T_ARRAY<U8> SCHEDULE_3_CONTENT(SCHEDULE_3_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = SCHEDULE_3_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_62()
{
  const U8 SCHEDULE_4_CONTENT_elements[23] = {
 	  0x13,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B, 0x2B, 0x2B, 0x2B,
	  0x2B, 0x2B
  };
  T_ARRAY<U8> SCHEDULE_4_CONTENT(SCHEDULE_4_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = SCHEDULE_4_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_66()
{
  const U8 CBCH_2_CONTENT_elements[23] = {
 	  0x0B,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF
  };
  T_ARRAY<U8> CBCH_2_CONTENT(CBCH_2_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_2_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}
T_PRIMITIVE_UNION mphc_data_ind_67()
{
  const U8 SCHEDULE_1_B_CONTENT_elements[23] = {
 	  0x08,
	  0x01, 0x30,
	  0x12, 0x04, 0x80,
	  0x00, 0x00, 0x00,
	  0x80, 0x05,
	  0x41,
	  0x80, 0x07,
	  0x41,
	  0x40,
	  0x80, 0x03,
	  0x40, 0x40, 0x40, 0x40, 0x40
  };
  T_ARRAY<U8> SCHEDULE_1_B_CONTENT(SCHEDULE_1_B_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = SCHEDULE_1_B_CONTENT;
  prim->tc = TC_0;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_68(CHAR variant)
{
  const U8 CBCH_2_CONTENT_elements[23] = {
 	  0x0B,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF
  };
  T_ARRAY<U8> CBCH_2_CONTENT(CBCH_2_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = INVALID_BLOCK;
  prim->l2_frame.content = CBCH_2_CONTENT;
  if( variant == 'A') prim->tc = TC_0;
  if( variant == 'B') prim->tc = TC_4;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_69()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  {
    const U8 CBCH_1_7_CONTENT_elements[23] = {
 	    0x00,
	    0x00, 0x00,
	    0x00, 0x0B,
	    0x00,
	    0x01,
	    0xAA, 0xAB, 0xAC, 0xAD,
	    0xAE, 0xAF, 0xB0, 0xB1,
	    0xB2, 0xB3, 0xB4, 0xB5,
	    0xB6, 0xB7, 0xB8, 0xB9
    };
    T_ARRAY<U8> CBCH_1_7_CONTENT(CBCH_1_7_CONTENT_elements, SKIP_TO_END);

    prim->l2_frame.content =  CBCH_1_7_CONTENT;
  }
  prim->tc = TC_4;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_70()
{
  const U8 CBCH_2_CONTENT_elements[23] = {
 	  0x01,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF
  };
  T_ARRAY<U8> CBCH_2_CONTENT(CBCH_2_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_2_CONTENT;
  prim->tc = TC_5;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_71()
{
  const U8 CBCH_3_CONTENT_elements[23] = {
 	  0x02,
	  0xD0, 0xD1, 0xD2, 0xD3,
	  0xD4, 0xD5, 0xD6, 0xD7,
	  0xD8, 0xD9, 0xDA, 0xDB,
	  0xDC, 0xDD, 0xDE, 0xDF,
	  0xE0, 0xE1, 0xE2, 0xE3,
	  0xE4, 0xE5
  };
  T_ARRAY<U8> CBCH_3_CONTENT(CBCH_3_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_3_CONTENT;
  prim->tc = TC_6;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_72()
{
  const U8 CBCH_4_CONTENT_elements[23] = {
 	  0x03,
	  0xE6, 0xE7, 0xE8, 0xE9,
	  0xEA, 0xEB, 0xEC, 0xED,
	  0xEE, 0xEF, 0xF0, 0xF1,
	  0xF2, 0xF3, 0xF4, 0xF5,
	  0xF6, 0xF7, 0xF8, 0xF9,
	  0xFA, 0xFB
  };
  T_ARRAY<U8> CBCH_4_CONTENT(CBCH_4_CONTENT_elements, SKIP_TO_END);

  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_CBCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame.content = CBCH_4_CONTENT;
  prim->tc = TC_7;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0;
  return prim;
}

T_PRIMITIVE_UNION mphc_data_ind_73()
{
  T_MPHC_DATA_IND prim;
  prim->radio_freq = ARFCN_23;
  prim->l2_channel = L2_CHANNEL_NBCCH;
  prim->error_flag = VALID_BLOCK;
  prim->l2_frame = l2_sys_info_3_new();
  prim->tc = TC_1;
  prim->ccch_lev._skip;
  prim->fn = FN_OFFSET_0; //FN_OFFSET_14;
  return prim;
}

T_PRIMITIVE_UNION mph_cbch_req_1()
{
  T_MPH_CBCH_REQ prim;
  prim->cbch.stat._skip;
  prim->cbch.ch._skip;
  prim->cbch.tn._skip;
  prim->cbch.tsc._skip;
  prim->cbch.h._skip;
  prim->cbch.arfcn._skip;
  prim->cbch.maio._skip;
  prim->cbch.hsn._skip;

  return prim;
}
T_PRIMITIVE_UNION mph_cbch_req_2(CHAR variant)
{
  T_MPH_CBCH_REQ prim;
  if (variant == 'A')   prim->cbch = cbch_description_4();
  if (variant == 'B')   prim->cbch = cbch_description_8();
  return prim;
}
T_PRIMITIVE_UNION mph_cbch_req_3(CHAR variant)
{
  T_MPH_CBCH_REQ prim;
  if (variant == 'A')   prim->cbch = cbch_description_4();
  if (variant == 'B')   prim->cbch = cbch_description_8();
  if (variant == 'C')   prim->cbch = cbch_description_4();
  return prim;
}
T_PRIMITIVE_UNION mmi_cbch_req_1()
{
  T_MMI_CBCH_REQ prim;
  prim->msg_id = MSG_ID_3_7_11_TO_13;
  prim->dcs_id = DCS_ID_EMPTY;
  prim->modus = CBCH_ACCEPT;
  return prim;
}
T_PRIMITIVE_UNION mmi_cbch_req_2(CHAR variant)
{
  T_MMI_CBCH_REQ prim;
  if (variant == 'A')   prim->msg_id = MSG_ID_3_7_11_TO_13;
  if (variant == 'B')   prim->msg_id = MSG_ID_3_7_11_TO_13;
  if (variant == 'C') {
    const U8 MSG_ID_1_TO_20[40] = {
 	    1, 0, 20, 0,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF,
	    0xFF, 0xFF, 0xFF, 0xFF
    };

    prim->msg_id = MSG_ID_1_TO_20;
  }
  prim->dcs_id = DCS_ID_EMPTY;
  prim->modus = CBCH_ACCEPT;
  return prim;
}

T_PRIMITIVE_UNION mphc_config_cbch_req_1(CHAR variant)
{
  T_MPHC_CONFIG_CBCH_REQ prim;
  if (variant == 'A')   prim->cbch_desc = channel_desc_cbch_4();
  if (variant == 'B')   prim->cbch_desc = channel_desc_cbch_8();
  prim->cbch_freq_list = freq_list();
  return prim;
}
T_PRIMITIVE_UNION mphc_config_cbch_req_2(CHAR variant)
{
  T_MPHC_CONFIG_CBCH_REQ prim;
  if (variant == 'A')   prim->cbch_desc = channel_desc_cbch_4();
  if (variant == 'B')   prim->cbch_desc = channel_desc_cbch_8();
  if (variant == 'C')   prim->cbch_desc = channel_desc_cbch_4();
  prim->cbch_freq_list = freq_list();
  return prim;
}

T_PRIMITIVE_UNION mphc_cbch_schedule_req_1()
{
  T_MPHC_CBCH_SCHEDULE_REQ prim;
  prim->cbch_select = CBCH_READ_NORM;
  prim->schedule_length = SCHED_LEN_0;
  prim->first_blocks_0._skip;
  prim->first_blocks_1._skip;
  return prim;
}

T_PRIMITIVE_UNION mphc_cbch_schedule_req_2()
{
  T_MPHC_CBCH_SCHEDULE_REQ prim;
  prim->cbch_select = CBCH_READ_EXT;
  prim->schedule_length = SCHED_LEN_0;
  prim->first_blocks_0._skip;
  prim->first_blocks_1._skip;
  return prim;
}
T_PRIMITIVE_UNION mphc_cbch_schedule_req_3()
{
  T_MPHC_CBCH_SCHEDULE_REQ prim;
  prim->cbch_select = CBCH_READ_NORM;
  prim->schedule_length = SCHED_LEN_8;
  prim->first_blocks_0 = FIRST_BLOCKS_0_UNSCH;
  prim->first_blocks_1 = FIRST_BLOCKS_1_B;
  return prim;
}
T_PRIMITIVE_UNION mphc_cbch_schedule_req_4(CHAR variant)
{
  T_MPHC_CBCH_SCHEDULE_REQ prim;
  prim->cbch_select._skip;
  prim->schedule_length = SCHED_LEN_30 ;
  if( variant == 'A')   prim->first_blocks_0 = FIRST_BLOCKS_0_B;
  if( variant == 'B')   prim->first_blocks_0 = FIRST_BLOCKS_0_DRX;
  if( variant == 'A')   prim->first_blocks_1 = FIRST_BLOCKS_1_B;
  if( variant == 'B')   prim->first_blocks_1 = FIRST_BLOCKS_1_B;
  return prim;
}

T_PRIMITIVE_UNION mphc_cbch_info_req_1()
{
  T_MPHC_CBCH_INFO_REQ prim;
  prim->tb_bitmap = CBCH_NORM_BLOCK234;
  return prim;
}

T_PRIMITIVE_UNION mphc_cbch_info_req_2()
{
  T_MPHC_CBCH_INFO_REQ prim;
  prim->tb_bitmap = 0;
  return prim;
}

T_PRIMITIVE_UNION mphc_cbch_info_req_3()
{
  T_MPHC_CBCH_INFO_REQ prim;
  prim->tb_bitmap = CBCH_EXT_BLOCK234;
  return prim;
}

T_PRIMITIVE_UNION mmi_cbch_ind_1(CHAR variant)
{
  T_MMI_CBCH_IND prim;
  const U8 CBCH_MSG_7[88] = {
    0x00, 0x00,
    0x00, 0x07,
    0x00,
    0x01,
    0xAA, 0xAB, 0xAC, 0xAD,
    0xAE, 0xAF, 0xB0, 0xB1,
    0xB2, 0xB3, 0xB4, 0xB5,
    0xB6, 0xB7, 0xB8, 0xB9,
    0xBA, 0xBB, 0xBC, 0xBD,
    0xBE, 0xBF, 0xC0, 0xC1,
    0xC2, 0xC3, 0xC4, 0xC5,
    0xC6, 0xC7, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCC, 0xCD,
    0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3,
    0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3,
    0xE4, 0xE5,
    0xE6, 0xE7, 0xE8, 0xE9,
    0xEA, 0xEB, 0xEC, 0xED,
    0xEE, 0xEF, 0xF0, 0xF1,
    0xF2, 0xF3, 0xF4, 0xF5,
    0xF6, 0xF7, 0xF8, 0xF9,
    0xFA, 0xFB
  };
  const U8 CBCH_MSG_7_updt_2[88] = {
    0x00, 0x02,
    0x00, 0x07,
    0x00,
    0x01,
    0xAA, 0xAB, 0xAC, 0xAD,
    0xAE, 0xAF, 0xB0, 0xB1,
    0xB2, 0xB3, 0xB4, 0xB5,
    0xB6, 0xB7, 0xB8, 0xB9,
    0xBA, 0xBB, 0xBC, 0xBD,
    0xBE, 0xBF, 0xC0, 0xC1,
    0xC2, 0xC3, 0xC4, 0xC5,
    0xC6, 0xC7, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCC, 0xCD,
    0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3,
    0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3,
    0xE4, 0xE5,
    0xE6, 0xE7, 0xE8, 0xE9,
    0xEA, 0xEB, 0xEC, 0xED,
    0xEE, 0xEF, 0xF0, 0xF1,
    0xF2, 0xF3, 0xF4, 0xF5,
    0xF6, 0xF7, 0xF8, 0xF9,
    0xFA, 0xFB
  };
  const U8 CBCH_MSG_7_scope_la[88] = {
    0x80, 0x00,
    0x00, 0x07,
    0x00,
    0x01,
    0xAA, 0xAB, 0xAC, 0xAD,
    0xAE, 0xAF, 0xB0, 0xB1,
    0xB2, 0xB3, 0xB4, 0xB5,
    0xB6, 0xB7, 0xB8, 0xB9,
    0xBA, 0xBB, 0xBC, 0xBD,
    0xBE, 0xBF, 0xC0, 0xC1,
    0xC2, 0xC3, 0xC4, 0xC5,
    0xC6, 0xC7, 0xC8, 0xC9,
    0xCA, 0xCB, 0xCC, 0xCD,
    0xCE, 0xCF,
    0xD0, 0xD1, 0xD2, 0xD3,
    0xD4, 0xD5, 0xD6, 0xD7,
    0xD8, 0xD9, 0xDA, 0xDB,
    0xDC, 0xDD, 0xDE, 0xDF,
    0xE0, 0xE1, 0xE2, 0xE3,
    0xE4, 0xE5,
    0xE6, 0xE7, 0xE8, 0xE9,
    0xEA, 0xEB, 0xEC, 0xED,
    0xEE, 0xEF, 0xF0, 0xF1,
    0xF2, 0xF3, 0xF4, 0xF5,
    0xF6, 0xF7, 0xF8, 0xF9,
    0xFA, 0xFB
  };
  const U8 CBCH_MSG_11[88] = {
 	  0x00, 0x00,
	  0x00, 0x0B,
	  0x00,
	  0x01,
	  0xAA, 0xAB, 0xAC, 0xAD,
	  0xAE, 0xAF, 0xB0, 0xB1,
	  0xB2, 0xB3, 0xB4, 0xB5,
	  0xB6, 0xB7, 0xB8, 0xB9,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF,
	  0xD0, 0xD1, 0xD2, 0xD3,
	  0xD4, 0xD5, 0xD6, 0xD7,
	  0xD8, 0xD9, 0xDA, 0xDB,
	  0xDC, 0xDD, 0xDE, 0xDF,
	  0xE0, 0xE1, 0xE2, 0xE3,
	  0xE4, 0xE5,
	  0xE6, 0xE7, 0xE8, 0xE9,
	  0xEA, 0xEB, 0xEC, 0xED,
	  0xEE, 0xEF, 0xF0, 0xF1,
	  0xF2, 0xF3, 0xF4, 0xF5,
	  0xF6, 0xF7, 0xF8, 0xF9,
	  0xFA, 0xFB
  };
  const U8 CBCH_MSG_12[88] = {
 	  0x00, 0x00,
	  0x00, 0x0C,
	  0x00,
	  0x01,
	  0xAA, 0xAB, 0xAC, 0xAD,
	  0xAE, 0xAF, 0xB0, 0xB1,
	  0xB2, 0xB3, 0xB4, 0xB5,
	  0xB6, 0xB7, 0xB8, 0xB9,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF,
	  0xD0, 0xD1, 0xD2, 0xD3,
	  0xD4, 0xD5, 0xD6, 0xD7,
	  0xD8, 0xD9, 0xDA, 0xDB,
	  0xDC, 0xDD, 0xDE, 0xDF,
	  0xE0, 0xE1, 0xE2, 0xE3,
	  0xE4, 0xE5,
	  0xE6, 0xE7, 0xE8, 0xE9,
	  0xEA, 0xEB, 0xEC, 0xED,
	  0xEE, 0xEF, 0xF0, 0xF1,
	  0xF2, 0xF3, 0xF4, 0xF5,
	  0xF6, 0xF7, 0xF8, 0xF9,
	  0xFA, 0xFB
  };
  const U8 CBCH_MSG_13[88] = {
 	  0x00, 0x00,
	  0x00, 0x0D,
	  0x00,
	  0x01,
	  0xAA, 0xAB, 0xAC, 0xAD,
	  0xAE, 0xAF, 0xB0, 0xB1,
	  0xB2, 0xB3, 0xB4, 0xB5,
	  0xB6, 0xB7, 0xB8, 0xB9,
	  0xBA, 0xBB, 0xBC, 0xBD,
	  0xBE, 0xBF, 0xC0, 0xC1,
	  0xC2, 0xC3, 0xC4, 0xC5,
	  0xC6, 0xC7, 0xC8, 0xC9,
	  0xCA, 0xCB, 0xCC, 0xCD,
	  0xCE, 0xCF,
	  0xD0, 0xD1, 0xD2, 0xD3,
	  0xD4, 0xD5, 0xD6, 0xD7,
	  0xD8, 0xD9, 0xDA, 0xDB,
	  0xDC, 0xDD, 0xDE, 0xDF,
	  0xE0, 0xE1, 0xE2, 0xE3,
	  0xE4, 0xE5,
	  0xE6, 0xE7, 0xE8, 0xE9,
	  0xEA, 0xEB, 0xEC, 0xED,
	  0xEE, 0xEF, 0xF0, 0xF1,
	  0xF2, 0xF3, 0xF4, 0xF5,
	  0xF6, 0xF7, 0xF8, 0xF9,
	  0xFA, 0xFB
  };

  if (variant == 'A')   prim->cbch_msg = CBCH_MSG_7;
  if (variant == 'B')   prim->cbch_msg = CBCH_MSG_11;
  if (variant == 'C')   prim->cbch_msg = CBCH_MSG_12;
  if (variant == 'D')   prim->cbch_msg = CBCH_MSG_13;
  if (variant == 'E')   prim->cbch_msg = CBCH_MSG_7_updt_2;
  if (variant == 'F')   prim->cbch_msg = CBCH_MSG_7_scope_la;
  prim->cbch_len = CBCH_LEN_88;
  return prim;
}
T_PRIMITIVE_UNION mphc_stop_cbch_req()
{
   T_MPHC_STOP_CBCH_REQ prim;
   prim->normal_cbch._skip;
   prim->extended_cbch._skip;
   return prim;
}
