#----------------------------------------------------------------------------- 
#  Project :  
#  Modul   :  J:\g23m-gsm\alr\alr.mak
#----------------------------------------------------------------------------- 
#  Copyright 2002 Texas Instruments Berlin, AG 
#                 All rights reserved. 
# 
#                 This file is confidential and a trade secret of Texas 
#                 Instruments Berlin, AG 
#                 The receipt of or possession of this file does not convey 
#                 any rights to reproduce or disclose its contents or to 
#                 manufacture, use, or sell anything it may describe, in 
#                 whole, or in part, without the specific written consent of 
#                 Texas Instruments Berlin, AG. 
#----------------------------------------------------------------------------- 
#|  Purpose :  
#----------------------------------------------------------------------------- 
#
#	Setting Directory for ALR Objects
#
OBJ := $(L23_OBJ_DIR)/alr

SRCALR=$(CONDAT_DIR)/ms/src/alr

ifneq ($(PMODE),0)
ALRCONFIG=-DHAS_FLASH_EPROM -DALR=1 -DCHIPSET=$(CHIPSET) -DFF_MULTIBAND
ALROBJ = $(OBJ)/alr_cs.$(OBJ_TAIL) $(OBJ)/alr_csf.$(OBJ_TAIL) $(OBJ)/alr_main.$(OBJ_TAIL) \
     $(OBJ)/alr_nc.$(OBJ_TAIL) $(OBJ)/alr_pch.$(OBJ_TAIL) $(OBJ)/alr_pei.$(OBJ_TAIL) \
     $(OBJ)/alr_rach.$(OBJ_TAIL) $(OBJ)/alr_sc.$(OBJ_TAIL) $(OBJ)/alr_dedi.$(OBJ_TAIL)\
     $(OBJ)/alr_mmi.$(OBJ_TAIL) $(OBJ)/alr_cbch.$(OBJ_TAIL) $(OBJ)/alr_trc.$(OBJ_TAIL)\
     $(OBJ)/alr_tim.$(OBJ_TAIL)
endif

ifeq ($(EM),1)
ALROBJ += $(OBJ)/alr_em.$(OBJ_TAIL)
endif

# Necessary for dummy functions in alr_main.c
ifneq ($(SRVC),0)
COPT += -dFAX_AND_DATA
endif

ifeq ($(PMODE),2)
ALROBJ +=  $(OBJ)/alr_gprs.$(OBJ_TAIL)
endif
#
# ---------------- create TI++ ---------------------
#
$(TOP_DIR)/$(ALR_LIB) : $(OBJ) $(ALROBJ)
	-$(PERL) $(CONDAT_DIR)/int/bin/make_ver.pl
	$(AR) r $(TOP_DIR)/$(ALR_LIB) $(ALROBJ) ver.$(OBJ_TAIL)


$(OBJ):	
	mkdir $(subst /,$(SLASH),$(OBJ))
	
clean: 
	$(REMOVE) $(subst /,$(SLASH),$(OBJ))

$(ALROBJ) : $(OBJ)/%.$(OBJ_TAIL) : $(SRCALR)/%.c
	echo -D$(NCONFIG) >  cmd
	echo -D$(NWARN) >> cmd
	echo $(ALRCONFIG) >> cmd
	echo $(COPT) >> cmd
	echo $(COPT1) >> cmd
	echo $(COTAR) >> cmd
	echo -I$(ICOM) >> cmd
	echo $(INCDRV2) >> cmd
	echo -I$(ICDG) >> cmd
	echo -i$(SRCALR) >> cmd
	echo -fr$(OBJ) >> cmd
	$(CC_PRE) $^ -@cmd
	$(CC_INT) $(addsuffix .pp,$(basename $^))
	$(CC_COM) $(addsuffix .pp_,$(basename $^)) -@cmd
