/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  MUX for ACI primitives
|             
|             Different entities sends the same ACI primitives. In this
|             file the correct PSA function will call
+----------------------------------------------------------------------------- 
*/ 

/*==== INCLUDES ===================================================*/

#ifndef SAP_ACI_C
#define SAP_ACI_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci.h"

/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/


/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GSM                   MODULE  : SAP_DTI                 |
|                                 ROUTINE : psa_dti_ready_ind       |
+-------------------------------------------------------------------+

  PURPOSE : processes the DTI_READY_IND primitive send by other entity.
            This indicates that the entity is ready to get
            the next data primitive.
*/

GLOBAL const void psa_dti_ready_ind( T_DTI_READY_IND *dti_ready_ind )
{
  switch (dti_ready_ind->tui)
  {
    case DTI_ENTITY_UART:
      psa_uart_dti_ready_ind (dti_ready_ind);
      break;

    default:
      TRACE_EVENT ("[ERR] sap_dti_ready_ind(): unknown TUI");
      PFREE (dti_ready_ind);
      break;
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM                   MODULE  : SAP_DTI                 |
|                                 ROUTINE : psa_dti_data_ind       |
+-------------------------------------------------------------------+

  PURPOSE : processes the DTI_DATA_IND primitive send by other entity.
            This indicates that the entity is ready to get
            the next data primitive.
*/

GLOBAL const void psa_dti_data_ind( T_DTI_DATA_IND *dti_data_ind )
{
  switch (dti_data_ind->tui)
  {
    case DTI_ENTITY_UART:
      psa_uart_dti_data_ind (dti_data_ind);
      break;

    default:
      TRACE_EVENT ("[ERR] sap_dti_data_ind(): unknown TUI");
      PFREE (dti_data_ind);
      break;
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM                   MODULE  : SAP_DTI                 |
|                                 ROUTINE : psa_dti_data_test_ind   |
+-------------------------------------------------------------------+

  PURPOSE : processes the DTI_DATA_TEST_IND primitive send by other
            entity. This indicates that the entity is ready to get
            the next data primitive.
*/

#ifdef _SIMULATION_

GLOBAL const void psa_dti_data_test_ind ( T_DTI_DATA_TEST_IND *dti_data_test_ind )
{
  switch (dti_data_test_ind->tui)
  {
    case DTI_ENTITY_UART:
      psa_uart_dti_data_test_ind (dti_data_test_ind);
      break;

    default:
      TRACE_EVENT ("[ERR] sap_dti_data_test_ind(): unknown TUI");
      PFREE (dti_data_test_ind);
      break;
  }
}
#endif /* _SIMULATION_ */
