/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  J:\g23m-aci\aci\psa_waps.c
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 

#ifdef FF_WAP

#ifndef PSA_WAPS_C
#define PSA_WAPS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#ifdef FAX_AND_DATA
//#include "aci_fd.h"
#endif    /* of #ifdef FAX_AND_DATA */


#include "aci.h"
#include "psa.h"
#include "psa_sim.h"
#include "psa_sms.h"
#include "psa_mmi.h"
#include "cmh.h"
//#include "cmh_sim.h"
#include "phb.h"
#include "aoc.h"

#ifdef SIM_TOOLKIT
#include "psa_cc.h"
#include "psa_sat.h"
#endif /* SIM_TOOLKIT */

#include "psa_waps.h"

#include "dti.h"
#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"



/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/


/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/





SHORT psaMMI_WAP_IND (UBYTE event_id,void* data, USHORT data_size)
{
  PALLOC_SDU (mmi_wap_ind, MMI_WAP_IND, (USHORT)(8*data_size));
	mmi_wap_ind->event_id = event_id;
	mmi_wap_ind->sdu.o_buf     = 0;
	mmi_wap_ind->sdu.l_buf     = 8*data_size;
	memcpy(mmi_wap_ind->sdu.buf,data,data_size);
  PSENDX (WAP, mmi_wap_ind);

  return 0;
}


SHORT psaMMI_WAP_REQ (UBYTE event_id, UBYTE ti, void* data, USHORT data_size)
{
  PALLOC_SDU (mmi_wap_req, MMI_WAP_REQ, (USHORT)(8*data_size));
	mmi_wap_req->event_id = event_id;
	mmi_wap_req->ti = ti;
	mmi_wap_req->sdu.o_buf     = 0;
	mmi_wap_req->sdu.l_buf     = 8*data_size;
	memcpy(mmi_wap_req->sdu.buf,data,data_size);
  PSENDX (WAP, mmi_wap_req);

  return 0;
}

SHORT psaMMI_WAP_CNF (UBYTE event_id,UBYTE ti,void* data,  USHORT data_size)
{
  PALLOC_SDU (mmi_wap_cnf, MMI_WAP_CNF, (USHORT)(8*data_size));
	mmi_wap_cnf->event_id = event_id;
	mmi_wap_cnf->ti     = ti;
	mmi_wap_cnf->sdu.o_buf     = 0;
	mmi_wap_cnf->sdu.l_buf     = 8*data_size;
	memcpy(mmi_wap_cnf->sdu.buf,data,data_size);
  PSENDX (WAP, mmi_wap_cnf);

   return 0;
}



/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)    MODULE  : PSA_WAPS                     |
|                            ROUTINE : psaWAP_Dti_Req               |
+-------------------------------------------------------------------+

  PURPOSE : connect/disconnect WAP 

*/

GLOBAL void psaWAP_Dti_Req(ULONG link_id, UBYTE peer_to_connect_to, UBYTE dti_conn)
{
  PALLOC( wap_dti_req, WAP_DTI_REQ);
 
  TRACE_FUNCTION("psaWAP_Dti_Req");

  wap_dti_req -> dti_conn  = dti_conn;
  wap_dti_req -> link_id   = link_id;
  wap_dti_req -> dti_direction = DTI_CHANNEL_TO_LOWER_LAYER;
  strcpy((char*)wap_dti_req->entity_name, dti_entity_name[peer_to_connect_to].name);

  if (dti_conn EQ WAP_CONNECT_DTI)
  {
    if (dti_cntrl_set_conn_parms(link_id, DTI_ENTITY_WAP, DTI_INSTANCE_NOTPRESENT, DTI_SUB_NO_NOTPRESENT) EQ FALSE)
    {
       return;
    }
  }

  PSENDX( WAP, wap_dti_req );
}

#endif /* FF_WAP */
