/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  PSA_PPPP
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the processing functions for the
|             primitives sent to the protocol stack adapter by the PPP
|             module.
+----------------------------------------------------------------------------- 
*/ 

#if defined (FF_WAP) && defined (DTI)

#ifndef PSA_WAPP_C
#define PSA_WAPP_C
#endif /* of PSA_PPPP_C */

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#ifdef FAX_AND_DATA
//#include "aci_fd.h"
#endif    /* of #ifdef FAX_AND_DATA */

#include "dti.h"
#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "aci.h"
#include "psa.h"
#include "psa_sim.h"
#include "psa_sms.h"
#include "psa_mmi.h"
#include "cmh.h"
#include "cmh_sim.h"
#include "phb.h"
#include "aoc.h"

#ifdef SIM_TOOLKIT
#include "psa_cc.h"
#include "psa_sat.h"
#endif /* SIM_TOOLKIT */

#include "wap_aci.h"

/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/


/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/


/*
+--------------------------------------------------------------------+
| PROJECT : GSM-WAP (8444)             MODULE  : ACI                |
| STATE   : code                       ROUTINE : psa_wap_mmi_ind     |
+--------------------------------------------------------------------+

  PURPOSE : Process primitive WAP_MMI_IND received from  WAP
*/

GLOBAL const void   psa_wap_mmi_ind (
                                  T_WAP_MMI_IND *wap_mmi_ind
                                )
{
  PACCESS(wap_mmi_ind);
  TRACE_FUNCTION("wap_mmi_ind()");


{
	UBYTE *event_store;
	USHORT total_size;
	
/*
	sprintf(temp,"wap_mmi_ind->event_id %d",wap_mmi_ind->event_id);
	TRACE_EVENT(temp);	
	sprintf(temp,"wap_mmi_ind->sdu.l_buf %d",wap_mmi_ind->sdu.l_buf);
	TRACE_EVENT(temp);	
*/
	total_size = wap_mmi_ind->sdu.l_buf/8;
	event_store = (UBYTE*)wap_mmi_ind->sdu.buf;
		// Memory dump, REMOVE
	/*TRACE_EVENT("WAP memory dump, received event");
	for (offsetIndex = 0; (offsetIndex<total_size && offsetIndex<80); offsetIndex++)
		{
		sprintf(temp,"%8x %2x %3d %c", event_store+offsetIndex, *(event_store+offsetIndex), *(event_store+offsetIndex), *(event_store+offsetIndex));
		TRACE_EVENT(temp);
		}*/
	// End of memory dump 
}

#ifdef MFW
	mmi_decoder(wap_mmi_ind->event_id, (void*)wap_mmi_ind->sdu.buf);
#endif

PFREE(wap_mmi_ind);

}
/*
+--------------------------------------------------------------------+
| PROJECT : GSM-WAP (8444)             MODULE  : ACI                |
| STATE   : code                       ROUTINE : psa_wap_mmi_req     |
+--------------------------------------------------------------------+

  PURPOSE : Process primitive WAP_MMI_REQ received from  WAP
*/

GLOBAL const void   psa_wap_mmi_req (
                                  T_WAP_MMI_REQ *wap_mmi_req
                                )
{
  PACCESS(wap_mmi_req);
  TRACE_EVENT("wap_mmi_req()");


{
	char temp[50];
	sprintf(temp,"wap_mmi_req->event_id %d",wap_mmi_req->event_id);
	TRACE_EVENT(temp);	
	sprintf(temp,"wap_mmi_req->sdu.l_buf %d",wap_mmi_req->sdu.l_buf);
	TRACE_EVENT(temp);	
	sprintf(temp,"wap_mmi_req->sdu.buf %s",(char*)wap_mmi_req->sdu.buf);
	TRACE_EVENT(temp);	


}
  
  PFREE(wap_mmi_req);
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-WAP (8444)             MODULE  : ACI				 |          
| STATE   : code                       ROUTINE : psa_wap_mmi_cnf     |
+--------------------------------------------------------------------+

  PURPOSE : Process primitive MMI_WAP_CNF received from  WAP
*/

GLOBAL const void   psa_wap_mmi_cnf (
                                  T_WAP_MMI_CNF *wap_mmi_cnf
                                )
{
  PACCESS(wap_mmi_cnf);
  TRACE_EVENT("wap_mmi_cnf()");


	{
		char temp[50];
		sprintf(temp,"wap_mmi_cnf->event_id %d",wap_mmi_cnf->event_id);
		TRACE_EVENT(temp);	
		sprintf(temp,"wap_mmi_cnf->sdu.l_buf %d",wap_mmi_cnf->sdu.l_buf);
		TRACE_EVENT(temp);	
		sprintf(temp,"wap_mmi_cnf->sdu.buf %s",(char*)wap_mmi_cnf->sdu.buf);
		TRACE_EVENT(temp);	
	}

	PFREE(wap_mmi_cnf);
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)    MODULE  : PSA_WAPP                     |
|                            ROUTINE : psa_wap_dti_cnf              |
+-------------------------------------------------------------------+

  PURPOSE : processes WAP_DTI_CNF received from WAP.

*/

GLOBAL const void psa_wap_dti_cnf( T_WAP_DTI_CNF *wap_dti_cnf )
{
  T_DTI_CONN_LINK_ID link_id = dti_cntrl_get_link_id( DTI_ENTITY_WAP, DTI_INSTANCE_NOTPRESENT, DTI_SUB_NO_NOTPRESENT );

  TRACE_FUNCTION ("psa_wap_dti_cnf()");

  switch( wap_dti_cnf->dti_conn )
  {
  case(WAP_CONNECT_DTI):
    dti_cntrl_entity_connected( link_id, DTI_ENTITY_WAP, DTI_OK );
    break;

  case(WAP_DISCONNECT_DTI):
    dti_cntrl_entity_disconnected( link_id, DTI_ENTITY_WAP );
    break;

  }
	PFREE(wap_dti_cnf);
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)    MODULE  : PSA_WAPP                     |
|                            ROUTINE : psa_wap_dti_ind              |
+-------------------------------------------------------------------+

  PURPOSE : processes WAP_DTI_IND received from WAP.

*/

GLOBAL const void psa_wap_dti_ind( T_WAP_DTI_IND *wap_dti_ind )
{
  T_DTI_CONN_LINK_ID link_id = dti_cntrl_get_link_id( DTI_ENTITY_WAP, DTI_INSTANCE_NOTPRESENT, DTI_SUB_NO_NOTPRESENT );

  TRACE_FUNCTION ("psa_wap_dti_ind()");

  dti_cntrl_entity_disconnected( link_id, DTI_ENTITY_WAP );

	PFREE(wap_dti_ind);
}

#endif

