/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the signalling functions of the
|             protocol stack adapter for the registration part of
|             the SNDCP entity.
+----------------------------------------------------------------------------- 
*/ 

#if defined (GPRS) && defined (DTI)

#ifndef PSA_SNDS_C
#define PSA_SNDS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "aci.h"
/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SMS                 |
| STATE   : finished              ROUTINE : psaSN_CountReq          |
+-------------------------------------------------------------------+

  PURPOSE : Requests SNDCP count.

*/
GLOBAL void psaSN_CountReq ( UBYTE c_id, BOOL reset )
{
  PALLOC (sn_count_req, SN_COUNT_REQ);

  TRACE_FUNCTION ("psaSN_CountReq()");

  sn_count_req -> nsapi   = c_id;

  if( reset )
  {
    sn_count_req -> reset = SN_RESET_YES;
  }
  else
  {
    sn_count_req -> reset = SN_RESET_NO;
  }

  PSENDX (SNDCP, sn_count_req);
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SMS                 |
| STATE   : finished              ROUTINE : psaSN_SwitchReq         |
+-------------------------------------------------------------------+

  PURPOSE : Request of switching DTI peer for a activated PDP context.

*/
GLOBAL void psaSN_SwitchReq ( UBYTE nsapi, 
                              ULONG dti_linkid, 
                              ULONG dti_neighbor, 
                              UBYTE dti_direction )
{
  PALLOC (sn_switch_req, SN_SWITCH_REQ);

  TRACE_FUNCTION ("psaSN_SwitchReq()");

  sn_switch_req -> nsapi          = nsapi;
  sn_switch_req -> dti_linkid     = dti_linkid;
  sn_switch_req -> dti_neighbor   = dti_neighbor;
  sn_switch_req -> dti_direction  = dti_direction;


  PSENDX (SNDCP, sn_switch_req);
}

#endif /* GPRS */
