/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the processing functions for the
|             primitives send to the protocol stack adapter by SNDCP.
+----------------------------------------------------------------------------- 
*/ 

#if defined (GPRS) && defined (DTI)

#ifndef PSA_SNDP_C
#define PSA_SNDP_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_sm.h"
#include "cmh.h"
#include "cmh_sm.h"

#if defined (FF_WAP) || defined (FF_GPF_TCPIP) || defined (FF_SAT_E)
#include "wap_aci.h"
#include "psa_tcpip.h"
#endif /* defined (FF_WAP) || defined (FF_GPF_TCPIP) */

#ifdef FF_GPF_TCPIP
#include "dcm_utils.h"
#endif
#include "dcm_f.h"

/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

EXTERN void cmhSNDCP_Counted( UBYTE nsapi,
                              ULONG octets_uplink,
                              ULONG octets_downlink,
                              ULONG packets_uplink,
                              ULONG packets_downlink );

/*
+-------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SM            |
| STATE   : finished              ROUTINE : psa_sn_count_cnf  |
+-------------------------------------------------------------+

  PURPOSE : processes the SN_COUNT_CNF primitive send by SNDCP.
*/
GLOBAL const void psa_sn_count_cnf ( T_SN_COUNT_CNF *sn_count_cnf )
{

  TRACE_FUNCTION ("psa_sn_count_cnf()");

  cmhSNDCP_Counted( sn_count_cnf->nsapi,
                    sn_count_cnf->octets_uplink,
                    sn_count_cnf->octets_downlink,
                    sn_count_cnf->packets_uplink,
                    sn_count_cnf->packets_downlink );

  TRACE_EVENT_P4("Packet count: UL Octets:%d,DL Octets:%d,UL Packets:%d,DL Packets:%d",
                   sn_count_cnf->octets_uplink,sn_count_cnf->octets_downlink,
                   sn_count_cnf->packets_uplink,sn_count_cnf->packets_downlink);

  PFREE (sn_count_cnf);
}

/*
+-------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SND           |
| STATE   : finished              ROUTINE : psa_sn_switch_cnf |
+-------------------------------------------------------------+

  PURPOSE : processes the SN_SWITCH_CNF primitive send by SNDCP.
*/
GLOBAL const void psa_sn_switch_cnf ( T_SN_SWITCH_CNF *sn_switch_cnf )
{
  T_DTI_ENTITY_ID dti_entity = DTI_ENTITY_IP;
  if(is_gpf_tcpip_call()) {
    GPF_TCPIP_STATEMENT(dti_entity = DTI_ENTITY_TCPIP);
  }
  
  TRACE_FUNCTION ("psa_sn_switch_cnf()");

  cmhSM_context_connected( sn_switch_cnf->nsapi);

  PFREE (sn_switch_cnf);

#if defined (CO_UDP_IP) || defined (FF_GPF_TCPIP)
  /* if WAP over GPRS is in progress, request WAP configuration */
  if (dti_entity EQ pdp_context[work_cids[cid_pointer] - 1].entity_id)
  {
    psaTCPIP_Configure(NULL, pdp_context[work_cids[cid_pointer] - 1].allocated_pdp_addr,
                       NULL, NULL, NULL, 1500, cmhSM_IP_activate_cb );
  }
#endif /* CO_UDP_IP || FF_GPF_TCPIP */
}

#endif /* GPRS */
