/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the signalling functions of the
|             protocol stack adapter for the registration part of
|             GPRS session management.
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef PSA_SMS_C
#define PSA_SMS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "aci.h"
#include "psa.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "gaci_cmh.h"
#include "psa_gmm.h"
#include "psa_sm.h"
#include "cmh.h"
#include "gaci.h"
#include "gaci_cmh.h"
#include "cmh_sm.h"

/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/


/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SMS                 |
| STATE   : finished              ROUTINE : psaSM_ActivateReq       |
+-------------------------------------------------------------------+

  PURPOSE : MS initiates a PDP context activation

*/
GLOBAL void psaSM_ActivateReq ( SHORT cid,
                                UBYTE ppp_hc,
                                UBYTE msid,
                                UBYTE hcomp,
                                ULONG dti_linkid,
                                ULONG dti_neighbor,
                                UBYTE dti_direction )
{
  USHORT PCO_length = pdp_context[cid - 1].user_pco.len << 3;

  TRACE_FUNCTION ("psaSM_ActivateReq()");

/*
 *-------------------------------------------------------------------
 * create and send primitive for context activation
 *-------------------------------------------------------------------
 */
   
  {
    PALLOC_SDU ( smreg_pdp_activate_req, SMREG_PDP_ACTIVATE_REQ, PCO_length );

    smreg_pdp_activate_req -> direc       = smShrdPrm.direc;
    smreg_pdp_activate_req -> ppp_hc      = ppp_hc;
    smreg_pdp_activate_req -> msid        = msid;
    smreg_pdp_activate_req -> hcomp       = hcomp;
    smreg_pdp_activate_req -> dcomp       = (1 EQ cmhSM_Get_d_comp()) ?
                                              SMREG_COMP_BOTH_DIRECT: SMREG_COMP_NEITHER_DIRECT;

    smreg_pdp_activate_req -> pdp_type    = cmhSM_Get_pdp_type();
    smreg_pdp_activate_req -> smreg_nsapi = pdp_context[cid - 1].nsapi;
    smreg_pdp_activate_req -> smreg_ti    = gprs_call_table[current_gprs_ct_index].sm_ind.smreg_ti;


    cmhSM_Get_QOS             ( &smreg_pdp_activate_req -> smreg_qos );
    cmhSM_Get_QOS_min         ( &smreg_pdp_activate_req -> smreg_min_qos );
    cmhSM_Get_pdp_address     ( &smreg_pdp_activate_req -> pdp_address );
    cmhSM_Get_smreg_apn       ( &smreg_pdp_activate_req -> smreg_apn );

    smreg_pdp_activate_req -> dti_linkid    = dti_linkid;
    smreg_pdp_activate_req -> dti_neighbor  = dti_neighbor;
    smreg_pdp_activate_req -> dti_direction = dti_direction;

    smreg_pdp_activate_req -> sdu.l_buf = PCO_length;
    smreg_pdp_activate_req -> sdu.o_buf = 0;

    if ( PCO_length )
    {
      memcpy(&smreg_pdp_activate_req -> sdu.buf,
              pdp_context[cid - 1].user_pco.pco,
              pdp_context[cid - 1].user_pco.len);
    }

    psaGMM_NetworkRegistrationStatus(SMREG_PDP_ACTIVATE_REQ, smreg_pdp_activate_req);

    PSEND (hCommSM, smreg_pdp_activate_req);
  }
}


/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SMS                 |
| STATE   : finished              ROUTINE : psaSM_PDP_Deactivate    |
+-------------------------------------------------------------------+

  PURPOSE : MS initiates a PDP context deactivation

*/
GLOBAL void psaSM_PDP_Deactivate ( USHORT nsapi_set, UBYTE smreg_local )
{

  TRACE_FUNCTION ("psaSM_PDP_Deactivate()");

/*
 *-------------------------------------------------------------------
 * create and send primitive for context deactivation
 *-------------------------------------------------------------------
 */
  {
    PALLOC (smreg_pdp_deactivate_req, SMREG_PDP_DEACTIVATE_REQ);

    smreg_pdp_deactivate_req -> nsapi_set   = nsapi_set;
    smreg_pdp_deactivate_req -> smreg_local = smreg_local;

    PSEND (hCommSM, smreg_pdp_deactivate_req);
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_SMS                 |
| STATE   : finished              ROUTINE : psaSM_PDP_No_activate   |
+-------------------------------------------------------------------+

  PURPOSE : GACI is not able to set up another context

*/
GLOBAL void psaSM_PDP_No_activate ( UBYTE smreg_ti, USHORT smreg_cause )
{

  TRACE_FUNCTION ("psaSM_PDP_No_activate()");

/*
 *-------------------------------------------------------------------
 *  create and send primitive for rejection 
 *  the network requested context activation
 *-------------------------------------------------------------------
 */
  {
    PALLOC (smreg_pdp_activate_res, SMREG_PDP_ACTIVATE_RES);

    smreg_pdp_activate_res -> smreg_ti    = smreg_ti;
    smreg_pdp_activate_res -> smreg_cause = smreg_cause;

    PSEND (hCommSM, smreg_pdp_activate_res);
  }
}

#endif  /* GPRS */
/*==== EOF ========================================================*/

