/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Definitions for the protocol stack adapter 
|             GPRS session management ( SM ).
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef PSA_SM_H
#define PSA_SM_H



/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/
typedef struct SMSetParm
{
  T_SMREG_PDP_ACTIVATE_REQ *pact;    /* primitive parameter */
  T_SMREG_PDP_ACTIVATE_REQ act;     /* primitive parameter */
} T_SM_SET_PRM;

typedef struct SMShrdParm
{
  /* state parameter */
  UBYTE             direc;          /* parameter for primitive SMREG_PDP_ACTIVATE_REQ */

  /* set parameter */
  UBYTE             owner;          /* identifies the used set */
  T_SM_SET_PRM setPrm[OWN_MAX];     /* possible sets */

  /* answer parameter */
  T_SMREG_PDP_ACTIVATE_REJ *pdp_rej;/* primitive parameter */
  T_SMREG_PDP_ACTIVATE_IND  act_ind;/* primitive parameter */
  USHORT            nsapi_set;      /* 1 - 15 N-SAPI - ...*/
  T_QOS             mod_qos;        /* QOS - modify indication */

} T_SM_SHRD_PRM;

/*==== PROTOTYPES =================================================*/

void  psaSM_Init            ( void );
/*SHORT psaSM_PDP_Activate_IP ( SHORT cid );*/

#ifdef DTI
EXTERN void psaSNDCP_Dti_Req( T_DTI_CONN_LINK_ID  link_id, UBYTE peer );
EXTERN void psaSM_PDP_Deactivate ( USHORT nsapi_set, UBYTE smreg_local );
EXTERN void psaSM_PDP_No_activate ( UBYTE smreg_ti, USHORT smreg_cause );
#endif /*DTI*/
EXTERN void psaSM_ActivateReq ( SHORT cid,
                                UBYTE ppp_hc,
                                UBYTE msid,
                                UBYTE hcomp,
                                ULONG dti_linkid, 
                                ULONG dti_neighbor, 
                                UBYTE dti_direction );

/*==== EXPORT =====================================================*/

#ifdef PSA_SMF_C

GLOBAL T_SM_SHRD_PRM smShrdPrm;

#else

EXTERN T_SM_SHRD_PRM smShrdPrm;

#endif /* PSA_SMF_C */

#endif /* PSA_SM_H */

#endif  /* GPRS */
/*==== EOF =======================================================*/
