/*
+------------------------------------------------------------------------------
|  File:       psa_pktios.c
+------------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG.
+------------------------------------------------------------------------------
| Purpose:     This module defines the signalling functions of the
|              protocol stack adapter for packet i/o managment (MNPKTIO)
+------------------------------------------------------------------------------
*/

#ifdef GPRS
#ifdef FF_PKTIO
#ifndef PSA_PKTIOS_C
#define PSA_PKTIOS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "aci_lst.h"
#include "aci.h"
#include "psa.h"
#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"
#include "psa_pktio.h"
#include "cmh.h"


/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/
   
/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_PKTIOS              |
| STATE   : finished              ROUTINE : psaPKT_ConnectRej       |
+-------------------------------------------------------------------+

  PURPOSE : Indicates that ACI can not handle a DTI connection with PKTIO

*/
GLOBAL void psaPKT_ConnectRej ( UBYTE device_no)
{
  TRACE_FUNCTION ("psaPKT_ConnectRej()");
  {
    PALLOC ( pkt_connect_rej, PKT_CONNECT_REJ);
    pkt_connect_rej->device_no = device_no;
    PSEND (hCommPKTIO, pkt_connect_rej);
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_PKTIOS              |
| STATE   : finished              ROUTINE : psaPKT_ConnectRes       |
+-------------------------------------------------------------------+

  PURPOSE : Response to PKT_CONNECT_IND sent by PKTIO with confirmed
            DIO capabilities

*/
GLOBAL void psaPKT_ConnectRes ( UBYTE device_no, 
                                T_ACI_PKTIO_CAP * pktio_cap)
{
  TRACE_FUNCTION ("psaPKT_ConnectRes()");
  {
    PALLOC ( pkt_connect_res, PKT_CONNECT_RES);
    memcpy(&pkt_connect_res->dio_dcb,pktio_cap,sizeof(T_ACI_PKTIO_CAP));
    pkt_connect_res->device_no = device_no;
    PSEND (hCommPKTIO, pkt_connect_res);
  }
}


/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_PKTIOS              |
| STATE   : finished              ROUTINE : psaPKT_DTICloseReq      |
+-------------------------------------------------------------------+

  PURPOSE : Request closing of DTI connection with PKTIO

*/
GLOBAL void psaPKT_DTICloseReq ( UBYTE device_no)
{
  TRACE_FUNCTION ("psaPKT_DTICloseReq()");
  {
    PALLOC ( pkt_dti_close_req, PKT_DTI_CLOSE_REQ);
    pkt_dti_close_req->device_no = device_no;
    PSEND (hCommPKTIO, pkt_dti_close_req);
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_PKTIOS              |
| STATE   : finished              ROUTINE : psaPKT_DTIOpenReq       |
+-------------------------------------------------------------------+

  PURPOSE : Request opening of DTI connection with PKTIO

*/
GLOBAL void psaPKT_DTIOpenReq ( UBYTE device_no, const char * peer_name,
                                ULONG link_id, UBYTE dti_direction)
{
  TRACE_FUNCTION ("psaPKT_DTIOpenReq()");
  {
    PALLOC ( pkt_dti_open_req, PKT_DTI_OPEN_REQ);
    pkt_dti_open_req->device_no = device_no;
    pkt_dti_open_req->peer = (ULONG)peer_name;
    pkt_dti_open_req->link_id = link_id;
    pkt_dti_open_req->dti_direction = dti_direction;

    PSEND (hCommPKTIO, pkt_dti_open_req);
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : PSA_PKTIOS              |
| STATE   : finished              ROUTINE : psaPKT_ModifyReq        |
+-------------------------------------------------------------------+

  PURPOSE : Request modification of channel parameter 
            !!Attention!! currently not used
*/
GLOBAL void psaPKT_ModifyReq ( UBYTE device_no, 
                               T_ACI_PKTIO_CAP * pktio_cap)
{
  TRACE_FUNCTION ("psaPKT_ModifyReq()");
  {
    PALLOC ( pkt_modify_req, PKT_MODIFY_REQ);
    pkt_modify_req->device_no = device_no;
    memcpy(&pkt_modify_req->dio_dcb,pktio_cap,sizeof(T_ACI_PKTIO_CAP));
    PSEND (hCommPKTIO, pkt_modify_req);
  }
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)            MODULE  : PSA_PKTIOS             |
| STATE   : finished               ROUTINE : psaPKT_Dti_Req         |
+-------------------------------------------------------------------+

  PURPOSE : Request for DTI connection by DTI managment

*/
GLOBAL void psaPKT_Dti_Req ( ULONG  link_id, UBYTE  peer, 
                             T_DTI_MNG_PKT_MODE con_mode)
{
  UBYTE device_no;
  T_DTI_CNTRL  device_info;
  
  TRACE_FUNCTION ("psaPKT_Dti_Req()"); 
      
  dti_cntrl_get_info_from_dti_id(EXTRACT_DTI_ID(link_id), &device_info);
  device_no = device_info.dev_no;
  if(con_mode EQ PKT_CONNECT_DTI)
  {
    dti_cntrl_set_conn_parms((T_DTI_CONN_LINK_ID)link_id, DTI_ENTITY_PKTIO,
                              device_info.dev_no, device_info.sub_no);

    psaPKT_DTIOpenReq (device_no,dti_entity_name[peer].name,
                       link_id, DTI_CHANNEL_TO_LOWER_LAYER);
  }
  else
  { 
    psaPKT_DTICloseReq(device_no);                           
  }
}


#endif /* FF_PKTIO */
#endif  /* GPRS */
/*==== EOF ========================================================*/

