/*
+------------------------------------------------------------------------------
|  File:       psa_pktio.h
+------------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG.
+------------------------------------------------------------------------------
| Purpose:     Definitions for the protocol stack adapter 
|              packet i/o managment (MNPKTIO).
+------------------------------------------------------------------------------
*/

#ifdef GPRS
#ifdef FF_PKTIO
#ifndef PSA_PKTIO_H
#define PSA_PKTIO_H



/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/
typedef T_dio_dcb T_ACI_PKTIO_CAP; /* structure for capabilities of DIO */
typedef struct
{
    UBYTE device_no;
    T_ACI_PKTIO_CAP pktio_cap;
} T_ACI_PKTIO;
/* only for test purposes */
typedef enum{
   PKT_CONNECT_DTI = 0,
   PKT_DISCONNECT_DTI
}T_DTI_MNG_PKT_MODE;




/*==== PROTOTYPES =================================================*/

EXTERN void psaPKT_ConnectRej ( UBYTE device_no);
EXTERN void psaPKT_ConnectRes ( UBYTE device_no, T_ACI_PKTIO_CAP * pktio_cap);
EXTERN void psaPKT_DTICloseReq ( UBYTE device_no);
EXTERN void psaPKT_DTIOpenReq ( UBYTE device_no, const char * peer_name,
                                ULONG link_id, UBYTE dti_direction);
EXTERN void psaPKT_ModifyReq ( UBYTE device_no, T_ACI_PKTIO_CAP * pktio_cap);

EXTERN  void psaPKT_Dti_Req ( ULONG  link_id, UBYTE  peer, T_DTI_MNG_PKT_MODE con_mode);

/*==== EXPORT =====================================================*/


#endif /* PSA_PKTIO_H */
#endif /* FF_PKTIO */
#endif  /* GPRS */
/*==== EOF =======================================================*/
