/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  PSA_LC
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the functions for the protocol
|             stack adapter for location service
+----------------------------------------------------------------------------- 
*/ 

#ifndef PSA_LC_C
#define PSA_LC_C
#endif

#if defined FF_EOTD
#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif

#define ACI_MEMBER

#undef TRACING

/*==== INCLUDES ===================================================*/

#include <string.h>
#include <stdlib.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "aci.h"
#include "psa.h"
#include "psa_mm.h"
#include "psa_util.h"

#include "cmh_lc.h"
#include "l4_tim.h"
#include "aci_lst.h"

/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/
EXTERN T_ACI_LIST    *ati_src_list;

/*==== VARIABLES ==================================================*/
EXTERN USHORT used_lc_callref;
EXTERN UBYTE    srcId_cb;

/*==== FUNCTIONS ==================================================*/
/* for hard coded AT commands 
LOCAL UBYTE search_tim_handl(void);
*/
EXTERN UBYTE search_tim_handl(void);
/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : PSA_LC                  |
|                                 ROUTINE : search_tim_handl        |
+-------------------------------------------------------------------+

  PURPOSE : This function searchs an unused timer handle for LC
*/
LOCAL const UBYTE lc_timer_list[]=
{
  ACI_LC_1,
  ACI_LC_2,
  ACI_LC_3,
  ACI_LC_4,
  ACI_LC_5
};
/* for hard coded AT commands 
LOCAL UBYTE search_tim_handl(void)
 */
EXTERN UBYTE search_tim_handl(void)
{
   T_LOC_SERV_PARA *lc_list = 0;
   T_LOC_SERV_CLIENT *lc_client = 0;
   BOOL h_flag = FALSE;
   char i;

   lc_list = &locServPrm;       /* global structure LC parameters */

   for(i= 0;i<5;i++)
   {
TRACE_EVENT_P1("i=%d",i);
vsi_t_sleep(VSI_CALLER 10);
       lc_client = lc_list->clients;
       if(lc_client EQ NULL)
          return (0);
      do
      {
TRACE_EVENT_P2("lc_client=%08x next=%08x",lc_client, lc_client->next);
vsi_t_sleep(VSI_CALLER 10);
        if(lc_client->period_upd_timer EQ lc_timer_list[i])
          {
              h_flag = TRUE;
              break;
          }
          lc_client =  lc_client->next;
      }
      while(lc_client NEQ NULL);

      if(!h_flag)
        return lc_timer_list[i];
   }
   return(0);
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : PSA_LC                  |
|                                 ROUTINE : psaLC_PosDataInd        |
+-------------------------------------------------------------------+

  PURPOSE : This function processes the primitive MNLC_SMS_MEAS_CNF
*/
GLOBAL const void psa_mnlc_sms_meas_cnf
                               (T_MNLC_SMS_MEAS_CNF *mnlc_sms_meas_cnf )
{
   T_LOC_SERV_PARA *p_lsprm = 0;
   T_LOC_SERV_CLIENT *p_client = 0;
   ULONG timer = 0;
   T_ACI_CME_ERR err;
   T_ATI_SRC_PARAMS *src_params = find_element( ati_src_list, locServPrm.lc_src_id, search_ati_src_id);
   
   TRACE_FUNCTION ("psa_mnlc_sms_meas_cnf()");

   if(mnlc_sms_meas_cnf->data_valid EQ DATA_VALID)
   {
      p_lsprm = &locServPrm;       /* global structure LC parameters */
      if(p_lsprm->lc_callReference EQ mnlc_sms_meas_cnf->reference)
      {
         used_lc_callref = used_lc_callref & ~(0x01 << p_lsprm->lc_callReference);
         p_lsprm->lc_callReference = -1;
         /* send cursorSmsText via sms...destination address */
        cmhSMS_MEASdeliver(mnlc_sms_meas_cnf->sms_text);
      }
      else
     {
        p_client = p_lsprm->clients;
        if(p_client NEQ NULL)
       {
         do
         {
           TRACE_EVENT_P2("p_client=%08x next=%08x", p_client, p_client->next);
           if(p_client->lc_clientReference EQ mnlc_sms_meas_cnf->reference)
            { /* reset callreference of client */
               used_lc_callref = used_lc_callref & ~(0x01 << p_client->lc_clientReference);
               p_client->lc_clientReference = -1;
               /* send cursorSmsText via sms...destination address */
               cmhSMS_MEASdeliver(mnlc_sms_meas_cnf->sms_text);
               /* check wether start of periodic update timer */
               if(eotd_periodic_update_flag EQ PERIODIC_UPDATE_ON AND
                  p_client->period_upd_status EQ PERIODIC_UP_ACTIVE)
               {
                  timer = p_client->period_upd_value*60*1000;/* sec */
                  if (p_client->period_upd_timer EQ 0)
                    p_client->period_upd_timer = search_tim_handl();
                  if(p_client->period_upd_timer NEQ 0)
                  {
                    TRACE_EVENT_P2("SMS preriodic timer started index=%d timer=%lu",p_client->period_upd_timer, timer);
                    TIMERSTART( timer, p_client->period_upd_timer);
                  }
               }
               break;
            }
            p_client = p_client->next;
         }
         while(p_client NEQ NULL);
        }
      }
   }
   else /* !DATA_VALID */
   {
      p_lsprm = &locServPrm;       /* global structure LC parameters */
      if(p_lsprm->lc_callReference EQ mnlc_sms_meas_cnf->reference)
      {
         used_lc_callref = used_lc_callref & ~(0x01 << p_lsprm->lc_callReference);
         p_lsprm->lc_callReference = -1;
      }
      else
      {
        p_client = p_lsprm->clients;
        if(p_client NEQ NULL)
        {
         do
         {
           TRACE_EVENT_P2("p_client=%08x next=%08x", p_client, p_client->next);
#if 0           
           if(p_client->lc_clientReference EQ mnlc_sms_meas_cnf->reference)
#else
           if(p_client->lc_clientReference NEQ -1)
#endif 
          { /* reset callreference of client */
               used_lc_callref = used_lc_callref & ~(0x01 << p_client->lc_clientReference);

               p_client->lc_clientReference = -1;
               /* check wether start of periodic update timer */
               if(eotd_periodic_update_flag EQ PERIODIC_UPDATE_ON AND
                  p_client->period_upd_status EQ PERIODIC_UP_ACTIVE)
               {
                  timer = 5000;/* restart timer to repeat measurement when the failing condtion no longer exists  */
                  if (p_client->period_upd_timer EQ 0)
                    p_client->period_upd_timer = search_tim_handl();
                  if(p_client->period_upd_timer NEQ 0)
                  {
                    TIMERSTART( timer, p_client->period_upd_timer);
                    TRACE_EVENT_P2("SMS timer restarted with index=%d timer=%d",p_client->period_upd_timer, timer);
                  }
               }
               break;
            }
            p_client = p_client->next;
         }
         while(p_client NEQ NULL);
        }
      }
      if(src_params->curAtCmd EQ AT_CMD_CLPS)
      {
         srcId_cb = locServPrm.lc_src_id;
         err = CME_ERR_Unknown;
         rCI_PlusCME(AT_CMD_CLPS,  err);
      }
   }
    
PFREE(mnlc_sms_meas_cnf);
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : PSA_LC                  |
|                                 ROUTINE : psaLC_posDataReq        |
+-------------------------------------------------------------------+

  PURPOSE : This function handle the position data request
            when the timer is expired
*/
GLOBAL void psaLC_posDataReq (USHORT index)
{
   T_LOC_SERV_PARA *p_lsprm = 0;
   T_LOC_SERV_CLIENT *p_client = 0;
   USHORT lc_callref;

   TRACE_FUNCTION ("psaLC_posDataReq()");

   p_lsprm = &locServPrm;       /* global structure LC parameters */
   p_client = p_lsprm->clients;
   if(p_client NEQ NULL)
   {
     do
     {
       TRACE_EVENT_P4("p_client=%08x next=%08x handle=%d index=%d", 
                p_client, p_client->next, p_client->period_upd_timer, index);
       if(p_client->period_upd_timer EQ index)
        {
            p_client->period_upd_timer = 0;
             /* start position data request */
            lc_callref = (USHORT)lc_callref_init();
            TRACE_EVENT_P1("lc_callref=%d", lc_callref);
            if(lc_callref NEQ 0)
            {
              p_client->lc_clientReference = lc_callref;
              cmhLC_posDataReq (p_client->client_id.address,
              lc_callref);
            }
        }
        p_client =  p_client->next;
      }
      while(p_client NEQ NULL);
   }
}



#endif /* FF_EOTD */


/*==== EOF ========================================================*/

