/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  PSA_BTIS
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the signalling functions of the
|             protocol stack adapter for BTI.
+----------------------------------------------------------------------------- 
*/ 

#ifndef PSA_BTIS_C
#define PSA_BTIS_C
#endif

#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif

#define ACI_MEMBER

/*==== INCLUDES ===================================================*/
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci_fd.h"
#include "aci.h"
#include "psa.h"
#include "psa_bti.h"
/*==== CONSTANTS ==================================================*/
/*==== TYPES ======================================================*/
/*==== EXPORT =====================================================*/
/*==== VARIABLES ==================================================*/
/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)    MODULE  : PSA_BTI                      |
|                            ROUTINE : psaBTI_Dti_Req               |
+-------------------------------------------------------------------+

  PURPOSE : connect or disconnect BTI (depends on dti_conn).
*/

GLOBAL void psaBTI_Dti_Req(
  UBYTE dti_id,
  T_DTI_ENTITY_ID peer_to_connect_to,
  UBYTE dti_conn
  )
{
  CHAR *p_ent_name;

  TRACE_FUNCTION ("psaBTI_Dti_Req()");

  {
    PALLOC (btp_dti_req, BTP_DTI_REQ);

    switch( peer_to_connect_to )
    {
    case( DTI_ENTITY__ACI ):
      p_ent_name = &ACI_NAME[0];
      break;
    case( DTI_ENTITY__L2R ):
      p_ent_name = &L2R_NAME[0];
      break;
    case( DTI_ENTITY__TRA ):
      p_ent_name = &TRA_NAME[0];
      break;
    case( DTI_ENTITY__T30 ):
      p_ent_name = &T30_NAME[0];
      break;
#ifdef FF_TRACE_OVER_MTST
    case( DTI_ENTITY__MTST):
      p_ent_name = &MTST_NAME[0];
      break;
#endif /* FF_TRACE_OVER_MTST */
#ifdef GPRS
    case( DTI_ENTITY__PPPS ):
      p_ent_name = &PPP_NAME[0];
      break;
#endif  /* GPRS */

    default:
      TRACE_EVENT("unknown connection peer Id: BTP_DTI_REQ not sent");
      PFREE(btp_dti_req);
      return;
    }

    strcpy((CHAR*)btp_dti_req->entity_name, p_ent_name);
    btp_dti_req->dti_conn      = dti_conn;
    btp_dti_req->link_id       = dti_id;
    btp_dti_req->dti_direction = DTI_CHANNEL_TO_HIGHER_LAYER;

    PSENDX (BTI, btp_dti_req);
  }
}
/*==== EOF ========================================================*/

