/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  PSA_BTIP
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the processing functions for the
|             primitives send to the protocol stack adapter by BTI.
+----------------------------------------------------------------------------- 
*/ 

#ifndef PSA_BTIP_C
#define PSA_BTIP_C
#endif

#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif

#define ACI_MEMBER

/*==== INCLUDES ===================================================*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include "typedefs.h"
#include "pconst.cdg"
#include "mconst.cdg"
#include "message.h"
#include "ccdapi.h"
#include "vsi.h"
#include "custom.h"
#include "gsm.h"
#include "prim.h"
#include "cnf_aci.h"
#include "mon_aci.h"
#include "pei.h"
#include "tok.h"
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci_fd.h"
#include "aci_io.h"
#include "aci.h"
#include "psa.h"
#include "cmh.h"

#include "aci_lst.h"
#include "psa_uart.h"
#include "cmh_uart.h"

#include "psa_cc.h"

#include "psa_bti.h"

/*==== CONSTANTS ==================================================*/
/*==== TYPES ======================================================*/
/*==== EXPORT =====================================================*/
/*==== VARIABLES ==================================================*/
/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : PSA_BTI                 |
|                                 ROUTINE : psa_btp_dti_cnf         |
+-------------------------------------------------------------------+

  PURPOSE : processes the BTP_DTI_CNF primitive sent by BTI.

*/

GLOBAL const void psa_btp_dti_cnf (T_BTP_DTI_CNF *btp_dti_cnf)
{
  TRACE_FUNCTION("psa_btp_dti_cnf");

  switch( btp_dti_cnf->dti_conn )
  {
  case BTI_CONNECT_DTI:
    /* tell DTI MNG that connection is closed */
    dti_entity_connected (
      (UBYTE)btp_dti_cnf->link_id,
      DTI_ENTITY_BLUETOOTH,
      DTI_MNG_AWAIT_UNKNOWN
      );
    break;

  case BTI_DISCONNECT_DTI:
    /* tell DTI MNG that connection is established */
    dti_entity_connected( (UBYTE)btp_dti_cnf->link_id, CONNECTED, UNIT_BLUETOOTH );
    break;

  case BTI_ERROR_DTI:
    TRACE_EVENT ("psa_btp_dti_cnf(): unable to open dti_connection.");

    /* tell DTI manager that establishment has failed */
    dti_entity_connected( (UBYTE)btp_dti_cnf->link_id, ERROR, UNIT_BLUETOOTH);
    break;

  default:
    TRACE_ERROR ("psa_btp_dti_cnf(): unknown dti_conn parameter!");
    break;
  }

  PFREE (btp_dti_cnf);
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : PSA_BTI                 |
|                                 ROUTINE : psa_btp_dti_ind         |
+-------------------------------------------------------------------+

  PURPOSE : processes the BTI_DTI_IND primitive sent by BTI.

*/

GLOBAL const void psa_btp_dti_ind( T_BTP_DTI_IND *btp_dti_ind )
{
  TRACE_FUNCTION("psa_btp_dti_ind");

  switch( btp_dti_ind->dti_conn )
  {
  case BTI_CONNECT_DTI:
    /* tell DTI MNG that connection is closed */
    dti_entity_disconnected (
      (UBYTE)btp_dti_ind->link_id,
      UNIT_BLUETOOTH,
      DTI_MNG_AWAIT_UNKNOWN
      );
    break;

  case BTI_DISCONNECT_DTI:
    /* tell DTI MNG that connection is established */
    dti_entity_connected( (UBYTE)btp_dti_ind->link_id, CONNECTED, UNIT_BLUETOOTH );
    break;

  case BTI_ERROR_DTI:
    TRACE_EVENT ("psa_btp_dti_ind(): unable to open dti_connection.");

    /* tell DTI manager that establishment has failed */
    dti_entity_connected( (UBYTE)btp_dti_ind->link_id, ERROR, UNIT_BLUETOOTH );
    break;

  default:
    TRACE_ERROR ("psa_btp_dti_ind(): unknown dti_conn parameter!");
    break;
  }

  PFREE(btp_dti_ind);
}

/*==== EOF =========================================================*/

