/*
+-----------------------------------------------------------------------------
|  Project :  ACI
|  Modul   :  psa_aaa
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  This modul ...
+-----------------------------------------------------------------------------
*/
#ifndef PSA_AAAS_C
#define PSA_AAAS_C
#endif

#include "aci_all.h"

/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */

#include "aci.h"
#include "aci_lst.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"
#include "psa_uart.h"
#include "ati_io.h"

#include "aci_mem.h"

#include "ati_src_riv.h"
#include "psa_aaa.h"


/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_open_port_cnf |
+-----------------------------------------------------------------------+

  PURPOSE : - called by psa_aaa_open_port_req() !
*/
GLOBAL const void  psaAAA_open_port_cnf     (UBYTE   port_number,
                                             UBYTE   sub_no,
                                                         UBYTE   dti_id)
{
  TRACE_FUNCTION("psaAAA_open_port_cnf()");

  TRACE_EVENT_P2("port_number: %d, dti_id: %d", port_number, dti_id);

  {
    PALLOC (aaa_open_port_cnf, AAA_OPEN_PORT_CNF);

    aaa_open_port_cnf->port_number = port_number;
    aaa_open_port_cnf->sub_no      = sub_no;
    aaa_open_port_cnf->dti_id      = dti_id;

#ifdef FF_ESIM
    PSENDX (ESIM, aaa_open_port_cnf);
#else
    PSENDX (AAA, aaa_open_port_cnf);
#endif
  }
}

/*
+------------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa                |
| STATE   : code                        ROUTINE : psa_aaa_close_port_cnf |
+------------------------------------------------------------------------+

  PURPOSE : - called by psa_aaa_close_port_req() !
*/
GLOBAL const void  psaAAA_close_port_cnf    (UBYTE   port_number,
                                           UBYTE   sub_no)

{
  TRACE_FUNCTION("psaAAA_close_port_cnf()");

  TRACE_EVENT_P1("port_number: %d", port_number);

  {
    PALLOC (aaa_close_port_cnf, AAA_CLOSE_PORT_CNF);

    aaa_close_port_cnf->port_number = port_number;
    aaa_close_port_cnf->sub_no      = sub_no;

#ifdef FF_ESIM
    PSENDX (ESIM, aaa_close_port_cnf);
#else
    PSENDX (AAA, aaa_close_port_cnf);
#endif
  }
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_cmd_cnf       |
+-----------------------------------------------------------------------+

  PURPOSE : - called by riv_src_result_cb()
*/
GLOBAL const void  psaAAA_cmd_cnf     (UBYTE     port_number,
                                     UBYTE   sub_no,
                                     USHORT  result_len,
                                     UBYTE  *cmd_result)
{
  TRACE_FUNCTION("psaAAA_cmd_cnf()");

  TRACE_EVENT_P2("port_number: %d, cmd_result: %s", port_number, cmd_result);

  {
    PALLOC (aaa_cmd_cnf, AAA_CMD_CNF);

    aaa_cmd_cnf->port_number = port_number;
    aaa_cmd_cnf->sub_no      = sub_no;
    aaa_cmd_cnf->result_len  = result_len;
    memcpy (aaa_cmd_cnf->cmd_result, cmd_result, result_len);

#ifdef FF_ESIM
    PSENDX (ESIM, aaa_cmd_cnf);
#else
    PSENDX (AAA, aaa_cmd_cnf);
#endif
  }
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_pres_cnf      |
+-----------------------------------------------------------------------+

  PURPOSE : - called by riv_src_result_cb()
*/
GLOBAL const void  psaAAA_pres_ind   (UBYTE   port_number,
                                      UBYTE   sub_no,
                                        USHORT  result_len,
                                        UBYTE    *cmd_result)
{
  TRACE_FUNCTION("psaAAA_pres_ind()");

  TRACE_EVENT_P2("port_number: %d, cmd_result: %s", port_number, cmd_result);

  {
    PALLOC (psa_aaa_pres_ind, AAA_PRES_IND);

    psa_aaa_pres_ind->port_number = port_number;
    psa_aaa_pres_ind->sub_no      = sub_no;
    psa_aaa_pres_ind->result_len  = result_len;
    memcpy (psa_aaa_pres_ind->cmd_result, cmd_result, result_len);

#ifdef FF_ESIM
    PSENDX (ESIM, psa_aaa_pres_ind);
#else
    PSENDX (AAA, psa_aaa_pres_ind);
#endif
  }
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_ures_ind      |
+-----------------------------------------------------------------------+

  PURPOSE : - called by riv_src_result_cb()
*/
GLOBAL const void  psaAAA_ures_ind   (UBYTE   port_number,
                                      UBYTE   sub_no,
                                        USHORT  result_len,
                                        UBYTE    *cmd_result)
{
  TRACE_FUNCTION("psaAAA_ures_ind()");

  TRACE_EVENT_P2("port_number: %d, cmd_result: %s", port_number, cmd_result);

  {
    PALLOC (psa_aaa_ures_ind, AAA_URES_IND);

    psa_aaa_ures_ind->port_number = port_number;
    psa_aaa_ures_ind->sub_no      = sub_no;
    psa_aaa_ures_ind->result_len  = result_len;
    memcpy (psa_aaa_ures_ind->cmd_result, cmd_result, result_len);

#ifdef FF_ESIM
    PSENDX (ESIM, psa_aaa_ures_ind);
#else
    PSENDX (AAA, psa_aaa_ures_ind);
#endif
  }
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_dti_ind       |
+-----------------------------------------------------------------------+

  PURPOSE : - called by dti_cntrl_maintain_entity(), which itself is registered
              as a call back funcion at the DTI connection manager
*/
GLOBAL const void  psaAAA_dti_ind     (ULONG            link_id,
                                     T_DTI_ENTITY_ID  peer_ent_id)
{
  UBYTE         dti_id = EXTRACT_DTI_ID(link_id);
  T_DTI_CNTRL   info;
  CHAR         *entity_name = dti_entity_name[peer_ent_id].name;

  TRACE_FUNCTION("psaAAA_dti_ind()");

  dti_cntrl_get_info_from_dti_id (dti_id, &info);
  /*
   *  info->dev_no == port_number
   */
  TRACE_EVENT_P3("port_number: %d, link_id: %d, connect with: %s", info.dev_no, link_id, entity_name);
  /*
   * just to remember the link_id
   */
  dti_cntrl_set_conn_parms (link_id,
                            DTI_ENTITY_AAA,
                            info.dev_no,
                            info.sub_no);

  {
    PALLOC (psa_aaa_dti_ind, AAA_DTI_IND);

    psa_aaa_dti_ind->port_number = info.dev_no;
    psa_aaa_dti_ind->sub_no      = info.sub_no;
    psa_aaa_dti_ind->link_id     = link_id;
    strcpy ((char *)psa_aaa_dti_ind->entity_name, entity_name);

#ifdef FF_ESIM
   PSENDX (ESIM, psa_aaa_dti_ind);
#else
   PSENDX (AAA, psa_aaa_dti_ind);
#endif
  }
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)             MODULE  : psa_aaa                |
| STATE   : code                       ROUTINE : psa_aaa_disconnect_ind |
+-----------------------------------------------------------------------+

  PURPOSE : - called by dti_cntrl_maintain_entity(), which itself is registered
              as a call back funcion at the DTI connection manager
*/
GLOBAL const void  psaAAA_disconnect_ind (ULONG link_id)
{
  UBYTE        dti_id = EXTRACT_DTI_ID(link_id);
  T_DTI_CNTRL  info;

  TRACE_FUNCTION("psaAAA_disconnect_ind()");

  dti_cntrl_get_info_from_dti_id (dti_id, &info);

  {
    PALLOC (psa_aaa_disconnect_ind, AAA_DISCONNECT_IND);

    psa_aaa_disconnect_ind->port_number = info.dev_no;
    psa_aaa_disconnect_ind->sub_no      = info.sub_no;
    psa_aaa_disconnect_ind->link_id     = link_id;

#ifdef FF_ESIM
    PSENDX (ESIM, psa_aaa_disconnect_ind);
#else
    PSENDX (AAA, psa_aaa_disconnect_ind);
#endif
  }
}
