/*
+-----------------------------------------------------------------------------
|  Project :  ACI
|  Modul   :  psa_aaa
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  This modul ...
+-----------------------------------------------------------------------------
*/

#ifdef DTI

#ifndef PSA_AAAP_C
#define PSA_AAAP_C
#endif

#include "aci_all.h"

/*==== INCLUDES ===================================================*/
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "dti.h"      /* functionality of the dti library */

#include "aci.h"
#include "aci_lst.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"
#include "psa_uart.h"
#include "ati_io.h"

#include "aci_mem.h"

#include "ati_src_riv.h"
#include "psa_aaa.h"


/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_cmd_req       |
+-----------------------------------------------------------------------+

  PURPOSE : - 
*/
GLOBAL const void  psa_aaa_cmd_req	(T_AAA_CMD_REQ *cmd)
{
  TRACE_FUNCTION("psa_aaa_cmd_req()");
  /*
   * the results of this request are send to AAA by the
   * call back function riv_src_result_cb() which calls
   * psa_aaa_cmd_cnf() | psa_aaa_pres_ind() | psa_aaa_ures_ind() 
   */
  ati_src_riv_proc_cmd (cmd);

  PFREE (cmd);
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_open_port_req |
+-----------------------------------------------------------------------+

  PURPOSE : - 
*/
GLOBAL const void  psa_aaa_open_port_req	(T_AAA_OPEN_PORT_REQ *cmd)
{
  UBYTE     dti_id  = DTI_DTI_ID_NOTPRESENT;
  UBYTE port_number = cmd->port_number;
  UBYTE      sub_no = cmd->sub_no;

  TRACE_FUNCTION("psa_aaa_open_port_req()");

  dti_id = ati_src_riv_open_port (port_number,
                                  sub_no,
                                  cmd->capability);

  PFREE (cmd);
  /*
   * we send here the confirmation, because there is no call back.
   * if dti_id = DTI_DTI_ID_NOTPRESENT, then the request failed
   */
  psaAAA_open_port_cnf (port_number, sub_no, dti_id);
}

/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_close_port_req|
+-----------------------------------------------------------------------+

  PURPOSE : - 
*/
GLOBAL const void  psa_aaa_close_port_req	(T_AAA_CLOSE_PORT_REQ *cmd)
{
  TRACE_FUNCTION("psa_aaa_close_port_req()");

  ati_src_riv_close_port (cmd->port_number, cmd->sub_no);

  PFREE (cmd);
  /*
   * we send here the confirmation, because there is no call back
   */
  psaAAA_close_port_cnf (cmd->port_number, cmd->sub_no);
}


/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)              MODULE  : psa_aaa               |
| STATE   : code                        ROUTINE : psa_aaa_dti_rsp       |
+-----------------------------------------------------------------------+

  PURPOSE : - the response to psa_aaa_dti_ind()
*/
GLOBAL const void  psa_aaa_dti_rsp (T_AAA_DTI_RES *cmd)
{
  T_DTI_CONN_LINK_ID link_id;

  TRACE_FUNCTION("psa_aaa_dti_rsp()");
  /*
   * we need the link_id again, which we had to remember at psaAAA_dti_ind()
   */
  link_id = dti_cntrl_get_link_id (DTI_ENTITY_AAA, cmd->port_number, cmd->sub_no);

  ati_src_riv_dti_rsp (link_id);

  PFREE (cmd);
}


/*
+-----------------------------------------------------------------------+
| PROJECT : GSM-F&D (8411)             MODULE  : psa_aaa                |
| STATE   : code                       ROUTINE : psa_aaa_disconnect_rsp |
+-----------------------------------------------------------------------+

  PURPOSE : - the response to psa_aaa_disconnect_ind()
*/
GLOBAL const void  psa_aaa_disconnect_rsp (T_AAA_DISCONNECT_RES *cmd)
{
  T_DTI_CONN_LINK_ID link_id;

  TRACE_FUNCTION("psa_aaa_disconnect_rsp()");
  /*
   * we need the link_id again, which we had to remember at psaAAA_dti_ind()
   */
  link_id = dti_cntrl_get_link_id (DTI_ENTITY_AAA, cmd->port_number, cmd->sub_no);

  ati_src_riv_disconnect_rsp (link_id);

  PFREE (cmd);
}


#endif /* DTI */
