/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  AOC
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Definitions for high level driver for vocoder interface
+----------------------------------------------------------------------------- 
*/

#ifndef HL_VOICE_DRV_H
#define HL_VOICE_DRV_H

typedef enum 
{
  HL_VOICE_DRV_FAIL,
  HL_VOICE_DRV_SUCC

} T_HL_VOICE_DRV_RSLT;


typedef enum
{
  HL_VOCODER_DISABLED,
  HL_VOCODER_ENABLE_REQ,
  HL_VOCODER_ENABLED

} T_HL_VOCODER_STATE;


EXTERN void hl_audio_drv_init (void);
EXTERN T_HL_VOICE_DRV_RSLT hl_drv_enable_vocoder ( void );
EXTERN void hl_drv_disable_vocoder ( void );
EXTERN T_HL_VOCODER_STATE hl_drv_get_vocoder_state (void);
EXTERN void hl_drv_vocoder_enabled (void);

#endif /* HL_VOICE_DRV_H */
