/*
+-----------------------------------------------------------------------------
|  Project :  GSM-PS (6147)
|  Modul   :  AOC
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  This module defines the functions for the high level audio 
              driver interface.
+-----------------------------------------------------------------------------
*/


#ifndef HL_AUDIO_DRV_C
#define HL_AUDIO_DRV_C
#endif

#include "aci_all.h"
#include "aci_cmh.h"
#include "aci.h"
#include "psa.h"
#include "hl_audio_drv.h"



/* ===============GLOBAL VARIABLES====================*/

LOCAL T_HL_VOCODER_STATE currVocoderState;

/* This flag helps enable the vocoder interface testing for
   specific tescases 
*/
#ifdef _SIMULATION_
BOOL vocoder_tst_flag; 
#endif


/* =============FUNCTION DEFINITIONS FOR L1===========*/
#ifndef _SIMULATION_
#ifdef VOCODER_FUNC_INTERFACE
void vocoder_mute_dl( BOOL mute );
void vocoder_mute_ul( BOOL mute );
void enable_tch_vocoder (BOOL vocoder_on);
#endif /* VOCODER_FUNC_INTERFACE */
#endif /* _SIMULATION_ */


/*================= FUNCTIONS ========================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : HL_AUDIO_DRV            |
|                                 ROUTINE : hl_audio_drv_init       |
+-------------------------------------------------------------------+

  PURPOSE : This function is called to initialise the variables in 
            the High Level Audio driver
*/
GLOBAL void hl_audio_drv_init (void)
{
  TRACE_FUNCTION("hl_audio_drv_init()");

  currVocoderState = HL_VOCODER_DISABLED;
#ifdef _SIMULATION_
  vocoder_tst_flag = FALSE;
#endif

}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : HL_AUDIO_DRV            |
|                                 ROUTINE : hl_drv_enable_vocoder   |
+-------------------------------------------------------------------+

  PURPOSE : This function is called to initialise the variables in 
            the High Level Audio driver
*/
GLOBAL T_HL_VOICE_DRV_RSLT hl_drv_enable_vocoder ( void )
{
  TRACE_FUNCTION("hl_drv_enable_vocoder()");
  /* If the vocoder is already enabled, then ignore the request */
  switch(currVocoderState)
  {
    case HL_VOCODER_ENABLED:
      TRACE_EVENT("*--Vocoder already active--*");
      return HL_VOICE_DRV_SUCC;

    case HL_VOCODER_ENABLE_REQ:
      TRACE_EVENT("*--Vocoder cannot be enabled--*");
      return HL_VOICE_DRV_FAIL;

    case HL_VOCODER_DISABLED:
      break;
  }

#ifdef _SIMULATION_
  if (vocoder_tst_flag)
#endif
  {
#ifndef VOCODER_FUNC_INTERFACE
  {
    PALLOC(mmi_tch_vocoder_cfg_req, MMI_TCH_VOCODER_CFG_REQ);
      mmi_tch_vocoder_cfg_req->vocoder_state = VOCODER_ENABLE;
    PSENDX(L1, mmi_tch_vocoder_cfg_req);
  }
    currVocoderState = HL_VOCODER_ENABLE_REQ;
#else
#ifndef _SIMULATION_
    TRACE_EVENT("Function interface for Vocoder");
    enable_tch_vocoder(TRUE);
    vocoder_mute_dl (FALSE);      /* un-mute speaker    */
    vocoder_mute_ul (FALSE);      /* un-mute microphone */
    currVocoderState = HL_VOCODER_ENABLED;
#endif /* _SIMULATION_ */
#endif
  }
  return HL_VOICE_DRV_SUCC;
}

/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : HL_AUDIO_DRV            |
|                                 ROUTINE : hl_drv_disable_vocoder  |
+-------------------------------------------------------------------+

  PURPOSE : This function is called to initialise the variables in 
            the High Level Audio driver
*/
GLOBAL void hl_drv_disable_vocoder ( void )
{
  TRACE_FUNCTION("hl_drv_disable_vocoder()");

  currVocoderState = HL_VOCODER_DISABLED;
#ifndef VOCODER_FUNC_INTERFACE
  /* Do nothing in this case */
#else
#ifndef _SIMULATION_
  TRACE_EVENT("Function interface for Vocoder");
  vocoder_mute_dl (TRUE);       /* mute speaker    */
  vocoder_mute_ul (TRUE);       /* mute microphone */
  enable_tch_vocoder (FALSE);   /* disable vocoder */
#endif
#endif
}


/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)        MODULE  : HL_AUDIO_DRV             |
|                                ROUTINE : hl_drv_get_vocoder_state |
+-------------------------------------------------------------------+

  PURPOSE : This function returns the state of the vocoder
*/

GLOBAL T_HL_VOCODER_STATE hl_drv_get_vocoder_state (void)
{
  return currVocoderState;
}

#ifndef VOCODER_FUNC_INTERFACE
/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)        MODULE  : HL_AUDIO_DRV             |
|                                ROUTINE : hl_drv_vocoder_enabled   |
+-------------------------------------------------------------------+

  PURPOSE : Currently this function does nothing
*/

GLOBAL void hl_drv_vocoder_enabled (void)
{
  TRACE_FUNCTION("hl_drv_vocoder_enabled()");
  currVocoderState = HL_VOCODER_ENABLED;
}
#endif

#ifdef _SIMULATION_
/*
+-------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)        MODULE  : HL_AUDIO_DRV             |
|                                ROUTINE : hl_audio_drv_initForTest |
+-------------------------------------------------------------------+

  PURPOSE : Initialise global variables related to simulaed 
*/

GLOBAL void hl_audio_drv_initForTest(void)
{
  vocoder_tst_flag = TRUE;
}
#endif