/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  GPRS AT Command Interpreter Call-Back Functions.
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef GACI_RET_C
#define GACI_RET_C
#endif

#include "aci_all.h"

/*
 *  includes
 */
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "aci_io.h"
#include "aci.h"
#include "l4_tim.h"
#include "aci_lst.h"

#include "dti_conn_mng.h"

#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_sm.h"

#include "cmh.h"
#include "cmh_sm.h"

#include "aci_io.h"
#include "aci_mem.h"

#include "ati_int.h"

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PlusCGACT      |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PlusCGACT call back

*/
GLOBAL void rCI_PlusCGACT ( SHORT link_id )
{
  UBYTE srcId = srcId_cb;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, srcId, search_ati_src_id);

  TRACE_FUNCTION("rCI_PlusCGACT()");

  src_params->curAtCmd = AT_CMD_NONE;

}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PlusCGDATA     |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PlusCGDATA call back

*/
GLOBAL void rCI_PlusCGDATA ( SHORT link_id )
{
  UBYTE srcId = srcId_cb;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, srcId, search_ati_src_id);

  TRACE_FUNCTION("rCI_PlusCGDATA()");

  src_params->curAtCmd = AT_CMD_NONE;

}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PlusCGANS      |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PlusCGANS call back

*/
GLOBAL void rCI_PlusCGANS ( SHORT link_id )
{
  UBYTE srcId = srcId_cb;
  T_ATI_SRC_PARAMS *src_params = find_element (ati_src_list, srcId, search_ati_src_id);

  TRACE_FUNCTION("rCI_PlusCGANS()");

  src_params->curAtCmd = AT_CMD_NONE;

}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PlusCGEREP     |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PlusCGEREP call back

*/
GLOBAL void rCI_PlusCGEREP ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param )
{
  char *me="+CGEV: ";
  UBYTE srcId = srcId_cb;

  TRACE_FUNCTION("rCI_PlusCGEREP()");

  if (ati_user_output_cfg[srcId].CGEREP_mode EQ 0)
  {
    return; /* don't indicate +CGEV to a source on which AT+CGEREP was not set up */
  }

  if( CGEREP_MODE_DICARD_RESERVED EQ ati_user_output_cfg[srcId].CGEREP_mode AND 
      uart_is_mt_te_link () NEQ FALSE )
  {
    return;
  }
  
  switch ( event )
  {
    case CGEREP_EVENT_REJECT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\"", me, "REJECT", param->reject.pdp_type, param->reject.pdp_addr);
      break;
    case CGEREP_EVENT_NW_REACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "NW REACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_NW_DEACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "NW DEACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_ME_DEACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "ME DEACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_NW_DETACH:
      sprintf(g_sa,"%s%s", me, "NW DETACH" );
      break;
    case CGEREP_EVENT_ME_DETACH:
      sprintf(g_sa,"%s%s", me, "ME DETACH" );
      break;
    case CGEREP_EVENT_NW_CLASS:
      sprintf(g_sa,"%s%s", me, "NW CLASS" );
      break;
    case CGEREP_EVENT_ME_CLASS:
      sprintf(g_sa,"%s%s", me, "ME CLASS" );
      break;
  }

  if ( CGEREP_MODE_BUFFER NEQ ati_user_output_cfg[srcId].CGEREP_mode AND 
       uart_is_mt_te_link () EQ FALSE)
  {
    io_sendIndication(srcId, g_sa, ATI_FORCED_OUTPUT);
  }
  else
  { /* write in event reporting buffer */
    cmhSM_save_event(event, param);
  }
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PercentCGEV     |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PercentCGEREP call back

*/
GLOBAL void rCI_PercentCGEV ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param )
{
  char *me="%CGEV: ";
  UBYTE srcId = srcId_cb;
  
  TRACE_FUNCTION("rCI_PercentCGEV()");

  if (ati_user_output_cfg[srcId].Percent_CGEREP_stat EQ 0)
  {
    return; /* don't indicate %CGEV to a source on which AT%CGEREP was not set up */
  }

  switch ( event )
  {
    case CGEREP_EVENT_REJECT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\"", me, "REJECT", param->reject.pdp_type, param->reject.pdp_addr);
      break;
    case CGEREP_EVENT_NW_REACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "NW REACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_NW_DEACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "NW DEACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_ME_DEACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "ME DEACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
      break;
    case CGEREP_EVENT_NW_DETACH:
      sprintf(g_sa,"%s%s", me, "NW DETACH" );
      break;
    case CGEREP_EVENT_ME_DETACH:
      sprintf(g_sa,"%s%s", me, "ME DETACH" );
      break;
    case CGEREP_EVENT_NW_CLASS:
      sprintf(g_sa,"%s%s", me, "NW CLASS" );
      break;
    case CGEREP_EVENT_ME_CLASS:
      sprintf(g_sa,"%s%s", me, "ME CLASS" );
      break;
    case CGEREP_EVENT_NW_ACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "NW ACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
        break;
    case CGEREP_EVENT_ME_ACT:
      sprintf(g_sa,"%s%s \"%s\",\"%s\",%hd", me, "ME ACT", param->act.pdp_type, param->act.pdp_addr, param->act.cid);
        break;
  }

  io_sendIndication(srcId, g_sa, ATI_NORMAL_OUTPUT);
  
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PlusCGREG      |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PlusCGREG call back

*/
GLOBAL void rCI_PlusCGREG ( T_CGREG_STAT stat, USHORT lac, USHORT ci )
{
  TRACE_FUNCTION("rCI_PlusCGREG()");

  r_plus_percent_CREG  ( srcId_cb,
                         stat,
                         lac,
                         ci,
                         PlusCGREG_CMD,
                         P_CREG_GPRS_Support_Unknown, /*ACI-SPR-17218: ignored*/
                         FALSE );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_changedQOS     |
+--------------------------------------------------------------------+

  PURPOSE : dummy function

*/
GLOBAL void rCI_changedQOS    ( SHORT cid, T_QOS *qos )
{
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PercentSNCNT   |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PercentSNCNT call back

*/
GLOBAL void rCI_PercentSNCNT ( UBYTE c_id,
                               ULONG octets_uplink,
                               ULONG octets_downlink,
                               ULONG packets_uplink,
                               ULONG packets_downlink )
{
  TRACE_FUNCTION("rCI_PercentSNCNT()");
  
  sprintf(g_sa,"%s: %d, %d, %d, %d, %d", "%SNCNT", c_id,
                                         octets_uplink, octets_downlink, 
                                         packets_uplink, packets_downlink);
      
  io_sendMessage(srcId_cb, g_sa, ATI_NORMAL_OUTPUT);

}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PercentCGREG   |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PercentCGREG call back

*/
GLOBAL void rCI_PercentCGREG ( T_P_CGREG_STAT stat, USHORT lac, USHORT ci, BOOL bActiveContext )
{
  TRACE_FUNCTION("rCI_PercentCGREG()");

  r_plus_percent_CREG  ( srcId_cb,
                         stat,
                         lac,
                         ci,
                         PercentCGREG_CMD,
                         P_CREG_GPRS_Support_Unknown, /*ACI-SPR-17218: ignored*/
                         bActiveContext);

}

/* sbh...15/01/02.  If MFW defined, then these functions are duplicated */

#if !defined(MFW) && !defined(FF_MMI_RIV)

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PlusCGACT      |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PlusCGACT call back

*/
GLOBAL void rAT_PlusCGACT   ( SHORT link_id )
{

  TRACE_FUNCTION("rAT_PlusCGACT()");


}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PlusCGDATA     |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PlusCGDATA call back

*/
GLOBAL void rAT_PlusCGDATA   ( SHORT link_id )
{

  TRACE_FUNCTION("rAT_PlusCGDATA()");


}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PlusCGANS      |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PlusCGANS call back

*/
GLOBAL void rAT_PlusCGANS ( SHORT link_id )
{

  TRACE_FUNCTION("rAT_PlusCGANS()");


}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PlusCGEREP     |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PlusCGEREP call back

*/
GLOBAL void rAT_PlusCGEREP ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param )
{

  TRACE_FUNCTION("rAT_PlusCGEREP()");


}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PercentCGEV     |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PercentCGEV call back

*/
GLOBAL void rAT_PercentCGEV (T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param )
{

  TRACE_FUNCTION("rAT_PercentCGEV()");

}
/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PlusCGREG      |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PlusCGREG call back

*/
GLOBAL void rAT_PlusCGREG ( T_CGREG_STAT stat, USHORT lac, USHORT ci )
{

  TRACE_FUNCTION("rAT_PlusCGREG()");


}
/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_changedQOS     |
+--------------------------------------------------------------------+

  PURPOSE : inform over the network initiated QOS modification

*/
GLOBAL void rAT_changedQOS    ( SHORT cid, T_QOS *qos )
{

  TRACE_FUNCTION("rAT_changedQOS()");


}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rCI_PercentSNCNT   |
+--------------------------------------------------------------------+

  PURPOSE : handles rCI_PercentSNCNT call back

*/
GLOBAL void rAT_PercentSNCNT ( UBYTE c_id,
                               ULONG octets_uplink,
                               ULONG octets_downlink,
                               ULONG packets_uplink,
                               ULONG packets_downlink )
{
  TRACE_FUNCTION("rAT_PercentSNCNT()");

}


/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                 MODULE  : GACI_RET           |
| STATE   : code                        ROUTINE : rAT_PercentCGREG      |
+--------------------------------------------------------------------+

  PURPOSE : handles rAT_PercentCGREG call back

*/
GLOBAL void rAT_PercentCGREG ( T_P_CGREG_STAT stat, USHORT lac, USHORT ci, BOOL bActiveContext )
{

  TRACE_FUNCTION("rAT_PercentCGREG()");


}

#endif /* MFW || FF_MMI_RIV */


#endif  /* GPRS */
