/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  GPRS Command handler interface definitions.
+----------------------------------------------------------------------------- 
*/ 

#ifndef GACI_CMH_H
#define GACI_CMH_H


/*==== MACROS =====================================================*/
#define GPRS_EVENT_REPORTING_BUFFER_SIZE  10

/*==== DEFINES ====================================================*/
/* the maximum length of strings to describe the PDP typ, PDP address, APN and L2P */
#define MAX_PDP_TYPE_LEN  7
#define MAX_APN_LEN       103
#define MAX_DNS_LEN       15
#define MAX_USER_LEN      63  /* this is a common value for Routers etc... */
#define MAX_PWD_LEN       63
#define MAX_PDP_ADDR_LEN  21
#if defined (FF_PKTIO) OR defined (FF_TCP_IP) || defined(FF_GPF_TCPIP) OR defined (FF_PSI)
#define MAX_L2P_LENGTH    6
#else /* FF_PKTIO || FF_TCP_IP || FF_GPF_TCPIP OR FF_PSI */
#define MAX_L2P_LENGTH    4
#endif /* FF_PKTIO || FF_TCP_IP || FF_GPF_TCPIP OR FF_PSI */

typedef enum                    /* CGDCONT command d_comp */
{
  GPRS_CID_OMITTED = 0,         /* value is omitted */
  GPRS_CID_1,                   /* PDP data compression off (default) */
  GPRS_CID_2,                   /* PDP data compression on */
#if defined (FF_PKTIO) OR defined (FF_PSI)
  GPRS_CID_3,
  GPRS_CID_4,
  GPRS_CID_5,
  GPRS_CID_6,
#endif /* FF_PKTIO OR FF_PSI */
  GPRS_CID_INVALID              /* invalid value */

} T_GPRS_CID;

#define INVALID_CID         GPRS_CID_OMITTED

#if defined (FF_PKTIO) OR defined (FF_PSI)
#define MAX_CID             GPRS_CID_6
#else /* FF_PKTIO OR FF_PSI */
#define MAX_CID             GPRS_CID_2
#endif /* FF_PKTIO OR FF_PSI */

#define MAX_CID_PLUS_EINS   GPRS_CID_INVALID

/*==== TYPES ======================================================*/
#define GPRS_QOS_OMITTED  0

typedef struct
{
  UBYTE           preced;
  UBYTE           delay;
  UBYTE           relclass;
  UBYTE           peak;
  UBYTE           mean;
} T_QOS;

typedef char T_PDP_ADDRESS  [MAX_PDP_ADDR_LEN];
typedef char T_PDP_TYPE     [MAX_PDP_TYPE_LEN];
typedef char T_APN          [MAX_APN_LEN];
typedef char T_L2P          [MAX_L2P_LENGTH];

typedef struct
{
  T_APN               apn;
  T_PDP_TYPE          pdp_type;
  T_PDP_ADDRESS       pdp_addr;
  SHORT               d_comp;
  SHORT               h_comp;
  T_QOS               qos;
  T_QOS               min_qos;
} T_GPRS_CONT_REC;

/*---- Types of  -----------------------------------------*/
typedef enum                    /* CGDCONT command d_comp */
{
  CGDCONT_D_COMP_OMITTED = -1,  /* value is omitted */
  CGDCONT_D_COMP_OFF,           /* PDP data compression off (default) */
  CGDCONT_D_COMP_ON,            /* PDP data compression on */
  CGDCONT_D_COMP_INVALID        /* invalid value */

} T_CGDCONT_D_COMP;

typedef enum                    /* CGDCONT command h_comp */
{
  CGDCONT_H_COMP_OMITTED = -1,  /* value is omitted */
  CGDCONT_H_COMP_OFF,           /* PDP header compression off (default) */
  CGDCONT_H_COMP_ON,            /* PDP header compression on */
  CGDCONT_H_COMP_INVALID        /* invalid value */

} T_CGDCONT_H_COMP;

typedef enum                    /* CGATT command state */
{
  CGATT_STATE_OMITTED = -1,     /* value is omitted */
  CGATT_STATE_DETACHED,         /* GPRS detached */
  CGATT_STATE_ATTACHED,         /* GPRS attached */
  CGATT_STATE_INVALID           /* invalid value */

} T_CGATT_STATE;

typedef enum                    /* CGACT command state */
{
  CGACT_STATE_OMITTED = -1,     /* value is omitted */
  CGACT_STATE_DEACTIVATED,      /* PDP context detached */
  CGACT_STATE_ACTIVATED,        /* PDP context attached */
  CGACT_STATE_INVALID           /* invalid value */

} T_CGACT_STATE;

typedef enum                    /* CGAUTO command n */
{
  CGAUTO_N_OMITTED = -1,        /* value is omitted */
  CGAUTO_N_GPRS_RES_OFF,        /* turn off automatic response for GPRS only */
  CGAUTO_N_GPRS_RES_ON,         /* turn on automatic response for GPRS only */
  CGAUTO_N_MCM_GPRS_ONLY,       /* modem compabitbility mode, GPRS only */
  CGAUTO_N_MCM_GPRS_CSC,        /* modem compabitbility mode, GPRS and circuit switched calls (default) */
  CGAUTO_N_INVALID              /* invalid value */

} T_CGAUTO_N;

typedef enum                    /* CGANS command response */
{
  CGANS_RESPONSE_OMITTED = -1,  /* value is omitted */
  CGANS_RESPONSE_REJECT,        /* reject the request */
  CGANS_RESPONSE_ACCEPT,        /* accept and request that the PDP context be activated */
  CGANS_RESPONSE_INVALID        /* invalid value */

} T_CGANS_RESPONSE;

typedef enum                    /* CGANS command response */
{
  CGCLASS_CLASS_OMITTED = -1,   /* value is omitted */
  CGCLASS_CLASS_A,              /* mobile class A  (highest) */
  CGCLASS_CLASS_B,              /* mobile class B  (if necessary consider NET III) */
  CGCLASS_CLASS_CG,             /* mobile class CG (GPRS only mode) */
  CGCLASS_CLASS_CC,             /* mobile class CC (circuit switched only mode - lowest) */
  CGCLASS_CLASS_MAX             /* invalid value */

} T_CGCLASS_CLASS;

typedef enum                    /* CGANS command response */
{
  PERCENT_CGCLASS_OMITTED = -1,   /* value is omitted */
  PERCENT_CGCLASS_A,              /* mobile class A  (highest) */
  PERCENT_CGCLASS_B,              /* mobile class B   */
  PERCENT_CGCLASS_BG,             /* mobile class BG   */
  PERCENT_CGCLASS_BC,             /* mobile class BC   */
  PERCENT_CGCLASS_BX,             /* mobile class BX   */
  PERCENT_CGCLASS_CG,             /* mobile class CG (GPRS only mode) */
  PERCENT_CGCLASS_CC,             /* mobile class CC (circuit switched only mode - lowest) */
  PERCENT_CGCLASS_MAX             /* invalid value */

} T_PERCENT_CGCLASS;

typedef enum                    /* CGEREP command mode */
{
  CGEREP_MODE_OMITTED = -1,     /* value is omitted */
  CGEREP_MODE_BUFFER,           /* buffer unsolicited result codes */
  CGEREP_MODE_DICARD_RESERVED,  /* discard unsolicited result codes when MT-TE link is reserved */
  CGEREP_MODE_BUFFER_RESERVED,  /* buffer unsolicited result codes in the MT when MT-TE link is reserved */
  CGEREP_MODE_INVALID           /* invalid value */

} T_CGEREP_MODE;

typedef enum                    /* CGEREP command bfr */
{
  CGEREP_BFR_OMITTED = -1,      /* value is omitted */
  CGEREP_BFR_CLEAR,             /* buffer unsolicited result codes */
  CGEREP_BFR_FLUSH,             /* discard unsolicited result codes when MT-TE link is reserved */
  CGEREP_BFR_INVALID            /* invalid value */

} T_CGEREP_BFR;

typedef enum                    /* CGREG command read stat */
{
  CGREG_STAT_NOT_PRESENT = -1,  /* not present, last state is not indicated */
  CGREG_STAT_NOT_REG,           /* not registered, no searching */
  CGREG_STAT_REG_HOME,          /* registered, home network */
  CGREG_STAT_SEARCHING,         /* not registered, but searching */
  CGREG_STAT_REG_DEN,           /* registration denied */
  CGREG_STAT_UNKN,              /* unknown */
  CGREG_STAT_REG_ROAM           /* registered, roaming */

} T_CGREG_STAT;

typedef enum                    /* %CGREG command read stat */
{
  P_CGREG_STAT_NOT_PRESENT = -1,  /* not present, last state is not indicated */
  P_CGREG_STAT_NOT_REG,           /* not registered, no searching */
  P_CGREG_STAT_REG_HOME,          /* registered, home network */
  P_CGREG_STAT_SEARCHING,         /* not registered, but searching */
  P_CGREG_STAT_REG_DEN,           /* registration denied */
  P_CGREG_STAT_UNKN,              /* unknown */
  P_CGREG_STAT_REG_ROAM,          /* registered, roaming */
  P_CGREG_STAT_LIMITED,           /* limited service */
  P_CGREG_STAT_GSM_CALL,          /* GSM call is active */
  P_CGREG_STAT_NO_CELL,           /* no cell available */
  P_CGREG_STAT_TRY_TO_UPDATE      /* next attempt to update MS */

} T_P_CGREG_STAT;


typedef enum                    /* CGSMS command service */
{
  CGSMS_SERVICE_OMITTED = -1,   /* value is omitted */
  CGSMS_SERVICE_GPRS,           /* GPRS */
  CGSMS_SERVICE_CS,             /* circuit switched */
  CGSMS_SERVICE_GPRS_PREFERRED, /* GPRS preferred */
  CGSMS_SERVICE_CS_PREFERRED,   /* circuit switched preferred */
  CGSMS_SERVICE_INVALID         /* invalid value */

} T_CGSMS_SERVICE;

typedef enum                    /* CGAATT command automatic attach mode */
{
  CGAATT_ATTACH_MODE_OMITTED = -1, /* value is omitted */
  CGAATT_ATTACH_MODE_AUTOMATIC,    /* automatic attach */
  CGAATT_ATTACH_MODE_MANUAL,       /* manual attach */
  CGAATT_ATTACH_MODE_INVALID       /* invalid value */

} T_CGAATT_ATTACH_MODE;

typedef enum                    /* CGAATT command automatic detach after context deactivation */
{
  CGAATT_DETACH_MODE_OMITTED = -1, /* value is omitted */
  CGAATT_DETACH_MODE_ON,           /* on */
  CGAATT_DETACH_MODE_OFF,          /* off */
  CGAATT_DETACH_MODE_INVALID       /* invalid value */

} T_CGAATT_DETACH_MODE;

/*---- Types for event reporting-----------------------------------*/

typedef enum                /* Defined events for GPRS event reporting */
{
  CGEREP_EVENT_INVALID = -1, /* reserved value */
  CGEREP_EVENT_REJECT,      /* network request context activation */
  CGEREP_EVENT_NW_REACT,    /* network requested context reactivation */
  CGEREP_EVENT_NW_DEACT,    /* network forced context deactivation */
  CGEREP_EVENT_ME_DEACT,    /* mobile equipment forced context deactivation */
  CGEREP_EVENT_NW_DETACH,   /* network forced detach */
  CGEREP_EVENT_ME_DETACH,   /* mobile equipment forced detach */
  CGEREP_EVENT_NW_CLASS,    /* network forced class change */
  CGEREP_EVENT_ME_CLASS,    /* mobile equipment forced class change */
  CGEREP_EVENT_NW_ACT,    /* network requested context activation */
  CGEREP_EVENT_ME_ACT    /* mobile equipment initiated context activation */
} T_CGEREP_EVENT;

typedef struct              /* parameter of unsolicited event: REJECT */
{
  T_PDP_TYPE        pdp_type;
  T_PDP_ADDRESS     pdp_addr;

} T_EVENT_REJECT;

typedef struct              /* parameter of unsolicited event: NW REACT, NW DEACT, ME DEACT */
{
  T_PDP_TYPE        pdp_type;
  T_PDP_ADDRESS     pdp_addr;
  SHORT             cid;

} T_EVENT_ACT;

typedef union
{
  T_EVENT_REJECT    reject;
  T_EVENT_ACT       act;
  T_CGCLASS_CLASS   mobile_class;

} T_CGEREP_EVENT_REP_PARAM;

/*---- %CGPCO -----------------------------------------------------*/

#define ACI_PCO_MAX_LEN                         251
#define ACI_PCO_CONTENTMASK_AUTH                0x00000001
#define ACI_PCO_CONTENTMASK_DNS1                0x00000002
#define ACI_PCO_CONTENTMASK_DNS2                0x00000004

#define ACI_PCO_CONFIG_PROT_PPP                 0

#define ACI_PCO_AUTH_PROT_PAP                   0xc023

#define ACI_PCO_PAP_OVERHEAD                    9
#define ACI_PCO_IPCP_OVERHEAD                   7
#define ACI_PCO_PAP_AUTH_REQ                    0x01
#define ACI_PCO_IPCP_PROT_MSB                   0x80
#define ACI_PCO_IPCP_PROT_LSB                   0x21
#define ACI_PCO_IPCP_CONF_REQ                   0x01
#define ACI_PCO_IPCP_CONF_ACK                   0x02
#define ACI_PCO_IPCP_CONF_NAK                   0x03
#define ACI_PCO_IPCP_TYPE_IP                    3
#define ACI_PCO_IPCP_TYPE_DNS1                  129
#define ACI_PCO_IPCP_TYPE_DNS2                  131
#define ACI_PCO_IPCP_LENGTH_IP                  6
#define ACI_PCO_IPCP_LENGTH_DNS1                6
#define ACI_PCO_IPCP_LENGTH_DNS2                6

typedef enum
{
  CGPCO_FORMAT_HEX = 0,
  CGPCO_FORMAT_ASCII
}T_ACI_CGPCO_FORMAT;

typedef enum
{
  CGPCO_MODE_SET_PCO = 0,
  CGPCO_MODE_QUERY_PCO
}T_ACI_CGPCO_MODE;


/*==== PROTOTYPES =================================================*/

/***  set commands  ***/
EXTERN T_ACI_RETURN sAT_PercentCGPCO (T_ACI_CMD_SRC srcId, 
                                      SHORT cid, USHORT protocol,
                                      CHAR *user, CHAR *pwd,CHAR *dns1, CHAR *dns2);
EXTERN T_ACI_RETURN qAT_PercentCGPCO ( UBYTE srcId, ULONG * gateway, ULONG * dns1,ULONG * dns2, USHORT cid);
EXTERN T_ACI_RETURN sAT_PlusCGDCONT ( T_ACI_CMD_SRC srcId, SHORT cid, T_GPRS_CONT_REC *inputCtxt);
EXTERN T_ACI_RETURN sAT_PlusCGQREQ  ( T_ACI_CMD_SRC srcId, SHORT cid ,T_QOS *qos);
EXTERN T_ACI_RETURN sAT_PlusCGQMIN  ( T_ACI_CMD_SRC srcId, SHORT cid ,T_QOS *qos);
EXTERN T_ACI_RETURN sAT_PlusCGATT   ( T_ACI_CMD_SRC srcId, T_CGATT_STATE state );
EXTERN T_ACI_RETURN sAT_PlusCGACT   ( T_ACI_CMD_SRC srcId, T_CGACT_STATE state, SHORT *cids );
EXTERN T_ACI_RETURN sAT_PlusCGDATA  ( T_ACI_CMD_SRC srcId, char *L2P, SHORT *cids );
EXTERN T_ACI_RETURN sAT_PlusCGPADDR ( T_ACI_CMD_SRC srcId, SHORT *cids, T_PDP_ADDRESS *pdp_adress );
EXTERN T_ACI_RETURN sAT_PlusCGAUTO  ( T_ACI_CMD_SRC srcId, T_CGAUTO_N n );
EXTERN T_ACI_RETURN sAT_PlusCGANS   ( T_ACI_CMD_SRC srcId, SHORT response, char *l2p, SHORT cid );
EXTERN T_ACI_RETURN sAT_PlusCGCLASS ( T_ACI_CMD_SRC srcId, T_CGCLASS_CLASS m_class );
EXTERN T_ACI_RETURN sAT_PlusCGEREP  ( T_ACI_CMD_SRC srcId, T_CGEREP_MODE mode, T_CGEREP_BFR bfr );
EXTERN T_ACI_RETURN sAT_PlusCGSMS   ( T_ACI_CMD_SRC srcId, T_CGSMS_SERVICE service );

EXTERN T_ACI_RETURN sAT_PercentCGAATT ( T_ACI_CMD_SRC srcId, T_CGAATT_ATTACH_MODE att_m, T_CGAATT_DETACH_MODE det_m );
EXTERN T_ACI_RETURN sAT_PercentCGMM ( T_ACI_CMD_SRC srcId, UBYTE cipher_on,
                                                           UBYTE tlli_handling );
EXTERN T_ACI_RETURN sAT_PercentSNCNT( T_ACI_CMD_SRC srcId, BOOL reset_counter );

EXTERN T_ACI_RETURN sAT_PercentCGPPP( T_ACI_CMD_SRC srcId,
                                      T_ACI_PPP_PROT protocol );
EXTERN T_ACI_RETURN sAT_PercentCGCLASS ( T_ACI_CMD_SRC srcId, T_PERCENT_CGCLASS m_class );
EXTERN T_ACI_RETURN qAT_PercentCGPPP( T_ACI_CMD_SRC srcId,
                                      T_ACI_PPP_PROT *protocol );

/***  read commands  ***/
EXTERN T_ACI_RETURN qAT_PlusCGDCONT ( T_ACI_CMD_SRC srcId, T_GPRS_CONT_REC (*Ctxt)[MAX_CID_PLUS_EINS], SHORT *cid );
EXTERN T_ACI_RETURN qAT_PlusCGQREQ  ( T_ACI_CMD_SRC srcId, T_QOS **qos, SHORT *cid);
EXTERN T_ACI_RETURN qAT_PlusCGQMIN  ( T_ACI_CMD_SRC srcId, T_QOS **qos, SHORT *cid);
EXTERN T_ACI_RETURN qAT_PlusCGATT   ( T_ACI_CMD_SRC srcId, T_CGATT_STATE *state );
EXTERN T_ACI_RETURN qAT_PlusCGACT   ( T_ACI_CMD_SRC srcId, BOOL  *states, SHORT *cid );
EXTERN T_ACI_RETURN qAT_PlusCGAUTO  ( T_ACI_CMD_SRC srcId, T_CGAUTO_N *n);
EXTERN T_ACI_RETURN qAT_PlusCGCLASS ( T_ACI_CMD_SRC srcId, T_CGCLASS_CLASS *m_class );
EXTERN T_ACI_RETURN qAT_PlusCGEREP  ( T_ACI_CMD_SRC srcId, T_CGEREP_MODE *mode, T_CGEREP_BFR *bfr );
EXTERN T_ACI_RETURN qAT_PlusCGREG   ( T_ACI_CMD_SRC srcId, T_CGREG_STAT *stat, USHORT *lac, USHORT *ci );
EXTERN T_ACI_RETURN qAT_PercentCGREG( T_ACI_CMD_SRC srcId, T_P_CGREG_STAT *stat, USHORT *lac, USHORT *ci );
EXTERN T_ACI_RETURN qAT_PlusCGSMS   ( T_ACI_CMD_SRC srcId, T_CGSMS_SERVICE *service );

EXTERN T_ACI_RETURN qAT_PercentCGAATT  ( T_ACI_CMD_SRC srcId, T_CGAATT_ATTACH_MODE *att_m, T_CGAATT_DETACH_MODE *det_m );
EXTERN T_ACI_RETURN qAT_PercentCGCLASS  ( T_ACI_CMD_SRC srcId, T_PERCENT_CGCLASS *m_class, T_PERCENT_CGCLASS *currentClass );

/***  test commands  ***/
EXTERN T_ACI_RETURN tAT_PlusCGPADDR ( T_ACI_CMD_SRC srcId, SHORT *cids);
EXTERN T_ACI_RETURN tAT_PlusCGSMS   ( T_ACI_CMD_SRC srcId, SHORT *service_list);


/*--------------- extension mechansim ----------------------------*/

/*--------------- constants --------------------------------------*/

/*--------------- configuration ----------------------------------*/

/*--------------- Extension Handler -> AT Interpreter ------------*/

/*--------------- AT Interpreter -> Extension Handler ------------*/

/*------- call-backs for MMI --------------------------------------*/

#ifdef CMH_F_C /*lint -save -e18 */ /* Turn off Lint errors for this "construct" */
EXTERN void rAT_PlusCGACT            ( void );
EXTERN void rAT_PlusCGDATA           ( void );
EXTERN void rAT_PlusCGANS            ( void );
EXTERN void rAT_PlusCGEREP           ( void );
EXTERN void rAT_PlusCGREG            ( void );
EXTERN void rAT_changedQOS           ( void );
EXTERN void rAT_PercentSNCNT         ( void );
EXTERN void rAT_PercentCGREG         ( void );
EXTERN void rAT_PercentCGEV           ( void );
/*lint -restore */
#else
EXTERN void rAT_PlusCGACT            ( SHORT link_id );
EXTERN void rAT_PlusCGDATA           ( SHORT link_id );
EXTERN void rAT_PlusCGANS            ( SHORT link_id );
EXTERN void rAT_PlusCGEREP           ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param );
EXTERN void rAT_PlusCGREG            ( T_CGREG_STAT stat, USHORT lac, USHORT ci );
EXTERN void rAT_changedQOS           ( SHORT cid, T_QOS *qos );
EXTERN void rAT_PercentSNCNT         ( UBYTE c_id,
                                       ULONG octets_uplink,
                                       ULONG octets_downlink,
                                       ULONG packets_uplink,
                                       ULONG packets_downlink );
EXTERN void rAT_PercentCGREG         ( T_P_CGREG_STAT stat, USHORT lac, USHORT ci, BOOL bActiveContext );
EXTERN void rAT_PercentCGEV           ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param );
#endif

/*--------------- call-backs for AT CI ----------------------------*/

#ifdef CMH_F_C
/*lint -save -e18 */ /* Turn off Lint errors for this "construct" */
EXTERN void rCI_PlusCGACT            ( void );
EXTERN void rCI_PlusCGDATA           ( void );
EXTERN void rCI_PlusCGANS            ( void );
EXTERN void rCI_PlusCGEREP           ( void );
EXTERN void rCI_PlusCGREG            ( void );
EXTERN void rCI_changedQOS           ( void );
EXTERN void rCI_PercentSNCNT         ( void );
EXTERN void rCI_PercentCGREG         ( void );
EXTERN void rCI_PercentCGEV           ( void );
/*lint -restore */
#else
EXTERN void rCI_PlusCGACT            ( SHORT link_id );
EXTERN void rCI_PlusCGDATA           ( SHORT link_id );
EXTERN void rCI_PlusCGANS            ( SHORT link_id );
EXTERN void rCI_PlusCGEREP           ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param );
EXTERN void rCI_PlusCGREG            ( T_CGREG_STAT stat, USHORT lac, USHORT ci );
EXTERN void rCI_changedQOS           ( SHORT cid, T_QOS *qos );
EXTERN void rCI_PercentSNCNT         ( UBYTE c_id,
                                       ULONG octets_uplink,
                                       ULONG octets_downlink,
                                       ULONG packets_uplink,
                                       ULONG packets_downlink );
EXTERN void rCI_PercentCGREG         ( T_P_CGREG_STAT stat, USHORT lac, USHORT ci, BOOL bActiveContext );
EXTERN void rCI_PercentCGEV           ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param );
#endif

#endif
/*==== EOF ========================================================*/
