/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Definitions for GPRS command handler and protocol stack adapter.
+----------------------------------------------------------------------------- 
*/ 

#include "dti.h"
#ifndef GACI_H
#define GACI_H



/*
**
**  handle states for every context
**
*/
typedef enum
{
  CS_INVALID_STATE = 0,       /* invalid value */
  CS_UNDEFINED,               /* context not defined */
  CS_DEFINED,                 /* context defined */
  CS_ATTACHING_AFTER_UNDEF,   /* mobile must be attached before it's able to activate it */
  CS_ATTACHING_AFTER_DEF,     /* mobile must be attached before it's able to activate it */
  CS_ESTABLISH_1,             /* PPP informed over estblish */
  CS_ESTABLISH_2,             /* SM informed over estblish */
  CS_ESTABLISH_3,             /* PPP informed over activated context */
  CS_WAITS_FOR_ACTIVATING,    /* running class change  for mobile class BX */
  CS_ACTIVATING,              /* SM context activating */
  CS_ABORT_ESTABLISH,         /* abort establish */
  CS_ACTIVATED,               /* context activated */
  CS_DATA_LINK,               /* Data link */
  CS_DEACTIVATE_NORMAL,       /* SM deactivating context except by AT command */
  CS_BREAKDOWN_LINK_NORMAL,   /* breakdown data link */
  CS_BREAKDOWN_LINK_ERROR,    /* breakdown data link due to an error */
  CS_CONTEXT_REACTIVATION_1,  /* the network will reactivate the context (PPP_TERMINATE_REQ && SMREG_DEACTIVATE_REQ) */
  CS_CONTEXT_REACTIVATION_2   /* the network will reactivate the context (PPP_TERMINATE_IND || SMREG_DEACTIVATE_CNF) */

} T_CONTEXT_STATE;

typedef enum
{
  AS_INVALID_STATE = 0,       /* invalid value */
  AS_MOBILE_OFF,              /* the protocol stack is off before +CFUN=1 */
  AS_DETACHED,                /* GPRS detached */
  AS_ATTACHED,                /* GPRS attached */
  AS_ATTACHING,               /* attaching GPRS */
  AS_DETACHING,               /* detaching GPRS */
  AS_SUSPENTED                /* GPRS suspended */

} T_ATTACH_STATE;

typedef enum
{
  GC_TYPE_NONE      = -1,     /* no connection */
  GC_TYPE_DATA_LINK = 0,      /* Data connection over PPP */
  GC_TYPE_NULL,               /* Data connection with NULL Device */
  GC_TYPE_SIM,          /* Data connection with SIM */
  GC_TYPE_WAP,                /* Data connection for the WAP browser */
#if defined (FF_PKTIO) OR defined (FF_TCP_IP) || defined(FF_GPF_TCPIP) OR defined (FF_PSI)
  GC_TYPE_PKT,                 /* Data connection for PKTIO */
#endif /* FF_PKTIO OR FF_TCP_IP || FF_GPF_TCPIP OR FF_PSI */
  GC_TYPE_EMAIL               /* Data connection for an Email - Client */

} T_GPRS_CONNECT_TYPE;

EXTERN  T_CONTEXT_STATE   get_state_over_cid      ( SHORT cid );
EXTERN  void              set_state_over_cid      ( SHORT cid, T_CONTEXT_STATE c_state );
EXTERN  T_CONTEXT_STATE   get_state_working_cid   ( void );
EXTERN  void              set_state_working_cid   ( T_CONTEXT_STATE c_state );
EXTERN  T_ACI_CAL_OWN     get_owner_over_cid      ( SHORT cid );
EXTERN  T_CONTEXT_STATE   get_state_over_nsapi_set( USHORT *nsapi_set, SHORT *cid );
EXTERN  T_CONTEXT_STATE   get_state_over_nsapi    ( USHORT nsapi );



EXTERN void   gaci_init   ( void );
EXTERN void   gaci_reset  ( void );
EXTERN void   gaci_finit  ( void );

#ifdef DTI
EXTERN SHORT  gaci_get_cid_over_link_id ( T_DTI_CONN_LINK_ID  link_id );
EXTERN SHORT  gaci_get_cid_over_dti_id  ( UBYTE  dti_id );
EXTERN T_DTI_CONN_LINK_ID  gaci_get_link_id_over_peer ( T_DTI_ENTITY_ID entity_id );
#endif

EXTERN  void  cmhSM_disconnect_cid ( SHORT cid, T_GPRS_CONNECT_TYPE type );
EXTERN  BOOL  uart_is_mt_te_link( void );

/* for ATZ */
EXTERN T_ACI_RETURN sGprsAT_Z     ( T_ACI_CMD_SRC srcId );
EXTERN BOOL         gaci_isATZcmd ( void );


EXTERN void gaci_RAT_caller ( SHORT rat_id, SHORT cid, UBYTE cmdBuf, UBYTE cme_err );
EXTERN void gaci_SAT_err(USHORT cause);

#endif /* GACI_H */

