/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  J:\g23m-aci\aci\gaci.c
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  
+----------------------------------------------------------------------------- 
*/ 
#if defined (GPRS) && defined (DTI)

#ifndef GACI_C
#define GACI_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "dti_conn_mng.h"

#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_sm.h"
#include "psa_gppp.h"
#include "psa_gmm.h"

#include "cmh.h"
#ifdef SIM_TOOLKIT
#include "psa_cc.h"
#include "psa_sat.h"
#include "cmh_sat.h"
#endif /* SIM_TOOLKIT */
#include "cmh_sm.h"
#include "cmh_gppp.h"
#include "cmh_gmm.h"
#include "gaci_srcc.h"

/*==== CONSTANTS ==================================================*/
static T_ACI_CMD_SRC _ATZ_srcId;

#ifdef FF_SAT_E
static USHORT SAT_error_cause = SAT_GPRS_INV_CAUSE;
#endif /* FF_SAT_E */

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

GLOBAL void gaci_init ( void )
{
  /* Init of intern variable */
  _ATZ_srcId = CMD_SRC_NONE;

  /* GPRS Init */
  gpppEntStat.curCmd = AT_CMD_NONE;
  gpppEntStat.entOwn = OWN_NONE;

  cmhGMM_Init();
  cmhSM_Init();

  srcc_init();

  gaci_reset();
}

GLOBAL void gaci_reset( void )
{
  cmhSM_Reset();
}

GLOBAL void gaci_ATZ_reset( void )
{
  cmhSM_ResetNonWorkingContexts();
}

GLOBAL void gaci_finit ( void )
{
  /* here will be a functionality */
}

EXTERN T_ACI_RETURN sGsmAT_Z ( T_ACI_CMD_SRC srcId );

GLOBAL T_ACI_RETURN sGprsAT_Z ( T_ACI_CMD_SRC srcId )
{
  SHORT cid_array[1] = { INVALID_CID };

 /*
  *-------------------------------------------------------------------
  *   rejects waiting network requests for PDP context activation
  *-------------------------------------------------------------------
  */
  if ( ( at.rngPrms.isRng EQ TRUE ) && ( at.rngPrms.mode EQ CRING_MOD_Gprs) ) /* GPRS call */
  {
   /*
    *   brz patch: In the case of context reactivation over SMREG_PDP_ACTIVATE_IND with an used ti
    *              the GPRS ATZ command doesn't do anything!
    *
    *   Why?       Because the Windows Dial-Up Networking client send every time an ATZ after termination
    *              of the connection and with this a context reactivation was impossible. 
    */
    if ( gprs_call_table[current_gprs_ct_index].reactivation EQ GCTT_NORMAL )
    {
      sAT_PlusCGANS(srcId, CGANS_RESPONSE_REJECT, NULL, GPRS_CID_OMITTED);
    }
    else
    { /* Reactivation: stop GPRS ATZ */
      return sGsmAT_Z ( srcId );
    }
  }
  if ( AT_EXCT EQ sAT_PlusCGACT ( srcId, CGACT_STATE_DEACTIVATED, cid_array ))
  {
    _ATZ_srcId = srcId;    /* hold source Id */
    return( AT_EXCT );
  }
  
  srcId_cb = srcId;
  gaci_ATZ_reset();
  return sGsmAT_Z ( srcId );
}

LOCAL void endOfGprsAT_Z ( void )
{
  srcId_cb = _ATZ_srcId;
  gaci_ATZ_reset();
  if ( AT_CMPL EQ sGsmAT_Z ( _ATZ_srcId ) )
  {
    R_AT( RAT_OK, _ATZ_srcId ) ( AT_CMD_Z );

    /* log result */
    cmh_logRslt ( _ATZ_srcId,
                  RAT_OK, AT_CMD_Z, -1, -1, -1 );
  }

  _ATZ_srcId = CMD_SRC_NONE;
}

GLOBAL BOOL gaci_isATZcmd ( void )
{
  if ( _ATZ_srcId NEQ CMD_SRC_NONE )
  {
    endOfGprsAT_Z();
    return TRUE;
  }
  
  return FALSE;
}


GLOBAL SHORT gaci_get_cid_over_dti_id ( UBYTE  dti_id )
{
  SHORT i = 0;

  /* compare only the DTI ID part of the Link ID */
  for (i = 0; i < MAX_CID; i++)
  {
    if ( dti_id EQ EXTRACT_DTI_ID(pdp_context[i].link_id_sn)    OR
         dti_id EQ EXTRACT_DTI_ID(pdp_context[i].link_id_uart)  OR
         dti_id EQ EXTRACT_DTI_ID(pdp_context[i].link_id_new)      ) 
    {
      return i + 1;
    }
  }
  return INVALID_CID;
}

GLOBAL SHORT gaci_get_cid_over_link_id ( T_DTI_CONN_LINK_ID  link_id )
{
  return gaci_get_cid_over_dti_id((UBYTE)EXTRACT_DTI_ID(link_id));
}

/*
 *  Assumption: there is only one connection between SNDCP and the peer
 */
GLOBAL T_DTI_CONN_LINK_ID gaci_get_link_id_over_peer ( T_DTI_ENTITY_ID entity_id )
{
  SHORT i;

  for (i = 0; i < MAX_CID; i++)
  {
    if(pdp_context[i].entity_id EQ entity_id) 
    {
      return cmhSM_get_link_id_SNDCP_peer((SHORT)(i + 1), SNDCP_PEER_NORMAL);
    }
  }
  return DTI_LINK_ID_NOTPRESENT;
}

#ifdef FF_SAT_E
GLOBAL void gaci_SAT_err(USHORT cause)
{
  SAT_error_cause = cause;
}
#endif /* FF_SAT_E */

GLOBAL void gaci_RAT_caller ( SHORT rat_id, SHORT cid, UBYTE cmdBuf, UBYTE cme_err )
{
  T_ACI_CMD_SRC  rat_owner = get_owner_over_cid( cid );

  TRACE_FUNCTION("gaci_RAT_caller()");

#ifdef FF_SAT_E
  if ( !cmhSAT_OpChnGPRSPend( cid, OPCH_NONE ))
#endif /* FF_SAT_E */
  {
    switch ( rat_id )
    {
      case RAT_OK:
        R_AT( RAT_OK, rat_owner ) ( cmdBuf );
        break;
      case RAT_CME:
        ACI_ERR_DESC( ACI_ERR_CLASS_Cme, cme_err );     /* align aciErrDesc to cme_err */
        R_AT( RAT_CME, rat_owner ) ( cmdBuf, cme_err );
        /* log result */
        cmh_logRslt ( (T_ACI_CMD_SRC) rat_owner, RAT_CME, (T_ACI_AT_CMD) cmdBuf, -1, -1, cme_err );
        break;
      case RAT_NO_CARRIER:
        if (!(cmhSM_getSrcIdOfRunningCGACTDeactivation(cid) EQ rat_owner))
        {
          R_AT( RAT_NO_CARRIER, rat_owner ) ( cmdBuf, 0 );
        }
        /* log result */
        cmh_logRslt ( (T_ACI_CMD_SRC) rat_owner, RAT_NO_CARRIER, (T_ACI_AT_CMD)cmdBuf, (SHORT) 0, -1, -1 );
        break;
    }
  }
#ifdef FF_SAT_E
  else
  {
    /*
     *    SIM callback for SAT-class CE 
     */
    switch ( rat_id )
    {
      case RAT_OK:
        /* connection deactivated */
        cmhSAT_OpChnGPRSStat(SAT_GPRS_ACT, SAT_GPRS_INV_CAUSE); /* no cause given by primitive */
        break;
      case RAT_CME:
        if ( cmdBuf EQ AT_CMD_CGDATA )
        { /* Attach before ATD (SNDCP <-> IP <-> UDP <-> SIM) fails */
          cmhSAT_OpChnGPRSStat(SAT_GPRS_ATT_FAILED, SAT_error_cause);  
        }
        else
        { /* activate connection SNDCP <-> SIM fails */
          cmhSAT_OpChnGPRSStat(SAT_GPRS_ACT_FAILED, SAT_error_cause);  
        }
        break;
      case RAT_NO_CARRIER:
          /* activate connection SNDCP <-> IP <-> UDP <-> SIM fails */
          cmhSAT_OpChnGPRSStat(SAT_GPRS_ACT_FAILED, SAT_error_cause);
        break;
    }
  }
#endif /* FF_SAT_E */
}

#endif  /* GPRS */
