/*
+-----------------------------------------------------------------------------
|  Project :
|  Modul   :
+-----------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG
|                 All rights reserved.
|
|                 This file is confidential and a trade secret of Texas
|                 Instruments Berlin, AG
|                 The receipt of or possession of this file does not convey
|                 any rights to reproduce or disclose its contents or to
|                 manufacture, use, or sell anything it may describe, in
|                 whole, or in part, without the specific written consent of
|                 Texas Instruments Berlin, AG.
+-----------------------------------------------------------------------------
|  Purpose :  This module implements the set fuinctions related to the
|             protocol stack adapter for the SNDCP entity.
+-----------------------------------------------------------------------------
*/

#ifdef GPRS

#ifndef CMH_SNDS_C
#define CMH_SNDS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "dti_conn_mng.h"

#include "aci_cmh.h"

#include "cmh_snd.h"

#include "dti_cntrl_mng.h"

#include "gaci_cmh.h"
#include "gaci.h"
#include "psa.h"
#include "cmh.h"
#include "psa_sm.h"
#include "cmh_sm.h"

/*==== CONSTANTS ==================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/
EXTERN void psaSN_CountReq ( UBYTE c_id, BOOL reset );


/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (8441)         MODULE  : CMH_SMS                  |
| STATE   : finnished             ROUTINE : sAT_PercentSNCNT         |
+--------------------------------------------------------------------+

PURPOSE : This is the functional counterpart to the %SNCNT = AT
          command which resets the SNDCP Counter.
*/
GLOBAL T_ACI_RETURN sAT_PercentSNCNT( T_ACI_CMD_SRC srcId, BOOL reset_counter )
{
  UBYTE i;
  UBYTE sndcp_id;

  TRACE_FUNCTION ("sAT_PercentSNCNT()");

  sndcpShrdPrm.srcId = srcId;

  for (i = 0; i < MAX_CID ; i++)         /* Count req is sent for both activated and deactivated CID */
  {
    if ( (pdp_context[i].state EQ CS_DATA_LINK OR
        pdp_context[i].state EQ CS_ACTIVATED) OR (pdp_context[i].nsapi NEQ UNUSED_NSAPI AND 
        pdp_context[i].state EQ CS_DEFINED))
    {
      sndcp_id = pdp_context[i].nsapi;
      psaSN_CountReq( sndcp_id, reset_counter );

      TRACE_EVENT_P1("found SNDCP connection on channel %d", sndcp_id);
    }
  }

  return AT_CMPL;
}

#endif /* GPRS */
