/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module implements the test fuinctions related to the
|             protocol stack adapter for GPRS session management ( SM ).
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef CMH_SMT_C
#define CMH_SMT_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_sm.h"
#include "psa_gppp.h"
#include "psa_gmm.h"

#include "cmh.h"
#include "cmh_sm.h"
#include "cmh_gppp.h"
#include "cmh_gmm.h"


/*==== CONSTANTS ==================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (8441)         MODULE  : CMH_SMS                  |
| STATE   : finnished             ROUTINE : tAT_PlusCGPADDR          |
+--------------------------------------------------------------------+

PURPOSE : This is the functional counterpart to the +CGPADDR= AT
          command which sets the requested QOS.
*/

GLOBAL T_ACI_RETURN tAT_PlusCGPADDR ( T_ACI_CMD_SRC srcId, SHORT *cids)
{
  SHORT cid = 1, index = 0;

  TRACE_FUNCTION ("tAT_PlusCGPADDR()");

  for (; cid <= MAX_CID; cid++)
    if ( get_state_over_cid(cid) NEQ CS_UNDEFINED )
      cids[index ++] = cid;

  cids[index] = INVALID_CID;

  return AT_CMPL;
}

GLOBAL T_ACI_RETURN tAT_PlusCGSMS   ( T_ACI_CMD_SRC srcId, SHORT *service_list)
{

  TRACE_FUNCTION ("tAT_PlusCGSMS()");

  *service_list = 15;

  return AT_CMPL;
}

#endif  /* GPRS */
/*==== EOF ========================================================*/
