/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module provides the query functions related to the
|             protocol stack adapter for GPRS session management ( SM ).
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef CMH_SMQ_C
#define CMH_SMQ_C
#endif

#include "aci_all.h"

/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "pcm.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_sm.h"

#include "cmh.h"
#include "cmh_sm.h"

#include "psa_gmm.h"

/*==== CONSTANTS ==================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : CMH_SMQ                  |
| STATE   : finished              ROUTINE : qAT_PlusCGQREQ           |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CGQREG? AT
            command which returns current settings for each defined PDP context.
*/
GLOBAL T_ACI_RETURN qAT_PlusCGQREQ ( T_ACI_CMD_SRC srcId, T_QOS **qos, SHORT *cid)
{
  USHORT i, j;
  TRACE_FUNCTION ("qAT_PlusCGQREQ()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  for ( i=j=0; i < MAX_CID; i++ )
  {
    if ( get_state_over_cid((SHORT) (i + 1)) EQ CS_DEFINED )
    {
      qos[j] = &pdp_context[i].con.qos;
      cid [j] = i + 1 ;
      j++;
    }
  }
  qos[j] = NULL;
  cid[j] = -1;

  return( AT_CMPL );
}


/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : CMH_SMQ                  |
| STATE   : finished              ROUTINE : qAT_PlusCGQMIN           |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CGQMIN? AT
            command which returns current settings for each defined PDP context.
*/
GLOBAL T_ACI_RETURN qAT_PlusCGQMIN ( T_ACI_CMD_SRC srcId, T_QOS **qos, SHORT *cid)
{
  USHORT i,j;
  TRACE_FUNCTION ("qAT_PlusCGQMIN()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  for ( i=j=0; i < MAX_CID; i++ )
  {
    if ( get_state_over_cid((SHORT) (i + 1)) EQ CS_DEFINED )
    {
      qos[j] = &pdp_context[i].con.min_qos;
      cid[j] = i + 1 ;
      j++;
    }
  }
  qos[j] = NULL;
  cid [j] = -1;

   return( AT_CMPL );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : CMH_SMQ                  |
| STATE   : finished              ROUTINE : qAT_PlusCGDCONT          |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CGCONT? AT
            command which returns current settings for each defined PDP context.
*/

GLOBAL T_ACI_RETURN qAT_PlusCGDCONT ( T_ACI_CMD_SRC srcId, T_GPRS_CONT_REC (*Ctxt)[MAX_CID_PLUS_EINS],
                                      SHORT *cid )
{
  T_CONTEXT_STATE state;
  USHORT i,j;
  TRACE_FUNCTION ("qAT_PlusCGDCONT()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  for ( i=j=0; i < MAX_CID; i++ )
  {
    state = get_state_over_cid((SHORT) (i + 1));
    if ( state NEQ CS_UNDEFINED )
    {
      memcpy (&((*Ctxt)[j]), &pdp_context[i].con, sizeof(T_GPRS_CONT_REC));

      if ( state EQ CS_ACTIVATED || state EQ CS_DATA_LINK)
        if ( strcmp(pdp_context[i].con.pdp_addr, pdp_context[i].allocated_pdp_addr) )
          (*Ctxt)[j].pdp_addr[0] = 0;

      cid[j] = i + 1 ;
      j++;
    }
  }
  cid [j] = INVALID_CID;

   return( AT_CMPL );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : CMH_SMQ                  |
| STATE   : finished              ROUTINE : qAT_PlusCGACT            |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CGACT? AT
            command which returns current activation states for all defined PDP context.
*/

GLOBAL T_ACI_RETURN qAT_PlusCGACT ( T_ACI_CMD_SRC srcId, BOOL *states, SHORT *cid )
{
  T_CONTEXT_STATE state = CS_INVALID_STATE;
  USHORT i,j;

  TRACE_FUNCTION ("qAT_PlusCGACT()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  for ( i=j=0; i < MAX_CID; i++ )
  {
    state = get_state_over_cid((SHORT) (i + 1));
    if ( state NEQ CS_UNDEFINED && state NEQ CS_INVALID_STATE )
    {
      if ( state EQ CS_ACTIVATED || state EQ CS_DATA_LINK )
        states[j] = TRUE;
      else
        states[j] = FALSE;

      cid[j] = i + 1 ;
      j++;
    }
  }
  cid [j] = INVALID_CID;

   return( AT_CMPL );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)           MODULE  : CMH_SMQ                  |
| STATE   : finished              ROUTINE : qAT_PlusCGAUTO           |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CGAUTO? AT
            command which returns current mode of automatic response
            to network requests.
*/

GLOBAL T_ACI_RETURN qAT_PlusCGAUTO  ( T_ACI_CMD_SRC srcId, T_CGAUTO_N *n)
{

  TRACE_FUNCTION ("qAT_PlusCGAUTO()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  *n = (T_CGAUTO_N) automatic_response_mode;

  return( AT_CMPL );
}

GLOBAL T_ACI_RETURN qAT_PlusCGEREP  ( T_ACI_CMD_SRC srcId, T_CGEREP_MODE *mode, T_CGEREP_BFR *bfr )
{

  TRACE_FUNCTION ("qAT_PlusCGEREP()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  *mode = ati_user_output_cfg[srcId].CGEREP_mode;
  *bfr  = ati_user_output_cfg[srcId].CGEREP_bfr;

  return( AT_CMPL );
}

GLOBAL T_ACI_RETURN qAT_PlusCGSMS   ( T_ACI_CMD_SRC srcId, T_CGSMS_SERVICE *service )
{

  TRACE_FUNCTION ("qAT_PlusCGSMS()");

/*
 *-------------------------------------------------------------------
 * check command source - should be Serial link ?
 *-------------------------------------------------------------------
 */
   if ( !cmh_IsVldCmdSrc (srcId) ) {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_Parameter );
      return( AT_FAIL );
   }

/*
 *-------------------------------------------------------------------
 * fill in parameters
 *-------------------------------------------------------------------
 */
  *service = sm_cgsms_service;

  return( AT_CMPL );
}

#endif  /* GPRS */
/*==== EOF ========================================================*/
