/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Definitions for the command handler of the
|             GPRS session management ( SM ).
+----------------------------------------------------------------------------- 
*/ 

#ifdef GPRS

#ifndef CMH_SM_H
#define CMH_SM_H

/*==== CONSTANTS ==================================================*/

/* dynamic numbers of nsapis */
#define SMH_FIRST_FREE_NSAPIS   SMREG_NSAPI_5
#define SMH_LAST_FREE_NSAPIS    SMREG_NSAPI_15
#define SMH_NSAPI_MAX           16

/* invalid values */
#define INVALID_NSAPI  (0xFF)          /* marks an invalid nsapi */

/* not used nsapi */
#define UNUSED_NSAPI   (0x00)          /* nsapi currently not in use */

/* for network requested context activation */
#define MAX_GPRS_CALL_TABLE_ENTRIES   2
  /* MAX_PDP_TYPE_LEN + MAX_PDP_ADDR_LEN + MAX_L2P_LENGTH = 7 + 21 + 6 = 34 */
#define MAX_CRING_INFORMATION_LENGTH  42

/* undefiend smreg_ti */
#define UNDEFINED_TI 0xFF

typedef enum
{
  PCO_USER,
  PCO_NETWORK

} T_PCO_TYPE;

typedef enum
{
  SNDCP_PEER_NORMAL,
  SNDCP_PEER_SWITCHED

} T_SNDCP_PEER;

typedef enum
{
  GCTT_NORMAL = 0,
  GCTT_REACTIVATION

} T_GPRS_CALL_TABLE_TYPE;

/*==== TYPES ======================================================*/

typedef struct
{
  UBYTE   len;
  UBYTE   pco[251];
} T_GPRS_CONT_PCO;

typedef struct
{
  T_CONTEXT_STATE       state;
  UBYTE                 nsapi;
  UBYTE                 smreg_ti;
  T_DTI_CONN_LINK_ID    link_id_sn;
  T_DTI_CONN_LINK_ID    link_id_uart;
  T_DTI_CONN_LINK_ID    link_id_new;
  T_DTI_ENTITY_ID       entity_id;
  T_GPRS_CONT_REC       con;
  T_QOS                 qos;
  T_PDP_ADDRESS         allocated_pdp_addr;
  T_ACI_CMD_SRC         owner;
  T_GPRS_CONT_PCO       user_pco;     /* setup with %CGPCO=... */
  T_GPRS_CONT_PCO       network_pco;  /* setup with SMREG_PDP_ACTIVATE_CNF */
} T_GPRS_CONT_CLASS;

typedef struct
{
  T_SMREG_PDP_ACTIVATE_IND    sm_ind;
  char                        L2P[MAX_L2P_LENGTH];
  SHORT                       cid;
  UBYTE                       reactivation;         /* T_GPRS_CALL_TABLE_TYPE */

} T_GPRS_CALL_TABLE;

typedef enum            /* GPRS Packet Data Protocol type */
{
  PDP_T_NONE = 0,       /* no valid PDP type */
  PDP_T_X25,            /* ITU-T/CCITT X.25 layer 3 */
  PDP_T_IP,             /* Internet Protocol (IETF STD 5) */
  PDP_T_MAX             /* maximum GPRS PDP types */

} T_GACI_PDP_TYPE;

#ifdef CO_UDP_IP
typedef void  T_SM_IP_CB (T_ACI_RETURN result);
#endif /* WAP || SAT E */

/*==== PROTOTYPES =================================================*/
EXTERN void   cmhSM_NetDeactivate       ( void );
EXTERN void   cmhSM_Deactivated         ( void );
EXTERN void   cmhSM_NetActivate         ( void );
EXTERN SHORT  cmhSM_NoActivate          ( void );
EXTERN SHORT  cmhSM_Activated           ( T_SMREG_PDP_ACTIVATE_CNF *pdp_cnf );
EXTERN void   cmhSM_NetModify           ( USHORT nsapi_set, T_smreg_qos *qos );

EXTERN void   cmhSM_Init                ( void );
EXTERN void   cmhSM_Reset               ( void );
EXTERN void   cmhSM_ResetNonWorkingContexts( void );
EXTERN void   cmhSM_empty_call_table    ( void );
EXTERN void   cmhSM_GiveNSapiFree       ( USHORT cid );
EXTERN void   cmhSM_contextDeactivated  ( void );
EXTERN USHORT cmhSM_pdp_typ_to_string   ( UBYTE pdp_typ_no, char* string );
EXTERN UBYTE  cmhSM_Get_pdp_type        ( void );
EXTERN void   cmhSM_Get_pdp_address     ( T_pdp_address *pdp_address );
EXTERN SHORT  cmhSM_pdp_address_to_ip   ( T_PDP_ADDRESS *pdp_address, UBYTE *ip );
EXTERN void   cmhSM_ip_to_pdp_address   ( UBYTE *ip, T_PDP_ADDRESS pdp_address );
EXTERN void   cmhSM_Get_smreg_apn       ( T_smreg_apn   *smreg_apn );
EXTERN UBYTE  cmhSM_Get_h_comp          ( void );
EXTERN UBYTE  cmhSM_Get_d_comp          ( void );
EXTERN void   cmhSM_change_def_QOS      ( T_QOS *qos );
EXTERN void   cmhSM_change_def_QOS_min  ( T_QOS *qos );
EXTERN void   cmhSM_Set_default_QOS     ( SHORT cid );
EXTERN void   cmhSM_Set_default_QOS_min ( SHORT cid );
EXTERN void   cmhSM_Get_QOS             ( T_smreg_qos     *dest_qos );
EXTERN void   cmhSM_Get_QOS_min         ( T_smreg_min_qos *dest_qos_min );
EXTERN char*  cmhSM_ring_gprs_par       ( void );
EXTERN BOOL   cmhSM_call_answer         ( UBYTE ring_counter, T_ACI_CRING_MOD mode );
EXTERN BOOL   cmhSM_call_reject         ( UBYTE ring_counter, T_ACI_CRING_MOD mode );
EXTERN BOOL   cmhSM_sAT_H               ( T_ACI_CMD_SRC srcId, T_ACI_RETURN *aci_ret );
EXTERN BOOL   cmhSM_sAT_A               ( T_ACI_CMD_SRC srcId, T_ACI_RETURN *aci_ret );
EXTERN USHORT cmhSM_Give_nsapi_set      ( SHORT cid );
EXTERN BOOL   cmhSM_pdp_addr_well_formed( USHORT type, T_PDP_ADDRESS pdp_addr );
EXTERN BOOL   cmhSM_apn_well_formed     ( T_APN apn );
EXTERN USHORT cmhSM_transform_pdp_type  ( char *pdp_type );
EXTERN void   cmhSM_cgerep_buffer       ( void );
EXTERN void   cmhSM_save_event          ( T_CGEREP_EVENT event, T_CGEREP_EVENT_REP_PARAM *param );
EXTERN void   cmhSM_set_sms_service     ( T_CGSMS_SERVICE service );
EXTERN void   cmhSM_sms_service_changed ( UBYTE service );
EXTERN SHORT  cmhSM_get_cid             ( USHORT nsapi );
EXTERN BOOL   cmhSM_next_work_cid       ( T_ACI_AT_CMD curCmd );
EXTERN SHORT  cmhSM_define_cid_list     ( T_ACI_CMD_SRC srcId, SHORT *cids );

EXTERN SHORT  cmhSM_get_pdp_addr_for_CGPADDR  ( SHORT cid, T_PDP_ADDRESS pdp_adress );

EXTERN T_ACI_RETURN cmhSM_GprsAttached        ( SHORT state );
EXTERN T_ACI_RETURN cmhSM_activate_context    (void);
EXTERN void   cmhSM_data_link_context         (void);

#ifdef DTI
EXTERN SHORT  cmhSM_connect_context           ( SHORT cid, T_DTI_ENTITY_ID peer, UBYTE ppp_hc, UBYTE msid );
#endif /* DTI */

EXTERN SHORT  cmhSM_context_connected         ( USHORT nsapi);

EXTERN BOOL   cmhSM_is_smreg_ti_used          ( UBYTE smreg_ti, SHORT *cid );
EXTERN void   cmhSM_context_reactivation      ( void );
EXTERN void   cmhSM_stop_context_reactivation ( void );
EXTERN void   cmhSM_next_call_table_entry     ( void );

EXTERN SHORT  cmhSM_connect_working_cid       ( void );

EXTERN void   cmhSM_set_PCO( SHORT cid, T_PCO_TYPE pco_type, UBYTE* buf_addr, UBYTE length);
#if defined (CO_UDP_IP) || defined (FF_GPF_TCPIP)
EXTERN void   cmhSM_IP_activate_cb        (T_ACI_RETURN result);
EXTERN void   cmhSM_IP_Enable             (T_DTI_CONN_LINK_ID link_id );
EXTERN void   cmhSM_IP_Disable            (void);
#endif /* CO_UDP_IP || FF_GPF_TCPIP */

/* execution AT set command without parameter check */
EXTERN void sAT_PlusCGDCONT_exec ( T_ACI_CMD_SRC srcId, SHORT cid, T_GPRS_CONT_REC *inputCtxt);

EXTERN ULONG  cmhSM_get_link_id_SNDCP_peer    ( SHORT cid, T_SNDCP_PEER which );
EXTERN void   cmhSM_context_deactivated       ( USHORT nsapi_set );
EXTERN void   cmhSM_connection_down           ( UBYTE dti_id );

EXTERN T_ACI_CMD_SRC cmhSM_getSrcIdOfRunningCGACTDeactivation(SHORT cid);
EXTERN BOOL isContextDeactivationRequestedByCGACT(SHORT cid);

EXTERN T_ACI_RETURN cmhSM_deactivateContexts   ( T_ACI_CMD_SRC srcId, SHORT *cids);
EXTERN T_ACI_RETURN cmhSM_deactivateAContext   ( T_ACI_CMD_SRC srcId, SHORT cid );

#ifdef DTI
EXTERN void   cmhSNDCP_Disable                ( T_DTI_CONN_LINK_ID link_id );
#endif /* DTI */

EXTERN void   cmhSM_ip_to_pdp_address         ( UBYTE *ip, T_PDP_ADDRESS pdp_address );

#ifdef FF_SAT_E
EXTERN T_QOS* cmhSM_getCurQOS                 ( SHORT cid );
#endif /* FF_SAT_E */

EXTERN BOOL   cmhSM_isContextActive           ( void );

#ifdef DTI
EXTERN  void  set_conn_param_on_working_cid ( UBYTE owner, T_DTI_ENTITY_ID entity_id );
EXTERN  void  set_conn_param_on_all_working_cids ( UBYTE owner, T_DTI_ENTITY_ID entity_id );
#endif /* DTI */

/*==== EXPORT =====================================================*/
#ifdef CMH_SMF_C

GLOBAL T_ENT_STAT   smEntStat;

T_GPRS_CONT_CLASS   pdp_context[MAX_CID];
SHORT               work_cids[MAX_CID_PLUS_EINS];
SHORT               cid_pointer;
T_GPRS_CONT_REC     defaultCtx;

SHORT               automatic_response_mode;

/* network requested context activation */
T_GPRS_CALL_TABLE   gprs_call_table[MAX_GPRS_CALL_TABLE_ENTRIES];
SHORT               current_gprs_ct_index;
SHORT               gprs_ct_index;

T_CGSMS_SERVICE     sm_cgsms_service;

#else

EXTERN T_ENT_STAT          smEntStat;

EXTERN T_GPRS_CONT_CLASS   pdp_context[MAX_CID];
EXTERN SHORT               work_cids[MAX_CID_PLUS_EINS];
EXTERN SHORT               cid_pointer;
EXTERN T_GPRS_CONT_REC     defaultCtx;

EXTERN SHORT               automatic_response_mode;

/* network requested context activation */
EXTERN T_GPRS_CALL_TABLE   gprs_call_table[MAX_GPRS_CALL_TABLE_ENTRIES];
EXTERN SHORT               current_gprs_ct_index;
EXTERN SHORT               gprs_ct_index;

EXTERN T_CGSMS_SERVICE     sm_cgsms_service;

#endif /* CMH_SMF_C */

#endif /* CMH_SM_H */


#endif  /* GPRS */
/*==== EOF =======================================================*/
