/*
+------------------------------------------------------------------------------
|  File:       cmh_pktio.c
+------------------------------------------------------------------------------
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG.
+------------------------------------------------------------------------------
| Purpose:     This module defines the functions used by the command
|              handler for packet I/O (PKTIO).
+------------------------------------------------------------------------------
*/

#if defined (GPRS ) && defined (DTI)
#ifdef FF_PKTIO
#ifndef CMH_PKTIO_C
#define CMH_PKTIO_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "gprs.h"

#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "aci.h"
#include "psa.h"

#include "cmh.h"


#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"
#include "sap_dti.h"
#include "gaci.h"
#include "gaci_cmh.h"
#include "cmh_sm.h"
#include "psa_pktio.h"
#include "cmh_pktio.h"


/*==== CONSTANTS ==================================================*/
#define MAX_BAUD_RATE 20
/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/
/*==== VARIABLES ==================================================*/
/*==== FUNCTIONS ==================================================*/
LOCAL void set_baudrate (T_ACI_PKTIO_CAP *capabilities);
/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)            MODULE  : CMH_PKTIO               |
| STATE   : finished               ROUTINE :  search_baudrate        |
+--------------------------------------------------------------------+

  PURPOSE : search and set the highest baudrate in DIO capabilities 
            to send in response PKT_CONNECT_RES
*/
LOCAL void set_baudrate (T_ACI_PKTIO_CAP * capabilities)
{
  U32 baud_rate = DIO_BAUD_812500;
  UBYTE i;

  for(i= 0;i<MAX_BAUD_RATE;i++)
  {   
    if((capabilities->baud & baud_rate) EQ baud_rate)
    { 
      capabilities->baud = baud_rate;
      break;
    }
    else
    {
      baud_rate = baud_rate>>1;
    }
  }    
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                      MODULE  : CMH_PKTIO     |
| STATE   : finished                         ROUTINE : cmhPKT_Ind    |
+--------------------------------------------------------------------+

  PURPOSE : 
*/
GLOBAL void cmhPKT_Ind (T_ACI_PKTIO *pkt_indic_msg)
{
  T_ACI_PKTIO_CAP capabilities;
 
  TRACE_FUNCTION ("cmhPKT_Ind()");

  /* register device to the DTI Control Manager */
  dti_cntrl_new_device ( DTI_SRC_ID_NOTPRESENT,   /* ATI source ID */
                         DTI_ENTITY_PKTIO,         /* device ID  */
                         pkt_indic_msg->device_no, /* device number  */ 
                         UART_DLCI_NOT_MULTIPLEXED,/* sub-channel number */
                         DTI_PORT_NUMBER_NOTPRESENT,/* ATI-RIV port number */
                         pkt_indic_msg->pktio_cap.convergence,/* capabilities */
                         DTI_DRIVER_ID_NOTPRESENT,
                         DTI_DIO_ID_NOTPRESENT);  

  memset(&capabilities,0,sizeof(T_ACI_PKTIO_CAP));
  memcpy(&capabilities,&pkt_indic_msg->pktio_cap,sizeof(T_ACI_PKTIO_CAP));
  set_baudrate(&capabilities);
  psaPKT_ConnectRes ( pkt_indic_msg->device_no, &capabilities);
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                     MODULE  : CMH_PKTIO      |
| STATE   : finished                        ROUTINE : cmhPKT_OpenCnf |
+--------------------------------------------------------------------+

  PURPOSE : 
*/
GLOBAL void cmhPKT_OpenCnf (UBYTE device_number, T_DTI_CONN_RESULT result)
{
  ULONG link_id;
    
  TRACE_FUNCTION ("cmhPKT_OpenCnf()");
    
  link_id = dti_cntrl_get_link_id(DTI_ENTITY_PKTIO, device_number, 
                                  UART_DLCI_NOT_MULTIPLEXED); 
  dti_cntrl_entity_connected( link_id, DTI_ENTITY_PKTIO,result);
}

/*
+--------------------------------------------------------------------+
| PROJECT : GPRS (8441)                   MODULE  : CMH_PKTIO        |
| STATE   : finished                      ROUTINE : cmhPKT_Close     |
+--------------------------------------------------------------------+

  PURPOSE : 
*/
GLOBAL void cmhPKT_Close (UBYTE device_no, T_CMH_PKT_STATE state)
{
  ULONG link_id;
  SHORT cid;

    
  TRACE_FUNCTION ("cmhPKT_Close()");
  
  link_id = dti_cntrl_get_link_id(DTI_ENTITY_PKTIO, device_no, 
                                  UART_DLCI_NOT_MULTIPLEXED); 
  switch(state)
  {
    case DTI_CLOSE_CNF:
      dti_cntrl_entity_disconnected(link_id, DTI_ENTITY_PKTIO);
      break;
    case DTI_CLOSE_IND:
      dti_cntrl_entity_disconnected(link_id, DTI_ENTITY_PKTIO);
      dti_cntrl_close_dpath_from_dti_id(EXTRACT_DTI_ID(link_id));
      break;
    case DTI_DISC_IND:
      return;
    default:
      return;
  }    

  cid = gaci_get_cid_over_link_id(link_id);
  if( INVALID_CID NEQ cid)
  {
    gaci_RAT_caller(RAT_NO_CARRIER, cid, AT_CMD_CGDATA, CME_ERR_Unknown);
  }
  cmhSM_connection_down((UBYTE)EXTRACT_DTI_ID(link_id));
}


#endif
#endif  /* GPRS */
/*==== EOF ========================================================*/
