/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  CMH_LCQ
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module provides the query functions related to the
|             protocol stack adapter for the location service.
+----------------------------------------------------------------------------- 
*/ 

#ifndef CMH_LCQ_C
#define CMH_LCQ_C
#endif

#ifdef FF_EOTD

#ifdef MFW
#define ENTITY_MFW
#else
#ifdef SMI
#define ENTITY_SMI
#else
#define ENTITY_ACI
#endif
#endif

#define ACI_MEMBER

/*==== INCLUDES ===================================================*/
#include "aci_all.h"
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "psa.h"
#include "cmh.h"

#include "cmh_lc.h"



/*==== CONSTANTS ==================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/
/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : CMH_LC                   |
| STATE   : code                  ROUTINE : qAT_PlusCLSA             |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CLSA?
            AT command which returns the Service Mobile Location
            Center source and destination address.

            <mlcsc>: mobile location center source address
            <mlcda>: mobile location center destination address

*/
GLOBAL T_ACI_RETURN qAT_PlusCLSA ( T_ACI_CMD_SRC srcId,
                                   CHAR*         mlcsc,
                                   CHAR*         mlcda)
{
   T_LOC_SERV_PARA *p_lsprm = 0;

   TRACE_FUNCTION ("qAT_PlusCLSA ()");

  /*
   *-----------------------------------------------------------------
   * check command source
   *-----------------------------------------------------------------
   */
    if(!cmh_IsVldCmdSrc (srcId))
    {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_LCS_CmdNotRec);
      return( AT_FAIL );
    }

    p_lsprm = &locServPrm; /* global structure LC parameters */

  /*
   *-----------------------------------------------------------------
   * fill in parameters
   *-----------------------------------------------------------------
   */

   if(!mlcsc)
   {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_LCS_CmdNotRec);
      return( AT_FAIL );
    }
   else
   {
        if(p_lsprm->mlcsrc.toa.ton EQ TON_International)
        *mlcsc++ = '+';
         strncpy(mlcsc,p_lsprm->mlcsrc.address,strlen(p_lsprm->mlcsrc.address));
   }
   if(!mlcda)
    ;
   else
   {
        if(p_lsprm->mlcdest.toa.ton EQ TON_International)
            *mlcda++ = '+';
        strncpy(mlcda,p_lsprm->mlcdest.address,strlen(p_lsprm->mlcdest.address));
   }

   return ( AT_CMPL );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : CMH_LC                   |
| STATE   : code                  ROUTINE : qAT_PlusCLOM             |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CLOM?
            AT command which returns the Operating mode settings of
            Location service
            <number_lc_clients>: number of LC client entries in list
            <client_list>: pointer to list of LC clients

*/
GLOBAL T_ACI_RETURN qAT_PlusCLOM ( T_ACI_CMD_SRC srcId,
                                   UBYTE        * number_lc_clients,
                                   T_LOC_SERV_PARA  ** client_list)
{
   T_LOC_SERV_PARA *p_client_list = 0;

   TRACE_FUNCTION ("qAT_PlusCLOM ()");
  /*
   *-----------------------------------------------------------------
   * check command source
   *-----------------------------------------------------------------
   */
    if(!cmh_IsVldCmdSrc (srcId))
    {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_LCS_CmdNotRec );
      return( AT_FAIL );
    }
   p_client_list = &locServPrm; /* global structure LC parameters */
  /*
   *-----------------------------------------------------------------
   * fill in parameters
   *-----------------------------------------------------------------
   */

   *number_lc_clients = p_client_list->numb_lc_clients;
   *client_list = p_client_list;
   return ( AT_CMPL );
}

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : CMH_LC                   |
| STATE   : code                  ROUTINE : qAT_PlusCLPS             |
+--------------------------------------------------------------------+

  PURPOSE : This is the functional counterpart to the +CLPS?
            AT command which returns the Periodic Update settings of
            Location service
            <number_lc_clients>: number of LC client entries in list
            <client_list>: pointer to list of LC clients

*/
GLOBAL T_ACI_RETURN qAT_PlusCLPS ( T_ACI_CMD_SRC srcId,
                                   UBYTE        * number_lc_clients,
                                   T_LOC_SERV_PARA  ** client_list)
{
   T_LOC_SERV_PARA *p_client_list = 0;

   TRACE_FUNCTION ("qAT_PlusCLPS ()");
  /*
   *-----------------------------------------------------------------
   * check command source
   *-----------------------------------------------------------------
   */
    if(!cmh_IsVldCmdSrc (srcId))
    {
      ACI_ERR_DESC( ACI_ERR_CLASS_Ext, EXT_ERR_LCS_CmdNotRec );
      return( AT_FAIL );
    }
   p_client_list = &locServPrm; /* global structure LC parameters */
  /*
   *-----------------------------------------------------------------
   * fill in parameters
   *-----------------------------------------------------------------
   */

   *number_lc_clients = p_client_list->numb_lc_clients;
   *client_list = p_client_list;
   return ( AT_CMPL );
}

#endif /* FF_EOTD */
/*==== EOF ========================================================*/
