/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  CMH_LC
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  Definitions for the command handler of the
|             Location Service
+----------------------------------------------------------------------------- 
*/ 

#ifndef CMH_LC_H
#define CMH_LC_H
#endif

#if defined FF_EOTD
/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/
/* T_LC_NVM_DATA */
/*
 * Caution! An identical definition must be contained in the file
 * ...\lc\lc.h
 */
typedef struct
{
  UBYTE eotd;       /* 0: EOTD detection by RR 1: EOTD assumed */
  UBYTE cps_trace;  /* 0: CPS log not started automatically 1: CPS log started */
  UBYTE periodic;   /* 0: periodic SMS by AT commands only 1: periodic SMS restarted */
  UBYTE sleep;      /* 0: no change of sleep mode 1: sleep switched off */
} T_LC_NVM_DATA;

/*==== PROTOTYPES =================================================*/

EXTERN void cmhLC_posDataReq (char*    clientId, USHORT   lcCallRefId);
EXTERN void cmhSMS_MEASdeliver ( UBYTE *lc_meas_buf);
EXTERN UBYTE lc_callref_init (void);
T_ACI_RETURN lclist_init (void);
/* EXTERN void lclist_deinit (void); */

/*==== EXPORT =====================================================*/

#ifdef CMH_LCS_C
EXTERN UBYTE             v_eotd;
GLOBAL T_LOC_SERV_PARA   locServPrm;  /* list of LC clients */
GLOBAL BOOL location_service_flag;    /* status of feature location service (E-OTD) */
GLOBAL BOOL eotd_periodic_update_flag;/* status of feature Periodic Update (E-OTD) */

GLOBAL T_LOC_MLC_ADDRESS lc_orig_addr;
GLOBAL T_LOC_POS_DATA aci_lc_data;
GLOBAL USHORT used_lc_callref = 1;

#else
EXTERN T_LOC_SERV_PARA   locServPrm;  /* list of LC clients */
EXTERN BOOL location_service_flag;    /* status of feature location service (E-OTD) */
EXTERN BOOL eotd_periodic_update_flag;/* status of feature Periodic Update (E-OTD) */
EXTERN T_LOC_MLC_ADDRESS lc_orig_addr;
EXTERN T_LOC_POS_DATA aci_lc_data;
EXTERN USHORT used_lc_callref;

#endif

/*==== EOF =======================================================*/
#endif
