/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the functions which are responsible
|             for the responses of the protocol stack adapter for
|             GPRS Point-to-Point Protocol ( PPP ).
+----------------------------------------------------------------------------- 
*/ 

#if defined (GPRS) && defined (DTI)

#ifndef CMH_GPPPR_C
#define CMH_GPPPR_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/

#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "aci.h"
#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_gppp.h"
#include "psa_sm.h"
#include "psa_uart.h"

#include "psa_aaa.h"

#include "cmh.h"
#include "cmh_gppp.h"
#include "cmh_sm.h"

#include "sap_dti.h"

/*==== CONSTANTS ==================================================*/


/*==== TYPES ======================================================*/


/*==== EXPORT =====================================================*/


/*==== VARIABLES ==================================================*/


/*==== FUNCTIONS ==================================================*/

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)      MODULE  : CMH_PPPR                     |
| STATE   : finnished        ROUTINE : cmhGPPP_Established           |
+-------------------------------------------------------------------+

  PURPOSE : establish a PPP link was successful

*/
GLOBAL SHORT cmhGPPP_Established ( void )
{

  TRACE_FUNCTION ("cmhGPPP_Established()");

  switch( gpppEntStat.curCmd )
  {
    case( AT_CMD_CGDATA ):
      /* no action, because the PDP context will be terminated */
      if ( CS_ESTABLISH_3 NEQ get_state_working_cid() )
        return 0;

      if ( gpppShrdPrm.ppp_hc  NEQ  gpppShrdPrm.est.ppp_hc ||
           gpppShrdPrm.msid    NEQ  gpppShrdPrm.est.msid      )
      {
     /*
      *   the PC won' t header compression now
      */

        /* brz: to check */

      }
/*    else*/
      {
        set_state_working_cid( CS_DATA_LINK );
        /*
         *  do we need one more context activation
         */
        if ( FALSE EQ cmhSM_next_work_cid( AT_CMD_CGDATA ) )
        {
          R_AT( RAT_CGDATA, pdp_context[work_cids[cid_pointer] - 1].owner )
                            (pdp_context[work_cids[cid_pointer] - 1].link_id_sn);
        }
      }
      cmhSM_next_call_table_entry();
      break;
  }
  return 0;
}


/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)      MODULE  : CMH_PPPR                     |
| STATE   : code             ROUTINE : cmhGPPP_Terminated           |
+-------------------------------------------------------------------+

  PURPOSE : PPP connection is closed

*/
GLOBAL SHORT cmhGPPP_Terminated ( void )
{
  T_ACI_CMD_SRC     rat_owner;
  UBYTE   cmdBuf  = gpppEntStat.curCmd,/* buffers current command */
          cme_err = CME_ERR_Unknown;   /* error number */
  T_DTI_CONN_LINK_ID dti_id_sn;
  SHORT   cid,                         /* is the PDP context activated */
          reactivation = 0,
          rat_id = RAT_MAX;
  USHORT  nsapi_set = 0;
#ifdef FF_TCP_IP
  T_DTI_ENTITY_ID peer;
#endif
  UBYTE srcId = srcId_cb;

  TRACE_FUNCTION ("cmhGPPP_Terminated()");


  cid = gaci_get_cid_over_link_id(gaci_get_link_id_over_peer(DTI_ENTITY_PPPS));

  dti_id_sn = cmhSM_get_link_id_SNDCP_peer( cid, SNDCP_PEER_NORMAL );

#ifdef FF_TCP_IP
  peer = dti_cntrl_get_peer(DTI_ENTITY_PPPS, 0, 0);
  if ( peer EQ DTI_ENTITY_AAA )
  {
    psaAAA_disconnect_ind (pdp_context[cid - 1].link_id_uart);
  }
#endif

  switch ( get_state_over_cid( cid ) )
  {
    case CS_UNDEFINED:
    case CS_DEFINED:
    case CS_WAITS_FOR_ACTIVATING:
    case CS_ACTIVATING:
    case CS_ACTIVATED:
    case CS_DEACTIVATE_NORMAL:
      break;
    case CS_ESTABLISH_2:
    case CS_ESTABLISH_3:
      set_state_over_cid( cid, CS_ABORT_ESTABLISH );
      nsapi_set  = cmhSM_Give_nsapi_set( cid );
      dti_cntrl_entity_disconnected( dti_id_sn , DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      break;
    case CS_ESTABLISH_1:
      cmhSM_contextDeactivated();
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_SNDCP );
      /*lint -fallthrough*/
    case CS_ABORT_ESTABLISH:
    case CS_BREAKDOWN_LINK_ERROR:
      set_state_over_cid( cid, CS_DEFINED );
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      if(ati_user_output_cfg[srcId].CMEE_stat EQ CMEE_MOD_Disable OR isContextDeactivationRequestedByCGACT(cid))
        rat_id = RAT_NO_CARRIER;
      else
        rat_id = RAT_CME;
      break;
    case CS_BREAKDOWN_LINK_NORMAL:
      set_state_over_cid( cid, CS_DEFINED );
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      rat_id = RAT_NO_CARRIER;
      break;
    case CS_DATA_LINK:
      set_state_over_cid( cid, CS_BREAKDOWN_LINK_NORMAL );
      nsapi_set  = cmhSM_Give_nsapi_set( cid );
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      break;
    case CS_CONTEXT_REACTIVATION_1:
      set_state_over_cid(cid, CS_CONTEXT_REACTIVATION_2);
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      gpppEntStat.curCmd = AT_CMD_NONE;
      cmhSM_connection_down((UBYTE)EXTRACT_DTI_ID(dti_id_sn));
      return 0;
    case CS_CONTEXT_REACTIVATION_2:
      set_state_over_cid(cid, CS_DEFINED);
      dti_cntrl_entity_disconnected( dti_id_sn, DTI_ENTITY_PPPS );
      dti_cntrl_set_dti_id_to_reconnect(EXTRACT_DTI_ID(dti_id_sn));
      dti_cntrl_entity_disconnected( pdp_context[cid - 1].link_id_uart, DTI_ENTITY_PPPS );
      gpppEntStat.curCmd = AT_CMD_NONE;
      rat_id = RAT_NO_CARRIER;
      reactivation = 1;
      break;
  }

  rat_owner = get_owner_over_cid(cid);

  if ( reactivation EQ 0 )
  {
    /* Do we need a SMREG_PDP_DEACTIVATE_REQ? */
    if ( nsapi_set )
    {
      psaSM_PDP_Deactivate ( nsapi_set, SMREG_NONLOCAL);
    }
  /*
   *-------------------------------------------------------------------
   * check for command context
   *-------------------------------------------------------------------
   */
    switch( gpppEntStat.curCmd )
    {
      case( AT_CMD_CGDATA ):
        if ( rat_owner EQ gpppEntStat.entOwn )
        {
          gpppEntStat.curCmd = AT_CMD_NONE;
        }
        /* brz: to check */
        switch(gpppShrdPrm.ppp_cause)
        {
          case PPP_TERM_OK_PEER:
          case PPP_TERM_NO_RESPONSE:
          case PPP_TERM_LOOP_BACK:
          case PPP_TERM_LCP_NOT_CONVERGE:
          case PPP_TERM_IPCP_NOT_CONVERGE:
          case PPP_TERM_IPCP_NOT_STARTED:
            cme_err = CME_ERR_GPRSBadModClass;
            break;
          case SMREG_RC_USE_AUTHED_FAILED:
          case PPP_TERM_USE_AUTHED_FAILED:
            cme_err = CME_ERR_GPRSPdpAuth;
            break;
          default:
            cme_err = CME_ERR_Unknown;
        }
        break;
#if 0
      /*
       * These cases do never happen!
       */
      case( AT_CMD_CGACT ):
      case( AT_CMD_CGANS ):
      case( AT_CMD_A ):
      case( AT_CMD_H ):
        break;
#endif
      default:
        switch(gpppShrdPrm.ppp_cause)
        {
          case SMREG_RC_SERV_OPT_NOT_SUPP:
            cme_err = CME_ERR_GPRSSerOptNsup;
            break;
          case SMREG_RC_SERV_OPT_NOT_SUBS:
            cme_err = CME_ERR_GPRSSerOptNsub;
            break;
          case SMREG_RC_SERV_OPT_TEMP_OOO:
            cme_err = CME_ERR_GPRSSerOptOOO;
            break;
          case PPP_TERM_USE_AUTHED_FAILED:
          case SMREG_RC_USE_AUTHED_FAILED:
            cme_err = CME_ERR_GPRSPdpAuth;
            break;
          default:
            cme_err = CME_ERR_Unknown;
        }
    }
    if ( smEntStat.entOwn EQ rat_owner )
    {
        switch( smEntStat.curCmd )
        {
          case( AT_CMD_CGDATA ):
          case( AT_CMD_CGACT ):
            smEntStat.curCmd = AT_CMD_NONE;
            break;
        }
    }
  }

  cmhSM_connection_down((UBYTE)EXTRACT_DTI_ID(dti_id_sn));

  if ( rat_id NEQ RAT_MAX )
  {
    gaci_RAT_caller ( rat_id, cid, cmdBuf, cme_err );
    
    cid_pointer  = 0;
    *work_cids = 0;

    cmhSM_context_reactivation();
    cmhSM_disconnect_cid(cid, GC_TYPE_DATA_LINK);
  }

  return 0;
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)      MODULE  : CMH_PPPR                     |
| STATE   : finished         ROUTINE : cmhGPPP_Activated             |
+-------------------------------------------------------------------+

  PURPOSE : activate the PDP context (only in server mode)

*/
GLOBAL SHORT cmhGPPP_Activated ( void )
{
  SHORT cid = work_cids[0];

  TRACE_FUNCTION ("cmhGPPP_Activated()");

/*
 *-------------------------------------------------------------------
 * check for command context
 *-------------------------------------------------------------------
 */
  switch( gpppEntStat.curCmd )
  {
    case( AT_CMD_CGANS ):
    case( AT_CMD_CGDATA ):
    /*
     *---------------------------------------------------------------
     * check entity status and context state
     *---------------------------------------------------------------
     */
      if ( CS_ESTABLISH_1 NEQ get_state_working_cid() )
        return 0;

    /*
     *---------------------------------------------------------------
     * save parameter
     *---------------------------------------------------------------
     */
      gpppShrdPrm.ppp_hc = gpppShrdPrm.pdp->ppp_hc; 
      gpppShrdPrm.msid   = gpppShrdPrm.pdp->msid;

      cmhSM_set_PCO(  cid, PCO_USER, 
                      &gpppShrdPrm.pdp->sdu.buf[gpppShrdPrm.pdp->sdu.o_buf >> 3],
                      (UBYTE) (gpppShrdPrm.pdp->sdu.l_buf >> 3));

    /*
     *---------------------------------------------------------------
     * process parameter
     *---------------------------------------------------------------
     */
      smEntStat.curCmd          = gpppEntStat.curCmd;
      smShrdPrm.owner           = gpppShrdPrm.owner;
      smEntStat.entOwn          = smShrdPrm.owner;

      cmhSM_connect_context ( cid, DTI_ENTITY_PPPS,
                              gpppShrdPrm.ppp_hc, gpppShrdPrm.msid);

      set_state_working_cid( CS_ESTABLISH_2 );
      break;
    default:
      return -1;
  }

  return 0;
}

/*
+-------------------------------------------------------------------+
| PROJECT : GPRS (8441)      MODULE  : CMH_PPPR                     |
| STATE   : finished         ROUTINE : cmhGPPP_Modified             |
+-------------------------------------------------------------------+

  PURPOSE : new negotiate header compression confirmed (only in server mode)

*/
GLOBAL SHORT cmhGPPP_Modified ( void )
{
  TRACE_FUNCTION ("cmhGPPP_Modified()");

/*
 *---------------------------------------------------------------
 * nothing to do
 *---------------------------------------------------------------
 */

  return 0;
}

#endif /* GPRS */
/*==== EOF ========================================================*/

