/* 
+----------------------------------------------------------------------------- 
|  Project :  
|  Modul   :  
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module defines the functions used by the command
|             handler for GPRS Point-to-Point Protocol ( PPP ).
+----------------------------------------------------------------------------- 
*/ 

#if defined (GPRS) && defined (DTI)

#ifndef CMH_PPPF_C
#define CMH_PPPF_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/
#include "dti.h"      /* functionality of the dti library */
#include "aci_cmh.h"
#include "ati_cmd.h"
#include "aci_cmd.h"
#include "pcm.h"

#include "dti_conn_mng.h"
#include "dti_cntrl_mng.h"

#include "aci.h"
#include "gaci.h"
#include "gaci_cmh.h"
#include "psa.h"
#include "psa_gppp.h"
#include "psa_sm.h"

#include "cmh.h"
#include "cmh_gppp.h"
#include "cmh_sm.h"
/*==== CONSTANTS ==================================================*/

/*==== TYPES ======================================================*/

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

GLOBAL void cmhGPPPS_Disable( T_DTI_CONN_LINK_ID  link_id )
{
  
  cmhSM_deactivateAContext(CMD_SRC_NONE, gaci_get_cid_over_link_id( link_id ));
}

GLOBAL void cmhGPPPS_DTIconnected( UBYTE dti_direction )
{
  T_DTI_CONN_LINK_ID link_id = DTI_LINK_ID_NOTPRESENT;

  TRACE_FUNCTION ("cmhGPPPS_DTIconnected()");

/*
 *-------------------------------------------------------------------
 * inform DTI Manager
 *-------------------------------------------------------------------
 */  
  switch ( dti_direction )
  {
    case PPP_DTI_CONN_PEER:
      link_id = pdp_context[work_cids[0] - 1].link_id_uart;
      break;
    case PPP_DTI_CONN_PROT:
      link_id = cmhSM_get_link_id_SNDCP_peer( work_cids[0], SNDCP_PEER_NORMAL );
      break;
    default:
      return;
  }

    dti_cntrl_entity_connected( link_id, DTI_ENTITY_PPPS, DTI_OK );
}


#endif  /* GPRS */
/*==== EOF ========================================================*/
