/* 
+----------------------------------------------------------------------------- 
|  Project :  GSM-PS (6147)
|  Modul   :  CMH_EXTS
+----------------------------------------------------------------------------- 
|  Copyright 2002 Texas Instruments Berlin, AG 
|                 All rights reserved. 
| 
|                 This file is confidential and a trade secret of Texas 
|                 Instruments Berlin, AG 
|                 The receipt of or possession of this file does not convey 
|                 any rights to reproduce or disclose its contents or to 
|                 manufacture, use, or sell anything it may describe, in 
|                 whole, or in part, without the specific written consent of 
|                 Texas Instruments Berlin, AG. 
+----------------------------------------------------------------------------- 
|  Purpose :  This module provides the set functions related to the 
|             protocol stack adapter for AT command extensions.
+----------------------------------------------------------------------------- 
*/ 

#ifndef CMH_EXTS_C
#define CMH_EXTS_C
#endif

#include "aci_all.h"
/*==== INCLUDES ===================================================*/

/*==== CONSTANTS ==================================================*/

typedef enum              /* ACI functional return codes */
{
  AT_FAIL = -1,           /* execution of command failed */
  AT_CMPL                 /* execution of command completed */
} T_ACI_RETURN;

EXTERN T_ACI_RETURN rCI_URC ( CHAR * result );

/*==== EXPORT =====================================================*/

/*==== VARIABLES ==================================================*/

/*==== FUNCTIONS ==================================================*/

/*
+--------------------------------------------------------------------+
| PROJECT : GSM-PS (6147)         MODULE  : CMH_EXTS                 |
| STATE   : code                  ROUTINE : sAT_EXT                  |
+--------------------------------------------------------------------+

  PURPOSE : This function is called by the interpreter part of the
            ACI in case of the detection of an unknown command.

            <command> : remaining unparsed command string.
            <len>     : length of command string. This value must be
                        incremented by the amount of parsed characters 
                        by this function.
            <output>  : this parameter can be used to display some
                        strings at the AT command interface.
                        The first char of one string must contain
                        the length of the following string. The
                        special length 0xff must be used to define
                        the end of the string list.

*/

GLOBAL T_ACI_RETURN sAT_EXT ( 
                              CHAR   *command,
									            USHORT *len,
                              CHAR   *output
                            )
{
  /*
   * example how to send an unsolicited result code via the AT interface
   */
  rCI_URC ("<unsolicited result code>");  

  /*
   * example how to process the command AT%H
   */
  if (*command++ == '%' && *command == 'H')
  {
    *len -= 2;

    /*
     * here you can perform some actions with drivers etc.
     */

    /* 
     * and create some additional output at the AT interface
     * The strings:
     *"Hello"
     *""
     *"World"
     * will be displayed at the terminal.
     *
     * first string Hello
     */
    output[0] = strlen ("Hello");
    memcpy (&output[1], "Hello", 5);
    /*
     * add a spare line with an empty string
     */
    output [6] = 0;
    /*
     * second string World
     */
    output [7] = strlen ("World");
    memcpy (&output[8], "World", 5);

    /*
     * end of string list
     */
    output [13] = (CHAR) 0xff;
  
    return( AT_CMPL );
  }
  else
    return( AT_FAIL );
}

